/* valaccodecommaexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODECOMMAEXPRESSION_H__
#define __VALACCODECOMMAEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_COMMA_EXPRESSION (vala_ccode_comma_expression_get_type ())
#define VALA_CCODE_COMMA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_COMMA_EXPRESSION, ValaCCodeCommaExpression))
#define VALA_CCODE_COMMA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_COMMA_EXPRESSION, ValaCCodeCommaExpressionClass))
#define VALA_IS_CCODE_COMMA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_COMMA_EXPRESSION))
#define VALA_IS_CCODE_COMMA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_COMMA_EXPRESSION))
#define VALA_CCODE_COMMA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_COMMA_EXPRESSION, ValaCCodeCommaExpressionClass))

typedef struct _ValaCCodeCommaExpression ValaCCodeCommaExpression;
typedef struct _ValaCCodeCommaExpressionClass ValaCCodeCommaExpressionClass;
typedef struct _ValaCCodeCommaExpressionPrivate ValaCCodeCommaExpressionPrivate;

/**
 * Represents a comma separated expression list in the C code.
 */
struct _ValaCCodeCommaExpression {
	ValaCCodeExpression parent;
	ValaCCodeCommaExpressionPrivate * priv;
};
struct _ValaCCodeCommaExpressionClass {
	ValaCCodeExpressionClass parent;
};

void vala_ccode_comma_expression_append_expression (ValaCCodeCommaExpression* self, ValaCCodeExpression* expr);
GType vala_ccode_comma_expression_get_type ();

G_END_DECLS

#endif
