/* tracker-main.c generated by valac 0.40.6, the Vala compiler
 * generated from tracker-main.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-data-manager.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "tracker-store/tracker-config.h"
#include <signal.h>
#include <glib-unix.h>
#include "libtracker-common/tracker-common.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-sparql/tracker-sparql.h"
#include <locale.h>
#include "libtracker-data/tracker-db-config.h"
#include "libtracker-common/tracker-domain-ontology.h"
#include "libtracker-data/tracker-db-manager.h"
#include "tracker-store/tracker-events.h"
#include "tracker-store/tracker-writeback.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_MAIN (tracker_main_get_type ())
#define TRACKER_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_MAIN, TrackerMain))
#define TRACKER_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_MAIN, TrackerMainClass))
#define TRACKER_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_MAIN))
#define TRACKER_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_MAIN))
#define TRACKER_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_MAIN, TrackerMainClass))

typedef struct _TrackerMain TrackerMain;
typedef struct _TrackerMainClass TrackerMainClass;
typedef struct _TrackerMainPrivate TrackerMainPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _TrackerParamSpecMain TrackerParamSpecMain;

struct _TrackerMain {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerMainPrivate * priv;
};

struct _TrackerMainClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerMain *self);
};

struct _TrackerParamSpecMain {
	GParamSpec parent_instance;
};


static gpointer tracker_main_parent_class = NULL;
static GMainLoop* tracker_main_main_loop;
static GMainLoop* tracker_main_main_loop = NULL;
static gchar* tracker_main_log_filename;
static gchar* tracker_main_log_filename = NULL;
static gboolean tracker_main_shutdown;
static gboolean tracker_main_shutdown = FALSE;
static TrackerDataManager* tracker_main_data_manager;
static TrackerDataManager* tracker_main_data_manager = NULL;
static gboolean tracker_main_version;
static gboolean tracker_main_version = FALSE;
static gint tracker_main_verbosity;
static gint tracker_main_verbosity = 0;
static gboolean tracker_main_force_reindex;
static gboolean tracker_main_force_reindex = FALSE;
static gboolean tracker_main_readonly_mode;
static gboolean tracker_main_readonly_mode = FALSE;
static gchar* tracker_main_domain_ontology;
static gchar* tracker_main_domain_ontology = NULL;
static GFile* tracker_main_cache_location;
static GFile* tracker_main_cache_location = NULL;
static GFile* tracker_main_data_location;
static GFile* tracker_main_data_location = NULL;
static GFile* tracker_main_ontology_location;
static GFile* tracker_main_ontology_location = NULL;
static gchar* tracker_main_domain;
static gchar* tracker_main_domain = NULL;
static gboolean tracker_main_in_loop;
static gboolean tracker_main_in_loop = FALSE;

gpointer tracker_main_ref (gpointer instance);
void tracker_main_unref (gpointer instance);
GParamSpec* tracker_param_spec_main (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void tracker_value_set_main (GValue* value,
                             gpointer v_object);
void tracker_value_take_main (GValue* value,
                              gpointer v_object);
gpointer tracker_value_get_main (const GValue* value);
GType tracker_main_get_type (void) G_GNUC_CONST;
#define TRACKER_MAIN_LICENSE "This program is free software and comes without any warranty.\n" \
"It is licensed under version 2 or later of the General Public\n" \
"License which can be viewed at:\n" \
"  http://www.gnu.org/licenses/gpl.txt\n"
#define TRACKER_MAIN_SELECT_CACHE_SIZE 100
#define TRACKER_MAIN_UPDATE_CACHE_SIZE 100
static void tracker_main_sanity_check_option_values (TrackerConfig* config);
static void tracker_main_do_shutdown (void);
static gboolean tracker_main_shutdown_timeout_cb (void);
static gboolean tracker_main_signal_handler (gint signo);
static void tracker_main_initialize_signal_handler (void);
static gboolean __lambda4_ (void);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean __lambda5_ (void);
static gboolean ___lambda5__gsource_func (gpointer self);
static void tracker_main_initialize_priority (void);
static gchar** tracker_main_get_writeback_predicates (void);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void tracker_main_config_verbosity_changed_cb (GObject* object,
                                               GParamSpec* spec);
TrackerDataManager* tracker_main_get_data_manager (void);
static gint tracker_main_main (gchar** args,
                        int args_length1);
void tzset (void);
gboolean tracker_dbus_init (TrackerConfig* config_p);
static void _tracker_main_config_verbosity_changed_cb_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
GType tracker_status_get_type (void) G_GNUC_CONST;
guint tracker_status_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
TrackerStatus* tracker_dbus_register_notifier (void);
void tracker_store_init (void);
gboolean tracker_dbus_register_objects (void);
gboolean tracker_dbus_register_names (const gchar* domain);
gboolean tracker_dbus_register_prepare_class_signal (void);
static gchar** _tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func (int* result_length1);
void tracker_store_resume (void);
void tracker_dbus_watch_domain (const gchar* domain,
                                GMainLoop* main_loop);
void tracker_store_shutdown (void);
static gboolean _tracker_main_shutdown_timeout_cb_gsource_func (gpointer self);
void tracker_dbus_shutdown (void);
TrackerMain* tracker_main_new (void);
TrackerMain* tracker_main_construct (GType object_type);
static void tracker_main_finalize (TrackerMain * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry TRACKER_MAIN_entries[6] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &tracker_main_version, N_ ("Displays version information"), NULL}, {"verbosity", 'v', 0, G_OPTION_ARG_INT, &tracker_main_verbosity, N_ ("Logging, 0 = errors only, 1 = minimal, 2 = detailed and 3 = debug (def" \
"ault = 0)"), NULL}, {"force-reindex", 'r', 0, G_OPTION_ARG_NONE, &tracker_main_force_reindex, N_ ("Force a re-index of all content"), NULL}, {"readonly-mode", 'n', 0, G_OPTION_ARG_NONE, &tracker_main_readonly_mode, N_ ("Only allow read based actions on the database"), NULL}, {"domain-ontology", 'd', 0, G_OPTION_ARG_STRING, &tracker_main_domain_ontology, N_ ("Load a specified domain ontology"), NULL}, {NULL}};

static void
tracker_main_sanity_check_option_values (TrackerConfig* config)
{
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp8_;
	GFile* _tmp10_;
	GFile* _tmp14_;
	GFile* _tmp18_;
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (config != NULL);
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("General options:");
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = tracker_config_get_verbosity (config);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp1_ = _tmp0_;
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("  Verbosity  ............................  %d", _tmp1_);
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Store options:");
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp3_ = tracker_main_readonly_mode;
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp3_) {
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp2_ = "yes";
#line 225 "tracker-main.c"
	} else {
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp2_ = "no";
#line 229 "tracker-main.c"
	}
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("  Readonly mode  ........................  %s", _tmp2_);
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp4_ = tracker_config_get_graphupdated_delay (config);
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp5_ = _tmp4_;
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("  GraphUpdated Delay ....................  %d", _tmp5_);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp6_ = tracker_main_domain_ontology;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp6_ != NULL) {
#line 243 "tracker-main.c"
		const gchar* _tmp7_;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp7_ = tracker_main_domain_ontology;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_message ("  Domain ontology........................  %s", _tmp7_);
#line 249 "tracker-main.c"
	}
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp8_ = tracker_main_domain;
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp8_ != NULL) {
#line 255 "tracker-main.c"
		const gchar* _tmp9_;
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp9_ = tracker_main_domain;
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_message ("  Domain.................................  %s", _tmp9_);
#line 261 "tracker-main.c"
	}
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp10_ = tracker_main_cache_location;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp10_ != NULL) {
#line 267 "tracker-main.c"
		GFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp11_ = tracker_main_cache_location;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp12_ = g_file_get_uri (_tmp11_);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp13_ = _tmp12_;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_message ("  Cache location.........................  %s", _tmp13_);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (_tmp13_);
#line 281 "tracker-main.c"
	}
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp14_ = tracker_main_data_location;
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp14_ != NULL) {
#line 287 "tracker-main.c"
		GFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp15_ = tracker_main_data_location;
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp16_ = g_file_get_uri (_tmp15_);
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp17_ = _tmp16_;
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_message ("  Data location..........................  %s", _tmp17_);
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (_tmp17_);
#line 301 "tracker-main.c"
	}
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp18_ = tracker_main_ontology_location;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp18_ != NULL) {
#line 307 "tracker-main.c"
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp19_ = tracker_main_ontology_location;
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp20_ = g_file_get_uri (_tmp19_);
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp21_ = _tmp20_;
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_message ("  Ontology location......................  %s", _tmp21_);
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (_tmp21_);
#line 321 "tracker-main.c"
	}
}


static void
tracker_main_do_shutdown (void)
{
	GMainLoop* _tmp0_;
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = tracker_main_main_loop;
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp0_ != NULL) {
#line 334 "tracker-main.c"
		GMainLoop* _tmp1_;
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp1_ = tracker_main_main_loop;
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_main_loop_quit (_tmp1_);
#line 340 "tracker-main.c"
	}
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_shutdown = TRUE;
#line 344 "tracker-main.c"
}


static gboolean
tracker_main_shutdown_timeout_cb (void)
{
	gboolean result = FALSE;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_critical ("Could not exit in a timely fashion - terminating...");
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	exit (1);
#line 97 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 358 "tracker-main.c"
}


static gboolean
tracker_main_signal_handler (gint signo)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = tracker_main_in_loop;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp0_) {
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		exit (1);
#line 373 "tracker-main.c"
	}
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	switch (signo) {
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		case SIGTERM:
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		case SIGINT:
#line 381 "tracker-main.c"
		{
			const gchar* _tmp1_;
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			tracker_main_in_loop = TRUE;
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			tracker_main_do_shutdown ();
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp1_ = g_strsignal (signo);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			if (_tmp1_ != NULL) {
#line 392 "tracker-main.c"
				const gchar* _tmp2_;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
				g_print ("\n");
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
				_tmp2_ = g_strsignal (signo);
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
				g_print ("Received signal:%d->'%s'", signo, _tmp2_);
#line 400 "tracker-main.c"
			}
#line 120 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			break;
#line 404 "tracker-main.c"
		}
		default:
		{
			const gchar* _tmp3_;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp3_ = g_strsignal (signo);
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			if (_tmp3_ != NULL) {
#line 413 "tracker-main.c"
				const gchar* _tmp4_;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
				g_print ("\n");
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
				_tmp4_ = g_strsignal (signo);
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
				g_print ("Received signal:%d->'%s'", signo, _tmp4_);
#line 421 "tracker-main.c"
			}
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			break;
#line 425 "tracker-main.c"
		}
	}
#line 129 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	result = TRUE;
#line 129 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 432 "tracker-main.c"
}


static gboolean
__lambda4_ (void)
{
	gboolean result = FALSE;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	result = tracker_main_signal_handler (SIGTERM);
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 444 "tracker-main.c"
}


static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ();
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 455 "tracker-main.c"
}


static gboolean
__lambda5_ (void)
{
	gboolean result = FALSE;
#line 134 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	result = tracker_main_signal_handler (SIGINT);
#line 134 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 467 "tracker-main.c"
}


static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ();
#line 134 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 478 "tracker-main.c"
}


static void
tracker_main_initialize_signal_handler (void)
{
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGTERM, ___lambda4__gsource_func, NULL, NULL);
#line 134 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGINT, ___lambda5__gsource_func, NULL, NULL);
#line 489 "tracker-main.c"
}


static void
tracker_main_initialize_priority (void)
{
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_ioprio_init ();
#line 498 "tracker-main.c"
}


static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if ((*length) == (*size)) {
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 514 "tracker-main.c"
	}
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	(*array)[(*length)++] = value;
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	(*array)[*length] = NULL;
#line 520 "tracker-main.c"
}


static gchar**
tracker_main_get_writeback_predicates (void)
{
	gchar** result = NULL;
	gchar** predicates_to_signal = NULL;
	gint predicates_to_signal_length1;
	gint _predicates_to_signal_size_;
	GError * _inner_error_ = NULL;
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	predicates_to_signal = NULL;
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	predicates_to_signal_length1 = 0;
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_predicates_to_signal_size_ = predicates_to_signal_length1;
#line 538 "tracker-main.c"
	{
		TrackerDBCursor* cursor = NULL;
		TrackerDataManager* _tmp0_;
		TrackerDBCursor* _tmp1_;
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp0_ = tracker_main_data_manager;
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp1_ = tracker_data_query_sparql_cursor (_tmp0_, "SELECT ?predicate WHERE { ?predicate tracker:writeback true }", &_inner_error_);
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		cursor = _tmp1_;
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 551 "tracker-main.c"
			goto __catch5_g_error;
		}
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		while (TRUE) {
#line 556 "tracker-main.c"
			gboolean _tmp2_ = FALSE;
			TrackerDBCursor* _tmp3_;
			gchar** _tmp4_;
			gint _tmp4__length1;
			TrackerDBCursor* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp3_ = cursor;
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp2_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp3_, NULL, &_inner_error_);
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
				_g_object_unref0 (cursor);
#line 572 "tracker-main.c"
				goto __catch5_g_error;
			}
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			if (!_tmp2_) {
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
				break;
#line 579 "tracker-main.c"
			}
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp4_ = predicates_to_signal;
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp4__length1 = predicates_to_signal_length1;
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp5_ = cursor;
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp6_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp5_, 0, NULL);
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_vala_array_add1 (&predicates_to_signal, &predicates_to_signal_length1, &_predicates_to_signal_size_, _tmp7_);
#line 593 "tracker-main.c"
		}
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (cursor);
#line 597 "tracker-main.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		e = _inner_error_;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_inner_error_ = NULL;
#line 158 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp8_ = e;
#line 158 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp9_ = _tmp8_->message;
#line 158 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("Unable to retrieve tracker:writeback properties: %s", _tmp9_);
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_error_free0 (e);
#line 617 "tracker-main.c"
	}
	__finally5:
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		predicates_to_signal = (_vala_array_free (predicates_to_signal, predicates_to_signal_length1, (GDestroyNotify) g_free), NULL);
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_clear_error (&_inner_error_);
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return NULL;
#line 630 "tracker-main.c"
	}
#line 161 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	result = predicates_to_signal;
#line 161 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 636 "tracker-main.c"
}


static void
tracker_main_config_verbosity_changed_cb (GObject* object,
                                          GParamSpec* spec)
{
	gint verbosity = 0;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (object != NULL);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = tracker_config_get_verbosity (G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_CONFIG, TrackerConfig));
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp1_ = _tmp0_;
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	verbosity = _tmp1_;
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp3_ = verbosity;
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp3_ > 0) {
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp2_ = "enabling";
#line 665 "tracker-main.c"
	} else {
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp2_ = "disabling";
#line 669 "tracker-main.c"
	}
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp4_ = verbosity;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Log verbosity is set to %d, %s D-Bus client lookup", _tmp4_, _tmp2_);
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp5_ = verbosity;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_dbus_enable_client_lookup (_tmp5_ > 0);
#line 679 "tracker-main.c"
}


TrackerDataManager*
tracker_main_get_data_manager (void)
{
	TrackerDataManager* result = NULL;
	TrackerDataManager* _tmp0_;
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = tracker_main_data_manager;
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	result = _tmp0_;
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 694 "tracker-main.c"
}


static void
_tracker_main_config_verbosity_changed_cb_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_config_verbosity_changed_cb (_sender, pspec);
#line 705 "tracker-main.c"
}


static gchar**
_tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func (int* result_length1)
{
	gchar** result;
	result = tracker_main_get_writeback_predicates ();
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 716 "tracker-main.c"
}


static gboolean
_tracker_main_shutdown_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_main_shutdown_timeout_cb ();
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 727 "tracker-main.c"
}


static gint
tracker_main_main (gchar** args,
                   int args_length1)
{
	gint result = 0;
	gboolean _tmp6_;
	TrackerConfig* config = NULL;
	TrackerConfig* _tmp7_;
	TrackerDBConfig* db_config = NULL;
	TrackerDBConfig* _tmp8_;
	gint _tmp9_;
	TrackerConfig* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	TrackerDomainOntology* domain_ontology_config = NULL;
	TrackerDomainOntology* _tmp26_;
	GFile* _tmp27_;
	TrackerDomainOntology* _tmp28_;
	GFile* _tmp29_;
	TrackerDomainOntology* _tmp30_;
	GFile* _tmp31_;
	TrackerDomainOntology* _tmp32_;
	gchar* _tmp33_;
	TrackerConfig* _tmp34_;
	TrackerConfig* _tmp35_;
	TrackerConfig* _tmp36_;
	gulong config_verbosity_id = 0UL;
	TrackerConfig* _tmp37_;
	gulong _tmp38_;
	TrackerDBManagerFlags flags = 0;
	gboolean _tmp39_;
	TrackerStatus* notifier = NULL;
	TrackerStatus* _tmp41_;
	const gchar* _tmp42_;
	gint chunk_size_mb = 0;
	TrackerDBConfig* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	gsize chunk_size = 0UL;
	gint _tmp46_;
	gchar* rotate_to = NULL;
	TrackerDBConfig* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	gboolean do_rotating = FALSE;
	gint _tmp51_;
	gboolean _tmp52_;
	gsize _tmp53_;
	const gchar* _tmp54_;
	gint select_cache_size = 0;
	gint update_cache_size = 0;
	gchar* cache_size_s = NULL;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gboolean _tmp57_ = FALSE;
	const gchar* _tmp58_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	gboolean _tmp63_ = FALSE;
	const gchar* _tmp64_;
	gboolean _tmp78_;
	gboolean _tmp81_;
	TrackerDataManager* _tmp87_;
	TrackerConfig* _tmp88_;
	gulong _tmp89_;
	gint _tmp90_;
	gsize _tmp91_;
	GError * _inner_error_ = NULL;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	setlocale (LC_ALL, "");
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 183 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	textdomain (GETTEXT_PACKAGE);
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tzset ();
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_verbosity = -1;
#line 814 "tracker-main.c"
	{
		GOptionContext* context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp0_ = g_option_context_new (_ ("— start the tracker daemon"));
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		context = _tmp0_;
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp1_ = context;
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_option_context_add_main_entries (_tmp1_, TRACKER_MAIN_entries, NULL);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp2_ = context;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_g_option_context_free0 (context);
#line 836 "tracker-main.c"
			goto __catch6_g_error;
		}
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_option_context_free0 (context);
#line 841 "tracker-main.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		e = _inner_error_;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_inner_error_ = NULL;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = e;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp4_ = _tmp3_->message;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_printerr ("Invalid arguments, %s\n", _tmp4_);
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_error_free0 (e);
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 865 "tracker-main.c"
	}
	__finally6:
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 870 "tracker-main.c"
		gint _tmp5_ = 0;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_clear_error (&_inner_error_);
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return _tmp5_;
#line 878 "tracker-main.c"
	}
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp6_ = tracker_main_version;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp6_) {
#line 204 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_print ("%s", "\nTracker " PACKAGE_VERSION "\n\n" TRACKER_MAIN_LICENSE "\n");
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 0;
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 890 "tracker-main.c"
	}
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_initialize_priority ();
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp7_ = tracker_config_new ();
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	config = _tmp7_;
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp8_ = tracker_db_config_new ();
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	db_config = _tmp8_;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp9_ = tracker_main_verbosity;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp9_ > -1) {
#line 906 "tracker-main.c"
		TrackerConfig* _tmp10_;
		gint _tmp11_;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp10_ = config;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp11_ = tracker_main_verbosity;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_config_set_verbosity (_tmp10_, _tmp11_);
#line 915 "tracker-main.c"
	}
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp12_ = config;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp13_ = tracker_config_get_verbosity (_tmp12_);
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp14_ = _tmp13_;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_log_init (_tmp14_, &_tmp15_);
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (tracker_main_log_filename);
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_log_filename = _tmp15_;
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp16_ = tracker_main_log_filename;
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp16_ != NULL) {
#line 933 "tracker-main.c"
		const gchar* _tmp17_;
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp17_ = tracker_main_log_filename;
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_message ("Using log file:'%s'", _tmp17_);
#line 939 "tracker-main.c"
	}
	{
		TrackerDomainOntology* _tmp18_ = NULL;
		const gchar* _tmp19_;
		TrackerDomainOntology* _tmp20_;
		TrackerDomainOntology* _tmp21_;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp19_ = tracker_main_domain_ontology;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp20_ = tracker_domain_ontology_new (_tmp19_, NULL, &_inner_error_);
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp18_ = _tmp20_;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 954 "tracker-main.c"
			goto __catch7_g_error;
		}
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp21_ = _tmp18_;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp18_ = NULL;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		domain_ontology_config = _tmp21_;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (_tmp18_);
#line 967 "tracker-main.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		e = _inner_error_;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_inner_error_ = NULL;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp22_ = tracker_main_domain_ontology;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp23_ = e;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp24_ = _tmp23_->message;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("Could not load domain ontology definition '%s': %s", _tmp22_, _tmp24_);
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = -1;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_error_free0 (e);
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 1000 "tracker-main.c"
	}
	__finally7:
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1005 "tracker-main.c"
		gint _tmp25_ = 0;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_clear_error (&_inner_error_);
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return _tmp25_;
#line 1019 "tracker-main.c"
	}
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp26_ = domain_ontology_config;
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp27_ = tracker_domain_ontology_get_cache (_tmp26_);
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (tracker_main_cache_location);
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_cache_location = _tmp27_;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp28_ = domain_ontology_config;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp29_ = tracker_domain_ontology_get_journal (_tmp28_);
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (tracker_main_data_location);
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_data_location = _tmp29_;
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp30_ = domain_ontology_config;
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp31_ = tracker_domain_ontology_get_ontology (_tmp30_);
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (tracker_main_ontology_location);
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_ontology_location = _tmp31_;
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp32_ = domain_ontology_config;
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp33_ = tracker_domain_ontology_get_domain (_tmp32_, NULL);
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (tracker_main_domain);
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_domain = _tmp33_;
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp34_ = config;
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_sanity_check_option_values (_tmp34_);
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp35_ = config;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!tracker_dbus_init (_tmp35_)) {
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 1071 "tracker-main.c"
	}
#line 247 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp36_ = config;
#line 247 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_config_verbosity_changed_cb ((GObject*) _tmp36_, NULL);
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp37_ = config;
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp38_ = g_signal_connect ((GObject*) _tmp37_, "notify::verbosity", (GCallback) _tracker_main_config_verbosity_changed_cb_g_object_notify, NULL);
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	config_verbosity_id = _tmp38_;
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	flags = TRACKER_DB_MANAGER_REMOVE_CACHE;
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp39_ = tracker_main_force_reindex;
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp39_) {
#line 1089 "tracker-main.c"
		TrackerDBManagerFlags _tmp40_;
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp40_ = flags;
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		flags = _tmp40_ | TRACKER_DB_MANAGER_FORCE_REINDEX;
#line 1095 "tracker-main.c"
	}
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp41_ = tracker_dbus_register_notifier ();
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	notifier = _tmp41_;
#line 261 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_store_init ();
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!tracker_dbus_register_objects ()) {
#line 265 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 265 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 265 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 265 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 265 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 265 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 1117 "tracker-main.c"
	}
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp42_ = tracker_main_domain;
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!tracker_dbus_register_names (_tmp42_)) {
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 1135 "tracker-main.c"
	}
#line 272 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp43_ = db_config;
#line 272 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp44_ = tracker_db_config_get_journal_chunk_size (_tmp43_);
#line 272 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp45_ = _tmp44_;
#line 272 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	chunk_size_mb = _tmp45_;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp46_ = chunk_size_mb;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	chunk_size = (gsize) ((((gsize) _tmp46_) * ((gsize) 1024)) * ((gsize) 1024));
#line 274 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp47_ = db_config;
#line 274 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp48_ = tracker_db_config_get_journal_rotate_destination (_tmp47_);
#line 274 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp49_ = _tmp48_;
#line 274 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	rotate_to = _tmp49_;
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp50_ = rotate_to;
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (g_strcmp0 (_tmp50_, "") == 0) {
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (rotate_to);
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		rotate_to = NULL;
#line 1165 "tracker-main.c"
	}
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp51_ = chunk_size_mb;
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	do_rotating = _tmp51_ != -1;
#line 282 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp52_ = do_rotating;
#line 282 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp53_ = chunk_size;
#line 282 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp54_ = rotate_to;
#line 282 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_db_journal_set_rotating (_tmp52_, _tmp53_, _tmp54_);
#line 287 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp55_ = g_getenv ("TRACKER_STORE_SELECT_CACHE_SIZE");
#line 287 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp56_ = g_strdup (_tmp55_);
#line 287 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (cache_size_s);
#line 287 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	cache_size_s = _tmp56_;
#line 288 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp58_ = cache_size_s;
#line 288 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp58_ != NULL) {
#line 1191 "tracker-main.c"
		const gchar* _tmp59_;
#line 288 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp59_ = cache_size_s;
#line 288 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp57_ = g_strcmp0 (_tmp59_, "") != 0;
#line 1197 "tracker-main.c"
	} else {
#line 288 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp57_ = FALSE;
#line 1201 "tracker-main.c"
	}
#line 288 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp57_) {
#line 1205 "tracker-main.c"
		const gchar* _tmp60_;
#line 289 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp60_ = cache_size_s;
#line 289 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		select_cache_size = atoi (_tmp60_);
#line 1211 "tracker-main.c"
	} else {
#line 291 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		select_cache_size = TRACKER_MAIN_SELECT_CACHE_SIZE;
#line 1215 "tracker-main.c"
	}
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp61_ = g_getenv ("TRACKER_STORE_UPDATE_CACHE_SIZE");
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp62_ = g_strdup (_tmp61_);
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (cache_size_s);
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	cache_size_s = _tmp62_;
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp64_ = cache_size_s;
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp64_ != NULL) {
#line 1229 "tracker-main.c"
		const gchar* _tmp65_;
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp65_ = cache_size_s;
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp63_ = g_strcmp0 (_tmp65_, "") != 0;
#line 1235 "tracker-main.c"
	} else {
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp63_ = FALSE;
#line 1239 "tracker-main.c"
	}
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp63_) {
#line 1243 "tracker-main.c"
		const gchar* _tmp66_;
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp66_ = cache_size_s;
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		update_cache_size = atoi (_tmp66_);
#line 1249 "tracker-main.c"
	} else {
#line 298 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		update_cache_size = TRACKER_MAIN_UPDATE_CACHE_SIZE;
#line 1253 "tracker-main.c"
	}
	{
		TrackerDBManagerFlags _tmp67_;
		GFile* _tmp68_;
		GFile* _tmp69_;
		GFile* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		TrackerDataManager* _tmp73_;
		TrackerDataManager* _tmp74_;
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp67_ = flags;
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp68_ = tracker_main_cache_location;
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp69_ = tracker_main_data_location;
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp70_ = tracker_main_ontology_location;
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp71_ = select_cache_size;
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp72_ = update_cache_size;
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp73_ = tracker_data_manager_new (_tmp67_, _tmp68_, _tmp69_, _tmp70_, TRUE, FALSE, (guint) _tmp71_, (guint) _tmp72_);
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (tracker_main_data_manager);
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_data_manager = _tmp73_;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp74_ = tracker_main_data_manager;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_initable_init ((GInitable*) _tmp74_, NULL, &_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1288 "tracker-main.c"
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp75_;
		const gchar* _tmp76_;
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		e = _inner_error_;
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_inner_error_ = NULL;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp75_ = e;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp76_ = _tmp75_->message;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("Cannot initialize database: %s", _tmp76_);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_error_free0 (e);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (cache_size_s);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (rotate_to);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 1326 "tracker-main.c"
	}
	__finally8:
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1331 "tracker-main.c"
		gint _tmp77_ = 0;
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (cache_size_s);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (rotate_to);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_clear_error (&_inner_error_);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return _tmp77_;
#line 1351 "tracker-main.c"
	}
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (db_config);
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	db_config = NULL;
#line 317 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (notifier);
#line 317 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	notifier = NULL;
#line 319 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp78_ = tracker_main_shutdown;
#line 319 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp78_) {
#line 1365 "tracker-main.c"
		TrackerDataManager* _tmp79_;
		TrackerDataManager* _tmp80_;
#line 320 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_dbus_register_prepare_class_signal ();
#line 322 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp79_ = tracker_main_data_manager;
#line 322 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_events_init (_tmp79_);
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp80_ = tracker_main_data_manager;
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_writeback_init (_tmp80_, _tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func);
#line 324 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_store_resume ();
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_message ("Waiting for D-Bus requests...");
#line 1382 "tracker-main.c"
	}
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp81_ = tracker_main_shutdown;
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp81_) {
#line 1388 "tracker-main.c"
		GMainLoop* _tmp82_;
		const gchar* _tmp83_;
		GMainLoop* _tmp86_;
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp82_ = g_main_loop_new (NULL, FALSE);
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_main_loop_unref0 (tracker_main_main_loop);
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_main_loop = _tmp82_;
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp83_ = tracker_main_domain;
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		if (_tmp83_ != NULL) {
#line 1402 "tracker-main.c"
			const gchar* _tmp84_;
			GMainLoop* _tmp85_;
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp84_ = tracker_main_domain_ontology;
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp85_ = tracker_main_main_loop;
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			tracker_dbus_watch_domain (_tmp84_, _tmp85_);
#line 1411 "tracker-main.c"
		}
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_initialize_signal_handler ();
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp86_ = tracker_main_main_loop;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_main_loop_run (_tmp86_);
#line 1419 "tracker-main.c"
	}
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Shutdown started");
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_store_shutdown ();
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_timeout_add_full (G_PRIORITY_LOW, (guint) 5000, _tracker_main_shutdown_timeout_cb_gsource_func, NULL, NULL);
#line 352 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Cleaning up");
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_writeback_shutdown ();
#line 356 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_events_shutdown ();
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp87_ = tracker_main_data_manager;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_data_manager_shutdown (_tmp87_);
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (tracker_main_data_manager);
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_data_manager = NULL;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_dbus_shutdown ();
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_log_shutdown ();
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp88_ = config;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp89_ = config_verbosity_id;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_signal_handler_disconnect ((GObject*) _tmp88_, _tmp89_);
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (config);
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	config = NULL;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp90_ = chunk_size_mb;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp91_ = chunk_size;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_db_journal_set_rotating (_tmp90_ != -1, _tmp91_, NULL);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_print ("\nOK\n\n");
#line 371 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (tracker_main_log_filename);
#line 371 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_log_filename = NULL;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_main_loop_unref0 (tracker_main_main_loop);
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_main_loop = NULL;
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	result = 0;
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (cache_size_s);
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (rotate_to);
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (notifier);
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (domain_ontology_config);
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (db_config);
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (config);
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 1487 "tracker-main.c"
}


int
main (int argc,
      char ** argv)
{
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return tracker_main_main (argv, argc);
#line 1497 "tracker-main.c"
}


TrackerMain*
tracker_main_construct (GType object_type)
{
	TrackerMain* self = NULL;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	self = (TrackerMain*) g_type_create_instance (object_type);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return self;
#line 1509 "tracker-main.c"
}


TrackerMain*
tracker_main_new (void)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return tracker_main_construct (TRACKER_TYPE_MAIN);
#line 1518 "tracker-main.c"
}


static void
tracker_value_main_init (GValue* value)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	value->data[0].v_pointer = NULL;
#line 1527 "tracker-main.c"
}


static void
tracker_value_main_free_value (GValue* value)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (value->data[0].v_pointer) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_unref (value->data[0].v_pointer);
#line 1538 "tracker-main.c"
	}
}


static void
tracker_value_main_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		dest_value->data[0].v_pointer = tracker_main_ref (src_value->data[0].v_pointer);
#line 1551 "tracker-main.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1555 "tracker-main.c"
	}
}


static gpointer
tracker_value_main_peek_pointer (const GValue* value)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return value->data[0].v_pointer;
#line 1565 "tracker-main.c"
}


static gchar*
tracker_value_main_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (collect_values[0].v_pointer) {
#line 1577 "tracker-main.c"
		TrackerMain * object;
		object = collect_values[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1584 "tracker-main.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1588 "tracker-main.c"
		}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = tracker_main_ref (object);
#line 1592 "tracker-main.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1596 "tracker-main.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return NULL;
#line 1600 "tracker-main.c"
}


static gchar*
tracker_value_main_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	TrackerMain ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!object_p) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1616 "tracker-main.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!value->data[0].v_pointer) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		*object_p = NULL;
#line 1622 "tracker-main.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		*object_p = value->data[0].v_pointer;
#line 1626 "tracker-main.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		*object_p = tracker_main_ref (value->data[0].v_pointer);
#line 1630 "tracker-main.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return NULL;
#line 1634 "tracker-main.c"
}


GParamSpec*
tracker_param_spec_main (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	TrackerParamSpecMain* spec;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_MAIN), NULL);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return G_PARAM_SPEC (spec);
#line 1654 "tracker-main.c"
}


gpointer
tracker_value_get_main (const GValue* value)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN), NULL);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return value->data[0].v_pointer;
#line 1665 "tracker-main.c"
}


void
tracker_value_set_main (GValue* value,
                        gpointer v_object)
{
	TrackerMain * old;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (v_object) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_MAIN));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = v_object;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_ref (value->data[0].v_pointer);
#line 1688 "tracker-main.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1692 "tracker-main.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (old) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_unref (old);
#line 1698 "tracker-main.c"
	}
}


void
tracker_value_take_main (GValue* value,
                         gpointer v_object)
{
	TrackerMain * old;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (v_object) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_MAIN));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = v_object;
#line 1720 "tracker-main.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1724 "tracker-main.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (old) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_unref (old);
#line 1730 "tracker-main.c"
	}
}


static void
tracker_main_class_init (TrackerMainClass * klass)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	((TrackerMainClass *) klass)->finalize = tracker_main_finalize;
#line 1742 "tracker-main.c"
}


static void
tracker_main_instance_init (TrackerMain * self)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	self->ref_count = 1;
#line 1751 "tracker-main.c"
}


static void
tracker_main_finalize (TrackerMain * obj)
{
	TrackerMain * self;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_MAIN, TrackerMain);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_signal_handlers_destroy (self);
#line 1763 "tracker-main.c"
}


GType
tracker_main_get_type (void)
{
	static volatile gsize tracker_main_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_main_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_main_init, tracker_value_main_free_value, tracker_value_main_copy_value, tracker_value_main_peek_pointer, "p", tracker_value_main_collect_value, "p", tracker_value_main_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMain), 0, (GInstanceInitFunc) tracker_main_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_main_type_id;
		tracker_main_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerMain", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_main_type_id__volatile, tracker_main_type_id);
	}
	return tracker_main_type_id__volatile;
}


gpointer
tracker_main_ref (gpointer instance)
{
	TrackerMain * self;
	self = instance;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	return instance;
#line 1792 "tracker-main.c"
}


void
tracker_main_unref (gpointer instance)
{
	TrackerMain * self;
	self = instance;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		TRACKER_MAIN_GET_CLASS (self)->finalize (self);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1807 "tracker-main.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



