/* tracker-builder.c generated by valac 0.31.1, the Vala compiler
 * generated from tracker-builder.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * SECTION: tracker-sparql-builder
 * @short_description: Creating insertion/update SPARQL queries.
 * @title: TrackerSparqlBuilder
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * <para>
 * #TrackerSparqlBuilder is an object what will gather a set of
 * subject/predicate/object triples, together with an optional WHERE clause,
 * in order to create a query that may be issued to tracker-store.
 * </para>
 *
 * <para>
 * When using #TrackerSparqlBuilder, note that you may append several predicates
 * for the same subject, and several objects for the same predicate.
 * </para>
 */
/**
 * TrackerSparqlBuilder:
 *
 * The <structname>TrackerSparqlBuilder</structname> object represents an
 * insertion/update SPARQL query.
 */
/**
 * tracker_sparql_builder_get_result:
 * @self: a #TrackerSparqlBuilder
 *
 * Retrieves a string representation of the constructed SPARQL query.
 *
 * Returns: the created SPARQL query. The string is contained in the
 * #TrackerSparqlBuilder object, and should not be freed by the caller.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_builder_get_length:
 * @self: a #TrackerSparqlBuilder
 *
 * Returns the number of objects added to @self.
 *
 * Returns: the number of objects contained.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_builder_get_state:
 * @self: a #TrackerSparqlBuilder
 *
 * Returns the current state of @self
 *
 * Returns: a #TrackerSparqlBuilderState defining the current state of @self
 *
 * Since: 0.10
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>


#define TRACKER_SPARQL_TYPE_BUILDER (tracker_sparql_builder_get_type ())
#define TRACKER_SPARQL_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder))
#define TRACKER_SPARQL_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderClass))
#define TRACKER_SPARQL_IS_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BUILDER))
#define TRACKER_SPARQL_IS_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BUILDER))
#define TRACKER_SPARQL_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderClass))

typedef struct _TrackerSparqlBuilder TrackerSparqlBuilder;
typedef struct _TrackerSparqlBuilderClass TrackerSparqlBuilderClass;
typedef struct _TrackerSparqlBuilderPrivate TrackerSparqlBuilderPrivate;

#define TRACKER_SPARQL_BUILDER_TYPE_STATE (tracker_sparql_builder_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TrackerSparqlBuilder {
	GObject parent_instance;
	TrackerSparqlBuilderPrivate * priv;
};

struct _TrackerSparqlBuilderClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_BUILDER_STATE_UPDATE,
	TRACKER_SPARQL_BUILDER_STATE_INSERT,
	TRACKER_SPARQL_BUILDER_STATE_DELETE,
	TRACKER_SPARQL_BUILDER_STATE_SUBJECT,
	TRACKER_SPARQL_BUILDER_STATE_PREDICATE,
	TRACKER_SPARQL_BUILDER_STATE_OBJECT,
	TRACKER_SPARQL_BUILDER_STATE_BLANK,
	TRACKER_SPARQL_BUILDER_STATE_WHERE,
	TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT,
	TRACKER_SPARQL_BUILDER_STATE_GRAPH
} TrackerSparqlBuilderState;

struct _TrackerSparqlBuilderPrivate {
	gint _length;
	TrackerSparqlBuilderState* states;
	gint states_length1;
	gint _states_size_;
	GString* str;
};


static gpointer tracker_sparql_builder_parent_class = NULL;

GType tracker_sparql_builder_get_type (void) G_GNUC_CONST;
GType tracker_sparql_builder_state_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderPrivate))
enum  {
	TRACKER_SPARQL_BUILDER_DUMMY_PROPERTY,
	TRACKER_SPARQL_BUILDER_RESULT,
	TRACKER_SPARQL_BUILDER_LENGTH,
	TRACKER_SPARQL_BUILDER_STATE
};
TrackerSparqlBuilder* tracker_sparql_builder_new_update (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type);
static void _vala_tracker_sparql_builder_state_array_add (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
TrackerSparqlBuilder* tracker_sparql_builder_new_embedded_insert (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_embedded_insert (GType object_type);
void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self, const gchar* graph);
TrackerSparqlBuilderState tracker_sparql_builder_get_state (TrackerSparqlBuilder* self);
void tracker_sparql_builder_insert_silent_open (TrackerSparqlBuilder* self, const gchar* graph);
void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_delete_open (TrackerSparqlBuilder* self, const gchar* graph);
void tracker_sparql_builder_delete_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_graph_open (TrackerSparqlBuilder* self, const gchar* graph);
void tracker_sparql_builder_graph_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_where_open (TrackerSparqlBuilder* self);
void tracker_sparql_builder_where_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_subject_variable (TrackerSparqlBuilder* self, const gchar* var_name);
void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const gchar* s);
void tracker_sparql_builder_object_variable (TrackerSparqlBuilder* self, const gchar* var_name);
void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const gchar* s);
void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const gchar* iri);
void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const gchar* iri);
void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const gchar* s);
void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const gchar* iri);
gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self);
static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self, gint value);
void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const gchar* literal);
gchar* tracker_sparql_escape_string (const gchar* literal);
void tracker_sparql_builder_object_unvalidated (TrackerSparqlBuilder* self, const gchar* value);
void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal);
void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal);
void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal);
void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, gdouble literal);
void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self);
void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_prepend (TrackerSparqlBuilder* self, const gchar* raw);
void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const gchar* raw);
TrackerSparqlBuilder* tracker_sparql_builder_new (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type);
const gchar* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self);
static void tracker_sparql_builder_finalize (GObject* obj);
static void _vala_tracker_sparql_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * TrackerSparqlBuilderState:
 * @TRACKER_SPARQL_BUILDER_STATE_UPDATE: Builder is generating an UPDATE
 * @TRACKER_SPARQL_BUILDER_STATE_INSERT: Builder is generating an INSERT
 * @TRACKER_SPARQL_BUILDER_STATE_DELETE: Builder is generating a DELETE
 * @TRACKER_SPARQL_BUILDER_STATE_SUBJECT: Builder is generating the subject of the query
 * @TRACKER_SPARQL_BUILDER_STATE_PREDICATE: Builder is generating the predicate of the query
 * @TRACKER_SPARQL_BUILDER_STATE_OBJECT: Builder is generating the object of the query
 * @TRACKER_SPARQL_BUILDER_STATE_BLANK: Builder is generating a blank node subject
 * @TRACKER_SPARQL_BUILDER_STATE_WHERE: Builder is generating the WHERE clause contents
 * @TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT: Builder is generating an embedded INSERT
 * @TRACKER_SPARQL_BUILDER_STATE_GRAPH: Builder is generating the GRAPH clause contents
 *
 * Enumeration with the possible states of the SPARQL Builder
 */
GType tracker_sparql_builder_state_get_type (void) {
	static volatile gsize tracker_sparql_builder_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_builder_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BUILDER_STATE_UPDATE, "TRACKER_SPARQL_BUILDER_STATE_UPDATE", "update"}, {TRACKER_SPARQL_BUILDER_STATE_INSERT, "TRACKER_SPARQL_BUILDER_STATE_INSERT", "insert"}, {TRACKER_SPARQL_BUILDER_STATE_DELETE, "TRACKER_SPARQL_BUILDER_STATE_DELETE", "delete"}, {TRACKER_SPARQL_BUILDER_STATE_SUBJECT, "TRACKER_SPARQL_BUILDER_STATE_SUBJECT", "subject"}, {TRACKER_SPARQL_BUILDER_STATE_PREDICATE, "TRACKER_SPARQL_BUILDER_STATE_PREDICATE", "predicate"}, {TRACKER_SPARQL_BUILDER_STATE_OBJECT, "TRACKER_SPARQL_BUILDER_STATE_OBJECT", "object"}, {TRACKER_SPARQL_BUILDER_STATE_BLANK, "TRACKER_SPARQL_BUILDER_STATE_BLANK", "blank"}, {TRACKER_SPARQL_BUILDER_STATE_WHERE, "TRACKER_SPARQL_BUILDER_STATE_WHERE", "where"}, {TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT, "TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT", "embedded-insert"}, {TRACKER_SPARQL_BUILDER_STATE_GRAPH, "TRACKER_SPARQL_BUILDER_STATE_GRAPH", "graph"}, {0, NULL, NULL}};
		GType tracker_sparql_builder_state_type_id;
		tracker_sparql_builder_state_type_id = g_enum_register_static ("TrackerSparqlBuilderState", values);
		g_once_init_leave (&tracker_sparql_builder_state_type_id__volatile, tracker_sparql_builder_state_type_id);
	}
	return tracker_sparql_builder_state_type_id__volatile;
}


/**
 * tracker_sparql_builder_new_update:
 *
 * Creates an empty #TrackerSparqlBuilder for an update query.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
static void _vala_tracker_sparql_builder_state_array_add (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 236 "tracker-builder.c"
	}
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 240 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
	TrackerSparqlBuilderState* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_UPDATE);
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 258 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_new_update (void) {
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct_update (TRACKER_SPARQL_TYPE_BUILDER);
#line 265 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_new_embedded_insert:
 *
 * Creates a #TrackerSparqlBuilder ready to be embedded in another query. In embedded
 * inserts, the subject is implied (responsibility of the embedder), so only calls to
 * append predicates and objects for the given subject are allowed.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
TrackerSparqlBuilder* tracker_sparql_builder_construct_embedded_insert (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
	TrackerSparqlBuilderState* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	TrackerSparqlBuilderState* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	TrackerSparqlBuilderState* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->states;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1__length1 = self->priv->states_length1;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 310 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_new_embedded_insert (void) {
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct_embedded_insert (TRACKER_SPARQL_TYPE_BUILDER);
#line 317 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_insert_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens an insertion statement.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = graph;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp3_ != NULL) {
#line 354 "tracker-builder.c"
		GString* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = self->priv->str;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = graph;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = g_strdup_printf ("INSERT INTO <%s> {\n", _tmp5_);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = _tmp6_;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp4_, _tmp7_);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp7_);
#line 371 "tracker-builder.c"
	} else {
		GString* _tmp8_ = NULL;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, "INSERT {\n");
#line 378 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_insert_silent_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens a silent insertion statement.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_insert_silent_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = graph;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp3_ != NULL) {
#line 416 "tracker-builder.c"
		GString* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = self->priv->str;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = graph;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = g_strdup_printf ("INSERT SILENT INTO <%s> {\n", _tmp5_);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = _tmp6_;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp4_, _tmp7_);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp7_);
#line 433 "tracker-builder.c"
	} else {
		GString* _tmp8_ = NULL;
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, "INSERT SILENT {\n");
#line 440 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_insert_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes an insertion statement opened with tracker_sparql_builder_insert_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
	TrackerSparqlBuilderState _tmp3_ = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	TrackerSparqlBuilderState _tmp5_ = 0;
	gint _tmp8_ = 0;
	TrackerSparqlBuilderState _tmp9_ = 0;
	TrackerSparqlBuilderState _tmp10_ = 0;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.INSERT || state == State.OBJECT");
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 481 "tracker-builder.c"
		GString* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 492 "tracker-builder.c"
	}
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = tracker_sparql_builder_get_state (self);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = _tmp9_;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp10_ != TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT) {
#line 504 "tracker-builder.c"
		GString* _tmp11_ = NULL;
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp11_ = self->priv->str;
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp11_, "}\n");
#line 510 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_delete_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens a DELETE clause. Data triples may be appended in order to prepare
 * a query to delete them.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_delete_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_DELETE);
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = graph;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp3_ != NULL) {
#line 549 "tracker-builder.c"
		GString* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = self->priv->str;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = graph;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = g_strdup_printf ("DELETE FROM <%s> {\n", _tmp5_);
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = _tmp6_;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp4_, _tmp7_);
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp7_);
#line 566 "tracker-builder.c"
	} else {
		GString* _tmp8_ = NULL;
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, "DELETE {\n");
#line 573 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_delete_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a DELETE clause opened through tracker_sparql_builder_delete_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_delete_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
	TrackerSparqlBuilderState _tmp3_ = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	TrackerSparqlBuilderState _tmp5_ = 0;
	gint _tmp8_ = 0;
	GString* _tmp9_ = NULL;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_DELETE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.DELETE || state == State.OBJECT");
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 613 "tracker-builder.c"
		GString* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 624 "tracker-builder.c"
	}
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, "}\n");
#line 634 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_graph_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name.
 *
 * Opens a GRAPH clause within INSERT, DELETE, or WHERE.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_graph_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
	TrackerSparqlBuilderState _tmp3_ = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	TrackerSparqlBuilderState _tmp5_ = 0;
	TrackerSparqlBuilderState _tmp6_ = 0;
	TrackerSparqlBuilderState _tmp7_ = 0;
	TrackerSparqlBuilderState _tmp8_ = 0;
	TrackerSparqlBuilderState _tmp9_ = 0;
	TrackerSparqlBuilderState* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	GString* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (graph != NULL);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tracker_sparql_builder_get_state (self);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (((((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_DELETE)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_WHERE)) || (_tmp9_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH), "state == State.INSERT || state == State.DELETE || state == State.OBJECT || state == State.WHERE || state == State.GRAPH");
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = self->priv->states;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10__length1 = self->priv->states_length1;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_GRAPH);
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = self->priv->str;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = graph;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append_printf (_tmp11_, "GRAPH <%s> {\n", _tmp12_);
#line 700 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_graph_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a GRAPH clause opened through tracker_sparql_builder_graph_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_graph_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
	TrackerSparqlBuilderState _tmp3_ = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	TrackerSparqlBuilderState _tmp5_ = 0;
	gint _tmp8_ = 0;
	GString* _tmp9_ = NULL;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.GRAPH || state == State.OBJECT");
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 739 "tracker-builder.c"
		GString* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 750 "tracker-builder.c"
	}
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, "}\n");
#line 760 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_where_open:
 * @self: a #TrackerSparqlBuilder
 *
 * Opens a WHERE clause. Data triples may be appended then to narrow the scope
 * to which the update query applies.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_where_open (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GString* _tmp3_ = NULL;
#line 338 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 338 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 338 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 338 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_WHERE);
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = self->priv->str;
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp3_, "WHERE {\n");
#line 797 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_where_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a WHERE clause opened through tracker_sparql_builder_where_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_where_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
	TrackerSparqlBuilderState _tmp3_ = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	TrackerSparqlBuilderState _tmp5_ = 0;
	gint _tmp8_ = 0;
	GString* _tmp9_ = NULL;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_WHERE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.WHERE || state == State.OBJECT");
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 836 "tracker-builder.c"
		GString* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 847 "tracker-builder.c"
	}
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, "}\n");
#line 857 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_subject_variable:
 * @self: a #TrackerSparqlBuilder
 * @var_name: variable name, without leading '?'
 *
 * Appends a subject as a SPARQL variable, such as "?urn".
 *
 * Since: 0.10
 */
void tracker_sparql_builder_subject_variable (TrackerSparqlBuilder* self, const gchar* var_name) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (var_name != NULL);
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = var_name;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("?%s", _tmp0_);
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_subject (self, _tmp2_);
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 888 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_variable:
 * @self: a #TrackerSparqlBuilder
 * @var_name: variable name, without leading '?'
 *
 * Appends an object as a SparQL variable, such as "?urn".
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_variable (TrackerSparqlBuilder* self, const gchar* var_name) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (var_name != NULL);
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = var_name;
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("?%s", _tmp0_);
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 919 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_subject_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends a subject as an IRI, such as "&lt;urn:file:1234-5678&gt;". IRIs
 * univocally identify a resource in tracker-store.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = iri;
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("<%s>", _tmp0_);
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_subject (self, _tmp2_);
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 951 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_subject:
 * @self: a #TrackerSparqlBuilder
 * @s: subject string
 *
 * Appends a subject.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
	TrackerSparqlBuilderState _tmp3_ = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	TrackerSparqlBuilderState _tmp5_ = 0;
	TrackerSparqlBuilderState _tmp6_ = 0;
	TrackerSparqlBuilderState _tmp7_ = 0;
	TrackerSparqlBuilderState _tmp8_ = 0;
	TrackerSparqlBuilderState _tmp9_ = 0;
	TrackerSparqlBuilderState _tmp10_ = 0;
	TrackerSparqlBuilderState _tmp11_ = 0;
	TrackerSparqlBuilderState _tmp12_ = 0;
	TrackerSparqlBuilderState _tmp13_ = 0;
	GString* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	TrackerSparqlBuilderState* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tracker_sparql_builder_get_state (self);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = tracker_sparql_builder_get_state (self);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = _tmp10_;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((((((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT)) || (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_DELETE)) || (_tmp9_ == TRACKER_SPARQL_BUILDER_STATE_WHERE)) || (_tmp11_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH), "state == State.INSERT || state == State.OBJECT || state == State.EMBEDDED_INSERT || state == State.DELETE || state == State.WHERE || state == State.GRAPH");
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = tracker_sparql_builder_get_state (self);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = _tmp12_;
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp13_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1019 "tracker-builder.c"
		GString* _tmp14_ = NULL;
		gint _tmp15_ = 0;
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp14_ = self->priv->str;
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp14_, " .\n");
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp15_ = self->priv->states_length1;
#line 1030 "tracker-builder.c"
	}
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp16_ = self->priv->str;
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp17_ = s;
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp16_, _tmp17_);
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp18_ = self->priv->states;
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp18__length1 = self->priv->states_length1;
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
#line 1044 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_predicate_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends a predicate as an IRI.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = iri;
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("<%s>", _tmp0_);
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_predicate (self, _tmp2_);
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1075 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_predicate:
 * @self: a #TrackerSparqlBuilder
 * @s: predicate string
 *
 * Appends a predicate for the previously appended subject.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
	TrackerSparqlBuilderState _tmp3_ = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	TrackerSparqlBuilderState _tmp5_ = 0;
	TrackerSparqlBuilderState _tmp6_ = 0;
	TrackerSparqlBuilderState _tmp7_ = 0;
	GString* _tmp10_ = NULL;
	GString* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	TrackerSparqlBuilderState* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_SUBJECT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_BLANK), "state == State.SUBJECT || state == State.OBJECT || state == State.BLANK");
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1126 "tracker-builder.c"
		GString* _tmp8_ = NULL;
		gint _tmp9_ = 0;
#line 450 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 450 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, " ;\n\t");
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 2;
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp9_ = self->priv->states_length1;
#line 1137 "tracker-builder.c"
	}
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = self->priv->str;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp10_, " ");
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = self->priv->str;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = s;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp11_, _tmp12_);
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = self->priv->states;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13__length1 = self->priv->states_length1;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_PREDICATE);
#line 1155 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends an object as an IRI.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = iri;
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("<%s>", _tmp0_);
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1186 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object:
 * @self: a #TrackerSparqlBuilder
 * @s: object string
 *
 * Appends a free-form object for the previously appended subject and predicate.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
	TrackerSparqlBuilderState _tmp3_ = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	TrackerSparqlBuilderState _tmp5_ = 0;
	GString* _tmp8_ = NULL;
	GString* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	TrackerSparqlBuilderState* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp12_ = 0;
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.PREDICATE || state == State.OBJECT");
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1232 "tracker-builder.c"
		GString* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 485 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 485 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 1243 "tracker-builder.c"
	}
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, " ");
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = s;
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, _tmp10_);
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = self->priv->states;
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11__length1 = self->priv->states_length1;
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = self->priv->_length;
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp12_ + 1);
#line 1265 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_string:
 * @self: a #TrackerSparqlBuilder
 * @literal: string object
 *
 * Appends an object formatted as an string. @literal will be escaped and surrounded
 * by double quotes.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const gchar* literal) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
	TrackerSparqlBuilderState _tmp3_ = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	TrackerSparqlBuilderState _tmp5_ = 0;
	GString* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	TrackerSparqlBuilderState* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp13_ = 0;
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (literal != NULL);
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.PREDICATE || state == State.OBJECT");
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1313 "tracker-builder.c"
		GString* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 1324 "tracker-builder.c"
	}
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = literal;
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = tracker_sparql_escape_string (_tmp9_);
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = _tmp10_;
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append_printf (_tmp8_, " \"%s\"", _tmp11_);
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp11_);
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = self->priv->states;
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12__length1 = self->priv->states_length1;
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = self->priv->_length;
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp13_ + 1);
#line 1348 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_unvalidated:
 * @self: a #TrackerSparqlBuilder
 * @value: possibly UTF-8 invalid string.
 *
 * Appends a string not validated as UTF-8 as an object.
 *
 * Since: 0.10
 */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1291 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1291 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1291 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1291 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1292 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1292 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1380 "tracker-builder.c"
		glong _tmp4_ = 0L;
#line 1293 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1293 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1293 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 1388 "tracker-builder.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1295 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1295 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1295 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1295 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 1400 "tracker-builder.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1302 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1304 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1304 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1424 "tracker-builder.c"
		glong _tmp2_ = 0L;
#line 1304 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1304 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1430 "tracker-builder.c"
	} else {
#line 1304 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1434 "tracker-builder.c"
	}
#line 1304 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1438 "tracker-builder.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1306 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1306 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1306 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1306 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 1450 "tracker-builder.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1308 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1308 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1308 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 1460 "tracker-builder.c"
	}
#line 1311 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1311 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 1466 "tracker-builder.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1312 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1312 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1312 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1313 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1313 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 1480 "tracker-builder.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1315 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1315 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1315 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 1490 "tracker-builder.c"
	}
#line 1317 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1317 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 1496 "tracker-builder.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1318 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1318 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1318 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 1505 "tracker-builder.c"
	}
#line 1320 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1320 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1320 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1320 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1321 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1321 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1321 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1321 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1321 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 1525 "tracker-builder.c"
}


void tracker_sparql_builder_object_unvalidated (TrackerSparqlBuilder* self, const gchar* value) {
	gchar* end = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp10_ = NULL;
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (value != NULL);
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = value;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = g_utf8_validate (_tmp0_, (gssize) -1, &_tmp1_);
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	end = _tmp1_;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (!_tmp2_) {
#line 1547 "tracker-builder.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = value;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = end;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		if (_tmp3_ != _tmp4_) {
#line 1556 "tracker-builder.c"
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp5_ = value;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp6_ = end;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp7_ = value;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp8_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp6_ - ((gchar*) _tmp7_)));
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp9_ = _tmp8_;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			tracker_sparql_builder_object_string (self, _tmp9_);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_g_free0 (_tmp9_);
#line 1576 "tracker-builder.c"
		} else {
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			tracker_sparql_builder_object_string (self, "(invalid data)");
#line 1580 "tracker-builder.c"
		}
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		return;
#line 1584 "tracker-builder.c"
	}
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = value;
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object_string (self, _tmp10_);
#line 1590 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_boolean:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gboolean
 *
 * Appends a #gboolean value as an object.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = literal;
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp1_) {
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = "true";
#line 1614 "tracker-builder.c"
	} else {
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = "false";
#line 1618 "tracker-builder.c"
	}
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp0_);
#line 1622 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_int64:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gint64
 *
 * Appends a #gint64 value as an object.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal) {
	gint64 _tmp0_ = 0LL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = literal;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1651 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_date:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #time_t
 *
 * Appends a #time_t value as an object. @literal will be converted
 * to a string in the date format used by tracker-store.
 *
 * Since: 0.10
 */
static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2692 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	gmtime_r (&time, &_tmp0_);
#line 2692 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2693 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2693 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return;
#line 1676 "tracker-builder.c"
}


void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal) {
	struct tm tm = {0};
	time_t _tmp0_ = 0;
	struct tm _tmp1_ = {0};
	struct tm _tmp2_ = {0};
	gint _tmp3_ = 0;
	struct tm _tmp4_ = {0};
	gint _tmp5_ = 0;
	struct tm _tmp6_ = {0};
	gint _tmp7_ = 0;
	struct tm _tmp8_ = {0};
	gint _tmp9_ = 0;
	struct tm _tmp10_ = {0};
	gint _tmp11_ = 0;
	struct tm _tmp12_ = {0};
	gint _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
#line 579 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = *literal;
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_time_gm (_tmp0_, &_tmp1_);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tm = _tmp1_;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tm;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_.tm_year;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tm;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_.tm_mon;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tm;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_.tm_mday;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tm;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_.tm_hour;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = tm;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = _tmp10_.tm_min;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = tm;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = _tmp12_.tm_sec;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp14_ = g_strdup_printf ("%04d-%02d-%02dT%02d:%02d:%02dZ", _tmp3_ + 1900, _tmp5_ + 1, _tmp7_, _tmp9_, _tmp11_, _tmp13_);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp15_ = _tmp14_;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object_string (self, _tmp15_);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp15_);
#line 1738 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_double:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gdouble
 *
 * Appends a #gdouble value as an object.
 *
 * Since: 0.10
 */
static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 859 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 859 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 859 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 859 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
#line 859 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp3_ = g_strdup (_tmp2_);
#line 859 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 859 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 859 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 859 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 1777 "tracker-builder.c"
}


void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, gdouble literal) {
	gdouble _tmp0_ = 0.0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 594 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = literal;
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = double_to_string (_tmp0_);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1797 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_blank_open:
 * @self: a #TrackerSparqlBuilder
 *
 * Opens an anonymous blank node. In insertions this can be used to create
 * anonymous nodes for not previously known data without the need of a
 * separate insertion.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
	TrackerSparqlBuilderState _tmp3_ = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	TrackerSparqlBuilderState _tmp5_ = 0;
	GString* _tmp8_ = NULL;
	TrackerSparqlBuilderState* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.PREDICATE || state == State.OBJECT");
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1839 "tracker-builder.c"
		GString* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 1850 "tracker-builder.c"
	}
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, " [");
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->states;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9__length1 = self->priv->states_length1;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_BLANK);
#line 1862 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_blank_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes an anomymous blank node opened with tracker_sparql_builder_object_blank_open()
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	TrackerSparqlBuilderState* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	TrackerSparqlBuilderState* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	TrackerSparqlBuilderState _tmp4_ = 0;
	GString* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	TrackerSparqlBuilderState* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp8_ = 0;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = self->priv->states;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3__length1 = self->priv->states_length1;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = _tmp2_[_tmp3__length1 - 3];
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) && (_tmp4_ == TRACKER_SPARQL_BUILDER_STATE_BLANK), "state == State.OBJECT && states[states.length - 3] == State.BLANK");
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = self->priv->str;
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp5_, "]");
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = self->priv->states_length1 - 3;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = self->priv->states_length1;
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = self->priv->states;
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7__length1 = self->priv->states_length1;
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_tracker_sparql_builder_state_array_add (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->_length;
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp8_ + 1);
#line 1923 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_prepend:
 * @self: a #TrackerSparqlBuilder
 * @raw: raw content to prepend.
 *
 * Prepends raw, unvalidated content to @self.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_prepend (TrackerSparqlBuilder* self, const gchar* raw) {
	GString* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
#line 646 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 646 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (raw != NULL);
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->str;
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = raw;
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = g_strdup_printf ("%s\n", _tmp1_);
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_prepend (_tmp0_, _tmp3_);
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp3_);
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = self->priv->_length;
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp4_ + 1);
#line 1962 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_append:
 * @self: a #TrackerSparqlBuilder
 * @raw: raw content to append.
 *
 * Appends raw, unvalidated content to @self.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const gchar* raw) {
	TrackerSparqlBuilderState _tmp0_ = 0;
	TrackerSparqlBuilderState _tmp1_ = 0;
	GString* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (raw != NULL);
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1991 "tracker-builder.c"
		GString* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp2_ = self->priv->str;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp2_, " .\n");
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = self->priv->states_length1;
#line 2002 "tracker-builder.c"
	}
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = self->priv->str;
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = raw;
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp4_, _tmp5_);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = self->priv->_length;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp6_ + 1);
#line 2014 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 2024 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_new (void) {
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct (TRACKER_SPARQL_TYPE_BUILDER);
#line 2031 "tracker-builder.c"
}


const gchar* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self) {
	const gchar* result;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlBuilderState* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GString* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->states;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1__length1 = self->priv->states_length1;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp1__length1 == 1) {
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = TRUE;
#line 2052 "tracker-builder.c"
	} else {
		gboolean _tmp2_ = FALSE;
		TrackerSparqlBuilderState* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		TrackerSparqlBuilderState _tmp4_ = 0;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = self->priv->states;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3__length1 = self->priv->states_length1;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = _tmp3_[0];
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		if (_tmp4_ == TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT) {
#line 2066 "tracker-builder.c"
			TrackerSparqlBuilderState* _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
#line 110 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp5_ = self->priv->states;
#line 110 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp5__length1 = self->priv->states_length1;
#line 110 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp2_ = _tmp5__length1 == 3;
#line 2075 "tracker-builder.c"
		} else {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp2_ = FALSE;
#line 2079 "tracker-builder.c"
		}
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = _tmp2_;
#line 2083 "tracker-builder.c"
	}
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_warn_if_fail (_tmp0_);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = self->priv->str;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_->str;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp7_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2095 "tracker-builder.c"
}


gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self) {
	gint result;
	gint _tmp0_ = 0;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->_length;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp0_;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2110 "tracker-builder.c"
}


static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self, gint value) {
	gint _tmp0_ = 0;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = value;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->_length = _tmp0_;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_notify ((GObject *) self, "length");
#line 2124 "tracker-builder.c"
}


TrackerSparqlBuilderState tracker_sparql_builder_get_state (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState result;
	TrackerSparqlBuilderState* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	TrackerSparqlBuilderState* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	TrackerSparqlBuilderState _tmp2_ = 0;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->states;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1__length1 = self->priv->states_length1;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp0_[_tmp1__length1 - 1];
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp2_;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2151 "tracker-builder.c"
}


static void tracker_sparql_builder_class_init (TrackerSparqlBuilderClass * klass) {
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_parent_class = g_type_class_peek_parent (klass);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlBuilderPrivate));
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_builder_get_property;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_builder_set_property;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_builder_finalize;
#line 2166 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:result:
	 *
	 * String containing the constructed SPARQL in the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_RESULT, g_param_spec_string ("result", "result", "result", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2176 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:length:
	 *
	 * Number of objects added to the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_LENGTH, g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2186 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:state:
	 *
	 * Current state of the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_STATE, g_param_spec_enum ("state", "state", "state", TRACKER_SPARQL_BUILDER_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2196 "tracker-builder.c"
}


static void tracker_sparql_builder_instance_init (TrackerSparqlBuilder * self) {
	GString* _tmp0_ = NULL;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv = TRACKER_SPARQL_BUILDER_GET_PRIVATE (self);
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = g_string_new ("");
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->str = _tmp0_;
#line 2208 "tracker-builder.c"
}


static void tracker_sparql_builder_finalize (GObject* obj) {
	TrackerSparqlBuilder * self;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder);
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states = (g_free (self->priv->states), NULL);
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_string_free0 (self->priv->str);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (tracker_sparql_builder_parent_class)->finalize (obj);
#line 2222 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_new:
 *
 * Creates a stateless #TrackerSparqlBuilder.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
GType tracker_sparql_builder_get_type (void) {
	static volatile gsize tracker_sparql_builder_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_builder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBuilder), 0, (GInstanceInitFunc) tracker_sparql_builder_instance_init, NULL };
		GType tracker_sparql_builder_type_id;
		tracker_sparql_builder_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlBuilder", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_builder_type_id__volatile, tracker_sparql_builder_type_id);
	}
	return tracker_sparql_builder_type_id__volatile;
}


static void _vala_tracker_sparql_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	switch (property_id) {
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_RESULT:
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_string (value, tracker_sparql_builder_get_result (self));
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_LENGTH:
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_int (value, tracker_sparql_builder_get_length (self));
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_STATE:
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_enum (value, tracker_sparql_builder_get_state (self));
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2270 "tracker-builder.c"
		default:
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2276 "tracker-builder.c"
	}
}


static void _vala_tracker_sparql_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	switch (property_id) {
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_LENGTH:
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		tracker_sparql_builder_set_length (self, g_value_get_int (value));
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2292 "tracker-builder.c"
		default:
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2298 "tracker-builder.c"
	}
}



