/* tracker-sparql-query.c generated by valac 0.30.0, the Vala compiler
 * generated from tracker-sparql-query.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-property.h"
#include "libtracker-data/tracker-class.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-common/tracker-date-time.h"
#include "libtracker-data/tracker-ontologies.h"
#include "libtracker-data/tracker-namespace.h"
#include "libtracker-data/tracker-db-manager.h"
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())

#define TRACKER_SPARQL_TYPE_UPDATE_TYPE (tracker_sparql_update_type_get_type ())

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlDataTablePrivate TrackerSparqlDataTablePrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_variable_binding_list_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))

typedef struct _TrackerSparqlVariableBindingList TrackerSparqlVariableBindingList;
typedef struct _TrackerSparqlVariableBindingListClass TrackerSparqlVariableBindingListClass;
typedef struct _TrackerSparqlVariableBindingListPrivate TrackerSparqlVariableBindingListPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;
typedef struct _TrackerSparqlParamSpecContext TrackerSparqlParamSpecContext;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;

#define TRACKER_SPARQL_TYPE_SOLUTION (tracker_sparql_solution_get_type ())
#define TRACKER_SPARQL_SOLUTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SOLUTION, TrackerSparqlSolution))
#define TRACKER_SPARQL_SOLUTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SOLUTION, TrackerSparqlSolutionClass))
#define TRACKER_SPARQL_IS_SOLUTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SOLUTION))
#define TRACKER_SPARQL_IS_SOLUTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SOLUTION))
#define TRACKER_SPARQL_SOLUTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SOLUTION, TrackerSparqlSolutionClass))

typedef struct _TrackerSparqlSolution TrackerSparqlSolution;
typedef struct _TrackerSparqlSolutionClass TrackerSparqlSolutionClass;
typedef struct _TrackerSparqlSolutionPrivate TrackerSparqlSolutionPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlParamSpecSolution TrackerSparqlParamSpecSolution;

#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;

#define TRACKER_SPARQL_QUERY_TYPE_TOKEN_INFO (tracker_sparql_query_token_info_get_type ())

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;
typedef struct _TrackerSparqlQueryTokenInfo TrackerSparqlQueryTokenInfo;
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _tracker_source_location_free0(var) ((var == NULL) ? NULL : (var = (tracker_source_location_free (var), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _tracker_sparql_solution_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_solution_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

typedef enum  {
	TRACKER_SPARQL_UPDATE_TYPE_DELETE,
	TRACKER_SPARQL_UPDATE_TYPE_INSERT,
	TRACKER_SPARQL_UPDATE_TYPE_UPDATE
} TrackerSparqlUpdateType;

struct _TrackerSparqlDataTable {
	GObject parent_instance;
	TrackerSparqlDataTablePrivate * priv;
	gchar* sql_db_tablename;
	gchar* sql_query_tablename;
	TrackerSparqlPredicateVariable* predicate_variable;
};

struct _TrackerSparqlDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBindingPrivate {
	gchar* _sql_expression;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlVariableBindingList {
	GObject parent_instance;
	TrackerSparqlVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariablePrivate {
	gchar* _name;
	gint _index;
	gchar* _sql_expression;
	gchar* sql_identifier;
	TrackerSparqlContext* _origin_context;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlParamSpecContext {
	GParamSpec parent_instance;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlSolution {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlSolutionPrivate * priv;
	GHashTable* hash;
	GPtrArray* values;
	gint solution_index;
};

struct _TrackerSparqlSolutionClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlSolution *self);
};

struct _TrackerSparqlParamSpecSolution {
	GParamSpec parent_instance;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BIND,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NOW,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_RAND,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlQueryTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

struct _TrackerSparqlQueryPrivate {
	TrackerSparqlScanner* scanner;
	TrackerSparqlQueryTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	gchar* query_string;
	gboolean update_extensions;
	gchar* current_graph;
	gchar* current_subject;
	gboolean current_subject_is_var;
	gchar* current_predicate;
	gboolean current_predicate_is_var;
	gboolean silent;
	GHashTable* prefix_map;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	GHashTable* blank_nodes;
	gboolean _no_cache;
	gboolean anon_blank_node_open;
};

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
	gchar* current_graph;
	TrackerSparqlVariable* fts_subject;
	gchar** fts_variables;
	gint fts_variables_length1;
	gint _fts_variables_size_;
	GString* match_str;
	gboolean queries_fts_data;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};


static gpointer tracker_sparql_data_table_parent_class = NULL;
static gpointer tracker_sparql_data_binding_parent_class = NULL;
static gpointer tracker_sparql_literal_binding_parent_class = NULL;
static gpointer tracker_sparql_variable_binding_parent_class = NULL;
static gpointer tracker_sparql_variable_binding_list_parent_class = NULL;
static gpointer tracker_sparql_variable_parent_class = NULL;
static gpointer tracker_sparql_context_parent_class = NULL;
static gpointer tracker_sparql_select_context_parent_class = NULL;
static gpointer tracker_sparql_solution_parent_class = NULL;
static gpointer tracker_sparql_query_parent_class = NULL;

GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
GType tracker_sparql_update_type_get_type (void) G_GNUC_CONST;
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_DATA_TABLE_DUMMY_PROPERTY
};
TrackerSparqlDataTable* tracker_sparql_data_table_new (void);
TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type);
static void tracker_sparql_data_table_finalize (GObject* obj);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_DATA_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingPrivate))
enum  {
	TRACKER_SPARQL_DATA_BINDING_DUMMY_PROPERTY,
	TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION
};
gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix);
TrackerSparqlDataBinding* tracker_sparql_data_binding_construct (GType object_type);
const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
static void tracker_sparql_data_binding_finalize (GObject* obj);
static void _vala_tracker_sparql_data_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_data_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_LITERAL_BINDING_DUMMY_PROPERTY
};
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
static void tracker_sparql_literal_binding_finalize (GObject* obj);
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_VARIABLE_BINDING_DUMMY_PROPERTY
};
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
static void tracker_sparql_variable_binding_finalize (GObject* obj);
GType tracker_sparql_variable_binding_list_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_VARIABLE_BINDING_LIST_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type);
static void tracker_sparql_variable_binding_list_finalize (GObject* obj);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariablePrivate))
enum  {
	TRACKER_SPARQL_VARIABLE_DUMMY_PROPERTY,
	TRACKER_SPARQL_VARIABLE_NAME,
	TRACKER_SPARQL_VARIABLE_INDEX,
	TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION,
	TRACKER_SPARQL_VARIABLE_ORIGIN_CONTEXT
};
TrackerSparqlVariable* tracker_sparql_variable_new (const gchar* name, gint index, TrackerSparqlContext* context);
TrackerSparqlVariable* tracker_sparql_variable_construct (GType object_type, const gchar* name, gint index, TrackerSparqlContext* context);
static void tracker_sparql_variable_set_name (TrackerSparqlVariable* self, const gchar* value);
static void tracker_sparql_variable_set_index (TrackerSparqlVariable* self, gint value);
static void tracker_sparql_variable_set_sql_expression (TrackerSparqlVariable* self, const gchar* value);
static void tracker_sparql_variable_set_origin_context (TrackerSparqlVariable* self, TrackerSparqlContext* value);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
gboolean tracker_sparql_variable_equal (TrackerSparqlVariable* a, TrackerSparqlVariable* b);
gint tracker_sparql_variable_get_index (TrackerSparqlVariable* self);
guint tracker_sparql_variable_hash (TrackerSparqlVariable* variable);
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
TrackerSparqlContext* tracker_sparql_variable_get_origin_context (TrackerSparqlVariable* self);
static void tracker_sparql_variable_finalize (GObject* obj);
static void _vala_tracker_sparql_variable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_variable_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_CONTEXT_DUMMY_PROPERTY
};
TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key);
static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b);
TrackerSparqlContext* tracker_sparql_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
static void tracker_sparql_context_finalize (TrackerSparqlContext* obj);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_SELECT_CONTEXT_DUMMY_PROPERTY
};
TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_select_context_finalize (TrackerSparqlContext* obj);
gpointer tracker_sparql_solution_ref (gpointer instance);
void tracker_sparql_solution_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_solution (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_solution (GValue* value, gpointer v_object);
void tracker_sparql_value_take_solution (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_solution (const GValue* value);
GType tracker_sparql_solution_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_SOLUTION_DUMMY_PROPERTY
};
TrackerSparqlSolution* tracker_sparql_solution_new (void);
TrackerSparqlSolution* tracker_sparql_solution_construct (GType object_type);
static void _g_free0_ (gpointer var);
gchar* tracker_sparql_solution_lookup (TrackerSparqlSolution* self, const gchar* variable_name);
static void tracker_sparql_solution_finalize (TrackerSparqlSolution* obj);
GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
static GType tracker_sparql_query_token_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static TrackerSparqlQueryTokenInfo* tracker_sparql_query_token_info_dup (const TrackerSparqlQueryTokenInfo* self);
static void tracker_sparql_query_token_info_free (TrackerSparqlQueryTokenInfo* self);
#define TRACKER_SPARQL_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryPrivate))
enum  {
	TRACKER_SPARQL_QUERY_DUMMY_PROPERTY,
	TRACKER_SPARQL_QUERY_NO_CACHE
};
#define TRACKER_SPARQL_QUERY_BUFFER_SIZE 32
#define TRACKER_SPARQL_QUERY_FN_NS "http://www.w3.org/2005/xpath-functions#"
TrackerSparqlQuery* tracker_sparql_query_new (const gchar* query);
TrackerSparqlQuery* tracker_sparql_query_construct (GType object_type, const gchar* query);
void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value);
void uuid_generate (guchar* uuid);
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query);
TrackerSparqlQuery* tracker_sparql_query_new_update (const gchar* query);
TrackerSparqlQuery* tracker_sparql_query_construct_update (GType object_type, const gchar* query);
static gchar* tracker_sparql_query_get_uuid_for_name (TrackerSparqlQuery* self, guchar* base_uuid, int base_uuid_length1, const gchar* name);
gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);
void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location);
void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, TrackerSourceLocation* location);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static void tracker_sparql_query_parse_prologue (TrackerSparqlQuery* self, GError** error);
static void tracker_sparql_query_prepare_execute (TrackerSparqlQuery* self, GError** error);
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
TrackerDBCursor* tracker_sparql_query_execute_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error);
static TrackerDBCursor* tracker_sparql_query_execute_select_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error);
static TrackerDBCursor* tracker_sparql_query_execute_ask_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error);
GVariant* tracker_sparql_query_execute_update (TrackerSparqlQuery* self, gboolean blank, GError** error);
static void tracker_sparql_query_execute_insert_delete (TrackerSparqlQuery* self, GVariantBuilder* update_blank_nodes, GError** error);
static TrackerDBStatement* tracker_sparql_query_prepare_for_exec (TrackerSparqlQuery* self, const gchar* sql, GError** error);
gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self);
static TrackerDBCursor* tracker_sparql_query_exec_sql_cursor (TrackerSparqlQuery* self, const gchar* sql, TrackerPropertyType* types, int types_length1, gchar** variable_names, int variable_names_length1, gboolean threadsafe, GError** error);
static gchar* tracker_sparql_query_get_select_query (TrackerSparqlQuery* self, TrackerSparqlSelectContext** context, GError** error);
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
static gchar* tracker_sparql_query_get_ask_query (TrackerSparqlQuery* self, GError** error);
TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
static void tracker_sparql_query_parse_from_or_into_param (TrackerSparqlQuery* self, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
static void tracker_sparql_query_skip_braces (TrackerSparqlQuery* self, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
static void tracker_sparql_query_parse_construct_triples_block (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error);
static GVariant* _variant_new1 (GHashTable* value);
static gchar* tracker_sparql_query_parse_construct_var_or_term (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, gboolean* is_null, GError** error);
static void tracker_sparql_query_parse_construct_property_list_not_empty (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_query_parse_construct_object_list (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error);
static void tracker_sparql_query_parse_construct_object (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error);
static void tracker_sparql_query_finalize (GObject* obj);
static void _vala_tracker_sparql_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType tracker_sparql_variable_state_get_type (void) {
	static volatile gsize tracker_sparql_variable_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_VARIABLE_STATE_NONE, "TRACKER_SPARQL_VARIABLE_STATE_NONE", "none"}, {TRACKER_SPARQL_VARIABLE_STATE_BOUND, "TRACKER_SPARQL_VARIABLE_STATE_BOUND", "bound"}, {TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL, "TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL", "optional"}, {0, NULL, NULL}};
		GType tracker_sparql_variable_state_type_id;
		tracker_sparql_variable_state_type_id = g_enum_register_static ("TrackerSparqlVariableState", values);
		g_once_init_leave (&tracker_sparql_variable_state_type_id__volatile, tracker_sparql_variable_state_type_id);
	}
	return tracker_sparql_variable_state_type_id__volatile;
}


GType tracker_sparql_update_type_get_type (void) {
	static volatile gsize tracker_sparql_update_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_update_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_UPDATE_TYPE_DELETE, "TRACKER_SPARQL_UPDATE_TYPE_DELETE", "delete"}, {TRACKER_SPARQL_UPDATE_TYPE_INSERT, "TRACKER_SPARQL_UPDATE_TYPE_INSERT", "insert"}, {TRACKER_SPARQL_UPDATE_TYPE_UPDATE, "TRACKER_SPARQL_UPDATE_TYPE_UPDATE", "update"}, {0, NULL, NULL}};
		GType tracker_sparql_update_type_type_id;
		tracker_sparql_update_type_type_id = g_enum_register_static ("TrackerSparqlUpdateType", values);
		g_once_init_leave (&tracker_sparql_update_type_type_id__volatile, tracker_sparql_update_type_type_id);
	}
	return tracker_sparql_update_type_type_id__volatile;
}


TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type) {
	TrackerSparqlDataTable * self = NULL;
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlDataTable*) g_object_new (object_type, NULL);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 803 "tracker-sparql-query.c"
}


TrackerSparqlDataTable* tracker_sparql_data_table_new (void) {
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_data_table_construct (TRACKER_SPARQL_TYPE_DATA_TABLE);
#line 810 "tracker-sparql-query.c"
}


static void tracker_sparql_data_table_class_init (TrackerSparqlDataTableClass * klass) {
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_data_table_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_data_table_finalize;
#line 819 "tracker-sparql-query.c"
}


static void tracker_sparql_data_table_instance_init (TrackerSparqlDataTable * self) {
}


static void tracker_sparql_data_table_finalize (GObject* obj) {
	TrackerSparqlDataTable * self;
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->sql_db_tablename);
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->sql_query_tablename);
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->predicate_variable);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_data_table_parent_class)->finalize (obj);
#line 839 "tracker-sparql-query.c"
}


GType tracker_sparql_data_table_get_type (void) {
	static volatile gsize tracker_sparql_data_table_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_data_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlDataTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_data_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlDataTable), 0, (GInstanceInitFunc) tracker_sparql_data_table_instance_init, NULL };
		GType tracker_sparql_data_table_type_id;
		tracker_sparql_data_table_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlDataTable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_data_table_type_id__volatile, tracker_sparql_data_table_type_id);
	}
	return tracker_sparql_data_table_type_id__volatile;
}


gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix) {
	gchar* result = NULL;
	TrackerSparqlDataTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (suffix != NULL, NULL);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->table;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = _tmp0_->sql_query_tablename;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->sql_db_column_name;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = suffix;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = g_strdup_printf ("\"%s\".\"%s:%s\"", _tmp1_, _tmp2_, _tmp3_);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp4_;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 880 "tracker-sparql-query.c"
}


TrackerSparqlDataBinding* tracker_sparql_data_binding_construct (GType object_type) {
	TrackerSparqlDataBinding * self = NULL;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlDataBinding*) g_object_new (object_type, NULL);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 890 "tracker-sparql-query.c"
}


const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_ = NULL;
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->_sql_expression;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_ == NULL) {
#line 904 "tracker-sparql-query.c"
		TrackerSparqlDataTable* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = self->table;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = _tmp1_->sql_query_tablename;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = self->sql_db_column_name;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = g_strdup_printf ("\"%s\".\"%s\"", _tmp2_, _tmp3_);
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->_sql_expression);
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->_sql_expression = _tmp4_;
#line 921 "tracker-sparql-query.c"
	}
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = self->priv->_sql_expression;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp5_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 929 "tracker-sparql-query.c"
}


void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = value;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->_sql_expression);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_sql_expression = _tmp1_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_notify ((GObject *) self, "sql-expression");
#line 948 "tracker-sparql-query.c"
}


static void tracker_sparql_data_binding_class_init (TrackerSparqlDataBindingClass * klass) {
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_data_binding_parent_class = g_type_class_peek_parent (klass);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlDataBindingPrivate));
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_data_binding_get_property;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_data_binding_set_property;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_data_binding_finalize;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION, g_param_spec_string ("sql-expression", "sql-expression", "sql-expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 965 "tracker-sparql-query.c"
}


static void tracker_sparql_data_binding_instance_init (TrackerSparqlDataBinding * self) {
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv = TRACKER_SPARQL_DATA_BINDING_GET_PRIVATE (self);
#line 972 "tracker-sparql-query.c"
}


static void tracker_sparql_data_binding_finalize (GObject* obj) {
	TrackerSparqlDataBinding * self;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding);
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->table);
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->sql_db_column_name);
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->_sql_expression);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_data_binding_parent_class)->finalize (obj);
#line 988 "tracker-sparql-query.c"
}


GType tracker_sparql_data_binding_get_type (void) {
	static volatile gsize tracker_sparql_data_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_data_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlDataBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_data_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlDataBinding), 0, (GInstanceInitFunc) tracker_sparql_data_binding_instance_init, NULL };
		GType tracker_sparql_data_binding_type_id;
		tracker_sparql_data_binding_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlDataBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_sparql_data_binding_type_id__volatile, tracker_sparql_data_binding_type_id);
	}
	return tracker_sparql_data_binding_type_id__volatile;
}


static void _vala_tracker_sparql_data_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlDataBinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION:
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_value_set_string (value, tracker_sparql_data_binding_get_sql_expression (self));
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1015 "tracker-sparql-query.c"
		default:
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1021 "tracker-sparql-query.c"
	}
}


static void _vala_tracker_sparql_data_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlDataBinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION:
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_data_binding_set_sql_expression (self, g_value_get_string (value));
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1037 "tracker-sparql-query.c"
		default:
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1043 "tracker-sparql-query.c"
	}
}


TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type) {
	TrackerSparqlLiteralBinding * self = NULL;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlLiteralBinding*) tracker_sparql_data_binding_construct (object_type);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1054 "tracker-sparql-query.c"
}


TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void) {
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_literal_binding_construct (TRACKER_SPARQL_TYPE_LITERAL_BINDING);
#line 1061 "tracker-sparql-query.c"
}


static void tracker_sparql_literal_binding_class_init (TrackerSparqlLiteralBindingClass * klass) {
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_literal_binding_parent_class = g_type_class_peek_parent (klass);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_literal_binding_finalize;
#line 1070 "tracker-sparql-query.c"
}


static void tracker_sparql_literal_binding_instance_init (TrackerSparqlLiteralBinding * self) {
}


static void tracker_sparql_literal_binding_finalize (GObject* obj) {
	TrackerSparqlLiteralBinding * self;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding);
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->literal);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_literal_binding_parent_class)->finalize (obj);
#line 1086 "tracker-sparql-query.c"
}


GType tracker_sparql_literal_binding_get_type (void) {
	static volatile gsize tracker_sparql_literal_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_literal_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlLiteralBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_literal_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlLiteralBinding), 0, (GInstanceInitFunc) tracker_sparql_literal_binding_instance_init, NULL };
		GType tracker_sparql_literal_binding_type_id;
		tracker_sparql_literal_binding_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_DATA_BINDING, "TrackerSparqlLiteralBinding", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_literal_binding_type_id__volatile, tracker_sparql_literal_binding_type_id);
	}
	return tracker_sparql_literal_binding_type_id__volatile;
}


TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type) {
	TrackerSparqlVariableBinding * self = NULL;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlVariableBinding*) tracker_sparql_data_binding_construct (object_type);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1108 "tracker-sparql-query.c"
}


TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void) {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_variable_binding_construct (TRACKER_SPARQL_TYPE_VARIABLE_BINDING);
#line 1115 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_binding_class_init (TrackerSparqlVariableBindingClass * klass) {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_binding_parent_class = g_type_class_peek_parent (klass);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_binding_finalize;
#line 1124 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_binding_instance_init (TrackerSparqlVariableBinding * self) {
}


static void tracker_sparql_variable_binding_finalize (GObject* obj) {
	TrackerSparqlVariableBinding * self;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding);
#line 73 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->type);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_variable_binding_parent_class)->finalize (obj);
#line 1140 "tracker-sparql-query.c"
}


GType tracker_sparql_variable_binding_get_type (void) {
	static volatile gsize tracker_sparql_variable_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariableBinding), 0, (GInstanceInitFunc) tracker_sparql_variable_binding_instance_init, NULL };
		GType tracker_sparql_variable_binding_type_id;
		tracker_sparql_variable_binding_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_DATA_BINDING, "TrackerSparqlVariableBinding", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_binding_type_id__volatile, tracker_sparql_variable_binding_type_id);
	}
	return tracker_sparql_variable_binding_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1159 "tracker-sparql-query.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_list_free (self);
#line 1168 "tracker-sparql-query.c"
}


TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type) {
	TrackerSparqlVariableBindingList * self = NULL;
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlVariableBindingList*) g_object_new (object_type, NULL);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1178 "tracker-sparql-query.c"
}


TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void) {
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_variable_binding_list_construct (TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST);
#line 1185 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_binding_list_class_init (TrackerSparqlVariableBindingListClass * klass) {
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_binding_list_parent_class = g_type_class_peek_parent (klass);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_binding_list_finalize;
#line 1194 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_binding_list_instance_init (TrackerSparqlVariableBindingList * self) {
}


static void tracker_sparql_variable_binding_list_finalize (GObject* obj) {
	TrackerSparqlVariableBindingList * self;
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	__g_list_free__g_object_unref0_0 (self->list);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_variable_binding_list_parent_class)->finalize (obj);
#line 1210 "tracker-sparql-query.c"
}


GType tracker_sparql_variable_binding_list_get_type (void) {
	static volatile gsize tracker_sparql_variable_binding_list_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_binding_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableBindingListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_binding_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariableBindingList), 0, (GInstanceInitFunc) tracker_sparql_variable_binding_list_instance_init, NULL };
		GType tracker_sparql_variable_binding_list_type_id;
		tracker_sparql_variable_binding_list_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlVariableBindingList", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_binding_list_type_id__volatile, tracker_sparql_variable_binding_list_type_id);
	}
	return tracker_sparql_variable_binding_list_type_id__volatile;
}


TrackerSparqlVariable* tracker_sparql_variable_construct (GType object_type, const gchar* name, gint index, TrackerSparqlContext* context) {
	TrackerSparqlVariable * self = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	TrackerSparqlContext* _tmp7_ = NULL;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlVariable*) g_object_new (object_type, NULL);
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = name;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_set_name (self, _tmp0_);
#line 90 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = index;
#line 90 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_set_index (self, _tmp1_);
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = index;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_strdup_printf ("%d_u", _tmp2_);
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->sql_identifier);
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->sql_identifier = _tmp3_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = self->priv->sql_identifier;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = g_strdup_printf ("\"%s\"", _tmp4_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = _tmp5_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_set_sql_expression (self, _tmp6_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp6_);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = context;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_set_origin_context (self, _tmp7_);
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1274 "tracker-sparql-query.c"
}


TrackerSparqlVariable* tracker_sparql_variable_new (const gchar* name, gint index, TrackerSparqlContext* context) {
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_variable_construct (TRACKER_SPARQL_TYPE_VARIABLE, name, index, context);
#line 1281 "tracker-sparql-query.c"
}


gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (suffix != NULL, NULL);
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->sql_identifier;
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = suffix;
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = g_strdup_printf ("\"%s:%s\"", _tmp0_, _tmp1_);
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp2_;
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1304 "tracker-sparql-query.c"
}


gboolean tracker_sparql_variable_equal (TrackerSparqlVariable* a, TrackerSparqlVariable* b) {
	gboolean result = FALSE;
	TrackerSparqlVariable* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	TrackerSparqlVariable* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = a;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = _tmp0_->priv->_index;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = b;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_->priv->_index;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp1_ == _tmp3_;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1330 "tracker-sparql-query.c"
}


guint tracker_sparql_variable_hash (TrackerSparqlVariable* variable) {
	guint result = 0U;
	TrackerSparqlVariable* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (variable != NULL, 0U);
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = variable;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = _tmp0_->priv->_index;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = (guint) _tmp1_;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1348 "tracker-sparql-query.c"
}


const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->_name;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp0_;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1363 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_set_name (TrackerSparqlVariable* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = value;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->_name);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_name = _tmp1_;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_notify ((GObject *) self, "name");
#line 1382 "tracker-sparql-query.c"
}


gint tracker_sparql_variable_get_index (TrackerSparqlVariable* self) {
	gint result;
	gint _tmp0_ = 0;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->_index;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp0_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1397 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_set_index (TrackerSparqlVariable* self, gint value) {
	gint _tmp0_ = 0;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = value;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_index = _tmp0_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_notify ((GObject *) self, "index");
#line 1411 "tracker-sparql-query.c"
}


const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->_sql_expression;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp0_;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1426 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_set_sql_expression (TrackerSparqlVariable* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = value;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->_sql_expression);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_sql_expression = _tmp1_;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_notify ((GObject *) self, "sql-expression");
#line 1445 "tracker-sparql-query.c"
}


TrackerSparqlContext* tracker_sparql_variable_get_origin_context (TrackerSparqlVariable* self) {
	TrackerSparqlContext* result;
	TrackerSparqlContext* _tmp0_ = NULL;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->_origin_context;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp0_;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1460 "tracker-sparql-query.c"
}


static gpointer _tracker_sparql_context_ref0 (gpointer self) {
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self ? tracker_sparql_context_ref (self) : NULL;
#line 1467 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_set_origin_context (TrackerSparqlVariable* self, TrackerSparqlContext* value) {
	TrackerSparqlContext* _tmp0_ = NULL;
	TrackerSparqlContext* _tmp1_ = NULL;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = value;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = _tracker_sparql_context_ref0 (_tmp0_);
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->priv->_origin_context);
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_origin_context = _tmp1_;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_notify ((GObject *) self, "origin-context");
#line 1486 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_class_init (TrackerSparqlVariableClass * klass) {
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_parent_class = g_type_class_peek_parent (klass);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlVariablePrivate));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_variable_get_property;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_variable_set_property;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_finalize;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_INDEX, g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION, g_param_spec_string ("sql-expression", "sql-expression", "sql-expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_ORIGIN_CONTEXT, tracker_sparql_param_spec_context ("origin-context", "origin-context", "origin-context", TRACKER_SPARQL_TYPE_CONTEXT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1509 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_instance_init (TrackerSparqlVariable * self) {
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv = TRACKER_SPARQL_VARIABLE_GET_PRIVATE (self);
#line 1516 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_finalize (GObject* obj) {
	TrackerSparqlVariable * self;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->_name);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->_sql_expression);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->binding);
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->sql_identifier);
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->priv->_origin_context);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_variable_parent_class)->finalize (obj);
#line 1536 "tracker-sparql-query.c"
}


GType tracker_sparql_variable_get_type (void) {
	static volatile gsize tracker_sparql_variable_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariable), 0, (GInstanceInitFunc) tracker_sparql_variable_instance_init, NULL };
		GType tracker_sparql_variable_type_id;
		tracker_sparql_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlVariable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_type_id__volatile, tracker_sparql_variable_type_id);
	}
	return tracker_sparql_variable_type_id__volatile;
}


static void _vala_tracker_sparql_variable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_NAME:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_value_set_string (value, tracker_sparql_variable_get_name (self));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_INDEX:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_value_set_int (value, tracker_sparql_variable_get_index (self));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_value_set_string (value, tracker_sparql_variable_get_sql_expression (self));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_ORIGIN_CONTEXT:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_value_set_context (value, tracker_sparql_variable_get_origin_context (self));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1581 "tracker-sparql-query.c"
		default:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1587 "tracker-sparql-query.c"
	}
}


static void _vala_tracker_sparql_variable_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_NAME:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_variable_set_name (self, g_value_get_string (value));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_INDEX:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_variable_set_index (self, g_value_get_int (value));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_variable_set_sql_expression (self, g_value_get_string (value));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_ORIGIN_CONTEXT:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_variable_set_origin_context (self, tracker_sparql_value_get_context (value));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1621 "tracker-sparql-query.c"
		default:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1627 "tracker-sparql-query.c"
	}
}


static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key) {
	guint result;
	result = tracker_sparql_variable_hash ((TrackerSparqlVariable*) key);
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1637 "tracker-sparql-query.c"
}


static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = tracker_sparql_variable_equal ((TrackerSparqlVariable*) a, (TrackerSparqlVariable*) b);
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1646 "tracker-sparql-query.c"
}


static gpointer _g_hash_table_ref0 (gpointer self) {
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 1653 "tracker-sparql-query.c"
}


TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlContext* self = NULL;
	TrackerSparqlQuery* _tmp0_ = NULL;
	TrackerSparqlContext* _tmp1_ = NULL;
	TrackerSparqlContext* _tmp2_ = NULL;
	GDestroyNotify _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	TrackerSparqlContext* _tmp5_ = NULL;
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlContext*) g_type_create_instance (object_type);
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = query;
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->query = _tmp0_;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = parent_context;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tracker_sparql_context_ref0 (_tmp1_);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->parent_context);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->parent_context = _tmp2_;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_object_unref;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp3_, NULL);
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->var_set);
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->var_set = _tmp4_;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = parent_context;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp5_ == NULL) {
#line 1693 "tracker-sparql-query.c"
		GDestroyNotify _tmp6_ = NULL;
		GHashTable* _tmp7_ = NULL;
		GHashFunc _tmp8_ = NULL;
		GEqualFunc _tmp9_ = NULL;
		GDestroyNotify _tmp10_ = NULL;
		GDestroyNotify _tmp11_ = NULL;
		GHashTable* _tmp12_ = NULL;
		GDestroyNotify _tmp13_ = NULL;
		GDestroyNotify _tmp14_ = NULL;
		GHashTable* _tmp15_ = NULL;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = g_object_unref;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp6_, NULL);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->select_var_set);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->select_var_set = _tmp7_;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = g_str_hash;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = g_str_equal;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = g_free;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = g_object_unref;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = g_hash_table_new_full (_tmp8_, _tmp9_, _tmp10_, _tmp11_);
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->var_map);
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->var_map = _tmp12_;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = g_object_unref;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = g_object_unref;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp15_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp13_, _tmp14_);
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->predicate_variable_map);
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->predicate_variable_map = _tmp15_;
#line 1736 "tracker-sparql-query.c"
	} else {
		TrackerSparqlContext* _tmp16_ = NULL;
		GHashTable* _tmp17_ = NULL;
		GHashTable* _tmp18_ = NULL;
		TrackerSparqlContext* _tmp19_ = NULL;
		GHashTable* _tmp20_ = NULL;
		GHashTable* _tmp21_ = NULL;
		TrackerSparqlContext* _tmp22_ = NULL;
		GHashTable* _tmp23_ = NULL;
		GHashTable* _tmp24_ = NULL;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp16_ = parent_context;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp17_ = _tmp16_->select_var_set;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp18_ = _g_hash_table_ref0 (_tmp17_);
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->select_var_set);
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->select_var_set = _tmp18_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp19_ = parent_context;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp20_ = _tmp19_->var_map;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp21_ = _g_hash_table_ref0 (_tmp20_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->var_map);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->var_map = _tmp21_;
#line 138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp22_ = parent_context;
#line 138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp23_ = _tmp22_->predicate_variable_map;
#line 138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp24_ = _g_hash_table_ref0 (_tmp23_);
#line 138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->predicate_variable_map);
#line 138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->predicate_variable_map = _tmp24_;
#line 1777 "tracker-sparql-query.c"
	}
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1781 "tracker-sparql-query.c"
}


TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_context_construct (TRACKER_SPARQL_TYPE_CONTEXT, query, parent_context);
#line 1788 "tracker-sparql-query.c"
}


TrackerSparqlContext* tracker_sparql_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlContext* self = NULL;
	TrackerSparqlQuery* _tmp0_ = NULL;
	TrackerSparqlContext* _tmp1_ = NULL;
	TrackerSparqlContext* _tmp2_ = NULL;
	GDestroyNotify _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GDestroyNotify _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	TrackerSparqlContext* _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	GDestroyNotify _tmp10_ = NULL;
	GDestroyNotify _tmp11_ = NULL;
	GHashTable* _tmp12_ = NULL;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (parent_context != NULL, NULL);
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlContext*) g_type_create_instance (object_type);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = query;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->query = _tmp0_;
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = parent_context;
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tracker_sparql_context_ref0 (_tmp1_);
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->parent_context);
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->parent_context = _tmp2_;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_object_unref;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp3_, NULL);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->var_set);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->var_set = _tmp4_;
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = g_object_unref;
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp5_, NULL);
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->select_var_set);
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->select_var_set = _tmp6_;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = parent_context;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_->var_map;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _g_hash_table_ref0 (_tmp8_);
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->var_map);
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->var_map = _tmp9_;
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = g_object_unref;
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = g_object_unref;
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp10_, _tmp11_);
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->predicate_variable_map);
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->predicate_variable_map = _tmp12_;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->scalar_subquery = TRUE;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1865 "tracker-sparql-query.c"
}


TrackerSparqlContext* tracker_sparql_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_context_construct_subquery (TRACKER_SPARQL_TYPE_CONTEXT, query, parent_context);
#line 1872 "tracker-sparql-query.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self ? g_object_ref (self) : NULL;
#line 1879 "tracker-sparql-query.c"
}


TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name) {
	TrackerSparqlVariable* result = NULL;
	TrackerSparqlVariable* _result_ = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	TrackerSparqlVariable* _tmp3_ = NULL;
	TrackerSparqlVariable* _tmp16_ = NULL;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->var_map;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = name;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_result_ = (TrackerSparqlVariable*) _tmp2_;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _result_;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp3_ == NULL) {
#line 1907 "tracker-sparql-query.c"
		TrackerSparqlVariable* variable = NULL;
		const gchar* _tmp4_ = NULL;
		TrackerSparqlQuery* _tmp5_ = NULL;
		TrackerSparqlQuery* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		TrackerSparqlVariable* _tmp9_ = NULL;
		GHashTable* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		TrackerSparqlVariable* _tmp13_ = NULL;
		TrackerSparqlVariable* _tmp14_ = NULL;
		TrackerSparqlVariable* _tmp15_ = NULL;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = name;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = self->query;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = self->query;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = _tmp6_->last_var_index;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_->last_var_index = _tmp7_ + 1;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = _tmp6_->last_var_index;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = tracker_sparql_variable_new (_tmp4_, _tmp8_, self);
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		variable = _tmp9_;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = self->var_map;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = name;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = variable;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = _g_object_ref0 (_tmp13_);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_hash_table_insert (_tmp10_, _tmp12_, _tmp14_);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp15_ = variable;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_result_ = _tmp15_;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (variable);
#line 1955 "tracker-sparql-query.c"
	}
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp16_ = _result_;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp16_;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1963 "tracker-sparql-query.c"
}


static void tracker_sparql_value_context_init (GValue* value) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	value->data[0].v_pointer = NULL;
#line 1970 "tracker-sparql-query.c"
}


static void tracker_sparql_value_context_free_value (GValue* value) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (value->data[0].v_pointer) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_context_unref (value->data[0].v_pointer);
#line 1979 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_value_context_copy_value (const GValue* src_value, GValue* dest_value) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (src_value->data[0].v_pointer) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		dest_value->data[0].v_pointer = tracker_sparql_context_ref (src_value->data[0].v_pointer);
#line 1989 "tracker-sparql-query.c"
	} else {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1993 "tracker-sparql-query.c"
	}
}


static gpointer tracker_sparql_value_context_peek_pointer (const GValue* value) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return value->data[0].v_pointer;
#line 2001 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_value_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (collect_values[0].v_pointer) {
#line 2008 "tracker-sparql-query.c"
		TrackerSparqlContext* object;
		object = collect_values[0].v_pointer;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (object->parent_instance.g_class == NULL) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2015 "tracker-sparql-query.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2019 "tracker-sparql-query.c"
		}
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = tracker_sparql_context_ref (object);
#line 2023 "tracker-sparql-query.c"
	} else {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2027 "tracker-sparql-query.c"
	}
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return NULL;
#line 2031 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_value_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerSparqlContext** object_p;
	object_p = collect_values[0].v_pointer;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!object_p) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2042 "tracker-sparql-query.c"
	}
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!value->data[0].v_pointer) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = NULL;
#line 2048 "tracker-sparql-query.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = value->data[0].v_pointer;
#line 2052 "tracker-sparql-query.c"
	} else {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = tracker_sparql_context_ref (value->data[0].v_pointer);
#line 2056 "tracker-sparql-query.c"
	}
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return NULL;
#line 2060 "tracker-sparql-query.c"
}


GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerSparqlParamSpecContext* spec;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_SPARQL_TYPE_CONTEXT), NULL);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return G_PARAM_SPEC (spec);
#line 2074 "tracker-sparql-query.c"
}


gpointer tracker_sparql_value_get_context (const GValue* value) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT), NULL);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return value->data[0].v_pointer;
#line 2083 "tracker-sparql-query.c"
}


void tracker_sparql_value_set_context (GValue* value, gpointer v_object) {
	TrackerSparqlContext* old;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT));
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	old = value->data[0].v_pointer;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (v_object) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_CONTEXT));
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = v_object;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_context_ref (value->data[0].v_pointer);
#line 2103 "tracker-sparql-query.c"
	} else {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2107 "tracker-sparql-query.c"
	}
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (old) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_context_unref (old);
#line 2113 "tracker-sparql-query.c"
	}
}


void tracker_sparql_value_take_context (GValue* value, gpointer v_object) {
	TrackerSparqlContext* old;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT));
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	old = value->data[0].v_pointer;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (v_object) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_CONTEXT));
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = v_object;
#line 2132 "tracker-sparql-query.c"
	} else {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2136 "tracker-sparql-query.c"
	}
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (old) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_context_unref (old);
#line 2142 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_context_class_init (TrackerSparqlContextClass * klass) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_context_parent_class = g_type_class_peek_parent (klass);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	((TrackerSparqlContextClass *) klass)->finalize = tracker_sparql_context_finalize;
#line 2152 "tracker-sparql-query.c"
}


static void tracker_sparql_context_instance_init (TrackerSparqlContext * self) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->ref_count = 1;
#line 2159 "tracker-sparql-query.c"
}


static void tracker_sparql_context_finalize (TrackerSparqlContext* obj) {
	TrackerSparqlContext * self;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_signal_handlers_destroy (self);
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->parent_context);
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->var_set);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->var_map);
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->select_var_set);
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->predicate_variable_map);
#line 2179 "tracker-sparql-query.c"
}


GType tracker_sparql_context_get_type (void) {
	static volatile gsize tracker_sparql_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_sparql_value_context_init, tracker_sparql_value_context_free_value, tracker_sparql_value_context_copy_value, tracker_sparql_value_context_peek_pointer, "p", tracker_sparql_value_context_collect_value, "p", tracker_sparql_value_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlContext), 0, (GInstanceInitFunc) tracker_sparql_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_sparql_context_type_id;
		tracker_sparql_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerSparqlContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_sparql_context_type_id__volatile, tracker_sparql_context_type_id);
	}
	return tracker_sparql_context_type_id__volatile;
}


gpointer tracker_sparql_context_ref (gpointer instance) {
	TrackerSparqlContext* self;
	self = instance;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_atomic_int_inc (&self->ref_count);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return instance;
#line 2204 "tracker-sparql-query.c"
}


void tracker_sparql_context_unref (gpointer instance) {
	TrackerSparqlContext* self;
	self = instance;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		TRACKER_SPARQL_CONTEXT_GET_CLASS (self)->finalize (self);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2217 "tracker-sparql-query.c"
	}
}


TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlSelectContext* self = NULL;
	TrackerSparqlQuery* _tmp0_ = NULL;
	TrackerSparqlContext* _tmp1_ = NULL;
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 171 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = query;
#line 171 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = parent_context;
#line 171 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlSelectContext*) tracker_sparql_context_construct (object_type, _tmp0_, _tmp1_);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 2236 "tracker-sparql-query.c"
}


TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_select_context_construct (TRACKER_SPARQL_TYPE_SELECT_CONTEXT, query, parent_context);
#line 2243 "tracker-sparql-query.c"
}


TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlSelectContext* self = NULL;
	TrackerSparqlQuery* _tmp0_ = NULL;
	TrackerSparqlContext* _tmp1_ = NULL;
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (parent_context != NULL, NULL);
#line 175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = query;
#line 175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = parent_context;
#line 175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlSelectContext*) tracker_sparql_context_construct_subquery (object_type, _tmp0_, _tmp1_);
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 2263 "tracker-sparql-query.c"
}


TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_select_context_construct_subquery (TRACKER_SPARQL_TYPE_SELECT_CONTEXT, query, parent_context);
#line 2270 "tracker-sparql-query.c"
}


static void tracker_sparql_select_context_class_init (TrackerSparqlSelectContextClass * klass) {
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_select_context_parent_class = g_type_class_peek_parent (klass);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	((TrackerSparqlContextClass *) klass)->finalize = tracker_sparql_select_context_finalize;
#line 2279 "tracker-sparql-query.c"
}


static void tracker_sparql_select_context_instance_init (TrackerSparqlSelectContext * self) {
	TrackerPropertyType* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_new0 (TrackerPropertyType, 0);
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->types = _tmp0_;
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->types_length1 = 0;
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->_types_size_ = self->types_length1;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_new0 (gchar*, 0 + 1);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->variable_names = _tmp1_;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->variable_names_length1 = 0;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->_variable_names_size_ = self->variable_names_length1;
#line 2302 "tracker-sparql-query.c"
}


static void tracker_sparql_select_context_finalize (TrackerSparqlContext* obj) {
	TrackerSparqlSelectContext * self;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext);
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->types = (g_free (self->types), NULL);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->variable_names = (_vala_array_free (self->variable_names, self->variable_names_length1, (GDestroyNotify) g_free), NULL);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	TRACKER_SPARQL_CONTEXT_CLASS (tracker_sparql_select_context_parent_class)->finalize (obj);
#line 2316 "tracker-sparql-query.c"
}


GType tracker_sparql_select_context_get_type (void) {
	static volatile gsize tracker_sparql_select_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_select_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlSelectContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_select_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlSelectContext), 0, (GInstanceInitFunc) tracker_sparql_select_context_instance_init, NULL };
		GType tracker_sparql_select_context_type_id;
		tracker_sparql_select_context_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONTEXT, "TrackerSparqlSelectContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_select_context_type_id__volatile, tracker_sparql_select_context_type_id);
	}
	return tracker_sparql_select_context_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	var = (g_free (var), NULL);
#line 2335 "tracker-sparql-query.c"
}


TrackerSparqlSolution* tracker_sparql_solution_construct (GType object_type) {
	TrackerSparqlSolution* self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GPtrArray* _tmp3_ = NULL;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlSolution*) g_type_create_instance (object_type);
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_str_hash;
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_str_equal;
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->hash);
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->hash = _tmp2_;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_ptr_array_unref0 (self->values);
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->values = _tmp3_;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 2365 "tracker-sparql-query.c"
}


TrackerSparqlSolution* tracker_sparql_solution_new (void) {
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_solution_construct (TRACKER_SPARQL_TYPE_SOLUTION);
#line 2372 "tracker-sparql-query.c"
}


gchar* tracker_sparql_solution_lookup (TrackerSparqlSolution* self, const gchar* variable_name) {
	gchar* result = NULL;
	gint variable_index = 0;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GPtrArray* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GHashTable* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gint _tmp8_ = 0;
	gconstpointer _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (variable_name != NULL, NULL);
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->hash;
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = variable_name;
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_hash_table_lookup_extended (_tmp0_, _tmp1_, NULL, &_tmp2_);
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	variable_index = _tmp2_;
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!_tmp3_) {
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		result = NULL;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return result;
#line 2408 "tracker-sparql-query.c"
	}
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = self->values;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = self->solution_index;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->hash;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = g_hash_table_size (_tmp6_);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = variable_index;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = g_ptr_array_index (_tmp4_, (_tmp5_ * _tmp7_) + _tmp8_);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = g_strdup ((const gchar*) _tmp9_);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp10_;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 2428 "tracker-sparql-query.c"
}


static void tracker_sparql_value_solution_init (GValue* value) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	value->data[0].v_pointer = NULL;
#line 2435 "tracker-sparql-query.c"
}


static void tracker_sparql_value_solution_free_value (GValue* value) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (value->data[0].v_pointer) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_solution_unref (value->data[0].v_pointer);
#line 2444 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_value_solution_copy_value (const GValue* src_value, GValue* dest_value) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (src_value->data[0].v_pointer) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		dest_value->data[0].v_pointer = tracker_sparql_solution_ref (src_value->data[0].v_pointer);
#line 2454 "tracker-sparql-query.c"
	} else {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2458 "tracker-sparql-query.c"
	}
}


static gpointer tracker_sparql_value_solution_peek_pointer (const GValue* value) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return value->data[0].v_pointer;
#line 2466 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_value_solution_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (collect_values[0].v_pointer) {
#line 2473 "tracker-sparql-query.c"
		TrackerSparqlSolution* object;
		object = collect_values[0].v_pointer;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (object->parent_instance.g_class == NULL) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2480 "tracker-sparql-query.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2484 "tracker-sparql-query.c"
		}
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = tracker_sparql_solution_ref (object);
#line 2488 "tracker-sparql-query.c"
	} else {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2492 "tracker-sparql-query.c"
	}
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return NULL;
#line 2496 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_value_solution_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerSparqlSolution** object_p;
	object_p = collect_values[0].v_pointer;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!object_p) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2507 "tracker-sparql-query.c"
	}
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!value->data[0].v_pointer) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = NULL;
#line 2513 "tracker-sparql-query.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = value->data[0].v_pointer;
#line 2517 "tracker-sparql-query.c"
	} else {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = tracker_sparql_solution_ref (value->data[0].v_pointer);
#line 2521 "tracker-sparql-query.c"
	}
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return NULL;
#line 2525 "tracker-sparql-query.c"
}


GParamSpec* tracker_sparql_param_spec_solution (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerSparqlParamSpecSolution* spec;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_SPARQL_TYPE_SOLUTION), NULL);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return G_PARAM_SPEC (spec);
#line 2539 "tracker-sparql-query.c"
}


gpointer tracker_sparql_value_get_solution (const GValue* value) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_SOLUTION), NULL);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return value->data[0].v_pointer;
#line 2548 "tracker-sparql-query.c"
}


void tracker_sparql_value_set_solution (GValue* value, gpointer v_object) {
	TrackerSparqlSolution* old;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_SOLUTION));
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	old = value->data[0].v_pointer;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (v_object) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_SOLUTION));
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = v_object;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_solution_ref (value->data[0].v_pointer);
#line 2568 "tracker-sparql-query.c"
	} else {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2572 "tracker-sparql-query.c"
	}
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (old) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_solution_unref (old);
#line 2578 "tracker-sparql-query.c"
	}
}


void tracker_sparql_value_take_solution (GValue* value, gpointer v_object) {
	TrackerSparqlSolution* old;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_SOLUTION));
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	old = value->data[0].v_pointer;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (v_object) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_SOLUTION));
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = v_object;
#line 2597 "tracker-sparql-query.c"
	} else {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2601 "tracker-sparql-query.c"
	}
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (old) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_solution_unref (old);
#line 2607 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_solution_class_init (TrackerSparqlSolutionClass * klass) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_solution_parent_class = g_type_class_peek_parent (klass);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	((TrackerSparqlSolutionClass *) klass)->finalize = tracker_sparql_solution_finalize;
#line 2617 "tracker-sparql-query.c"
}


static void tracker_sparql_solution_instance_init (TrackerSparqlSolution * self) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->ref_count = 1;
#line 2624 "tracker-sparql-query.c"
}


static void tracker_sparql_solution_finalize (TrackerSparqlSolution* obj) {
	TrackerSparqlSolution * self;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_SOLUTION, TrackerSparqlSolution);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_signal_handlers_destroy (self);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->hash);
#line 181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_ptr_array_unref0 (self->values);
#line 2638 "tracker-sparql-query.c"
}


GType tracker_sparql_solution_get_type (void) {
	static volatile gsize tracker_sparql_solution_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_solution_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_sparql_value_solution_init, tracker_sparql_value_solution_free_value, tracker_sparql_value_solution_copy_value, tracker_sparql_value_solution_peek_pointer, "p", tracker_sparql_value_solution_collect_value, "p", tracker_sparql_value_solution_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlSolutionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_solution_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlSolution), 0, (GInstanceInitFunc) tracker_sparql_solution_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_sparql_solution_type_id;
		tracker_sparql_solution_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerSparqlSolution", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_sparql_solution_type_id__volatile, tracker_sparql_solution_type_id);
	}
	return tracker_sparql_solution_type_id__volatile;
}


gpointer tracker_sparql_solution_ref (gpointer instance) {
	TrackerSparqlSolution* self;
	self = instance;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_atomic_int_inc (&self->ref_count);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return instance;
#line 2663 "tracker-sparql-query.c"
}


void tracker_sparql_solution_unref (gpointer instance) {
	TrackerSparqlSolution* self;
	self = instance;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		TRACKER_SPARQL_SOLUTION_GET_CLASS (self)->finalize (self);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2676 "tracker-sparql-query.c"
	}
}


TrackerSparqlQuery* tracker_sparql_query_construct (GType object_type, const gchar* query) {
	TrackerSparqlQuery * self = NULL;
	TrackerSparqlQueryTokenInfo* _tmp0_ = NULL;
	GHashFunc _tmp1_ = NULL;
	GEqualFunc _tmp2_ = NULL;
	GDestroyNotify _tmp3_ = NULL;
	GDestroyNotify _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	guchar* _tmp6_ = NULL;
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	TrackerSparqlExpression* _tmp10_ = NULL;
	TrackerSparqlPattern* _tmp11_ = NULL;
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlQuery*) g_object_new (object_type, NULL);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_set_no_cache (self, FALSE);
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_new0 (TrackerSparqlQueryTokenInfo, TRACKER_SPARQL_QUERY_BUFFER_SIZE);
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->tokens = _tmp0_;
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->tokens_length1 = TRACKER_SPARQL_QUERY_BUFFER_SIZE;
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_tokens_size_ = self->priv->tokens_length1;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_str_hash;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = g_str_equal;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_free;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = g_free;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = g_hash_table_new_full (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->prefix_map = _tmp5_;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = g_new0 (guchar, 16);
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->base_uuid = _tmp6_;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->base_uuid_length1 = 16;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_base_uuid_size_ = self->priv->base_uuid_length1;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = self->priv->base_uuid;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7__length1 = self->priv->base_uuid_length1;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	uuid_generate (_tmp7_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = query;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->query_string);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->query_string = _tmp9_;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = tracker_sparql_expression_new (self);
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->expression);
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->expression = _tmp10_;
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = tracker_sparql_pattern_new (self);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->pattern);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->pattern = _tmp11_;
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 2764 "tracker-sparql-query.c"
}


TrackerSparqlQuery* tracker_sparql_query_new (const gchar* query) {
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_query_construct (TRACKER_SPARQL_TYPE_QUERY, query);
#line 2771 "tracker-sparql-query.c"
}


TrackerSparqlQuery* tracker_sparql_query_construct_update (GType object_type, const gchar* query) {
	TrackerSparqlQuery * self = NULL;
	const gchar* _tmp0_ = NULL;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = query;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlQuery*) tracker_sparql_query_construct (object_type, _tmp0_);
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->update_extensions = TRUE;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 2788 "tracker-sparql-query.c"
}


TrackerSparqlQuery* tracker_sparql_query_new_update (const gchar* query) {
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_query_construct_update (TRACKER_SPARQL_TYPE_QUERY, query);
#line 2795 "tracker-sparql-query.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2818 "tracker-sparql-query.c"
		glong _tmp4_ = 0L;
#line 1199 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2826 "tracker-sparql-query.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2838 "tracker-sparql-query.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2862 "tracker-sparql-query.c"
		glong _tmp2_ = 0L;
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2868 "tracker-sparql-query.c"
	} else {
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2872 "tracker-sparql-query.c"
	}
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2876 "tracker-sparql-query.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 2888 "tracker-sparql-query.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 2898 "tracker-sparql-query.c"
	}
#line 1217 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 2904 "tracker-sparql-query.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 2918 "tracker-sparql-query.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 2928 "tracker-sparql-query.c"
	}
#line 1223 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 2934 "tracker-sparql-query.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 2943 "tracker-sparql-query.c"
	}
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 2963 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_query_get_uuid_for_name (TrackerSparqlQuery* self, guchar* base_uuid, int base_uuid_length1, const gchar* name) {
	gchar* result = NULL;
	GChecksum* checksum = NULL;
	GChecksum* _tmp0_ = NULL;
	guchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* sha1 = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_checksum_new (G_CHECKSUM_SHA1);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	checksum = _tmp0_;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = base_uuid;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1__length1 = base_uuid_length1;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_checksum_update (checksum, _tmp1_, (gsize) 16);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = name;
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_checksum_update (checksum, (guchar*) _tmp2_, (gsize) -1);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_checksum_get_string (checksum);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	sha1 = _tmp4_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = string_substring (sha1, (glong) 8, (glong) -1);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = _tmp5_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = string_substring (sha1, (glong) 12, (glong) -1);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = string_substring (sha1, (glong) 16, (glong) -1);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = _tmp9_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = string_substring (sha1, (glong) 20, (glong) -1);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = _tmp11_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", sha1, _tmp6_, _tmp8_, _tmp10_, _tmp12_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = _tmp13_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp12_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp10_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp8_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp6_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp14_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (sha1);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_checksum_free0 (checksum);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3047 "tracker-sparql-query.c"
}


gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = user_bnodeid;
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_ == NULL) {
#line 3060 "tracker-sparql-query.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gchar* _tmp3_ = NULL;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = self->priv->bnodeid;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->bnodeid = _tmp1_ + 1;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = self->priv->bnodeid;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = g_strdup_printf (":%d", _tmp2_);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		result = _tmp3_;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return result;
#line 3076 "tracker-sparql-query.c"
	} else {
		gchar* uri = NULL;
		GHashTable* _tmp4_ = NULL;
		guchar* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GHashTable* _tmp13_ = NULL;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		uri = NULL;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = self->priv->blank_nodes;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp4_ != NULL) {
#line 3091 "tracker-sparql-query.c"
			GHashTable* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gconstpointer _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = self->priv->blank_nodes;
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = user_bnodeid;
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (uri);
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			uri = _tmp8_;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = uri;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp9_ != NULL) {
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				result = uri;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return result;
#line 3117 "tracker-sparql-query.c"
			}
		}
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = self->priv->base_uuid;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10__length1 = self->priv->base_uuid_length1;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = user_bnodeid;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = tracker_sparql_query_get_uuid_for_name (self, _tmp10_, _tmp10__length1, _tmp11_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (uri);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		uri = _tmp12_;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = self->priv->blank_nodes;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp13_ != NULL) {
#line 3136 "tracker-sparql-query.c"
			GHashTable* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			while (TRUE) {
#line 3144 "tracker-sparql-query.c"
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				guchar* new_base_uuid = NULL;
				guchar* _tmp16_ = NULL;
				gint new_base_uuid_length1 = 0;
				gint _new_base_uuid_size_ = 0;
				guchar* _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				guchar* _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				const gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp14_ = uri;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp15_ = tracker_data_query_resource_id (_tmp14_);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (!(_tmp15_ > 0)) {
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					break;
#line 3165 "tracker-sparql-query.c"
				}
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp16_ = g_new0 (guchar, 16);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				new_base_uuid = _tmp16_;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				new_base_uuid_length1 = 16;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_new_base_uuid_size_ = new_base_uuid_length1;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp17_ = new_base_uuid;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp17__length1 = new_base_uuid_length1;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				uuid_generate (_tmp17_);
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18_ = new_base_uuid;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18__length1 = new_base_uuid_length1;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp19_ = user_bnodeid;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp20_ = tracker_sparql_query_get_uuid_for_name (self, _tmp18_, _tmp18__length1, _tmp19_);
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (uri);
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				uri = _tmp20_;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				new_base_uuid = (g_free (new_base_uuid), NULL);
#line 3195 "tracker-sparql-query.c"
			}
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp21_ = self->priv->blank_nodes;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp22_ = user_bnodeid;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp23_ = g_strdup (_tmp22_);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp24_ = uri;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp25_ = g_strdup (_tmp24_);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_hash_table_insert (_tmp21_, _tmp23_, _tmp25_);
#line 3209 "tracker-sparql-query.c"
		}
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		result = uri;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return result;
#line 3215 "tracker-sparql-query.c"
	}
}


gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	TrackerSparqlQueryTokenInfo* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp17_ = 0;
	TrackerSparqlQueryTokenInfo _tmp18_ = {0};
	TrackerSparqlTokenType _tmp19_ = 0;
	GError * _inner_error_ = NULL;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->index;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->index = (_tmp0_ + 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->size;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->size = _tmp1_ - 1;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->priv->size;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp2_ <= 0) {
#line 3245 "tracker-sparql-query.c"
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSparqlTokenType type = 0;
		TrackerSparqlScanner* _tmp3_ = NULL;
		TrackerSourceLocation _tmp4_ = {0};
		TrackerSourceLocation _tmp5_ = {0};
		TrackerSparqlTokenType _tmp6_ = 0;
		TrackerSparqlQueryTokenInfo* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp8_ = 0;
		TrackerSparqlTokenType _tmp9_ = 0;
		TrackerSparqlQueryTokenInfo* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gint _tmp11_ = 0;
		TrackerSourceLocation _tmp12_ = {0};
		TrackerSparqlQueryTokenInfo* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		gint _tmp14_ = 0;
		TrackerSourceLocation _tmp15_ = {0};
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = self->priv->scanner;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = tracker_sparql_scanner_read_token (_tmp3_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		begin = _tmp4_;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		end = _tmp5_;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		type = _tmp6_;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return FALSE;
#line 3283 "tracker-sparql-query.c"
			} else {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return FALSE;
#line 3291 "tracker-sparql-query.c"
			}
		}
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = self->priv->tokens;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7__length1 = self->priv->tokens_length1;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = self->priv->index;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = type;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_[_tmp8_].type = _tmp9_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = self->priv->tokens;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10__length1 = self->priv->tokens_length1;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = self->priv->index;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = begin;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_[_tmp11_].begin = _tmp12_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = self->priv->tokens;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13__length1 = self->priv->tokens_length1;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = self->priv->index;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp15_ = end;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_[_tmp14_].end = _tmp15_;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->size = 1;
#line 3326 "tracker-sparql-query.c"
	}
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp16_ = self->priv->tokens;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp16__length1 = self->priv->tokens_length1;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp17_ = self->priv->index;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp18_ = _tmp16_[_tmp17_];
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp19_ = _tmp18_.type;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp19_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3342 "tracker-sparql-query.c"
}


TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQueryTokenInfo* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	TrackerSparqlQueryTokenInfo _tmp2_ = {0};
	TrackerSparqlTokenType _tmp3_ = 0;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->tokens;
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->index;
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.type;
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp3_;
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3369 "tracker-sparql-query.c"
}


TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self) {
	TrackerSparqlTokenType result = 0;
	gint last_index = 0;
	gint _tmp0_ = 0;
	TrackerSparqlQueryTokenInfo* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	TrackerSparqlQueryTokenInfo _tmp2_ = {0};
	TrackerSparqlTokenType _tmp3_ = 0;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->index;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	last_index = ((_tmp0_ + TRACKER_SPARQL_QUERY_BUFFER_SIZE) - 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->tokens;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1__length1 = self->priv->tokens_length1;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp1_[last_index];
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.type;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp3_;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3399 "tracker-sparql-query.c"
}


gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlTokenType _tmp0_ = 0;
	TrackerSparqlTokenType _tmp1_ = 0;
	GError * _inner_error_ = NULL;
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = tracker_sparql_query_current (self);
#line 340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = type;
#line 340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_ == _tmp1_) {
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_next (self, &_inner_error_);
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return FALSE;
#line 3426 "tracker-sparql-query.c"
			} else {
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return FALSE;
#line 3434 "tracker-sparql-query.c"
			}
		}
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		result = TRUE;
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return result;
#line 3441 "tracker-sparql-query.c"
	}
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = FALSE;
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3447 "tracker-sparql-query.c"
}


GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQueryTokenInfo* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	TrackerSparqlQueryTokenInfo _tmp2_ = {0};
	TrackerSourceLocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	TrackerSparqlQueryTokenInfo* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp6_ = 0;
	TrackerSparqlQueryTokenInfo _tmp7_ = {0};
	TrackerSourceLocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GError* _tmp13_ = NULL;
	GError* _tmp14_ = NULL;
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->tokens;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->index;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.begin;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_.line;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = self->priv->tokens;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5__length1 = self->priv->tokens_length1;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->index;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp5_[_tmp6_];
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_.begin;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _tmp8_.column;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = msg;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = g_strdup_printf ("%d.%d: syntax error, %s", _tmp4_, _tmp9_, _tmp10_);
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = _tmp11_;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp12_);
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = _tmp13_;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp12_);
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp14_;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3514 "tracker-sparql-query.c"
}


GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQueryTokenInfo* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	TrackerSparqlQueryTokenInfo _tmp2_ = {0};
	TrackerSourceLocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	TrackerSparqlQueryTokenInfo* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp6_ = 0;
	TrackerSparqlQueryTokenInfo _tmp7_ = {0};
	TrackerSourceLocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GError* _tmp13_ = NULL;
	GError* _tmp14_ = NULL;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->tokens;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->index;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.begin;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_.line;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = self->priv->tokens;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5__length1 = self->priv->tokens_length1;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->index;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp5_[_tmp6_];
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_.begin;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _tmp8_.column;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = msg;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = g_strdup_printf ("%d.%d: %s", _tmp4_, _tmp9_, _tmp10_);
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = _tmp11_;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp12_);
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = _tmp13_;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp12_);
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp14_;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3581 "tracker-sparql-query.c"
}


gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlTokenType _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	TrackerSparqlTokenType _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GError* _tmp7_ = NULL;
	GError* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = type;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = tracker_sparql_query_accept (self, _tmp1_, &_inner_error_);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = _tmp2_;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return FALSE;
#line 3613 "tracker-sparql-query.c"
		} else {
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return FALSE;
#line 3621 "tracker-sparql-query.c"
		}
	}
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_) {
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		result = TRUE;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return result;
#line 3630 "tracker-sparql-query.c"
	}
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = type;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = tracker_sparql_token_type_to_string (_tmp3_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = g_strdup_printf ("expected %s", _tmp4_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = _tmp5_;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = tracker_sparql_query_get_error (self, _tmp6_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp6_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_inner_error_ = _tmp8_;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return FALSE;
#line 3654 "tracker-sparql-query.c"
	} else {
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_clear_error (&_inner_error_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return FALSE;
#line 3662 "tracker-sparql-query.c"
	}
}


void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result) {
	TrackerSparqlQueryTokenInfo* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	TrackerSparqlQueryTokenInfo _tmp2_ = {0};
	TrackerSourceLocation _tmp3_ = {0};
#line 363 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->tokens;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->index;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.begin;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	*result = _tmp3_;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return;
#line 3689 "tracker-sparql-query.c"
}


void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location) {
	TrackerSparqlScanner* _tmp0_ = NULL;
	TrackerSourceLocation _tmp1_ = {0};
	GError * _inner_error_ = NULL;
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (location != NULL);
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->scanner;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = *location;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_scanner_seek (_tmp0_, &_tmp1_);
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->size = 0;
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->index = 0;
#line 3711 "tracker-sparql-query.c"
	{
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_next (self, &_inner_error_);
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3719 "tracker-sparql-query.c"
				goto __catch2_tracker_sparql_error;
			}
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 3728 "tracker-sparql-query.c"
		}
	}
	goto __finally2;
	__catch2_tracker_sparql_error:
	{
		GError* e = NULL;
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		e = _inner_error_;
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = NULL;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_critical ("internal error: next in set_location failed");
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_error_free0 (e);
#line 3743 "tracker-sparql-query.c"
	}
	__finally2:
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_clear_error (&_inner_error_);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 3754 "tracker-sparql-query.c"
	}
}


gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip) {
	gchar* result = NULL;
	gint last_index = 0;
	gint _tmp0_ = 0;
	TrackerSparqlQueryTokenInfo* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	TrackerSparqlQueryTokenInfo _tmp2_ = {0};
	TrackerSourceLocation _tmp3_ = {0};
	gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	TrackerSparqlQueryTokenInfo* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	TrackerSparqlQueryTokenInfo _tmp7_ = {0};
	TrackerSourceLocation _tmp8_ = {0};
	gchar* _tmp9_ = NULL;
	TrackerSparqlQueryTokenInfo* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	TrackerSparqlQueryTokenInfo _tmp11_ = {0};
	TrackerSourceLocation _tmp12_ = {0};
	gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar* _tmp15_ = NULL;
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->index;
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	last_index = ((_tmp0_ + TRACKER_SPARQL_QUERY_BUFFER_SIZE) - 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->tokens;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1__length1 = self->priv->tokens_length1;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp1_[last_index];
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.begin;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_.pos;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = strip;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->tokens;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6__length1 = self->priv->tokens_length1;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp6_[last_index];
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_.end;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _tmp8_.pos;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = self->priv->tokens;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10__length1 = self->priv->tokens_length1;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = _tmp10_[last_index];
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = _tmp11_.begin;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = _tmp12_.pos;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = strip;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp15_ = string_substring ((const gchar*) (_tmp4_ + _tmp5_), (glong) 0, (glong) ((gint) ((_tmp9_ - _tmp13_) - (2 * _tmp14_))));
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp15_;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3827 "tracker-sparql-query.c"
}


static void tracker_sparql_query_parse_prologue (TrackerSparqlQuery* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BASE, &_inner_error_);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = _tmp1_;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 3849 "tracker-sparql-query.c"
		} else {
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 3857 "tracker-sparql-query.c"
		}
	}
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_) {
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3872 "tracker-sparql-query.c"
			} else {
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3880 "tracker-sparql-query.c"
			}
		}
	}
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 3886 "tracker-sparql-query.c"
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gchar* ns = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gchar* uri = NULL;
		gchar* _tmp8_ = NULL;
		GHashTable* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PREFIX, &_inner_error_);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = _tmp3_;
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3912 "tracker-sparql-query.c"
			} else {
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3920 "tracker-sparql-query.c"
			}
		}
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp2_) {
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 3927 "tracker-sparql-query.c"
		}
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = g_strdup ("");
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ns = _tmp4_;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = _tmp6_;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3947 "tracker-sparql-query.c"
			} else {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3957 "tracker-sparql-query.c"
			}
		}
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp5_) {
#line 3962 "tracker-sparql-query.c"
			gchar* _tmp7_ = NULL;
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = tracker_sparql_query_get_last_string (self, 0);
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (ns);
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			ns = _tmp7_;
#line 3970 "tracker-sparql-query.c"
		}
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3984 "tracker-sparql-query.c"
			} else {
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3994 "tracker-sparql-query.c"
			}
		}
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 4009 "tracker-sparql-query.c"
			} else {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 4019 "tracker-sparql-query.c"
			}
		}
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = tracker_sparql_query_get_last_string (self, 1);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		uri = _tmp8_;
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = self->priv->prefix_map;
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = ns;
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = uri;
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_hash_table_insert (_tmp9_, _tmp11_, _tmp13_);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (uri);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (ns);
#line 4042 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_query_prepare_execute (TrackerSparqlQuery* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	TrackerSparqlScanner* _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	TrackerNamespace** _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->update_extensions;
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_vala_assert (!_tmp0_, "!update_extensions");
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->query_string;
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->priv->query_string;
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = strlen (_tmp2_);
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_;
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = tracker_sparql_scanner_new ((gchar*) _tmp1_, (gsize) ((glong) _tmp4_));
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->priv->scanner);
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->scanner = _tmp5_;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_next (self, &_inner_error_);
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 4090 "tracker-sparql-query.c"
		} else {
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 4098 "tracker-sparql-query.c"
		}
	}
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->prefix_map;
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = g_strdup ("fn");
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = g_strdup (TRACKER_SPARQL_QUERY_FN_NS);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = tracker_ontologies_get_namespaces (&_tmp9_);
#line 4111 "tracker-sparql-query.c"
	{
		TrackerNamespace** ns_collection = NULL;
		gint ns_collection_length1 = 0;
		gint _ns_collection_size_ = 0;
		gint ns_it = 0;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ns_collection = _tmp10_;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ns_collection_length1 = _tmp9_;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		for (ns_it = 0; ns_it < _tmp9_; ns_it = ns_it + 1) {
#line 4123 "tracker-sparql-query.c"
			TrackerNamespace* _tmp11_ = NULL;
			TrackerNamespace* ns = NULL;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp11_ = _g_object_ref0 (ns_collection[ns_it]);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			ns = _tmp11_;
#line 4130 "tracker-sparql-query.c"
			{
				TrackerNamespace* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				GHashTable* _tmp18_ = NULL;
				TrackerNamespace* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				TrackerNamespace* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp12_ = ns;
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp13_ = tracker_namespace_get_prefix (_tmp12_);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp14_ = _tmp13_;
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp14_ == NULL) {
#line 4152 "tracker-sparql-query.c"
					TrackerNamespace* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp15_ = ns;
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp16_ = tracker_namespace_get_uri (_tmp15_);
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp17_ = _tmp16_;
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("Namespace does not specify a prefix: %s", _tmp17_);
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_object_unref0 (ns);
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					continue;
#line 4168 "tracker-sparql-query.c"
				}
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18_ = self->priv->prefix_map;
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp19_ = ns;
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp20_ = tracker_namespace_get_prefix (_tmp19_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp21_ = _tmp20_;
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp22_ = g_strdup (_tmp21_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp23_ = ns;
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp24_ = tracker_namespace_get_uri (_tmp23_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp25_ = _tmp24_;
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp26_ = g_strdup (_tmp25_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_hash_table_insert (_tmp18_, _tmp22_, _tmp26_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (ns);
#line 4192 "tracker-sparql-query.c"
			}
		}
	}
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_parse_prologue (self, &_inner_error_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 4206 "tracker-sparql-query.c"
		} else {
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 4214 "tracker-sparql-query.c"
		}
	}
}


TrackerDBCursor* tracker_sparql_query_execute_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error) {
	TrackerDBCursor* result = NULL;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_prepare_execute (self, &_inner_error_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4236 "tracker-sparql-query.c"
		} else {
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4244 "tracker-sparql-query.c"
		}
	}
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = tracker_sparql_query_current (self);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (_tmp0_) {
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
#line 4253 "tracker-sparql-query.c"
		{
			TrackerDBCursor* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
			TrackerDBCursor* _tmp3_ = NULL;
			TrackerDBCursor* _tmp4_ = NULL;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp2_ = threadsafe;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp3_ = tracker_sparql_query_execute_select_cursor (self, _tmp2_, &_inner_error_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp1_ = _tmp3_;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 4273 "tracker-sparql-query.c"
				} else {
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 4281 "tracker-sparql-query.c"
				}
			}
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp4_ = _tmp1_;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp1_ = NULL;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			result = _tmp4_;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (_tmp1_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return result;
#line 4294 "tracker-sparql-query.c"
		}
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
#line 4298 "tracker-sparql-query.c"
		{
			GError* _tmp5_ = NULL;
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = tracker_sparql_query_get_internal_error (self, "CONSTRUCT is not supported");
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp5_;
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4311 "tracker-sparql-query.c"
			} else {
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4319 "tracker-sparql-query.c"
			}
		}
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
#line 4324 "tracker-sparql-query.c"
		{
			GError* _tmp6_ = NULL;
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = tracker_sparql_query_get_internal_error (self, "DESCRIBE is not supported");
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp6_;
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4337 "tracker-sparql-query.c"
			} else {
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4345 "tracker-sparql-query.c"
			}
		}
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASK:
#line 4350 "tracker-sparql-query.c"
		{
			TrackerDBCursor* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			TrackerDBCursor* _tmp9_ = NULL;
			TrackerDBCursor* _tmp10_ = NULL;
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp8_ = threadsafe;
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = tracker_sparql_query_execute_ask_cursor (self, _tmp8_, &_inner_error_);
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = _tmp9_;
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 4370 "tracker-sparql-query.c"
				} else {
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 4378 "tracker-sparql-query.c"
				}
			}
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = _tmp7_;
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = NULL;
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			result = _tmp10_;
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (_tmp7_);
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return result;
#line 4391 "tracker-sparql-query.c"
		}
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DROP:
#line 4399 "tracker-sparql-query.c"
		{
			GError* _tmp11_ = NULL;
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp11_ = tracker_sparql_query_get_error (self, "INSERT and DELETE are not supported in query mode");
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp11_;
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4412 "tracker-sparql-query.c"
			} else {
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4420 "tracker-sparql-query.c"
			}
		}
		default:
		{
			GError* _tmp12_ = NULL;
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp12_ = tracker_sparql_query_get_error (self, "expected SELECT or ASK");
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp12_;
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4436 "tracker-sparql-query.c"
			} else {
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4444 "tracker-sparql-query.c"
			}
		}
	}
}


GVariant* tracker_sparql_query_execute_update (TrackerSparqlQuery* self, gboolean blank, GError** error) {
	GVariant* result = NULL;
	GVariant* _result_ = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	TrackerSparqlScanner* _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	TrackerNamespace** _tmp10_ = NULL;
	GVariantBuilder* ublank_nodes = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp38_ = FALSE;
	GError * _inner_error_ = NULL;
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_result_ = NULL;
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->update_extensions;
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_vala_assert (_tmp0_, "update_extensions");
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->query_string;
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->priv->query_string;
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = strlen (_tmp2_);
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_;
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = tracker_sparql_scanner_new ((gchar*) _tmp1_, (gsize) ((glong) _tmp4_));
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->priv->scanner);
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->scanner = _tmp5_;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_next (self, &_inner_error_);
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_variant_unref0 (_result_);
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return NULL;
#line 4501 "tracker-sparql-query.c"
	}
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->prefix_map;
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = g_strdup ("fn");
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = g_strdup (TRACKER_SPARQL_QUERY_FN_NS);
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = tracker_ontologies_get_namespaces (&_tmp9_);
#line 4513 "tracker-sparql-query.c"
	{
		TrackerNamespace** ns_collection = NULL;
		gint ns_collection_length1 = 0;
		gint _ns_collection_size_ = 0;
		gint ns_it = 0;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ns_collection = _tmp10_;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ns_collection_length1 = _tmp9_;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		for (ns_it = 0; ns_it < _tmp9_; ns_it = ns_it + 1) {
#line 4525 "tracker-sparql-query.c"
			TrackerNamespace* _tmp11_ = NULL;
			TrackerNamespace* ns = NULL;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp11_ = _g_object_ref0 (ns_collection[ns_it]);
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			ns = _tmp11_;
#line 4532 "tracker-sparql-query.c"
			{
				TrackerNamespace* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				GHashTable* _tmp18_ = NULL;
				TrackerNamespace* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				TrackerNamespace* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp12_ = ns;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp13_ = tracker_namespace_get_prefix (_tmp12_);
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp14_ = _tmp13_;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp14_ == NULL) {
#line 4554 "tracker-sparql-query.c"
					TrackerNamespace* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp15_ = ns;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp16_ = tracker_namespace_get_uri (_tmp15_);
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp17_ = _tmp16_;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("Namespace does not specify a prefix: %s", _tmp17_);
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_object_unref0 (ns);
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					continue;
#line 4570 "tracker-sparql-query.c"
				}
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18_ = self->priv->prefix_map;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp19_ = ns;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp20_ = tracker_namespace_get_prefix (_tmp19_);
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp21_ = _tmp20_;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp22_ = g_strdup (_tmp21_);
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp23_ = ns;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp24_ = tracker_namespace_get_uri (_tmp23_);
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp25_ = _tmp24_;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp26_ = g_strdup (_tmp25_);
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_hash_table_insert (_tmp18_, _tmp22_, _tmp26_);
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (ns);
#line 4594 "tracker-sparql-query.c"
			}
		}
	}
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_parse_prologue (self, &_inner_error_);
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_variant_unref0 (_result_);
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return NULL;
#line 4608 "tracker-sparql-query.c"
	}
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	ublank_nodes = NULL;
#line 466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp27_ = blank;
#line 466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp27_) {
#line 4616 "tracker-sparql-query.c"
		GVariantBuilder* _tmp28_ = NULL;
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp28_ = g_variant_builder_new ((const GVariantType*) "aaa{ss}");
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_variant_builder_unref0 (ublank_nodes);
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ublank_nodes = _tmp28_;
#line 4624 "tracker-sparql-query.c"
	}
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 4628 "tracker-sparql-query.c"
		TrackerSparqlTokenType _tmp29_ = 0;
		TrackerSparqlTokenType _tmp30_ = 0;
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp29_ = tracker_sparql_query_current (self);
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!(_tmp29_ != TRACKER_SPARQL_TOKEN_TYPE_EOF)) {
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 4637 "tracker-sparql-query.c"
		}
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp30_ = tracker_sparql_query_current (self);
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		switch (_tmp30_) {
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_WITH:
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
#line 4649 "tracker-sparql-query.c"
			{
				gboolean _tmp31_ = FALSE;
#line 475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp31_ = blank;
#line 475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp31_) {
#line 4656 "tracker-sparql-query.c"
					GVariantBuilder* _tmp32_ = NULL;
					GVariantBuilder* _tmp33_ = NULL;
					GVariantBuilder* _tmp34_ = NULL;
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp32_ = ublank_nodes;
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_variant_builder_open (_tmp32_, (const GVariantType*) "aa{ss}");
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp33_ = ublank_nodes;
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_execute_insert_delete (self, _tmp33_, &_inner_error_);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_variant_builder_unref0 (ublank_nodes);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_variant_unref0 (_result_);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 4678 "tracker-sparql-query.c"
					}
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp34_ = ublank_nodes;
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_variant_builder_close (_tmp34_);
#line 4684 "tracker-sparql-query.c"
				} else {
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_execute_insert_delete (self, NULL, &_inner_error_);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_variant_builder_unref0 (ublank_nodes);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_variant_unref0 (_result_);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 4698 "tracker-sparql-query.c"
					}
				}
#line 482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				break;
#line 4703 "tracker-sparql-query.c"
			}
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_DROP:
#line 4707 "tracker-sparql-query.c"
			{
				GError* _tmp35_ = NULL;
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp35_ = tracker_sparql_query_get_internal_error (self, "DROP GRAPH is not supported");
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_inner_error_ = _tmp35_;
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_builder_unref0 (ublank_nodes);
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_unref0 (_result_);
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4722 "tracker-sparql-query.c"
			}
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_ASK:
#line 4732 "tracker-sparql-query.c"
			{
				GError* _tmp36_ = NULL;
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp36_ = tracker_sparql_query_get_error (self, "SELECT, CONSTRUCT, DESCRIBE, and ASK are not supported in update mode");
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_inner_error_ = _tmp36_;
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_builder_unref0 (ublank_nodes);
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_unref0 (_result_);
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4747 "tracker-sparql-query.c"
			}
			default:
			{
				GError* _tmp37_ = NULL;
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp37_ = tracker_sparql_query_get_error (self, "expected INSERT or DELETE");
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_inner_error_ = _tmp37_;
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_builder_unref0 (ublank_nodes);
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_unref0 (_result_);
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4764 "tracker-sparql-query.c"
			}
		}
#line 496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
#line 496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_variant_builder_unref0 (ublank_nodes);
#line 496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_variant_unref0 (_result_);
#line 496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4779 "tracker-sparql-query.c"
		}
	}
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp38_ = blank;
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp38_) {
#line 4786 "tracker-sparql-query.c"
		GVariantBuilder* _tmp39_ = NULL;
		GVariant* _tmp40_ = NULL;
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp39_ = ublank_nodes;
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp40_ = g_variant_builder_end (_tmp39_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_variant_ref_sink (_tmp40_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_variant_unref0 (_result_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_result_ = _tmp40_;
#line 4799 "tracker-sparql-query.c"
	}
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _result_;
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_variant_builder_unref0 (ublank_nodes);
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 4807 "tracker-sparql-query.c"
}


static TrackerDBStatement* tracker_sparql_query_prepare_for_exec (TrackerSparqlQuery* self, const gchar* sql, GError** error) {
	TrackerDBStatement* result = NULL;
	TrackerDBInterface* iface = NULL;
	TrackerDBInterface* _tmp0_ = NULL;
	TrackerDBInterface* _tmp1_ = NULL;
	TrackerDBInterface* _tmp2_ = NULL;
	TrackerDBStatementCacheType _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	TrackerDBStatement* stmt = NULL;
	TrackerDBInterface* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	TrackerDBStatement* _tmp8_ = NULL;
	gint i = 0;
	GList* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = tracker_db_manager_get_db_interface ();
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	iface = _tmp1_;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = iface;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp2_ == NULL) {
#line 4840 "tracker-sparql-query.c"
		GError* _tmp3_ = NULL;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = g_error_new_literal (TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_OPEN_ERROR, "Error opening database");
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = _tmp3_;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4854 "tracker-sparql-query.c"
		} else {
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4864 "tracker-sparql-query.c"
		}
	}
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = self->priv->_no_cache;
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp5_) {
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = TRACKER_DB_STATEMENT_CACHE_TYPE_NONE;
#line 4873 "tracker-sparql-query.c"
	} else {
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT;
#line 4877 "tracker-sparql-query.c"
	}
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = iface;
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = sql;
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = tracker_db_interface_create_statement (_tmp6_, _tmp4_, &_inner_error_, "%s", _tmp7_);
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	stmt = _tmp8_;
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4897 "tracker-sparql-query.c"
		} else {
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4907 "tracker-sparql-query.c"
		}
	}
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	i = 0;
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = self->bindings;
#line 4914 "tracker-sparql-query.c"
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		binding_collection = _tmp9_;
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 4922 "tracker-sparql-query.c"
			TrackerSparqlLiteralBinding* _tmp10_ = NULL;
			TrackerSparqlLiteralBinding* binding = NULL;
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			binding = _tmp10_;
#line 4929 "tracker-sparql-query.c"
			{
				TrackerSparqlLiteralBinding* _tmp11_ = NULL;
				TrackerPropertyType _tmp12_ = 0;
				gint _tmp63_ = 0;
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp11_ = binding;
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp12_ = ((TrackerSparqlDataBinding*) _tmp11_)->data_type;
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp12_ == TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 4940 "tracker-sparql-query.c"
					gboolean _tmp13_ = FALSE;
					TrackerSparqlLiteralBinding* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp14_ = binding;
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp15_ = _tmp14_->literal;
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (g_strcmp0 (_tmp15_, "true") == 0) {
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp13_ = TRUE;
#line 4952 "tracker-sparql-query.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp16_ = NULL;
						const gchar* _tmp17_ = NULL;
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp16_ = binding;
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp17_ = _tmp16_->literal;
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp13_ = g_strcmp0 (_tmp17_, "1") == 0;
#line 4962 "tracker-sparql-query.c"
					}
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp13_) {
#line 4966 "tracker-sparql-query.c"
						TrackerDBStatement* _tmp18_ = NULL;
						gint _tmp19_ = 0;
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp18_ = stmt;
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp19_ = i;
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						tracker_db_statement_bind_int (_tmp18_, _tmp19_, 1);
#line 4975 "tracker-sparql-query.c"
					} else {
						gboolean _tmp20_ = FALSE;
						TrackerSparqlLiteralBinding* _tmp21_ = NULL;
						const gchar* _tmp22_ = NULL;
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp21_ = binding;
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp22_ = _tmp21_->literal;
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (g_strcmp0 (_tmp22_, "false") == 0) {
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp20_ = TRUE;
#line 4988 "tracker-sparql-query.c"
						} else {
							TrackerSparqlLiteralBinding* _tmp23_ = NULL;
							const gchar* _tmp24_ = NULL;
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp23_ = binding;
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp24_ = _tmp23_->literal;
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp20_ = g_strcmp0 (_tmp24_, "0") == 0;
#line 4998 "tracker-sparql-query.c"
						}
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_tmp20_) {
#line 5002 "tracker-sparql-query.c"
							TrackerDBStatement* _tmp25_ = NULL;
							gint _tmp26_ = 0;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp25_ = stmt;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp26_ = i;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							tracker_db_statement_bind_int (_tmp25_, _tmp26_, 0);
#line 5011 "tracker-sparql-query.c"
						} else {
							TrackerSparqlLiteralBinding* _tmp27_ = NULL;
							const gchar* _tmp28_ = NULL;
							gchar* _tmp29_ = NULL;
							gchar* _tmp30_ = NULL;
							GError* _tmp31_ = NULL;
							GError* _tmp32_ = NULL;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp27_ = binding;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp28_ = _tmp27_->literal;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp29_ = g_strdup_printf ("`%s' is not a valid boolean", _tmp28_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp30_ = _tmp29_;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp31_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_TYPE, _tmp30_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp32_ = _tmp31_;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_tmp30_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_inner_error_ = _tmp32_;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (binding);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (stmt);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (iface);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 5047 "tracker-sparql-query.c"
							} else {
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (binding);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (stmt);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (iface);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 5061 "tracker-sparql-query.c"
							}
						}
					}
				} else {
					TrackerSparqlLiteralBinding* _tmp33_ = NULL;
					TrackerPropertyType _tmp34_ = 0;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp33_ = binding;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp34_ = ((TrackerSparqlDataBinding*) _tmp33_)->data_type;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp34_ == TRACKER_PROPERTY_TYPE_DATE) {
#line 5074 "tracker-sparql-query.c"
						gdouble _tmp35_ = 0.0;
						TrackerSparqlLiteralBinding* _tmp36_ = NULL;
						const gchar* _tmp37_ = NULL;
						gchar* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
						gdouble _tmp40_ = 0.0;
						gdouble _tmp41_ = 0.0;
						TrackerDBStatement* _tmp42_ = NULL;
						gint _tmp43_ = 0;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp36_ = binding;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp37_ = _tmp36_->literal;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp38_ = g_strconcat (_tmp37_, "T00:00:00Z", NULL);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp39_ = _tmp38_;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp40_ = tracker_string_to_date (_tmp39_, NULL, &_inner_error_);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp41_ = _tmp40_;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp39_);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp35_ = _tmp41_;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (binding);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (stmt);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (iface);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 5114 "tracker-sparql-query.c"
							} else {
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (binding);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (stmt);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (iface);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 5128 "tracker-sparql-query.c"
							}
						}
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp42_ = stmt;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp43_ = i;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						tracker_db_statement_bind_int (_tmp42_, _tmp43_, (gint) _tmp35_);
#line 5137 "tracker-sparql-query.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp44_ = NULL;
						TrackerPropertyType _tmp45_ = 0;
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp44_ = binding;
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp45_ = ((TrackerSparqlDataBinding*) _tmp44_)->data_type;
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_tmp45_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 5147 "tracker-sparql-query.c"
							gdouble _tmp46_ = 0.0;
							TrackerSparqlLiteralBinding* _tmp47_ = NULL;
							const gchar* _tmp48_ = NULL;
							gdouble _tmp49_ = 0.0;
							TrackerDBStatement* _tmp50_ = NULL;
							gint _tmp51_ = 0;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp47_ = binding;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp48_ = _tmp47_->literal;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp49_ = tracker_string_to_date (_tmp48_, NULL, &_inner_error_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp46_ = _tmp49_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_propagate_error (error, _inner_error_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_object_unref0 (binding);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_object_unref0 (stmt);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_object_unref0 (iface);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 5176 "tracker-sparql-query.c"
								} else {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_object_unref0 (binding);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_object_unref0 (stmt);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_object_unref0 (iface);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_clear_error (&_inner_error_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 5190 "tracker-sparql-query.c"
								}
							}
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp50_ = stmt;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp51_ = i;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							tracker_db_statement_bind_double (_tmp50_, _tmp51_, _tmp46_);
#line 5199 "tracker-sparql-query.c"
						} else {
							TrackerSparqlLiteralBinding* _tmp52_ = NULL;
							TrackerPropertyType _tmp53_ = 0;
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp52_ = binding;
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp53_ = ((TrackerSparqlDataBinding*) _tmp52_)->data_type;
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (_tmp53_ == TRACKER_PROPERTY_TYPE_INTEGER) {
#line 5209 "tracker-sparql-query.c"
								TrackerDBStatement* _tmp54_ = NULL;
								gint _tmp55_ = 0;
								TrackerSparqlLiteralBinding* _tmp56_ = NULL;
								const gchar* _tmp57_ = NULL;
								gint _tmp58_ = 0;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp54_ = stmt;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp55_ = i;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp56_ = binding;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp57_ = _tmp56_->literal;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp58_ = atoi (_tmp57_);
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								tracker_db_statement_bind_int (_tmp54_, _tmp55_, _tmp58_);
#line 5227 "tracker-sparql-query.c"
							} else {
								TrackerDBStatement* _tmp59_ = NULL;
								gint _tmp60_ = 0;
								TrackerSparqlLiteralBinding* _tmp61_ = NULL;
								const gchar* _tmp62_ = NULL;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp59_ = stmt;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp60_ = i;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp61_ = binding;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp62_ = _tmp61_->literal;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								tracker_db_statement_bind_text (_tmp59_, _tmp60_, _tmp62_);
#line 5243 "tracker-sparql-query.c"
							}
						}
					}
				}
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp63_ = i;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				i = _tmp63_ + 1;
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (binding);
#line 5254 "tracker-sparql-query.c"
			}
		}
	}
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = stmt;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (iface);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 5264 "tracker-sparql-query.c"
}


static TrackerDBCursor* tracker_sparql_query_exec_sql_cursor (TrackerSparqlQuery* self, const gchar* sql, TrackerPropertyType* types, int types_length1, gchar** variable_names, int variable_names_length1, gboolean threadsafe, GError** error) {
	TrackerDBCursor* result = NULL;
	TrackerDBStatement* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	TrackerDBStatement* _tmp1_ = NULL;
	TrackerDBCursor* _tmp2_ = NULL;
	TrackerDBStatement* _tmp3_ = NULL;
	TrackerPropertyType* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gboolean _tmp6_ = FALSE;
	TrackerDBCursor* _tmp7_ = NULL;
	TrackerDBCursor* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = sql;
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_prepare_for_exec (self, _tmp0_, &_inner_error_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	stmt = _tmp1_;
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5301 "tracker-sparql-query.c"
		} else {
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5309 "tracker-sparql-query.c"
		}
	}
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = stmt;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = types;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4__length1 = types_length1;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = variable_names;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5__length1 = variable_names_length1;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = threadsafe;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = tracker_db_statement_start_sparql_cursor (_tmp3_, _tmp4_, _tmp4__length1, _tmp5_, _tmp5__length1, _tmp6_, &_inner_error_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp7_;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (stmt);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5338 "tracker-sparql-query.c"
		} else {
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (stmt);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5348 "tracker-sparql-query.c"
		}
	}
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp2_;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = NULL;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp8_;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (_tmp2_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (stmt);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 5363 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_query_get_select_query (TrackerSparqlQuery* self, TrackerSparqlSelectContext** context, GError** error) {
	TrackerSparqlSelectContext* _vala_context = NULL;
	gchar* result = NULL;
	GString* sql = NULL;
	GString* _tmp0_ = NULL;
	TrackerSparqlSelectContext* _tmp1_ = NULL;
	TrackerSparqlPattern* _tmp2_ = NULL;
	GString* _tmp3_ = NULL;
	TrackerSparqlSelectContext* _tmp4_ = NULL;
	TrackerSparqlSelectContext* _tmp5_ = NULL;
	GString* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_string_new ("");
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	sql = _tmp0_;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->pattern;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = sql;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = tracker_sparql_pattern_translate_select (_tmp2_, _tmp3_, FALSE, FALSE, &_inner_error_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = _tmp4_;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5405 "tracker-sparql-query.c"
		} else {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5415 "tracker-sparql-query.c"
		}
	}
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = _tmp1_;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = NULL;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (_vala_context);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_vala_context = _tmp5_;
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EOF, &_inner_error_);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp1_);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5440 "tracker-sparql-query.c"
		} else {
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp1_);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5452 "tracker-sparql-query.c"
		}
	}
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = sql;
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp6_->str;
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp8_;
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (_tmp1_);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_string_free0 (sql);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (context) {
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*context = _vala_context;
#line 5471 "tracker-sparql-query.c"
	} else {
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_sparql_context_unref0 (_vala_context);
#line 5475 "tracker-sparql-query.c"
	}
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 5479 "tracker-sparql-query.c"
}


static TrackerDBCursor* tracker_sparql_query_execute_select_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error) {
	TrackerDBCursor* result = NULL;
	TrackerSparqlSelectContext* context = NULL;
	gchar* sql = NULL;
	TrackerSparqlSelectContext* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	TrackerDBCursor* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	TrackerSparqlSelectContext* _tmp4_ = NULL;
	TrackerPropertyType* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	TrackerSparqlSelectContext* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	TrackerDBCursor* _tmp8_ = NULL;
	TrackerDBCursor* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_get_select_query (self, &_tmp0_, &_inner_error_);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (context);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	context = _tmp0_;
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	sql = _tmp1_;
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (context);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5520 "tracker-sparql-query.c"
		} else {
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (context);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5530 "tracker-sparql-query.c"
		}
	}
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = sql;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = context;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = _tmp4_->types;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5__length1 = _tmp4_->types_length1;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = context;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp6_->variable_names;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7__length1 = _tmp6_->variable_names_length1;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = tracker_sparql_query_exec_sql_cursor (self, _tmp3_, _tmp5_, _tmp5__length1, _tmp7_, _tmp7__length1, TRUE, &_inner_error_);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp8_;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (sql);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (context);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5563 "tracker-sparql-query.c"
		} else {
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (sql);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (context);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5575 "tracker-sparql-query.c"
		}
	}
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _tmp2_;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = NULL;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp9_;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (_tmp2_);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (sql);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (context);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 5592 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_query_get_ask_query (TrackerSparqlQuery* self, GError** error) {
	gchar* result = NULL;
	GString* pattern_sql = NULL;
	GString* _tmp0_ = NULL;
	GString* sql = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	TrackerSparqlContext* _tmp3_ = NULL;
	TrackerSparqlPattern* _tmp4_ = NULL;
	GString* _tmp5_ = NULL;
	TrackerSparqlContext* _tmp6_ = NULL;
	TrackerSparqlContext* _tmp7_ = NULL;
	GString* _tmp8_ = NULL;
	GString* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GString* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	TrackerSparqlContext* _tmp29_ = NULL;
	TrackerSparqlContext* _tmp30_ = NULL;
	TrackerSparqlContext* _tmp31_ = NULL;
	GString* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_string_new ("");
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	pattern_sql = _tmp0_;
#line 571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_string_new ("");
#line 571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	sql = _tmp1_;
#line 572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = sql;
#line 572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp2_, "SELECT CASE EXISTS ( ");
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ASK, &_inner_error_);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5652 "tracker-sparql-query.c"
		} else {
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5664 "tracker-sparql-query.c"
		}
	}
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5681 "tracker-sparql-query.c"
		} else {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5693 "tracker-sparql-query.c"
		}
	}
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = self->pattern;
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = pattern_sql;
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = tracker_sparql_pattern_translate_group_graph_pattern (_tmp4_, _tmp5_, &_inner_error_);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp6_;
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5716 "tracker-sparql-query.c"
		} else {
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5728 "tracker-sparql-query.c"
		}
	}
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp3_;
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = NULL;
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->context);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->context = _tmp7_;
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = sql;
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = pattern_sql;
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = _tmp9_->str;
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp8_, _tmp10_);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = sql;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp11_, " ) WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp16_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GROUP, &_inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp15_ = _tmp16_;
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5769 "tracker-sparql-query.c"
		} else {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5783 "tracker-sparql-query.c"
		}
	}
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp15_) {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = TRUE;
#line 5790 "tracker-sparql-query.c"
	} else {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp18_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ORDER, &_inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp17_ = _tmp18_;
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5812 "tracker-sparql-query.c"
			} else {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5826 "tracker-sparql-query.c"
			}
		}
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = _tmp17_;
#line 5831 "tracker-sparql-query.c"
	}
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp14_) {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = TRUE;
#line 5837 "tracker-sparql-query.c"
	} else {
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp20_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp19_ = _tmp20_;
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5859 "tracker-sparql-query.c"
			} else {
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5873 "tracker-sparql-query.c"
			}
		}
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = _tmp19_;
#line 5878 "tracker-sparql-query.c"
	}
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp13_) {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = TRUE;
#line 5884 "tracker-sparql-query.c"
	} else {
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp22_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp21_ = _tmp22_;
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5906 "tracker-sparql-query.c"
			} else {
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5920 "tracker-sparql-query.c"
			}
		}
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = _tmp21_;
#line 5925 "tracker-sparql-query.c"
	}
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp12_) {
#line 5929 "tracker-sparql-query.c"
		TrackerSparqlTokenType _tmp23_ = 0;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		GError* _tmp27_ = NULL;
		GError* _tmp28_ = NULL;
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp23_ = tracker_sparql_query_last (self);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp24_ = tracker_sparql_token_type_to_string (_tmp23_);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp25_ = g_strdup_printf ("invalid use of %s in ASK", _tmp24_);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp26_ = _tmp25_;
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp27_ = tracker_sparql_query_get_error (self, _tmp26_);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp28_ = _tmp27_;
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (_tmp26_);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = _tmp28_;
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5964 "tracker-sparql-query.c"
		} else {
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5978 "tracker-sparql-query.c"
		}
	}
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EOF, &_inner_error_);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5997 "tracker-sparql-query.c"
		} else {
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6011 "tracker-sparql-query.c"
		}
	}
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp29_ = self->context;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp30_ = _tmp29_->parent_context;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp31_ = _tracker_sparql_context_ref0 (_tmp30_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->context);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->context = _tmp31_;
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp32_ = sql;
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp33_ = _tmp32_->str;
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp34_ = g_strdup (_tmp33_);
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp34_;
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (_tmp3_);
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_string_free0 (sql);
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_string_free0 (pattern_sql);
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 6040 "tracker-sparql-query.c"
}


static TrackerDBCursor* tracker_sparql_query_execute_ask_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error) {
	TrackerDBCursor* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	TrackerDBCursor* _tmp2_ = NULL;
	TrackerPropertyType* _tmp3_ = NULL;
	TrackerPropertyType* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	TrackerDBCursor* _tmp8_ = NULL;
	TrackerDBCursor* _tmp9_ = NULL;
	TrackerDBCursor* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_get_ask_query (self, &_inner_error_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = _tmp1_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6074 "tracker-sparql-query.c"
		} else {
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6082 "tracker-sparql-query.c"
		}
	}
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_new0 (TrackerPropertyType, 1);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_[0] = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4__length1 = 1;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = g_strdup ("result");
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = g_new0 (gchar*, 1 + 1);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_[0] = _tmp5_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp6_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7__length1 = 1;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = tracker_sparql_query_exec_sql_cursor (self, _tmp0_, _tmp4_, 1, _tmp7_, 1, TRUE, &_inner_error_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _tmp8_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = (g_free (_tmp4_), NULL);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp9_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp0_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6123 "tracker-sparql-query.c"
		} else {
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp0_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6133 "tracker-sparql-query.c"
		}
	}
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = _tmp2_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = NULL;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp10_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (_tmp2_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp0_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 6148 "tracker-sparql-query.c"
}


static void tracker_sparql_query_parse_from_or_into_param (TrackerSparqlQuery* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = _tmp1_;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6170 "tracker-sparql-query.c"
		} else {
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6178 "tracker-sparql-query.c"
		}
	}
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_) {
#line 6183 "tracker-sparql-query.c"
		gchar* _tmp2_ = NULL;
#line 602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = tracker_sparql_query_get_last_string (self, 1);
#line 602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->current_graph);
#line 602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->current_graph = _tmp2_;
#line 6191 "tracker-sparql-query.c"
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = _tmp4_;
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6207 "tracker-sparql-query.c"
			} else {
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6215 "tracker-sparql-query.c"
			}
		}
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp3_) {
#line 6220 "tracker-sparql-query.c"
			gchar* ns = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = tracker_sparql_query_get_last_string (self, 0);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			ns = _tmp5_;
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (ns);
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6248 "tracker-sparql-query.c"
				} else {
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (ns);
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6258 "tracker-sparql-query.c"
				}
			}
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = ns;
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp8_ = tracker_sparql_query_get_last_string (self, 0);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = _tmp8_;
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) -1);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp11_ = _tmp10_;
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp12_ = tracker_sparql_query_resolve_prefixed_name (self, _tmp7_, _tmp11_, &_inner_error_);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp13_ = _tmp12_;
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp11_);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp9_);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = _tmp13_;
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (ns);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6291 "tracker-sparql-query.c"
				} else {
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (ns);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6301 "tracker-sparql-query.c"
				}
			}
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp14_ = _tmp6_;
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = NULL;
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_graph);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_graph = _tmp14_;
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp6_);
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (ns);
#line 6316 "tracker-sparql-query.c"
		} else {
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6336 "tracker-sparql-query.c"
				} else {
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6344 "tracker-sparql-query.c"
				}
			}
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp16_ = tracker_sparql_query_get_last_string (self, 0);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp17_ = _tmp16_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp18_ = string_substring (_tmp17_, (glong) 1, (glong) -1);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp19_ = _tmp18_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp20_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp19_, &_inner_error_);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp21_ = _tmp20_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp19_);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp17_);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = _tmp21_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6373 "tracker-sparql-query.c"
				} else {
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6381 "tracker-sparql-query.c"
				}
			}
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp22_ = _tmp15_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = NULL;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_graph);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_graph = _tmp22_;
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp15_);
#line 6394 "tracker-sparql-query.c"
		}
	}
}


static gpointer _tracker_source_location_dup0 (gpointer self) {
#line 655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self ? tracker_source_location_dup (self) : NULL;
#line 6403 "tracker-sparql-query.c"
}


static GVariant* _variant_new1 (GHashTable* value) {
	GVariantBuilder _tmp151_;
	GHashTableIter _tmp152_;
	gpointer _tmp153_;
	gpointer _tmp154_;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_hash_table_iter_init (&_tmp152_, value);
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_variant_builder_init (&_tmp151_, G_VARIANT_TYPE ("a{ss}"));
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (g_hash_table_iter_next (&_tmp152_, &_tmp153_, &_tmp154_)) {
#line 6418 "tracker-sparql-query.c"
		gchar* _key;
		gchar* _value;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_key = (gchar*) _tmp153_;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_value = (gchar*) _tmp154_;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_variant_builder_add (&_tmp151_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
#line 6427 "tracker-sparql-query.c"
	}
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return g_variant_ref_sink (g_variant_builder_end (&_tmp151_));
#line 6431 "tracker-sparql-query.c"
}


static void tracker_sparql_query_execute_insert_delete (TrackerSparqlQuery* self, GVariantBuilder* update_blank_nodes, GError** error) {
	gboolean blank = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	TrackerSourceLocation* delete_location = NULL;
	TrackerSourceLocation* insert_location = NULL;
	gboolean insert_is_update = FALSE;
	gboolean delete_where = FALSE;
	gboolean data = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GString* pattern_sql = NULL;
	GString* _tmp42_ = NULL;
	GString* sql = NULL;
	GString* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	TrackerSourceLocation after_where = {0};
	TrackerSourceLocation _tmp60_ = {0};
	TrackerSparqlSolution* solution = NULL;
	TrackerSparqlSolution* _tmp61_ = NULL;
	GString* _tmp62_ = NULL;
	gint var_idx = 0;
	TrackerSparqlContext* _tmp63_ = NULL;
	GHashTable* _tmp64_ = NULL;
	GList* _tmp65_ = NULL;
	gint _tmp91_ = 0;
	GString* _tmp93_ = NULL;
	GString* _tmp94_ = NULL;
	GString* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	GString* _tmp97_ = NULL;
	TrackerDBCursor* cursor = NULL;
	GString* _tmp98_ = NULL;
	const gchar* _tmp99_ = NULL;
	TrackerDBCursor* _tmp100_ = NULL;
	gint n_solutions = 0;
	TrackerSourceLocation* _tmp117_ = NULL;
	TrackerSourceLocation* _tmp128_ = NULL;
	gboolean _tmp156_ = FALSE;
	TrackerSparqlContext* _tmp158_ = NULL;
	TrackerSparqlContext* _tmp159_ = NULL;
	TrackerSparqlContext* _tmp160_ = NULL;
	GError * _inner_error_ = NULL;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	blank = TRUE;
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WITH, &_inner_error_);
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = _tmp1_;
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 6494 "tracker-sparql-query.c"
	}
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_) {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6506 "tracker-sparql-query.c"
		}
	} else {
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->current_graph);
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->current_graph = NULL;
#line 6513 "tracker-sparql-query.c"
	}
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	delete_location = NULL;
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	insert_location = NULL;
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	insert_is_update = FALSE;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	delete_where = FALSE;
#line 628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	data = FALSE;
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DELETE, &_inner_error_);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp3_;
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (insert_location);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (delete_location);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 6539 "tracker-sparql-query.c"
	}
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp2_) {
#line 6543 "tracker-sparql-query.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		blank = FALSE;
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SILENT, &_inner_error_);
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = _tmp5_;
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6568 "tracker-sparql-query.c"
		}
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->silent = _tmp4_;
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = self->priv->current_graph;
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp7_ == NULL) {
#line 6576 "tracker-sparql-query.c"
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp8_ = _tmp9_;
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6593 "tracker-sparql-query.c"
			}
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = _tmp8_;
#line 6597 "tracker-sparql-query.c"
		} else {
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = FALSE;
#line 6601 "tracker-sparql-query.c"
		}
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp6_) {
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6617 "tracker-sparql-query.c"
			}
		}
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = self->priv->current_graph;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp11_ == NULL) {
#line 6624 "tracker-sparql-query.c"
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp13_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DATA, &_inner_error_);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp12_ = _tmp13_;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6641 "tracker-sparql-query.c"
			}
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = _tmp12_;
#line 6645 "tracker-sparql-query.c"
		} else {
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = FALSE;
#line 6649 "tracker-sparql-query.c"
		}
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp10_) {
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			data = TRUE;
#line 6655 "tracker-sparql-query.c"
		} else {
			TrackerSparqlTokenType _tmp14_ = 0;
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp14_ = tracker_sparql_query_current (self);
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp14_ == TRACKER_SPARQL_TOKEN_TYPE_WHERE) {
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				delete_where = TRUE;
#line 6664 "tracker-sparql-query.c"
			}
		}
#line 654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp16_ = data;
#line 654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp16_) {
#line 6671 "tracker-sparql-query.c"
			gboolean _tmp17_ = FALSE;
#line 654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp17_ = delete_where;
#line 654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = !_tmp17_;
#line 6677 "tracker-sparql-query.c"
		} else {
#line 654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = FALSE;
#line 6681 "tracker-sparql-query.c"
		}
#line 654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp15_) {
#line 6685 "tracker-sparql-query.c"
			TrackerSourceLocation _tmp18_ = {0};
			TrackerSourceLocation* _tmp19_ = NULL;
#line 655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_get_location (self, &_tmp18_);
#line 655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp19_ = _tracker_source_location_dup0 (&_tmp18_);
#line 655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			delete_location = _tmp19_;
#line 656 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_skip_braces (self, &_inner_error_);
#line 656 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 656 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 656 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 656 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 656 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6708 "tracker-sparql-query.c"
			}
		}
	}
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp21_ = data;
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!_tmp21_) {
#line 6716 "tracker-sparql-query.c"
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp23_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INSERT, &_inner_error_);
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp22_ = _tmp23_;
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6733 "tracker-sparql-query.c"
		}
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp20_ = _tmp22_;
#line 6737 "tracker-sparql-query.c"
	} else {
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp20_ = FALSE;
#line 6741 "tracker-sparql-query.c"
	}
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp20_) {
#line 6745 "tracker-sparql-query.c"
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp29_ = FALSE;
		const gchar* _tmp30_ = NULL;
		gboolean _tmp33_ = FALSE;
		const gchar* _tmp34_ = NULL;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp25_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OR, &_inner_error_);
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp24_ = _tmp25_;
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6769 "tracker-sparql-query.c"
		}
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp24_) {
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REPLACE, &_inner_error_);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6785 "tracker-sparql-query.c"
			}
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			insert_is_update = TRUE;
#line 6789 "tracker-sparql-query.c"
		}
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp26_ = insert_is_update;
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp26_) {
#line 6795 "tracker-sparql-query.c"
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp28_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SILENT, &_inner_error_);
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp27_ = _tmp28_;
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6812 "tracker-sparql-query.c"
			}
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->silent = _tmp27_;
#line 6816 "tracker-sparql-query.c"
		}
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp30_ = self->priv->current_graph;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp30_ == NULL) {
#line 6822 "tracker-sparql-query.c"
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_ = FALSE;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp32_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INTO, &_inner_error_);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp31_ = _tmp32_;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6839 "tracker-sparql-query.c"
			}
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp29_ = _tmp31_;
#line 6843 "tracker-sparql-query.c"
		} else {
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp29_ = FALSE;
#line 6847 "tracker-sparql-query.c"
		}
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp29_) {
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6863 "tracker-sparql-query.c"
			}
		}
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp34_ = self->priv->current_graph;
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp34_ == NULL) {
#line 6870 "tracker-sparql-query.c"
			gboolean _tmp35_ = FALSE;
			gboolean _tmp36_ = FALSE;
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp36_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DATA, &_inner_error_);
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp35_ = _tmp36_;
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6887 "tracker-sparql-query.c"
			}
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp33_ = _tmp35_;
#line 6891 "tracker-sparql-query.c"
		} else {
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp33_ = FALSE;
#line 6895 "tracker-sparql-query.c"
		}
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp33_) {
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			data = TRUE;
#line 6901 "tracker-sparql-query.c"
		}
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp38_ = data;
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp38_) {
#line 6907 "tracker-sparql-query.c"
			TrackerSparqlTokenType _tmp39_ = 0;
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp39_ = tracker_sparql_query_current (self);
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp37_ = _tmp39_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE;
#line 6913 "tracker-sparql-query.c"
		} else {
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp37_ = FALSE;
#line 6917 "tracker-sparql-query.c"
		}
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp37_) {
#line 6921 "tracker-sparql-query.c"
			TrackerSourceLocation _tmp40_ = {0};
			TrackerSourceLocation* _tmp41_ = NULL;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_get_location (self, &_tmp40_);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp41_ = _tracker_source_location_dup0 (&_tmp40_);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			insert_location = _tmp41_;
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_skip_braces (self, &_inner_error_);
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6944 "tracker-sparql-query.c"
			}
		}
	}
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp42_ = g_string_new ("");
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	pattern_sql = _tmp42_;
#line 689 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp43_ = g_string_new ("");
#line 689 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	sql = _tmp43_;
#line 691 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp44_ = data;
#line 691 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!_tmp44_) {
#line 6960 "tracker-sparql-query.c"
		gboolean _tmp45_ = FALSE;
		gboolean _tmp46_ = FALSE;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp46_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp45_ = _tmp46_;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6981 "tracker-sparql-query.c"
		}
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp45_) {
#line 6985 "tracker-sparql-query.c"
			TrackerSparqlPattern* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			TrackerSparqlContext* _tmp50_ = NULL;
			TrackerSparqlPattern* _tmp51_ = NULL;
			GString* _tmp52_ = NULL;
			TrackerSparqlContext* _tmp53_ = NULL;
			TrackerSparqlContext* _tmp54_ = NULL;
			TrackerSparqlPattern* _tmp55_ = NULL;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp47_ = self->pattern;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp48_ = self->priv->current_graph;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp49_ = g_strdup (_tmp48_);
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp47_->current_graph);
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp47_->current_graph = _tmp49_;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp51_ = self->pattern;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp52_ = pattern_sql;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp53_ = tracker_sparql_pattern_translate_group_graph_pattern (_tmp51_, _tmp52_, &_inner_error_);
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp50_ = _tmp53_;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7027 "tracker-sparql-query.c"
			}
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp54_ = _tmp50_;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp50_ = NULL;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (self->context);
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->context = _tmp54_;
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp55_ = self->pattern;
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp55_->current_graph);
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp55_->current_graph = NULL;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp50_);
#line 7045 "tracker-sparql-query.c"
		} else {
			TrackerSparqlContext* _tmp56_ = NULL;
			GString* _tmp57_ = NULL;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp56_ = tracker_sparql_context_new (self, NULL);
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (self->context);
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->context = _tmp56_;
#line 699 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp57_ = pattern_sql;
#line 699 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_string_append (_tmp57_, "SELECT 1");
#line 7059 "tracker-sparql-query.c"
		}
	} else {
		TrackerSparqlContext* _tmp58_ = NULL;
		GString* _tmp59_ = NULL;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp58_ = tracker_sparql_context_new (self, NULL);
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_sparql_context_unref0 (self->context);
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->context = _tmp58_;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp59_ = pattern_sql;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_string_append (_tmp59_, "SELECT 1");
#line 7074 "tracker-sparql-query.c"
	}
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_get_location (self, &_tmp60_);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	after_where = _tmp60_;
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp61_ = tracker_sparql_solution_new ();
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	solution = _tmp61_;
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp62_ = sql;
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp62_, "SELECT ");
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	var_idx = 0;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp63_ = self->context;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp64_ = _tmp63_->var_set;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp65_ = g_hash_table_get_keys (_tmp64_);
#line 7096 "tracker-sparql-query.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		variable_collection = _tmp65_;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 7104 "tracker-sparql-query.c"
			TrackerSparqlVariable* variable = NULL;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			variable = (TrackerSparqlVariable*) variable_it->data;
#line 7108 "tracker-sparql-query.c"
			{
				gint _tmp66_ = 0;
				TrackerSparqlVariable* _tmp68_ = NULL;
				TrackerSparqlVariableBinding* _tmp69_ = NULL;
				GString* _tmp77_ = NULL;
				TrackerSparqlVariable* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				TrackerSparqlVariable* _tmp81_ = NULL;
				TrackerSparqlVariableBinding* _tmp82_ = NULL;
				TrackerPropertyType _tmp83_ = 0;
				TrackerSparqlSolution* _tmp84_ = NULL;
				GHashTable* _tmp85_ = NULL;
				TrackerSparqlVariable* _tmp86_ = NULL;
				const gchar* _tmp87_ = NULL;
				const gchar* _tmp88_ = NULL;
				gchar* _tmp89_ = NULL;
				gint _tmp90_ = 0;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp66_ = var_idx;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp66_ > 0) {
#line 7131 "tracker-sparql-query.c"
					GString* _tmp67_ = NULL;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp67_ = sql;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_string_append (_tmp67_, ", ");
#line 7137 "tracker-sparql-query.c"
				}
#line 721 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp68_ = variable;
#line 721 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp69_ = _tmp68_->binding;
#line 721 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp69_ == NULL) {
#line 7145 "tracker-sparql-query.c"
					TrackerSparqlVariable* _tmp70_ = NULL;
					const gchar* _tmp71_ = NULL;
					const gchar* _tmp72_ = NULL;
					gchar* _tmp73_ = NULL;
					gchar* _tmp74_ = NULL;
					GError* _tmp75_ = NULL;
					GError* _tmp76_ = NULL;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp70_ = variable;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp71_ = tracker_sparql_variable_get_name (_tmp70_);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp72_ = _tmp71_;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp73_ = g_strdup_printf ("use of undefined variable `%s'", _tmp72_);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp74_ = _tmp73_;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp75_ = tracker_sparql_query_get_error (self, _tmp74_);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp76_ = _tmp75_;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp74_);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_inner_error_ = _tmp76_;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_list_free0 (variable_collection);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tracker_sparql_solution_unref0 (solution);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_string_free0 (sql);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_string_free0 (pattern_sql);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tracker_source_location_free0 (insert_location);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tracker_source_location_free0 (delete_location);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 7187 "tracker-sparql-query.c"
				}
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp77_ = sql;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp78_ = variable;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp79_ = tracker_sparql_variable_get_sql_expression (_tmp78_);
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp80_ = _tmp79_;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp81_ = variable;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp82_ = _tmp81_->binding;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp83_ = ((TrackerSparqlDataBinding*) _tmp82_)->data_type;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_sparql_expression_append_expression_as_string (_tmp77_, _tmp80_, _tmp83_);
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp84_ = solution;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp85_ = _tmp84_->hash;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp86_ = variable;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp87_ = tracker_sparql_variable_get_name (_tmp86_);
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp88_ = _tmp87_;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp89_ = g_strdup (_tmp88_);
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp90_ = var_idx;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				var_idx = _tmp90_ + 1;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_hash_table_insert (_tmp85_, _tmp89_, (gpointer) ((gintptr) _tmp90_));
#line 7223 "tracker-sparql-query.c"
			}
		}
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_list_free0 (variable_collection);
#line 7228 "tracker-sparql-query.c"
	}
#line 729 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp91_ = var_idx;
#line 729 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp91_ == 0) {
#line 7234 "tracker-sparql-query.c"
		GString* _tmp92_ = NULL;
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp92_ = sql;
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_string_append (_tmp92_, "1");
#line 7240 "tracker-sparql-query.c"
	}
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp93_ = sql;
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp93_, " FROM (");
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp94_ = sql;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp95_ = pattern_sql;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp96_ = _tmp95_->str;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp94_, _tmp96_);
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp97_ = sql;
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp97_, ")");
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp98_ = sql;
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp99_ = _tmp98_->str;
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp100_ = tracker_sparql_query_exec_sql_cursor (self, _tmp99_, NULL, 0, NULL, 0, FALSE, &_inner_error_);
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	cursor = _tmp100_;
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_sparql_solution_unref0 (solution);
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_string_free0 (sql);
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_string_free0 (pattern_sql);
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (insert_location);
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (delete_location);
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 7282 "tracker-sparql-query.c"
	}
#line 740 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	n_solutions = 0;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 7288 "tracker-sparql-query.c"
		gboolean _tmp101_ = FALSE;
		TrackerDBCursor* _tmp102_ = NULL;
		gboolean _tmp103_ = FALSE;
		gint _tmp116_ = 0;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp102_ = cursor;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp103_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp102_, NULL, &_inner_error_);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp101_ = _tmp103_;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (cursor);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_solution_unref0 (solution);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 7317 "tracker-sparql-query.c"
		}
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp101_) {
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 7323 "tracker-sparql-query.c"
		}
		{
			gboolean _tmp104_ = FALSE;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			var_idx = 0;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp104_ = TRUE;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			while (TRUE) {
#line 7333 "tracker-sparql-query.c"
				gint _tmp106_ = 0;
				TrackerSparqlSolution* _tmp107_ = NULL;
				GHashTable* _tmp108_ = NULL;
				guint _tmp109_ = 0U;
				TrackerSparqlSolution* _tmp110_ = NULL;
				GPtrArray* _tmp111_ = NULL;
				TrackerDBCursor* _tmp112_ = NULL;
				gint _tmp113_ = 0;
				const gchar* _tmp114_ = NULL;
				gchar* _tmp115_ = NULL;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (!_tmp104_) {
#line 7346 "tracker-sparql-query.c"
					gint _tmp105_ = 0;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp105_ = var_idx;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					var_idx = _tmp105_ + 1;
#line 7352 "tracker-sparql-query.c"
				}
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp104_ = FALSE;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp106_ = var_idx;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp107_ = solution;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp108_ = _tmp107_->hash;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp109_ = g_hash_table_size (_tmp108_);
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (!(((guint) _tmp106_) < _tmp109_)) {
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					break;
#line 7368 "tracker-sparql-query.c"
				}
#line 744 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp110_ = solution;
#line 744 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp111_ = _tmp110_->values;
#line 744 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp112_ = cursor;
#line 744 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp113_ = var_idx;
#line 744 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp114_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp112_, _tmp113_, NULL);
#line 744 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp115_ = g_strdup (_tmp114_);
#line 744 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_ptr_array_add (_tmp111_, _tmp115_);
#line 7384 "tracker-sparql-query.c"
			}
		}
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp116_ = n_solutions;
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		n_solutions = _tmp116_ + 1;
#line 7391 "tracker-sparql-query.c"
	}
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (cursor);
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	cursor = NULL;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp117_ = delete_location;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp117_ != NULL) {
#line 7401 "tracker-sparql-query.c"
		TrackerSourceLocation* _tmp127_ = NULL;
		{
			gint i = 0;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			i = 0;
#line 7407 "tracker-sparql-query.c"
			{
				gboolean _tmp118_ = FALSE;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp118_ = TRUE;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				while (TRUE) {
#line 7414 "tracker-sparql-query.c"
					gint _tmp120_ = 0;
					gint _tmp121_ = 0;
					TrackerSparqlSolution* _tmp122_ = NULL;
					gint _tmp123_ = 0;
					TrackerSourceLocation* _tmp124_ = NULL;
					TrackerSourceLocation _tmp125_ = {0};
					TrackerSparqlSolution* _tmp126_ = NULL;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (!_tmp118_) {
#line 7424 "tracker-sparql-query.c"
						gint _tmp119_ = 0;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp119_ = i;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						i = _tmp119_ + 1;
#line 7430 "tracker-sparql-query.c"
					}
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp118_ = FALSE;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp120_ = i;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp121_ = n_solutions;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (!(_tmp120_ < _tmp121_)) {
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						break;
#line 7442 "tracker-sparql-query.c"
					}
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp122_ = solution;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp123_ = i;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp122_->solution_index = _tmp123_;
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp124_ = delete_location;
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp125_ = *_tmp124_;
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_set_location (self, &_tmp125_);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp126_ = solution;
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_parse_construct_triples_block (self, _tmp126_, TRACKER_SPARQL_UPDATE_TYPE_DELETE, &_inner_error_);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (cursor);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_sparql_solution_unref0 (solution);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (sql);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (pattern_sql);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (insert_location);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (delete_location);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 7478 "tracker-sparql-query.c"
					}
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_data_update_buffer_might_flush (&_inner_error_);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (cursor);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_sparql_solution_unref0 (solution);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (sql);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (pattern_sql);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (insert_location);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (delete_location);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 7500 "tracker-sparql-query.c"
					}
				}
			}
		}
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp127_ = insert_location;
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp127_ != NULL) {
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_data_update_buffer_flush (&_inner_error_);
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (cursor);
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_solution_unref0 (solution);
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7529 "tracker-sparql-query.c"
			}
		}
	}
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp128_ = insert_location;
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp128_ != NULL) {
#line 7537 "tracker-sparql-query.c"
		{
			gint i = 0;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			i = 0;
#line 7542 "tracker-sparql-query.c"
			{
				gboolean _tmp129_ = FALSE;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp129_ = TRUE;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				while (TRUE) {
#line 7549 "tracker-sparql-query.c"
					gint _tmp131_ = 0;
					gint _tmp132_ = 0;
					guchar* _tmp133_ = NULL;
					gint _tmp133__length1 = 0;
					GHashFunc _tmp134_ = NULL;
					GEqualFunc _tmp135_ = NULL;
					GDestroyNotify _tmp136_ = NULL;
					GDestroyNotify _tmp137_ = NULL;
					GHashTable* _tmp138_ = NULL;
					TrackerSparqlSolution* _tmp139_ = NULL;
					gint _tmp140_ = 0;
					TrackerSourceLocation* _tmp141_ = NULL;
					TrackerSourceLocation _tmp142_ = {0};
					TrackerSparqlUpdateType _tmp143_ = 0;
					gboolean _tmp144_ = FALSE;
					TrackerSparqlSolution* _tmp145_ = NULL;
					gboolean _tmp146_ = FALSE;
					gboolean _tmp147_ = FALSE;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (!_tmp129_) {
#line 7570 "tracker-sparql-query.c"
						gint _tmp130_ = 0;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp130_ = i;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						i = _tmp130_ + 1;
#line 7576 "tracker-sparql-query.c"
					}
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp129_ = FALSE;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp131_ = i;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp132_ = n_solutions;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (!(_tmp131_ < _tmp132_)) {
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						break;
#line 7588 "tracker-sparql-query.c"
					}
#line 771 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp133_ = self->priv->base_uuid;
#line 771 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp133__length1 = self->priv->base_uuid_length1;
#line 771 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					uuid_generate (_tmp133_);
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp134_ = g_str_hash;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp135_ = g_str_equal;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp136_ = g_free;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp137_ = g_free;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp138_ = g_hash_table_new_full (_tmp134_, _tmp135_, _tmp136_, _tmp137_);
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_hash_table_unref0 (self->priv->blank_nodes);
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					self->priv->blank_nodes = _tmp138_;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp139_ = solution;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp140_ = i;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp139_->solution_index = _tmp140_;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp141_ = insert_location;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp142_ = *_tmp141_;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_set_location (self, &_tmp142_);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp144_ = insert_is_update;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp144_) {
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp143_ = TRACKER_SPARQL_UPDATE_TYPE_UPDATE;
#line 7628 "tracker-sparql-query.c"
					} else {
#line 779 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp143_ = TRACKER_SPARQL_UPDATE_TYPE_INSERT;
#line 7632 "tracker-sparql-query.c"
					}
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp145_ = solution;
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_parse_construct_triples_block (self, _tmp145_, _tmp143_, &_inner_error_);
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (cursor);
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_sparql_solution_unref0 (solution);
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (sql);
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (pattern_sql);
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (insert_location);
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (delete_location);
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 7656 "tracker-sparql-query.c"
					}
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp147_ = blank;
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp147_) {
#line 7662 "tracker-sparql-query.c"
						GVariantBuilder* _tmp148_ = NULL;
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp148_ = update_blank_nodes;
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp146_ = _tmp148_ != NULL;
#line 7668 "tracker-sparql-query.c"
					} else {
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp146_ = FALSE;
#line 7672 "tracker-sparql-query.c"
					}
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp146_) {
#line 7676 "tracker-sparql-query.c"
						GVariantBuilder* _tmp149_ = NULL;
						GHashTable* _tmp150_ = NULL;
						GVariant* _tmp155_ = NULL;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp149_ = update_blank_nodes;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp150_ = self->priv->blank_nodes;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp155_ = _variant_new1 (_tmp150_);
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_variant_builder_add_value (_tmp149_, _tmp155_);
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_variant_unref0 (_tmp155_);
#line 7690 "tracker-sparql-query.c"
					}
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_data_update_buffer_might_flush (&_inner_error_);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (cursor);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_sparql_solution_unref0 (solution);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (sql);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (pattern_sql);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (insert_location);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (delete_location);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 7712 "tracker-sparql-query.c"
					}
				}
			}
		}
	}
#line 789 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_solution_unref0 (solution);
#line 789 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	solution = NULL;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp156_ = data;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!_tmp156_) {
#line 7726 "tracker-sparql-query.c"
		TrackerSourceLocation _tmp157_ = {0};
#line 793 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp157_ = after_where;
#line 793 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_set_location (self, &_tmp157_);
#line 7732 "tracker-sparql-query.c"
	}
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_data_update_buffer_flush (&_inner_error_);
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (cursor);
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_sparql_solution_unref0 (solution);
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_string_free0 (sql);
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_string_free0 (pattern_sql);
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (insert_location);
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (delete_location);
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 7754 "tracker-sparql-query.c"
	}
#line 798 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	__g_list_free__g_object_unref0_0 (self->bindings);
#line 798 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->bindings = NULL;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp158_ = self->context;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp159_ = _tmp158_->parent_context;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp160_ = _tracker_sparql_context_ref0 (_tmp159_);
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->context);
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->context = _tmp160_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (cursor);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_solution_unref0 (solution);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_string_free0 (sql);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_string_free0 (pattern_sql);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_source_location_free0 (insert_location);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_source_location_free0 (delete_location);
#line 7782 "tracker-sparql-query.c"
}


gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error) {
	gchar* result = NULL;
	gchar* ns = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (local_name != NULL, NULL);
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->prefix_map;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = prefix;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	ns = _tmp3_;
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = ns;
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp4_ == NULL) {
#line 7818 "tracker-sparql-query.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = prefix;
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = g_strdup_printf ("use of undefined prefix `%s'", _tmp5_);
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = _tmp6_;
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = tracker_sparql_query_get_error (self, _tmp7_);
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = _tmp8_;
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (_tmp7_);
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = _tmp9_;
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (ns);
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 7846 "tracker-sparql-query.c"
		} else {
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (ns);
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 7856 "tracker-sparql-query.c"
		}
	}
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = ns;
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = local_name;
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp12_;
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (ns);
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 7871 "tracker-sparql-query.c"
}


static void tracker_sparql_query_skip_braces (TrackerSparqlQuery* self, GError** error) {
	gint n_braces = 0;
	GError * _inner_error_ = NULL;
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 7890 "tracker-sparql-query.c"
		} else {
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 7898 "tracker-sparql-query.c"
		}
	}
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	n_braces = 1;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 7905 "tracker-sparql-query.c"
		gint _tmp0_ = 0;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = n_braces;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!(_tmp0_ > 0)) {
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 7915 "tracker-sparql-query.c"
		}
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = _tmp2_;
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7929 "tracker-sparql-query.c"
			} else {
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7937 "tracker-sparql-query.c"
			}
		}
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp1_) {
#line 7942 "tracker-sparql-query.c"
			gint _tmp3_ = 0;
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp3_ = n_braces;
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			n_braces = _tmp3_ + 1;
#line 7948 "tracker-sparql-query.c"
		} else {
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp4_ = _tmp5_;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 7964 "tracker-sparql-query.c"
				} else {
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 7972 "tracker-sparql-query.c"
				}
			}
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp4_) {
#line 7977 "tracker-sparql-query.c"
				gint _tmp6_ = 0;
#line 818 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp6_ = n_braces;
#line 818 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				n_braces = _tmp6_ - 1;
#line 7983 "tracker-sparql-query.c"
			} else {
				TrackerSparqlTokenType _tmp7_ = 0;
#line 819 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp7_ = tracker_sparql_query_current (self);
#line 819 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
#line 7990 "tracker-sparql-query.c"
					GError* _tmp8_ = NULL;
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp8_ = tracker_sparql_query_get_error (self, "unexpected end of query, expected }");
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_inner_error_ = _tmp8_;
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8002 "tracker-sparql-query.c"
					} else {
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8010 "tracker-sparql-query.c"
					}
				} else {
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_next (self, &_inner_error_);
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 8023 "tracker-sparql-query.c"
						} else {
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 8031 "tracker-sparql-query.c"
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_query_parse_construct_triples_block (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error) {
	GError * _inner_error_ = NULL;
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (var_value_map != NULL);
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 8057 "tracker-sparql-query.c"
		} else {
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 8065 "tracker-sparql-query.c"
		}
	}
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 8070 "tracker-sparql-query.c"
		TrackerSparqlTokenType _tmp0_ = 0;
		gboolean is_null = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = tracker_sparql_query_current (self);
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!(_tmp0_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE)) {
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 8081 "tracker-sparql-query.c"
		}
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		is_null = FALSE;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = _tmp2_;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 8097 "tracker-sparql-query.c"
			} else {
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 8105 "tracker-sparql-query.c"
			}
		}
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp1_) {
#line 8110 "tracker-sparql-query.c"
			gchar* old_graph = NULL;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			TrackerSparqlSolution* _tmp6_ = NULL;
			TrackerSparqlUpdateType _tmp7_ = 0;
			gboolean _tmp8_ = FALSE;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp3_ = self->priv->current_graph;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			old_graph = _tmp4_;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = var_value_map;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = type;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = tracker_sparql_query_parse_construct_var_or_term (self, _tmp6_, _tmp7_, &_tmp8_, &_inner_error_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			is_null = _tmp8_;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = _tmp9_;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8149 "tracker-sparql-query.c"
				} else {
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8159 "tracker-sparql-query.c"
				}
			}
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = _tmp5_;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = NULL;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_graph);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_graph = _tmp10_;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp11_ = is_null;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp11_) {
#line 8174 "tracker-sparql-query.c"
				GError* _tmp12_ = NULL;
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp12_ = tracker_sparql_query_get_error (self, "'null' not supported for graph");
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_inner_error_ = _tmp12_;
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8190 "tracker-sparql-query.c"
				} else {
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8202 "tracker-sparql-query.c"
				}
			}
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8219 "tracker-sparql-query.c"
				} else {
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8231 "tracker-sparql-query.c"
				}
			}
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			while (TRUE) {
#line 8236 "tracker-sparql-query.c"
				TrackerSparqlTokenType _tmp13_ = 0;
				gchar* _tmp14_ = NULL;
				TrackerSparqlSolution* _tmp15_ = NULL;
				TrackerSparqlUpdateType _tmp16_ = 0;
				gboolean _tmp17_ = FALSE;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				TrackerSparqlSolution* _tmp22_ = NULL;
				TrackerSparqlUpdateType _tmp23_ = 0;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp13_ = tracker_sparql_query_current (self);
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (!(_tmp13_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE)) {
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					break;
#line 8255 "tracker-sparql-query.c"
				}
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp15_ = var_value_map;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp16_ = type;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18_ = tracker_sparql_query_parse_construct_var_or_term (self, _tmp15_, _tmp16_, &_tmp17_, &_inner_error_);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				is_null = _tmp17_;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp14_ = _tmp18_;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8279 "tracker-sparql-query.c"
					} else {
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8291 "tracker-sparql-query.c"
					}
				}
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp19_ = _tmp14_;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp14_ = NULL;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (self->priv->current_subject);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				self->priv->current_subject = _tmp19_;
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp20_ = is_null;
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp20_) {
#line 8306 "tracker-sparql-query.c"
					GError* _tmp21_ = NULL;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp21_ = tracker_sparql_query_get_error (self, "'null' not supported for subject");
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_inner_error_ = _tmp21_;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8324 "tracker-sparql-query.c"
					} else {
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8338 "tracker-sparql-query.c"
					}
				}
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp22_ = var_value_map;
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp23_ = type;
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_sparql_query_parse_construct_property_list_not_empty (self, _tmp22_, _tmp23_, &_inner_error_);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8361 "tracker-sparql-query.c"
					} else {
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8375 "tracker-sparql-query.c"
					}
				}
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp25_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp24_ = _tmp25_;
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8396 "tracker-sparql-query.c"
					} else {
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8410 "tracker-sparql-query.c"
					}
				}
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (!_tmp24_) {
#line 854 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp14_);
#line 854 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					break;
#line 8419 "tracker-sparql-query.c"
				}
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_tmp14_);
#line 8423 "tracker-sparql-query.c"
			}
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8439 "tracker-sparql-query.c"
				} else {
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8451 "tracker-sparql-query.c"
				}
			}
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp26_ = old_graph;
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp27_ = g_strdup (_tmp26_);
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_graph);
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_graph = _tmp27_;
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8476 "tracker-sparql-query.c"
				} else {
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8488 "tracker-sparql-query.c"
				}
			}
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp5_);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (old_graph);
#line 8495 "tracker-sparql-query.c"
		} else {
			gchar* _tmp28_ = NULL;
			TrackerSparqlSolution* _tmp29_ = NULL;
			TrackerSparqlUpdateType _tmp30_ = 0;
			gboolean _tmp31_ = FALSE;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gboolean _tmp34_ = FALSE;
			TrackerSparqlSolution* _tmp36_ = NULL;
			TrackerSparqlUpdateType _tmp37_ = 0;
			gboolean _tmp38_ = FALSE;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp40_ = FALSE;
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp29_ = var_value_map;
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp30_ = type;
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp32_ = tracker_sparql_query_parse_construct_var_or_term (self, _tmp29_, _tmp30_, &_tmp31_, &_inner_error_);
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			is_null = _tmp31_;
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp28_ = _tmp32_;
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8527 "tracker-sparql-query.c"
				} else {
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8535 "tracker-sparql-query.c"
				}
			}
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp33_ = _tmp28_;
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp28_ = NULL;
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_subject);
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_subject = _tmp33_;
#line 866 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp34_ = is_null;
#line 866 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp34_) {
#line 8550 "tracker-sparql-query.c"
				GError* _tmp35_ = NULL;
#line 867 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp35_ = tracker_sparql_query_get_error (self, "'null' not supported for subject");
#line 867 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_inner_error_ = _tmp35_;
#line 867 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 867 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 867 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 867 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8564 "tracker-sparql-query.c"
				} else {
#line 867 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 867 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 867 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 867 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8574 "tracker-sparql-query.c"
				}
			}
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp36_ = var_value_map;
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp37_ = type;
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_parse_construct_property_list_not_empty (self, _tmp36_, _tmp37_, &_inner_error_);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8593 "tracker-sparql-query.c"
				} else {
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8603 "tracker-sparql-query.c"
				}
			}
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp40_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp39_ = _tmp40_;
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8620 "tracker-sparql-query.c"
				} else {
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8630 "tracker-sparql-query.c"
				}
			}
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (!_tmp39_) {
#line 8635 "tracker-sparql-query.c"
				TrackerSparqlTokenType _tmp41_ = 0;
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp41_ = tracker_sparql_query_current (self);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp38_ = _tmp41_ != TRACKER_SPARQL_TOKEN_TYPE_GRAPH;
#line 8641 "tracker-sparql-query.c"
			} else {
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp38_ = FALSE;
#line 8645 "tracker-sparql-query.c"
			}
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp38_) {
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_tmp28_);
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				break;
#line 8653 "tracker-sparql-query.c"
			}
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp28_);
#line 8657 "tracker-sparql-query.c"
		}
	}
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 8670 "tracker-sparql-query.c"
		} else {
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 8678 "tracker-sparql-query.c"
		}
	}
}


static gchar* tracker_sparql_query_parse_construct_var_or_term (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, gboolean* is_null, GError** error) {
	gboolean _vala_is_null = FALSE;
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	TrackerSparqlTokenType _tmp1_ = 0;
	GError * _inner_error_ = NULL;
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (var_value_map != NULL, NULL);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_strdup ("");
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_result_ = _tmp0_;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_vala_is_null = FALSE;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_current (self);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp1_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 8705 "tracker-sparql-query.c"
		TrackerSparqlSolution* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_next (self, &_inner_error_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_result_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 8724 "tracker-sparql-query.c"
			} else {
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_result_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 8734 "tracker-sparql-query.c"
			}
		}
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = var_value_map;
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = tracker_sparql_query_get_last_string (self, 0);
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = _tmp3_;
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) -1);
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = _tmp5_;
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = tracker_sparql_solution_lookup (_tmp2_, _tmp6_);
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (_result_);
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_result_ = _tmp7_;
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (_tmp6_);
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (_tmp4_);
#line 8757 "tracker-sparql-query.c"
	} else {
		TrackerSparqlTokenType _tmp8_ = 0;
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = tracker_sparql_query_current (self);
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp8_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 8764 "tracker-sparql-query.c"
			gchar* _tmp9_ = NULL;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_next (self, &_inner_error_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_result_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 8778 "tracker-sparql-query.c"
				} else {
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_result_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 8788 "tracker-sparql-query.c"
				}
			}
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = tracker_sparql_query_get_last_string (self, 1);
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_result_);
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_result_ = _tmp9_;
#line 8797 "tracker-sparql-query.c"
		} else {
			TrackerSparqlTokenType _tmp10_ = 0;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = tracker_sparql_query_current (self);
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp10_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
#line 8804 "tracker-sparql-query.c"
				gchar* ns = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_sparql_query_next (self, &_inner_error_);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 8828 "tracker-sparql-query.c"
					} else {
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 8838 "tracker-sparql-query.c"
					}
				}
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp11_ = tracker_sparql_query_get_last_string (self, 0);
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				ns = _tmp11_;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (ns);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 8859 "tracker-sparql-query.c"
					} else {
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (ns);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 8871 "tracker-sparql-query.c"
					}
				}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp13_ = ns;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp14_ = tracker_sparql_query_get_last_string (self, 0);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp15_ = _tmp14_;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp16_ = string_substring (_tmp15_, (glong) 1, (glong) -1);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp17_ = _tmp16_;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18_ = tracker_sparql_query_resolve_prefixed_name (self, _tmp13_, _tmp17_, &_inner_error_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp19_ = _tmp18_;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_tmp17_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_tmp15_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp12_ = _tmp19_;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (ns);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 8906 "tracker-sparql-query.c"
					} else {
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (ns);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 8918 "tracker-sparql-query.c"
					}
				}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp20_ = _tmp12_;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp12_ = NULL;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_result_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_result_ = _tmp20_;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_tmp12_);
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 8933 "tracker-sparql-query.c"
			} else {
				TrackerSparqlTokenType _tmp21_ = 0;
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp21_ = tracker_sparql_query_current (self);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp21_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
#line 8940 "tracker-sparql-query.c"
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_next (self, &_inner_error_);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 8961 "tracker-sparql-query.c"
						} else {
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 8971 "tracker-sparql-query.c"
						}
					}
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp23_ = tracker_sparql_query_get_last_string (self, 0);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp24_ = _tmp23_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp25_ = string_substring (_tmp24_, (glong) 1, (glong) -1);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp26_ = _tmp25_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp27_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp26_, &_inner_error_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp28_ = _tmp27_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp26_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp24_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp22_ = _tmp28_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 9002 "tracker-sparql-query.c"
						} else {
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 9012 "tracker-sparql-query.c"
						}
					}
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp29_ = _tmp22_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp22_ = NULL;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_result_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_result_ = _tmp29_;
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp22_);
#line 9025 "tracker-sparql-query.c"
				} else {
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp31_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp30_ = _tmp31_;
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 9043 "tracker-sparql-query.c"
						} else {
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 9053 "tracker-sparql-query.c"
						}
					}
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp30_) {
#line 9058 "tracker-sparql-query.c"
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_ = NULL;
						gchar* _tmp34_ = NULL;
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_ = NULL;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (_result_);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 9076 "tracker-sparql-query.c"
							} else {
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (_result_);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 9086 "tracker-sparql-query.c"
							}
						}
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp32_ = tracker_sparql_query_get_last_string (self, 0);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp33_ = _tmp32_;
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp34_ = string_substring (_tmp33_, (glong) 1, (glong) -1);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp35_ = _tmp34_;
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp36_ = tracker_sparql_query_generate_bnodeid (self, _tmp35_);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_result_ = _tmp36_;
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp35_);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp33_);
#line 9107 "tracker-sparql-query.c"
					} else {
						TrackerSparqlTokenType _tmp37_ = 0;
#line 906 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp37_ = tracker_sparql_query_current (self);
#line 906 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_tmp37_ == TRACKER_SPARQL_TOKEN_TYPE_MINUS) {
#line 9114 "tracker-sparql-query.c"
							gboolean _tmp38_ = FALSE;
							gboolean _tmp39_ = FALSE;
							TrackerSparqlTokenType _tmp40_ = 0;
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							tracker_sparql_query_next (self, &_inner_error_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_propagate_error (error, _inner_error_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (_result_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 9130 "tracker-sparql-query.c"
								} else {
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (_result_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_clear_error (&_inner_error_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 9140 "tracker-sparql-query.c"
								}
							}
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp40_ = tracker_sparql_query_current (self);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (_tmp40_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp39_ = TRUE;
#line 9149 "tracker-sparql-query.c"
							} else {
								TrackerSparqlTokenType _tmp41_ = 0;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp41_ = tracker_sparql_query_current (self);
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp39_ = _tmp41_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL;
#line 9156 "tracker-sparql-query.c"
							}
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (_tmp39_) {
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp38_ = TRUE;
#line 9162 "tracker-sparql-query.c"
							} else {
								TrackerSparqlTokenType _tmp42_ = 0;
#line 910 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp42_ = tracker_sparql_query_current (self);
#line 910 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp38_ = _tmp42_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 9169 "tracker-sparql-query.c"
							}
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (_tmp38_) {
#line 9173 "tracker-sparql-query.c"
								gchar* _tmp43_ = NULL;
								gchar* _tmp44_ = NULL;
								gchar* _tmp45_ = NULL;
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								tracker_sparql_query_next (self, &_inner_error_);
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_propagate_error (error, _inner_error_);
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_g_free0 (_result_);
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										return NULL;
#line 9189 "tracker-sparql-query.c"
									} else {
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_g_free0 (_result_);
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_clear_error (&_inner_error_);
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										return NULL;
#line 9199 "tracker-sparql-query.c"
									}
								}
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp43_ = tracker_sparql_query_get_last_string (self, 0);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp44_ = _tmp43_;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp45_ = g_strconcat ("-", _tmp44_, NULL);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (_result_);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_result_ = _tmp45_;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (_tmp44_);
#line 9214 "tracker-sparql-query.c"
							} else {
								GError* _tmp46_ = NULL;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp46_ = tracker_sparql_query_get_error (self, "expected variable or term");
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_inner_error_ = _tmp46_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_propagate_error (error, _inner_error_);
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (_result_);
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 9229 "tracker-sparql-query.c"
								} else {
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (_result_);
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_clear_error (&_inner_error_);
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 9239 "tracker-sparql-query.c"
								}
							}
						} else {
							TrackerSparqlTokenType _tmp47_ = 0;
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp47_ = tracker_sparql_query_current (self);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (_tmp47_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 9248 "tracker-sparql-query.c"
								gchar* _tmp48_ = NULL;
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								tracker_sparql_query_next (self, &_inner_error_);
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_propagate_error (error, _inner_error_);
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_g_free0 (_result_);
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										return NULL;
#line 9262 "tracker-sparql-query.c"
									} else {
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_g_free0 (_result_);
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_clear_error (&_inner_error_);
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										return NULL;
#line 9272 "tracker-sparql-query.c"
									}
								}
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp48_ = tracker_sparql_query_get_last_string (self, 0);
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (_result_);
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_result_ = _tmp48_;
#line 9281 "tracker-sparql-query.c"
							} else {
								TrackerSparqlTokenType _tmp49_ = 0;
#line 919 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp49_ = tracker_sparql_query_current (self);
#line 919 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if (_tmp49_ == TRACKER_SPARQL_TOKEN_TYPE_NULL) {
#line 9288 "tracker-sparql-query.c"
									gchar* _tmp50_ = NULL;
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									tracker_sparql_query_next (self, &_inner_error_);
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											g_propagate_error (error, _inner_error_);
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_g_free0 (_result_);
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											return NULL;
#line 9302 "tracker-sparql-query.c"
										} else {
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_g_free0 (_result_);
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											g_clear_error (&_inner_error_);
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											return NULL;
#line 9312 "tracker-sparql-query.c"
										}
									}
#line 921 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_tmp50_ = g_strdup ("null");
#line 921 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (_result_);
#line 921 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_result_ = _tmp50_;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_vala_is_null = TRUE;
#line 9323 "tracker-sparql-query.c"
								} else {
									TrackerSparqlTokenType _tmp51_ = 0;
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_tmp51_ = tracker_sparql_query_current (self);
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									if (_tmp51_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
#line 9330 "tracker-sparql-query.c"
										gchar* _tmp52_ = NULL;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										tracker_sparql_query_next (self, &_inner_error_);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												g_propagate_error (error, _inner_error_);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_g_free0 (_result_);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												return NULL;
#line 9344 "tracker-sparql-query.c"
											} else {
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_g_free0 (_result_);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												g_clear_error (&_inner_error_);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												return NULL;
#line 9354 "tracker-sparql-query.c"
											}
										}
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_tmp52_ = tracker_sparql_query_get_last_string (self, 0);
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_g_free0 (_result_);
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_result_ = _tmp52_;
#line 9363 "tracker-sparql-query.c"
									} else {
										TrackerSparqlTokenType _tmp53_ = 0;
#line 926 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_tmp53_ = tracker_sparql_query_current (self);
#line 926 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										if (_tmp53_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
#line 9370 "tracker-sparql-query.c"
											gchar* _tmp54_ = NULL;
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											tracker_sparql_query_next (self, &_inner_error_);
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													g_propagate_error (error, _inner_error_);
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_g_free0 (_result_);
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													return NULL;
#line 9384 "tracker-sparql-query.c"
												} else {
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_g_free0 (_result_);
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													g_clear_error (&_inner_error_);
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													return NULL;
#line 9394 "tracker-sparql-query.c"
												}
											}
#line 928 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_tmp54_ = tracker_sparql_query_get_last_string (self, 0);
#line 928 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_g_free0 (_result_);
#line 928 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_result_ = _tmp54_;
#line 9403 "tracker-sparql-query.c"
										} else {
											TrackerSparqlTokenType _tmp55_ = 0;
#line 929 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_tmp55_ = tracker_sparql_query_current (self);
#line 929 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											if (_tmp55_ == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
#line 9410 "tracker-sparql-query.c"
												gchar* _tmp56_ = NULL;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												tracker_sparql_query_next (self, &_inner_error_);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														g_propagate_error (error, _inner_error_);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_g_free0 (_result_);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														return NULL;
#line 9424 "tracker-sparql-query.c"
													} else {
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_g_free0 (_result_);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														g_clear_error (&_inner_error_);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														return NULL;
#line 9434 "tracker-sparql-query.c"
													}
												}
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_tmp56_ = g_strdup ("true");
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_g_free0 (_result_);
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_result_ = _tmp56_;
#line 9443 "tracker-sparql-query.c"
											} else {
												TrackerSparqlTokenType _tmp57_ = 0;
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_tmp57_ = tracker_sparql_query_current (self);
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												if (_tmp57_ == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
#line 9450 "tracker-sparql-query.c"
													gchar* _tmp58_ = NULL;
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													tracker_sparql_query_next (self, &_inner_error_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															g_propagate_error (error, _inner_error_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_g_free0 (_result_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															return NULL;
#line 9464 "tracker-sparql-query.c"
														} else {
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_g_free0 (_result_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															g_clear_error (&_inner_error_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															return NULL;
#line 9474 "tracker-sparql-query.c"
														}
													}
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_tmp58_ = g_strdup ("false");
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_g_free0 (_result_);
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_result_ = _tmp58_;
#line 9483 "tracker-sparql-query.c"
												} else {
													TrackerSparqlTokenType _tmp59_ = 0;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_tmp59_ = tracker_sparql_query_current (self);
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													if (_tmp59_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
#line 9490 "tracker-sparql-query.c"
														gchar* _tmp60_ = NULL;
														TrackerSparqlExpression* _tmp61_ = NULL;
														gchar* _tmp62_ = NULL;
														gchar* _tmp63_ = NULL;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp61_ = self->expression;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp62_ = tracker_sparql_expression_parse_string_literal (_tmp61_, NULL, &_inner_error_);
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp60_ = _tmp62_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																g_propagate_error (error, _inner_error_);
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_g_free0 (_result_);
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																return NULL;
#line 9511 "tracker-sparql-query.c"
															} else {
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_g_free0 (_result_);
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																g_clear_error (&_inner_error_);
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																return NULL;
#line 9521 "tracker-sparql-query.c"
															}
														}
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp63_ = _tmp60_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp60_ = NULL;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_g_free0 (_result_);
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_result_ = _tmp63_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_g_free0 (_tmp60_);
#line 9534 "tracker-sparql-query.c"
													} else {
														TrackerSparqlTokenType _tmp64_ = 0;
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp64_ = tracker_sparql_query_current (self);
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														if (_tmp64_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
#line 9541 "tracker-sparql-query.c"
															gchar* _tmp65_ = NULL;
															TrackerSparqlExpression* _tmp66_ = NULL;
															gchar* _tmp67_ = NULL;
															gchar* _tmp68_ = NULL;
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp66_ = self->expression;
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp67_ = tracker_sparql_expression_parse_string_literal (_tmp66_, NULL, &_inner_error_);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp65_ = _tmp67_;
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	g_propagate_error (error, _inner_error_);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_g_free0 (_result_);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	return NULL;
#line 9562 "tracker-sparql-query.c"
																} else {
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_g_free0 (_result_);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	g_clear_error (&_inner_error_);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	return NULL;
#line 9572 "tracker-sparql-query.c"
																}
															}
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp68_ = _tmp65_;
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp65_ = NULL;
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_g_free0 (_result_);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_result_ = _tmp68_;
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_g_free0 (_tmp65_);
#line 9585 "tracker-sparql-query.c"
														} else {
															TrackerSparqlTokenType _tmp69_ = 0;
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp69_ = tracker_sparql_query_current (self);
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															if (_tmp69_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
#line 9592 "tracker-sparql-query.c"
																gchar* _tmp70_ = NULL;
																TrackerSparqlExpression* _tmp71_ = NULL;
																gchar* _tmp72_ = NULL;
																gchar* _tmp73_ = NULL;
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp71_ = self->expression;
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp72_ = tracker_sparql_expression_parse_string_literal (_tmp71_, NULL, &_inner_error_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp70_ = _tmp72_;
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		g_propagate_error (error, _inner_error_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (_result_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		return NULL;
#line 9613 "tracker-sparql-query.c"
																	} else {
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (_result_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		g_clear_error (&_inner_error_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		return NULL;
#line 9623 "tracker-sparql-query.c"
																	}
																}
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp73_ = _tmp70_;
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp70_ = NULL;
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_g_free0 (_result_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_result_ = _tmp73_;
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_g_free0 (_tmp70_);
#line 9636 "tracker-sparql-query.c"
															} else {
																TrackerSparqlTokenType _tmp74_ = 0;
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp74_ = tracker_sparql_query_current (self);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																if (_tmp74_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
#line 9643 "tracker-sparql-query.c"
																	gchar* _tmp75_ = NULL;
																	TrackerSparqlExpression* _tmp76_ = NULL;
																	gchar* _tmp77_ = NULL;
																	gchar* _tmp78_ = NULL;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp76_ = self->expression;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp77_ = tracker_sparql_expression_parse_string_literal (_tmp76_, NULL, &_inner_error_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp75_ = _tmp77_;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_propagate_error (error, _inner_error_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_g_free0 (_result_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			return NULL;
#line 9664 "tracker-sparql-query.c"
																		} else {
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_g_free0 (_result_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_clear_error (&_inner_error_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			return NULL;
#line 9674 "tracker-sparql-query.c"
																		}
																	}
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp78_ = _tmp75_;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp75_ = NULL;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_g_free0 (_result_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_result_ = _tmp78_;
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_g_free0 (_tmp75_);
#line 9687 "tracker-sparql-query.c"
																} else {
																	TrackerSparqlTokenType _tmp79_ = 0;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp79_ = tracker_sparql_query_current (self);
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	if (_tmp79_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
#line 9694 "tracker-sparql-query.c"
																		gboolean _tmp80_ = FALSE;
																		gchar* _tmp82_ = NULL;
																		gchar* old_subject = NULL;
																		const gchar* _tmp83_ = NULL;
																		gchar* _tmp84_ = NULL;
																		gboolean old_subject_is_var = FALSE;
																		gboolean _tmp85_ = FALSE;
																		const gchar* _tmp86_ = NULL;
																		gchar* _tmp87_ = NULL;
																		TrackerSparqlSolution* _tmp88_ = NULL;
																		TrackerSparqlUpdateType _tmp89_ = 0;
																		const gchar* _tmp90_ = NULL;
																		gchar* _tmp91_ = NULL;
																		gboolean _tmp92_ = FALSE;
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp80_ = self->priv->anon_blank_node_open;
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if (_tmp80_) {
#line 9713 "tracker-sparql-query.c"
																			GError* _tmp81_ = NULL;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_tmp81_ = tracker_sparql_query_get_error (self, "no support for nested anonymous blank nodes");
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_inner_error_ = _tmp81_;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_propagate_error (error, _inner_error_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 9727 "tracker-sparql-query.c"
																			} else {
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_clear_error (&_inner_error_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 9737 "tracker-sparql-query.c"
																			}
																		}
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		self->priv->anon_blank_node_open = TRUE;
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		tracker_sparql_query_next (self, &_inner_error_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_propagate_error (error, _inner_error_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 9754 "tracker-sparql-query.c"
																			} else {
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_clear_error (&_inner_error_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 9764 "tracker-sparql-query.c"
																			}
																		}
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp82_ = tracker_sparql_query_generate_bnodeid (self, NULL);
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (_result_);
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_result_ = _tmp82_;
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp83_ = self->priv->current_subject;
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp84_ = g_strdup (_tmp83_);
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		old_subject = _tmp84_;
#line 955 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp85_ = self->priv->current_subject_is_var;
#line 955 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		old_subject_is_var = _tmp85_;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp86_ = _result_;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp87_ = g_strdup (_tmp86_);
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (self->priv->current_subject);
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		self->priv->current_subject = _tmp87_;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp88_ = var_value_map;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp89_ = type;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		tracker_sparql_query_parse_construct_property_list_not_empty (self, _tmp88_, _tmp89_, &_inner_error_);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_propagate_error (error, _inner_error_);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (old_subject);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 9809 "tracker-sparql-query.c"
																			} else {
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (old_subject);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_clear_error (&_inner_error_);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 9821 "tracker-sparql-query.c"
																			}
																		}
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_propagate_error (error, _inner_error_);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (old_subject);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 9838 "tracker-sparql-query.c"
																			} else {
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (old_subject);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_clear_error (&_inner_error_);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 9850 "tracker-sparql-query.c"
																			}
																		}
#line 960 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		self->priv->anon_blank_node_open = FALSE;
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp90_ = old_subject;
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp91_ = g_strdup (_tmp90_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (self->priv->current_subject);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		self->priv->current_subject = _tmp91_;
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp92_ = old_subject_is_var;
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		self->priv->current_subject_is_var = _tmp92_;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (old_subject);
#line 9869 "tracker-sparql-query.c"
																	} else {
																		GError* _tmp93_ = NULL;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp93_ = tracker_sparql_query_get_error (self, "expected variable or term");
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_inner_error_ = _tmp93_;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_propagate_error (error, _inner_error_);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_g_free0 (_result_);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			return NULL;
#line 9884 "tracker-sparql-query.c"
																		} else {
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_g_free0 (_result_);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_clear_error (&_inner_error_);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			return NULL;
#line 9894 "tracker-sparql-query.c"
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 967 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _result_;
#line 967 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (is_null) {
#line 967 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*is_null = _vala_is_null;
#line 9919 "tracker-sparql-query.c"
	}
#line 967 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 9923 "tracker-sparql-query.c"
}


static void tracker_sparql_query_parse_construct_property_list_not_empty (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error) {
	GError * _inner_error_ = NULL;
#line 970 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 970 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (var_value_map != NULL);
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 9935 "tracker-sparql-query.c"
		gchar* old_predicate = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		TrackerSparqlTokenType _tmp2_ = 0;
		TrackerSparqlSolution* _tmp34_ = NULL;
		TrackerSparqlUpdateType _tmp35_ = 0;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = self->priv->current_predicate;
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		old_predicate = _tmp1_;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->current_predicate);
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->current_predicate = NULL;
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = tracker_sparql_query_current (self);
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp2_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 9960 "tracker-sparql-query.c"
			TrackerSparqlSolution* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_predicate_is_var = TRUE;
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_next (self, &_inner_error_);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_predicate);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9981 "tracker-sparql-query.c"
				} else {
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_predicate);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9991 "tracker-sparql-query.c"
				}
			}
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp3_ = var_value_map;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp4_ = tracker_sparql_query_get_last_string (self, 0);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = _tmp4_;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = _tmp6_;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp8_ = tracker_sparql_solution_lookup (_tmp3_, _tmp7_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_predicate);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_predicate = _tmp8_;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp7_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp5_);
#line 10014 "tracker-sparql-query.c"
		} else {
			TrackerSparqlTokenType _tmp9_ = 0;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = tracker_sparql_query_current (self);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp9_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 10021 "tracker-sparql-query.c"
				gchar* _tmp10_ = NULL;
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_sparql_query_next (self, &_inner_error_);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_predicate);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 10035 "tracker-sparql-query.c"
					} else {
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_predicate);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 10045 "tracker-sparql-query.c"
					}
				}
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp10_ = tracker_sparql_query_get_last_string (self, 1);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (self->priv->current_predicate);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				self->priv->current_predicate = _tmp10_;
#line 10054 "tracker-sparql-query.c"
			} else {
				TrackerSparqlTokenType _tmp11_ = 0;
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp11_ = tracker_sparql_query_current (self);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp11_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
#line 10061 "tracker-sparql-query.c"
					gchar* ns = NULL;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_next (self, &_inner_error_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10085 "tracker-sparql-query.c"
						} else {
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10095 "tracker-sparql-query.c"
						}
					}
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp12_ = tracker_sparql_query_get_last_string (self, 0);
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					ns = _tmp12_;
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (ns);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10116 "tracker-sparql-query.c"
						} else {
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (ns);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10128 "tracker-sparql-query.c"
						}
					}
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp14_ = ns;
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp15_ = tracker_sparql_query_get_last_string (self, 0);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp16_ = _tmp15_;
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp17_ = string_substring (_tmp16_, (glong) 1, (glong) -1);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp18_ = _tmp17_;
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp19_ = tracker_sparql_query_resolve_prefixed_name (self, _tmp14_, _tmp18_, &_inner_error_);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp20_ = _tmp19_;
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp18_);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp16_);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp13_ = _tmp20_;
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (ns);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10163 "tracker-sparql-query.c"
						} else {
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (ns);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10175 "tracker-sparql-query.c"
						}
					}
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp21_ = _tmp13_;
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp13_ = NULL;
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (self->priv->current_predicate);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					self->priv->current_predicate = _tmp21_;
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp13_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (ns);
#line 10190 "tracker-sparql-query.c"
				} else {
					TrackerSparqlTokenType _tmp22_ = 0;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp22_ = tracker_sparql_query_current (self);
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp22_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
#line 10197 "tracker-sparql-query.c"
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_ = NULL;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						tracker_sparql_query_next (self, &_inner_error_);
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10218 "tracker-sparql-query.c"
							} else {
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10228 "tracker-sparql-query.c"
							}
						}
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp24_ = tracker_sparql_query_get_last_string (self, 0);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp25_ = _tmp24_;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp26_ = string_substring (_tmp25_, (glong) 1, (glong) -1);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp27_ = _tmp26_;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp28_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp27_, &_inner_error_);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp29_ = _tmp28_;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp27_);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp25_);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp23_ = _tmp29_;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10259 "tracker-sparql-query.c"
							} else {
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10269 "tracker-sparql-query.c"
							}
						}
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp30_ = _tmp23_;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp23_ = NULL;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (self->priv->current_predicate);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						self->priv->current_predicate = _tmp30_;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp23_);
#line 10282 "tracker-sparql-query.c"
					} else {
						TrackerSparqlTokenType _tmp31_ = 0;
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp31_ = tracker_sparql_query_current (self);
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_tmp31_ == TRACKER_SPARQL_TOKEN_TYPE_A) {
#line 10289 "tracker-sparql-query.c"
							gchar* _tmp32_ = NULL;
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							tracker_sparql_query_next (self, &_inner_error_);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_propagate_error (error, _inner_error_);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (old_predicate);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return;
#line 10303 "tracker-sparql-query.c"
								} else {
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (old_predicate);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_clear_error (&_inner_error_);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return;
#line 10313 "tracker-sparql-query.c"
								}
							}
#line 992 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp32_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
#line 992 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (self->priv->current_predicate);
#line 992 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							self->priv->current_predicate = _tmp32_;
#line 10322 "tracker-sparql-query.c"
						} else {
							GError* _tmp33_ = NULL;
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp33_ = tracker_sparql_query_get_error (self, "expected non-empty property list");
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_inner_error_ = _tmp33_;
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10337 "tracker-sparql-query.c"
							} else {
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10347 "tracker-sparql-query.c"
							}
						}
					}
				}
			}
		}
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp34_ = var_value_map;
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp35_ = type;
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_parse_construct_object_list (self, _tmp34_, _tmp35_, &_inner_error_);
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (old_predicate);
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10370 "tracker-sparql-query.c"
			} else {
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (old_predicate);
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10380 "tracker-sparql-query.c"
			}
		}
#line 998 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp36_ = old_predicate;
#line 998 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 998 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->current_predicate);
#line 998 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->current_predicate = _tmp37_;
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp39_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp38_ = _tmp39_;
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (old_predicate);
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10405 "tracker-sparql-query.c"
			} else {
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (old_predicate);
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10415 "tracker-sparql-query.c"
			}
		}
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp38_) {
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (old_predicate);
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			continue;
#line 10424 "tracker-sparql-query.c"
		}
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (old_predicate);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 10430 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_query_parse_construct_object_list (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error) {
	GError * _inner_error_ = NULL;
#line 1007 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 1007 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (var_value_map != NULL);
#line 1008 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 10443 "tracker-sparql-query.c"
		TrackerSparqlSolution* _tmp0_ = NULL;
		TrackerSparqlUpdateType _tmp1_ = 0;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = var_value_map;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = type;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_parse_construct_object (self, _tmp0_, _tmp1_, &_inner_error_);
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10462 "tracker-sparql-query.c"
			} else {
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10470 "tracker-sparql-query.c"
			}
		}
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = _tmp3_;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10485 "tracker-sparql-query.c"
			} else {
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10493 "tracker-sparql-query.c"
			}
		}
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp2_) {
#line 1011 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			continue;
#line 10500 "tracker-sparql-query.c"
		}
#line 1013 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 10504 "tracker-sparql-query.c"
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 1044 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self ? g_error_copy (self) : NULL;
#line 10512 "tracker-sparql-query.c"
}


static void tracker_sparql_query_parse_construct_object (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error) {
	gboolean is_null = FALSE;
	gchar* object = NULL;
	TrackerSparqlSolution* _tmp0_ = NULL;
	TrackerSparqlUpdateType _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (var_value_map != NULL);
#line 1018 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	is_null = FALSE;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = var_value_map;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = type;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = tracker_sparql_query_parse_construct_var_or_term (self, _tmp0_, _tmp1_, &_tmp2_, &_inner_error_);
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	is_null = _tmp2_;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	object = _tmp3_;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 10551 "tracker-sparql-query.c"
		} else {
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 10559 "tracker-sparql-query.c"
		}
	}
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->current_subject;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp6_ == NULL) {
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = TRUE;
#line 10568 "tracker-sparql-query.c"
	} else {
		const gchar* _tmp7_ = NULL;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = self->priv->current_predicate;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = _tmp7_ == NULL;
#line 10575 "tracker-sparql-query.c"
	}
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp5_) {
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = TRUE;
#line 10581 "tracker-sparql-query.c"
	} else {
		const gchar* _tmp8_ = NULL;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = object;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = _tmp8_ == NULL;
#line 10588 "tracker-sparql-query.c"
	}
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp4_) {
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (object);
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 10596 "tracker-sparql-query.c"
	}
	{
		TrackerSparqlUpdateType _tmp9_ = 0;
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = type;
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp9_ == TRACKER_SPARQL_UPDATE_TYPE_UPDATE) {
#line 10604 "tracker-sparql-query.c"
			const gchar* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp11_ = is_null;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp11_) {
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp10_ = NULL;
#line 10616 "tracker-sparql-query.c"
			} else {
				const gchar* _tmp12_ = NULL;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp12_ = object;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp10_ = _tmp12_;
#line 10623 "tracker-sparql-query.c"
			}
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp13_ = self->priv->current_graph;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp14_ = self->priv->current_subject;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = self->priv->current_predicate;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_data_update_statement (_tmp13_, _tmp14_, _tmp15_, _tmp10_, &_inner_error_);
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 10637 "tracker-sparql-query.c"
					goto __catch3_tracker_sparql_error;
				}
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 10642 "tracker-sparql-query.c"
					goto __catch3_tracker_date_error;
				}
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (object);
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10653 "tracker-sparql-query.c"
			}
		} else {
			TrackerSparqlUpdateType _tmp16_ = 0;
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp16_ = type;
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp16_ == TRACKER_SPARQL_UPDATE_TYPE_DELETE) {
#line 10661 "tracker-sparql-query.c"
				gboolean _tmp17_ = FALSE;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp17_ = is_null;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp17_) {
#line 10671 "tracker-sparql-query.c"
					GError* _tmp18_ = NULL;
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp18_ = tracker_sparql_query_get_error (self, "'null' not supported in this mode");
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_inner_error_ = _tmp18_;
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 10679 "tracker-sparql-query.c"
						goto __catch3_tracker_sparql_error;
					}
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 10684 "tracker-sparql-query.c"
						goto __catch3_tracker_date_error;
					}
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (object);
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 10695 "tracker-sparql-query.c"
				}
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp19_ = self->priv->current_graph;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp20_ = self->priv->current_subject;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp21_ = self->priv->current_predicate;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp22_ = object;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_data_delete_statement (_tmp19_, _tmp20_, _tmp21_, _tmp22_, &_inner_error_);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 10711 "tracker-sparql-query.c"
						goto __catch3_tracker_sparql_error;
					}
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 10716 "tracker-sparql-query.c"
						goto __catch3_tracker_date_error;
					}
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (object);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 10727 "tracker-sparql-query.c"
				}
			} else {
				TrackerSparqlUpdateType _tmp23_ = 0;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp23_ = type;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp23_ == TRACKER_SPARQL_UPDATE_TYPE_INSERT) {
#line 10735 "tracker-sparql-query.c"
					gboolean _tmp24_ = FALSE;
					const gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp24_ = is_null;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp24_) {
#line 10745 "tracker-sparql-query.c"
						GError* _tmp25_ = NULL;
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp25_ = tracker_sparql_query_get_error (self, "'null' not supported in this mode");
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_inner_error_ = _tmp25_;
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 10753 "tracker-sparql-query.c"
							goto __catch3_tracker_sparql_error;
						}
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 10758 "tracker-sparql-query.c"
							goto __catch3_tracker_date_error;
						}
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (object);
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 10769 "tracker-sparql-query.c"
					}
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp26_ = self->priv->current_graph;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp27_ = self->priv->current_subject;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp28_ = self->priv->current_predicate;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp29_ = object;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_data_insert_statement (_tmp26_, _tmp27_, _tmp28_, _tmp29_, &_inner_error_);
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 10785 "tracker-sparql-query.c"
							goto __catch3_tracker_sparql_error;
						}
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 10790 "tracker-sparql-query.c"
							goto __catch3_tracker_date_error;
						}
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (object);
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 10801 "tracker-sparql-query.c"
					}
				}
			}
		}
	}
	goto __finally3;
	__catch3_tracker_sparql_error:
	{
		GError* e = NULL;
		gboolean _tmp30_ = FALSE;
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		e = _inner_error_;
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = NULL;
#line 1043 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp30_ = self->priv->silent;
#line 1043 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp30_) {
#line 10820 "tracker-sparql-query.c"
			GError* _tmp31_ = NULL;
			GError* _tmp32_ = NULL;
#line 1044 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp31_ = e;
#line 1044 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp32_ = _g_error_copy0 (_tmp31_);
#line 1044 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp32_;
#line 1044 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_error_free0 (e);
#line 10831 "tracker-sparql-query.c"
			goto __finally3;
		}
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_error_free0 (e);
#line 10836 "tracker-sparql-query.c"
	}
	goto __finally3;
	__catch3_tracker_date_error:
	{
		GError* e = NULL;
		gboolean _tmp33_ = FALSE;
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		e = _inner_error_;
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = NULL;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp33_ = self->priv->silent;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp33_) {
#line 10851 "tracker-sparql-query.c"
			GError* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			GError* _tmp36_ = NULL;
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp34_ = e;
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp35_ = _tmp34_->message;
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp36_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_TYPE, _tmp35_);
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp36_;
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_error_free0 (e);
#line 10865 "tracker-sparql-query.c"
			goto __finally3;
		}
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_error_free0 (e);
#line 10870 "tracker-sparql-query.c"
	}
	__finally3:
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (object);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 10883 "tracker-sparql-query.c"
		} else {
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (object);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 10893 "tracker-sparql-query.c"
		}
	}
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (object);
#line 10898 "tracker-sparql-query.c"
}


gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->_no_cache;
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp0_;
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 10913 "tracker-sparql-query.c"
}


void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = value;
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_no_cache = _tmp0_;
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_notify ((GObject *) self, "no-cache");
#line 10927 "tracker-sparql-query.c"
}


static TrackerSparqlQueryTokenInfo* tracker_sparql_query_token_info_dup (const TrackerSparqlQueryTokenInfo* self) {
	TrackerSparqlQueryTokenInfo* dup;
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	dup = g_new0 (TrackerSparqlQueryTokenInfo, 1);
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	memcpy (dup, self, sizeof (TrackerSparqlQueryTokenInfo));
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return dup;
#line 10939 "tracker-sparql-query.c"
}


static void tracker_sparql_query_token_info_free (TrackerSparqlQueryTokenInfo* self) {
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_free (self);
#line 10946 "tracker-sparql-query.c"
}


static GType tracker_sparql_query_token_info_get_type (void) {
	static volatile gsize tracker_sparql_query_token_info_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_query_token_info_type_id__volatile)) {
		GType tracker_sparql_query_token_info_type_id;
		tracker_sparql_query_token_info_type_id = g_boxed_type_register_static ("TrackerSparqlQueryTokenInfo", (GBoxedCopyFunc) tracker_sparql_query_token_info_dup, (GBoxedFreeFunc) tracker_sparql_query_token_info_free);
		g_once_init_leave (&tracker_sparql_query_token_info_type_id__volatile, tracker_sparql_query_token_info_type_id);
	}
	return tracker_sparql_query_token_info_type_id__volatile;
}


static void tracker_sparql_query_class_init (TrackerSparqlQueryClass * klass) {
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_parent_class = g_type_class_peek_parent (klass);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlQueryPrivate));
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_query_get_property;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_query_set_property;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_finalize;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_QUERY_NO_CACHE, g_param_spec_boolean ("no-cache", "no-cache", "no-cache", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 10974 "tracker-sparql-query.c"
}


static void tracker_sparql_query_instance_init (TrackerSparqlQuery * self) {
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv = TRACKER_SPARQL_QUERY_GET_PRIVATE (self);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->bnodeid = 0;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->anon_blank_node_open = FALSE;
#line 10985 "tracker-sparql-query.c"
}


static void tracker_sparql_query_finalize (GObject* obj) {
	TrackerSparqlQuery * self;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery);
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->priv->scanner);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->query_string);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->expression);
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->pattern);
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->current_graph);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->current_subject);
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->current_predicate);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	__g_list_free__g_object_unref0_0 (self->bindings);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->context);
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->priv->blank_nodes);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_query_parent_class)->finalize (obj);
#line 11021 "tracker-sparql-query.c"
}


GType tracker_sparql_query_get_type (void) {
	static volatile gsize tracker_sparql_query_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQuery), 0, (GInstanceInitFunc) tracker_sparql_query_instance_init, NULL };
		GType tracker_sparql_query_type_id;
		tracker_sparql_query_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlQuery", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_query_type_id__volatile, tracker_sparql_query_type_id);
	}
	return tracker_sparql_query_type_id__volatile;
}


static void _vala_tracker_sparql_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_QUERY_NO_CACHE:
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_value_set_boolean (value, tracker_sparql_query_get_no_cache (self));
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 11048 "tracker-sparql-query.c"
		default:
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 11054 "tracker-sparql-query.c"
	}
}


static void _vala_tracker_sparql_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_QUERY_NO_CACHE:
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_set_no_cache (self, g_value_get_boolean (value));
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 11070 "tracker-sparql-query.c"
		default:
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 11076 "tracker-sparql-query.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



