/* tracker-turtle-reader.c generated by valac 0.36.3, the Vala compiler
 * generated from tracker-turtle-reader.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-common/tracker-date-time.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"


#define TRACKER_TYPE_TURTLE_READER (tracker_turtle_reader_get_type ())
#define TRACKER_TURTLE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader))
#define TRACKER_TURTLE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderClass))
#define TRACKER_IS_TURTLE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_TURTLE_READER))
#define TRACKER_IS_TURTLE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_TURTLE_READER))
#define TRACKER_TURTLE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderClass))

typedef struct _TrackerTurtleReader TrackerTurtleReader;
typedef struct _TrackerTurtleReaderClass TrackerTurtleReaderClass;
typedef struct _TrackerTurtleReaderPrivate TrackerTurtleReaderPrivate;

#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;

#define TRACKER_TURTLE_READER_TYPE_TOKEN_INFO (tracker_turtle_reader_token_info_get_type ())

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;
typedef struct _TrackerTurtleReaderTokenInfo TrackerTurtleReaderTokenInfo;

#define TRACKER_TURTLE_READER_TYPE_STATE (tracker_turtle_reader_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TrackerTurtleReader {
	GObject parent_instance;
	TrackerTurtleReaderPrivate * priv;
};

struct _TrackerTurtleReaderClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BIND,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NOW,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_RAND,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerTurtleReaderTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

typedef enum  {
	TRACKER_TURTLE_READER_STATE_INITIAL,
	TRACKER_TURTLE_READER_STATE_BOS,
	TRACKER_TURTLE_READER_STATE_SUBJECT,
	TRACKER_TURTLE_READER_STATE_PREDICATE,
	TRACKER_TURTLE_READER_STATE_OBJECT
} TrackerTurtleReaderState;

struct _TrackerTurtleReaderPrivate {
	TrackerSparqlScanner* scanner;
	TrackerTurtleReaderTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	TrackerTurtleReaderState state;
	gchar* _graph;
	gchar* _subject;
	gchar* _predicate;
	gchar* _object;
	gboolean _object_is_uri;
	GHashTable* prefix_map;
	gchar** subject_stack;
	gint subject_stack_length1;
	gint _subject_stack_size_;
	gchar** predicate_stack;
	gint predicate_stack_length1;
	gint _predicate_stack_size_;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	GMappedFile* mapped_file;
};


static gpointer tracker_turtle_reader_parent_class = NULL;

GType tracker_turtle_reader_get_type (void) G_GNUC_CONST;
GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
static GType tracker_turtle_reader_token_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static TrackerTurtleReaderTokenInfo* tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self);
static void tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self);
static GType tracker_turtle_reader_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_TURTLE_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderPrivate))
enum  {
	TRACKER_TURTLE_READER_DUMMY_PROPERTY,
	TRACKER_TURTLE_READER_GRAPH,
	TRACKER_TURTLE_READER_SUBJECT,
	TRACKER_TURTLE_READER_PREDICATE,
	TRACKER_TURTLE_READER_OBJECT,
	TRACKER_TURTLE_READER_OBJECT_IS_URI
};
#define TRACKER_TURTLE_READER_BUFFER_SIZE 32
TrackerTurtleReader* tracker_turtle_reader_new (const gchar* path, GError** error);
TrackerTurtleReader* tracker_turtle_reader_construct (GType object_type, const gchar* path, GError** error);
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
void uuid_generate (guchar* uuid);
static gchar* tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self, const gchar* user_bnodeid);
static inline gboolean tracker_turtle_reader_next_token (TrackerTurtleReader* self, GError** error);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
static inline TrackerSparqlTokenType tracker_turtle_reader_current (TrackerTurtleReader* self);
static inline gboolean tracker_turtle_reader_accept (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_turtle_reader_get_error (TrackerTurtleReader* self, const gchar* msg);
static gboolean tracker_turtle_reader_expect (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);
static gchar* tracker_turtle_reader_get_last_string (TrackerTurtleReader* self, gint strip);
static gchar* tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self, const gchar* prefix, const gchar* local_name, GError** error);
gboolean tracker_turtle_reader_next (TrackerTurtleReader* self, GError** error);
static void tracker_turtle_reader_set_subject (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_set_predicate (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_set_object (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self, gboolean value);
const gchar* tracker_turtle_reader_get_subject (TrackerTurtleReader* self);
static void _vala_array_add12 (gchar** * array, int* length, int* size, gchar* value);
const gchar* tracker_turtle_reader_get_predicate (TrackerTurtleReader* self);
static void _vala_array_add13 (gchar** * array, int* length, int* size, gchar* value);
void tracker_turtle_reader_load (const gchar* path, GError** error);
gboolean tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self);
const gchar* tracker_turtle_reader_get_graph (TrackerTurtleReader* self);
const gchar* tracker_turtle_reader_get_object (TrackerTurtleReader* self);
static void tracker_turtle_reader_set_graph (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_finalize (GObject * obj);
static void _vala_tracker_turtle_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_turtle_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType tracker_turtle_reader_state_get_type (void) {
	static volatile gsize tracker_turtle_reader_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_TURTLE_READER_STATE_INITIAL, "TRACKER_TURTLE_READER_STATE_INITIAL", "initial"}, {TRACKER_TURTLE_READER_STATE_BOS, "TRACKER_TURTLE_READER_STATE_BOS", "bos"}, {TRACKER_TURTLE_READER_STATE_SUBJECT, "TRACKER_TURTLE_READER_STATE_SUBJECT", "subject"}, {TRACKER_TURTLE_READER_STATE_PREDICATE, "TRACKER_TURTLE_READER_STATE_PREDICATE", "predicate"}, {TRACKER_TURTLE_READER_STATE_OBJECT, "TRACKER_TURTLE_READER_STATE_OBJECT", "object"}, {0, NULL, NULL}};
		GType tracker_turtle_reader_state_type_id;
		tracker_turtle_reader_state_type_id = g_enum_register_static ("TrackerTurtleReaderState", values);
		g_once_init_leave (&tracker_turtle_reader_state_type_id__volatile, tracker_turtle_reader_state_type_id);
	}
	return tracker_turtle_reader_state_type_id__volatile;
}


TrackerTurtleReader* tracker_turtle_reader_construct (GType object_type, const gchar* path, GError** error) {
	TrackerTurtleReader * self = NULL;
	GMappedFile* _tmp0_ = NULL;
	const gchar* _tmp1_;
	GMappedFile* _tmp2_;
	GMappedFile* _tmp3_;
	GMappedFile* _tmp4_;
	gchar* _tmp5_;
	GMappedFile* _tmp6_;
	gsize _tmp7_;
	TrackerSparqlScanner* _tmp8_;
	guchar* _tmp9_;
	guchar* _tmp10_;
	gint _tmp10__length1;
	TrackerTurtleReaderTokenInfo* _tmp11_;
	GHashFunc _tmp12_;
	GEqualFunc _tmp13_;
	GDestroyNotify _tmp14_;
	GDestroyNotify _tmp15_;
	GHashTable* _tmp16_;
	GError * _inner_error_ = NULL;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self = (TrackerTurtleReader*) g_object_new (object_type, NULL);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = path;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = g_mapped_file_new (_tmp1_, FALSE, &_inner_error_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = _tmp2_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (_inner_error_->domain == G_FILE_ERROR) {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (self);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 371 "tracker-turtle-reader.c"
		} else {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 379 "tracker-turtle-reader.c"
		}
	}
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = _tmp0_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = NULL;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_mapped_file_unref0 (self->priv->mapped_file);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->mapped_file = _tmp3_;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = self->priv->mapped_file;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = g_mapped_file_get_contents (_tmp4_);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = self->priv->mapped_file;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = g_mapped_file_get_length (_tmp6_);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = tracker_sparql_scanner_new (_tmp5_, _tmp7_);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_object_unref0 (self->priv->scanner);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->scanner = _tmp8_;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp9_ = g_new0 (guchar, 16);
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid = _tmp9_;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid_length1 = 16;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->_base_uuid_size_ = self->priv->base_uuid_length1;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10_ = self->priv->base_uuid;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10__length1 = self->priv->base_uuid_length1;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	uuid_generate (_tmp10_);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp11_ = g_new0 (TrackerTurtleReaderTokenInfo, TRACKER_TURTLE_READER_BUFFER_SIZE);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens = _tmp11_;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens_length1 = TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->_tokens_size_ = self->priv->tokens_length1;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12_ = g_str_hash;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp13_ = g_str_equal;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp14_ = g_free;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp15_ = g_free;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp16_ = g_hash_table_new_full (_tmp12_, _tmp13_, _tmp14_, _tmp15_);
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->prefix_map = _tmp16_;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_mapped_file_unref0 (_tmp0_);
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return self;
#line 448 "tracker-turtle-reader.c"
}


TrackerTurtleReader* tracker_turtle_reader_new (const gchar* path, GError** error) {
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return tracker_turtle_reader_construct (TRACKER_TYPE_TURTLE_READER, path, error);
#line 455 "tracker-turtle-reader.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 478 "tracker-turtle-reader.c"
		glong _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 486 "tracker-turtle-reader.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 498 "tracker-turtle-reader.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1333 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 522 "tracker-turtle-reader.c"
		glong _tmp2_;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 528 "tracker-turtle-reader.c"
	} else {
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 532 "tracker-turtle-reader.c"
	}
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 536 "tracker-turtle-reader.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 548 "tracker-turtle-reader.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 558 "tracker-turtle-reader.c"
	}
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 564 "tracker-turtle-reader.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 578 "tracker-turtle-reader.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 588 "tracker-turtle-reader.c"
	}
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 594 "tracker-turtle-reader.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 603 "tracker-turtle-reader.c"
	}
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 623 "tracker-turtle-reader.c"
}


static gchar* tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self, const gchar* user_bnodeid) {
	gchar* result = NULL;
	const gchar* _tmp0_;
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = user_bnodeid;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp0_ == NULL) {
#line 636 "tracker-turtle-reader.c"
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = self->priv->bnodeid;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->bnodeid = _tmp1_ + 1;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp2_ = self->priv->bnodeid;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp3_ = g_strdup_printf (":%d", _tmp2_);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = _tmp3_;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 652 "tracker-turtle-reader.c"
	} else {
		GChecksum* checksum = NULL;
		GChecksum* _tmp4_;
		GChecksum* _tmp5_;
		guchar* _tmp6_;
		gint _tmp6__length1;
		GChecksum* _tmp7_;
		const gchar* _tmp8_;
		gchar* sha1 = NULL;
		GChecksum* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp4_ = g_checksum_new (G_CHECKSUM_SHA1);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		checksum = _tmp4_;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp5_ = checksum;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6_ = self->priv->base_uuid;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6__length1 = self->priv->base_uuid_length1;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_checksum_update (_tmp5_, _tmp6_, (gsize) 16);
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_ = checksum;
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp8_ = user_bnodeid;
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_checksum_update (_tmp7_, (guchar*) _tmp8_, (gsize) -1);
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9_ = checksum;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10_ = g_checksum_get_string (_tmp9_);
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		sha1 = _tmp11_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp12_ = sha1;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp13_ = sha1;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp14_ = string_substring (_tmp13_, (glong) 8, (glong) -1);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp15_ = _tmp14_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp16_ = sha1;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp17_ = string_substring (_tmp16_, (glong) 12, (glong) -1);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp18_ = _tmp17_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp19_ = sha1;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp20_ = string_substring (_tmp19_, (glong) 16, (glong) -1);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp21_ = _tmp20_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp22_ = sha1;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp23_ = string_substring (_tmp22_, (glong) 20, (glong) -1);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp24_ = _tmp23_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp25_ = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", _tmp12_, _tmp15_, _tmp18_, _tmp21_, _tmp24_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp26_ = _tmp25_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp24_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp21_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp18_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp15_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = _tmp26_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (sha1);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_checksum_free0 (checksum);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 752 "tracker-turtle-reader.c"
	}
}


static inline gboolean tracker_turtle_reader_next_token (TrackerTurtleReader* self, GError** error) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	TrackerTurtleReaderTokenInfo* _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_;
	TrackerTurtleReaderTokenInfo _tmp20_;
	TrackerSparqlTokenType _tmp21_;
	GError * _inner_error_ = NULL;
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->index;
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->index = (_tmp0_ + 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = self->priv->size;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->size = _tmp1_ - 1;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = self->priv->size;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp2_ <= 0) {
#line 782 "tracker-turtle-reader.c"
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSparqlTokenType type = 0;
		TrackerSparqlScanner* _tmp3_;
		TrackerSourceLocation _tmp4_ = {0};
		TrackerSourceLocation _tmp5_ = {0};
		TrackerSparqlTokenType _tmp6_;
		TrackerTurtleReaderTokenInfo* _tmp9_;
		gint _tmp9__length1;
		gint _tmp10_;
		TrackerSparqlTokenType _tmp11_;
		TrackerTurtleReaderTokenInfo* _tmp12_;
		gint _tmp12__length1;
		gint _tmp13_;
		TrackerSourceLocation _tmp14_;
		TrackerTurtleReaderTokenInfo* _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_;
		TrackerSourceLocation _tmp17_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp3_ = self->priv->scanner;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6_ = tracker_sparql_scanner_read_token (_tmp3_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		begin = _tmp4_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		end = _tmp5_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		type = _tmp6_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 816 "tracker-turtle-reader.c"
				gboolean _tmp7_ = FALSE;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return _tmp7_;
#line 822 "tracker-turtle-reader.c"
			} else {
				gboolean _tmp8_ = FALSE;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return _tmp8_;
#line 831 "tracker-turtle-reader.c"
			}
		}
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9_ = self->priv->tokens;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9__length1 = self->priv->tokens_length1;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10_ = self->priv->index;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp11_ = type;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9_[_tmp10_].type = _tmp11_;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp12_ = self->priv->tokens;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp12__length1 = self->priv->tokens_length1;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp13_ = self->priv->index;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp14_ = begin;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp12_[_tmp13_].begin = _tmp14_;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp15_ = self->priv->tokens;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp15__length1 = self->priv->tokens_length1;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp16_ = self->priv->index;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp17_ = end;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp15_[_tmp16_].end = _tmp17_;
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->size = 1;
#line 866 "tracker-turtle-reader.c"
	}
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp18_ = self->priv->tokens;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp18__length1 = self->priv->tokens_length1;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp19_ = self->priv->index;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp20_ = _tmp18_[_tmp19_];
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp21_ = _tmp20_.type;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp21_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 882 "tracker-turtle-reader.c"
}


static inline TrackerSparqlTokenType tracker_turtle_reader_current (TrackerTurtleReader* self) {
	TrackerSparqlTokenType result = 0;
	TrackerTurtleReaderTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	TrackerTurtleReaderTokenInfo _tmp2_;
	TrackerSparqlTokenType _tmp3_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->tokens;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = self->priv->index;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = _tmp2_.type;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp3_;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 909 "tracker-turtle-reader.c"
}


static inline gboolean tracker_turtle_reader_accept (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlTokenType _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	GError * _inner_error_ = NULL;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = tracker_turtle_reader_current (self);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = type;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp0_ == _tmp1_) {
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_next_token (self, &_inner_error_);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 932 "tracker-turtle-reader.c"
				gboolean _tmp2_ = FALSE;
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return _tmp2_;
#line 938 "tracker-turtle-reader.c"
			} else {
				gboolean _tmp3_ = FALSE;
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error_);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return _tmp3_;
#line 947 "tracker-turtle-reader.c"
			}
		}
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = TRUE;
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 954 "tracker-turtle-reader.c"
	}
#line 120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = FALSE;
#line 120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 960 "tracker-turtle-reader.c"
}


static GError* tracker_turtle_reader_get_error (TrackerTurtleReader* self, const gchar* msg) {
	GError* result = NULL;
	TrackerTurtleReaderTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	TrackerTurtleReaderTokenInfo _tmp2_;
	TrackerSourceLocation _tmp3_;
	gint _tmp4_;
	TrackerTurtleReaderTokenInfo* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	TrackerTurtleReaderTokenInfo _tmp7_;
	TrackerSourceLocation _tmp8_;
	gint _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->tokens;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = self->priv->index;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = _tmp2_.begin;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = _tmp3_.line;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = self->priv->tokens;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5__length1 = self->priv->tokens_length1;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = self->priv->index;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = _tmp5_[_tmp6_];
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = _tmp7_.begin;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp9_ = _tmp8_.column;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10_ = msg;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp11_ = g_strdup_printf ("%d.%d: syntax error, %s", _tmp4_, _tmp9_, _tmp10_);
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12_ = _tmp11_;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp13_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp12_);
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp14_ = _tmp13_;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (_tmp12_);
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp14_;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 1027 "tracker-turtle-reader.c"
}


static gboolean tracker_turtle_reader_expect (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_;
	TrackerSparqlTokenType _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError * _inner_error_ = NULL;
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = type;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = tracker_turtle_reader_accept (self, _tmp1_, &_inner_error_);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = _tmp2_;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1055 "tracker-turtle-reader.c"
			gboolean _tmp3_ = FALSE;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return _tmp3_;
#line 1061 "tracker-turtle-reader.c"
		} else {
			gboolean _tmp4_ = FALSE;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return _tmp4_;
#line 1070 "tracker-turtle-reader.c"
		}
	}
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp0_) {
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = TRUE;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 1079 "tracker-turtle-reader.c"
	}
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = type;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = tracker_sparql_token_type_to_string (_tmp5_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = g_strdup_printf ("expected %s", _tmp6_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = _tmp7_;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp9_ = tracker_turtle_reader_get_error (self, _tmp8_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10_ = _tmp9_;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (_tmp8_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_inner_error_ = _tmp10_;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1099 "tracker-turtle-reader.c"
		gboolean _tmp11_ = FALSE;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_propagate_error (error, _inner_error_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return _tmp11_;
#line 1105 "tracker-turtle-reader.c"
	} else {
		gboolean _tmp12_ = FALSE;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_clear_error (&_inner_error_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return _tmp12_;
#line 1114 "tracker-turtle-reader.c"
	}
}


static gchar* tracker_turtle_reader_get_last_string (TrackerTurtleReader* self, gint strip) {
	gchar* result = NULL;
	gint last_index = 0;
	gint _tmp0_;
	TrackerTurtleReaderTokenInfo* _tmp1_;
	gint _tmp1__length1;
	TrackerTurtleReaderTokenInfo _tmp2_;
	TrackerSourceLocation _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	TrackerTurtleReaderTokenInfo* _tmp6_;
	gint _tmp6__length1;
	TrackerTurtleReaderTokenInfo _tmp7_;
	TrackerSourceLocation _tmp8_;
	gchar* _tmp9_;
	TrackerTurtleReaderTokenInfo* _tmp10_;
	gint _tmp10__length1;
	TrackerTurtleReaderTokenInfo _tmp11_;
	TrackerSourceLocation _tmp12_;
	gchar* _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->index;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	last_index = ((_tmp0_ + TRACKER_TURTLE_READER_BUFFER_SIZE) - 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = self->priv->tokens;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1__length1 = self->priv->tokens_length1;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = _tmp1_[last_index];
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = _tmp2_.begin;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = _tmp3_.pos;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = strip;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = self->priv->tokens;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6__length1 = self->priv->tokens_length1;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = _tmp6_[last_index];
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = _tmp7_.end;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp9_ = _tmp8_.pos;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10_ = self->priv->tokens;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10__length1 = self->priv->tokens_length1;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp11_ = _tmp10_[last_index];
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12_ = _tmp11_.begin;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp13_ = _tmp12_.pos;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp14_ = strip;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp15_ = string_substring ((const gchar*) (_tmp4_ + _tmp5_), (glong) 0, (glong) ((gint) ((_tmp9_ - _tmp13_) - (2 * _tmp14_))));
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp15_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 1187 "tracker-turtle-reader.c"
}


static gchar* tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self, const gchar* prefix, const gchar* local_name, GError** error) {
	gchar* result = NULL;
	gchar* ns = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (local_name != NULL, NULL);
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->prefix_map;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = prefix;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	ns = _tmp3_;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = ns;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp4_ == NULL) {
#line 1223 "tracker-turtle-reader.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp5_ = prefix;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6_ = g_strdup_printf ("use of undefined prefix `%s'", _tmp5_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_ = _tmp6_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp8_ = tracker_turtle_reader_get_error (self, _tmp7_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9_ = _tmp8_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp7_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error_ = _tmp9_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_free0 (ns);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 1251 "tracker-turtle-reader.c"
		} else {
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_free0 (ns);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 1261 "tracker-turtle-reader.c"
		}
	}
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10_ = ns;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp11_ = local_name;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp12_;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (ns);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 1276 "tracker-turtle-reader.c"
}


static void _vala_array_add12 (gchar** * array, int* length, int* size, gchar* value) {
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if ((*length) == (*size)) {
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1287 "tracker-turtle-reader.c"
	}
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(*array)[(*length)++] = value;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(*array)[*length] = NULL;
#line 1293 "tracker-turtle-reader.c"
}


static void _vala_array_add13 (gchar** * array, int* length, int* size, gchar* value) {
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if ((*length) == (*size)) {
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1304 "tracker-turtle-reader.c"
	}
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(*array)[(*length)++] = value;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(*array)[*length] = NULL;
#line 1310 "tracker-turtle-reader.c"
}


gboolean tracker_turtle_reader_next (TrackerTurtleReader* self, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	while (TRUE) {
#line 1321 "tracker-turtle-reader.c"
		TrackerTurtleReaderState _tmp0_;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = self->priv->state;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		switch (_tmp0_) {
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_INITIAL:
#line 1329 "tracker-turtle-reader.c"
			{
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				tracker_turtle_reader_next_token (self, &_inner_error_);
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1337 "tracker-turtle-reader.c"
						gboolean _tmp1_ = FALSE;
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp1_;
#line 1343 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp2_ = FALSE;
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp2_;
#line 1352 "tracker-turtle-reader.c"
					}
				}
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				continue;
#line 1359 "tracker-turtle-reader.c"
			}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_BOS:
#line 1363 "tracker-turtle-reader.c"
			{
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp4_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, &_inner_error_);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp3_ = _tmp4_;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1377 "tracker-turtle-reader.c"
						gboolean _tmp5_ = FALSE;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp5_;
#line 1383 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp6_ = FALSE;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp6_;
#line 1392 "tracker-turtle-reader.c"
					}
				}
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp3_) {
#line 1397 "tracker-turtle-reader.c"
					gchar* ns = NULL;
					gchar* _tmp7_;
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_;
					gchar* uri = NULL;
					gchar* _tmp17_;
					GHashTable* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp7_ = g_strdup ("");
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					ns = _tmp7_;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp9_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp8_ = _tmp9_;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1421 "tracker-turtle-reader.c"
							gboolean _tmp10_ = FALSE;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp10_;
#line 1429 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp11_ = FALSE;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp11_;
#line 1440 "tracker-turtle-reader.c"
						}
					}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp8_) {
#line 1445 "tracker-turtle-reader.c"
						gchar* _tmp12_;
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp12_ = tracker_turtle_reader_get_last_string (self, 0);
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp12_;
#line 1453 "tracker-turtle-reader.c"
					}
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1461 "tracker-turtle-reader.c"
							gboolean _tmp13_ = FALSE;
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp13_;
#line 1469 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp14_ = FALSE;
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp14_;
#line 1480 "tracker-turtle-reader.c"
						}
					}
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1489 "tracker-turtle-reader.c"
							gboolean _tmp15_ = FALSE;
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp15_;
#line 1497 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp16_ = FALSE;
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp16_;
#line 1508 "tracker-turtle-reader.c"
						}
					}
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp17_ = tracker_turtle_reader_get_last_string (self, 1);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					uri = _tmp17_;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp18_ = self->priv->prefix_map;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp19_ = ns;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp20_ = g_strdup (_tmp19_);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp21_ = uri;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp22_ = g_strdup (_tmp21_);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_hash_table_insert (_tmp18_, _tmp20_, _tmp22_);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1533 "tracker-turtle-reader.c"
							gboolean _tmp23_ = FALSE;
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (uri);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp23_;
#line 1543 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp24_ = FALSE;
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (uri);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp24_;
#line 1556 "tracker-turtle-reader.c"
						}
					}
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_free0 (uri);
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_free0 (ns);
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 1565 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp25_ = FALSE;
					gboolean _tmp26_;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp26_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATBASE, &_inner_error_);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp25_ = _tmp26_;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1577 "tracker-turtle-reader.c"
							gboolean _tmp27_ = FALSE;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp27_;
#line 1583 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp28_ = FALSE;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp28_;
#line 1592 "tracker-turtle-reader.c"
						}
					}
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp25_) {
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1603 "tracker-turtle-reader.c"
								gboolean _tmp29_ = FALSE;
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp29_;
#line 1609 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp30_ = FALSE;
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp30_;
#line 1618 "tracker-turtle-reader.c"
							}
						}
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1627 "tracker-turtle-reader.c"
								gboolean _tmp31_ = FALSE;
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp31_;
#line 1633 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp32_ = FALSE;
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp32_;
#line 1642 "tracker-turtle-reader.c"
							}
						}
#line 171 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 1647 "tracker-turtle-reader.c"
					} else {
						TrackerSparqlTokenType _tmp33_;
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp33_ = tracker_turtle_reader_current (self);
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp33_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							result = FALSE;
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return result;
#line 1658 "tracker-turtle-reader.c"
						}
					}
				}
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp35_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp34_ = _tmp35_;
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1670 "tracker-turtle-reader.c"
						gboolean _tmp36_ = FALSE;
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp36_;
#line 1676 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp37_ = FALSE;
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp37_;
#line 1685 "tracker-turtle-reader.c"
					}
				}
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp34_) {
#line 1690 "tracker-turtle-reader.c"
					gchar* _tmp38_;
					gchar* _tmp39_;
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp38_ = tracker_turtle_reader_get_last_string (self, 1);
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp39_ = _tmp38_;
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_subject (self, _tmp39_);
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_free0 (_tmp39_);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 1705 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp40_ = FALSE;
					gboolean _tmp41_;
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp41_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp40_ = _tmp41_;
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1717 "tracker-turtle-reader.c"
							gboolean _tmp42_ = FALSE;
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp42_;
#line 1723 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp43_ = FALSE;
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp43_;
#line 1732 "tracker-turtle-reader.c"
						}
					}
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp40_) {
#line 1737 "tracker-turtle-reader.c"
						gchar* ns = NULL;
						gchar* _tmp44_;
						gchar* _tmp47_ = NULL;
						const gchar* _tmp48_;
						gchar* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp44_ = tracker_turtle_reader_get_last_string (self, 0);
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp44_;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1758 "tracker-turtle-reader.c"
								gboolean _tmp45_ = FALSE;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp45_;
#line 1766 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp46_ = FALSE;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp46_;
#line 1777 "tracker-turtle-reader.c"
							}
						}
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp48_ = ns;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp49_ = tracker_turtle_reader_get_last_string (self, 0);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp50_ = _tmp49_;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp51_ = string_substring (_tmp50_, (glong) 1, (glong) -1);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp52_ = _tmp51_;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp53_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp48_, _tmp52_, &_inner_error_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp54_ = _tmp53_;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp52_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp50_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp47_ = _tmp54_;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1804 "tracker-turtle-reader.c"
								gboolean _tmp55_ = FALSE;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp55_;
#line 1812 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp56_ = FALSE;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp56_;
#line 1823 "tracker-turtle-reader.c"
							}
						}
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_subject (self, _tmp47_);
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp47_);
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 1836 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp57_ = FALSE;
						gboolean _tmp58_;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp58_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp57_ = _tmp58_;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1848 "tracker-turtle-reader.c"
								gboolean _tmp59_ = FALSE;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp59_;
#line 1854 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp60_ = FALSE;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp60_;
#line 1863 "tracker-turtle-reader.c"
							}
						}
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp57_) {
#line 1868 "tracker-turtle-reader.c"
							gchar* _tmp61_ = NULL;
							gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp64_;
							gchar* _tmp65_;
							gchar* _tmp66_;
							gchar* _tmp67_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp62_ = tracker_turtle_reader_get_last_string (self, 0);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp63_ = _tmp62_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp64_ = string_substring (_tmp63_, (glong) 1, (glong) -1);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp65_ = _tmp64_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp66_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp65_, &_inner_error_);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp67_ = _tmp66_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp65_);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp63_);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp61_ = _tmp67_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1898 "tracker-turtle-reader.c"
									gboolean _tmp68_ = FALSE;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp68_;
#line 1904 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp69_ = FALSE;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp69_;
#line 1913 "tracker-turtle-reader.c"
								}
							}
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_subject (self, _tmp61_);
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp61_);
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							continue;
#line 1924 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp70_ = FALSE;
							gboolean _tmp71_;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp71_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp70_ = _tmp71_;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1936 "tracker-turtle-reader.c"
									gboolean _tmp72_ = FALSE;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp72_;
#line 1942 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp73_ = FALSE;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp73_;
#line 1951 "tracker-turtle-reader.c"
								}
							}
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp70_) {
#line 1956 "tracker-turtle-reader.c"
								gchar* _tmp76_;
								gchar* _tmp77_;
								gchar* _tmp78_;
								gchar* _tmp79_;
								gchar* _tmp80_;
								gchar* _tmp81_;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1969 "tracker-turtle-reader.c"
										gboolean _tmp74_ = FALSE;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error_);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp74_;
#line 1975 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp75_ = FALSE;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_clear_error (&_inner_error_);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp75_;
#line 1984 "tracker-turtle-reader.c"
									}
								}
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp76_ = tracker_turtle_reader_get_last_string (self, 0);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp77_ = _tmp76_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp78_ = string_substring (_tmp77_, (glong) 1, (glong) -1);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp79_ = _tmp78_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp80_ = tracker_turtle_reader_generate_bnodeid (self, _tmp79_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp81_ = _tmp80_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_subject (self, _tmp81_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp81_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp79_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp77_);
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								continue;
#line 2011 "tracker-turtle-reader.c"
							} else {
								GError* _tmp82_;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp82_ = tracker_turtle_reader_get_error (self, "expected subject");
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_inner_error_ = _tmp82_;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2020 "tracker-turtle-reader.c"
									gboolean _tmp83_ = FALSE;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp83_;
#line 2026 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp84_ = FALSE;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp84_;
#line 2035 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_SUBJECT:
#line 2044 "tracker-turtle-reader.c"
			{
				gboolean _tmp85_ = FALSE;
				gboolean _tmp86_;
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp86_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp85_ = _tmp86_;
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2056 "tracker-turtle-reader.c"
						gboolean _tmp87_ = FALSE;
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp87_;
#line 2062 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp88_ = FALSE;
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp88_;
#line 2071 "tracker-turtle-reader.c"
					}
				}
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp85_) {
#line 2076 "tracker-turtle-reader.c"
					gchar* _tmp89_;
					gchar* _tmp90_;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp89_ = tracker_turtle_reader_get_last_string (self, 1);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp90_ = _tmp89_;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_predicate (self, _tmp90_);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_free0 (_tmp90_);
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 2091 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp91_ = FALSE;
					gboolean _tmp92_;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp92_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp91_ = _tmp92_;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2103 "tracker-turtle-reader.c"
							gboolean _tmp93_ = FALSE;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp93_;
#line 2109 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp94_ = FALSE;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp94_;
#line 2118 "tracker-turtle-reader.c"
						}
					}
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp91_) {
#line 2123 "tracker-turtle-reader.c"
						gchar* ns = NULL;
						gchar* _tmp95_;
						gchar* _tmp98_ = NULL;
						const gchar* _tmp99_;
						gchar* _tmp100_;
						gchar* _tmp101_;
						gchar* _tmp102_;
						gchar* _tmp103_;
						gchar* _tmp104_;
						gchar* _tmp105_;
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp95_ = tracker_turtle_reader_get_last_string (self, 0);
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp95_;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2144 "tracker-turtle-reader.c"
								gboolean _tmp96_ = FALSE;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp96_;
#line 2152 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp97_ = FALSE;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp97_;
#line 2163 "tracker-turtle-reader.c"
							}
						}
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp99_ = ns;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp100_ = tracker_turtle_reader_get_last_string (self, 0);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp101_ = _tmp100_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp102_ = string_substring (_tmp101_, (glong) 1, (glong) -1);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp103_ = _tmp102_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp104_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp99_, _tmp103_, &_inner_error_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp105_ = _tmp104_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp103_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp101_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp98_ = _tmp105_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2190 "tracker-turtle-reader.c"
								gboolean _tmp106_ = FALSE;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp106_;
#line 2198 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp107_ = FALSE;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp107_;
#line 2209 "tracker-turtle-reader.c"
							}
						}
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_predicate (self, _tmp98_);
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp98_);
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 2222 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp108_ = FALSE;
						gboolean _tmp109_;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp109_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp108_ = _tmp109_;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2234 "tracker-turtle-reader.c"
								gboolean _tmp110_ = FALSE;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp110_;
#line 2240 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp111_ = FALSE;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp111_;
#line 2249 "tracker-turtle-reader.c"
							}
						}
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp108_) {
#line 2254 "tracker-turtle-reader.c"
							gchar* _tmp112_ = NULL;
							gchar* _tmp113_;
							gchar* _tmp114_;
							gchar* _tmp115_;
							gchar* _tmp116_;
							gchar* _tmp117_;
							gchar* _tmp118_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp113_ = tracker_turtle_reader_get_last_string (self, 0);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp114_ = _tmp113_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp115_ = string_substring (_tmp114_, (glong) 1, (glong) -1);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp116_ = _tmp115_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp117_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp116_, &_inner_error_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp118_ = _tmp117_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp116_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp114_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp112_ = _tmp118_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2284 "tracker-turtle-reader.c"
									gboolean _tmp119_ = FALSE;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp119_;
#line 2290 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp120_ = FALSE;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp120_;
#line 2299 "tracker-turtle-reader.c"
								}
							}
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_predicate (self, _tmp112_);
#line 215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp112_);
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							continue;
#line 2310 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp121_ = FALSE;
							gboolean _tmp122_;
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp122_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_A, &_inner_error_);
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp121_ = _tmp122_;
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2322 "tracker-turtle-reader.c"
									gboolean _tmp123_ = FALSE;
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp123_;
#line 2328 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp124_ = FALSE;
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp124_;
#line 2337 "tracker-turtle-reader.c"
								}
							}
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp121_) {
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_predicate (self, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
#line 219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								continue;
#line 2348 "tracker-turtle-reader.c"
							} else {
								GError* _tmp125_;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp125_ = tracker_turtle_reader_get_error (self, "expected predicate");
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_inner_error_ = _tmp125_;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2357 "tracker-turtle-reader.c"
									gboolean _tmp126_ = FALSE;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp126_;
#line 2363 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp127_ = FALSE;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp127_;
#line 2372 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_PREDICATE:
#line 2381 "tracker-turtle-reader.c"
			{
				gboolean _tmp128_ = FALSE;
				gboolean _tmp129_;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp129_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp128_ = _tmp129_;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2393 "tracker-turtle-reader.c"
						gboolean _tmp130_ = FALSE;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp130_;
#line 2399 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp131_ = FALSE;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp131_;
#line 2408 "tracker-turtle-reader.c"
					}
				}
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp128_) {
#line 2413 "tracker-turtle-reader.c"
					gchar* _tmp132_;
					gchar* _tmp133_;
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp132_ = tracker_turtle_reader_get_last_string (self, 1);
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp133_ = _tmp132_;
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_object (self, _tmp133_);
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_free0 (_tmp133_);
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					result = TRUE;
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					return result;
#line 2432 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp134_ = FALSE;
					gboolean _tmp135_;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp135_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp134_ = _tmp135_;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2444 "tracker-turtle-reader.c"
							gboolean _tmp136_ = FALSE;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp136_;
#line 2450 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp137_ = FALSE;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp137_;
#line 2459 "tracker-turtle-reader.c"
						}
					}
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp134_) {
#line 2464 "tracker-turtle-reader.c"
						gchar* ns = NULL;
						gchar* _tmp138_;
						gchar* _tmp141_ = NULL;
						const gchar* _tmp142_;
						gchar* _tmp143_;
						gchar* _tmp144_;
						gchar* _tmp145_;
						gchar* _tmp146_;
						gchar* _tmp147_;
						gchar* _tmp148_;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp138_ = tracker_turtle_reader_get_last_string (self, 0);
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp138_;
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2485 "tracker-turtle-reader.c"
								gboolean _tmp139_ = FALSE;
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp139_;
#line 2493 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp140_ = FALSE;
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp140_;
#line 2504 "tracker-turtle-reader.c"
							}
						}
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp142_ = ns;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp143_ = tracker_turtle_reader_get_last_string (self, 0);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp144_ = _tmp143_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp145_ = string_substring (_tmp144_, (glong) 1, (glong) -1);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp146_ = _tmp145_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp147_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp142_, _tmp146_, &_inner_error_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp148_ = _tmp147_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp146_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp144_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp141_ = _tmp148_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2531 "tracker-turtle-reader.c"
								gboolean _tmp149_ = FALSE;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp149_;
#line 2539 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp150_ = FALSE;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp150_;
#line 2550 "tracker-turtle-reader.c"
							}
						}
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_object (self, _tmp141_);
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						result = TRUE;
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp141_);
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return result;
#line 2567 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp151_ = FALSE;
						gboolean _tmp152_;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp152_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp151_ = _tmp152_;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2579 "tracker-turtle-reader.c"
								gboolean _tmp153_ = FALSE;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp153_;
#line 2585 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp154_ = FALSE;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp154_;
#line 2594 "tracker-turtle-reader.c"
							}
						}
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp151_) {
#line 2599 "tracker-turtle-reader.c"
							gchar* _tmp155_ = NULL;
							gchar* _tmp156_;
							gchar* _tmp157_;
							gchar* _tmp158_;
							gchar* _tmp159_;
							gchar* _tmp160_;
							gchar* _tmp161_;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp156_ = tracker_turtle_reader_get_last_string (self, 0);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp157_ = _tmp156_;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp158_ = string_substring (_tmp157_, (glong) 1, (glong) -1);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp159_ = _tmp158_;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp160_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp159_, &_inner_error_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp161_ = _tmp160_;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp159_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp157_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp155_ = _tmp161_;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2629 "tracker-turtle-reader.c"
									gboolean _tmp162_ = FALSE;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp162_;
#line 2635 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp163_ = FALSE;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp163_;
#line 2644 "tracker-turtle-reader.c"
								}
							}
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object (self, _tmp155_);
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							result = TRUE;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp155_);
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return result;
#line 2659 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp164_ = FALSE;
							gboolean _tmp165_;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp165_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp164_ = _tmp165_;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2671 "tracker-turtle-reader.c"
									gboolean _tmp166_ = FALSE;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp166_;
#line 2677 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp167_ = FALSE;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp167_;
#line 2686 "tracker-turtle-reader.c"
								}
							}
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp164_) {
#line 2691 "tracker-turtle-reader.c"
								gchar* _tmp170_;
								gchar* _tmp171_;
								gchar* _tmp172_;
								gchar* _tmp173_;
								gchar* _tmp174_;
								gchar* _tmp175_;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2704 "tracker-turtle-reader.c"
										gboolean _tmp168_ = FALSE;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp168_;
#line 2710 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp169_ = FALSE;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_clear_error (&_inner_error_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp169_;
#line 2719 "tracker-turtle-reader.c"
									}
								}
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp170_ = tracker_turtle_reader_get_last_string (self, 0);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp171_ = _tmp170_;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp172_ = string_substring (_tmp171_, (glong) 1, (glong) -1);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp173_ = _tmp172_;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp174_ = tracker_turtle_reader_generate_bnodeid (self, _tmp173_);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp175_ = _tmp174_;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_object (self, _tmp175_);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp175_);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp173_);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp171_);
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								result = TRUE;
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return result;
#line 2750 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp176_ = FALSE;
								gboolean _tmp177_;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp177_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, &_inner_error_);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp176_ = _tmp177_;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2762 "tracker-turtle-reader.c"
										gboolean _tmp178_ = FALSE;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error_);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp178_;
#line 2768 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp179_ = FALSE;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_clear_error (&_inner_error_);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp179_;
#line 2777 "tracker-turtle-reader.c"
									}
								}
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_tmp176_) {
#line 2782 "tracker-turtle-reader.c"
									gchar** _tmp180_;
									gint _tmp180__length1;
									const gchar* _tmp181_;
									gchar* _tmp182_;
									gchar** _tmp183_;
									gint _tmp183__length1;
									const gchar* _tmp184_;
									gchar* _tmp185_;
									gchar* _tmp186_;
									gchar* _tmp187_;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp180_ = self->priv->subject_stack;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp180__length1 = self->priv->subject_stack_length1;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp181_ = self->priv->_subject;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp182_ = g_strdup (_tmp181_);
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_vala_array_add12 (&self->priv->subject_stack, &self->priv->subject_stack_length1, &self->priv->_subject_stack_size_, _tmp182_);
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp183_ = self->priv->predicate_stack;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp183__length1 = self->priv->predicate_stack_length1;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp184_ = self->priv->_predicate;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp185_ = g_strdup (_tmp184_);
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_vala_array_add13 (&self->priv->predicate_stack, &self->priv->predicate_stack_length1, &self->priv->_predicate_stack_size_, _tmp185_);
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp186_ = tracker_turtle_reader_generate_bnodeid (self, NULL);
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp187_ = _tmp186_;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									tracker_turtle_reader_set_subject (self, _tmp187_);
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_g_free0 (_tmp187_);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									continue;
#line 2825 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp188_ = FALSE;
									gboolean _tmp189_ = FALSE;
									gboolean _tmp190_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp190_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, &_inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp189_ = _tmp190_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2838 "tracker-turtle-reader.c"
											gboolean _tmp191_ = FALSE;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											g_propagate_error (error, _inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											return _tmp191_;
#line 2844 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp192_ = FALSE;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											g_clear_error (&_inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											return _tmp192_;
#line 2853 "tracker-turtle-reader.c"
										}
									}
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_tmp189_) {
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp188_ = TRUE;
#line 2860 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp193_ = FALSE;
										gboolean _tmp194_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp194_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, &_inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp193_ = _tmp194_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2872 "tracker-turtle-reader.c"
												gboolean _tmp195_ = FALSE;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp195_;
#line 2878 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp196_ = FALSE;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_clear_error (&_inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp196_;
#line 2887 "tracker-turtle-reader.c"
											}
										}
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp188_ = _tmp193_;
#line 2892 "tracker-turtle-reader.c"
									}
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_tmp188_) {
#line 2896 "tracker-turtle-reader.c"
										GString* sb = NULL;
										GString* _tmp197_;
										gchar* s = NULL;
										gchar* _tmp198_;
										const gchar* p = NULL;
										const gchar* _tmp199_;
										const gchar* end = NULL;
										const gchar* _tmp200_;
										const gchar* _tmp201_;
										gint _tmp202_;
										gint _tmp203_;
										GString* _tmp230_;
										const gchar* _tmp231_;
										gboolean _tmp232_ = FALSE;
										gboolean _tmp233_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp197_ = g_string_new ("");
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										sb = _tmp197_;
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp198_ = tracker_turtle_reader_get_last_string (self, 1);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										s = _tmp198_;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp199_ = s;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										p = _tmp199_;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp200_ = p;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp201_ = s;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp202_ = strlen (_tmp201_);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp203_ = _tmp202_;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										end = _tmp200_ + _tmp203_;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										while (TRUE) {
#line 2936 "tracker-turtle-reader.c"
											const gchar* _tmp204_;
											const gchar* _tmp205_;
											const gchar* q = NULL;
											const gchar* _tmp206_;
											const gchar* _tmp207_;
											const gchar* _tmp208_;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp204_ = p;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp205_ = end;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (!(((glong) _tmp204_) < ((glong) _tmp205_))) {
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												break;
#line 2951 "tracker-turtle-reader.c"
											}
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp206_ = p;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp207_ = strchr (_tmp206_, (gint) '\\');
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											q = _tmp207_;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp208_ = q;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp208_ == NULL) {
#line 2963 "tracker-turtle-reader.c"
												GString* _tmp209_;
												const gchar* _tmp210_;
												const gchar* _tmp211_;
												const gchar* _tmp212_;
												const gchar* _tmp213_;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp209_ = sb;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp210_ = p;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp211_ = end;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp212_ = p;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_string_append_len (_tmp209_, _tmp210_, (gssize) ((glong) (_tmp211_ - _tmp212_)));
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp213_ = end;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												p = _tmp213_;
#line 2983 "tracker-turtle-reader.c"
											} else {
												GString* _tmp214_;
												const gchar* _tmp215_;
												const gchar* _tmp216_;
												const gchar* _tmp217_;
												const gchar* _tmp218_;
												const gchar* _tmp219_;
												gchar _tmp220_;
												const gchar* _tmp229_;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp214_ = sb;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp215_ = p;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp216_ = q;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp217_ = p;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_string_append_len (_tmp214_, _tmp215_, (gssize) ((glong) (_tmp216_ - _tmp217_)));
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp218_ = q;
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												p = _tmp218_ + 1;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp219_ = p;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp220_ = ((gchar*) _tmp219_)[0];
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												switch (_tmp220_) {
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case '\'':
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case '"':
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case '\\':
#line 3019 "tracker-turtle-reader.c"
													{
														GString* _tmp221_;
														const gchar* _tmp222_;
														gchar _tmp223_;
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp221_ = sb;
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp222_ = p;
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp223_ = ((gchar*) _tmp222_)[0];
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp221_, _tmp223_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 3034 "tracker-turtle-reader.c"
													}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'b':
#line 3038 "tracker-turtle-reader.c"
													{
														GString* _tmp224_;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp224_ = sb;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp224_, '\b');
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 3047 "tracker-turtle-reader.c"
													}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'f':
#line 3051 "tracker-turtle-reader.c"
													{
														GString* _tmp225_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp225_ = sb;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp225_, '\f');
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 3060 "tracker-turtle-reader.c"
													}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'n':
#line 3064 "tracker-turtle-reader.c"
													{
														GString* _tmp226_;
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp226_ = sb;
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp226_, '\n');
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 3073 "tracker-turtle-reader.c"
													}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'r':
#line 3077 "tracker-turtle-reader.c"
													{
														GString* _tmp227_;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp227_ = sb;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp227_, '\r');
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 3086 "tracker-turtle-reader.c"
													}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 't':
#line 3090 "tracker-turtle-reader.c"
													{
														GString* _tmp228_;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp228_ = sb;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp228_, '\t');
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 3099 "tracker-turtle-reader.c"
													}
													default:
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													break;
#line 3104 "tracker-turtle-reader.c"
												}
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp229_ = p;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												p = _tmp229_ + 1;
#line 3110 "tracker-turtle-reader.c"
											}
										}
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp230_ = sb;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp231_ = _tmp230_->str;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										tracker_turtle_reader_set_object (self, _tmp231_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp233_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp232_ = _tmp233_;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3131 "tracker-turtle-reader.c"
												gboolean _tmp234_ = FALSE;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error_);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_free0 (s);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_string_free0 (sb);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp234_;
#line 3141 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp235_ = FALSE;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_free0 (s);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_string_free0 (sb);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_clear_error (&_inner_error_);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp235_;
#line 3154 "tracker-turtle-reader.c"
											}
										}
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_tmp232_) {
#line 3159 "tracker-turtle-reader.c"
											gboolean _tmp236_ = FALSE;
											gboolean _tmp237_;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp237_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp236_ = _tmp237_;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3170 "tracker-turtle-reader.c"
													gboolean _tmp238_ = FALSE;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error_);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													_g_free0 (s);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													_g_string_free0 (sb);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp238_;
#line 3180 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp239_ = FALSE;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													_g_free0 (s);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													_g_string_free0 (sb);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error_);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp239_;
#line 3193 "tracker-turtle-reader.c"
												}
											}
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (!_tmp236_) {
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3204 "tracker-turtle-reader.c"
														gboolean _tmp240_ = FALSE;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_free0 (s);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp240_;
#line 3214 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp241_ = FALSE;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_free0 (s);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp241_;
#line 3227 "tracker-turtle-reader.c"
													}
												}
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3236 "tracker-turtle-reader.c"
														gboolean _tmp242_ = FALSE;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_free0 (s);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp242_;
#line 3246 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp243_ = FALSE;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_free0 (s);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp243_;
#line 3259 "tracker-turtle-reader.c"
													}
												}
											}
										}
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										result = TRUE;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_g_free0 (s);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_g_string_free0 (sb);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return result;
#line 3272 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp244_ = FALSE;
										gboolean _tmp245_ = FALSE;
										gboolean _tmp246_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp246_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, &_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp245_ = _tmp246_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3285 "tracker-turtle-reader.c"
												gboolean _tmp247_ = FALSE;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp247_;
#line 3291 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp248_ = FALSE;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_clear_error (&_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp248_;
#line 3300 "tracker-turtle-reader.c"
											}
										}
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_tmp245_) {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp244_ = TRUE;
#line 3307 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp249_ = FALSE;
											gboolean _tmp250_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp250_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, &_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp249_ = _tmp250_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3319 "tracker-turtle-reader.c"
													gboolean _tmp251_ = FALSE;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp251_;
#line 3325 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp252_ = FALSE;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp252_;
#line 3334 "tracker-turtle-reader.c"
												}
											}
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp244_ = _tmp249_;
#line 3339 "tracker-turtle-reader.c"
										}
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_tmp244_) {
#line 3343 "tracker-turtle-reader.c"
											gchar* _tmp253_;
											gchar* _tmp254_;
											gboolean _tmp255_ = FALSE;
											gboolean _tmp256_;
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp253_ = tracker_turtle_reader_get_last_string (self, 3);
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp254_ = _tmp253_;
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											tracker_turtle_reader_set_object (self, _tmp254_);
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_g_free0 (_tmp254_);
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp256_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp255_ = _tmp256_;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3368 "tracker-turtle-reader.c"
													gboolean _tmp257_ = FALSE;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp257_;
#line 3374 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp258_ = FALSE;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp258_;
#line 3383 "tracker-turtle-reader.c"
												}
											}
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp255_) {
#line 3388 "tracker-turtle-reader.c"
												gboolean _tmp259_ = FALSE;
												gboolean _tmp260_;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp260_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp259_ = _tmp260_;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3399 "tracker-turtle-reader.c"
														gboolean _tmp261_ = FALSE;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp261_;
#line 3405 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp262_ = FALSE;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp262_;
#line 3414 "tracker-turtle-reader.c"
													}
												}
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (!_tmp259_) {
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3425 "tracker-turtle-reader.c"
															gboolean _tmp263_ = FALSE;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_propagate_error (error, _inner_error_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return _tmp263_;
#line 3431 "tracker-turtle-reader.c"
														} else {
															gboolean _tmp264_ = FALSE;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_clear_error (&_inner_error_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return _tmp264_;
#line 3440 "tracker-turtle-reader.c"
														}
													}
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3449 "tracker-turtle-reader.c"
															gboolean _tmp265_ = FALSE;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_propagate_error (error, _inner_error_);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return _tmp265_;
#line 3455 "tracker-turtle-reader.c"
														} else {
															gboolean _tmp266_ = FALSE;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_clear_error (&_inner_error_);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return _tmp266_;
#line 3464 "tracker-turtle-reader.c"
														}
													}
												}
											}
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											result = TRUE;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											return result;
#line 3473 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp267_ = FALSE;
											gboolean _tmp268_ = FALSE;
											gboolean _tmp269_ = FALSE;
											gboolean _tmp270_ = FALSE;
											gboolean _tmp271_ = FALSE;
											gboolean _tmp272_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp272_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp271_ = _tmp272_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3489 "tracker-turtle-reader.c"
													gboolean _tmp273_ = FALSE;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp273_;
#line 3495 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp274_ = FALSE;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp274_;
#line 3504 "tracker-turtle-reader.c"
												}
											}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp271_) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp270_ = TRUE;
#line 3511 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp275_ = FALSE;
												gboolean _tmp276_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp276_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp275_ = _tmp276_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3523 "tracker-turtle-reader.c"
														gboolean _tmp277_ = FALSE;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp277_;
#line 3529 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp278_ = FALSE;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp278_;
#line 3538 "tracker-turtle-reader.c"
													}
												}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp270_ = _tmp275_;
#line 3543 "tracker-turtle-reader.c"
											}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp270_) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp269_ = TRUE;
#line 3549 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp279_ = FALSE;
												gboolean _tmp280_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp280_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp279_ = _tmp280_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3561 "tracker-turtle-reader.c"
														gboolean _tmp281_ = FALSE;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp281_;
#line 3567 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp282_ = FALSE;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp282_;
#line 3576 "tracker-turtle-reader.c"
													}
												}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp269_ = _tmp279_;
#line 3581 "tracker-turtle-reader.c"
											}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp269_) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp268_ = TRUE;
#line 3587 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp283_ = FALSE;
												gboolean _tmp284_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp284_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_TRUE, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp283_ = _tmp284_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3599 "tracker-turtle-reader.c"
														gboolean _tmp285_ = FALSE;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp285_;
#line 3605 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp286_ = FALSE;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp286_;
#line 3614 "tracker-turtle-reader.c"
													}
												}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp268_ = _tmp283_;
#line 3619 "tracker-turtle-reader.c"
											}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp268_) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp267_ = TRUE;
#line 3625 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp287_ = FALSE;
												gboolean _tmp288_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp288_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FALSE, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp287_ = _tmp288_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3637 "tracker-turtle-reader.c"
														gboolean _tmp289_ = FALSE;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp289_;
#line 3643 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp290_ = FALSE;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp290_;
#line 3652 "tracker-turtle-reader.c"
													}
												}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp267_ = _tmp287_;
#line 3657 "tracker-turtle-reader.c"
											}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp267_) {
#line 3661 "tracker-turtle-reader.c"
												gchar* _tmp291_;
												gchar* _tmp292_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp291_ = tracker_turtle_reader_get_last_string (self, 0);
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp292_ = _tmp291_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_set_object (self, _tmp292_);
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_free0 (_tmp292_);
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												result = TRUE;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return result;
#line 3680 "tracker-turtle-reader.c"
											} else {
												GError* _tmp293_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp293_ = tracker_turtle_reader_get_error (self, "expected object");
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_inner_error_ = _tmp293_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3689 "tracker-turtle-reader.c"
													gboolean _tmp294_ = FALSE;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error_);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp294_;
#line 3695 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp295_ = FALSE;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error_);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp295_;
#line 3704 "tracker-turtle-reader.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_OBJECT:
#line 3717 "tracker-turtle-reader.c"
			{
				gboolean _tmp296_ = FALSE;
				gboolean _tmp297_;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp297_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp296_ = _tmp297_;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3729 "tracker-turtle-reader.c"
						gboolean _tmp298_ = FALSE;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp298_;
#line 3735 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp299_ = FALSE;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp299_;
#line 3744 "tracker-turtle-reader.c"
					}
				}
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp296_) {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 3753 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp300_ = FALSE;
					gboolean _tmp301_;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp301_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp300_ = _tmp301_;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3765 "tracker-turtle-reader.c"
							gboolean _tmp302_ = FALSE;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp302_;
#line 3771 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp303_ = FALSE;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp303_;
#line 3780 "tracker-turtle-reader.c"
						}
					}
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp300_) {
#line 3785 "tracker-turtle-reader.c"
						gboolean _tmp304_ = FALSE;
						gboolean _tmp305_;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp305_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp304_ = _tmp305_;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3796 "tracker-turtle-reader.c"
								gboolean _tmp306_ = FALSE;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp306_;
#line 3802 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp307_ = FALSE;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp307_;
#line 3811 "tracker-turtle-reader.c"
							}
						}
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp304_) {
#line 338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							continue;
#line 3820 "tracker-turtle-reader.c"
						}
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 3826 "tracker-turtle-reader.c"
					} else {
						gchar** _tmp308_;
						gint _tmp308__length1;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp308_ = self->priv->subject_stack;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp308__length1 = self->priv->subject_stack_length1;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp308__length1 > 0) {
#line 3836 "tracker-turtle-reader.c"
							const gchar* _tmp311_;
							gchar** _tmp312_;
							gint _tmp312__length1;
							gchar** _tmp313_;
							gint _tmp313__length1;
							const gchar* _tmp314_;
							gint _tmp315_;
							gchar** _tmp316_;
							gint _tmp316__length1;
							gchar** _tmp317_;
							gint _tmp317__length1;
							const gchar* _tmp318_;
							gint _tmp319_;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3856 "tracker-turtle-reader.c"
									gboolean _tmp309_ = FALSE;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp309_;
#line 3862 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp310_ = FALSE;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp310_;
#line 3871 "tracker-turtle-reader.c"
								}
							}
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp311_ = self->priv->_subject;
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object (self, _tmp311_);
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp312_ = self->priv->subject_stack;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp312__length1 = self->priv->subject_stack_length1;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp313_ = self->priv->subject_stack;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp313__length1 = self->priv->subject_stack_length1;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp314_ = _tmp312_[_tmp313__length1 - 1];
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_subject (self, _tmp314_);
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp315_ = self->priv->subject_stack_length1;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->subject_stack_length1 = _tmp315_ - 1;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp316_ = self->priv->predicate_stack;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp316__length1 = self->priv->predicate_stack_length1;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp317_ = self->priv->predicate_stack;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp317__length1 = self->priv->predicate_stack_length1;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp318_ = _tmp316_[_tmp317__length1 - 1];
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_predicate (self, _tmp318_);
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp319_ = self->priv->predicate_stack_length1;
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->predicate_stack_length1 = _tmp319_ - 1;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							result = TRUE;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return result;
#line 3918 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp320_ = FALSE;
							gboolean _tmp321_;
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp321_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp320_ = _tmp321_;
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3930 "tracker-turtle-reader.c"
									gboolean _tmp322_ = FALSE;
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp322_;
#line 3936 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp323_ = FALSE;
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp323_;
#line 3945 "tracker-turtle-reader.c"
								}
							}
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp320_) {
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								continue;
#line 3954 "tracker-turtle-reader.c"
							} else {
								GError* _tmp324_;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp324_ = tracker_turtle_reader_get_error (self, "expected comma, semicolon, or dot");
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_inner_error_ = _tmp324_;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3963 "tracker-turtle-reader.c"
									gboolean _tmp325_ = FALSE;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp325_;
#line 3969 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp326_ = FALSE;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp326_;
#line 3978 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
			default:
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			break;
#line 3988 "tracker-turtle-reader.c"
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return self ? g_error_copy (self) : NULL;
#line 3997 "tracker-turtle-reader.c"
}


void tracker_turtle_reader_load (const gchar* path, GError** error) {
	GError * _inner_error_ = NULL;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (path != NULL);
#line 4005 "tracker-turtle-reader.c"
	{
		TrackerTurtleReader* reader = NULL;
		const gchar* _tmp0_;
		TrackerTurtleReader* _tmp1_;
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_begin_transaction (&_inner_error_);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 4016 "tracker-turtle-reader.c"
				goto __catch4_tracker_sparql_error;
			}
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4021 "tracker-turtle-reader.c"
				goto __catch4_tracker_db_interface_error;
			}
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return;
#line 4030 "tracker-turtle-reader.c"
		}
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = path;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = tracker_turtle_reader_new (_tmp0_, &_inner_error_);
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		reader = _tmp1_;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 4042 "tracker-turtle-reader.c"
				goto __catch4_tracker_sparql_error;
			}
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4047 "tracker-turtle-reader.c"
				goto __catch4_tracker_db_interface_error;
			}
			goto __finally4;
		}
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		while (TRUE) {
#line 4054 "tracker-turtle-reader.c"
			gboolean _tmp2_ = FALSE;
			TrackerTurtleReader* _tmp3_;
			gboolean _tmp4_;
			TrackerTurtleReader* _tmp5_;
			gboolean _tmp6_;
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp3_ = reader;
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp4_ = tracker_turtle_reader_next (_tmp3_, &_inner_error_);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp2_ = _tmp4_;
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 4072 "tracker-turtle-reader.c"
					goto __catch4_tracker_sparql_error;
				}
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4077 "tracker-turtle-reader.c"
					goto __catch4_tracker_db_interface_error;
				}
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error_);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return;
#line 4088 "tracker-turtle-reader.c"
			}
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (!_tmp2_) {
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				break;
#line 4094 "tracker-turtle-reader.c"
			}
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp5_ = reader;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp6_ = _tmp5_->priv->_object_is_uri;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_tmp6_) {
#line 4102 "tracker-turtle-reader.c"
				TrackerTurtleReader* _tmp7_;
				const gchar* _tmp8_;
				TrackerTurtleReader* _tmp9_;
				const gchar* _tmp10_;
				TrackerTurtleReader* _tmp11_;
				const gchar* _tmp12_;
				TrackerTurtleReader* _tmp13_;
				const gchar* _tmp14_;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp7_ = reader;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp8_ = _tmp7_->priv->_graph;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp9_ = reader;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp10_ = _tmp9_->priv->_subject;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp11_ = reader;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp12_ = _tmp11_->priv->_predicate;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp13_ = reader;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp14_ = _tmp13_->priv->_object;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				tracker_data_insert_statement_with_uri (_tmp8_, _tmp10_, _tmp12_, _tmp14_, &_inner_error_);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 4135 "tracker-turtle-reader.c"
						goto __catch4_tracker_sparql_error;
					}
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4140 "tracker-turtle-reader.c"
						goto __catch4_tracker_db_interface_error;
					}
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_clear_error (&_inner_error_);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					return;
#line 4151 "tracker-turtle-reader.c"
				}
			} else {
				TrackerTurtleReader* _tmp15_;
				const gchar* _tmp16_;
				TrackerTurtleReader* _tmp17_;
				const gchar* _tmp18_;
				TrackerTurtleReader* _tmp19_;
				const gchar* _tmp20_;
				TrackerTurtleReader* _tmp21_;
				const gchar* _tmp22_;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp15_ = reader;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp16_ = _tmp15_->priv->_graph;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp17_ = reader;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp18_ = _tmp17_->priv->_subject;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp19_ = reader;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp20_ = _tmp19_->priv->_predicate;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp21_ = reader;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp22_ = _tmp21_->priv->_object;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				tracker_data_insert_statement_with_string (_tmp16_, _tmp18_, _tmp20_, _tmp22_, &_inner_error_);
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 4186 "tracker-turtle-reader.c"
						goto __catch4_tracker_sparql_error;
					}
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4191 "tracker-turtle-reader.c"
						goto __catch4_tracker_db_interface_error;
					}
					goto __finally4;
				}
			}
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			tracker_data_update_buffer_might_flush (&_inner_error_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 4205 "tracker-turtle-reader.c"
					goto __catch4_tracker_sparql_error;
				}
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4210 "tracker-turtle-reader.c"
					goto __catch4_tracker_db_interface_error;
				}
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return;
#line 4221 "tracker-turtle-reader.c"
			}
		}
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_commit_transaction (&_inner_error_);
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (reader);
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 4232 "tracker-turtle-reader.c"
				goto __catch4_tracker_sparql_error;
			}
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4237 "tracker-turtle-reader.c"
				goto __catch4_tracker_db_interface_error;
			}
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (reader);
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return;
#line 4248 "tracker-turtle-reader.c"
		}
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_object_unref0 (reader);
#line 4252 "tracker-turtle-reader.c"
	}
	goto __finally4;
	__catch4_tracker_sparql_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		GError* _tmp24_;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		e = _inner_error_;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error_ = NULL;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_rollback_transaction ();
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp23_ = e;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp24_ = _g_error_copy0 (_tmp23_);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error_ = _tmp24_;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_error_free0 (e);
#line 4274 "tracker-turtle-reader.c"
		goto __finally4;
	}
	goto __finally4;
	__catch4_tracker_db_interface_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		GError* _tmp26_;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		e = _inner_error_;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error_ = NULL;
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_rollback_transaction ();
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp25_ = e;
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp26_ = _g_error_copy0 (_tmp25_);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error_ = _tmp26_;
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_error_free0 (e);
#line 4297 "tracker-turtle-reader.c"
		goto __finally4;
	}
	__finally4:
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if ((((_inner_error_->domain == G_FILE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) || (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR)) {
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return;
#line 4309 "tracker-turtle-reader.c"
		} else {
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return;
#line 4317 "tracker-turtle-reader.c"
		}
	}
}


const gchar* tracker_turtle_reader_get_graph (TrackerTurtleReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_graph;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4334 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_set_graph (TrackerTurtleReader* self, const gchar* value) {
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_graph (self)) != 0) {
#line 4343 "tracker-turtle-reader.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = value;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (self->priv->_graph);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_graph = _tmp1_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify ((GObject *) self, "graph");
#line 4356 "tracker-turtle-reader.c"
	}
}


const gchar* tracker_turtle_reader_get_subject (TrackerTurtleReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_subject;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4372 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_set_subject (TrackerTurtleReader* self, const gchar* value) {
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_subject (self)) != 0) {
#line 4381 "tracker-turtle-reader.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = value;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (self->priv->_subject);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_subject = _tmp1_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify ((GObject *) self, "subject");
#line 4394 "tracker-turtle-reader.c"
	}
}


const gchar* tracker_turtle_reader_get_predicate (TrackerTurtleReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_predicate;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4410 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_set_predicate (TrackerTurtleReader* self, const gchar* value) {
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_predicate (self)) != 0) {
#line 4419 "tracker-turtle-reader.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = value;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (self->priv->_predicate);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_predicate = _tmp1_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify ((GObject *) self, "predicate");
#line 4432 "tracker-turtle-reader.c"
	}
}


const gchar* tracker_turtle_reader_get_object (TrackerTurtleReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_object;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4448 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_set_object (TrackerTurtleReader* self, const gchar* value) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_object (self)) != 0) {
#line 4457 "tracker-turtle-reader.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = value;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (self->priv->_object);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_object = _tmp1_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify ((GObject *) self, "object");
#line 4470 "tracker-turtle-reader.c"
	}
}


gboolean tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self) {
	gboolean result;
	gboolean _tmp0_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_object_is_uri;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4486 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self, gboolean value) {
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (tracker_turtle_reader_get_object_is_uri (self) != value) {
#line 4495 "tracker-turtle-reader.c"
		gboolean _tmp0_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = value;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_object_is_uri = _tmp0_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify ((GObject *) self, "object-is-uri");
#line 4503 "tracker-turtle-reader.c"
	}
}


static TrackerTurtleReaderTokenInfo* tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self) {
	TrackerTurtleReaderTokenInfo* dup;
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	dup = g_new0 (TrackerTurtleReaderTokenInfo, 1);
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	memcpy (dup, self, sizeof (TrackerTurtleReaderTokenInfo));
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return dup;
#line 4516 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self) {
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_free (self);
#line 4523 "tracker-turtle-reader.c"
}


static GType tracker_turtle_reader_token_info_get_type (void) {
	static volatile gsize tracker_turtle_reader_token_info_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_token_info_type_id__volatile)) {
		GType tracker_turtle_reader_token_info_type_id;
		tracker_turtle_reader_token_info_type_id = g_boxed_type_register_static ("TrackerTurtleReaderTokenInfo", (GBoxedCopyFunc) tracker_turtle_reader_token_info_dup, (GBoxedFreeFunc) tracker_turtle_reader_token_info_free);
		g_once_init_leave (&tracker_turtle_reader_token_info_type_id__volatile, tracker_turtle_reader_token_info_type_id);
	}
	return tracker_turtle_reader_token_info_type_id__volatile;
}


static void tracker_turtle_reader_class_init (TrackerTurtleReaderClass * klass) {
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	tracker_turtle_reader_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_type_class_add_private (klass, sizeof (TrackerTurtleReaderPrivate));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_turtle_reader_get_property;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_turtle_reader_set_property;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_turtle_reader_finalize;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_GRAPH, g_param_spec_string ("graph", "graph", "graph", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_SUBJECT, g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_PREDICATE, g_param_spec_string ("predicate", "predicate", "predicate", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT, g_param_spec_string ("object", "object", "object", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT_IS_URI, g_param_spec_boolean ("object-is-uri", "object-is-uri", "object-is-uri", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 4559 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_instance_init (TrackerTurtleReader * self) {
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv = TRACKER_TURTLE_READER_GET_PRIVATE (self);
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->bnodeid = 0;
#line 4568 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_finalize (GObject * obj) {
	TrackerTurtleReader * self;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_object_unref0 (self->priv->scanner);
#line 24 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (self->priv->_graph);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (self->priv->_subject);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (self->priv->_predicate);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (self->priv->_object);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->subject_stack = (_vala_array_free (self->priv->subject_stack, self->priv->subject_stack_length1, (GDestroyNotify) g_free), NULL);
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->predicate_stack = (_vala_array_free (self->priv->predicate_stack, self->priv->predicate_stack_length1, (GDestroyNotify) g_free), NULL);
#line 63 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_mapped_file_unref0 (self->priv->mapped_file);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (tracker_turtle_reader_parent_class)->finalize (obj);
#line 4600 "tracker-turtle-reader.c"
}


GType tracker_turtle_reader_get_type (void) {
	static volatile gsize tracker_turtle_reader_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTurtleReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_turtle_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTurtleReader), 0, (GInstanceInitFunc) tracker_turtle_reader_instance_init, NULL };
		GType tracker_turtle_reader_type_id;
		tracker_turtle_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerTurtleReader", &g_define_type_info, 0);
		g_once_init_leave (&tracker_turtle_reader_type_id__volatile, tracker_turtle_reader_type_id);
	}
	return tracker_turtle_reader_type_id__volatile;
}


static void _vala_tracker_turtle_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerTurtleReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	switch (property_id) {
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_GRAPH:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_graph (self));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_SUBJECT:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_subject (self));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_PREDICATE:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_predicate (self));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_object (self));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_IS_URI:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_boolean (value, tracker_turtle_reader_get_object_is_uri (self));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4651 "tracker-turtle-reader.c"
		default:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4657 "tracker-turtle-reader.c"
	}
}


static void _vala_tracker_turtle_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerTurtleReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	switch (property_id) {
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_GRAPH:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_graph (self, g_value_get_string (value));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_SUBJECT:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_subject (self, g_value_get_string (value));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_PREDICATE:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_predicate (self, g_value_get_string (value));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_object (self, g_value_get_string (value));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_IS_URI:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_object_is_uri (self, g_value_get_boolean (value));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4697 "tracker-turtle-reader.c"
		default:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4703 "tracker-turtle-reader.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



