/* tracker-utils.c generated by valac 0.36.4, the Vala compiler
 * generated from tracker-utils.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))



#define secs_per_day ((60 * 60) * 24)
gchar* uri_get_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
void uri_launch (const gchar* uri);
void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
void tracker_model_launch_selected_parent_dir (GtkTreeModel* model, GtkTreePath* path, gint col);
gchar* tracker_time_format_from_iso8601 (const gchar* s);
gchar* tracker_time_format_from_seconds (const gchar* seconds_str);
GdkPixbuf* tracker_pixbuf_new_from_file (GtkIconTheme* theme, const gchar* filename, gint size, gboolean is_image);
GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gchar* uri_get_selected (GtkTreeModel* model, GtkTreePath* path, gint col) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	const gchar* uri = NULL;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
#line 24 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (model != NULL, NULL);
#line 24 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = model;
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = path;
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	gtk_tree_model_get_iter (_tmp0_, &_tmp2_, _tmp1_);
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	iter = _tmp2_;
#line 29 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = model;
#line 29 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = iter;
#line 29 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = col;
#line 29 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	gtk_tree_model_get (_tmp3_, &_tmp4_, _tmp5_, &uri, -1);
#line 31 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = g_strdup (uri);
#line 31 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	result = _tmp6_;
#line 31 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	return result;
#line 94 "tracker-utils.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1011 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1011 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1012 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1012 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 1012 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 1012 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1014 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1014 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 121 "tracker-utils.c"
		gchar* _tmp4_;
#line 1015 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1015 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1015 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 129 "tracker-utils.c"
	} else {
#line 1017 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = -1;
#line 1017 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 135 "tracker-utils.c"
	}
}


void uri_launch (const gchar* uri) {
	const gchar* _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
#line 34 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (uri != NULL);
#line 37 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = uri;
#line 37 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = string_index_of (_tmp0_, "://", 0);
#line 37 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp1_ < 1) {
#line 152 "tracker-utils.c"
		gchar** command = NULL;
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint command_length1;
		gint _command_size_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		GPid child_pid = 0;
		gchar** argv = NULL;
		gchar** _tmp7_;
		gint argv_length1;
		gint _argv_size_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GPid _tmp22_;
#line 38 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp2_ = uri;
#line 38 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
#line 38 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		command = _tmp4_;
#line 38 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		command_length1 = _vala_array_length (_tmp3_);
#line 38 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_command_size_ = command_length1;
#line 39 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp5_ = command;
#line 39 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp5__length1 = command_length1;
#line 39 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp6_ = _tmp5_[0];
#line 39 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_debug ("tracker-utils.vala:39: Attempting to spawn_async() '%s'", _tmp6_);
#line 42 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp7_ = g_new0 (gchar*, 1 + 1);
#line 42 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		argv = _tmp7_;
#line 42 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		argv_length1 = 1;
#line 42 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_argv_size_ = argv_length1;
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp8_ = argv;
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp8__length1 = argv_length1;
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp9_ = command;
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp9__length1 = command_length1;
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp10_ = _tmp9_[0];
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp8_[0]);
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp8_[0] = _tmp11_;
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp12_ = _tmp8_[0];
#line 219 "tracker-utils.c"
		{
			gchar** _tmp13_;
			gint _tmp13__length1;
			GPid _tmp14_ = 0;
#line 46 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp13_ = argv;
#line 46 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp13__length1 = argv_length1;
#line 46 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			g_spawn_async ("/usr/bin", _tmp13_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp14_, &_inner_error_);
#line 46 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			child_pid = _tmp14_;
#line 46 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 234 "tracker-utils.c"
				goto __catch21_g_error;
			}
		}
		goto __finally21;
		__catch21_g_error:
		{
			GError* e = NULL;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			GError* _tmp17_;
			gint _tmp18_;
			GError* _tmp19_;
			gint _tmp20_;
			const gchar* _tmp21_;
#line 45 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 45 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 53 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp15_ = command;
#line 53 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp15__length1 = command_length1;
#line 53 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp16_ = _tmp15_[0];
#line 53 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp17_ = e;
#line 53 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp18_ = _tmp17_->code;
#line 53 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp19_ = e;
#line 53 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp20_ = _tmp19_->code;
#line 53 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp21_ = g_strerror (_tmp20_);
#line 53 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:53: Could not launch '%s', %d->%s", _tmp16_, _tmp18_, _tmp21_);
#line 54 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 54 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 54 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
#line 54 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			return;
#line 280 "tracker-utils.c"
		}
		__finally21:
#line 45 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 45 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 45 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
#line 45 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 45 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 45 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			return;
#line 295 "tracker-utils.c"
		}
#line 57 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp22_ = child_pid;
#line 57 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_debug ("tracker-utils.vala:57: Launched application with PID:%d", (gint) _tmp22_);
#line 58 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 58 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
#line 58 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		return;
#line 307 "tracker-utils.c"
	}
	{
		const gchar* _tmp23_;
		const gchar* _tmp24_;
#line 62 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp23_ = uri;
#line 62 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_debug ("tracker-utils.vala:62: Attempting to launch application for uri:'%s'", _tmp23_);
#line 63 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp24_ = uri;
#line 63 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_app_info_launch_default_for_uri (_tmp24_, NULL, &_inner_error_);
#line 63 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 322 "tracker-utils.c"
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		e = _inner_error_;
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_inner_error_ = NULL;
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp25_ = e;
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp26_ = _tmp25_->message;
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp27_ = g_strconcat ("Could not launch application: ", _tmp26_, NULL);
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp28_ = _tmp27_;
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_warning ("tracker-utils.vala:65: %s", _tmp28_);
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp28_);
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_error_free0 (e);
#line 352 "tracker-utils.c"
	}
	__finally22:
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_clear_error (&_inner_error_);
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		return;
#line 363 "tracker-utils.c"
	}
}


void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col) {
	gchar* uri = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreePath* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
#line 69 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (model != NULL);
#line 69 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (path != NULL);
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = model;
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = path;
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = col;
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = uri_get_selected (_tmp0_, _tmp1_, _tmp2_);
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	uri = _tmp3_;
#line 71 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_debug ("tracker-utils.vala:71: Selected uri:'%s'", uri);
#line 73 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	uri_launch (uri);
#line 69 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_g_free0 (uri);
#line 394 "tracker-utils.c"
}


void tracker_model_launch_selected_parent_dir (GtkTreeModel* model, GtkTreePath* path, gint col) {
	gchar* uri = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreePath* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	GFile* f = NULL;
	GFile* _tmp4_;
	GFile* p = NULL;
	GFile* _tmp5_;
	gchar* parent_uri = NULL;
	gchar* _tmp6_;
#line 76 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (model != NULL);
#line 76 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (path != NULL);
#line 77 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = model;
#line 77 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = path;
#line 77 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = col;
#line 77 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = uri_get_selected (_tmp0_, _tmp1_, _tmp2_);
#line 77 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	uri = _tmp3_;
#line 78 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_debug ("tracker-utils.vala:78: Selected uri:'%s'", uri);
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = g_file_new_for_uri (uri);
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	f = _tmp4_;
#line 81 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = g_file_get_parent (f);
#line 81 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	p = _tmp5_;
#line 82 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = g_file_get_uri (p);
#line 82 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	parent_uri = _tmp6_;
#line 84 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_debug ("tracker-utils.vala:84: Parent uri:'%s'", parent_uri);
#line 85 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	uri_launch (parent_uri);
#line 76 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_g_free0 (parent_uri);
#line 76 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (p);
#line 76 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (f);
#line 76 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_g_free0 (uri);
#line 450 "tracker-utils.c"
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
#line 2853 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2854 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2854 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2854 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2854 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = format;
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = buffer;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3__length1 = buffer_length1;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 496 "tracker-utils.c"
}


gchar* tracker_time_format_from_iso8601 (const gchar* s) {
	gchar* result = NULL;
	struct tm t = {0};
	const gchar* _tmp0_;
	GTimeVal tv_now = {0};
	GTimeVal tv_then = {0};
	const gchar* _tmp1_;
	glong diff_sec = 0L;
	GTimeVal _tmp2_;
	glong _tmp3_;
	GTimeVal _tmp4_;
	glong _tmp5_;
	glong diff_days = 0L;
	glong _tmp6_;
	glong diff_days_abs = 0L;
	glong _tmp7_;
	glong _tmp8_;
	glong _tmp9_;
	glong _tmp11_;
#line 88 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	memset (&t, 0, sizeof (struct tm));
#line 90 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = s;
#line 90 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	strptime (_tmp0_, "%FT%T", &t);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_now);
#line 93 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_now);
#line 95 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_then);
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = s;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_time_val_from_iso8601 (_tmp1_, &tv_then);
#line 98 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = tv_now;
#line 98 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = _tmp2_.tv_sec;
#line 98 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = tv_then;
#line 98 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = _tmp4_.tv_sec;
#line 98 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	diff_sec = _tmp3_ - _tmp5_;
#line 99 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = diff_sec;
#line 99 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	diff_days = _tmp6_ / secs_per_day;
#line 100 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp7_ = diff_days;
#line 100 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp8_ = labs (_tmp7_);
#line 100 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	diff_days_abs = _tmp8_;
#line 105 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp9_ = diff_days_abs;
#line 105 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp9_ > ((glong) 7)) {
#line 561 "tracker-utils.c"
		gchar* _tmp10_;
#line 108 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp10_ = g_time_format (&t, _ ("%x"));
#line 108 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		result = _tmp10_;
#line 108 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		return result;
#line 569 "tracker-utils.c"
	}
#line 111 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp11_ = diff_days_abs;
#line 111 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp11_ == ((glong) 0)) {
#line 575 "tracker-utils.c"
		gchar* _tmp12_;
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp12_ = g_strdup (_ ("Today"));
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		result = _tmp12_;
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		return result;
#line 583 "tracker-utils.c"
	} else {
		gboolean future = FALSE;
		glong _tmp13_;
		glong _tmp14_;
#line 114 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		future = FALSE;
#line 116 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp13_ = diff_days;
#line 116 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		if (_tmp13_ < ((glong) 0)) {
#line 117 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			future = TRUE;
#line 596 "tracker-utils.c"
		}
#line 119 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp14_ = diff_days;
#line 119 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		if (_tmp14_ <= ((glong) 1)) {
#line 602 "tracker-utils.c"
			gboolean _tmp15_;
#line 120 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp15_ = future;
#line 120 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			if (_tmp15_) {
#line 608 "tracker-utils.c"
				gchar* _tmp16_;
#line 121 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp16_ = g_strdup (_ ("Tomorrow"));
#line 121 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				result = _tmp16_;
#line 121 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				return result;
#line 616 "tracker-utils.c"
			} else {
				gchar* _tmp17_;
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp17_ = g_strdup (_ ("Yesterday"));
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				result = _tmp17_;
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				return result;
#line 625 "tracker-utils.c"
			}
		} else {
			gboolean _tmp18_;
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp18_ = future;
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			if (_tmp18_) {
#line 633 "tracker-utils.c"
				glong _tmp19_;
				glong _tmp20_;
				gchar* _tmp21_;
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp19_ = diff_days_abs;
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp20_ = diff_days_abs;
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp21_ = g_strdup_printf (ngettext ("%ld day from now", "%ld days from now", (gulong) _tmp19_), _tmp20_);
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				result = _tmp21_;
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				return result;
#line 647 "tracker-utils.c"
			} else {
				glong _tmp22_;
				glong _tmp23_;
				gchar* _tmp24_;
#line 130 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp22_ = diff_days_abs;
#line 130 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp23_ = diff_days_abs;
#line 130 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp24_ = g_strdup_printf (ngettext ("%ld day ago", "%ld days ago", (gulong) _tmp22_), _tmp23_);
#line 130 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				result = _tmp24_;
#line 130 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				return result;
#line 662 "tracker-utils.c"
			}
		}
	}
}


gchar* tracker_time_format_from_seconds (const gchar* seconds_str) {
	gchar* result = NULL;
	gdouble seconds = 0.0;
	const gchar* _tmp0_;
	gint _tmp1_;
	gdouble total = 0.0;
	gint d = 0;
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gdouble _tmp2_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	GString* output = NULL;
	GString* _tmp11_;
	gint _tmp12_;
	gint _tmp17_;
	gint _tmp22_;
	const gchar* _tmp29_ = NULL;
	gint _tmp30_;
	GString* _tmp31_;
	gint _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GString* _tmp35_;
	gssize _tmp36_;
	gchar* str = NULL;
	GString* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
#line 136 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (seconds_str != NULL, NULL);
#line 137 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = seconds_str;
#line 137 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = atoi (_tmp0_);
#line 137 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	seconds = (gdouble) _tmp1_;
#line 141 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = seconds;
#line 141 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp2_ == 0.0) {
#line 719 "tracker-utils.c"
		gchar* _tmp3_;
#line 142 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp3_ = g_strdup (_ ("Less than one second"));
#line 142 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		result = _tmp3_;
#line 142 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		return result;
#line 727 "tracker-utils.c"
	}
#line 145 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = seconds;
#line 145 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	total = _tmp4_;
#line 146 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = total;
#line 146 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	s = ((gint) _tmp5_) % 60;
#line 147 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = total;
#line 147 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	total = _tmp6_ / 60;
#line 148 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp7_ = total;
#line 148 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	m = ((gint) _tmp7_) % 60;
#line 149 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp8_ = total;
#line 149 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	total = _tmp8_ / 60;
#line 150 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp9_ = total;
#line 150 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	h = ((gint) _tmp9_) % 24;
#line 151 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp10_ = total;
#line 151 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	d = ((gint) _tmp10_) / 24;
#line 153 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp11_ = g_string_new ("");
#line 153 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	output = _tmp11_;
#line 155 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp12_ = d;
#line 155 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp12_ > 0) {
#line 765 "tracker-utils.c"
		GString* _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp13_ = output;
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp14_ = d;
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp15_ = g_strdup_printf (" %dd", _tmp14_);
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp16_ = _tmp15_;
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp13_, _tmp16_);
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp16_);
#line 782 "tracker-utils.c"
	}
#line 159 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp17_ = h;
#line 159 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp17_ > 0) {
#line 788 "tracker-utils.c"
		GString* _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
#line 160 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp18_ = output;
#line 160 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp19_ = h;
#line 160 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp20_ = g_strdup_printf (" %.2d", _tmp19_);
#line 160 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp21_ = _tmp20_;
#line 160 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp18_, _tmp21_);
#line 160 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp21_);
#line 805 "tracker-utils.c"
	}
#line 163 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp22_ = m;
#line 163 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp22_ > 0) {
#line 811 "tracker-utils.c"
		const gchar* _tmp23_ = NULL;
		gint _tmp24_;
		GString* _tmp25_;
		gint _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp24_ = h;
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		if (_tmp24_ > 0) {
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp23_ = ":";
#line 824 "tracker-utils.c"
		} else {
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp23_ = "";
#line 828 "tracker-utils.c"
		}
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp25_ = output;
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp26_ = m;
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp27_ = g_strdup_printf ("%s%.2d", _tmp23_, _tmp26_);
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp28_ = _tmp27_;
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp25_, _tmp28_);
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp28_);
#line 842 "tracker-utils.c"
	}
#line 168 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp30_ = m;
#line 168 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp30_ > 0) {
#line 168 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp29_ = ":";
#line 850 "tracker-utils.c"
	} else {
#line 168 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp29_ = "0:";
#line 854 "tracker-utils.c"
	}
#line 168 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp31_ = output;
#line 168 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp32_ = s;
#line 168 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp33_ = g_strdup_printf ("%s%.2d", _tmp29_, _tmp32_);
#line 168 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp34_ = _tmp33_;
#line 168 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_string_append (_tmp31_, _tmp34_);
#line 168 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_g_free0 (_tmp34_);
#line 170 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp35_ = output;
#line 170 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp36_ = _tmp35_->len;
#line 170 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp36_ < ((gssize) 1)) {
#line 874 "tracker-utils.c"
		gchar* _tmp37_;
#line 171 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp37_ = g_strdup (_ ("Less than one second"));
#line 171 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		result = _tmp37_;
#line 171 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_string_free0 (output);
#line 171 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		return result;
#line 884 "tracker-utils.c"
	}
#line 174 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp38_ = output;
#line 174 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp39_ = _tmp38_->str;
#line 174 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp40_ = g_strdup (_tmp39_);
#line 174 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	str = _tmp40_;
#line 176 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp41_ = str;
#line 176 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp42_ = g_strchug (_tmp41_);
#line 176 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp43_ = g_strdup (_tmp42_);
#line 176 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	result = _tmp43_;
#line 176 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_g_free0 (str);
#line 176 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_g_string_free0 (output);
#line 176 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	return result;
#line 908 "tracker-utils.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 182 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 915 "tracker-utils.c"
}


GdkPixbuf* tracker_pixbuf_new_from_file (GtkIconTheme* theme, const gchar* filename, gint size, gboolean is_image) {
	GdkPixbuf* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GdkPixbuf* pixbuf = NULL;
	gpointer _tmp2_;
	GdkPixbuf* _tmp3_;
	gboolean _tmp4_;
	GFile* _tmp19_;
	gboolean _tmp20_;
	GdkPixbuf* _tmp54_;
	GtkIconTheme* _tmp55_;
	gint _tmp56_;
	GdkPixbuf* _tmp57_;
	GError * _inner_error_ = NULL;
#line 179 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (theme != NULL, NULL);
#line 179 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 181 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = filename;
#line 181 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = g_file_new_for_uri (_tmp0_);
#line 181 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	file = _tmp1_;
#line 182 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = NULL;
#line 182 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_pixbuf_get_type ()) ? ((GdkPixbuf*) _tmp2_) : NULL);
#line 182 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	pixbuf = _tmp3_;
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = is_image;
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp4_) {
#line 955 "tracker-utils.c"
		GdkPixbuf* _tmp18_;
		{
			GdkPixbuf* _tmp5_ = NULL;
			GFile* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GdkPixbuf* _tmp11_;
			GdkPixbuf* _tmp12_;
			GdkPixbuf* _tmp13_;
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp6_ = file;
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp7_ = g_file_get_path (_tmp6_);
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp8_ = _tmp7_;
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp9_ = size;
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp10_ = size;
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp11_ = gdk_pixbuf_new_from_file_at_size (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp12_ = _tmp11_;
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp8_);
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp5_ = _tmp12_;
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 987 "tracker-utils.c"
				goto __catch23_g_error;
			}
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp13_ = _tmp5_;
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp5_ = NULL;
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			pixbuf = _tmp13_;
#line 185 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (_tmp5_);
#line 1000 "tracker-utils.c"
		}
		goto __finally23;
		__catch23_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
#line 185 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 185 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp14_ = e;
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp15_ = _tmp14_->message;
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp16_ = g_strconcat ("Error loading icon pixbuf: ", _tmp15_, NULL);
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp17_ = _tmp16_;
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:188: %s", _tmp17_);
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp17_);
#line 185 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 1028 "tracker-utils.c"
		}
		__finally23:
#line 185 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 185 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 185 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 185 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 185 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 185 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			return NULL;
#line 1043 "tracker-utils.c"
		}
#line 191 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp18_ = pixbuf;
#line 191 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		if (_tmp18_ != NULL) {
#line 192 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			result = pixbuf;
#line 192 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 192 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			return result;
#line 1055 "tracker-utils.c"
		}
	}
#line 196 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp19_ = file;
#line 196 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp20_ = g_file_query_exists (_tmp19_, NULL);
#line 196 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp20_) {
#line 1064 "tracker-utils.c"
		{
			GFileInfo* file_info = NULL;
			GFile* _tmp21_;
			GFileInfo* _tmp22_;
			GFileInfo* _tmp23_;
#line 198 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp21_ = file;
#line 198 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp22_ = g_file_query_info (_tmp21_, "standard::icon", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 198 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			file_info = _tmp22_;
#line 198 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1078 "tracker-utils.c"
				goto __catch24_g_error;
			}
#line 202 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp23_ = file_info;
#line 202 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			if (_tmp23_ != NULL) {
#line 1085 "tracker-utils.c"
				GIcon* icon = NULL;
				GFileInfo* _tmp24_;
				GIcon* _tmp25_;
				GIcon* _tmp26_;
#line 203 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp24_ = file_info;
#line 203 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp25_ = g_file_info_get_icon (_tmp24_);
#line 203 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_tmp26_ = _g_object_ref0 (_tmp25_);
#line 203 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				icon = _tmp26_;
#line 1098 "tracker-utils.c"
				{
					GIcon* _tmp27_;
#line 206 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					_tmp27_ = icon;
#line 206 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, g_file_icon_get_type ())) {
#line 1105 "tracker-utils.c"
						GdkPixbuf* _tmp28_ = NULL;
						GIcon* _tmp29_;
						GFile* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						GdkPixbuf* _tmp33_;
						GdkPixbuf* _tmp34_;
						GdkPixbuf* _tmp35_;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_tmp29_ = icon;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_tmp30_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_file_icon_get_type (), GFileIcon));
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_tmp31_ = g_file_get_path (_tmp30_);
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_tmp32_ = _tmp31_;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_tmp33_ = gdk_pixbuf_new_from_file (_tmp32_, &_inner_error_);
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_tmp34_ = _tmp33_;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_g_free0 (_tmp32_);
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_tmp28_ = _tmp34_;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1132 "tracker-utils.c"
							goto __catch25_g_error;
						}
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_tmp35_ = _tmp28_;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_tmp28_ = NULL;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_g_object_unref0 (pixbuf);
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						pixbuf = _tmp35_;
#line 206 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_g_object_unref0 (_tmp28_);
#line 1145 "tracker-utils.c"
					} else {
						GIcon* _tmp36_;
#line 208 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						_tmp36_ = icon;
#line 208 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, g_themed_icon_get_type ())) {
#line 1152 "tracker-utils.c"
							GdkPixbuf* _tmp37_ = NULL;
							GtkIconTheme* _tmp38_;
							GIcon* _tmp39_;
							gchar** _tmp40_;
							gchar** _tmp41_;
							const gchar* _tmp42_;
							gint _tmp43_;
							GdkPixbuf* _tmp44_;
							GdkPixbuf* _tmp45_;
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_tmp38_ = theme;
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_tmp39_ = icon;
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_tmp41_ = _tmp40_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, g_themed_icon_get_type (), GThemedIcon));
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_tmp42_ = _tmp41_[0];
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_tmp43_ = size;
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_tmp44_ = gtk_icon_theme_load_icon (_tmp38_, _tmp42_, _tmp43_, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_tmp37_ = _tmp44_;
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1178 "tracker-utils.c"
								goto __catch25_g_error;
							}
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_tmp45_ = _tmp37_;
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_tmp37_ = NULL;
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_g_object_unref0 (pixbuf);
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							pixbuf = _tmp45_;
#line 208 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
							_g_object_unref0 (_tmp37_);
#line 1191 "tracker-utils.c"
						}
					}
				}
				goto __finally25;
				__catch25_g_error:
				{
					GError* e = NULL;
					GError* _tmp46_;
					const gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
#line 205 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					e = _inner_error_;
#line 205 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					_inner_error_ = NULL;
#line 212 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					_tmp46_ = e;
#line 212 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					_tmp47_ = _tmp46_->message;
#line 212 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					_tmp48_ = g_strconcat ("Error loading icon pixbuf: ", _tmp47_, NULL);
#line 212 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					_tmp49_ = _tmp48_;
#line 212 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					g_warning ("tracker-utils.vala:212: %s", _tmp49_);
#line 212 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					_g_free0 (_tmp49_);
#line 205 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					_g_error_free0 (e);
#line 1221 "tracker-utils.c"
				}
				__finally25:
#line 205 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 205 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					_g_object_unref0 (icon);
#line 205 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
					_g_object_unref0 (file_info);
#line 1230 "tracker-utils.c"
					goto __catch24_g_error;
				}
#line 202 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
				_g_object_unref0 (icon);
#line 1235 "tracker-utils.c"
			}
#line 197 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file_info);
#line 1239 "tracker-utils.c"
		}
		goto __finally24;
		__catch24_g_error:
		{
			GError* e = NULL;
			GError* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
#line 197 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 197 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 216 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp50_ = e;
#line 216 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp51_ = _tmp50_->message;
#line 216 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp52_ = g_strconcat ("Error looking up file for pixbuf: ", _tmp51_, NULL);
#line 216 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_tmp53_ = _tmp52_;
#line 216 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:216: %s", _tmp53_);
#line 216 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp53_);
#line 197 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 1267 "tracker-utils.c"
		}
		__finally24:
#line 197 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 197 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 197 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 197 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 197 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
			return NULL;
#line 1282 "tracker-utils.c"
		}
	}
#line 220 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp54_ = pixbuf;
#line 220 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (_tmp54_ != NULL) {
#line 221 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		result = pixbuf;
#line 221 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (file);
#line 221 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		return result;
#line 1295 "tracker-utils.c"
	}
#line 224 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp55_ = theme;
#line 224 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp56_ = size;
#line 224 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp57_ = tracker_pixbuf_new_from_name (_tmp55_, "text-x-generic", _tmp56_);
#line 224 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	result = _tmp57_;
#line 224 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (pixbuf);
#line 224 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (file);
#line 224 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	return result;
#line 1311 "tracker-utils.c"
}


GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	gpointer _tmp0_;
	GdkPixbuf* _tmp1_;
	GError * _inner_error_ = NULL;
#line 227 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (theme != NULL, NULL);
#line 227 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 229 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = NULL;
#line 229 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gdk_pixbuf_get_type ()) ? ((GdkPixbuf*) _tmp0_) : NULL);
#line 229 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	pixbuf = _tmp1_;
#line 1331 "tracker-utils.c"
	{
		GdkPixbuf* _tmp2_ = NULL;
		GtkIconTheme* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp3_ = theme;
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp4_ = name;
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp5_ = size;
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp6_ = gtk_icon_theme_load_icon (_tmp3_, _tmp4_, _tmp5_, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp2_ = _tmp6_;
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1351 "tracker-utils.c"
			goto __catch26_g_error;
		}
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp7_ = _tmp2_;
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp2_ = NULL;
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (pixbuf);
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		pixbuf = _tmp7_;
#line 231 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (_tmp2_);
#line 1364 "tracker-utils.c"
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 231 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		e = _inner_error_;
#line 231 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_inner_error_ = NULL;
#line 234 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp8_ = name;
#line 234 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp9_ = e;
#line 234 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_tmp10_ = _tmp9_->message;
#line 234 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_warning ("tracker-utils.vala:234: Could not load default icon pixbuf from theme " \
"for '%s': %s", _tmp8_, _tmp10_);
#line 231 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_error_free0 (e);
#line 1387 "tracker-utils.c"
	}
	__finally26:
#line 231 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 231 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (pixbuf);
#line 231 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 231 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		g_clear_error (&_inner_error_);
#line 231 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
		return NULL;
#line 1400 "tracker-utils.c"
	}
#line 237 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	result = pixbuf;
#line 237 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-needle/tracker-utils.vala"
	return result;
#line 1406 "tracker-utils.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



