/* tracker-backend.c generated by valac 0.25.1, the Vala compiler
 * generated from tracker-backend.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-bus/tracker-bus.h"


#define TRACKER_SPARQL_TYPE_BACKEND (tracker_sparql_backend_get_type ())
#define TRACKER_SPARQL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend))
#define TRACKER_SPARQL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))
#define TRACKER_SPARQL_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))

typedef struct _TrackerSparqlBackend TrackerSparqlBackend;
typedef struct _TrackerSparqlBackendClass TrackerSparqlBackendClass;
typedef struct _TrackerSparqlBackendPrivate TrackerSparqlBackendPrivate;

#define TRACKER_SPARQL_BACKEND_TYPE_BACKEND (tracker_sparql_backend_backend_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerSparqlBackendQueryAsyncData TrackerSparqlBackendQueryAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateAsyncData TrackerSparqlBackendUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateArrayAsyncData TrackerSparqlBackendUpdateArrayAsyncData;
typedef struct _TrackerSparqlBackendUpdateBlankAsyncData TrackerSparqlBackendUpdateBlankAsyncData;
typedef struct _TrackerSparqlBackendLoadAsyncData TrackerSparqlBackendLoadAsyncData;
typedef struct _TrackerSparqlBackendStatisticsAsyncData TrackerSparqlBackendStatisticsAsyncData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _TrackerSparqlBackendGetInternalAsyncData TrackerSparqlBackendGetInternalAsyncData;
typedef struct _TrackerSparqlConnectionGetAsyncData TrackerSparqlConnectionGetAsyncData;
typedef struct _TrackerSparqlConnectionGetDirectAsyncData TrackerSparqlConnectionGetDirectAsyncData;

struct _TrackerSparqlBackend {
	TrackerSparqlConnection parent_instance;
	TrackerSparqlBackendPrivate * priv;
};

struct _TrackerSparqlBackendClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerSparqlBackendPrivate {
	gboolean initialized;
	TrackerSparqlConnection* direct;
	TrackerSparqlConnection* bus;
	GBusType bus_type;
};

typedef enum  {
	TRACKER_SPARQL_BACKEND_BACKEND_AUTO,
	TRACKER_SPARQL_BACKEND_BACKEND_DIRECT,
	TRACKER_SPARQL_BACKEND_BACKEND_BUS
} TrackerSparqlBackendBackend;

struct _TrackerSparqlBackendQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	const gchar* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	const gchar* _tmp4_;
	GCancellable* _tmp5_;
	TrackerSparqlCursor* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	TrackerSparqlCursor* _tmp8_;
	TrackerSparqlConnection* _tmp9_;
	const gchar* _tmp10_;
	GCancellable* _tmp11_;
	TrackerSparqlCursor* _tmp12_;
	TrackerSparqlCursor* _tmp13_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	gint _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	GCancellable* _tmp7_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	GPtrArray* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	GCancellable* _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* _tmp8_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	gint _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _tmp3_;
	GVariant* _tmp4_;
	TrackerSparqlConnection* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	GCancellable* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	GFile* file;
	GCancellable* cancellable;
	gchar* uri;
	GFile* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GError* _tmp4_;
	TrackerSparqlConnection* _tmp5_;
	GFile* _tmp6_;
	GCancellable* _tmp7_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GCancellable* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	TrackerSparqlCursor* _tmp6_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* async_result;
};

struct _Block2Data {
	int _ref_count_;
	GError* sparql_error;
	GError* io_error;
	GError* dbus_error;
	GError* spawn_error;
	TrackerSparqlConnection* _result_;
	GMainContext* context;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _TrackerSparqlBackendGetInternalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	Block2Data* _data2_;
	GCancellable* _tmp0_;
	gboolean _tmp1_;
	TrackerSparqlConnection* _result_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	GMainContext* _tmp5_;
	GMainContext* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	TrackerSparqlConnection* _tmp19_;
	TrackerSparqlConnection* _tmp20_;
	GError * _inner_error_;
};

struct _TrackerSparqlConnectionGetAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
	GCancellable* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GError * _inner_error_;
};

struct _TrackerSparqlConnectionGetDirectAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
	GCancellable* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GError * _inner_error_;
};


static gpointer tracker_sparql_backend_parent_class = NULL;
static TrackerSparqlConnection* tracker_sparql_backend_singleton;
static TrackerSparqlConnection* tracker_sparql_backend_singleton = NULL;
static gboolean tracker_sparql_backend_log_initialized;
static gboolean tracker_sparql_backend_log_initialized = FALSE;
static GMutex tracker_sparql_backend_door;
static GMutex tracker_sparql_backend_door = {0};

GType tracker_sparql_backend_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendPrivate))
enum  {
	TRACKER_SPARQL_BACKEND_DUMMY_PROPERTY
};
static GType tracker_sparql_backend_backend_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
TrackerSparqlBackend* tracker_sparql_backend_new (GError** error);
TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, GError** error);
static void tracker_sparql_backend_load_env (TrackerSparqlBackend* self);
static void tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, GError** error);
static void tracker_sparql_backend_real_dispose (GObject* base);
static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_query_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* _data_);
static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_update_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* _data_);
static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* _data_);
static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* _data_);
static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_load_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* _data_);
static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* _data_);
static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerSparqlConnection* tracker_sparql_backend_get (GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_log_init (void);
TrackerSparqlConnection* tracker_sparql_backend_get_internal (GCancellable* cancellable, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void tracker_sparql_backend_get_internal_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_, GError** error);
static void __lambda6_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tracker_sparql_backend_get_internal_async_data_free (gpointer _data);
static gboolean tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block2Data* _data2_, GIOSchedulerJob* job);
static gboolean __lambda5_ (Block2Data* _data2_);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean ___lambda4__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self);
static void tracker_sparql_backend_remove_log_handler (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
static void _tracker_sparql_backend_remove_log_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void tracker_sparql_backend_finalize (GObject* obj);
static void tracker_sparql_connection_get_async_data_free (gpointer _data);
void tracker_sparql_connection_get_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* _data_);
static void tracker_sparql_connection_get_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_get_direct_async_data_free (gpointer _data);
void tracker_sparql_connection_get_direct_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_direct_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_get_direct_async_co (TrackerSparqlConnectionGetDirectAsyncData* _data_);
static void tracker_sparql_connection_get_direct_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_direct (GCancellable* cancellable, GError** error);


static GType tracker_sparql_backend_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_backend_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BACKEND_BACKEND_AUTO, "TRACKER_SPARQL_BACKEND_BACKEND_AUTO", "auto"}, {TRACKER_SPARQL_BACKEND_BACKEND_DIRECT, "TRACKER_SPARQL_BACKEND_BACKEND_DIRECT", "direct"}, {TRACKER_SPARQL_BACKEND_BACKEND_BUS, "TRACKER_SPARQL_BACKEND_BACKEND_BUS", "bus"}, {0, NULL, NULL}};
		GType tracker_sparql_backend_backend_type_id;
		tracker_sparql_backend_backend_type_id = g_enum_register_static ("TrackerSparqlBackendBackend", values);
		g_once_init_leave (&tracker_sparql_backend_backend_type_id__volatile, tracker_sparql_backend_backend_type_id);
	}
	return tracker_sparql_backend_backend_type_id__volatile;
}


TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, GError** error) {
	TrackerSparqlBackend * self = NULL;
	GError * _inner_error_ = NULL;
#line 31 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) tracker_sparql_connection_construct (object_type);
#line 399 "tracker-backend.c"
	{
		GDBusConnection* bus = NULL;
		GBusType _tmp0_ = 0;
		GDBusConnection* _tmp1_ = NULL;
		GDBusMessage* msg = NULL;
		GDBusMessage* _tmp2_ = NULL;
		GDBusMessage* _tmp3_ = NULL;
		GDBusConnection* _tmp4_ = NULL;
		GDBusMessage* _tmp5_ = NULL;
		GDBusMessage* _tmp6_ = NULL;
		GDBusMessage* _tmp7_ = NULL;
		GDBusMessage* _tmp8_ = NULL;
#line 34 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		tracker_sparql_backend_load_env (self);
#line 37 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("tracker-backend.vala:37: Waiting for service to become available...");
#line 41 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = self->priv->bus_type;
#line 41 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = g_bus_get_sync (_tmp0_, NULL, &_inner_error_);
#line 41 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		bus = _tmp1_;
#line 41 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 424 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 42 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = g_dbus_message_new_method_call (TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_STATUS, TRACKER_DBUS_INTERFACE_STATUS, "Wait");
#line 42 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		msg = _tmp2_;
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = bus;
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = msg;
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp6_ = g_dbus_connection_send_message_with_reply_sync (_tmp4_, _tmp5_, 0, G_MAXINT, NULL, NULL, &_inner_error_);
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = _tmp6_;
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (msg);
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (bus);
#line 445 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp7_ = _tmp3_;
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = NULL;
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = _tmp7_;
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_dbus_message_to_gerror (_tmp8_, &_inner_error_);
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp8_);
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp3_);
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (msg);
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (bus);
#line 466 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 45 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("tracker-backend.vala:45: Service is ready");
#line 47 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("tracker-backend.vala:47: Constructing connection");
#line 48 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		tracker_sparql_backend_load_plugins (self, &_inner_error_);
#line 48 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 48 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp3_);
#line 48 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (msg);
#line 48 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (bus);
#line 483 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 49 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("tracker-backend.vala:49: Backend is ready");
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp3_);
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (msg);
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (bus);
#line 494 "tracker-backend.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e = _inner_error_;
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 51 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = e;
#line 51 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp10_ = _tmp9_->message;
#line 51 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp11_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp10_);
#line 51 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp11_;
#line 51 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e);
#line 517 "tracker-backend.c"
		goto __finally0;
	}
	__finally0:
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self);
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 531 "tracker-backend.c"
		} else {
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 539 "tracker-backend.c"
		}
	}
#line 54 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv->initialized = TRUE;
#line 31 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self;
#line 546 "tracker-backend.c"
}


TrackerSparqlBackend* tracker_sparql_backend_new (GError** error) {
#line 31 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return tracker_sparql_backend_construct (TRACKER_SPARQL_TYPE_BACKEND, error);
#line 553 "tracker-backend.c"
}


static void tracker_sparql_backend_load_env (TrackerSparqlBackend* self) {
	gchar* env_bus_type = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 57 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = g_getenv ("TRACKER_BUS_TYPE");
#line 58 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 58 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	env_bus_type = _tmp1_;
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = env_bus_type;
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp2_ != NULL) {
#line 574 "tracker-backend.c"
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = env_bus_type;
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = g_ascii_strcasecmp (_tmp3_, "system");
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_tmp4_ == 0) {
#line 62 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			self->priv->bus_type = G_BUS_TYPE_SYSTEM;
#line 63 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_debug ("tracker-backend.vala:63: Using bus = 'SYSTEM'");
#line 587 "tracker-backend.c"
		} else {
			const gchar* _tmp5_ = NULL;
			gint _tmp6_ = 0;
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp5_ = env_bus_type;
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp6_ = g_ascii_strcasecmp (_tmp5_, "session");
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp6_ == 0) {
#line 65 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				self->priv->bus_type = G_BUS_TYPE_SESSION;
#line 66 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_debug ("tracker-backend.vala:66: Using bus = 'SESSION'");
#line 601 "tracker-backend.c"
			} else {
				const gchar* _tmp7_ = NULL;
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp7_ = env_bus_type;
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_warning ("tracker-backend.vala:68: Environment variable TRACKER_BUS_TYPE set to " \
"unknown value '%s'", _tmp7_);
#line 608 "tracker-backend.c"
			}
		}
	}
#line 57 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (env_bus_type);
#line 614 "tracker-backend.c"
}


static void tracker_sparql_backend_real_dispose (GObject* base) {
	TrackerSparqlBackend * self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 73 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 75 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = self->priv->initialized;
#line 75 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_) {
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_mutex_lock (&tracker_sparql_backend_door);
#line 630 "tracker-backend.c"
		{
			TrackerSparqlConnection* _tmp1_ = NULL;
#line 83 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp1_ = tracker_sparql_backend_singleton;
#line 83 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection)) {
#line 84 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				tracker_sparql_backend_singleton = NULL;
#line 639 "tracker-backend.c"
			}
		}
		__finally1:
		{
#line 87 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_mutex_unlock (&tracker_sparql_backend_door);
#line 646 "tracker-backend.c"
		}
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 656 "tracker-backend.c"
		}
	}
#line 91 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection));
#line 661 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	const gchar* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 94 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 94 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 95 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = sparql;
#line 95 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:95: %s(): '%s'", "Tracker.Sparql.Backend.query", _tmp0_);
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = self->priv->direct;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp1_ != NULL) {
#line 683 "tracker-backend.c"
		TrackerSparqlCursor* _tmp2_ = NULL;
		TrackerSparqlConnection* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GCancellable* _tmp5_ = NULL;
		TrackerSparqlCursor* _tmp6_ = NULL;
		TrackerSparqlCursor* _tmp7_ = NULL;
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = self->priv->direct;
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = sparql;
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = cancellable;
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp6_ = tracker_sparql_connection_query (_tmp3_, _tmp4_, _tmp5_, &_inner_error_);
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = _tmp6_;
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 708 "tracker-backend.c"
			} else {
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_inner_error_);
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 716 "tracker-backend.c"
			}
		}
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp7_ = _tmp2_;
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = NULL;
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp7_;
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp2_);
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 729 "tracker-backend.c"
	} else {
		TrackerSparqlCursor* _tmp8_ = NULL;
		TrackerSparqlConnection* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GCancellable* _tmp11_ = NULL;
		TrackerSparqlCursor* _tmp12_ = NULL;
		TrackerSparqlCursor* _tmp13_ = NULL;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = self->priv->bus;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp10_ = sparql;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp11_ = cancellable;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp12_ = tracker_sparql_connection_query (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = _tmp12_;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 755 "tracker-backend.c"
			} else {
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_inner_error_);
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 763 "tracker-backend.c"
			}
		}
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp13_ = _tmp8_;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = NULL;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp13_;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp8_);
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 776 "tracker-backend.c"
	}
}


static void tracker_sparql_backend_real_query_async_data_free (gpointer _data) {
	TrackerSparqlBackendQueryAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendQueryAsyncData, _data_);
#line 794 "tracker-backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 801 "tracker-backend.c"
}


static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendQueryAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendQueryAsyncData);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_query_async);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_query_async_data_free);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp2_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = cancellable;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp4_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_query_async_co (_data_);
#line 843 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendQueryAsyncData* _data_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 854 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 864 "tracker-backend.c"
}


static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendQueryAsyncData* _data_;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_query_async_co (_data_);
#line 878 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* _data_) {
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 887 "tracker-backend.c"
		goto _state_0;
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 891 "tracker-backend.c"
		goto _state_1;
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 2:
#line 895 "tracker-backend.c"
		goto _state_2;
		default:
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 900 "tracker-backend.c"
	}
	_state_0:
#line 104 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 104 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->sparql;
#line 104 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:104: %s(): '%s'", "Tracker.Sparql.Backend.query_async", _data_->_tmp0_);
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->self->priv->direct;
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp1_ != NULL) {
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = NULL;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = _data_->self->priv->direct;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = NULL;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = _data_->sparql;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp5_ = NULL;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp5_ = _data_->cancellable;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_state_ = 1;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		tracker_sparql_connection_query_async (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, tracker_sparql_backend_query_async_ready, _data_);
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 933 "tracker-backend.c"
		_state_1:
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp6_ = NULL;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp6_ = tracker_sparql_connection_query_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp2_ = _data_->_tmp6_;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_error_free (_data_->_inner_error_);
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (_data_->_state_ == 0) {
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 953 "tracker-backend.c"
				} else {
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 957 "tracker-backend.c"
				}
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_object_unref (_data_->_async_result);
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 963 "tracker-backend.c"
			} else {
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_data_->_inner_error_);
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 971 "tracker-backend.c"
			}
		}
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp7_ = NULL;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp7_ = _data_->_tmp2_;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp2_ = NULL;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->result = _data_->_tmp7_;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data_->_tmp2_);
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_state_ == 0) {
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 988 "tracker-backend.c"
		} else {
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 992 "tracker-backend.c"
		}
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 998 "tracker-backend.c"
	} else {
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp9_ = NULL;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp9_ = _data_->self->priv->bus;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp10_ = NULL;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp10_ = _data_->sparql;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp11_ = NULL;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp11_ = _data_->cancellable;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_state_ = 2;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		tracker_sparql_connection_query_async (_data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, tracker_sparql_backend_query_async_ready, _data_);
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 1018 "tracker-backend.c"
		_state_2:
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp12_ = NULL;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp12_ = tracker_sparql_connection_query_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = _data_->_tmp12_;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_error_free (_data_->_inner_error_);
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (_data_->_state_ == 0) {
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1038 "tracker-backend.c"
				} else {
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 1042 "tracker-backend.c"
				}
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_object_unref (_data_->_async_result);
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 1048 "tracker-backend.c"
			} else {
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_data_->_inner_error_);
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 1056 "tracker-backend.c"
			}
		}
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp13_ = NULL;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp13_ = _data_->_tmp8_;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = NULL;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->result = _data_->_tmp13_;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data_->_tmp8_);
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_state_ == 0) {
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1073 "tracker-backend.c"
		} else {
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1077 "tracker-backend.c"
		}
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 1083 "tracker-backend.c"
	}
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1089 "tracker-backend.c"
	} else {
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1093 "tracker-backend.c"
	}
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1099 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	TrackerSparqlConnection* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GCancellable* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 112 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 112 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (sparql != NULL);
#line 113 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = priority;
#line 113 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 113 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:113: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update", _tmp0_, _tmp1_);
#line 114 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = self->priv->bus;
#line 114 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp2_ == NULL) {
#line 1127 "tracker-backend.c"
		GError* _tmp3_ = NULL;
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp3_;
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1139 "tracker-backend.c"
		} else {
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1147 "tracker-backend.c"
		}
	}
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = self->priv->bus;
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = sparql;
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = priority;
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = cancellable;
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update (_tmp4_, _tmp5_, _tmp6_, _tmp7_, &_inner_error_);
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1168 "tracker-backend.c"
		} else {
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1176 "tracker-backend.c"
		}
	}
}


static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	GVariant* result = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	TrackerSparqlConnection* _tmp2_ = NULL;
	GVariant* _tmp4_ = NULL;
	TrackerSparqlConnection* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GCancellable* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 121 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = priority;
#line 121 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 121 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:121: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank", _tmp0_, _tmp1_);
#line 122 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = self->priv->bus;
#line 122 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp2_ == NULL) {
#line 1210 "tracker-backend.c"
		GError* _tmp3_ = NULL;
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp3_;
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1222 "tracker-backend.c"
		} else {
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1230 "tracker-backend.c"
		}
	}
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = self->priv->bus;
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = sparql;
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = priority;
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = cancellable;
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp9_ = tracker_sparql_connection_update_blank (_tmp5_, _tmp6_, _tmp7_, _tmp8_, &_inner_error_);
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _tmp9_;
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1253 "tracker-backend.c"
		} else {
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1261 "tracker-backend.c"
		}
	}
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp10_ = _tmp4_;
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = NULL;
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp10_;
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_variant_unref0 (_tmp4_);
#line 125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 1274 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateAsyncData, _data_);
#line 1289 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GCancellable* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateAsyncData);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_async);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_async_data_free);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp2_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = priority;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->priority = _tmp3_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = cancellable;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp5_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_async_co (_data_);
#line 1336 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return;
#line 1346 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1350 "tracker-backend.c"
}


static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_async_co (_data_);
#line 1364 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* _data_) {
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 1373 "tracker-backend.c"
		goto _state_0;
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 1377 "tracker-backend.c"
		goto _state_1;
		default:
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 1382 "tracker-backend.c"
	}
	_state_0:
#line 129 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = 0;
#line 129 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->priority;
#line 129 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 129 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->sparql;
#line 129 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:129: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_async", _data_->_tmp0_, _data_->_tmp1_);
#line 130 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 130 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 130 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp2_ == NULL) {
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = NULL;
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1417 "tracker-backend.c"
			} else {
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1421 "tracker-backend.c"
			}
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1427 "tracker-backend.c"
		} else {
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1435 "tracker-backend.c"
		}
	}
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = NULL;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->self->priv->bus;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = NULL;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->sparql;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = 0;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->priority;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = NULL;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->cancellable;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_async (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, tracker_sparql_backend_update_async_ready, _data_);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1460 "tracker-backend.c"
	_state_1:
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1476 "tracker-backend.c"
			} else {
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1480 "tracker-backend.c"
			}
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1486 "tracker-backend.c"
		} else {
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1494 "tracker-backend.c"
		}
	}
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1501 "tracker-backend.c"
	} else {
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1505 "tracker-backend.c"
	}
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1511 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_ptr_array_unref0 (_data_->result);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateArrayAsyncData, _data_);
#line 1526 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateArrayAsyncData);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_array_async);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_array_async_data_free);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1__length1 = sparql_length1;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp1_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql_length1 = _tmp1__length1;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = priority;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->priority = _tmp2_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = cancellable;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp4_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_array_async_co (_data_);
#line 1573 "tracker-backend.c"
}


static GPtrArray* tracker_sparql_backend_real_update_array_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GPtrArray* result;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 1584 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 1594 "tracker-backend.c"
}


static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_array_async_co (_data_);
#line 1608 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* _data_) {
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 1617 "tracker-backend.c"
		goto _state_0;
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 1621 "tracker-backend.c"
		goto _state_1;
		default:
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 1626 "tracker-backend.c"
	}
	_state_0:
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->bus;
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp0_ == NULL) {
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp1_ = NULL;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp1_;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1651 "tracker-backend.c"
			} else {
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1655 "tracker-backend.c"
			}
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1661 "tracker-backend.c"
		} else {
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1669 "tracker-backend.c"
		}
	}
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = NULL;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = NULL;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4__length1 = 0;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->sparql;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4__length1 = _data_->sparql_length1;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = 0;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->priority;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = NULL;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->cancellable;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_array_async (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp4__length1, _data_->_tmp5_, _data_->_tmp6_, tracker_sparql_backend_update_array_async_ready, _data_);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1698 "tracker-backend.c"
	_state_1:
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = NULL;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = tracker_sparql_connection_update_array_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->_tmp7_;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1718 "tracker-backend.c"
			} else {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1722 "tracker-backend.c"
			}
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1728 "tracker-backend.c"
		} else {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1736 "tracker-backend.c"
		}
	}
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp8_ = NULL;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp8_ = _data_->_tmp2_;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp8_;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_ptr_array_unref0 (_data_->_tmp2_);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1753 "tracker-backend.c"
	} else {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1757 "tracker-backend.c"
	}
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_ptr_array_unref0 (_data_->_tmp2_);
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1769 "tracker-backend.c"
	} else {
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1773 "tracker-backend.c"
	}
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1779 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_variant_unref0 (_data_->result);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateBlankAsyncData, _data_);
#line 1796 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GCancellable* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateBlankAsyncData);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_blank_async);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_blank_async_data_free);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp2_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = priority;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->priority = _tmp3_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = cancellable;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp5_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_blank_async_co (_data_);
#line 1843 "tracker-backend.c"
}


static GVariant* tracker_sparql_backend_real_update_blank_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 1854 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 1864 "tracker-backend.c"
}


static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_blank_async_co (_data_);
#line 1878 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* _data_) {
#line 143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 1887 "tracker-backend.c"
		goto _state_0;
#line 143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 1891 "tracker-backend.c"
		goto _state_1;
		default:
#line 143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 1896 "tracker-backend.c"
	}
	_state_0:
#line 144 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = 0;
#line 144 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->priority;
#line 144 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 144 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->sparql;
#line 144 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:144: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank_async", _data_->_tmp0_, _data_->_tmp1_);
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp2_ == NULL) {
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = NULL;
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1931 "tracker-backend.c"
			} else {
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1935 "tracker-backend.c"
			}
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1941 "tracker-backend.c"
		} else {
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1949 "tracker-backend.c"
		}
	}
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = NULL;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->self->priv->bus;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = NULL;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->sparql;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = 0;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->priority;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp8_ = NULL;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp8_ = _data_->cancellable;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_blank_async (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, tracker_sparql_backend_update_blank_async_ready, _data_);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1974 "tracker-backend.c"
	_state_1:
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp9_ = NULL;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp9_ = tracker_sparql_connection_update_blank_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->_tmp9_;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1994 "tracker-backend.c"
			} else {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1998 "tracker-backend.c"
			}
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2004 "tracker-backend.c"
		} else {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2012 "tracker-backend.c"
		}
	}
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp10_ = NULL;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp10_ = _data_->_tmp4_;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = NULL;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp10_;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_variant_unref0 (_data_->_tmp4_);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2029 "tracker-backend.c"
	} else {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2033 "tracker-backend.c"
	}
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_variant_unref0 (_data_->_tmp4_);
#line 143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2045 "tracker-backend.c"
	} else {
#line 143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2049 "tracker-backend.c"
	}
#line 143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2055 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	gchar* uri = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_ = NULL;
	TrackerSparqlConnection* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (file != NULL);
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = file;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	uri = _tmp1_;
#line 153 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = uri;
#line 153 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:153: %s(): '%s'", "Tracker.Sparql.Backend.load", _tmp2_);
#line 154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = self->priv->bus;
#line 154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp3_ == NULL) {
#line 2088 "tracker-backend.c"
		GError* _tmp4_ = NULL;
#line 155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp4_;
#line 155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 2102 "tracker-backend.c"
		} else {
#line 155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 2112 "tracker-backend.c"
		}
	}
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = self->priv->bus;
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = file;
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = cancellable;
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_load (_tmp5_, _tmp6_, _tmp7_, &_inner_error_);
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 2133 "tracker-backend.c"
		} else {
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 2143 "tracker-backend.c"
		}
	}
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (uri);
#line 2148 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load_async_data_free (gpointer _data) {
	TrackerSparqlBackendLoadAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->file);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendLoadAsyncData, _data_);
#line 2163 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendLoadAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendLoadAsyncData);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_load_async);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_load_async_data_free);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = file;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->file);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->file = _tmp2_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = cancellable;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp4_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_load_async_co (_data_);
#line 2205 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendLoadAsyncData* _data_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return;
#line 2215 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2219 "tracker-backend.c"
}


static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendLoadAsyncData* _data_;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_load_async_co (_data_);
#line 2233 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* _data_) {
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 2242 "tracker-backend.c"
		goto _state_0;
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 2246 "tracker-backend.c"
		goto _state_1;
		default:
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 2251 "tracker-backend.c"
	}
	_state_0:
#line 161 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 161 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->file;
#line 161 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 161 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = g_file_get_uri (_data_->_tmp0_);
#line 161 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->uri = _data_->_tmp1_;
#line 162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->uri;
#line 162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:162: %s(): '%s'", "Tracker.Sparql.Backend.load_async", _data_->_tmp2_);
#line 163 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = NULL;
#line 163 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 163 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp3_ == NULL) {
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = NULL;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp4_;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2294 "tracker-backend.c"
			} else {
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2298 "tracker-backend.c"
			}
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2304 "tracker-backend.c"
		} else {
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2314 "tracker-backend.c"
		}
	}
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = NULL;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->self->priv->bus;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = NULL;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->file;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = NULL;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->cancellable;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_load_async (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, tracker_sparql_backend_load_async_ready, _data_);
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2335 "tracker-backend.c"
	_state_1:
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_load_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2353 "tracker-backend.c"
			} else {
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2357 "tracker-backend.c"
			}
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2363 "tracker-backend.c"
		} else {
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2373 "tracker-backend.c"
		}
	}
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->uri);
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2382 "tracker-backend.c"
	} else {
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2386 "tracker-backend.c"
	}
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2392 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlCursor* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	TrackerSparqlCursor* _tmp5_ = NULL;
	TrackerSparqlCursor* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 169 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 170 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:170: %s()", "Tracker.Sparql.Backend.statistics");
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = self->priv->bus;
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 2414 "tracker-backend.c"
		GError* _tmp1_ = NULL;
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Statistics support not available for direct-only connection");
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp1_;
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 2426 "tracker-backend.c"
		} else {
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 2434 "tracker-backend.c"
		}
	}
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = self->priv->bus;
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = cancellable;
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = tracker_sparql_connection_statistics (_tmp3_, _tmp4_, &_inner_error_);
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _tmp5_;
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 2453 "tracker-backend.c"
		} else {
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 2461 "tracker-backend.c"
		}
	}
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = _tmp2_;
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = NULL;
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp6_;
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 2474 "tracker-backend.c"
}


static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data) {
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendStatisticsAsyncData, _data_);
#line 2489 "tracker-backend.c"
}


static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendStatisticsAsyncData);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_statistics_async);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_statistics_async_data_free);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = cancellable;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp2_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_statistics_async_co (_data_);
#line 2521 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 2532 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 2542 "tracker-backend.c"
}


static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendStatisticsAsyncData* _data_;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_statistics_async_co (_data_);
#line 2556 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* _data_) {
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 2565 "tracker-backend.c"
		goto _state_0;
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 2569 "tracker-backend.c"
		goto _state_1;
		default:
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 2574 "tracker-backend.c"
	}
	_state_0:
#line 178 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:178: %s()", "Tracker.Sparql.Backend.statistics_async");
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->bus;
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp0_ == NULL) {
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp1_ = NULL;
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Statistics support not available for direct-only connection");
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp1_;
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2601 "tracker-backend.c"
			} else {
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2605 "tracker-backend.c"
			}
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2611 "tracker-backend.c"
		} else {
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2619 "tracker-backend.c"
		}
	}
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = NULL;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = NULL;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->cancellable;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_statistics_async (_data_->_tmp3_, _data_->_tmp4_, tracker_sparql_backend_statistics_async_ready, _data_);
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2636 "tracker-backend.c"
	_state_1:
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = NULL;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = tracker_sparql_connection_statistics_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->_tmp5_;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2656 "tracker-backend.c"
			} else {
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2660 "tracker-backend.c"
			}
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2666 "tracker-backend.c"
		} else {
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2674 "tracker-backend.c"
		}
	}
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = NULL;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->_tmp2_;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp6_;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2691 "tracker-backend.c"
	} else {
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2695 "tracker-backend.c"
	}
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2707 "tracker-backend.c"
	} else {
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2711 "tracker-backend.c"
	}
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2717 "tracker-backend.c"
}


static void tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, GError** error) {
	gchar* env_backend = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	TrackerSparqlBackendBackend backend = 0;
	const gchar* _tmp2_ = NULL;
	TrackerSparqlBackendBackend _tmp8_ = 0;
	TrackerSparqlBackendBackend _tmp9_ = 0;
	GError * _inner_error_ = NULL;
#line 186 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (self != NULL);
#line 187 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = g_getenv ("TRACKER_SPARQL_BACKEND");
#line 187 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 187 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	env_backend = _tmp1_;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	backend = TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
#line 190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = env_backend;
#line 190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp2_ != NULL) {
#line 2744 "tracker-backend.c"
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 191 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = env_backend;
#line 191 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = g_ascii_strcasecmp (_tmp3_, "direct");
#line 191 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_tmp4_ == 0) {
#line 192 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
#line 193 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_debug ("tracker-backend.vala:193: Using backend = 'DIRECT'");
#line 2757 "tracker-backend.c"
		} else {
			const gchar* _tmp5_ = NULL;
			gint _tmp6_ = 0;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp5_ = env_backend;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp6_ = g_ascii_strcasecmp (_tmp5_, "bus");
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp6_ == 0) {
#line 195 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				backend = TRACKER_SPARQL_BACKEND_BACKEND_BUS;
#line 196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_debug ("tracker-backend.vala:196: Using backend = 'BUS'");
#line 2771 "tracker-backend.c"
			} else {
				const gchar* _tmp7_ = NULL;
#line 198 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp7_ = env_backend;
#line 198 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_warning ("tracker-backend.vala:198: Environment variable TRACKER_SPARQL_BACKEND " \
"set to unknown value '%s'", _tmp7_);
#line 2778 "tracker-backend.c"
			}
		}
	}
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = backend;
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp8_ == TRACKER_SPARQL_BACKEND_BACKEND_AUTO) {
#line 203 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("tracker-backend.vala:203: Using backend = 'AUTO'");
#line 2788 "tracker-backend.c"
	}
#line 206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp9_ = backend;
#line 206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_tmp9_) {
#line 206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_AUTO:
#line 2796 "tracker-backend.c"
		{
			TrackerBusConnection* _tmp17_ = NULL;
			TrackerBusConnection* _tmp18_ = NULL;
			TrackerBusConnection* _tmp19_ = NULL;
			{
				TrackerDirectConnection* _tmp10_ = NULL;
				TrackerDirectConnection* _tmp11_ = NULL;
				TrackerDirectConnection* _tmp12_ = NULL;
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp11_ = tracker_direct_connection_new (&_inner_error_);
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp10_ = _tmp11_;
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2813 "tracker-backend.c"
						goto __catch2_tracker_sparql_error;
					}
					goto __finally2;
				}
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp12_ = _tmp10_;
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp10_ = NULL;
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (self->priv->direct);
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				self->priv->direct = (TrackerSparqlConnection*) _tmp12_;
#line 208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_tmp10_);
#line 2828 "tracker-backend.c"
			}
			goto __finally2;
			__catch2_tracker_sparql_error:
			{
				GError* e = NULL;
				GError* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
#line 208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				e = _inner_error_;
#line 208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_inner_error_ = NULL;
#line 211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp13_ = e;
#line 211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp14_ = _tmp13_->message;
#line 211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp15_ = g_strconcat ("Unable to initialize direct backend: ", _tmp14_, NULL);
#line 211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp16_ = _tmp15_;
#line 211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_debug ("tracker-backend.vala:211: %s", _tmp16_);
#line 211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (_tmp16_);
#line 208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_error_free0 (e);
#line 2856 "tracker-backend.c"
			}
			__finally2:
#line 208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2867 "tracker-backend.c"
			}
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp18_ = tracker_bus_connection_new (&_inner_error_);
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp17_ = _tmp18_;
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2881 "tracker-backend.c"
			}
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp19_ = _tmp17_;
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp17_ = NULL;
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self->priv->bus);
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			self->priv->bus = (TrackerSparqlConnection*) _tmp19_;
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp17_);
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 2895 "tracker-backend.c"
		}
#line 206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_DIRECT:
#line 2899 "tracker-backend.c"
		{
			TrackerDirectConnection* _tmp20_ = NULL;
			TrackerDirectConnection* _tmp21_ = NULL;
			TrackerDirectConnection* _tmp22_ = NULL;
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp21_ = tracker_direct_connection_new (&_inner_error_);
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp20_ = _tmp21_;
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2916 "tracker-backend.c"
			}
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp22_ = _tmp20_;
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp20_ = NULL;
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self->priv->direct);
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			self->priv->direct = (TrackerSparqlConnection*) _tmp22_;
#line 219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp20_);
#line 219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 2930 "tracker-backend.c"
		}
#line 206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_BUS:
#line 2934 "tracker-backend.c"
		{
			TrackerBusConnection* _tmp23_ = NULL;
			TrackerBusConnection* _tmp24_ = NULL;
			TrackerBusConnection* _tmp25_ = NULL;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp24_ = tracker_bus_connection_new (&_inner_error_);
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp23_ = _tmp24_;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2951 "tracker-backend.c"
			}
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp25_ = _tmp23_;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp23_ = NULL;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self->priv->bus);
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			self->priv->bus = (TrackerSparqlConnection*) _tmp25_;
#line 223 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp23_);
#line 223 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 2965 "tracker-backend.c"
		}
		default:
		{
#line 226 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_assert_not_reached ();
#line 2971 "tracker-backend.c"
		}
	}
#line 186 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (env_backend);
#line 2976 "tracker-backend.c"
}


static TrackerSparqlConnection* tracker_sparql_backend_get (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	GError * _inner_error_ = NULL;
#line 235 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_mutex_lock (&tracker_sparql_backend_door);
#line 2985 "tracker-backend.c"
	{
		TrackerSparqlConnection* _result_ = NULL;
		TrackerSparqlConnection* _tmp0_ = NULL;
		TrackerSparqlConnection* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_ = NULL;
#line 239 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = tracker_sparql_backend_singleton;
#line 239 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 239 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_result_ = _tmp1_;
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = _result_;
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_tmp2_ == NULL) {
#line 3001 "tracker-backend.c"
			TrackerSparqlBackend* _tmp3_ = NULL;
			TrackerSparqlBackend* _tmp4_ = NULL;
			TrackerSparqlBackend* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			GCancellable* _tmp7_ = NULL;
			TrackerSparqlConnection* _tmp11_ = NULL;
#line 242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			tracker_sparql_backend_log_init ();
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp4_ = tracker_sparql_backend_new (&_inner_error_);
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp3_ = _tmp4_;
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_result_);
#line 3018 "tracker-backend.c"
				goto __finally3;
			}
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp5_ = _tmp3_;
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp3_ = NULL;
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_result_);
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_result_ = (TrackerSparqlConnection*) _tmp5_;
#line 246 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp7_ = cancellable;
#line 246 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp7_ != NULL) {
#line 3033 "tracker-backend.c"
				GCancellable* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 246 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp8_ = cancellable;
#line 246 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp9_ = g_cancellable_is_cancelled (_tmp8_);
#line 246 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp6_ = _tmp9_;
#line 3042 "tracker-backend.c"
			} else {
#line 246 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp6_ = FALSE;
#line 3046 "tracker-backend.c"
			}
#line 246 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp6_) {
#line 3050 "tracker-backend.c"
				GError* _tmp10_ = NULL;
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp10_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_inner_error_ = _tmp10_;
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_tmp3_);
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_result_);
#line 3060 "tracker-backend.c"
				goto __finally3;
			}
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp11_ = _result_;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			tracker_sparql_backend_singleton = _tmp11_;
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp3_);
#line 3069 "tracker-backend.c"
		}
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _result_;
#line 3073 "tracker-backend.c"
		{
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_mutex_unlock (&tracker_sparql_backend_door);
#line 3077 "tracker-backend.c"
		}
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 3081 "tracker-backend.c"
	}
	__finally3:
	{
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_mutex_unlock (&tracker_sparql_backend_door);
#line 3087 "tracker-backend.c"
	}
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 3095 "tracker-backend.c"
	} else {
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_clear_error (&_inner_error_);
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 3103 "tracker-backend.c"
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return _data1_;
#line 3113 "tracker-backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data1_->async_result);
#line 259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 3128 "tracker-backend.c"
	}
}


static void __lambda6_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (res != NULL);
#line 273 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = res;
#line 273 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 273 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data1_->async_result);
#line 273 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->async_result = _tmp1_;
#line 274 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _data1_->loop;
#line 274 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_loop_quit (_tmp2_);
#line 3151 "tracker-backend.c"
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	__lambda6_ (self, source_object, res);
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	block1_data_unref (self);
#line 3160 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_backend_get_internal (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	Block1Data* _data1_;
	GMainContext* _tmp0_ = NULL;
	GMainContext* context = NULL;
	GMainContext* _tmp5_ = NULL;
	GMainContext* _tmp6_ = NULL;
	GMainLoop* _tmp7_ = NULL;
	GMainContext* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	GMainLoop* _tmp10_ = NULL;
	GMainContext* _tmp11_ = NULL;
	TrackerSparqlConnection* _tmp12_ = NULL;
	GAsyncResult* _tmp13_ = NULL;
	TrackerSparqlConnection* _tmp14_ = NULL;
	TrackerSparqlConnection* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->_ref_count_ = 1;
#line 260 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = g_main_context_get_thread_default ();
#line 260 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 3189 "tracker-backend.c"
		TrackerSparqlConnection* _tmp1_ = NULL;
		GCancellable* _tmp2_ = NULL;
		TrackerSparqlConnection* _tmp3_ = NULL;
		TrackerSparqlConnection* _tmp4_ = NULL;
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = cancellable;
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = tracker_sparql_backend_get (_tmp2_, &_inner_error_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = _tmp3_;
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block1_data_unref (_data1_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data1_ = NULL;
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 3212 "tracker-backend.c"
			} else {
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block1_data_unref (_data1_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data1_ = NULL;
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_inner_error_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 3224 "tracker-backend.c"
			}
		}
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = _tmp1_;
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = NULL;
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp4_;
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp1_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		block1_data_unref (_data1_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data1_ = NULL;
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 3241 "tracker-backend.c"
	}
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = g_main_context_new ();
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	context = _tmp5_;
#line 267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = context;
#line 267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = g_main_loop_new (_tmp6_, FALSE);
#line 267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->loop = _tmp7_;
#line 268 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->async_result = NULL;
#line 270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = context;
#line 270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_context_push_thread_default (_tmp8_);
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp9_ = cancellable;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async (_tmp9_, ___lambda6__gasync_ready_callback, block1_data_ref (_data1_));
#line 277 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp10_ = _data1_->loop;
#line 277 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_loop_run (_tmp10_);
#line 279 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp11_ = context;
#line 279 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_context_pop_thread_default (_tmp11_);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp13_ = _data1_->async_result;
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp14_ = tracker_sparql_backend_get_internal_finish (_tmp13_, &_inner_error_);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp12_ = _tmp14_;
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_main_context_unref0 (context);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block1_data_unref (_data1_);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data1_ = NULL;
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 3291 "tracker-backend.c"
		} else {
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_main_context_unref0 (context);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block1_data_unref (_data1_);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data1_ = NULL;
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 3305 "tracker-backend.c"
		}
	}
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp15_ = _tmp12_;
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp12_ = NULL;
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp15_;
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_tmp12_);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_main_context_unref0 (context);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	block1_data_unref (_data1_);
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_ = NULL;
#line 281 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3324 "tracker-backend.c"
}


static void tracker_sparql_backend_get_internal_async_data_free (gpointer _data) {
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendGetInternalAsyncData, _data_);
#line 3335 "tracker-backend.c"
}


void tracker_sparql_backend_get_internal_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendGetInternalAsyncData);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_sparql_backend_get_internal_async);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_get_internal_async_data_free);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = cancellable;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp1_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async_co (_data_);
#line 3359 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlBackendGetInternalAsyncData* _data_;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 3370 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3380 "tracker-backend.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return _data2_;
#line 3389 "tracker-backend.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_main_context_unref0 (_data2_->context);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data2_->_result_);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->spawn_error);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->io_error);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data2_->cancellable);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_slice_free (Block2Data, _data2_);
#line 3414 "tracker-backend.c"
	}
}


static gpointer _g_main_context_ref0 (gpointer self) {
#line 303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self ? g_main_context_ref (self) : NULL;
#line 3422 "tracker-backend.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 309 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self ? g_error_copy (self) : NULL;
#line 3429 "tracker-backend.c"
}


static gboolean __lambda5_ (Block2Data* _data2_) {
	gboolean result = FALSE;
#line 320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async_co (_data2_->_async_data_);
#line 321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = FALSE;
#line 321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3441 "tracker-backend.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
#line 319 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3450 "tracker-backend.c"
}


static gboolean __lambda4_ (Block2Data* _data2_, GIOSchedulerJob* job) {
	gboolean result = FALSE;
	GSource* source = NULL;
	GSource* _tmp12_ = NULL;
	GMainContext* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (job != NULL, FALSE);
#line 3462 "tracker-backend.c"
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		GCancellable* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_ = NULL;
		TrackerSparqlConnection* _tmp3_ = NULL;
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = _data2_->cancellable;
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = tracker_sparql_backend_get (_tmp1_, &_inner_error_);
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = _tmp2_;
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 3478 "tracker-backend.c"
				goto __catch4_g_io_error;
			}
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3483 "tracker-backend.c"
				goto __catch4_tracker_sparql_error;
			}
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 3488 "tracker-backend.c"
				goto __catch4_g_dbus_error;
			}
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 3493 "tracker-backend.c"
				goto __catch4_g_spawn_error;
			}
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3502 "tracker-backend.c"
		}
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = _tmp0_;
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = NULL;
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data2_->_result_);
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->_result_ = _tmp3_;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp0_);
#line 3514 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_io = _inner_error_;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 309 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = e_io;
#line 309 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 309 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->io_error);
#line 309 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->io_error = _tmp5_;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_io);
#line 3536 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_tracker_sparql_error:
	{
		GError* e_spql = NULL;
		GError* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_spql = _inner_error_;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 311 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp6_ = e_spql;
#line 311 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp7_ = _g_error_copy0 (_tmp6_);
#line 311 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 311 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->sparql_error = _tmp7_;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_spql);
#line 3558 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_dbus = _inner_error_;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 313 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = e_dbus;
#line 313 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = _g_error_copy0 (_tmp8_);
#line 313 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 313 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->dbus_error = _tmp9_;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_dbus);
#line 3580 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e_spawn = NULL;
		GError* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_spawn = _inner_error_;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 315 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp10_ = e_spawn;
#line 315 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp11_ = _g_error_copy0 (_tmp10_);
#line 315 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->spawn_error);
#line 315 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->spawn_error = _tmp11_;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_spawn);
#line 3602 "tracker-backend.c"
	}
	__finally4:
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_clear_error (&_inner_error_);
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 3613 "tracker-backend.c"
	}
#line 318 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp12_ = g_idle_source_new ();
#line 318 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	source = _tmp12_;
#line 319 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_source_set_callback (source, ___lambda5__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 323 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp13_ = _data2_->context;
#line 323 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_source_attach (source, _tmp13_);
#line 325 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = FALSE;
#line 325 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_source_unref0 (source);
#line 325 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3631 "tracker-backend.c"
}


static gboolean ___lambda4__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self) {
	gboolean result;
	result = __lambda4_ (self, job);
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3640 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* _data_) {
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 3649 "tracker-backend.c"
		goto _state_0;
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 3653 "tracker-backend.c"
		goto _state_1;
		default:
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 3658 "tracker-backend.c"
	}
	_state_0:
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->cancellable;
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_data2_->cancellable);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->cancellable = _data_->_tmp0_;
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = FALSE;
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = g_mutex_trylock (&tracker_sparql_backend_door);
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp1_) {
#line 288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp2_ = NULL;
#line 288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp2_ = tracker_sparql_backend_singleton;
#line 288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = NULL;
#line 288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
#line 288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_result_ = _data_->_tmp3_;
#line 290 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_mutex_unlock (&tracker_sparql_backend_door);
#line 292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = NULL;
#line 292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = _data_->_result_;
#line 292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_tmp4_ != NULL) {
#line 293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->result = _data_->_result_;
#line 293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3709 "tracker-backend.c"
			} else {
#line 293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3713 "tracker-backend.c"
			}
#line 293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3719 "tracker-backend.c"
		}
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data_->_result_);
#line 3723 "tracker-backend.c"
	}
#line 298 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->sparql_error = NULL;
#line 299 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->io_error = NULL;
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->dbus_error = NULL;
#line 301 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->spawn_error = NULL;
#line 302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->_result_ = NULL;
#line 303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = NULL;
#line 303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = g_main_context_get_thread_default ();
#line 303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = NULL;
#line 303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _g_main_context_ref0 (_data_->_tmp5_);
#line 303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->context = _data_->_tmp6_;
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_io_scheduler_push_job (___lambda4__gio_scheduler_job_func, block2_data_ref (_data_->_data2_), block2_data_unref, G_PRIORITY_DEFAULT, NULL);
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 3751 "tracker-backend.c"
	_state_1:
	;
#line 329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = NULL;
#line 329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->_data2_->sparql_error;
#line 329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp7_ != NULL) {
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = NULL;
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = _data_->_data2_->sparql_error;
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp9_ = NULL;
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp9_;
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3784 "tracker-backend.c"
			} else {
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3788 "tracker-backend.c"
			}
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3794 "tracker-backend.c"
		} else {
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3806 "tracker-backend.c"
		}
	} else {
#line 331 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp10_ = NULL;
#line 331 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp10_ = _data_->_data2_->io_error;
#line 331 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_tmp10_ != NULL) {
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp11_ = NULL;
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp11_ = _data_->_data2_->io_error;
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp12_ = NULL;
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_inner_error_ = _data_->_tmp12_;
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_error_free (_data_->_inner_error_);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block2_data_unref (_data_->_data2_);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_data2_ = NULL;
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (_data_->_state_ == 0) {
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3839 "tracker-backend.c"
				} else {
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 3843 "tracker-backend.c"
				}
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_object_unref (_data_->_async_result);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 3849 "tracker-backend.c"
			} else {
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block2_data_unref (_data_->_data2_);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_data2_ = NULL;
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_data_->_inner_error_);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 3861 "tracker-backend.c"
			}
		} else {
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp13_ = NULL;
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp13_ = _data_->_data2_->dbus_error;
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_tmp13_ != NULL) {
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp14_ = NULL;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp14_ = _data_->_data2_->dbus_error;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp15_ = NULL;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp15_ = _g_error_copy0 (_data_->_tmp14_);
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_inner_error_ = _data_->_tmp15_;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_error_free (_data_->_inner_error_);
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if (_data_->_state_ == 0) {
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3894 "tracker-backend.c"
					} else {
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 3898 "tracker-backend.c"
					}
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_object_unref (_data_->_async_result);
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					return FALSE;
#line 3904 "tracker-backend.c"
				} else {
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_clear_error (&_data_->_inner_error_);
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					return FALSE;
#line 3916 "tracker-backend.c"
				}
			} else {
#line 335 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp16_ = NULL;
#line 335 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp16_ = _data_->_data2_->spawn_error;
#line 335 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (_data_->_tmp16_ != NULL) {
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp17_ = NULL;
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp17_ = _data_->_data2_->spawn_error;
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp18_ = NULL;
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp18_ = _g_error_copy0 (_data_->_tmp17_);
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_inner_error_ = _data_->_tmp18_;
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_error_free (_data_->_inner_error_);
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						block2_data_unref (_data_->_data2_);
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						_data_->_data2_ = NULL;
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						if (_data_->_state_ == 0) {
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
							g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3949 "tracker-backend.c"
						} else {
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
							g_simple_async_result_complete (_data_->_async_result);
#line 3953 "tracker-backend.c"
						}
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_object_unref (_data_->_async_result);
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						return FALSE;
#line 3959 "tracker-backend.c"
					} else {
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						block2_data_unref (_data_->_data2_);
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						_data_->_data2_ = NULL;
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_clear_error (&_data_->_inner_error_);
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						return FALSE;
#line 3971 "tracker-backend.c"
					}
				} else {
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp19_ = NULL;
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp19_ = _data_->_data2_->_result_;
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp20_ = NULL;
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->result = _data_->_tmp20_;
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if (_data_->_state_ == 0) {
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3992 "tracker-backend.c"
					} else {
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 3996 "tracker-backend.c"
					}
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_object_unref (_data_->_async_result);
#line 338 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					return FALSE;
#line 4002 "tracker-backend.c"
				}
			}
		}
	}
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	block2_data_unref (_data_->_data2_);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_ = NULL;
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4015 "tracker-backend.c"
	} else {
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4019 "tracker-backend.c"
	}
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 4025 "tracker-backend.c"
}


static void _tracker_sparql_backend_remove_log_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_remove_log_handler (log_domain, log_levels, message);
#line 4032 "tracker-backend.c"
}


static void tracker_sparql_backend_log_init (void) {
	gboolean _tmp0_ = FALSE;
	gint verbosity = 0;
	gchar* env_verbosity = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GLogLevelFlags remove_levels = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GLogLevelFlags _tmp8_ = 0;
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = tracker_sparql_backend_log_initialized;
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_) {
#line 344 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return;
#line 4053 "tracker-backend.c"
	}
#line 347 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_log_initialized = TRUE;
#line 350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	verbosity = 0;
#line 351 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = g_getenv ("TRACKER_VERBOSITY");
#line 351 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 351 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	env_verbosity = _tmp2_;
#line 352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = env_verbosity;
#line 352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp3_ != NULL) {
#line 4069 "tracker-backend.c"
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = env_verbosity;
#line 353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = atoi (_tmp4_);
#line 353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		verbosity = _tmp5_;
#line 4078 "tracker-backend.c"
	}
#line 355 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	remove_levels = 0;
#line 359 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = verbosity;
#line 359 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp6_ > 2) {
#line 360 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_setenv ("G_MESSAGES_DEBUG", "all", TRUE);
#line 4088 "tracker-backend.c"
	}
#line 362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = verbosity;
#line 362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_tmp7_) {
#line 362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 3:
#line 4096 "tracker-backend.c"
		{
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 4100 "tracker-backend.c"
		}
#line 362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 2:
#line 4104 "tracker-backend.c"
		{
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			remove_levels = G_LOG_LEVEL_DEBUG;
#line 370 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 4110 "tracker-backend.c"
		}
#line 362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 4114 "tracker-backend.c"
		{
#line 374 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			remove_levels = G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_MESSAGE;
#line 376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 4120 "tracker-backend.c"
		}
		default:
#line 362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 4125 "tracker-backend.c"
		{
#line 381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			remove_levels = (G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO;
#line 384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 4131 "tracker-backend.c"
		}
	}
#line 387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = remove_levels;
#line 387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp8_ != 0) {
#line 4138 "tracker-backend.c"
		GLogLevelFlags _tmp9_ = 0;
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = remove_levels;
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_log_set_handler ("Tracker", _tmp9_, _tracker_sparql_backend_remove_log_handler_glog_func, NULL);
#line 4144 "tracker-backend.c"
	}
#line 342 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (env_verbosity);
#line 4148 "tracker-backend.c"
}


static void tracker_sparql_backend_remove_log_handler (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
#line 392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (message != NULL);
#line 4155 "tracker-backend.c"
}


static void tracker_sparql_backend_class_init (TrackerSparqlBackendClass * klass) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlBackendPrivate));
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((GObjectClass *) klass)->dispose = tracker_sparql_backend_real_dispose;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->query = tracker_sparql_backend_real_query;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = tracker_sparql_backend_real_query_async;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = tracker_sparql_backend_real_query_finish;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update = tracker_sparql_backend_real_update;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank = tracker_sparql_backend_real_update_blank;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_async = tracker_sparql_backend_real_update_async;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_finish = tracker_sparql_backend_real_update_finish;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_async = tracker_sparql_backend_real_update_array_async;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_finish = tracker_sparql_backend_real_update_array_finish;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_async = tracker_sparql_backend_real_update_blank_async;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_finish = tracker_sparql_backend_real_update_blank_finish;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->load = tracker_sparql_backend_real_load;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->load_async = tracker_sparql_backend_real_load_async;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->load_finish = tracker_sparql_backend_real_load_finish;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics = tracker_sparql_backend_real_statistics;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_async = tracker_sparql_backend_real_statistics_async;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_finish = tracker_sparql_backend_real_statistics_finish;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_backend_finalize;
#line 4202 "tracker-backend.c"
}


static void tracker_sparql_backend_instance_init (TrackerSparqlBackend * self) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv = TRACKER_SPARQL_BACKEND_GET_PRIVATE (self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv->direct = NULL;
#line 23 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv->bus = NULL;
#line 29 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv->bus_type = G_BUS_TYPE_SESSION;
#line 4215 "tracker-backend.c"
}


static void tracker_sparql_backend_finalize (GObject* obj) {
	TrackerSparqlBackend * self;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (self->priv->direct);
#line 23 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (self->priv->bus);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->finalize (obj);
#line 4229 "tracker-backend.c"
}


GType tracker_sparql_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBackend), 0, (GInstanceInitFunc) tracker_sparql_backend_instance_init, NULL };
		GType tracker_sparql_backend_type_id;
		tracker_sparql_backend_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerSparqlBackend", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_backend_type_id__volatile, tracker_sparql_backend_type_id);
	}
	return tracker_sparql_backend_type_id__volatile;
}


static void tracker_sparql_connection_get_async_data_free (gpointer _data) {
	TrackerSparqlConnectionGetAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionGetAsyncData, _data_);
}


void tracker_sparql_connection_get_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionGetAsyncData* _data_;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	_data_ = g_slice_new0 (TrackerSparqlConnectionGetAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_sparql_connection_get_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_get_async_data_free);
	_tmp0_ = cancellable;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	tracker_sparql_connection_get_async_co (_data_);
}


TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionGetAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_connection_get_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionGetAsyncData* _data_;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_get_async_co (_data_);
#line 4292 "tracker-backend.c"
}


static gboolean tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* _data_) {
#line 397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 4301 "tracker-backend.c"
		goto _state_0;
#line 397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 4305 "tracker-backend.c"
		goto _state_1;
		default:
#line 397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 4310 "tracker-backend.c"
	}
	_state_0:
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async (_data_->_tmp1_, tracker_sparql_connection_get_async_ready, _data_);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 4323 "tracker-backend.c"
	_state_1:
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = tracker_sparql_backend_get_internal_finish (_data_->_res_, &_data_->_inner_error_);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->_tmp2_;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4343 "tracker-backend.c"
			} else {
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4347 "tracker-backend.c"
			}
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 4353 "tracker-backend.c"
		} else {
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 4361 "tracker-backend.c"
		}
	}
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = NULL;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->_tmp0_;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp3_;
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4378 "tracker-backend.c"
	} else {
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4382 "tracker-backend.c"
	}
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4394 "tracker-backend.c"
	} else {
#line 397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4398 "tracker-backend.c"
	}
#line 397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 4404 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	TrackerSparqlConnection* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = cancellable;
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = tracker_sparql_backend_get_internal (_tmp1_, &_inner_error_);
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _tmp2_;
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 4429 "tracker-backend.c"
		} else {
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 4437 "tracker-backend.c"
		}
	}
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = _tmp0_;
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = NULL;
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp3_;
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_tmp0_);
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 4450 "tracker-backend.c"
}


static void tracker_sparql_connection_get_direct_async_data_free (gpointer _data) {
	TrackerSparqlConnectionGetDirectAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionGetDirectAsyncData, _data_);
}


void tracker_sparql_connection_get_direct_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionGetDirectAsyncData* _data_;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	_data_ = g_slice_new0 (TrackerSparqlConnectionGetDirectAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_sparql_connection_get_direct_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_get_direct_async_data_free);
	_tmp0_ = cancellable;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	tracker_sparql_connection_get_direct_async_co (_data_);
}


TrackerSparqlConnection* tracker_sparql_connection_get_direct_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionGetDirectAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_connection_get_direct_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionGetDirectAsyncData* _data_;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_get_direct_async_co (_data_);
#line 4501 "tracker-backend.c"
}


static gboolean tracker_sparql_connection_get_direct_async_co (TrackerSparqlConnectionGetDirectAsyncData* _data_) {
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 4510 "tracker-backend.c"
		goto _state_0;
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 4514 "tracker-backend.c"
		goto _state_1;
		default:
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 4519 "tracker-backend.c"
	}
	_state_0:
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async (_data_->_tmp1_, tracker_sparql_connection_get_direct_async_ready, _data_);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 4532 "tracker-backend.c"
	_state_1:
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = tracker_sparql_backend_get_internal_finish (_data_->_res_, &_data_->_inner_error_);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->_tmp2_;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4552 "tracker-backend.c"
			} else {
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4556 "tracker-backend.c"
			}
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 4562 "tracker-backend.c"
		} else {
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 4570 "tracker-backend.c"
		}
	}
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = NULL;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->_tmp0_;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp3_;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4587 "tracker-backend.c"
	} else {
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4591 "tracker-backend.c"
	}
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4603 "tracker-backend.c"
	} else {
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4607 "tracker-backend.c"
	}
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 4613 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_connection_get_direct (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	TrackerSparqlConnection* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = cancellable;
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = tracker_sparql_backend_get_internal (_tmp1_, &_inner_error_);
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _tmp2_;
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 4638 "tracker-backend.c"
		} else {
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 4646 "tracker-backend.c"
		}
	}
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = _tmp0_;
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = NULL;
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp3_;
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_tmp0_);
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 4659 "tracker-backend.c"
}



