/* tracker-bus.c generated by valac 0.9.5.4-19a5, the Vala compiler
 * generated from tracker-bus.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tracker-sparql.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <dbus/dbus.h>
#include <config.h>
#include <libtracker-bus/tracker-bus-fd-cursor.h>
#include <tracker-bus-fd-update.h>
#include <tracker-bus-array-update.h>


#define TRACKER_BUS_TYPE_RESOURCES (tracker_bus_resources_get_type ())
#define TRACKER_BUS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_RESOURCES, TrackerBusResources))
#define TRACKER_BUS_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_RESOURCES))
#define TRACKER_BUS_RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TRACKER_BUS_TYPE_RESOURCES, TrackerBusResourcesIface))

typedef struct _TrackerBusResources TrackerBusResources;
typedef struct _TrackerBusResourcesIface TrackerBusResourcesIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerBusResourcesDBusProxy TrackerBusResourcesDBusProxy;
typedef DBusGProxyClass TrackerBusResourcesDBusProxyClass;
typedef struct _TrackerBusResourcesDBusProxySparqlQueryAsyncData TrackerBusResourcesDBusProxySparqlQueryAsyncData;
typedef struct _TrackerBusResourcesDBusProxySparqlUpdateAsyncData TrackerBusResourcesDBusProxySparqlUpdateAsyncData;
typedef struct _TrackerBusResourcesDBusProxyLoadAsyncData TrackerBusResourcesDBusProxyLoadAsyncData;

#define TRACKER_BUS_TYPE_STATISTICS (tracker_bus_statistics_get_type ())
#define TRACKER_BUS_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_STATISTICS, TrackerBusStatistics))
#define TRACKER_BUS_IS_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_STATISTICS))
#define TRACKER_BUS_STATISTICS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TRACKER_BUS_TYPE_STATISTICS, TrackerBusStatisticsIface))

typedef struct _TrackerBusStatistics TrackerBusStatistics;
typedef struct _TrackerBusStatisticsIface TrackerBusStatisticsIface;
typedef struct _TrackerBusStatisticsDBusProxy TrackerBusStatisticsDBusProxy;
typedef DBusGProxyClass TrackerBusStatisticsDBusProxyClass;
typedef struct _TrackerBusStatisticsDBusProxyGet_asyncData TrackerBusStatisticsDBusProxyGet_asyncData;

#define TRACKER_BUS_TYPE_CONNECTION (tracker_bus_connection_get_type ())
#define TRACKER_BUS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnection))
#define TRACKER_BUS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnectionClass))
#define TRACKER_BUS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_CONNECTION))
#define TRACKER_BUS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_CONNECTION))
#define TRACKER_BUS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnectionClass))

typedef struct _TrackerBusConnection TrackerBusConnection;
typedef struct _TrackerBusConnectionClass TrackerBusConnectionClass;
typedef struct _TrackerBusConnectionPrivate TrackerBusConnectionPrivate;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_BUS_TYPE_ARRAY_CURSOR (tracker_bus_array_cursor_get_type ())
#define TRACKER_BUS_ARRAY_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursor))
#define TRACKER_BUS_ARRAY_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursorClass))
#define TRACKER_BUS_IS_ARRAY_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR))
#define TRACKER_BUS_IS_ARRAY_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_ARRAY_CURSOR))
#define TRACKER_BUS_ARRAY_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursorClass))

typedef struct _TrackerBusArrayCursor TrackerBusArrayCursor;
typedef struct _TrackerBusArrayCursorClass TrackerBusArrayCursorClass;
typedef struct _TrackerBusConnectionQueryAsyncData TrackerBusConnectionQueryAsyncData;
typedef struct _TrackerBusConnectionUpdateAsyncData TrackerBusConnectionUpdateAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerBusConnectionUpdateBlankAsyncData TrackerBusConnectionUpdateBlankAsyncData;
typedef struct _TrackerBusConnectionLoadAsyncData TrackerBusConnectionLoadAsyncData;
typedef struct _TrackerBusConnectionStatisticsAsyncData TrackerBusConnectionStatisticsAsyncData;

struct _TrackerBusResourcesIface {
	GTypeInterface parent_iface;
	char** (*sparql_query) (TrackerBusResources* self, const char* query, int* result_length1, int* result_length2, GError** error);
	void (*sparql_query_async) (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*sparql_query_finish) (TrackerBusResources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update) (TrackerBusResources* self, const char* query, GError** error);
	void (*sparql_update_async) (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*sparql_update_finish) (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
	void (*load) (TrackerBusResources* self, const char* uri, GError** error);
	void (*load_async) (TrackerBusResources* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*load_finish) (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _TrackerBusResourcesDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _TrackerBusResourcesDBusProxySparqlQueryAsyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _TrackerBusResourcesDBusProxySparqlUpdateAsyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _TrackerBusResourcesDBusProxyLoadAsyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _TrackerBusStatisticsIface {
	GTypeInterface parent_iface;
	char** (*Get) (TrackerBusStatistics* self, int* result_length1, int* result_length2, GError** error);
	void (*Get_async) (TrackerBusStatistics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*Get_finish) (TrackerBusStatistics* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _TrackerBusStatisticsDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _TrackerBusStatisticsDBusProxyGet_asyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _TrackerBusConnection {
	TrackerSparqlConnection parent_instance;
	TrackerBusConnectionPrivate * priv;
};

struct _TrackerBusConnectionClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerBusConnectionQueryAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBusConnection* self;
	char* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	char** results;
	gint _tmp1_;
	gint _tmp2_;
	gint results_length1;
	gint results_length2;
	char** _tmp3_;
	char** _tmp4_;
	GError * e;
	GError * _inner_error_;
};

struct _TrackerBusConnectionUpdateAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBusConnection* self;
	char* sparql;
	gint priority;
	GCancellable* cancellable;
	GError * e;
	GError * _inner_error_;
};

struct _TrackerBusConnectionUpdateBlankAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBusConnection* self;
	char* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	GVariant* res;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GError * e;
	GError * _inner_error_;
};

struct _TrackerBusConnectionLoadAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBusConnection* self;
	GFile* file;
	GCancellable* cancellable;
	char* _tmp0_;
	GError * e;
	GError * _inner_error_;
};

struct _TrackerBusConnectionStatisticsAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBusConnection* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	char** results;
	gint _tmp0_;
	gint _tmp1_;
	gint results_length1;
	gint results_length2;
	char** _tmp2_;
	char** _tmp3_;
	GError * e;
	GError * _inner_error_;
};


static DBusGConnection* tracker_bus_connection_connection;
static DBusGConnection* tracker_bus_connection_connection = NULL;
static TrackerBusResources* tracker_bus_connection_resources_object;
static TrackerBusResources* tracker_bus_connection_resources_object = NULL;
static TrackerBusStatistics* tracker_bus_connection_statistics_object;
static TrackerBusStatistics* tracker_bus_connection_statistics_object = NULL;
static gboolean tracker_bus_connection_initialized;
static gboolean tracker_bus_connection_initialized = FALSE;
static gboolean tracker_bus_connection_use_steroids;
static gboolean tracker_bus_connection_use_steroids = FALSE;
static gpointer tracker_bus_connection_parent_class = NULL;

TrackerBusResources* tracker_bus_resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType tracker_bus_resources_get_type (void) G_GNUC_CONST;
char** tracker_bus_resources_sparql_query (TrackerBusResources* self, const char* query, int* result_length1, int* result_length2, GError** error);
void tracker_bus_resources_sparql_query_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** tracker_bus_resources_sparql_query_finish (TrackerBusResources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
void tracker_bus_resources_sparql_update (TrackerBusResources* self, const char* query, GError** error);
void tracker_bus_resources_sparql_update_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_bus_resources_sparql_update_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
void tracker_bus_resources_load (TrackerBusResources* self, const char* uri, GError** error);
void tracker_bus_resources_load_async (TrackerBusResources* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_bus_resources_load_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void tracker_bus_resources_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _tracker_bus_resources_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult tracker_bus_resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_tracker_bus_resources_introspect (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_property_get_all (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_sparql_query (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_sparql_query_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_tracker_bus_resources_sparql_query_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_tracker_bus_resources_sparql_update (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_sparql_update_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_tracker_bus_resources_sparql_update_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_tracker_bus_resources_load (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_load_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_tracker_bus_resources_load_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType tracker_bus_resources_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult tracker_bus_resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	TRACKER_BUS_RESOURCES_DBUS_PROXY_DUMMY_PROPERTY
};
static char** tracker_bus_resources_dbus_proxy_sparql_query (TrackerBusResources* self, const char* query, int* result_length1, int* result_length2, GError** error);
static void tracker_bus_resources_dbus_proxy_sparql_query_async_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_resources_dbus_proxy_sparql_query_async_ready (DBusPendingCall* pending, void* user_data);
static char** tracker_bus_resources_dbus_proxy_sparql_query_async_finish (TrackerBusResources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void tracker_bus_resources_dbus_proxy_sparql_update (TrackerBusResources* self, const char* query, GError** error);
static void tracker_bus_resources_dbus_proxy_sparql_update_async_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_resources_dbus_proxy_sparql_update_async_ready (DBusPendingCall* pending, void* user_data);
static void tracker_bus_resources_dbus_proxy_sparql_update_async_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
static void tracker_bus_resources_dbus_proxy_load (TrackerBusResources* self, const char* uri, GError** error);
static void tracker_bus_resources_dbus_proxy_load_async_async (TrackerBusResources* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_resources_dbus_proxy_load_async_ready (DBusPendingCall* pending, void* user_data);
static void tracker_bus_resources_dbus_proxy_load_async_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
static void tracker_bus_resources_dbus_proxy_tracker_bus_resources__interface_init (TrackerBusResourcesIface* iface);
static void tracker_bus_resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_bus_resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
TrackerBusStatistics* tracker_bus_statistics_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType tracker_bus_statistics_get_type (void) G_GNUC_CONST;
char** tracker_bus_statistics_Get (TrackerBusStatistics* self, int* result_length1, int* result_length2, GError** error);
void tracker_bus_statistics_Get_async (TrackerBusStatistics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** tracker_bus_statistics_Get_finish (TrackerBusStatistics* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
void tracker_bus_statistics_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _tracker_bus_statistics_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult tracker_bus_statistics_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_tracker_bus_statistics_introspect (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_statistics_property_get_all (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_statistics_Get (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_statistics_Get_async (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_tracker_bus_statistics_Get_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType tracker_bus_statistics_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult tracker_bus_statistics_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	TRACKER_BUS_STATISTICS_DBUS_PROXY_DUMMY_PROPERTY
};
static char** tracker_bus_statistics_dbus_proxy_Get (TrackerBusStatistics* self, int* result_length1, int* result_length2, GError** error);
static void tracker_bus_statistics_dbus_proxy_Get_async_async (TrackerBusStatistics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_statistics_dbus_proxy_Get_async_ready (DBusPendingCall* pending, void* user_data);
static char** tracker_bus_statistics_dbus_proxy_Get_async_finish (TrackerBusStatistics* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void tracker_bus_statistics_dbus_proxy_tracker_bus_statistics__interface_init (TrackerBusStatisticsIface* iface);
static void tracker_bus_statistics_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_bus_statistics_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
TrackerSparqlCursor* tracker_bus_fd_query (DBusGConnection* connection, const char* query, GCancellable* cancellable, GError** error);
GType tracker_bus_connection_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_BUS_CONNECTION_DUMMY_PROPERTY
};
TrackerBusConnection* tracker_bus_connection_new (void);
TrackerBusConnection* tracker_bus_connection_construct (GType object_type);
TrackerBusArrayCursor* tracker_bus_array_cursor_new (char** results, int results_length1, int results_length2, gint rows, gint cols);
TrackerBusArrayCursor* tracker_bus_array_cursor_construct (GType object_type, char** results, int results_length1, int results_length2, gint rows, gint cols);
GType tracker_bus_array_cursor_get_type (void) G_GNUC_CONST;
static TrackerSparqlCursor* tracker_bus_connection_real_query (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GError** error);
static void tracker_bus_connection_real_query_async_data_free (gpointer _data);
static void tracker_bus_connection_real_query_async (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_connection_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_bus_connection_real_query_async_co (TrackerBusConnectionQueryAsyncData* data);
static void tracker_bus_connection_real_update (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_bus_connection_real_update_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_connection_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_async_co (TrackerBusConnectionUpdateAsyncData* data);
static GVariant* tracker_bus_connection_real_update_blank (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_bus_connection_real_update_blank_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_blank_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_connection_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_blank_async_co (TrackerBusConnectionUpdateBlankAsyncData* data);
static void tracker_bus_connection_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_bus_connection_real_load_async_data_free (gpointer _data);
static void tracker_bus_connection_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_connection_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_bus_connection_real_load_async_co (TrackerBusConnectionLoadAsyncData* data);
static TrackerSparqlCursor* tracker_bus_connection_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error);
static void tracker_bus_connection_real_statistics_async_data_free (gpointer _data);
static void tracker_bus_connection_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_connection_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_bus_connection_real_statistics_async_co (TrackerBusConnectionStatisticsAsyncData* data);
static void tracker_bus_connection_finalize (GObject* obj);
TrackerSparqlConnection* module_init (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _tracker_bus_resources_dbus_path_vtable = {_tracker_bus_resources_dbus_unregister, tracker_bus_resources_dbus_message};
static const _DBusObjectVTable _tracker_bus_resources_dbus_vtable = {tracker_bus_resources_dbus_register_object};
static const DBusObjectPathVTable _tracker_bus_statistics_dbus_path_vtable = {_tracker_bus_statistics_dbus_unregister, tracker_bus_statistics_dbus_message};
static const _DBusObjectVTable _tracker_bus_statistics_dbus_vtable = {tracker_bus_statistics_dbus_register_object};


char** tracker_bus_resources_sparql_query (TrackerBusResources* self, const char* query, int* result_length1, int* result_length2, GError** error) {
	return TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_query (self, query, result_length1, result_length2, error);
}


void tracker_bus_resources_sparql_query_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_query_async (self, query, _callback_, _user_data_);
}


char** tracker_bus_resources_sparql_query_finish (TrackerBusResources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	return TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_query_finish (self, _res_, result_length1, result_length2, error);
}


void tracker_bus_resources_sparql_update (TrackerBusResources* self, const char* query, GError** error) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_update (self, query, error);
}


void tracker_bus_resources_sparql_update_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_update_async (self, query, _callback_, _user_data_);
}


void tracker_bus_resources_sparql_update_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_update_finish (self, _res_, error);
}


void tracker_bus_resources_load (TrackerBusResources* self, const char* uri, GError** error) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->load (self, uri, error);
}


void tracker_bus_resources_load_async (TrackerBusResources* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->load_async (self, uri, _callback_, _user_data_);
}


void tracker_bus_resources_load_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->load_finish (self, _res_, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _tracker_bus_resources_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_tracker_bus_resources_introspect (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Resources\">\n  <method name=\"SparqlQuery\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n  <method name=\"SparqlQuery\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n  <method name=\"SparqlUpdate\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"SparqlUpdate\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"Load\">\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"Load\">\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_property_get_all (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Resources") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_sparql_query (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* query = NULL;
	const char* _tmp1_;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp2_;
	DBusMessageIter _tmp3_;
	int _tmp4_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp1_);
	result_length1 = 0;
	result_length2 = 0;
	result = tracker_bus_resources_sparql_query (self, query, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (query);
	_tmp2_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp3_);
	for (_tmp4_ = 0; _tmp4_ < result_length1; _tmp4_++) {
		DBusMessageIter _tmp5_;
		int _tmp6_;
		dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_ARRAY, "s", &_tmp5_);
		for (_tmp6_ = 0; _tmp6_ < result_length2; _tmp6_++) {
			const char* _tmp7_;
			_tmp7_ = *_tmp2_;
			dbus_message_iter_append_basic (&_tmp5_, DBUS_TYPE_STRING, &_tmp7_);
			_tmp2_++;
		}
		dbus_message_iter_close_container (&_tmp3_, &_tmp5_);
	}
	dbus_message_iter_close_container (&iter, &_tmp3_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_sparql_query_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* query = NULL;
	const char* _tmp8_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp8_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp8_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	tracker_bus_resources_sparql_query_async (self, query, (GAsyncReadyCallback) _dbus_tracker_bus_resources_sparql_query_async_ready, _user_data_);
	_g_free0 (query);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_tracker_bus_resources_sparql_query_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp9_;
	DBusMessageIter _tmp10_;
	int _tmp11_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = tracker_bus_resources_sparql_query_finish ((TrackerBusResources*) source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp9_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp10_);
	for (_tmp11_ = 0; _tmp11_ < result_length1; _tmp11_++) {
		DBusMessageIter _tmp12_;
		int _tmp13_;
		dbus_message_iter_open_container (&_tmp10_, DBUS_TYPE_ARRAY, "s", &_tmp12_);
		for (_tmp13_ = 0; _tmp13_ < result_length2; _tmp13_++) {
			const char* _tmp14_;
			_tmp14_ = *_tmp9_;
			dbus_message_iter_append_basic (&_tmp12_, DBUS_TYPE_STRING, &_tmp14_);
			_tmp9_++;
		}
		dbus_message_iter_close_container (&_tmp10_, &_tmp12_);
	}
	dbus_message_iter_close_container (&iter, &_tmp10_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_tracker_bus_resources_sparql_update (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* query = NULL;
	const char* _tmp15_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp15_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp15_);
	tracker_bus_resources_sparql_update (self, query, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (query);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_sparql_update_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* query = NULL;
	const char* _tmp16_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp16_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp16_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	tracker_bus_resources_sparql_update_async (self, query, (GAsyncReadyCallback) _dbus_tracker_bus_resources_sparql_update_async_ready, _user_data_);
	_g_free0 (query);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_tracker_bus_resources_sparql_update_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	tracker_bus_resources_sparql_update_finish ((TrackerBusResources*) source_object, _res_, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_tracker_bus_resources_load (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* uri = NULL;
	const char* _tmp17_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp17_);
	dbus_message_iter_next (&iter);
	uri = g_strdup (_tmp17_);
	tracker_bus_resources_load (self, uri, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (uri);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_load_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* uri = NULL;
	const char* _tmp18_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp18_);
	dbus_message_iter_next (&iter);
	uri = g_strdup (_tmp18_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	tracker_bus_resources_load_async (self, uri, (GAsyncReadyCallback) _dbus_tracker_bus_resources_load_async_ready, _user_data_);
	_g_free0 (uri);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_tracker_bus_resources_load_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	tracker_bus_resources_load_finish ((TrackerBusResources*) source_object, _res_, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult tracker_bus_resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_tracker_bus_resources_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_tracker_bus_resources_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlQuery")) {
		result = _dbus_tracker_bus_resources_sparql_query (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlQuery")) {
		result = _dbus_tracker_bus_resources_sparql_query_async (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlUpdate")) {
		result = _dbus_tracker_bus_resources_sparql_update (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlUpdate")) {
		result = _dbus_tracker_bus_resources_sparql_update_async (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "Load")) {
		result = _dbus_tracker_bus_resources_load (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "Load")) {
		result = _dbus_tracker_bus_resources_load_async (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void tracker_bus_resources_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_tracker_bus_resources_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void tracker_bus_resources_base_init (TrackerBusResourcesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TRACKER_BUS_TYPE_RESOURCES, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_tracker_bus_resources_dbus_vtable));
	}
}


GType tracker_bus_resources_get_type (void) {
	static volatile gsize tracker_bus_resources_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_bus_resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBusResourcesIface), (GBaseInitFunc) tracker_bus_resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType tracker_bus_resources_type_id;
		tracker_bus_resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "TrackerBusResources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (tracker_bus_resources_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (tracker_bus_resources_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &tracker_bus_resources_dbus_proxy_get_type);
		g_once_init_leave (&tracker_bus_resources_type_id__volatile, tracker_bus_resources_type_id);
	}
	return tracker_bus_resources_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (TrackerBusResourcesDBusProxy, tracker_bus_resources_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TRACKER_BUS_TYPE_RESOURCES, tracker_bus_resources_dbus_proxy_tracker_bus_resources__interface_init) );
TrackerBusResources* tracker_bus_resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	TrackerBusResources* self;
	self = g_object_new (tracker_bus_resources_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Resources", NULL);
	return self;
}


static GObject* tracker_bus_resources_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (tracker_bus_resources_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), tracker_bus_resources_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult tracker_bus_resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void tracker_bus_resources_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((TrackerBusResourcesDBusProxy*) self)->disposed) {
		return;
	}
	((TrackerBusResourcesDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), tracker_bus_resources_dbus_proxy_filter, self);
	G_OBJECT_CLASS (tracker_bus_resources_dbus_proxy_parent_class)->dispose (self);
}


static void tracker_bus_resources_dbus_proxy_class_init (TrackerBusResourcesDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = tracker_bus_resources_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = tracker_bus_resources_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = tracker_bus_resources_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_bus_resources_dbus_proxy_set_property;
}


static void tracker_bus_resources_dbus_proxy_init (TrackerBusResourcesDBusProxy* self) {
}


static char** tracker_bus_resources_dbus_proxy_sparql_query (TrackerBusResources* self, const char* query, int* result_length1, int* result_length2, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp19_;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp20_;
	int _tmp20__length;
	int _tmp20__size;
	int _tmp20__length1;
	DBusMessageIter _tmp21_;
	if (((TrackerBusResourcesDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp19_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp19_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp24_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp24_ = _dbus_error.name + 64;
			if (strcmp (_tmp24_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp24_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp24_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp24_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp24_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp24_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp24_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp24_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp25_;
			_edomain = DBUS_GERROR;
			_tmp25_ = _dbus_error.name + 27;
			if (strcmp (_tmp25_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp25_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp25_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp25_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp25_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp25_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp25_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp25_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp25_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp25_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp25_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp25_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp25_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp25_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp25_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp25_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp25_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp25_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp25_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp25_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp25_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp25_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp25_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp25_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp25_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp25_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp25_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp25_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp25_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp25_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp25_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp25_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp25_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp20_ = g_new (char*, 5);
	_tmp20__length = 0;
	_tmp20__size = 4;
	_tmp20__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp21_);
	for (; dbus_message_iter_get_arg_type (&_tmp21_); _tmp20__length1++) {
		int _tmp20__length2;
		DBusMessageIter _tmp22_;
		_tmp20__length2 = 0;
		dbus_message_iter_recurse (&_tmp21_, &_tmp22_);
		for (; dbus_message_iter_get_arg_type (&_tmp22_); _tmp20__length2++) {
			const char* _tmp23_;
			if (_tmp20__size == _tmp20__length) {
				_tmp20__size = 2 * _tmp20__size;
				_tmp20_ = g_renew (char*, _tmp20_, _tmp20__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp22_, &_tmp23_);
			dbus_message_iter_next (&_tmp22_);
			_tmp20_[_tmp20__length++] = g_strdup (_tmp23_);
		}
		_result_length2 = _tmp20__length2;
		dbus_message_iter_next (&_tmp21_);
	}
	_result_length1 = _tmp20__length1;
	_tmp20_[_tmp20__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp20_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void tracker_bus_resources_dbus_proxy_sparql_query_async_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp26_;
	TrackerBusResourcesDBusProxySparqlQueryAsyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp26_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp26_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (TrackerBusResourcesDBusProxySparqlQueryAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, tracker_bus_resources_dbus_proxy_sparql_query_async_ready, _data_, NULL);
}


static void tracker_bus_resources_dbus_proxy_sparql_query_async_ready (DBusPendingCall* pending, void* user_data) {
	TrackerBusResourcesDBusProxySparqlQueryAsyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (TrackerBusResourcesDBusProxySparqlQueryAsyncData, _data_);
	dbus_pending_call_unref (pending);
}


static char** tracker_bus_resources_dbus_proxy_sparql_query_async_finish (TrackerBusResources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	TrackerBusResourcesDBusProxySparqlQueryAsyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp34_;
	int _tmp34__length;
	int _tmp34__size;
	int _tmp34__length1;
	DBusMessageIter _tmp35_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp31_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp31_ = _dbus_error.name + 64;
			if (strcmp (_tmp31_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp31_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp31_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp31_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp31_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp31_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp31_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp31_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp32_;
			_edomain = DBUS_GERROR;
			_tmp32_ = _dbus_error.name + 27;
			if (strcmp (_tmp32_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp32_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp32_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp32_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp32_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp32_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp32_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp32_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp32_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp32_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp32_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp32_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp32_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp32_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp32_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp32_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp32_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp32_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp32_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp32_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp32_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp32_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp32_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp32_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp32_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp32_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp32_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp32_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp32_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp32_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp32_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp32_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp32_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp34_ = g_new (char*, 5);
	_tmp34__length = 0;
	_tmp34__size = 4;
	_tmp34__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp35_);
	for (; dbus_message_iter_get_arg_type (&_tmp35_); _tmp34__length1++) {
		int _tmp34__length2;
		DBusMessageIter _tmp36_;
		_tmp34__length2 = 0;
		dbus_message_iter_recurse (&_tmp35_, &_tmp36_);
		for (; dbus_message_iter_get_arg_type (&_tmp36_); _tmp34__length2++) {
			const char* _tmp37_;
			if (_tmp34__size == _tmp34__length) {
				_tmp34__size = 2 * _tmp34__size;
				_tmp34_ = g_renew (char*, _tmp34_, _tmp34__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp36_, &_tmp37_);
			dbus_message_iter_next (&_tmp36_);
			_tmp34_[_tmp34__length++] = g_strdup (_tmp37_);
		}
		_result_length2 = _tmp34__length2;
		dbus_message_iter_next (&_tmp35_);
	}
	_result_length1 = _tmp34__length1;
	_tmp34_[_tmp34__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp34_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void tracker_bus_resources_dbus_proxy_sparql_update (TrackerBusResources* self, const char* query, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp38_;
	if (((TrackerBusResourcesDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlUpdate");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp38_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp38_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp39_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp39_ = _dbus_error.name + 64;
			if (strcmp (_tmp39_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp39_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp39_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp39_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp39_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp39_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp39_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp39_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp40_;
			_edomain = DBUS_GERROR;
			_tmp40_ = _dbus_error.name + 27;
			if (strcmp (_tmp40_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp40_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp40_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp40_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp40_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp40_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp40_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp40_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp40_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp40_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp40_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp40_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp40_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp40_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp40_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp40_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp40_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp40_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp40_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp40_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp40_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp40_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp40_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp40_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp40_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp40_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp40_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp40_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp40_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp40_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp40_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp40_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp40_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_bus_resources_dbus_proxy_sparql_update_async_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp41_;
	TrackerBusResourcesDBusProxySparqlUpdateAsyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlUpdate");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp41_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp41_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (TrackerBusResourcesDBusProxySparqlUpdateAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, tracker_bus_resources_dbus_proxy_sparql_update_async_ready, _data_, NULL);
}


static void tracker_bus_resources_dbus_proxy_sparql_update_async_ready (DBusPendingCall* pending, void* user_data) {
	TrackerBusResourcesDBusProxySparqlUpdateAsyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (TrackerBusResourcesDBusProxySparqlUpdateAsyncData, _data_);
	dbus_pending_call_unref (pending);
}


static void tracker_bus_resources_dbus_proxy_sparql_update_async_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error) {
	TrackerBusResourcesDBusProxySparqlUpdateAsyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp42_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp42_ = _dbus_error.name + 64;
			if (strcmp (_tmp42_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp42_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp42_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp42_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp42_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp42_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp42_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp42_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp43_;
			_edomain = DBUS_GERROR;
			_tmp43_ = _dbus_error.name + 27;
			if (strcmp (_tmp43_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp43_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp43_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp43_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp43_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp43_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp43_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp43_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp43_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp43_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp43_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp43_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp43_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp43_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp43_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp43_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp43_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp43_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp43_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp43_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp43_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp43_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp43_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp43_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp43_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp43_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp43_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp43_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp43_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp43_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp43_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp43_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp43_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_bus_resources_dbus_proxy_load (TrackerBusResources* self, const char* uri, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp45_;
	if (((TrackerBusResourcesDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "Load");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp45_ = uri;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp45_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp46_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp46_ = _dbus_error.name + 64;
			if (strcmp (_tmp46_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp46_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp46_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp46_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp46_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp46_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp46_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp46_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp47_;
			_edomain = DBUS_GERROR;
			_tmp47_ = _dbus_error.name + 27;
			if (strcmp (_tmp47_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp47_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp47_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp47_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp47_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp47_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp47_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp47_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp47_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp47_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp47_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp47_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp47_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp47_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp47_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp47_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp47_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp47_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp47_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp47_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp47_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp47_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp47_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp47_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp47_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp47_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp47_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp47_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp47_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp47_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp47_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp47_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp47_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_bus_resources_dbus_proxy_load_async_async (TrackerBusResources* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp48_;
	TrackerBusResourcesDBusProxyLoadAsyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "Load");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp48_ = uri;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp48_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (TrackerBusResourcesDBusProxyLoadAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, tracker_bus_resources_dbus_proxy_load_async_ready, _data_, NULL);
}


static void tracker_bus_resources_dbus_proxy_load_async_ready (DBusPendingCall* pending, void* user_data) {
	TrackerBusResourcesDBusProxyLoadAsyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (TrackerBusResourcesDBusProxyLoadAsyncData, _data_);
	dbus_pending_call_unref (pending);
}


static void tracker_bus_resources_dbus_proxy_load_async_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error) {
	TrackerBusResourcesDBusProxyLoadAsyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp49_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp49_ = _dbus_error.name + 64;
			if (strcmp (_tmp49_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp49_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp49_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp49_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp49_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp49_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp49_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp49_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp50_;
			_edomain = DBUS_GERROR;
			_tmp50_ = _dbus_error.name + 27;
			if (strcmp (_tmp50_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp50_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp50_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp50_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp50_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp50_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp50_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp50_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp50_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp50_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp50_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp50_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp50_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp50_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp50_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp50_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp50_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp50_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp50_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp50_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp50_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp50_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp50_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp50_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp50_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp50_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp50_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp50_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp50_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp50_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp50_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp50_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp50_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_bus_resources_dbus_proxy_tracker_bus_resources__interface_init (TrackerBusResourcesIface* iface) {
	iface->sparql_query = tracker_bus_resources_dbus_proxy_sparql_query;
	iface->sparql_query_async = tracker_bus_resources_dbus_proxy_sparql_query_async_async;
	iface->sparql_query_finish = tracker_bus_resources_dbus_proxy_sparql_query_async_finish;
	iface->sparql_update = tracker_bus_resources_dbus_proxy_sparql_update;
	iface->sparql_update_async = tracker_bus_resources_dbus_proxy_sparql_update_async_async;
	iface->sparql_update_finish = tracker_bus_resources_dbus_proxy_sparql_update_async_finish;
	iface->load = tracker_bus_resources_dbus_proxy_load;
	iface->load_async = tracker_bus_resources_dbus_proxy_load_async_async;
	iface->load_finish = tracker_bus_resources_dbus_proxy_load_async_finish;
}


static void tracker_bus_resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void tracker_bus_resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


char** tracker_bus_statistics_Get (TrackerBusStatistics* self, int* result_length1, int* result_length2, GError** error) {
	return TRACKER_BUS_STATISTICS_GET_INTERFACE (self)->Get (self, result_length1, result_length2, error);
}


void tracker_bus_statistics_Get_async (TrackerBusStatistics* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BUS_STATISTICS_GET_INTERFACE (self)->Get_async (self, _callback_, _user_data_);
}


char** tracker_bus_statistics_Get_finish (TrackerBusStatistics* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	return TRACKER_BUS_STATISTICS_GET_INTERFACE (self)->Get_finish (self, _res_, result_length1, result_length2, error);
}


void _tracker_bus_statistics_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_tracker_bus_statistics_introspect (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Statistics\">\n  <method name=\"Get\">\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n  <method name=\"Get_async\">\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_statistics_property_get_all (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp52_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp52_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp52_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Statistics") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_statistics_Get (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp53_;
	DBusMessageIter _tmp54_;
	int _tmp55_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result_length2 = 0;
	result = tracker_bus_statistics_Get (self, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp53_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp54_);
	for (_tmp55_ = 0; _tmp55_ < result_length1; _tmp55_++) {
		DBusMessageIter _tmp56_;
		int _tmp57_;
		dbus_message_iter_open_container (&_tmp54_, DBUS_TYPE_ARRAY, "s", &_tmp56_);
		for (_tmp57_ = 0; _tmp57_ < result_length2; _tmp57_++) {
			const char* _tmp58_;
			_tmp58_ = *_tmp53_;
			dbus_message_iter_append_basic (&_tmp56_, DBUS_TYPE_STRING, &_tmp58_);
			_tmp53_++;
		}
		dbus_message_iter_close_container (&_tmp54_, &_tmp56_);
	}
	dbus_message_iter_close_container (&iter, &_tmp54_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_statistics_Get_async (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	tracker_bus_statistics_Get_async (self, (GAsyncReadyCallback) _dbus_tracker_bus_statistics_Get_async_ready, _user_data_);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_tracker_bus_statistics_Get_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp59_;
	DBusMessageIter _tmp60_;
	int _tmp61_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = tracker_bus_statistics_Get_finish ((TrackerBusStatistics*) source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp59_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp60_);
	for (_tmp61_ = 0; _tmp61_ < result_length1; _tmp61_++) {
		DBusMessageIter _tmp62_;
		int _tmp63_;
		dbus_message_iter_open_container (&_tmp60_, DBUS_TYPE_ARRAY, "s", &_tmp62_);
		for (_tmp63_ = 0; _tmp63_ < result_length2; _tmp63_++) {
			const char* _tmp64_;
			_tmp64_ = *_tmp59_;
			dbus_message_iter_append_basic (&_tmp62_, DBUS_TYPE_STRING, &_tmp64_);
			_tmp59_++;
		}
		dbus_message_iter_close_container (&_tmp60_, &_tmp62_);
	}
	dbus_message_iter_close_container (&iter, &_tmp60_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult tracker_bus_statistics_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_tracker_bus_statistics_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_tracker_bus_statistics_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Statistics", "Get")) {
		result = _dbus_tracker_bus_statistics_Get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Statistics", "Get_async")) {
		result = _dbus_tracker_bus_statistics_Get_async (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void tracker_bus_statistics_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_tracker_bus_statistics_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void tracker_bus_statistics_base_init (TrackerBusStatisticsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TRACKER_BUS_TYPE_STATISTICS, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_tracker_bus_statistics_dbus_vtable));
	}
}


GType tracker_bus_statistics_get_type (void) {
	static volatile gsize tracker_bus_statistics_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_bus_statistics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBusStatisticsIface), (GBaseInitFunc) tracker_bus_statistics_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType tracker_bus_statistics_type_id;
		tracker_bus_statistics_type_id = g_type_register_static (G_TYPE_INTERFACE, "TrackerBusStatistics", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (tracker_bus_statistics_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (tracker_bus_statistics_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &tracker_bus_statistics_dbus_proxy_get_type);
		g_once_init_leave (&tracker_bus_statistics_type_id__volatile, tracker_bus_statistics_type_id);
	}
	return tracker_bus_statistics_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (TrackerBusStatisticsDBusProxy, tracker_bus_statistics_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TRACKER_BUS_TYPE_STATISTICS, tracker_bus_statistics_dbus_proxy_tracker_bus_statistics__interface_init) );
TrackerBusStatistics* tracker_bus_statistics_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	TrackerBusStatistics* self;
	self = g_object_new (tracker_bus_statistics_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Statistics", NULL);
	return self;
}


static GObject* tracker_bus_statistics_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (tracker_bus_statistics_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), tracker_bus_statistics_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult tracker_bus_statistics_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void tracker_bus_statistics_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((TrackerBusStatisticsDBusProxy*) self)->disposed) {
		return;
	}
	((TrackerBusStatisticsDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), tracker_bus_statistics_dbus_proxy_filter, self);
	G_OBJECT_CLASS (tracker_bus_statistics_dbus_proxy_parent_class)->dispose (self);
}


static void tracker_bus_statistics_dbus_proxy_class_init (TrackerBusStatisticsDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = tracker_bus_statistics_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = tracker_bus_statistics_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = tracker_bus_statistics_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_bus_statistics_dbus_proxy_set_property;
}


static void tracker_bus_statistics_dbus_proxy_init (TrackerBusStatisticsDBusProxy* self) {
}


static char** tracker_bus_statistics_dbus_proxy_Get (TrackerBusStatistics* self, int* result_length1, int* result_length2, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp65_;
	int _tmp65__length;
	int _tmp65__size;
	int _tmp65__length1;
	DBusMessageIter _tmp66_;
	if (((TrackerBusStatisticsDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Statistics", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp69_;
			_edomain = DBUS_GERROR;
			_tmp69_ = _dbus_error.name + 27;
			if (strcmp (_tmp69_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp69_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp69_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp69_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp69_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp69_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp69_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp69_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp69_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp69_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp69_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp69_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp69_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp69_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp69_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp69_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp69_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp69_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp69_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp69_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp69_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp69_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp69_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp69_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp69_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp69_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp69_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp69_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp69_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp69_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp69_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp69_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp69_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp65_ = g_new (char*, 5);
	_tmp65__length = 0;
	_tmp65__size = 4;
	_tmp65__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp66_);
	for (; dbus_message_iter_get_arg_type (&_tmp66_); _tmp65__length1++) {
		int _tmp65__length2;
		DBusMessageIter _tmp67_;
		_tmp65__length2 = 0;
		dbus_message_iter_recurse (&_tmp66_, &_tmp67_);
		for (; dbus_message_iter_get_arg_type (&_tmp67_); _tmp65__length2++) {
			const char* _tmp68_;
			if (_tmp65__size == _tmp65__length) {
				_tmp65__size = 2 * _tmp65__size;
				_tmp65_ = g_renew (char*, _tmp65_, _tmp65__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp67_, &_tmp68_);
			dbus_message_iter_next (&_tmp67_);
			_tmp65_[_tmp65__length++] = g_strdup (_tmp68_);
		}
		_result_length2 = _tmp65__length2;
		dbus_message_iter_next (&_tmp66_);
	}
	_result_length1 = _tmp65__length1;
	_tmp65_[_tmp65__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp65_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void tracker_bus_statistics_dbus_proxy_Get_async_async (TrackerBusStatistics* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	TrackerBusStatisticsDBusProxyGet_asyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Statistics", "Get_async");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (TrackerBusStatisticsDBusProxyGet_asyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, tracker_bus_statistics_dbus_proxy_Get_async_ready, _data_, NULL);
}


static void tracker_bus_statistics_dbus_proxy_Get_async_ready (DBusPendingCall* pending, void* user_data) {
	TrackerBusStatisticsDBusProxyGet_asyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (TrackerBusStatisticsDBusProxyGet_asyncData, _data_);
	dbus_pending_call_unref (pending);
}


static char** tracker_bus_statistics_dbus_proxy_Get_async_finish (TrackerBusStatistics* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	TrackerBusStatisticsDBusProxyGet_asyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp75_;
	int _tmp75__length;
	int _tmp75__size;
	int _tmp75__length1;
	DBusMessageIter _tmp76_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp74_;
			_edomain = DBUS_GERROR;
			_tmp74_ = _dbus_error.name + 27;
			if (strcmp (_tmp74_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp74_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp74_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp74_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp74_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp74_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp74_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp74_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp74_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp74_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp74_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp74_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp74_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp74_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp74_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp74_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp74_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp74_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp74_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp74_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp74_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp74_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp74_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp74_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp74_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp74_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp74_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp74_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp74_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp74_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp74_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp74_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp74_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp75_ = g_new (char*, 5);
	_tmp75__length = 0;
	_tmp75__size = 4;
	_tmp75__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp76_);
	for (; dbus_message_iter_get_arg_type (&_tmp76_); _tmp75__length1++) {
		int _tmp75__length2;
		DBusMessageIter _tmp77_;
		_tmp75__length2 = 0;
		dbus_message_iter_recurse (&_tmp76_, &_tmp77_);
		for (; dbus_message_iter_get_arg_type (&_tmp77_); _tmp75__length2++) {
			const char* _tmp78_;
			if (_tmp75__size == _tmp75__length) {
				_tmp75__size = 2 * _tmp75__size;
				_tmp75_ = g_renew (char*, _tmp75_, _tmp75__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp77_, &_tmp78_);
			dbus_message_iter_next (&_tmp77_);
			_tmp75_[_tmp75__length++] = g_strdup (_tmp78_);
		}
		_result_length2 = _tmp75__length2;
		dbus_message_iter_next (&_tmp76_);
	}
	_result_length1 = _tmp75__length1;
	_tmp75_[_tmp75__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp75_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void tracker_bus_statistics_dbus_proxy_tracker_bus_statistics__interface_init (TrackerBusStatisticsIface* iface) {
	iface->Get = tracker_bus_statistics_dbus_proxy_Get;
	iface->Get_async = tracker_bus_statistics_dbus_proxy_Get_async_async;
	iface->Get_finish = tracker_bus_statistics_dbus_proxy_Get_async_finish;
}


static void tracker_bus_statistics_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void tracker_bus_statistics_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


TrackerBusConnection* tracker_bus_connection_construct (GType object_type) {
	GError * _inner_error_;
	TrackerBusConnection * self;
	_inner_error_ = NULL;
	g_return_val_if_fail (!tracker_bus_connection_initialized, NULL);
	self = (TrackerBusConnection*) tracker_sparql_connection_construct (object_type);
	tracker_bus_connection_initialized = TRUE;
	{
		const char* _tmp1_;
		DBusGConnection* _tmp2_;
		DBusGConnection* _tmp3_;
		TrackerBusResources* _tmp4_;
		TrackerBusStatistics* _tmp5_;
		if (g_strcmp0 (HAVE_DBUS_FD_PASSING_IN_VALA, "1") == 0) {
			char* env_backend;
			gboolean _tmp0_ = FALSE;
			env_backend = g_strdup (g_getenv ("TRACKER_BUS_BACKEND"));
			if (env_backend == NULL) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = g_ascii_strcasecmp (env_backend, "dbus-glib") != 0;
			}
			if (_tmp0_) {
				tracker_bus_connection_use_steroids = TRUE;
			}
			_g_free0 (env_backend);
		}
		_tmp1_ = NULL;
		if (tracker_bus_connection_use_steroids) {
			_tmp1_ = "yes";
		} else {
			_tmp1_ = "no";
		}
		g_debug ("tracker-bus.vala:65: Using steroids = %s", _tmp1_);
		_tmp2_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		tracker_bus_connection_connection = (_tmp3_ = _tmp2_, _dbus_g_connection_unref0 (tracker_bus_connection_connection), _tmp3_);
		tracker_bus_connection_resources_object = (_tmp4_ = tracker_bus_resources_dbus_proxy_new (tracker_bus_connection_connection, TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_RESOURCES), _g_object_unref0 (tracker_bus_connection_resources_object), _tmp4_);
		tracker_bus_connection_statistics_object = (_tmp5_ = tracker_bus_statistics_dbus_proxy_new (tracker_bus_connection_connection, TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_STATISTICS), _g_object_unref0 (tracker_bus_connection_statistics_object), _tmp5_);
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("tracker-bus.vala:77: Could not connect to D-Bus service:'%s': %s", TRACKER_DBUS_INTERFACE_RESOURCES, e->message);
			tracker_bus_connection_initialized = FALSE;
			_g_error_free0 (e);
			return self;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	tracker_bus_connection_initialized = TRUE;
	return self;
}


TrackerBusConnection* tracker_bus_connection_new (void) {
	return tracker_bus_connection_construct (TRACKER_BUS_TYPE_CONNECTION);
}


static TrackerSparqlCursor* tracker_bus_connection_real_query (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GError** error) {
	TrackerBusConnection * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_;
	self = (TrackerBusConnection*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	_inner_error_ = NULL;
	{
		if (tracker_bus_connection_use_steroids) {
			TrackerSparqlCursor* _tmp0_;
			_tmp0_ = tracker_bus_fd_query (tracker_bus_connection_connection, sparql, cancellable, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch1_dbus_gerror;
				}
				goto __finally1;
			}
			result = _tmp0_;
			return result;
		} else {
			gint results_length1;
			gint results_length2;
			char** _tmp3_;
			gint _tmp1_;
			gint _tmp2_;
			char** results;
			char** _tmp4_;
			results = (_tmp3_ = tracker_bus_resources_sparql_query (tracker_bus_connection_resources_object, sparql, &_tmp1_, &_tmp2_, &_inner_error_), results_length1 = _tmp1_, results_length2 = _tmp2_, _tmp3_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch1_dbus_gerror;
				}
				goto __finally1;
			}
			result = (TrackerSparqlCursor*) tracker_bus_array_cursor_new ((_tmp4_ = results, results = NULL, _tmp4_), results_length1, results_length2, results_length1, results_length2);
			results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
			return result;
			results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		}
	}
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally1;
			}
			_g_error_free0 (e);
		}
	}
	__finally1:
	{
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static void tracker_bus_connection_real_query_async_data_free (gpointer _data) {
	TrackerBusConnectionQueryAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerBusConnectionQueryAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_bus_connection_real_query_async (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBusConnection * self;
	TrackerBusConnectionQueryAsyncData* _data_;
	self = (TrackerBusConnection*) base;
	_data_ = g_slice_new0 (TrackerBusConnectionQueryAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_bus_connection_real_query_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_bus_connection_real_query_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_bus_connection_real_query_async_co (_data_);
}


static TrackerSparqlCursor* tracker_bus_connection_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerBusConnectionQueryAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_bus_connection_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBusConnectionQueryAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_bus_connection_real_query_async_co (data);
}


static gboolean tracker_bus_connection_real_query_async_co (TrackerBusConnectionQueryAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			if (tracker_bus_connection_use_steroids) {
				data->_state_ = 1;
				tracker_bus_fd_query_async (tracker_bus_connection_connection, data->sparql, data->cancellable, tracker_bus_connection_query_async_ready, data);
				return FALSE;
				_state_1:
				data->_tmp0_ = tracker_bus_fd_query_finish (data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch2_dbus_gerror;
					}
					goto __finally2;
				}
				data->result = data->_tmp0_;
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				data->_state_ = 2;
				tracker_bus_resources_sparql_query_async (tracker_bus_connection_resources_object, data->sparql, tracker_bus_connection_query_async_ready, data);
				return FALSE;
				_state_2:
				data->results = (data->_tmp3_ = tracker_bus_resources_sparql_query_finish (tracker_bus_connection_resources_object, data->_res_, &data->_tmp1_, &data->_tmp2_, &data->_inner_error_), data->results_length1 = data->_tmp1_, data->results_length2 = data->_tmp2_, data->_tmp3_);
				if (data->_inner_error_ != NULL) {
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch2_dbus_gerror;
					}
					goto __finally2;
				}
				data->result = (TrackerSparqlCursor*) tracker_bus_array_cursor_new ((data->_tmp4_ = data->results, data->results = NULL, data->_tmp4_), data->results_length1, data->results_length2, data->results_length1, data->results_length2);
				data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
			}
		}
		goto __finally2;
		__catch2_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
				{
					_g_error_free0 (data->e);
					goto __finally2;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally2:
		{
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tracker_bus_connection_real_update (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerBusConnection * self;
	GError * _inner_error_;
	self = (TrackerBusConnection*) base;
	g_return_if_fail (sparql != NULL);
	_inner_error_ = NULL;
	{
		if (tracker_bus_connection_use_steroids) {
			tracker_bus_fd_sparql_update (tracker_bus_connection_connection, sparql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch3_dbus_gerror;
				}
				goto __finally3;
			}
		} else {
			tracker_bus_resources_sparql_update (tracker_bus_connection_resources_object, sparql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch3_dbus_gerror;
				}
				goto __finally3;
			}
		}
	}
	goto __finally3;
	__catch3_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally3;
			}
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_bus_connection_real_update_async_data_free (gpointer _data) {
	TrackerBusConnectionUpdateAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (TrackerBusConnectionUpdateAsyncData, data);
}


static void tracker_bus_connection_real_update_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateAsyncData* _data_;
	self = (TrackerBusConnection*) base;
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_bus_connection_real_update_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_bus_connection_real_update_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_bus_connection_real_update_async_co (_data_);
}


static void tracker_bus_connection_real_update_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerBusConnectionUpdateAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_bus_connection_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBusConnectionUpdateAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_bus_connection_real_update_async_co (data);
}


static gboolean tracker_bus_connection_real_update_async_co (TrackerBusConnectionUpdateAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			if (tracker_bus_connection_use_steroids) {
				data->_state_ = 3;
				tracker_bus_fd_sparql_update_async (tracker_bus_connection_connection, data->sparql, data->cancellable, tracker_bus_connection_update_async_ready, data);
				return FALSE;
				_state_3:
				tracker_bus_fd_sparql_update_finish (data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch4_dbus_gerror;
					}
					goto __finally4;
				}
			} else {
				data->_state_ = 4;
				tracker_bus_resources_sparql_update_async (tracker_bus_connection_resources_object, data->sparql, tracker_bus_connection_update_async_ready, data);
				return FALSE;
				_state_4:
				tracker_bus_resources_sparql_update_finish (tracker_bus_connection_resources_object, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch4_dbus_gerror;
					}
					goto __finally4;
				}
			}
		}
		goto __finally4;
		__catch4_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
				{
					_g_error_free0 (data->e);
					goto __finally4;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally4:
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static GVariant* tracker_bus_connection_real_update_blank (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerBusConnection * self;
	GVariant* result = NULL;
	GError * _inner_error_;
	self = (TrackerBusConnection*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	_inner_error_ = NULL;
	{
		GVariant* res;
		res = NULL;
		if (tracker_bus_connection_use_steroids) {
			GVariant* _tmp0_;
			GVariant* _tmp1_;
			_tmp0_ = tracker_bus_fd_sparql_update_blank (tracker_bus_connection_connection, sparql, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_variant_unref0 (res);
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch5_dbus_gerror;
				}
				goto __finally5;
			}
			res = (_tmp1_ = _tmp0_, _g_variant_unref0 (res), _tmp1_);
		} else {
			GVariant* _tmp2_;
			GVariant* _tmp3_;
			_tmp2_ = tracker_bus_array_sparql_update_blank (tracker_bus_connection_connection, sparql, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_variant_unref0 (res);
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch5_dbus_gerror;
				}
				goto __finally5;
			}
			res = (_tmp3_ = _tmp2_, _g_variant_unref0 (res), _tmp3_);
		}
		result = res;
		return result;
	}
	goto __finally5;
	__catch5_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally5;
			}
			_g_error_free0 (e);
		}
	}
	__finally5:
	{
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static void tracker_bus_connection_real_update_blank_async_data_free (gpointer _data) {
	TrackerBusConnectionUpdateBlankAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_variant_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerBusConnectionUpdateBlankAsyncData, data);
}


static void tracker_bus_connection_real_update_blank_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
	self = (TrackerBusConnection*) base;
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateBlankAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_bus_connection_real_update_blank_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_bus_connection_real_update_blank_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_bus_connection_real_update_blank_async_co (_data_);
}


static GVariant* tracker_bus_connection_real_update_blank_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_bus_connection_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBusConnectionUpdateBlankAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_bus_connection_real_update_blank_async_co (data);
}


static gboolean tracker_bus_connection_real_update_blank_async_co (TrackerBusConnectionUpdateBlankAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->res = NULL;
			if (tracker_bus_connection_use_steroids) {
				data->_state_ = 5;
				tracker_bus_fd_sparql_update_blank_async (tracker_bus_connection_connection, data->sparql, data->cancellable, tracker_bus_connection_update_blank_async_ready, data);
				return FALSE;
				_state_5:
				data->_tmp0_ = tracker_bus_fd_sparql_update_blank_finish (data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_variant_unref0 (data->res);
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch6_dbus_gerror;
					}
					goto __finally6;
				}
				data->res = (data->_tmp1_ = data->_tmp0_, _g_variant_unref0 (data->res), data->_tmp1_);
			} else {
				data->_state_ = 6;
				tracker_bus_array_sparql_update_blank_async (tracker_bus_connection_connection, data->sparql, data->cancellable, tracker_bus_connection_update_blank_async_ready, data);
				return FALSE;
				_state_6:
				data->_tmp2_ = tracker_bus_array_sparql_update_blank_finish (data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_variant_unref0 (data->res);
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch6_dbus_gerror;
					}
					goto __finally6;
				}
				data->res = (data->_tmp3_ = data->_tmp2_, _g_variant_unref0 (data->res), data->_tmp3_);
			}
			data->result = data->res;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_variant_unref0 (data->res);
		}
		goto __finally6;
		__catch6_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
				{
					_g_error_free0 (data->e);
					goto __finally6;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally6:
		{
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tracker_bus_connection_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error) {
	TrackerBusConnection * self;
	GError * _inner_error_;
	self = (TrackerBusConnection*) base;
	g_return_if_fail (file != NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		tracker_bus_resources_load (tracker_bus_connection_resources_object, _tmp0_ = g_file_get_uri (file), &_inner_error_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch7_dbus_gerror;
			}
			goto __finally7;
		}
	}
	goto __finally7;
	__catch7_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally7;
			}
			_g_error_free0 (e);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_bus_connection_real_load_async_data_free (gpointer _data) {
	TrackerBusConnectionLoadAsyncData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (TrackerBusConnectionLoadAsyncData, data);
}


static void tracker_bus_connection_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBusConnection * self;
	TrackerBusConnectionLoadAsyncData* _data_;
	self = (TrackerBusConnection*) base;
	_data_ = g_slice_new0 (TrackerBusConnectionLoadAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_bus_connection_real_load_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_bus_connection_real_load_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->file = _g_object_ref0 (file);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_bus_connection_real_load_async_co (_data_);
}


static void tracker_bus_connection_real_load_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerBusConnectionLoadAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_bus_connection_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBusConnectionLoadAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_bus_connection_real_load_async_co (data);
}


static gboolean tracker_bus_connection_real_load_async_co (TrackerBusConnectionLoadAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->_state_ = 7;
			tracker_bus_resources_load_async (tracker_bus_connection_resources_object, data->_tmp0_ = g_file_get_uri (data->file), tracker_bus_connection_load_async_ready, data);
			return FALSE;
			_state_7:
			tracker_bus_resources_load_finish (tracker_bus_connection_resources_object, data->_res_, &data->_inner_error_);
			_g_free0 (data->_tmp0_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == DBUS_GERROR) {
					goto __catch8_dbus_gerror;
				}
				goto __finally8;
			}
		}
		goto __finally8;
		__catch8_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
				{
					_g_error_free0 (data->e);
					goto __finally8;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally8:
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static TrackerSparqlCursor* tracker_bus_connection_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error) {
	TrackerBusConnection * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_;
	self = (TrackerBusConnection*) base;
	_inner_error_ = NULL;
	{
		gint results_length1;
		gint results_length2;
		char** _tmp2_;
		gint _tmp0_;
		gint _tmp1_;
		char** results;
		char** _tmp3_;
		results = (_tmp2_ = tracker_bus_statistics_Get (tracker_bus_connection_statistics_object, &_tmp0_, &_tmp1_, &_inner_error_), results_length1 = _tmp0_, results_length2 = _tmp1_, _tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch9_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = (TrackerSparqlCursor*) tracker_bus_array_cursor_new ((_tmp3_ = results, results = NULL, _tmp3_), results_length1, results_length2, results_length1, results_length2);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		return result;
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
	}
	goto __finally9;
	__catch9_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally9;
			}
			_g_error_free0 (e);
		}
	}
	__finally9:
	{
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static void tracker_bus_connection_real_statistics_async_data_free (gpointer _data) {
	TrackerBusConnectionStatisticsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerBusConnectionStatisticsAsyncData, data);
}


static void tracker_bus_connection_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBusConnection * self;
	TrackerBusConnectionStatisticsAsyncData* _data_;
	self = (TrackerBusConnection*) base;
	_data_ = g_slice_new0 (TrackerBusConnectionStatisticsAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_bus_connection_real_statistics_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_bus_connection_real_statistics_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_bus_connection_real_statistics_async_co (_data_);
}


static TrackerSparqlCursor* tracker_bus_connection_real_statistics_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerBusConnectionStatisticsAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_bus_connection_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBusConnectionStatisticsAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_bus_connection_real_statistics_async_co (data);
}


static gboolean tracker_bus_connection_real_statistics_async_co (TrackerBusConnectionStatisticsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 8:
		goto _state_8;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->_state_ = 8;
			tracker_bus_statistics_Get_async (tracker_bus_connection_statistics_object, tracker_bus_connection_statistics_async_ready, data);
			return FALSE;
			_state_8:
			data->results = (data->_tmp2_ = tracker_bus_statistics_Get_finish (tracker_bus_connection_statistics_object, data->_res_, &data->_tmp0_, &data->_tmp1_, &data->_inner_error_), data->results_length1 = data->_tmp0_, data->results_length2 = data->_tmp1_, data->_tmp2_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == DBUS_GERROR) {
					goto __catch10_dbus_gerror;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			data->result = (TrackerSparqlCursor*) tracker_bus_array_cursor_new ((data->_tmp3_ = data->results, data->results = NULL, data->_tmp3_), data->results_length1, data->results_length2, data->results_length1, data->results_length2);
			data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
		}
		goto __finally10;
		__catch10_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
				{
					_g_error_free0 (data->e);
					goto __finally10;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally10:
		{
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tracker_bus_connection_class_init (TrackerBusConnectionClass * klass) {
	tracker_bus_connection_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_bus_connection_real_query;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_async = tracker_bus_connection_real_query_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_finish = tracker_bus_connection_real_query_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update = tracker_bus_connection_real_update;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_async = tracker_bus_connection_real_update_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_finish = tracker_bus_connection_real_update_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank = tracker_bus_connection_real_update_blank;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_async = tracker_bus_connection_real_update_blank_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_finish = tracker_bus_connection_real_update_blank_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load = tracker_bus_connection_real_load;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_async = tracker_bus_connection_real_load_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_finish = tracker_bus_connection_real_load_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics = tracker_bus_connection_real_statistics;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_async = tracker_bus_connection_real_statistics_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_finish = tracker_bus_connection_real_statistics_finish;
	G_OBJECT_CLASS (klass)->finalize = tracker_bus_connection_finalize;
}


static void tracker_bus_connection_instance_init (TrackerBusConnection * self) {
}


static void tracker_bus_connection_finalize (GObject* obj) {
	TrackerBusConnection * self;
	self = TRACKER_BUS_CONNECTION (obj);
	{
		tracker_bus_connection_initialized = FALSE;
	}
	G_OBJECT_CLASS (tracker_bus_connection_parent_class)->finalize (obj);
}


GType tracker_bus_connection_get_type (void) {
	static volatile gsize tracker_bus_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_bus_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBusConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_bus_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerBusConnection), 0, (GInstanceInitFunc) tracker_bus_connection_instance_init, NULL };
		GType tracker_bus_connection_type_id;
		tracker_bus_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerBusConnection", &g_define_type_info, 0);
		g_once_init_leave (&tracker_bus_connection_type_id__volatile, tracker_bus_connection_type_id);
	}
	return tracker_bus_connection_type_id__volatile;
}


TrackerSparqlConnection* module_init (void) {
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* plugin;
	plugin = (TrackerSparqlConnection*) tracker_bus_connection_new ();
	result = plugin;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




