/*****************************************************************************/
/* td_timeruler.h : Objet Gtk+
 * td_timeruler.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_TIMERULER (td_timeruler_get_type())
#define TD_TIMERULER(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_TIMERULER, TdTimeruler))
#define TD_TIMERULER_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_TIMERULER, TdTimerulerClass))
#define TD_IS_TIMERULER(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_TIMERULER))
#define TD_IS_TIMERULER_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_TIMERULER))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdTimeruler TdTimeruler;
typedef struct _TdTimerulerClass TdTimerulerClass;

struct _TdTimeruler
{
  /*< public >*/
  GtkObject object;
  GtkWidget *widget; /*** Widget */
  GtkWidget *canvas; /*** Cavenas client - Customer canvas */
  GDate *lower; /*** Date basse - Lower date */
  GDate *upper;/*** Date haute - Upper date */ 
  int scale; /*** Echelle - Scale */
  float width; /*** Largeur d'un jour - Width of days */
  GtkWidget *zoom_label; /*** Etiquette du zoom - Zoom label */
};

struct _TdTimerulerClass
{
  GtkObjectClass parent_class;
  void (*set_lower) (TdTimeruler *timeruler, GDate *lower);
};

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_timeruler_init (TdTimeruler *timeruler);
static void td_timeruler_class_init (TdTimerulerClass *klass);
GtkType td_timeruler_get_type (void);
GtkObject *td_timeruler_new (void);
void td_timeruler_destroy (TdTimeruler *timeruler);
void td_timeruler_hide (TdTimeruler *timeruler);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_timeruler_set_canvas (TdTimeruler *timeruler, GtkWidget *canvas);
void td_timeruler_set_lower (TdTimeruler *timeruler, GDate *lower);

/*****************************************************************************/
/*** Commande - Command */
/*****************************************************************************/
void td_timeruler_create (TdTimeruler *timeruler, GtkWidget *vbox1, GtkWidget *vbox2);
void td_timeruler_zoom_changed (GtkAdjustment *adj, TdTimeruler *timeruler);
void td_timeruler_calendar_button_press (GtkWidget *widget, GdkEventButton *event, TdTimeruler *timeruler);
void td_timeruler_calendar_day_selected (GtkCalendar *calendar, TdTimeruler *timeruler);

/*****************************************************************************/
/*** Dessin - Drawing */
/*****************************************************************************/
void td_timeruler_draw_line (float x1, float y1, float x2, float y2, TdTimeruler *timeruler);
void td_timeruler_draw_string (float x, float y, gchar *string, TdTimeruler *timeruler);
void td_timeruler_draw (TdTimeruler *timeruler);
gchar *td_timeruler_year_optimal_format (TdTimeruler *timeruler);
void td_timeruler_year_draw (TdTimeruler *timeruler, int y0, int y1);
gchar *td_timeruler_month_optimal_format (TdTimeruler *timeruler);
void td_timeruler_month_draw (TdTimeruler *timeruler, int y0, int y1, gchar *format);
gchar *td_timeruler_week_optimal_format (TdTimeruler *timeruler);
void td_timeruler_week_draw (TdTimeruler *timeruler, int y0, int y1, gchar *format);
gchar *td_timeruler_day_optimal_format (TdTimeruler *timeruler);
void td_timeruler_day_draw (TdTimeruler *timeruler, int y0, int y1, gchar *format);
void td_timeruler_set_scale (TdTimeruler *timeruler, int scale);
int td_timeruler_scale_label_maxsize (void);
