/*****************************************************************************/
/* td_rule.h : Objet Gtk+
 * td_rule.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <parser.h>
#include <tree.h>
/*  #include <libxml/parser.h> */
/*  #include <libxml/tree.h> */

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_RULE (td_rule_get_type())
#define TD_RULE(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_RULE, TdRule))
#define TD_RULE_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_RULE, TdRuleClass))
#define TD_IS_RULE(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_RULE))
#define TD_IS_RULE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_RULE))

/*****************************************************************************/
/*** Enumration - Enumeration */
/*****************************************************************************/
typedef enum {
  TD_RULE_0, /*** NULL */
  TD_RULE_UPDATE, /*** Rgle de mise  jour - Update rule */
  TD_RULE_INSERT, /*** Rgle d'insertion - Insert rule */
  TD_RULE_DELETE, /*** Rgle de supression - Delete rule */
  TD_RULE_SELECT, /*** Rgle de selection - Select rule */
} TdRuleEvent;

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdRule TdRule;
typedef struct _TdRuleClass TdRuleClass;

struct _TdRule
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  gchar *comment; /*** Commentaire - Comment */
  gchar *table; /*** Table */
  gchar *action; /*** Action */
  GList *property_name; /*** Nom des proprits - Properties name */
  GList *property_value; /*** Valeur des proprits - Properties value */
};

struct _TdRuleClass
{
  GtkObjectClass parent_class;
  void (*add_property) (TdRule *rule, gchar *property_name, gchar *property_value);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_rule_set_name (TdRule *rule, gchar *name);
static void td_rule_set_comment (TdRule *rule, gchar *comment);
static void td_rule_set_table (TdRule *rule, gchar *table);
static void td_rule_set_action (TdRule *rule, gchar *action);
static void td_rule_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_rule_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_rule_init (TdRule *rule);
static void td_rule_class_init (TdRuleClass *klass);
GtkType td_rule_get_type (void);
GtkObject *td_rule_new (void);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_rule_add_property (TdRule *rule, gchar *property_name, gchar *property_value);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
TdRuleEvent td_rule_event_parse (gchar *value);
gchar *td_rule_event_print (TdRuleEvent value);
gchar *td_rule_property_value (TdRule *rule, gchar *property_name);

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
GtkObject *td_rule_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur_root);
