/*****************************************************************************/
/* td_rule.h : Objet Gtk+
 * td_rule.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "td_rule.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_COMMENT,
  ARG_TABLE,
  ARG_ACTION,
};

static void td_rule_set_name (TdRule *rule, gchar *name)
{
  g_return_if_fail (rule != NULL);
  g_return_if_fail (TD_IS_RULE (rule));
  if (rule->name != name)
    rule->name = name;
}

static void td_rule_set_comment (TdRule *rule, gchar *comment)
{
  g_return_if_fail (rule != NULL);
  g_return_if_fail (TD_IS_RULE (rule));
  if (rule->comment != comment)
    rule->comment = comment;
}

static void td_rule_set_table (TdRule *rule, gchar *table)
{
  g_return_if_fail (rule != NULL);
  g_return_if_fail (TD_IS_RULE (rule));
  if (rule->table != table)
    rule->table = table;
}

static void td_rule_set_action (TdRule *rule, gchar *action)
{
  g_return_if_fail (rule != NULL);
  g_return_if_fail (TD_IS_RULE (rule));
  if (rule->action != action)
    rule->action = action;
}

static void td_rule_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdRule *rule;
  rule = TD_RULE (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_rule_set_name (rule, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COMMENT:
      td_rule_set_comment (rule, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TABLE:
      td_rule_set_table (rule, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ACTION:
      td_rule_set_action (rule, GTK_VALUE_STRING (*arg));
      break;
     default:
      break;
    }
}

static void td_rule_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdRule *rule;
  rule = TD_RULE (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = rule->name;
      break;
    case ARG_COMMENT:
      GTK_VALUE_STRING (*arg) = rule->comment;
      break;
    case ARG_TABLE:
      GTK_VALUE_STRING (*arg) = rule->table;
      break;
    case ARG_ACTION:
      GTK_VALUE_STRING (*arg) = rule->action;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_rule_init (TdRule *rule)
{
  rule->name = NULL;
  rule->comment = NULL;
  rule->table = NULL;
  rule->action = NULL;
  rule->property_name = NULL;
  rule->property_value = NULL;
}

static void td_rule_class_init (TdRuleClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdRule::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdRule::comment", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_COMMENT);
  gtk_object_add_arg_type ("TdRule::table", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE);
  gtk_object_add_arg_type ("TdRule::action", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_ACTION);
  object_class->set_arg = td_rule_set_arg;
  object_class->get_arg = td_rule_get_arg;
  klass->add_property = td_rule_add_property;
}

GtkType td_rule_get_type (void)
{
  static GtkType rule_type = 0;
  if (!rule_type)
    {
      static const GtkTypeInfo rule_info =
      {
  	"TdRule", sizeof (TdRule), sizeof (TdRuleClass),
  	(GtkClassInitFunc) td_rule_class_init,
	(GtkObjectInitFunc) td_rule_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      rule_type = gtk_type_unique (GTK_TYPE_OBJECT, &rule_info);
    }
  return rule_type;
}

/**
 * td_rule_new:
 * 
 * fr: Cr une nouvelle rgle
 *
 * en: Creates new rule
 * 
 * Return value: rule parameters
 **/

GtkObject *td_rule_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_rule_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_rule_add_property:
 * @rule: rule
 * @property_name: property's name
 * @property_value: property's value
 * 
 * fr: Ajoute la proprit  la rgle
 *
 * en: Adds the property to rule
 **/

void td_rule_add_property (TdRule *rule, gchar *property_name, gchar *property_value)
{
  g_return_if_fail (rule != NULL);
  g_return_if_fail (TD_IS_RULE (rule));
  rule->property_name = g_list_append (rule->property_name, property_name);
  rule->property_value = g_list_append (rule->property_value, property_value);
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_rule_event_parse:
 * @value: string
 * 
 * fr: Retourne le 'TdRuleEvent' correspondant  la chane de caractres
 *
 * en: Returns the 'TdRuleEvent' corresponding the string
 * 
 * Return value: rule event
 **/

TdRuleEvent td_rule_event_parse (gchar *value)
{
  if (!value)
    return TD_RULE_0;
  if (!strcmp (value, "update"))
    return TD_RULE_UPDATE;
  if (!strcmp (value, "insert"))
    return TD_RULE_INSERT;
  if (!strcmp (value, "delete"))
    return TD_RULE_DELETE;
  if (!strcmp (value, "select"))
    return TD_RULE_SELECT;
  return TD_RULE_0;
}

/**
 * td_rule_event_print:
 * @value: string
 * 
 * fr: Retourne la chane de caractres correspondant au 'TdRuleEvent'
 *
 * en: Returns the string corresponding the 'TdRuleEvent'
 * 
 * Return value: string
 **/

gchar *td_rule_event_print (TdRuleEvent value)
{
  gchar *ret;
  switch (value)
    {
    case TD_RULE_UPDATE:
      ret = "update";
      break;
    case TD_RULE_INSERT:
      ret = "insert";
      break;
    case TD_RULE_DELETE:
      ret = "delete";
      break;
    case TD_RULE_SELECT:
      ret = "select";
      break;
    default:
      ret = "(null)";
      break;
    }
  return ret;
}

/**
 * td_rule_property_value:
 * @rule: rule
 * @property_name: property name
 * 
 * fr: Retourne la valeur de la proprit de la rgle
 *
 * en: Returns the value of rule property
 * 
 * Return value: string
 **/

gchar *td_rule_property_value (TdRule *rule, gchar *property_name)
{
  int i;
  for (i=0; i<g_list_length (rule->property_name); i++)
    if (!strcmp ((gchar*) (g_list_nth_data (rule->property_name, i)), property_name))
      return (g_list_nth_data (rule->property_value, i));
  return NULL;
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_rule_load:
 * @doc: XML document
 * @ns: XML namespace
 * @cur_root: XML node
 * 
 * fr: Retourne la rgle correspondant  la localisation XML
 *
 * en: Returns the rule corresponding the XML location
 * 
 * Return value: rule
 **/

GtkObject *td_rule_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur_root)
{
  GtkObject *ret;
  XmlNode *cur;
  ret = td_rule_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", xmlGetProp (cur_root, "name"),
		  "comment", xmlGetProp (cur_root, "comment"), NULL);

  /*** Proprits - Properties */
  cur =  td_xml_check_children (cur_root->xmlChildrenNode, "properties");
  if (!cur)
    return (ret);
  while (cur)
    {
      if (!strcmp (cur->name, "property"))
	td_rule_add_property (TD_RULE (ret), xmlGetProp (cur, "name"), xmlGetProp (cur, "value"));
      cur = cur->next;
    }
  return (ret);
}
