/*****************************************************************************/
/* td_panwindow.h : Objet Gtk+
 * td_panwindow.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_PANWINDOW (td_panwindow_get_type())
#define TD_PANWINDOW(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_PANWINDOW, TdPanwindow))
#define TD_PANWINDOW_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_PANWINDOW, TdPanwindowClass))
#define TD_IS_PANWINDOW(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_PANWINDOW))
#define TD_IS_PANWINDOW_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_PANWINDOW))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdPanwindow TdPanwindow;
typedef struct _TdPanwindowClass TdPanwindowClass;

struct _TdPanwindow
{
  /*< public >*/
  GtkObject object;
  GtkWidget *window; /*** Fentre - Window */
  GtkWidget *canvas; /*** Cavenas client - Customer canvas */
  GnomeCanvasItem *button; /*** Glisseur - Slider */
  double x; /*** Coordonne x - x coordinate */
  double y; /*** Coordonne y - y coordinate */
  gboolean dragging; /*** Drapeau du tirer - Dragging flag */
  gboolean move; /*** Drapeau de dplacement - Moving flag */
};

struct _TdPanwindowClass
{
  GtkObjectClass parent_class;
};

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_panwindow_init (TdPanwindow *panwindow);
static void td_panwindow_class_init (TdPanwindowClass *klass);
GtkType td_panwindow_get_type (void);
GtkObject *td_panwindow_new (void);
void td_panwindow_destroy (TdPanwindow *panwindow);
void td_panwindow_hide (TdPanwindow *panwindow);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_panwindow_set_canvas (TdPanwindow *panwindow, GtkWidget *canvas);

/*****************************************************************************/
/*** Interface */
/*****************************************************************************/
void td_panwindow_create (GtkWidget *widget, GdkEventButton *event, TdPanwindow *panwindow);
void td_panwindow_button_press (GtkWidget *widget, GdkEventButton *event, TdPanwindow *panwindow);
void td_panwindow_changed (GnomeCanvasItem *item, GdkEvent *event, TdPanwindow *panwindow);
void td_panwindow_scrollbar_changed (TdPanwindow *panwindow);
