/*****************************************************************************/
/* td_panwindow.c : Objet Gtk+
 * td_panwindow.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "gtdk.h"
#include "td_panwindow.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_panwindow_init (TdPanwindow *panwindow)
{
  panwindow->window = NULL;
  panwindow->canvas = NULL;
  panwindow->button = NULL;
  panwindow->x = 0;
  panwindow->y = 0;
  panwindow->dragging = FALSE;
  panwindow->move = FALSE;
}

static void td_panwindow_class_init (TdPanwindowClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
}

GtkType td_panwindow_get_type (void)
{
  static GtkType panwindow_type = 0;
  if (!panwindow_type)
    {
      static const GtkTypeInfo panwindow_info =
      {
  	"TdPanwindow", sizeof (TdPanwindow), sizeof (TdPanwindowClass),
  	(GtkClassInitFunc) td_panwindow_class_init,
	(GtkObjectInitFunc) td_panwindow_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      panwindow_type = gtk_type_unique (GTK_TYPE_OBJECT, &panwindow_info);
    }
  return panwindow_type;
}

/**
 * td_panwindow_new:
 * 
 * fr: Cr une nouvelle fentre pan
 *
 * en: Creates a new pan window
 * 
 * Return value: pan window
 **/

GtkObject *td_panwindow_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_panwindow_get_type()));
}

/**
 * td_panwindow_destroy:
 * @panwindow: pan window
 * 
 * fr: Dtruit la fentre pan
 *
 * en: Destroys the pan window
 **/

void td_panwindow_destroy (TdPanwindow *panwindow)
{
  g_return_if_fail (panwindow != NULL);
  g_return_if_fail (TD_IS_PANWINDOW (panwindow));
  if (panwindow->window)
    gtk_widget_destroy (panwindow->window);
  gtk_object_destroy (GTK_OBJECT (panwindow));
}

/**
 * td_panwindow_hide:
 * @panwindow: pan window
 * 
 * fr: Cache la fentre pan
 *
 * en: Hides the pan window
 **/

void td_panwindow_hide (TdPanwindow *panwindow)
{
  g_return_if_fail (panwindow != NULL);
  g_return_if_fail (TD_IS_PANWINDOW (panwindow));
  if (panwindow->window)
    {
      gtk_widget_destroy (panwindow->window);
      panwindow->window = NULL;
    }
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_panwindow_set_canvas:
 * @panwindow: pan window
 * @canvas: canvas
 * 
 * fr: Affecte le cavenas  la fentre pan
 *
 * en: Allocates the canvas to pan window
 **/

void td_panwindow_set_canvas (TdPanwindow *panwindow, GtkWidget *canvas)
{
  g_return_if_fail (panwindow != NULL);
  g_return_if_fail (TD_IS_PANWINDOW (panwindow));
  if (panwindow->canvas != canvas)
    panwindow->canvas = canvas;
}

/*****************************************************************************/
/*** Interface */
/*****************************************************************************/

/**
 * td_panwindow_create:
 * @widget: button clicked for pan window creation
 * @event: click event
 * @panwindow: pan window
 * 
 * fr: Cr l'interface de la fentre pan
 *
 * en: Creates the interface of pan window
 **/

void td_panwindow_create (GtkWidget *widget, GdkEventButton *event, TdPanwindow *panwindow)
{
  GtkWidget *frame;
  GtkWidget *frame2;
  GnomeCanvas *canvas = GNOME_CANVAS (panwindow->canvas);
  GtkWidget *pan_canvas;
  GtkWidget *button;
  GnomeCanvasGroup *root;
  GdkColor color;
  double x, y, width, height;
  int x_pop, y_pop;
  g_return_if_fail (panwindow != NULL);
  g_return_if_fail (TD_IS_PANWINDOW (panwindow));

  /*** Dj existant - Already existing */
  if (panwindow->window)
    {
      gtk_widget_destroy (panwindow->window);
      panwindow->window = NULL;
      return;
    }

  /*** Canevas - Canvas */
  panwindow->window = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_window_set_policy (GTK_WINDOW (panwindow->window), FALSE, FALSE, TRUE);
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_OUT);
  gtk_widget_show (frame);
  gtk_container_add (GTK_CONTAINER (panwindow->window), frame);
  frame2 = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_IN);
  gtk_widget_show (frame2);
  gtk_container_add (GTK_CONTAINER (frame), frame2);
  pan_canvas = gnome_canvas_new();
  root = gnome_canvas_root (GNOME_CANVAS (pan_canvas));
  gnome_canvas_set_scroll_region (GNOME_CANVAS (pan_canvas), 0, 0, 80, 80);
  gtk_widget_set_usize (pan_canvas, 80, 80);
  gtk_container_add (GTK_CONTAINER (frame2), pan_canvas);
  gtk_widget_show (pan_canvas);
  GTK_WIDGET_SET_FLAGS (pan_canvas, GTK_CAN_FOCUS);
  gtk_widget_grab_focus (pan_canvas);
  color = gtdk_color_parse ("base[normal]");
  gnome_canvas_item_new (root, gnome_canvas_rect_get_type(), 
			 "x1", (double) 0, 
			 "y1", (double) 0, 
			 "x2", (double) 80, 
			 "y2", (double) 80, 
			 "fill_color_gdk", &color, NULL);

  /*** Item */
  x = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value*(80/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper);
  y = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value*(80/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper);
  width = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->page_size*(80/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper);
  if (width<20)
    width = 20;
  height = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->page_size*(80/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper);
  if (height<20)
    height = 20;
  button = gtk_button_new();
  gtk_widget_show (button);
  panwindow->button = gnome_canvas_item_new (root, gnome_canvas_widget_get_type(), 
					     "widget", button, 
					     "x", x, 
					     "y", y, 
					     "width", width, 
					     "height", height, 
					     "anchor", GTK_ANCHOR_NW, NULL);
  gtk_signal_connect (GTK_OBJECT (panwindow->button), "event", GTK_SIGNAL_FUNC (td_panwindow_changed), panwindow);
  gtk_signal_connect (GTK_OBJECT (GNOME_CANVAS_WIDGET (panwindow->button)->widget), "button_press_event", GTK_SIGNAL_FUNC (td_panwindow_button_press), panwindow);
  gtk_signal_connect (GTK_OBJECT (GNOME_CANVAS_WIDGET (panwindow->button)->widget), "button_release_event", GTK_SIGNAL_FUNC (td_panwindow_button_press), panwindow);
  x_pop = event->x_root-x-width/2;
  y_pop = event->y_root-y-height/2;
  if (x_pop<0)
    x_pop = 0;
  if (y_pop<0)
    y_pop = 0;
  if (x_pop+88>gdk_screen_width())
    x_pop = gdk_screen_width()-88;
  if (y_pop+88>gdk_screen_height())
    y_pop = gdk_screen_height()-88;
  gtk_widget_popup (panwindow->window, x_pop, y_pop);
}

/**
 * td_panwindow_button_press:
 * @widget: slider of pan window
 * @event: click event
 * @panwindow: pan window
 * 
 * fr: Evnements 'button_press_event' et 'button_release_event' du glisseur de la fentre pan
 *
 * en: Events 'button_press_event' and 'button_release_event' of slider of pan window
 **/

void td_panwindow_button_press (GtkWidget *widget, GdkEventButton *event, TdPanwindow *panwindow)
{
  GnomeCanvas *canvas = GNOME_CANVAS (panwindow->canvas);
  double item_x, item_y;
  g_return_if_fail (panwindow != NULL);
  g_return_if_fail (TD_IS_PANWINDOW (panwindow));
  item_x = event->x;
  item_y = event->y;
  if (event->button != 1)
    {
      gtk_widget_destroy (panwindow->window);
      panwindow->window = NULL;
      return;
    }
  switch (event->type) 
    {
    case GDK_BUTTON_PRESS:
      panwindow->x = item_x+GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value*(80/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper);
      panwindow->y = item_y+GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value*(80/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper);
      panwindow->dragging = TRUE;
      gnome_canvas_item_grab (panwindow->button, GDK_POINTER_MOTION_MASK | GDK_BUTTON_RELEASE_MASK, NULL, event->time);
      break;
    case GDK_BUTTON_RELEASE:
      gnome_canvas_item_ungrab (panwindow->button, event->time);
      panwindow->dragging = FALSE;
      if (!panwindow->move)
	{
	  gtk_widget_destroy (panwindow->window);
	  panwindow->window = NULL;
	}
      else
	panwindow->move = FALSE;
      break;
    default:
      break;
    }
}

/**
 * td_panwindow_changed:
 * @item: slider of pan button
 * @event: event (move)
 * @panwindow: pan window
 * 
 * fr: Evnements 'event' (mouvement) du glisseur de la fentre pan
 *
 * en: Events 'event' (move) of slider of pan window
 **/

void td_panwindow_changed (GnomeCanvasItem *item, GdkEvent *event, TdPanwindow *panwindow)
{
  double max_x, max_y;
  double item_x, item_y;
  double new_x = 0;
  double new_y = 0;
  GnomeCanvas *canvas = GNOME_CANVAS (panwindow->canvas);
  g_return_if_fail (panwindow != NULL);
  g_return_if_fail (TD_IS_PANWINDOW (panwindow));
  item_x = event->button.x;
  item_y = event->button.y;

  /*** Go ! */
  if ((event->type == GDK_BUTTON_PRESS) && (event->button.button !=1))
    return;
  if ((event->type == GDK_MOTION_NOTIFY) && panwindow->dragging && (event->motion.state & GDK_BUTTON1_MASK)) 
    {
      new_x = item_x;
      new_y = item_y;
      if (GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value+(new_x-panwindow->x)*(GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper/80)<GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->lower)
	gtk_adjustment_set_value (GTK_LAYOUT (canvas)->hadjustment, GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->lower);
      if ((GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value+GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->page_size+(new_x-panwindow->x)*(GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper/80))>GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper)
	gtk_adjustment_set_value (GTK_LAYOUT (canvas)->hadjustment, GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper-GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->page_size);
      if (GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value+(new_y-panwindow->y)*(GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper/80)<GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->lower)
	gtk_adjustment_set_value (GTK_LAYOUT (canvas)->vadjustment, GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->lower);
      if ((GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value+GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->page_size+(new_y-panwindow->y)*(GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper/80))>GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper)
	gtk_adjustment_set_value (GTK_LAYOUT (canvas)->vadjustment, GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper-GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->page_size);
      if ((GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value+(new_x-panwindow->x)*(GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper/80)>GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->lower) &&
	  ((GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value+GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->page_size+(new_x-panwindow->x)*(GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper/80))<GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper))
	gtk_adjustment_set_value (GTK_LAYOUT (canvas)->hadjustment, GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value+(new_x-panwindow->x)*(GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper/80));
      if ((GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value+(new_y-panwindow->y)*(GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper/80)>GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->lower) &&
	  ((GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value+GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->page_size+(new_y-panwindow->y)*(GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper/80))<GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper))
	gtk_adjustment_set_value (GTK_LAYOUT (canvas)->vadjustment, GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value+(new_y-panwindow->y)*(GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper/80));
      panwindow->x = new_x;
      panwindow->y = new_y;
      panwindow->move = TRUE;
      gnome_canvas_request_redraw (GNOME_CANVAS (panwindow->canvas), 
				   GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value,
				   GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value,
				   GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value+GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->page_size,
				   GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value+GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->page_size);
    }
}

/**
 * td_panwindow_scrollbar_changed:
 * @panwindow: pan window
 * 
 * fr: Evnement 'value_changed' d'un des ascenseurs du cavenas li  la fentre pan 
 *
 * en: Event 'value_changed' of scrollbar of canvas linked with the pan window
 **/

void td_panwindow_scrollbar_changed (TdPanwindow *panwindow)
{
  GnomeCanvas *canvas = GNOME_CANVAS (panwindow->canvas);
  double x, y, width, height;
  g_return_if_fail (panwindow != NULL);
  g_return_if_fail (TD_IS_PANWINDOW (panwindow));
  if (panwindow->window)
    {
      x = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value*(80/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper);
      y = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value*(80/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper);
      width = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->page_size*(80/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper);
      height = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->page_size*(80/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper);
      if (width<16)
	width = 16;
      if (height<16)
	height = 16;
      gnome_canvas_item_set (panwindow->button, 
			     "x", x, 
			     "y", y, 
			     "width", width, 
			     "height", height, NULL);
    }
}
