/*****************************************************************************/
/* td_mod_tree_icon.c : Objet Gtk+
 * td_mod_tree_icon.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "td_mod_tree_icon.h"
#include "icons.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_PIXMAP1,
  ARG_PIXMAP2,
  ARG_QUERY_VISIBLE,
};

static void td_mod_tree_icon_set_pixmap1 (TdModTreeIcon *mod_tree_icon, gchar *pixmap1)
{
  g_return_if_fail (mod_tree_icon != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_ICON (mod_tree_icon));
  if (mod_tree_icon->pixmap1 != pixmap1)
    mod_tree_icon->pixmap1 = pixmap1;
}

static void td_mod_tree_icon_set_pixmap2 (TdModTreeIcon *mod_tree_icon, gchar *pixmap2)
{
  g_return_if_fail (mod_tree_icon != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_ICON (mod_tree_icon));
  if (mod_tree_icon->pixmap2 != pixmap2)
    mod_tree_icon->pixmap2 = pixmap2;
}

static void td_mod_tree_icon_set_query_visible (TdModTreeIcon *mod_tree_icon, gchar *query_visible)
{
  g_return_if_fail (mod_tree_icon != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_ICON (mod_tree_icon));
  if (mod_tree_icon->query_visible != query_visible)
    mod_tree_icon->query_visible = query_visible;
}

static void td_mod_tree_icon_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModTreeIcon *mod_tree_icon;
  mod_tree_icon = TD_MOD_TREE_ICON (object);
  switch (arg_id)
    {
    case ARG_PIXMAP1:
      td_mod_tree_icon_set_pixmap1 (mod_tree_icon, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PIXMAP2:
      td_mod_tree_icon_set_pixmap2 (mod_tree_icon, GTK_VALUE_STRING (*arg));
      break;
    case ARG_QUERY_VISIBLE:
      td_mod_tree_icon_set_query_visible (mod_tree_icon, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_tree_icon_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModTreeIcon *mod_tree_icon;
  mod_tree_icon = TD_MOD_TREE_ICON (object);
  switch (arg_id)
    {
    case ARG_PIXMAP1:
      GTK_VALUE_STRING (*arg) = mod_tree_icon->pixmap1;
      break;
    case ARG_PIXMAP2:
      GTK_VALUE_STRING (*arg) = mod_tree_icon->pixmap2;
      break;
    case ARG_QUERY_VISIBLE:
      GTK_VALUE_STRING (*arg) = mod_tree_icon->query_visible;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_tree_icon_init (TdModTreeIcon *mod_tree_icon)
{
  mod_tree_icon->pixmap1 = NULL;
  mod_tree_icon->pixmap2 = NULL;
  mod_tree_icon->query_visible = NULL;
}

static void td_mod_tree_icon_class_init (TdModTreeIconClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModTreeIcon::pixmap1", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PIXMAP1);
  gtk_object_add_arg_type ("TdModTreeIcon::pixmap2", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PIXMAP2);
  gtk_object_add_arg_type ("TdModTreeIcon::query_visible", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_VISIBLE);
  object_class->set_arg = td_mod_tree_icon_set_arg;
  object_class->get_arg = td_mod_tree_icon_get_arg;
}

GtkType td_mod_tree_icon_get_type (void)
{
  static GtkType mod_tree_icon_type = 0;
  if (!mod_tree_icon_type)
    {
      static const GtkTypeInfo mod_tree_icon_info =
      {
  	"TdModTreeIcon", sizeof (TdModTreeIcon), sizeof (TdModTreeIconClass),
  	(GtkClassInitFunc) td_mod_tree_icon_class_init,
	(GtkObjectInitFunc) td_mod_tree_icon_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_tree_icon_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_tree_icon_info);
    }
  return mod_tree_icon_type;
}

/**
 * td_mod_tree_icon_new:
 * 
 * fr: Cr une nouvelle icne
 *
 * en: Creates a new icon
 * 
 * Return value: icon
 **/

GtkObject *td_mod_tree_icon_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_tree_icon_get_type()));
}

/*****************************************************************************/
/*** Commande */
/*****************************************************************************/

/**
 * td_mod_tree_icon_set:
 * @mod_tree_icon: icon
 * @value: icon closed's name and icon opened's name
 * 
 * fr: Affecte les icnes
 *
 * en: Allocates the icons
 **/

void td_mod_tree_icon_set (TdModTreeIcon *mod_tree_icon, gchar *value)
{
  gchar *value2;
  if (td_strsplit (value, NULL, 1))
    gtk_object_set (GTK_OBJECT (mod_tree_icon),
		    "pixmap1", td_icon_parse (td_strsplit (value, NULL, 0)),
		    "pixmap2", td_icon_parse (td_strsplit (value, NULL, 1)), NULL);
  else
    {
      value2 = td_icon_parse (value);
      gtk_object_set (GTK_OBJECT (mod_tree_icon),
		      "pixmap1", value2,
		      "pixmap2", value2, NULL);
    }
}



