/*****************************************************************************/
/* td_mod_tree.h : Objet Gtk+
 * td_mod_tree.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_TREE (td_mod_tree_get_type())
#define TD_MOD_TREE(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_TREE, TdModTree))
#define TD_MOD_TREE_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_TREE, TdModTreeClass))
#define TD_IS_MOD_TREE(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_TREE))
#define TD_IS_MOD_TREE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_TREE))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdModTree TdModTree;
typedef struct _TdModTreeClass TdModTreeClass;

struct _TdModTree
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  gchar *name_intl; /*** Nom international - International name */
  int id; /*** Identificateur - Identifier */
  GtkWidget *label; /*** Etiquette - Label */
  gboolean customize; /*** Personnalisable - Customizable */
  gboolean reorderable; /*** Rarrangeable - Reorderable */
  GList *field; /*** Champs - Fields */
  GList *icon; /*** Icnes - Icons */
  int column_oid; /*** Localisation du champs des idendificateurs - Location of identifiers field */
  gchar *table; /*** Nom de la table - Table name */
  gchar *table_tree; /*** Nom de la table de l'arbre - Tree table name */

  GtkWidget *widget; /*** Widget */
  GtkWidget *widget_data; /*** Widget de donnes - Widget with data */
  GtkWidget *menu_widget; /*** Menu */
  GtkCTreeNode *selected; /*** Item selectionn - Selected item */

  GList *list_widget; /*** Widget des listes - Widget of lists */
  GList *list_query; /*** Requte des liste - Query of lists */
  GList *list_type; /*** Type des listes - Type of lists */
};

struct _TdModTreeClass
{
  GtkObjectClass parent_class;
  void (*add_icon) (TdModTree *mod_tree, GtkObject *icon);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_mod_tree_set_name (TdModTree *mod_tree, gchar *name);
static void td_mod_tree_set_name_intl (TdModTree *mod_tree, gchar *name_intl);
static void td_mod_tree_set_customize (TdModTree *mod_tree, gboolean customize);
static void td_mod_tree_set_reorderable (TdModTree *mod_tree, gboolean reorderable);
static void td_mod_tree_set_column_oid (TdModTree *mod_tree, int column_oid);
static void td_mod_tree_set_table (TdModTree *mod_tree, gchar *table);
static void td_mod_tree_set_table_tree (TdModTree *mod_tree, gchar *table_tree);
static void td_mod_tree_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_tree_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_tree_init (TdModTree *mod_tree);
static void td_mod_tree_class_init (TdModTreeClass *klass);
GtkType td_mod_tree_get_type (void);
GtkObject *td_mod_tree_new (void);
void td_mod_tree_destroy (TdModTree *mod_tree);
void td_mod_tree_show (TdModTree *mod_tree);
void td_mod_tree_hide (TdModTree *mod_tree);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_mod_tree_add_icon (TdModTree *mod_tree, GtkObject *icon);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
void td_mod_tree_create (TdModTree *mod_tree, TdMod *mod);
void td_mod_tree_button_press (GtkWidget *widget, GdkEventButton *event, TdModTree *mod_tree);
void td_mod_tree_interface_action (GtkMenuItem *menuitem, GList *data);
void td_mod_tree_expand (GtkWidget *widget, GtkCTreeNode *node, TdModTree *mod_tree);
void td_mod_tree_collapse (GtkWidget *widget, GtkCTreeNode *node, TdModTree *mod_tree);
void td_mod_tree_refresh (TdModTree *mod_tree);
GtkCTreeNode *td_mod_tree_add_node (TdModTree *mod_tree, GtkCTreeNode *parent, GtkCTreeNode *sibling, GList *data);
void td_mod_tree_update_node (TdModTree *mod_tree);
void td_mod_tree_select_node (GtkCTree *widget, gint row, gint column, GdkEvent *event, TdModTree *mod_tree);
GList *td_mod_tree_read_node (TdModTree *mod_tree, GtkCTreeNode *node);

/*****************************************************************************/
/*** Tirer-lcher - Drag'n'drop */
/*****************************************************************************/
void td_mod_tree_dnd_get (GtkWidget *widget, GdkDragContext *context, GtkSelectionData *selection_data, guint info, guint time, int row);
void td_mod_tree_dnd_received (GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *selection_data, guint info, guint time, TdModTree *mod_tree);
void td_mod_tree_dnd_action (TdModTree *mod_tree, GtkCTreeNode *node_drag, GtkCTreeNode *node_drop, GtkCTreeNode *node_parent, GtkCTreeNode *node_sibling, GdkDragContext *context);
gint td_mod_tree_dnd_autoexpand (gpointer widget);
int td_mod_tree_dnd_drag_position (GtkWidget *widget, int x, int y, GtkWidget *scrolledwindow);
void td_mod_tree_dnd_motion (GtkWidget *widget, GdkDragContext *context, gint x, gint y, guint time, GtkWidget *scrolledwindow);

/*****************************************************************************/
/*** Base de donnes - Database */
/*****************************************************************************/
void td_mod_tree_action (TdModTree *mod_tree, gchar *type);
