/*****************************************************************************/
/* td_mod_stree.h : Objet Gtk+
 * td_mod_stree.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_STREE (td_mod_stree_get_type())
#define TD_MOD_STREE(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_STREE, TdModStree))
#define TD_MOD_STREE_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_STREE, TdModStreeClass))
#define TD_IS_MOD_STREE(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_STREE))
#define TD_IS_MOD_STREE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_STREE))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdModStree TdModStree;
typedef struct _TdModStreeClass TdModStreeClass;

struct _TdModStree
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  gchar *name_parent; /*** Nom du module - Module name */
  int id; /*** Identificateur - Identifier */
  int id_parent; /*** Identificateur du module - Identifier of module */
  GtkWidget *label; /*** Etiquette - Label */

  GtkWidget *widget; /*** Widget */
  GtkWidget *widget_data; /*** Widget de donnes - Widget with data */
  GtkWidget *default_menu; /*** Menu */
};

struct _TdModStreeClass
{
  GtkObjectClass parent_class;
  void (*set_default_menu) (TdModStree *mod_stree, GtkWidget *menu);
  void (*create) (TdModStree *mod_stree, int id, int id_parent);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_mod_stree_set_name (TdModStree *mod_stree, gchar *name);
static void td_mod_stree_set_name_parent (TdModStree *mod_stree, gchar *name_parent);
static void td_mod_stree_set_id (TdModStree *mod_stree, int id);
static void td_mod_stree_set_id_parent (TdModStree *mod_stree, int id_parent);
static void td_mod_stree_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_stree_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_stree_init (TdModStree *mod_stree);
static void td_mod_stree_class_init (TdModStreeClass *klass);
GtkType td_mod_stree_get_type (void);
GtkObject *td_mod_stree_new (void);
void td_mod_stree_destroy (TdModStree *mod_stree);
void td_mod_stree_show (TdModStree *mod_stree);
void td_mod_stree_hide (TdModStree *mod_stree);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_mod_stree_set_default_menu (TdModStree *mod_stree, GtkWidget *default_menu);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
void td_mod_stree_create (TdModStree *mod_stree, int id, int id_parent);
void td_mod_stree_button_press (GtkWidget *widget, GdkEventButton *event, TdModStree *mod_stree);

/*****************************************************************************/
/*** Fichier support - Support file */
/*****************************************************************************/
void td_mod_stree_item_set_label (GtkWidget *tree_item, gchar *data, TdModStree *mod_stree, int width);
void td_mod_stree_load_flower (TdModStree *mod_stree, GtkObject *flower);

