/*****************************************************************************/
/* td_mod_menu.h : Objet Gtk+
 * td_mod_menu.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_MENU (td_mod_menu_get_type())
#define TD_MOD_MENU(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_MENU, TdModMenu))
#define TD_MOD_MENU_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_MENU, TdModMenuClass))
#define TD_IS_MOD_MENU(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_MENU))
#define TD_IS_MOD_MENU_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_MENU))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdModMenu TdModMenu;
typedef struct _TdModMenuClass TdModMenuClass;

struct _TdModMenu
{
  /*< public >*/
  GtkObject object;
  gchar *label; /*** Etiquette - Label */
  gchar *icon; /*** Icne - Icon */
  gchar *type; /*** Type */
  GtkWidget *widget; /*** Widget */
  gchar *query_visible; /*** Requte de visibilit - Query of visisbility */
  gchar *query_unsensitive; /*** Requte de sensibilit - Query of sensitivity */
};

struct _TdModMenuClass
{
  GtkObjectClass parent_class;
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_mod_menu_set_label (TdModMenu *mod_menu, gchar *label);
static void td_mod_menu_set_icon (TdModMenu *mod_menu, gchar *icon);
static void td_mod_menu_set_query_visible (TdModMenu *mod_menu, gchar *query_visible);
static void td_mod_menu_set_query_unsensitive (TdModMenu *mod_menu, gchar *query_unsensitive);
static void td_mod_menu_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_menu_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_menu_init (TdModMenu *mod_menu);
static void td_mod_menu_class_init (TdModMenuClass *klass);
GtkType td_mod_menu_get_type (void);
GtkObject *td_mod_menu_new (void);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_mod_menu_set_widget (TdModMenu *mod_menu, GtkWidget *widget);






