/*****************************************************************************/
/* td_mod_gantt.h : Objet Gtk+
 * td_mod_gantt.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_GANTT (td_mod_gantt_get_type())
#define TD_MOD_GANTT(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_GANTT, TdModGantt))
#define TD_MOD_GANTT_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_GANTT, TdModGanttClass))
#define TD_IS_MOD_GANTT(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_GANTT))
#define TD_IS_MOD_GANTT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_GANTT))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdModGantt TdModGantt;
typedef struct _TdModGanttClass TdModGanttClass;

struct _TdModGantt
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  gchar *name_intl; /*** Nom international - International name */
  int id; /*** Identificateur - Identifier */
  GtkWidget *label; /*** Etiquette - Label */
  gchar *label_form; /*** Mise en forme de l'tiquette - Form of label */
  GList *label_field; /*** Champs de l'tiquette - Fields of label */
  gboolean customize; /*** Personnalisable - Customizable */
  gboolean reorderable; /*** Rarrangeable - Reorderable */
  GList *symbol; /*** Symboles - Symbols */
  gchar *symbol_file; /*** Localisation du fichier des symboles - File location of symbols */
  int column_oid; /*** Localisation du champs des idendificateurs - Location of identifiers field */
  gchar *table; /*** Nom de la table - Table name */
  gchar *table_net; /*** Nom de la table du reseau - Network table name */
  gchar *table_tree; /*** Nom de la table de l'arboresence - Tree table name */

  GtkWidget *widget; /*** Widget */
  GtkWidget *widget_data; /*** Widget de donnes - Widget with data */
  int row_height; /*** Hauteur d'une node - Height of node */
  int row_height_link; /*** Hauteur du lien ligne - Height of link */
  int row_indent; /*** Indentation de l'arbre - Tree indentation */
  GtkObject *timeruler; /*** Echelle du temps - Time ruler */
  GtkWidget *menu_widget; /*** Menu */
  GtkWidget *menu_link_widget; /*** Menu des liens - Links menu */

  GnomeCanvasGroup *selected; /*** Item selectionn - Selected item */
  GList *selected_parent; /*** Items enfant selectionns - Selected child items */
  GList *selected_child; /*** Items enfant selectionns - Selected child items */
  GList *selected_link_parent; /*** Liens entrants selectionns - Selected input links */
  GList *selected_link_child; /*** Liens sortants selectionns - Selected output links */
  GList *selected_link_familly; /*** Liens de la famille selectionne - Links of the selected familly */
  GnomeCanvasItem *link; /*** Lien - Link */

  int dragging; /*** Drapeau du tirer - Dragging flag */
  double dragging_x; /*** Coordonne x du tirer - x coordinate of dragging */
  double dragging_y; /*** Coordonne y du tirer - y coordinate of dragging */
  GnomeCanvasItem *dragging_line1; /* Ligne du dnd */
  GnomeCanvasItem *dragging_line2; /* Ligne du dnd */
  double init_x; /*** Coordonne x initiale du tirer - Initial x coordinate of dragging */
  double init_y; /*** Coordonne y initiale du tirer - Initial y coordinate of dragging */
  GtkObject *panwindow; /*** Fentre pan - Pan window */
};

struct _TdModGanttClass
{
  GtkObjectClass parent_class;
  void (*set_timeruler) (TdModGantt *mod_gantt, GtkObject *timeruler);
  void (*add_symbol) (TdModGantt *mod_gantt, GtkObject *symbol);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_mod_gantt_set_name (TdModGantt *mod_gantt, gchar *name);
static void td_mod_gantt_set_name_intl (TdModGantt *mod_gantt, gchar *name_intl);
static void td_mod_gantt_set_customize (TdModGantt *mod_gantt, gboolean customize);
static void td_mod_gantt_set_reorderable (TdModGantt *mod_gantt, gboolean reorderable);
static void td_mod_gantt_set_symbol_file (TdModGantt *mod_gantt, gchar *symbol_file);
static void td_mod_gantt_set_column_oid (TdModGantt *mod_gantt, int column_oid);
static void td_mod_gantt_set_label_form (TdModGantt *mod_gantt, gchar *label_form);
static void td_mod_gantt_set_row_height (TdModGantt *mod_gantt, int row_height);
static void td_mod_gantt_set_table (TdModGantt *mod_gantt, gchar *table);
static void td_mod_gantt_set_table_net (TdModGantt *mod_gantt, gchar *table_net);
static void td_mod_gantt_set_table_tree (TdModGantt *mod_gantt, gchar *table_tree);
static void td_mod_gantt_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_gantt_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_gantt_init (TdModGantt *mod_gantt);
static void td_mod_gantt_class_init (TdModGanttClass *klass);
GtkType td_mod_gantt_get_type (void);
GtkObject *td_mod_gantt_new (void);
void td_mod_gantt_destroy (TdModGantt *mod_gantt);
void td_mod_gantt_show (TdModGantt *mod_gantt);
void td_mod_gantt_hide (TdModGantt *mod_gantt);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_mod_gantt_set_timeruler (TdModGantt *mod_gantt, GtkObject *timeruler);
void td_mod_gantt_add_symbol (TdModGantt *mod_gantt, GtkObject *symbol);
void td_mod_gantt_add_label_field (TdModGantt *mod_gantt, gchar *label_field);

/*****************************************************************************/
/*** Interface */
/*****************************************************************************/
void td_mod_gantt_create (TdModGantt *mod_gantt, GtkObject *mod);
void td_mod_gantt_button_press (GtkWidget *widget, GdkEventButton *event, TdModGantt *mod_gantt);
void td_mod_gantt_scrollbar_changed (GtkAdjustment *adj, TdModGantt *mod_gantt);
void td_mod_gantt_set_scrollbar_region (TdModGantt *mod_gantt, int y);
void td_mod_gantt_draw_link (TdModGantt *mod_gantt, GnomeCanvasItem *link, GnomeCanvasItem *node_parent, GnomeCanvasItem *node);
void td_mod_gantt_link_correct (GnomeCanvasLine *link);




