/*****************************************************************************/
/* td_mod_gantt.c : Objet Gtk+
 * td_mod_gantt.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "gtdk.h"
#include "database.h"
#include "td_app.h"
#include "td_app_palette.h"
#include "td_app_bench.h"
#include "td_mod.h"
#include "td_mod_gantt.h"
#include "td_db_base.h"
#include "td_db_mod.h"
#include "td_db_datatable.h"
#include "td_db_connect.h"
#include "td_field.h"
#include "td_flower.h"
#include "td_timeruler.h"
#include "td_panwindow.h"

/* 
 * FIXME: Temps nous gagnerons, par usage abusive du greffon,
 * lments mieux finaliss, la lib retrouvera son autorite.
 */

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_NAME_INTL,
  ARG_CUSTOMIZE,
  ARG_REORDERABLE,
  ARG_SYMBOL_FILE,
  ARG_COLUMN_OID,
  ARG_LABEL_FORM,
  ARG_ROW_HEIGHT,
  ARG_TABLE,
  ARG_TABLE_NET,
  ARG_TABLE_TREE,
};

static void td_mod_gantt_set_name (TdModGantt *mod_gantt, gchar *name)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->name != name)
    mod_gantt->name = name;
}

static void td_mod_gantt_set_name_intl (TdModGantt *mod_gantt, gchar *name_intl)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->name_intl != name_intl)
    {
      mod_gantt->name_intl = name_intl;
      mod_gantt->label = gtk_label_new (name_intl);
    }
}

static void td_mod_gantt_set_customize (TdModGantt *mod_gantt, gboolean customize)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->customize != customize)
    mod_gantt->customize = customize;
}

static void td_mod_gantt_set_reorderable (TdModGantt *mod_gantt, gboolean reorderable)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->reorderable != reorderable)
    mod_gantt->reorderable = reorderable;
}

static void td_mod_gantt_set_symbol_file (TdModGantt *mod_gantt, gchar *symbol_file)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->symbol_file != symbol_file)
    mod_gantt->symbol_file = symbol_file;
}

static void td_mod_gantt_set_column_oid (TdModGantt *mod_gantt, int column_oid)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->column_oid != column_oid)
    mod_gantt->column_oid = column_oid;
}

static void td_mod_gantt_set_label_form (TdModGantt *mod_gantt, gchar *label_form)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->label_form != label_form)
    mod_gantt->label_form = label_form;
}

static void td_mod_gantt_set_row_height (TdModGantt *mod_gantt, int row_height)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->row_height != row_height)
    mod_gantt->row_height = row_height;
}

static void td_mod_gantt_set_table (TdModGantt *mod_gantt, gchar *table)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->table != table)
    mod_gantt->table = table;
}

static void td_mod_gantt_set_table_net (TdModGantt *mod_gantt, gchar *table_net)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->table_net != table_net)
    mod_gantt->table_net = table_net;
}

static void td_mod_gantt_set_table_tree (TdModGantt *mod_gantt, gchar *table_tree)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->table_tree != table_tree)
    mod_gantt->table_tree = table_tree;
}

static void td_mod_gantt_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModGantt *mod_gantt;
  mod_gantt = TD_MOD_GANTT (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_mod_gantt_set_name (mod_gantt, GTK_VALUE_STRING (*arg));
      break;
    case ARG_NAME_INTL:
      td_mod_gantt_set_name_intl (mod_gantt, GTK_VALUE_STRING (*arg));
      break;
    case ARG_CUSTOMIZE:
      td_mod_gantt_set_customize (mod_gantt, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_REORDERABLE:
      td_mod_gantt_set_reorderable (mod_gantt, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_SYMBOL_FILE:
      td_mod_gantt_set_symbol_file (mod_gantt, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COLUMN_OID:
      td_mod_gantt_set_column_oid (mod_gantt, GTK_VALUE_INT (*arg));
      break;
    case ARG_LABEL_FORM:
      td_mod_gantt_set_label_form (mod_gantt, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ROW_HEIGHT:
      td_mod_gantt_set_row_height (mod_gantt, GTK_VALUE_INT (*arg));
      break;
    case ARG_TABLE:
      td_mod_gantt_set_table (mod_gantt, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TABLE_NET:
      td_mod_gantt_set_table_net (mod_gantt, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TABLE_TREE:
      td_mod_gantt_set_table_tree (mod_gantt, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_gantt_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModGantt *mod_gantt;
  mod_gantt = TD_MOD_GANTT (object);
  switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = mod_gantt->name;
      break;
    case ARG_NAME_INTL:
      GTK_VALUE_STRING (*arg) = mod_gantt->name_intl;
      break;
    case ARG_CUSTOMIZE:
      GTK_VALUE_BOOL (*arg) = mod_gantt->customize;
      break;
    case ARG_REORDERABLE:
      GTK_VALUE_BOOL (*arg) = mod_gantt->reorderable;
      break;
    case ARG_SYMBOL_FILE:
      GTK_VALUE_STRING (*arg) = mod_gantt->symbol_file;
      break;
    case ARG_COLUMN_OID:
      GTK_VALUE_INT (*arg) = mod_gantt->column_oid;
      break;
    case ARG_LABEL_FORM:
      GTK_VALUE_STRING (*arg) = mod_gantt->label_form;
      break;
    case ARG_ROW_HEIGHT:
      GTK_VALUE_INT (*arg) = mod_gantt->row_height;
      break;
    case ARG_TABLE:
      GTK_VALUE_STRING (*arg) = mod_gantt->table;
      break;
    case ARG_TABLE_NET:
      GTK_VALUE_STRING (*arg) = mod_gantt->table_net;
      break;
    case ARG_TABLE_TREE:
      GTK_VALUE_STRING (*arg) = mod_gantt->table_tree;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_gantt_init (TdModGantt *mod_gantt)
{
  mod_gantt->name = NULL;
  mod_gantt->name_intl = NULL;
  mod_gantt->id = -1;
  mod_gantt->label = NULL;
  mod_gantt->label_form = NULL;
  mod_gantt->label_field = NULL;
  mod_gantt->customize = FALSE;
  mod_gantt->reorderable = FALSE;
  mod_gantt->symbol = NULL;
  mod_gantt->symbol_file = NULL;
  mod_gantt->column_oid = 0;
  mod_gantt->table = NULL;
  mod_gantt->table_net = NULL;
  mod_gantt->table_tree = NULL;

  mod_gantt->widget = NULL;
  mod_gantt->widget_data = NULL;
  mod_gantt->row_height = gdk_string_height (gtk_widget_get_default_style()->font, "0")+18;
  mod_gantt->row_height_link = gdk_string_height (gtk_widget_get_default_style()->font, "0")+10;
  mod_gantt->row_indent = 4;
  mod_gantt->timeruler = NULL;
  mod_gantt->menu_widget = NULL;
  mod_gantt->menu_link_widget = NULL;

  mod_gantt->selected = NULL;
  mod_gantt->selected_parent = NULL;
  mod_gantt->selected_child = NULL;
  mod_gantt->selected_link_parent = NULL;
  mod_gantt->selected_link_child = NULL;
  mod_gantt->selected_link_familly = NULL;
  mod_gantt->link = NULL;

  mod_gantt->dragging = 0;
  mod_gantt->dragging_x = 0;
  mod_gantt->dragging_y = 0;
  mod_gantt->dragging_line1 = NULL;
  mod_gantt->dragging_line2 = NULL;
  mod_gantt->init_x = 0;
  mod_gantt->init_y = 0;
  mod_gantt->panwindow = NULL;
}

static void td_mod_gantt_class_init (TdModGanttClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModGantt::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdModGantt::name_intl", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME_INTL);
  gtk_object_add_arg_type ("TdModGantt::customize", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_CUSTOMIZE);
  gtk_object_add_arg_type ("TdModGantt::reorderable", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_REORDERABLE);
  gtk_object_add_arg_type ("TdModGantt::symbol_file", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_SYMBOL_FILE);
  gtk_object_add_arg_type ("TdModGantt::column_oid", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_COLUMN_OID);
  gtk_object_add_arg_type ("TdModGantt::label_form", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LABEL_FORM);
  gtk_object_add_arg_type ("TdModGantt::row_height", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_ROW_HEIGHT);
  gtk_object_add_arg_type ("TdModGantt::table", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE);
  gtk_object_add_arg_type ("TdModGantt::table_net", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE_NET);
  gtk_object_add_arg_type ("TdModGantt::table_tree", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE_TREE);
  object_class->set_arg = td_mod_gantt_set_arg;
  object_class->get_arg = td_mod_gantt_get_arg;
  klass->set_timeruler = td_mod_gantt_set_timeruler;
  klass->add_symbol = td_mod_gantt_add_symbol;
}

GtkType td_mod_gantt_get_type (void)
{
  static GtkType mod_gantt_type = 0;
  if (!mod_gantt_type)
    {
      static const GtkTypeInfo mod_gantt_info =
      {
  	"TdModGantt", sizeof (TdModGantt), sizeof (TdModGanttClass),
  	(GtkClassInitFunc) td_mod_gantt_class_init,
	(GtkObjectInitFunc) td_mod_gantt_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_gantt_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_gantt_info);
    }
  return mod_gantt_type;
}

/**
 * td_mod_gantt_new:
 * 
 * fr: Cr un nouveau gantt
 *
 * en: Creates a new gantt
 * 
 * Return value: gantt
 **/

GtkObject *td_mod_gantt_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_gantt_get_type()));
}

/**
 * td_mod_gantt_destroy:
 * @mod_gantt: gantt
 * 
 * fr: Dtruit le gantt
 *
 * en: Destroys the gantt
 **/

void td_mod_gantt_destroy (TdModGantt *mod_gantt)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  td_timeruler_destroy (TD_TIMERULER (mod_gantt->timeruler));
  td_panwindow_destroy (TD_PANWINDOW (mod_gantt->panwindow));
  gtk_object_destroy (GTK_OBJECT (mod_gantt));
}

/**
 * td_mod_gantt_show:
 * @mod_gantt: gantt
 * 
 * fr: Affiche le gantt
 *
 * en: Displays the gantt
 **/

void td_mod_gantt_show (TdModGantt *mod_gantt)
{
  void (*symbol)();
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (g_list_length (gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data))->item_list)==0)
    {
      (gpointer*) symbol = td_app_mod_data_symbol (mod_gantt->id, "plugins_refresh", TRUE);
      if (symbol)
	symbol (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_gantt->id)), mod_gantt);
    }
  /* FIXME: problme avec l'chelle du temps : + tards */
  gtk_widget_queue_draw (TD_TIMERULER (mod_gantt->timeruler)->widget); /* FIXME: sans effet */ 
}

/**
 * td_mod_gantt_hide:
 * @mod_gantt: gantt
 * 
 * fr: Cache le gantt
 *
 * en: Hides the gantt
 **/

void td_mod_gantt_hide (TdModGantt *mod_gantt)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  td_timeruler_hide (TD_TIMERULER (mod_gantt->timeruler));
  td_panwindow_hide (TD_PANWINDOW (mod_gantt->panwindow));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_mod_gantt_set_timeruler:
 * @mod_gantt: gantt
 * @timeruler: time ruler
 *
 * fr: Affecte la rgle du temps au gantt
 *
 * en: Allocates the time ruler to gantt
 **/

void td_mod_gantt_set_timeruler (TdModGantt *mod_gantt, GtkObject *timeruler)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (mod_gantt->timeruler != timeruler)
    mod_gantt->timeruler = timeruler;
}

/**
 * td_mod_gantt_add_symbol:
 * @mod_gantt: gantt
 * @symbol: symbol
 *
 * fr: Ajoute le symbole au gantt
 *
 * en: Adds the symbol to gantt
 **/

void td_mod_gantt_add_symbol (TdModGantt *mod_gantt, GtkObject *symbol)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  mod_gantt->symbol = g_list_append (mod_gantt->symbol, symbol);
}

/**
 * td_mod_gantt_add_label_field:
 * @mod_gantt: gantt
 * @label_field: field
 *
 * fr: Ajoute un champs  l'etiquette
 *
 * en: Adds the field to label
 **/

void td_mod_gantt_add_label_field (TdModGantt *mod_gantt, gchar *label_field)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  mod_gantt->label_field = g_list_append (mod_gantt->label_field, label_field);
}

/*****************************************************************************/
/*** Interface */
/*****************************************************************************/

/**
 * td_mod_gantt_create:
 * @mod_gantt: gantt
 * @mod: module
 * 
 * fr: Cr l'interface du composant du module
 *
 * en: Creates the interface of component of module
 **/

void td_mod_gantt_create (TdModGantt *mod_gantt, GtkObject *mod)
{
  void (*symbol)();
  GtkWidget *frame;
  GnomeCanvasGroup *root;
  GtkWidget *vbox1;
  GtkWidget *vbox2;
  GtkWidget *pan_arrow;
  GtkWidget *pan_button;
  GtkWidget *vscrollbar;
  GtkWidget *hscrollbar;
  GtkWidget *menu_arrow;
  GtkWidget *menu_button;
  GList *field;
  GdkFont *font;
  int i;
  gchar *txt_tmp;
  GtkObject *flower;
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));

  /*** Champs - Fields */
  field = td_database_field (g_strdup_printf ("SELECT * FROM %s;", mod_gantt->table));
  for (i=0; i<g_list_length (field); i++)
    if (!strcmp ((gchar*) (g_list_nth_data (field, i)), "td_id"))
      {
	gtk_object_set (GTK_OBJECT (mod_gantt), "column_oid", i, NULL);
	break;
      }
  field = td_mod_interface_field (TD_MOD (mod));
  txt_tmp = NULL;
  for (i=0; i<g_list_length (field); i++)
    {
      td_mod_gantt_add_label_field (mod_gantt, TD_FIELD (g_list_nth_data (field, i))->table_field);
      if (txt_tmp)
	txt_tmp = g_strdup_printf ("%s%s", txt_tmp, td_field_property_value (g_list_nth_data (field, i), "label"));
      else
	txt_tmp = g_strdup_printf ("%s", td_field_property_value (g_list_nth_data (field, i), "label"));
    }
  gtk_object_set (GTK_OBJECT (mod_gantt), "label_form", txt_tmp, NULL);

  /*** Bote - Box */
  mod_gantt->id = TD_MOD (mod)->id;
  mod_gantt->menu_widget = TD_MOD (mod)->menu_widget;
  mod_gantt->menu_link_widget = TD_MOD (mod)->menu_link_widget;
  mod_gantt->widget = gtk_table_new (2, 3, FALSE);
  gtk_widget_show (mod_gantt->widget);
  mod_gantt->widget_data = gnome_canvas_new();

  /*** Rgle du temps - Time ruler */
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_table_attach (GTK_TABLE (mod_gantt->widget), vbox1, 0, 1, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_table_attach (GTK_TABLE (mod_gantt->widget), vbox2, 1, 2, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
  td_timeruler_set_canvas (TD_TIMERULER (mod_gantt->timeruler), mod_gantt->widget_data);
  td_timeruler_create (TD_TIMERULER (mod_gantt->timeruler), vbox1, vbox2);

  /*** Gantt */
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 1);
  gtk_table_attach (GTK_TABLE (mod_gantt->widget), frame, 0, 1, 1, 2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL | GTK_SHRINK), (GtkAttachOptions) (GTK_EXPAND | GTK_FILL | GTK_SHRINK), 0, 0);
  gtk_widget_show (frame);
  gtk_widget_push_visual (gdk_imlib_get_visual());
  gtk_widget_push_colormap (gdk_imlib_get_colormap());
  root = gnome_canvas_root (GNOME_CANVAS (mod_gantt->widget_data));
  gtk_widget_pop_colormap();
  gtk_widget_pop_visual();
  gnome_canvas_set_scroll_region (GNOME_CANVAS (mod_gantt->widget_data), 0, 0, 10000, 10000);
  gtk_container_add (GTK_CONTAINER (frame), mod_gantt->widget_data);
  gtk_widget_show (mod_gantt->widget_data);
  GTK_WIDGET_SET_FLAGS (mod_gantt->widget_data, GTK_CAN_FOCUS);
  gtk_widget_grab_focus (mod_gantt->widget_data);
  gtk_signal_connect (GTK_OBJECT (mod_gantt->widget_data), "button_press_event", GTK_SIGNAL_FUNC (td_mod_gantt_button_press), mod_gantt);

  /*** Pan */
  vscrollbar = gtk_vscrollbar_new (GTK_LAYOUT (mod_gantt->widget_data)->vadjustment);
  gtk_widget_show (vscrollbar);
  gtk_table_attach (GTK_TABLE (mod_gantt->widget), vscrollbar, 1, 2, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_signal_connect (GTK_OBJECT (GTK_LAYOUT (mod_gantt->widget_data)->vadjustment), "changed", GTK_SIGNAL_FUNC (td_mod_gantt_scrollbar_changed), mod_gantt);
  gtk_signal_connect (GTK_OBJECT (GTK_LAYOUT (mod_gantt->widget_data)->vadjustment), "value_changed", GTK_SIGNAL_FUNC (td_mod_gantt_scrollbar_changed), mod_gantt);
  /*** FIXME: hscrollbar : +tards - hscrollbar : this night */
  hscrollbar = gtk_hscrollbar_new (GTK_LAYOUT (mod_gantt->widget_data)->hadjustment);
  gtk_widget_hide (hscrollbar);
  gtk_table_attach (GTK_TABLE (mod_gantt->widget), hscrollbar, 0, 1, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_signal_connect (GTK_OBJECT (GTK_LAYOUT (mod_gantt->widget_data)->hadjustment), "changed", GTK_SIGNAL_FUNC (td_mod_gantt_scrollbar_changed), mod_gantt);
  gtk_signal_connect (GTK_OBJECT (GTK_LAYOUT (mod_gantt->widget_data)->hadjustment), "value_changed", GTK_SIGNAL_FUNC (td_mod_gantt_scrollbar_changed), mod_gantt);
  pan_button = gtk_button_new();
  gtk_button_set_relief (GTK_BUTTON (pan_button), GTK_RELIEF_NONE);
  gtk_widget_hide (pan_button);
  gtk_widget_set_usize (pan_button, 18, 18);
  gtk_table_attach (GTK_TABLE (mod_gantt->widget), pan_button, 1, 2, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
  mod_gantt->panwindow = td_panwindow_new();
  td_panwindow_set_canvas (TD_PANWINDOW (mod_gantt->panwindow), mod_gantt->widget_data);
  gtk_signal_connect (GTK_OBJECT (pan_button), "button_press_event", GTK_SIGNAL_FUNC (td_panwindow_create), mod_gantt->panwindow);
  pan_arrow = gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_IN);
  gtk_widget_show (pan_arrow);
  gtk_container_add (GTK_CONTAINER (pan_button), pan_arrow);

  /*** Symboles - Symbols */
  /*** FIXME: pour le momment dans le greffons : +tards - At present in the plug-in : this night */
  (gpointer*) symbol = td_app_mod_data_symbol (mod_gantt->id, "plugins_symbol_def", TRUE);
  if (symbol)
    symbol (mod_gantt);
}

/**
 * td_mod_gantt_button_press:
 * @widget: canvas widget
 * @event: event button
 * @mod_gantt: gantt
 * 
 * fr: Evnement 'button_press' du cavenas
 *
 * en: Event 'button_press' of canvas
 **/

void td_mod_gantt_button_press (GtkWidget *widget, GdkEventButton *event, TdModGantt *mod_gantt)
{
  GnomeCanvasGroup *root;
  GnomeCanvasItem *node;
  GdkEventButton *bevent;
  int i, j;
  double  x, y;
  gchar *id_item;
  gchar *id_parent;
  gchar *id_child;
  gchar *txt_tmp1;
  gchar *txt_tmp2;
  GList *list_familly;
  bevent = (GdkEventButton*) event;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data));

  /*** Slection - Selection */
  TD_FLAG_NO_REFRESH_NODE = TRUE;
  gnome_canvas_window_to_world (GNOME_CANVAS (widget), bevent->x, bevent->y, &x, &y);
  node = gnome_canvas_get_item_at (GNOME_CANVAS (widget), x, y);
  TD_MOD_GANTT (mod_gantt)->init_x = x;
  TD_MOD_GANTT (mod_gantt)->init_y = y;

  /*** Poigne - Handle */
  if ((node) && (node != GNOME_CANVAS_ITEM (root)) && (node->parent != GNOME_CANVAS_ITEM (root)) && (strstr (gtk_object_get_user_data (GTK_OBJECT (node->parent)), "handle")))
    return;

  /*** Mise  zro - Clear */
  TD_FLAG_NO_REFRESH_NODE = TRUE;
  CURRENT_ROW = NULL;
  CURRENT_ID = 0;
  if (mod_gantt->selected)
    {
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (mod_gantt->selected)->item_list, 0),
			     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
			     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
			     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (mod_gantt->selected)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_NORMAL], NULL);
    }
  mod_gantt->selected = NULL;
  if (mod_gantt->selected_parent)
    for (i=0; i<g_list_length (mod_gantt->selected_parent); i++)
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (g_list_nth_data (mod_gantt->selected_parent, i))->item_list, 0),
			     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
			     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
			     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);
  mod_gantt->selected_parent = NULL;
  if (mod_gantt->selected_child)
    for (i=0; i<g_list_length (mod_gantt->selected_child); i++)
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (g_list_nth_data (mod_gantt->selected_child, i))->item_list, 0),
			     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
			     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
			     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);
  mod_gantt->selected_child = NULL;
  if (mod_gantt->selected_link_parent)
    for (i=0; i<g_list_length (mod_gantt->selected_link_parent); i++)
      gnome_canvas_item_set (g_list_nth_data (mod_gantt->selected_link_parent, i), 
			     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL],
			     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL],
			     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL], NULL);
  mod_gantt->selected_link_parent = NULL;
  if (mod_gantt->selected_link_child)
    for (i=0; i<g_list_length (mod_gantt->selected_link_child); i++)
      gnome_canvas_item_set (g_list_nth_data (mod_gantt->selected_link_child, i),
			     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL],
			     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL],
			     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL], NULL);
  mod_gantt->selected_link_child = NULL;

  /*** Rien - Nothing */
  if (!node)
    {

      /*** Editeur des proprits et menu - Properties editor and menu */
      td_mod_refresh_bench (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_gantt->id)), GTK_OBJECT (mod_gantt));
      td_mod_refresh_etabliste (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_gantt->id)), GTK_OBJECT (mod_gantt));
      td_mod_refresh_menu (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_gantt->id)), GTK_OBJECT (mod_gantt));
      TD_FLAG_NO_REFRESH_NODE = FALSE;

      /*** Menu item */
      if (gtdk_mouse_event (bevent, TD_EVENT_MOUSE_MENU_ITEM))
	gtk_menu_popup (GTK_MENU (mod_gantt->menu_widget), NULL, NULL, NULL, NULL, bevent->button, bevent->time);

      /*** Menu principal - Main menu */
      if (gtdk_mouse_event (bevent, TD_EVENT_MOUSE_MENU_MAIN))
	gnome_popup_menu_do_popup (TD_APP (APP)->menu_main, NULL, NULL, bevent, NULL);
      return;
    }

  /*** Item */
  if (!GNOME_IS_CANVAS_LINE (node))
    {
      CURRENT_ID = atoi (gtk_object_get_user_data (GTK_OBJECT (node->parent)));
      mod_gantt->selected = GNOME_CANVAS_GROUP (node->parent);
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (mod_gantt->selected)->item_list, 0),
			     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_SELECTED],
			     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_SELECTED],
			     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_SELECTED], NULL);
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (mod_gantt->selected)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_SELECTED], NULL);
    }

  /*** Etablis et menu - Benchs and menu */
  if (GNOME_IS_CANVAS_LINE (node))
    {
      td_mod_refresh_bench (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_gantt->id)), GTK_OBJECT (mod_gantt));
      td_mod_refresh_etabliste (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_gantt->id)), GTK_OBJECT (mod_gantt));
      td_mod_refresh_menu (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_gantt->id)), GTK_OBJECT (mod_gantt));
      td_database_set_current (g_strdup_printf ("SELECT * FROM %s WHERE (td_id = %d) AND (td_id_parent = %d);", mod_gantt->table_net, CURRENT_ID, CURRENT_ID_PARENT));
    }
  else
    {
      td_database_set_current (g_strdup_printf ("SELECT * FROM %s WHERE td_id = %d;", mod_gantt->table, CURRENT_ID));
      td_mod_refresh_bench (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_gantt->id)), GTK_OBJECT (mod_gantt));
      td_mod_refresh_etabliste (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_gantt->id)), GTK_OBJECT (mod_gantt));
      td_mod_refresh_menu (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_gantt->id)), GTK_OBJECT (mod_gantt));
    }
  TD_FLAG_NO_REFRESH_NODE = FALSE;

  /*** Liens - Links */
  if (GNOME_IS_CANVAS_LINE (node))
    {
      CURRENT_ID_PARENT = atoi (td_strsplit (gtk_object_get_user_data (GTK_OBJECT (node)), ",", 0));
      CURRENT_ID = atoi (td_strsplit (gtk_object_get_user_data (GTK_OBJECT (node)), ",", 1));
      mod_gantt->selected_link_parent = g_list_append (mod_gantt->selected_link_parent, node);
      gnome_canvas_item_set (node, 
			     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_SELECTED],
			     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_SELECTED],
			     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_SELECTED], NULL);
    }
  else    
    {
      id_parent = g_strdup_printf (",%d", CURRENT_ID);
      id_child = g_strdup_printf ("%d,", CURRENT_ID);
      for (i=0; i<g_list_length (root->item_list); i++)
	{
	  id_item = gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, i)));

	  /*** Parents */
	  if ((!id_item) || (!strstr (id_item, ",")))
	    continue;
	  if (strstr (id_item, id_parent))
	    {
	      gnome_canvas_item_set (g_list_nth_data (root->item_list, i),
				     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_PARENT],
				     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_PARENT],
				     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_PARENT], NULL);
	      mod_gantt->selected_link_parent = g_list_append (mod_gantt->selected_link_parent, GTK_OBJECT (g_list_nth_data (GNOME_CANVAS_GROUP (root)->item_list, i)));
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (gtdk_canvas_link_get_parent (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), g_list_nth_data (root->item_list, i)))->item_list, 0),
				     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_PARENT],
				     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_PARENT],
				     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_PARENT], NULL);
	      mod_gantt->selected_parent = g_list_append (mod_gantt->selected_parent, GTK_OBJECT (gtdk_canvas_link_get_parent (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), g_list_nth_data (root->item_list, i))));
	      continue;
	    }

	  /*** Enfant - Childs */
	  if (strstr (id_item, id_child))
	    {
	      gnome_canvas_item_set (g_list_nth_data (root->item_list, i),
				     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_CHILD],
				     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_CHILD],
				     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_CHILD], NULL);
	      mod_gantt->selected_link_child = g_list_append (mod_gantt->selected_link_child, GTK_OBJECT (g_list_nth_data (GNOME_CANVAS_GROUP (root)->item_list, i)));
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (gtdk_canvas_link_get_child (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), g_list_nth_data (root->item_list, i)))->item_list, 0),
				     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_CHILD],
				     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_CHILD],
				     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_CHILD], NULL);
	      mod_gantt->selected_child = g_list_append (mod_gantt->selected_child, GTK_OBJECT (gtdk_canvas_link_get_child (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), g_list_nth_data (root->item_list, i))));
	    }
	}

      /*** Famille - Familly */
/*        printf ("*** Debug : Famille \n");  */
/*        list_familly = td_datatable_tree_childs ("td_id", CURRENT_ID, TD_MOD_GANTT (mod_gantt)->table, TD_MOD_GANTT (mod_gantt)->table_tree); */
/*        mod_gantt->selected_link_familly = NULL; */
/*        for (i=0; i<g_list_length (root->item_list); i++) */
/*  	{ */
/*  	  id_item = gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, i))); */
/*  	  printf ("*** Debug : selected_link_familly : %s \n", id_item);  */
/*  	  if (!GNOME_IS_CANVAS_LINE (node)) */
/*  	    continue; */

/*  	  id_item = gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, i))); */
/*  	  printf ("*** Debug : selected_link_familly : %s \n", id_item);  */
	  
/*  	  for (j=0; j<g_list_length (list_familly); j++) */
/*  	    if (strstr (id_item, (gchar*) g_list_nth_data (list_familly, i))) */
/*  	      { */
/*  		printf ("*** Debug : selected_link_familly : dedans : %s \n", id_item);  */
/*  		mod_gantt->selected_link_familly = g_list_append (mod_gantt->selected_link_familly, (g_list_nth_data (root->item_list, i))); */
/*  		break; */
/*  	      } */
/*  	} */
    }
 
  /*** Menu item - Item menu */
  if (gtdk_mouse_event (bevent, TD_EVENT_MOUSE_MENU_ITEM))
    {
      if (GNOME_IS_CANVAS_LINE (node))
	{
	  if (mod_gantt->menu_link_widget)
	    gtk_menu_popup (GTK_MENU (mod_gantt->menu_link_widget), NULL, NULL, NULL, NULL, bevent->button, bevent->time);
	}
      else
	gtk_menu_popup (GTK_MENU (mod_gantt->menu_widget), NULL, NULL, NULL, NULL, bevent->button, bevent->time);
    }

  /*** Menu principal - Main menu */
  if (gtdk_mouse_event (bevent, TD_EVENT_MOUSE_MENU_MAIN))
    gnome_popup_menu_do_popup (TD_APP (APP)->menu_main, NULL, NULL, bevent, NULL);
}

/**
 * td_mod_gantt_scrollbar_changed:
 * @adj: adjustement of scrollbar of canvas
 * @mod_gantt: gantt
 * 
 * fr: Evnement 'value_changed' d'un des ascenseurs du cavenas
 *
 * en: Event 'value_changed' of scrollbar of canvas
 **/

void td_mod_gantt_scrollbar_changed (GtkAdjustment *adj, TdModGantt *mod_gantt)
{
  double x, y, width, height;
  GnomeCanvas *gantt = GNOME_CANVAS (mod_gantt->widget_data);
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  /*** FIXME: remplacer 600 et 460 par les paramtres : +tards - changing 600 and 460 by parameters : this night */
  x = GTK_ADJUSTMENT (GTK_LAYOUT (gantt)->hadjustment)->value*(600/GTK_ADJUSTMENT (GTK_LAYOUT (gantt)->hadjustment)->upper);
  y = GTK_ADJUSTMENT (GTK_LAYOUT (gantt)->vadjustment)->value*(460/GTK_ADJUSTMENT (GTK_LAYOUT (gantt)->vadjustment)->upper);
  width = GTK_ADJUSTMENT (GTK_LAYOUT (gantt)->hadjustment)->page_size*(600/GTK_ADJUSTMENT (GTK_LAYOUT (gantt)->hadjustment)->upper);
  height = GTK_ADJUSTMENT (GTK_LAYOUT (gantt)->vadjustment)->page_size*(460/GTK_ADJUSTMENT (GTK_LAYOUT (gantt)->vadjustment)->upper);
  td_panwindow_scrollbar_changed (TD_PANWINDOW (mod_gantt->panwindow));
}

void td_mod_gantt_set_scrollbar_region (TdModGantt *mod_gantt, int y)
{
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  if (GTK_WIDGET (TD_MOD_GANTT (mod_gantt)->widget_data)->allocation.height<y)
    gnome_canvas_set_scroll_region (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), 0, 0,
				    10000,
				    y);
/*  				    GTK_WIDGET (TD_MOD_GANTT (mod_gantt)->widget_data)->allocation.width, */
/*  				    y); */
  else
    gnome_canvas_set_scroll_region (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), 0, 0,
				    10000,
				    GTK_WIDGET (TD_MOD_GANTT (mod_gantt)->widget_data)->allocation.height);
/*  				    GTK_WIDGET (TD_MOD_GANTT (mod_gantt)->widget_data)->allocation.width, */
/*  				    GTK_WIDGET (TD_MOD_GANTT (mod_gantt)->widget_data)->allocation.height); */
}

/**
 * td_mod_gantt_draw_link:
 * @mod_gantt: gantt
 * @link: link
 * @node_parent: parent
 * @node: node
 * 
 * fr: Redessine le lien
 *
 * en: Redraws the link
 **/

void td_mod_gantt_draw_link (TdModGantt *mod_gantt, GnomeCanvasItem *link, GnomeCanvasItem *node_parent, GnomeCanvasItem *node)
{
  GnomeCanvas *canvas;
  GnomeCanvasPoints *points;
  double *coords;
  double x1, y1, x2, y2;
  int indent;
  g_return_if_fail (mod_gantt != NULL);
  g_return_if_fail (TD_IS_MOD_GANTT (mod_gantt));
  canvas=GNOME_CANVAS (mod_gantt->widget_data);

  /*** Coordonnes - Coordinates */
  if (!node_parent)
    {
      node_parent = gtdk_canvas_link_get_parent (canvas, link);
      if ((!node_parent) || (GNOME_CANVAS_GROUP (node_parent) == gnome_canvas_root (canvas)))
	return;
    }
  if (!node)
    {
      node = gtdk_canvas_link_get_child (canvas, link);
      if ((!node) || (GNOME_CANVAS_GROUP (node) == gnome_canvas_root (canvas)))
	return;
    }
  if (GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (node)->item_list, 0))->x2>7)
    indent=mod_gantt->row_indent;
  else
    indent=0;

  /* Chevauchement - Overlapping */
  if (((gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node_parent), 0)+GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (node_parent)->item_list, 0))->x2)>=gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0)+indent) &&
      (gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node_parent), 0)<=gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0)+indent))
    {

      /*** Bas - Down */
      if (gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node_parent), 0)<gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node), 0))
	{
	  points = gnome_canvas_points_new (2);
	  points->coords[0] = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0)+indent;
	  points->coords[1] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node_parent), 0)+mod_gantt->row_height_link;
	  points->coords[2] = points->coords[0];
	  points->coords[3] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node), 0)+(TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1]);
	  gnome_canvas_item_set (link, "points", points, NULL);
	  gnome_canvas_points_free (points);
	  return;
	}

      /*** Haut - Up */
      points = gnome_canvas_points_new (2);
      points->coords[0] = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0)+indent;
      points->coords[1] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node_parent), 0)+mod_gantt->row_height_link;
      points->coords[2] = points->coords[0];
      points->coords[3] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node), 0)+mod_gantt->row_height-(TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1])-2;
      gnome_canvas_item_set (link, "points", points, NULL);
      gnome_canvas_points_free (points);
      return;
    }

  /*** Aprs - After */
  if (gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node_parent), 0)<gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0))
    {

      /*** Bas - Down */
      if (gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node_parent), 0)<gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node), 0))
	{
	  points = gnome_canvas_points_new (3);
	  points->coords[0] = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node_parent), 0)+GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (node_parent)->item_list, 0))->x2;
	  points->coords[1] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node_parent), 0)+mod_gantt->row_height_link;
	  points->coords[2] = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0)+indent;
	  points->coords[3] = points->coords[1];
	  points->coords[4] = points->coords[2];
	  points->coords[5] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node), 0)+(TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1]);
	  gnome_canvas_item_set (link, "points", points, NULL);
	  gnome_canvas_points_free (points);
	  return;
	}

      /*** Haut - Up */
      points = gnome_canvas_points_new (3);
      points->coords[0] = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node_parent), 0)+GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (node_parent)->item_list, 0))->x2;
      points->coords[1] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node_parent), 0)+mod_gantt->row_height_link;
      points->coords[2] = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0)+indent;
      points->coords[3] = points->coords[1];
      points->coords[4] = points->coords[2];
      points->coords[5] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node), 0)+mod_gantt->row_height-(TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1])-2;
      gnome_canvas_item_set (link, "points", points, NULL);
      gnome_canvas_points_free (points);
      return;
    }

  /*** Avant - Before */
  if (gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node_parent), 0)>gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0))
    {

      /*** Bas - Down */
      if (gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node_parent), 0)<gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node), 0))
	{
	  points = gnome_canvas_points_new (3);
	  points->coords[0] = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node_parent), 0);
	  points->coords[1] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node_parent), 0)+mod_gantt->row_height_link;
	  points->coords[2] = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0)+indent;
	  points->coords[3] = points->coords[1];
	  points->coords[4] = points->coords[2];
	  points->coords[5] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node), 0)+(TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1]);
	  gnome_canvas_item_set (link, "points", points, NULL);
	  gnome_canvas_points_free (points);
	  return;
	}

      /*** Haut - Up */
      points = gnome_canvas_points_new (3);
      points->coords[0] = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node_parent), 0);
      points->coords[1] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node_parent), 0)+mod_gantt->row_height_link;
      points->coords[2] = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0)+indent;
      points->coords[3] = points->coords[1];
      points->coords[4] = points->coords[2];
      points->coords[5] = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node), 0)+mod_gantt->row_height-(TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1])-2;
      gnome_canvas_item_set (link, "points", points, NULL);
      gnome_canvas_points_free (points);
      return;
    }
}

/**
 * td_mod_gantt_link_correct:
 * @link: link
 * 
 * fr: Corrige la gomtrie du lien
 *
 * en: Corrects the link geometry
 **/

void td_mod_gantt_link_correct (GnomeCanvasLine *link)
{
  GnomeCanvasPoints *points;
  int i;
  /* BIDOUILLE: correctif suite  un bug de la libgnomeui sur les flches du cavenas - correction for a bug the arrow's canvas of the libgnomeui */
  points = gnome_canvas_points_new (link->num_points);
  for (i=0; i<link->num_points*2; i=i+2)
    {
      points->coords[i] = link->coords[i];
      points->coords[i+1] = link->coords[i+1];
    }
  if (points->coords[2*link->num_points-1] - points->coords[2*link->num_points-3]>0)
    points->coords[2*link->num_points-1] = td_floor (points->coords[2*link->num_points-1], gdk_string_height (gtk_widget_get_default_style()->font, "0")+18)+gtdk_canvas_arrow_y (link);
  else
    points->coords[2*link->num_points-1] = td_floor (points->coords[2*link->num_points-1]+gdk_string_height (gtk_widget_get_default_style()->font, "0")+18, gdk_string_height (gtk_widget_get_default_style()->font, "0")+18)+gtdk_canvas_arrow_y (link)-2;
  gnome_canvas_item_set (GNOME_CANVAS_ITEM (link), "points", points, NULL);
  gnome_canvas_points_free (points);
}
