/*****************************************************************************/
/* td_mod_etabliste.h : Objet Gtk+
 * td_mod_etabliste.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_ETABLISTE (td_mod_etabliste_get_type())
#define TD_MOD_ETABLISTE(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_ETABLISTE, TdModEtabliste))
#define TD_MOD_ETABLISTE_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_ETABLISTE, TdModEtablisteClass))
#define TD_IS_MOD_ETABLISTE(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_ETABLISTE))
#define TD_IS_MOD_ETABLISTE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_ETABLISTE))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdModEtabliste TdModEtabliste;
typedef struct _TdModEtablisteClass TdModEtablisteClass;

struct _TdModEtabliste
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  GtkSelectionMode selection_mode; /*** Nom - Name */
  gchar *table_field; /*** Nom du champs - Field name */
  GtkWidget *widget; /*** Widget */
  GtkWidget *widget_parent; /*** Container du widget - Container of widget */
  gchar *query_refresh; /*** Requte de rafrachissement - Query of refresh */
  gchar *query_set; /*** Requte d'affectation  - Query of allocation */
  gchar *query_unset; /*** Requte de libration  - Query of free */
  gchar *query_visible; /*** Requte de visibilit - Query of visisbility */
  gchar *list_query; /*** Requte de la liste - Query of the list */
  gchar *list_type; /*** Type de liste - Type of list */
  GtkObject *dico; /*** Dictionnaire - Dictionary */
};

struct _TdModEtablisteClass
{
  GtkObjectClass parent_class;
  void (*set_widget) (TdModEtabliste *mod_etabliste, GtkWidget *widget, GtkWidget *widget_parent);
  void (*set_dico) (TdModEtabliste *db_mod_etabliste, GtkObject *dico);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_mod_etabliste_set_name (TdModEtabliste *mod_etabliste, gchar *name);
static void td_mod_etabliste_set_selection_mode (TdModEtabliste *mod_etabliste, GtkSelectionMode selection_mode);
static void td_mod_etabliste_set_table_field (TdModEtabliste *mod_etabliste, gchar *table_field);
static void td_mod_etabliste_set_query_refresh (TdModEtabliste *mod_etabliste, gchar *query_refresh);
static void td_mod_etabliste_set_query_set (TdModEtabliste *mod_etabliste, gchar *query_set);
static void td_mod_etabliste_set_query_unset (TdModEtabliste *mod_etabliste, gchar *query_unset);
static void td_mod_etabliste_set_query_visible (TdModEtabliste *mod_etabliste, gchar *query_visible);
static void td_mod_etabliste_set_list_query (TdModEtabliste *mod_etabliste, gchar *list_query);
static void td_mod_etabliste_set_list_type (TdModEtabliste *mod_etabliste, gchar *list_type);
static void td_mod_etabliste_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_etabliste_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_etabliste_init (TdModEtabliste *mod_etabliste);
static void td_mod_etabliste_class_init (TdModEtablisteClass *klass);
GtkType td_mod_etabliste_get_type (void);
GtkObject *td_mod_etabliste_new (void);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_mod_etabliste_set_widget (TdModEtabliste *mod_etabliste, GtkWidget *widget, GtkWidget *widget_parent);
void td_mod_etabliste_set_dico (TdModEtabliste *mod_etabliste, GtkObject *dico);
