/*****************************************************************************/
/* td_mod.h : Objet Gtk+
 * td_mod.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_MOD (td_mod_get_type())
#define TD_MOD(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD, TdMod))
#define TD_MOD_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD, TdModClass))
#define TD_IS_MOD(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD))
#define TD_IS_MOD_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdMod TdMod;
typedef struct _TdModClass TdModClass;

struct _TdMod
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  gchar *name_intl; /*** Nom international - International name */
  gchar *group; /*** Groupe - Group */
  int id; /*** Identificateur du module - Module identifier */
  gchar *fields; /*** Champs - Fields */
  GList *property; /*** Proprits - Properties */
  gboolean modified; /*** Drapeau de modifications non enregistres - Flag for unsaved changes */

  GList *child; /*** Composants - Component */
  GList *table; /*** Tables */
  GtkWidget *palette_button; /*** Bouton de la palette - Palette button */
  GList *bench; /*** Etabli - Bench */
  GtkWidget *bench_vbox; /*** Container des onglets de l'tabli - Container of notebook of bench */
  GList *etabliste; /*** Etabliste - Bench of lists */
  GtkWidget *etabliste_vbox; /*** Container des onglets de l'tabliste - Container of notebook of bench of lists */
  GList *menu; /*** Menu */
  GtkWidget *menu_widget; /*** Widget menu - Menu widget */
  GList *menu_link; /*** Menu des liens - Links menu */
  GtkWidget *menu_link_widget; /*** Widget menu des liens - Links menu widget */

  GtkWidget *window; /*** Fentre - Window */
  GtkWidget *window_toolbar; /*** Barre d'outils - Toolbar */
  GtkWidget *window_statusbar; /*** Barre de statut - Statusbar  */
  GtkWidget *window_notebook; /*** Onglets - Notebook */

  GtkObject *about; /*** Description */
  GtkObject *presto_browser; /*** Interface d'aide - Help interface */
  GtkObject *custom_browser; /*** Interface de personnalisation - Customize interface */
  GtkWidget *custom_notebook; /*** Onglets de l'interface de personnalisation - Notebook of customize interface */
  GtkWidget *custom_tree; /*** Arbre de l'interface de personnalisation - Tree of customize interface */
  GList *custom_widget; /*** Widgets de l'interface de personnalisation - Widgets of customize interface */
};

struct _TdModClass
{
  GtkObjectClass parent_class;
  void (*add_property) (TdMod *mod, GtkObject *property);
  void (*add_child) (TdMod *mod, GtkObject *child);
  void (*add_table) (TdMod *mod, GtkObject *table);
  void (*add_bench) (TdMod *mod, GtkObject *bench);
  void (*add_etabliste) (TdMod *mod, GtkObject *etabliste);
  void (*add_menu) (TdMod *mod, GtkObject *menu);
  void (*add_menu_link) (TdMod *mod, GtkObject *menu_link);
  void (*set_window_toolbar) (TdMod *mod, GtkWidget *window_toolbar);
  void (*set_window_statusbar) (TdMod *mod, GtkWidget *window_statusbar);
  void (*set_about) (TdMod *mod, GtkObject *about);
  void (*add_custom_widget) (TdMod *mod, GtkWidget *custom_widget);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_mod_set_name (TdMod *mod, gchar *name);
static void td_mod_set_name_intl (TdMod *mod, gchar *name_intl);
static void td_mod_set_group (TdMod *mod, gchar *group);
static void td_mod_set_id (TdMod *mod, int id);
static void td_mod_set_fields (TdMod *mod, gchar *fields);
static void td_mod_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_init (TdMod *mod);
static void td_mod_class_init (TdModClass *klass);
GtkType td_mod_get_type (void);
GtkObject *td_mod_new (void);
void td_mod_destroy (TdMod *mod);
void td_mod_show (TdMod *mod);
void td_mod_hide (TdMod *mod);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_mod_add_property (TdMod *mod, GtkObject *property);
void td_mod_add_child (TdMod *mod, GtkObject *child);
void td_mod_add_table (TdMod *mod, GtkObject *table);
void td_mod_add_bench (TdMod *mod, GtkObject *bench);
void td_mod_add_etabliste (TdMod *mod, GtkObject *etabliste);
void td_mod_add_menu (TdMod *mod, GtkObject *menu);
void td_mod_add_menu_link (TdMod *mod, GtkObject *menu_link);
void td_mod_set_window_toolbar (TdMod *mod, GtkWidget *window_toolbar);
void td_mod_set_window_statusbar (TdMod *mod, GtkWidget *window_statusbar);
void td_mod_set_about (TdMod *mod, GtkObject *about);
void td_mod_add_custom_widget (TdMod *mod, GtkWidget *custom_widget);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
void td_mod_create (TdMod *mod);
void td_mod_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, gint page_num, TdMod *mod);
void td_mod_modified (TdMod *mod);
void td_mod_unmodified (TdMod *mod);
void td_mod_custom_show (GtkObject *mod);
void td_mod_presto_show (GtkObject *mod);

/*****************************************************************************/
/*** Base de donnes - Database */
/*****************************************************************************/
void td_mod_refresh_child (TdMod *mod);
void td_mod_refresh_bench (TdMod *mod, GtkObject *mod_child);
void td_mod_refresh_etabliste (TdMod *mod, GtkObject *mod_child);
int td_mod_action_bench_real (gpointer data);
void td_mod_action_bench (GtkWidget *widget, TdMod *mod);
void td_mod_action_etabliste_set (GtkWidget *widget, gint row, gint column, GdkEvent *event, TdMod *mod);
void td_mod_action_etabliste_unset (GtkWidget *widget, gint row, gint column, GdkEvent *event, TdMod *mod);
void td_mod_refresh_menu (TdMod *mod, GtkObject *mod_child);
void td_mod_action_menu (GtkWidget *widget, TdMod *mod);
void td_mod_action_menu_link (GtkWidget *widget, TdMod *mod);

/*****************************************************************************/
/*** Personnalisation et paramtrage - Customize and parameters */
/*****************************************************************************/
gchar *td_mod_custom_value (TdMod *mod, gchar *category, gchar *group, gchar *option);
GList *td_mod_interface_field (TdMod *mod);
GList *td_mod_bench_field (TdMod *mod);
GList *td_mod_etabliste_field (TdMod *mod);
