/*****************************************************************************/
/* td_function.h : Objet Gtk+
 * td_function.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <parser.h>
#include <tree.h>
/*  #include <libxml/parser.h> */
/*  #include <libxml/tree.h> */

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_FUNCTION (td_function_get_type())
#define TD_FUNCTION(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_FUNCTION, TdFunction))
#define TD_FUNCTION_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_FUNCTION, TdFunctionClass))
#define TD_IS_FUNCTION(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_FUNCTION))
#define TD_IS_FUNCTION_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_FUNCTION))

/*****************************************************************************/
/*** Enumration - Enumeration */
/*****************************************************************************/
typedef enum {
  TD_FUNCTION_0, /*** NULL */
  TD_FUNCTION_C, /*** Fonction en C - C function */
  TD_FUNCTION_SQL, /*** Fonction en SQL - SQL function */
} TdFunctionLanguage;

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdFunction TdFunction;
typedef struct _TdFunctionClass TdFunctionClass;

struct _TdFunction
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  gchar *comment; /*** Commentaire - Comment */
  gchar *language; /*** Language */
  gchar *definition; /*** Dfinition - Definition */
  GList *input; /*** Entres - Inputs */
  GList *output; /*** Sorties - Outputs */
  GList *property_name; /*** Nom des proprits - Properties name */
  GList *property_value; /*** Valeur des proprits - Properties value */
};

struct _TdFunctionClass
{
  GtkObjectClass parent_class;
  void (*add_input) (TdFunction *function, gchar *input);
  void (*add_output) (TdFunction *function, gchar *output);
  void (*add_property) (TdFunction *function, gchar *property_name, gchar *property_value);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_function_set_name (TdFunction *function, gchar *name);
static void td_function_set_comment (TdFunction *function, gchar *comment);
static void td_function_set_language (TdFunction *function, gchar *language);
static void td_function_set_definition (TdFunction *function, gchar *definition);
static void td_function_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_function_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_function_init (TdFunction *function);
static void td_function_class_init (TdFunctionClass *klass);
GtkType td_function_get_type (void);
GtkObject *td_function_new (void);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_function_add_input (TdFunction *function, gchar *input);
void td_function_add_output (TdFunction *function, gchar *output);
void td_function_add_property (TdFunction *function, gchar *property_name, gchar *property_value);

/*****************************************************************************/
/*** Language */
/*****************************************************************************/
TdFunctionLanguage td_function_language_parse (gchar *value);
gchar *td_function_language_print (TdFunctionLanguage value);
gchar *td_function_property_value (TdFunction *function, gchar *property_name);
gboolean td_function_activate (TdFunction *function);

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
GtkObject *td_function_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur_root);

