/*****************************************************************************/
/* td_function.h : Objet Gtk+
 * td_function.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "database.h"
#include "td_app.h"
#include "td_function.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_COMMENT,
  ARG_LANGUAGE,
  ARG_DEFINITION,
};

static void td_function_set_name (TdFunction *function, gchar *name)
{
  g_return_if_fail (function != NULL);
  g_return_if_fail (TD_IS_FUNCTION (function));
  if (function->name != name)
    function->name = name;
}

static void td_function_set_comment (TdFunction *function, gchar *comment)
{
  g_return_if_fail (function != NULL);
  g_return_if_fail (TD_IS_FUNCTION (function));
  if (function->comment != comment)
    function->comment = comment;
}

static void td_function_set_language (TdFunction *function, gchar *language)
{
  g_return_if_fail (function != NULL);
  g_return_if_fail (TD_IS_FUNCTION (function));
  if (function->language != language)
    function->language = language;
}

static void td_function_set_definition (TdFunction *function, gchar *definition)
{
  g_return_if_fail (function != NULL);
  g_return_if_fail (TD_IS_FUNCTION (function));
  if (function->definition != definition)
    function->definition = definition;
}

static void td_function_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdFunction *function;
  function = TD_FUNCTION (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_function_set_name (function, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COMMENT:
      td_function_set_comment (function, GTK_VALUE_STRING (*arg));
      break;
   case ARG_LANGUAGE:
      td_function_set_language (function, GTK_VALUE_STRING (*arg));
      break;
    case ARG_DEFINITION:
      td_function_set_definition (function, GTK_VALUE_STRING (*arg));
      break;
     default:
      break;
    }
}

static void td_function_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdFunction *function;
  function = TD_FUNCTION (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = function->name;
      break;
    case ARG_COMMENT:
      GTK_VALUE_STRING (*arg) = function->name;
      break;
    case ARG_LANGUAGE:
      GTK_VALUE_STRING (*arg) = function->language;
      break;
    case ARG_DEFINITION:
      GTK_VALUE_STRING (*arg) = function->definition;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_function_init (TdFunction *function)
{
  function->name = NULL;
  function->comment = NULL;
  function->language = NULL;
  function->definition = NULL;
  function->input = NULL;
  function->output = NULL;
  function->property_name = NULL;
  function->property_value = NULL;
}

static void td_function_class_init (TdFunctionClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdFunction::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdFunction::comment", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_COMMENT);
  gtk_object_add_arg_type ("TdFunction::language", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LANGUAGE);
  gtk_object_add_arg_type ("TdFunction::definition", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_DEFINITION);
  object_class->set_arg = td_function_set_arg;
  object_class->get_arg = td_function_get_arg;
  klass->add_input = td_function_add_input;
  klass->add_output = td_function_add_output;
  klass->add_property = td_function_add_property;
}

GtkType td_function_get_type (void)
{
  static GtkType function_type = 0;
  if (!function_type)
    {
      static const GtkTypeInfo function_info =
      {
  	"TdFunction", sizeof (TdFunction), sizeof (TdFunctionClass),
  	(GtkClassInitFunc) td_function_class_init,
	(GtkObjectInitFunc) td_function_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      function_type = gtk_type_unique (GTK_TYPE_OBJECT, &function_info);
    }
  return function_type;
}

/**
 * td_function_new:
 * 
 * fr: Cr une nouvelle fonction
 *
 * en: Creates new function
 * 
 * Return value: function parameters
 **/

GtkObject *td_function_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_function_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_function_add_input:
 * @function: function
 * @input: input
 * 
 * fr: Ajoute l'entre  la fonction
 *
 * en: Adds the input to the function
 **/

void td_function_add_input (TdFunction *function, gchar *input)
{
  g_return_if_fail (function != NULL);
  g_return_if_fail (TD_IS_FUNCTION (function));
  function->input = g_list_append (function->input, input);
}

/**
 * td_function_add_output:
 * @function: function
 * @output: output
 * 
 * fr: Ajoute la sortie  la fonction
 *
 * en: Adds the output to the function
 **/

void td_function_add_output (TdFunction *function, gchar *output)
{
  g_return_if_fail (function != NULL);
  g_return_if_fail (TD_IS_FUNCTION (function));
  function->output = g_list_append (function->output, output);
}

/**
 * td_function_add_property:
 * @function: function
 * @property_name: property's name
 * @property_value: property's value
 * 
 * fr: Ajoute la proprit  la fonction
 *
 * en: Adds the property to function
 **/

void td_function_add_property (TdFunction *function, gchar *property_name, gchar *property_value)
{
  g_return_if_fail (function != NULL);
  g_return_if_fail (TD_IS_FUNCTION (function));
  function->property_name = g_list_append (function->property_name, property_name);
  function->property_value = g_list_append (function->property_value, property_value);
}

/*****************************************************************************/
/*** Language */
/*****************************************************************************/

/**
 * td_function_language_parse:
 * @value: string
 * 
 * fr: Retourne le 'TdFunctionLang' correspondant  la chane de caractres
 *
 * en: Returns the 'TdFunctionLang' corresponding the string
 * 
 * Return value: function language
 **/

TdFunctionLanguage td_function_language_parse (gchar *value)
{
  if (!value)
    return TD_FUNCTION_0;
  if (!strcmp (value, "c"))
    return TD_FUNCTION_C;
  if (!strcmp (value, "sql"))
    return TD_FUNCTION_SQL;
  return TD_FUNCTION_0;
}

/**
 * td_function_language_print:
 * @value: string
 * 
 * fr: Retourne la chane de caractres correspondant au 'TdFunctionLanguage'
 *
 * en: Returns the string corresponding the 'TdFunctionLanguage'
 * 
 * Return value: string
 **/

gchar *td_function_language_print (TdFunctionLanguage value)
{
  gchar *ret;
  switch (value)
    {
    case TD_FUNCTION_C:
      ret = "c";
      break;
    case TD_FUNCTION_SQL:
      ret = "sql";
      break;
    default:
      ret = "(null)";
      break;
    }
  return ret;
}

/**
 * td_function_property_value:
 * @function: function
 * @property_name: property name
 * 
 * fr: Retourne la valeur de la proprit du la fonction
 *
 * en: Returns the value of function property
 * 
 * Return value: string
 **/

gchar *td_function_property_value (TdFunction *function, gchar *property_name)
{
  int i;
  for (i=0; i<g_list_length (function->property_name); i++)
    if (!strcmp ((gchar*) (g_list_nth_data (function->property_name, i)), property_name))
      return (g_list_nth_data (function->property_value, i));
  return NULL;
}

/**
 * td_function_activate:
 * @function: function
 * 
 * fr: Execute la fonction
 *
 * en: Executes the functions
 * 
 * Return value: FALSE on error
 **/

gboolean td_function_activate (TdFunction *function)
{
  int i;
  GList *(*symbol)();
  GList *input;
  GList *output;
  gchar *query;

  /*** Dfinition - Definition */
  if (!function->definition)
    {
      td_app_message (_("Executing function"), g_strdup_printf (_("Executing function '%s' : definition not find"), function->name), TD_MSG_FAILED);
      return FALSE;
    }

  /*** SQL */
  if (!strcmp (function->language, "sql"))
    {
      td_database_command (function->definition);
      td_app_message (NULL, g_strdup_printf (_("Executing function '%s'"), function->name), TD_MSG_FUNCTION);
      return TRUE;
    }

  /*** C */
  if (!strcmp (function->language, "c"))
    {

      /*** Module */
      if ((!td_strsplit (function->definition, NULL, 0)) || (!td_strsplit (function->definition, NULL, 1)))
	{
	  td_app_message (_("Executing function"), g_strdup_printf (_("Executing function '%s' : definition not complete"), function->name), TD_MSG_FAILED);
	  return FALSE;
	}
      if (g_list_length (function->input) == 0)
	{
	  td_app_message (_("Executing function"), g_strdup_printf (_("Executing function '%s' : input not defined"), function->name), TD_MSG_FAILED);
	  return FALSE;
	}
      if (g_list_length (function->output) == 0)
	{
	  td_app_message (_("Executing function"), g_strdup_printf (_("Executing function '%s' : output not defined"), function->name), TD_MSG_FAILED);
	  return FALSE;
	}
      if (!td_app_add_mod_core (TD_APP (APP), NULL, td_strsplit (function->definition, NULL, 0)))
	{
	  td_app_message (_("Executing function"), g_strdup_printf (_("Executing function '%s' : module '%s' not loaded"), function->name, td_strsplit (function->definition, NULL, 0)), TD_MSG_FAILED);
	  return FALSE;
	}
      (gpointer*) symbol = td_app_mod_core_symbol (TD_APP (APP), NULL, td_strsplit (function->definition, NULL, 0), td_strsplit (function->definition, NULL, 1), TRUE);
      if (!symbol)
	{
	  td_app_message (_("Executing function"), g_strdup_printf (_("Executing function '%s' : symbol '%s.%s' not find"), function->name, td_strsplit (function->definition, NULL, 0), td_strsplit (function->definition, NULL, 1)), TD_MSG_FAILED);
	  return FALSE;
	}

      /*** Entres - Inputs */
      query = "SELECT ";
      for (i=0; i<g_list_length (function->input); i++)
	{
	  query = g_strdup_printf ("%s%s", query, td_strsplit (g_list_nth_data (function->input, i), NULL, 1));
	  if (i != g_list_length (function->input)-1)
	    query = g_strdup_printf ("%s, ", query);
	}
      query = g_strdup_printf ("%s FROM %s WHERE td_id = %d;", query, td_strsplit (g_list_nth_data (function->input, i), NULL, 0), CURRENT_ID);
      input = td_database_row (query);

      /*** Sorties - Outputs */
      output = symbol (input);
      if (g_list_length (function->output) != g_list_length (output))
	td_app_message (_("Executing function"), g_strdup_printf (_("Executing function '%s' : lenght of output list not equal between function->output : %d and result : %d"), function->name, g_list_length (function->output), g_list_length (output)), TD_MSG_FAILED);
      query = g_strdup_printf ("UPDATE %s SET ", td_strsplit (g_list_nth_data (function->input, i), NULL, 0));
      for (i=0; i<g_list_length (function->output); i++)
	{
	  if (i+1<=g_list_length (output))
	    query = g_strdup_printf ("%s%s = %s", query, td_strsplit (g_list_nth_data (function->input, i), NULL, 1), td_database_adaptvalue (g_list_nth_data (output, i), "text"));
	  else
	    query = g_strdup_printf ("%s%s = ''", query, td_strsplit (g_list_nth_data (function->input, i), NULL, 1));
	  if (i != g_list_length (function->output)-1)
	    query = g_strdup_printf ("%s, ", query);
	}
      query = g_strdup_printf ("%s WHERE td_id = %d;", query, CURRENT_ID);
      if (!td_database_command (query))
	return FALSE;
      td_app_message (NULL, g_strdup_printf (_("Executing function '%s'"), function->name), TD_MSG_FUNCTION);
    }
  return TRUE;
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_function_load:
 * @doc: XML document
 * @ns: XML namespace
 * @cur_root: XML node
 * 
 * fr: Retourne la fonction correspondant  la localisation XML
 *
 * en: Returns the function corresponding the XML location
 * 
 * Return value: function
 **/

GtkObject *td_function_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur_root)
{
  GtkObject *ret;
  XmlNode *cur;

  /*** Fonction - Function */
  ret = td_function_new();
  gtk_object_set (GTK_OBJECT (ret),
		  "name", xmlGetProp (cur_root, "name"),
		  "comment", xmlGetProp (cur_root, "comment"), NULL);

  /*** Proprits - Properties */
  cur =  td_xml_check_children (cur_root->xmlChildrenNode, "properties");
  if (!cur)
    return (ret);
  while (cur)
    {
      if (!strcmp (cur->name, "property"))
	td_function_add_property (TD_FUNCTION (ret), xmlGetProp (cur, "name"), xmlGetProp (cur, "value"));
      cur = cur->next;
    }
  return (ret);
}
