/*****************************************************************************/
/* td_dico.h : Objet Gtk+
 * td_dico.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_DICO (td_dico_get_type())
#define TD_DICO(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_DICO, TdDico))
#define TD_DICO_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_DICO, TdDicoClass))
#define TD_IS_DICO(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_DICO))
#define TD_IS_DICO_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_DICO))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdDico TdDico;
typedef struct _TdDicoClass TdDicoClass;

struct _TdDico
{
  /*< public >*/
  GtkObject object;
  GList *word; /*** Mots rfrence - Reference words */
  GList *word_intl; /*** Mots traduits - Translated words */
};

struct _TdDicoClass
{
  GtkObjectClass parent_class;
  void (*add_word) (TdDico *dico, gchar *word, gchar *word_intl);
};

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_dico_init (TdDico *dico);
static void td_dico_class_init (TdDicoClass *klass);
GtkType td_dico_get_type (void);
GtkObject *td_dico_new (void);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_dico_add_word (TdDico *dico, gchar *word, gchar *word_intl);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
gchar *td_dico_2intl (TdDico *dico, gchar *word);
gchar *td_dico_intl2 (TdDico *dico, gchar *word);





