/*****************************************************************************/
/* td_dico.c : Objet Gtk+
 * td_dico.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>

#include "commons.h"
#include "gtdk.h"
#include "td_dico.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_dico_init (TdDico *dico)
{
  dico->word = NULL;
  dico->word_intl = NULL;
}

static void td_dico_class_init (TdDicoClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  klass->add_word = td_dico_add_word;
}

GtkType td_dico_get_type (void)
{
  static GtkType dico_type = 0;
  if (!dico_type)
    {
      static const GtkTypeInfo dico_info =
      {
  	"TdDico", sizeof (TdDico), sizeof (TdDicoClass),
  	(GtkClassInitFunc) td_dico_class_init,
	(GtkObjectInitFunc) td_dico_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      dico_type = gtk_type_unique (GTK_TYPE_OBJECT, &dico_info);
    }
  return dico_type;
}

/**
 * td_dico_new:
 * 
 * fr: Cr un nouveau dictionnaire
 *
 * en: Creates a new dictionary
 * 
 * Return value: dictionary
 **/

GtkObject *td_dico_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_dico_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_dico_add_word:
 * @dico: dictionary
 * @word: reference word
 * @word_intl: translated word
 *
 * fr: Ajoute le mot au dictionnaire
 *
 * en: Adds the word to dictionary
 **/

void td_dico_add_word (TdDico *dico, gchar *word, gchar *word_intl)
{
  g_return_if_fail (dico != NULL);
  g_return_if_fail (TD_IS_DICO (dico));
  dico->word = g_list_append (dico->word, word);
  dico->word_intl = g_list_append (dico->word_intl, word_intl);
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_dico_2intl:
 * @dico: dictionary
 * @word: word
 * 
 * fr: Retourne la traduction du mot
 *
 * en: Return the word translated
 * 
 * Return value: string
 **/

gchar *td_dico_2intl (TdDico *dico, gchar *word)
{
  int i;
  for (i=0; i<g_list_length (dico->word); i++)
    if (!strcmp (word, (gchar*) g_list_nth_data (dico->word, i)))
      return (g_list_nth_data (dico->word_intl, i));
  return word;
}

/**
 * td_dico_intl2:
 * @dico: dictionary
 * @word: word
 * 
 * fr: Retourne la rfrence du mot traduit
 *
 * en: Return the reference word of the translated word
 * 
 * Return value: string
 **/

gchar *td_dico_intl2 (TdDico *dico, gchar *word)
{
  int i;
  for (i=0; i<g_list_length (dico->word); i++)
    if (!strcmp (word, (gchar*) g_list_nth_data (dico->word_intl, i)))
      return (g_list_nth_data (dico->word, i));
  return word;
}
