/*****************************************************************************/
/* td_db_table.c : Objet Gtk+
 * td_db_table.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "database.h"
#include "td_db_table.h"
#include "td_field.h"
#include "td_rule.h"
#include "td_function.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_COMMENT,
};

static void td_db_table_set_name (TdDbTable *db_table, gchar *name)
{
  g_return_if_fail (db_table != NULL);
  g_return_if_fail (TD_IS_DB_TABLE (db_table));
  if (db_table->name != name)
    db_table->name = name;
}

static void td_db_table_set_comment (TdDbTable *db_table, gchar *comment)
{
  g_return_if_fail (db_table != NULL);
  g_return_if_fail (TD_IS_DB_TABLE (db_table));
  if (db_table->comment != comment)
    db_table->comment = comment;
}

static void td_db_table_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbTable *db_table;
  db_table = TD_DB_TABLE (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_db_table_set_name (db_table, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COMMENT:
      td_db_table_set_comment (db_table, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_table_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbTable *db_table;
  db_table = TD_DB_TABLE (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = db_table->name;
      break;
    case ARG_COMMENT:
      GTK_VALUE_STRING (*arg) = db_table->comment;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_db_table_init (TdDbTable *db_table)
{
  db_table->name = NULL;
  db_table->comment = NULL;
  db_table->field = NULL;
  db_table->rule = NULL;
  db_table->function = NULL;
}

static void td_db_table_class_init (TdDbTableClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbTable::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdDbTable::comment", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_COMMENT);
  object_class->set_arg = td_db_table_set_arg;
  object_class->get_arg = td_db_table_get_arg;
  klass->add_field = td_db_table_add_field;
  klass->add_rule = td_db_table_add_rule;
  klass->add_function = td_db_table_add_function;
}

GtkType td_db_table_get_type (void)
{
  static GtkType db_table_type = 0;
  if (!db_table_type)
    {
      static const GtkTypeInfo db_table_info =
      {
  	"TdDbTable", sizeof (TdDbTable), sizeof (TdDbTableClass),
  	(GtkClassInitFunc) td_db_table_class_init,
	(GtkObjectInitFunc) td_db_table_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_table_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_table_info);
    }
  return db_table_type;
}

/**
 * td_db_table_new:
 * 
 * fr: Cr un nouveau schma de table
 *
 * en: Creates new table schema
 * 
 * Return value: table schema
 **/

GtkObject *td_db_table_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_table_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_db_table_add_field:
 * @db_table: table schema
 * @field: field schema
 * 
 * fr: Ajoute le schma du champs au schma de la table
 *
 * en: Adds the field schema to table schema
 **/

void td_db_table_add_field (TdDbTable *db_table, GtkObject *field)
{
  g_return_if_fail (db_table != NULL);
  g_return_if_fail (TD_IS_DB_TABLE (db_table));
  db_table->field = g_list_append (db_table->field, field);
}

/**
 * td_db_table_add_rule:
 * @db_table: table
 * @rule: rule
 * 
 * fr: Ajoute la rgle  la table
 *
 * en: Adds the rule to table
 **/

void td_db_table_add_rule (TdDbTable *db_table, GtkObject *rule)
{
  g_return_if_fail (db_table != NULL);
  g_return_if_fail (TD_IS_DB_TABLE (db_table));
  db_table->rule = g_list_append (db_table->rule, rule);
}

/**
 * td_db_table_add_function:
 * @db_table: table
 * @function: function
 * 
 * fr: Ajoute la function  la table
 *
 * en: Adds the function to table
 **/

void td_db_table_add_function (TdDbTable *db_table, GtkObject *function)
{
  g_return_if_fail (db_table != NULL);
  g_return_if_fail (TD_IS_DB_TABLE (db_table));
  db_table->function = g_list_append (db_table->function, function);
}

/*****************************************************************************/
/***  Fichier - File */
/*****************************************************************************/

/**
 * td_db_table_load:
 * @doc: XML document
 * @ns: XML namespace
 * @cur_root: XML node
 * 
 * fr: Retourne le schma de la table correspondant  la localisation XML
 *
 * en: Return the table schema corresponding the XML location
 * 
 * Return value: table schema
 **/

GtkObject *td_db_table_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur_root)
{
  XmlNode *cur;
  GtkObject *ret;

  /*** Table */
  ret = td_db_table_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", xmlGetProp (cur_root, "name"), 
		  "comment", xmlGetProp (cur_root, "comment"), NULL);

  /*** Champs - Fields */
  cur =  td_xml_check_children (cur_root->xmlChildrenNode, "fields");
  while (cur)
    {
      if (!strcmp (cur->name, "field"))
	td_db_table_add_field (TD_DB_TABLE (ret), td_field_load (doc, ns, cur));
      cur = cur->next;
    }

  /*** Rgles - Rules */
  if (!cur_root->xmlChildrenNode->next)
    return (ret);
  cur = td_xml_check_children (cur_root->xmlChildrenNode->next, "rules");
  while (cur)
    {
      if (!strcmp (cur->name, "rule"))
	td_db_table_add_rule (TD_DB_TABLE (ret), td_rule_load (doc, ns, cur));
      cur = cur->next;
    }

  /*** Fonctions - Functions */
  if (!cur_root->xmlChildrenNode->next->next)
    return (ret);
  cur = td_xml_check_children (cur_root->xmlChildrenNode->next->next, "functions");
  while (cur)
    {
      if (!strcmp (cur->name, "function"))
	td_db_table_add_function (TD_DB_TABLE (ret), td_function_load (doc, ns, cur));
      cur = cur->next;
    }
  return (ret);
}


