/*****************************************************************************/
/* td_db_mod_menu.c : Objet Gtk+
 * td_db_mod_menu.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "database.h"
#include "td_db_mod_menu.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
};

static void td_db_mod_menu_set_name (TdDbModMenu *db_mod_menu, gchar *name)
{
  g_return_if_fail (db_mod_menu != NULL);
  g_return_if_fail (TD_IS_DB_MOD_MENU (db_mod_menu));
  if (db_mod_menu->name != name)
    db_mod_menu->name = name;
}

static void td_db_mod_menu_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbModMenu *db_mod_menu;
  db_mod_menu = TD_DB_MOD_MENU (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_db_mod_menu_set_name (db_mod_menu, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_mod_menu_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbModMenu *db_mod_menu;
  db_mod_menu = TD_DB_MOD_MENU (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = db_mod_menu->name;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_db_mod_menu_init (TdDbModMenu *db_mod_menu)
{
  db_mod_menu->name = NULL;
  db_mod_menu->property_name = NULL;
  db_mod_menu->property_value = NULL;
}

static void td_db_mod_menu_class_init (TdDbModMenuClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbModMenu::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  object_class->set_arg = td_db_mod_menu_set_arg;
  object_class->get_arg = td_db_mod_menu_get_arg;
  klass->add_property = td_db_mod_menu_add_property;
}

GtkType td_db_mod_menu_get_type (void)
{
  static GtkType db_mod_menu_type = 0;
  if (!db_mod_menu_type)
    {
      static const GtkTypeInfo db_mod_menu_info =
      {
  	"TdDbModMenu", sizeof (TdDbModMenu), sizeof (TdDbModMenuClass),
  	(GtkClassInitFunc) td_db_mod_menu_class_init,
	(GtkObjectInitFunc) td_db_mod_menu_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_mod_menu_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_mod_menu_info);
    }
  return db_mod_menu_type;
}

/**
 * td_db_mod_menu_new:
 * 
 * fr: Cr un nouveau paramtrage de menu
 *
 * en: Creates new menu parameters
 * 
 * Return value: menu parameters
 **/

GtkObject *td_db_mod_menu_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_mod_menu_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_db_mod_menu_add_property:
 * @db_mod_menu: menu parameters
 * @property_name: property's name
 * @property_value: property's value
 * 
 * fr: Ajoute la proprit au paramtrage du menu
 *
 * en: Adds the property to menu parameters
 **/

void td_db_mod_menu_add_property (TdDbModMenu *db_mod_menu, gchar *property_name, gchar *property_value)
{
  g_return_if_fail (db_mod_menu != NULL);
  g_return_if_fail (TD_IS_DB_MOD_MENU (db_mod_menu));
  db_mod_menu->property_name = g_list_append (db_mod_menu->property_name, property_name);
  db_mod_menu->property_value = g_list_append (db_mod_menu->property_value, property_value);
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_db_mod_menu_load:
 * @doc: XML document
 * @ns: XML namespace
 * @cur: XML node
 * 
 * fr: Retourne le paramtrage du menu du module correspondant  la localisation XML
 *
 * en: Return the menu parameters of module corresponding the XML location
 * 
 * Return value: menu parameters
 **/

GtkObject *td_db_mod_menu_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur_root)
{
  XmlNode *cur;
  GtkObject *ret;

  /*** Nom - Name */
  ret = td_db_mod_menu_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", xmlGetProp (cur_root, "name"), NULL);

  /*** Champs - Fields */
  cur =  td_xml_check_children (cur_root->xmlChildrenNode, "menu");
  if (!cur)
    return (ret);
  while (cur)
    {
      if (!strcmp (cur->name, "property"))
	td_db_mod_menu_add_property (TD_DB_MOD_MENU (ret), xmlGetProp (cur, "name"), xmlGetProp (cur, "value"));
      cur = cur->next;
    }
  return (ret);
}
