/*****************************************************************************/
/* td_db_datatable.h : Objet Gtk+
 * td_db_datatable.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_DB_DATATABLE (td_db_datatable_get_type())
#define TD_DB_DATATABLE(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_DB_DATATABLE, TdDbDatatable))
#define TD_DB_DATATABLE_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_DB_DATATABLE, TdDbDatatableClass))
#define TD_IS_DB_DATATABLE(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_DB_DATATABLE))
#define TD_IS_DB_DATATABLE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_DB_DATATABLE))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdDbDatatable TdDbDatatable;
typedef struct _TdDbDatatableClass TdDbDatatableClass;

struct _TdDbDatatable
{
  /*< public >*/
  GtkObject object;
  gchar *table; /*** Nom de la table - Table name */
  GList *item;  /*** Dones - Data */
};

struct _TdDbDatatableClass
{
  GtkObjectClass parent_class;
  void (*add_item) (TdDbDatatable *db_datatable, GList *item);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
void td_db_datatable_set_table (TdDbDatatable *db_datatable, gchar *table);
static void td_db_datatable_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_db_datatable_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_db_datatable_init (TdDbDatatable *db_datatable);
static void td_db_datatable_class_init (TdDbDatatableClass *klass);
GtkType td_db_datatable_get_type (void);
GtkObject *td_db_datatable_new (void);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_db_datatable_add_item (TdDbDatatable *db_datatable, GList *item);

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
GtkObject *td_db_datatable_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur);
GtkObject *td_db_datatable_load_flower (GtkObject *flower, gchar *name);
