/*****************************************************************************/
/*** td_db_datatable.c : Objet Gtk+
 *** td_db_datatable.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <parser.h>
#include <tree.h>
/*  #include <libxml/parser.h> */
/*  #include <libxml/tree.h> */

#include "commons.h"
#include "td_flower.h"
#include "td_app.h"
#include "td_db_datatable.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_TABLE,
};

void td_db_datatable_set_table (TdDbDatatable *db_datatable, gchar *table)
{
  g_return_if_fail (db_datatable != NULL);
  g_return_if_fail (TD_IS_DB_DATATABLE (db_datatable));
  if (db_datatable->table != table)
    db_datatable->table = table;
}

static void td_db_datatable_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbDatatable *db_datatable;
  db_datatable = TD_DB_DATATABLE (object);
  switch (arg_id)
    {
    case ARG_TABLE:
      td_db_datatable_set_table (db_datatable, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_datatable_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbDatatable *db_datatable;
  db_datatable = TD_DB_DATATABLE (object);
   switch (arg_id)
    {
    case ARG_TABLE:
      GTK_VALUE_STRING (*arg) = db_datatable->table;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_db_datatable_init (TdDbDatatable *db_datatable)
{
  db_datatable->table = NULL;
  db_datatable->item = NULL;
}

static void td_db_datatable_class_init (TdDbDatatableClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbDatatable::table", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE);
  object_class->set_arg = td_db_datatable_set_arg;
  object_class->get_arg = td_db_datatable_get_arg;
  klass->add_item = td_db_datatable_add_item;
}

GtkType td_db_datatable_get_type (void)
{
  static GtkType db_datatable_type = 0;
  if (!db_datatable_type)
    {
      static const GtkTypeInfo db_datatable_info =
      {
  	"TdDbDatatable", sizeof (TdDbDatatable), sizeof (TdDbDatatableClass),
  	(GtkClassInitFunc) td_db_datatable_class_init,
	(GtkObjectInitFunc) td_db_datatable_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_datatable_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_datatable_info);
    }
  return db_datatable_type;
}

/**
 * td_db_datatable_new:
 * 
 * fr: Cr une nouvelle table de donnes
 *
 * en: Creates new datatable
 * 
 * Return value: datatable
 **/

GtkObject *td_db_datatable_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_datatable_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_db_datatable_add_item:
 * @db_datatable: datatable
 * @item: item
 * 
 * fr: Ajoute l'item  la table de donnes
 *
 * en: Adds the item to datatable
 **/

void td_db_datatable_add_item (TdDbDatatable *db_datatable, GList *item)
{
  g_return_if_fail (db_datatable != NULL);
  g_return_if_fail (TD_IS_DB_DATATABLE (db_datatable));

  /*** Vrification de la longueur de l'item - Checking the length of data list */
  if (g_list_length (db_datatable->item))
    if (g_list_length (item) != g_list_length (g_list_nth_data (db_datatable->item, 0)))
      td_app_message (NULL, _("Adding node : incompatible length between records"), TD_MSG_FAILED);
  db_datatable->item = g_list_append (db_datatable->item, item);
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_db_datatable_load:
 * @doc: XML document
 * @ns: XML namespace
 * @cur: XML node
 * 
 * fr: Retourne la table de donnes correspondant  la localisation XML
 *
 * en: Return the datatable corresponding the XML location
 * 
 * Return value: datatable
 **/

GtkObject *td_db_datatable_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur)
{
  GtkObject *ret;
  GList *data = NULL;
  int i;

  /*** Table de donnes - Datatable */
  ret = td_db_datatable_new();
  gtk_object_set (GTK_OBJECT (ret), "table", xmlGetProp (cur, "table"), NULL);

  /*** Donnes - Data */
  cur = cur->xmlChildrenNode->xmlChildrenNode;
  while (cur)
    {
      if (!strcmp (cur->name, "item"))
	{
	  i = 0;
	  while (xmlGetProp (cur, g_strdup_printf ("field%d", i)))
	    {
	      data = g_list_append (data, xmlGetProp (cur, g_strdup_printf ("field%d", i)));
	      i++;
	    }
	  td_db_datatable_add_item (TD_DB_DATATABLE (ret), data);
	  data = NULL;
	}
      cur = cur->next;
    }
  g_list_free (data);
  return ret;
}

/**
 * td_db_datatable_load_flower:
 * @flower: td_flower object
 * @name: name of datatable
 * 
 * fr: Retourne la table de donnes du fichier support
 *
 * en: Return the datatable of support file
 * 
 * Return value: datatable
 **/

GtkObject *td_db_datatable_load_flower (GtkObject *flower, gchar *name)
{
  GtkObject *ret;
  int i;

  /*** Table de donnes - Datatable */
  ret = td_db_datatable_new();
  gtk_object_set (GTK_OBJECT (ret), "table", name, NULL);

  /*** Donnes - Data */
  for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
    td_db_datatable_add_item (TD_DB_DATATABLE (ret), g_list_nth_data (TD_FLOWER (flower)->items_value, i));
  return ret;
}
