/*****************************************************************************/
/*** td_db_connect.c : Objet Gtk+
 *** td_db_connect.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/stat.h>

#include "commons.h"
#include "icons.h"
#include "database.h"
#include "td_app.h"
#include "td_app_palette.h"
#include "td_app_bench.h"
#include "td_app_etabliste.h"
#include "td_mod.h"
#include "td_db_base.h"
#include "td_db_table.h"
#include "td_db_mod.h"
#include "td_db_datatable.h"
#include "td_db_connect.h"
#include "td_flower.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_INTERFACE,
  ARG_HOST,
  ARG_PORT,
  ARG_BASE,
  ARG_USER,
  ARG_PASSWORD,
  ARG_FILE,
  ARG_TEMPLATE,
};

static void td_db_connect_set_name (TdDbConnect *connect, gchar *name)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->name != name)
    connect->name = name;
}

static void td_db_connect_set_interface (TdDbConnect *connect, gchar *interface)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->interface != interface)
    connect->interface = interface;
}

static void td_db_connect_set_host (TdDbConnect *connect, gchar *host)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->host != host)
    connect->host = host;
}

static void td_db_connect_set_port (TdDbConnect *connect, gchar *port)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->port != port)
    connect->port = port;
}

static void td_db_connect_set_base (TdDbConnect *connect, gchar *base)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->base != base)
    connect->base = base;
}

static void td_db_connect_set_user (TdDbConnect *connect, gchar *user)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->user != user)
    connect->user = user;
}

static void td_db_connect_set_password (TdDbConnect *connect, gchar *password)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->password != password)
    connect->password = password;
}

static void td_db_connect_set_file (TdDbConnect *connect, gchar *file)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->file != file)
    connect->file = file;
}

static void td_db_connect_set_template (TdDbConnect *connect, gchar *template)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->template != template)
    connect->template = template;
}

static void td_db_connect_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbConnect *connect;
  connect = TD_DB_CONNECT (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_db_connect_set_name (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_INTERFACE:
      td_db_connect_set_interface (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_HOST:
      td_db_connect_set_host (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PORT:
      td_db_connect_set_port (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_BASE:
      td_db_connect_set_base (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_USER:
      td_db_connect_set_user (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PASSWORD:
      td_db_connect_set_password (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_FILE:
      td_db_connect_set_file (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TEMPLATE:
      td_db_connect_set_template (connect, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_connect_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbConnect *connect;
  connect = TD_DB_CONNECT (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = connect->name;
      break;
    case ARG_INTERFACE:
      GTK_VALUE_STRING (*arg) = connect->interface;
      break;
    case ARG_HOST:
      GTK_VALUE_STRING (*arg) = connect->host;
      break;
    case ARG_PORT:
      GTK_VALUE_STRING (*arg) = connect->port;
      break;
    case ARG_BASE:
      GTK_VALUE_STRING (*arg) = connect->base;
      break;
    case ARG_USER:
      GTK_VALUE_STRING (*arg) = connect->user;
      break;
    case ARG_PASSWORD:
      GTK_VALUE_STRING (*arg) = connect->password;
      break;
    case ARG_FILE:
      GTK_VALUE_STRING (*arg) = connect->file;
      break;
    case ARG_TEMPLATE:
      GTK_VALUE_STRING (*arg) = connect->template;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_db_connect_init (TdDbConnect *connect)
{
  connect->name = NULL;
  connect->type = TD_CONNECT_TYPE_NONE;
  connect->interface = NULL;
  connect->host = NULL;
  connect->port = NULL;
  connect->base = NULL;
  connect->user = NULL;
  connect->password = NULL;
  connect->file = NULL;
  connect->template = NULL;
}

static void td_db_connect_class_init (TdDbConnectClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbConnect::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdDbConnect::interface", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_INTERFACE);
  gtk_object_add_arg_type ("TdDbConnect::host", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_HOST);
  gtk_object_add_arg_type ("TdDbConnect::port", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PORT);
  gtk_object_add_arg_type ("TdDbConnect::base", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_BASE);
  gtk_object_add_arg_type ("TdDbConnect::user", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_USER);
  gtk_object_add_arg_type ("TdDbConnect::password", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PASSWORD);
  gtk_object_add_arg_type ("TdDbConnect::file", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_FILE);
  gtk_object_add_arg_type ("TdDbConnect::template", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TEMPLATE);
  object_class->set_arg = td_db_connect_set_arg;
  object_class->get_arg = td_db_connect_get_arg;
  klass->set_type = td_db_connect_set_type;
}

GtkType td_db_connect_get_type (void)
{
  static GtkType db_connect_type = 0;
  if (!db_connect_type)
    {
      static const GtkTypeInfo db_connect_info =
      {
  	"TdDbConnect", sizeof (TdDbConnect), sizeof (TdDbConnectClass),
  	(GtkClassInitFunc) td_db_connect_class_init,
	(GtkObjectInitFunc) td_db_connect_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_connect_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_connect_info);
    }
  return db_connect_type;
}

/**
 * td_db_connect_new:
 * 
 * fr: Cr une nouvelle connexion
 *
 * en: Creates a new connection
 * 
 * Return value: connection
 **/

GtkObject *td_db_connect_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_connect_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_db_connect_set_type (TdDbConnect *connect, TdConnectType type)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  connect->type = type;
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
TdConnectType td_db_connect_parse_type (gchar *value)
{
  if (!value)
    return TD_CONNECT_TYPE_NONE;
  if (!strcmp (value, "file"))
    return TD_CONNECT_TYPE_FILE;
  if (!strcmp (value, "template"))
    return TD_CONNECT_TYPE_TEMPLATE;
  if (!strcmp (value, "database"))
    return TD_CONNECT_TYPE_DATABASE;
  if (!strcmp (value, "url"))
    return TD_CONNECT_TYPE_URL;
  if (!strcmp (value, "recovery"))
    return TD_CONNECT_TYPE_RECOVERY;
  if (!strcmp (value, "recovery_start"))
    return TD_CONNECT_TYPE_RECOVERY_START;
  if (!strcmp (value, "none"))
    return TD_CONNECT_TYPE_NONE;
  return TD_CONNECT_TYPE_NONE;
}

gchar *td_db_connect_print_type (TdConnectType value)
{
  switch (value)
    {
    case TD_CONNECT_TYPE_NONE:
      return "none";
    case TD_CONNECT_TYPE_FILE:
      return "file";
    case TD_CONNECT_TYPE_TEMPLATE:
      return "template";
    case TD_CONNECT_TYPE_URL:
      return "url";
    case TD_CONNECT_TYPE_RECOVERY:
      return "recovery";
    case TD_CONNECT_TYPE_RECOVERY_START:
      return "recovery start";
    default:
      break;
    }
  return "none";
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_db_connect_load:
 * @menuitem: menu command
 * @connect_bookmark: connection of a bookmark
 * 
 * fr: Charge un fichier
 *
 * en: Load a file
 * 
 * Return value: FALSE on error
 **/

gboolean td_db_connect_load (GtkWidget *menuitem, GtkObject *connect_bookmark)
{
  void (*symbol)();
  gchar *(*symbol2)();
  gboolean (*symbol3)();
  int fp;
  gchar *txt_tmp;
  gchar *menuitem_name;
  GtkObject *parse_test;
  GtkObject *connect = NULL;
  gboolean bool_tmp;
  int i, j;
  GtkObject *plugins_flower;
  struct stat stat_tmp;
  if (menuitem)
    gtk_label_get (GTK_LABEL (g_list_nth_data (gtk_container_children (GTK_CONTAINER (GTK_BIN (menuitem)->child)), 1)), &menuitem_name);

  /*** Slection d'un fichier - Select a file */
  if (menuitem)
    if (!strcmp (menuitem_name, _("Open file...")))
      {
	txt_tmp = g_strdup_printf ("%s", td_fileselector_create_window (_("Load file"), NULL, NULL, TRUE));
	if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	  {
	    txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
	    return TRUE;
	  }
	connect = td_db_connect_new();
	gtk_object_set (GTK_OBJECT (connect), 
			"name", txt_tmp,
			"file", txt_tmp, NULL);
	td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_FILE);
	txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
      }

  /*** Slection d'un gabarit - Select a template */
  if (menuitem)
    if (!strcmp (menuitem_name, _("Open template...")))
      {
	txt_tmp = g_strdup_printf ("%s", td_fileselector_create_window (_("Load template"), NULL, NULL, TRUE));
	if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	  {
	    txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
	    return TRUE;
	  }
	else
	  {
	    connect = td_db_connect_new();
	    gtk_object_set (GTK_OBJECT (connect),
			    "name", _("New"),
			    "file", txt_tmp, NULL);
	    td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_TEMPLATE);
	    txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
	  }
      }

  /*** Slection d'une URL - Select a URL */
  if (menuitem)
    if (!strcmp (menuitem_name, _("Open URL...")))
      {
	(gpointer*) symbol2 = td_app_mod_core_symbol (NULL, NULL, "libcommunication_url.so", "plugins_show", TRUE);
	txt_tmp = symbol2();
	if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	  return TRUE;
	else
	  {
	    (gpointer*) symbol3 = td_app_mod_core_symbol (NULL, NULL, "libcommunication_url.so", "plugins_load_url", TRUE);
	    if (!symbol3 (txt_tmp))
	      return TRUE;
	    connect = td_db_connect_new();
	    gtk_object_set (GTK_OBJECT (connect),
			    "name", txt_tmp,
			    "base", txt_tmp,
			    "file", g_strdup_printf ("%s/url.td", TD_PACKAGE_TMP_DIR), NULL);
	    td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_URL);
	  }
      }

  /*** Signets - Bookmarks */
  td_app_message (NULL, _("Loading file"), TD_MSG_BEGIN);
  td_app_message (g_strdup_printf ("%s...", _("Checking file")), NULL, TD_MSG_MESSAGE);
  if (connect_bookmark)
    connect = connect_bookmark;

  /*** Vrif de la prsence du fichier - Checking the presence of file */
  fp = open (TD_DB_CONNECT (connect)->file, O_RDONLY);
  if (fp == -1)
    {
      td_app_message (_("Loading file"), g_strdup_printf (_("Loading file : '%s'"), TD_DB_CONNECT (connect)->file), TD_MSG_FAILED);
      td_app_message (NULL, _("Loading file"), TD_MSG_END);
      return FALSE;
    }
  fstat (fp, &stat_tmp);
  close (fp);
  if (S_ISDIR (stat_tmp.st_mode))
    {
      td_app_message (_("Loading file"), g_strdup_printf (_("Loading file '%s' : It's not a file"), TD_DB_CONNECT (connect)->file), TD_MSG_FAILED);
      td_app_message (NULL, _("Loading file"), TD_MSG_END);
      return FALSE;
    }

  /*** Verif du contenu du fichier et conversion ancien format - Checking the content of file and translation the old format */
  parse_test = td_db_base_load (TD_DB_CONNECT (connect)->file);
  if (!parse_test)
    {
      if (!td_db_connect_open_oldfile (TD_DB_CONNECT (connect)->file))
	{
	  td_app_message (_("Loading file"), g_strdup_printf (_("Loading file '%s' : file unreadable"), TD_DB_CONNECT (connect)->file), TD_MSG_FAILED);
	  td_app_message (NULL, _("Loading file"), TD_MSG_END);
	  return FALSE;
	}
      parse_test = td_db_base_load (TD_DB_CONNECT (connect)->file);
      if (!parse_test)
	{
	  td_app_message (_("Loading file"), g_strdup_printf (_("Loading file '%s' : file unreadable"), TD_DB_CONNECT (connect)->file), TD_MSG_FAILED);
	  td_app_message (NULL, _("Loading file"), TD_MSG_END);
	  return FALSE;
	}
    }

  /*** Fermeture du fichier courant - Close the current file */
  if (TD_DB_CONNECT (TD_APP (APP)->connect)->type != TD_CONNECT_TYPE_RECOVERY_START)
    if (!td_db_connect_close (NULL, NULL))
      {
	td_app_message (NULL, _("Loading file"), TD_MSG_END);
	return FALSE;
      }
  if (TD_DB_CONNECT (TD_APP (APP)->connect)->type == TD_CONNECT_TYPE_RECOVERY_START)
    TD_DB_CONNECT (TD_APP (APP)->connect)->type = TD_CONNECT_TYPE_RECOVERY;

  /*** Schma - Schema */
  td_app_message (NULL, _("Creating local database"), TD_MSG_BEGIN);
  td_app_set_current (TD_APP (APP), connect, parse_test);
  if (TD_DB_CONNECT (TD_APP (APP)->connect)->type != TD_CONNECT_TYPE_RECOVERY)
    {
      td_app_message (g_strdup_printf ("%s...", _("Loading schema")), NULL, TD_MSG_MESSAGE);
      if (!td_database_base_construct (TD_APP (APP)->base))
	td_app_message (_("Loading file"), _("Loading file : schema of local database not complete"), TD_MSG_STOP);
    }

  /*** Donnes - Data */
  if ((TD_DB_CONNECT (TD_APP (APP)->connect)->type != TD_CONNECT_TYPE_TEMPLATE) &&
      (TD_DB_CONNECT (TD_APP (APP)->connect)->type != TD_CONNECT_TYPE_RECOVERY))
    {
      td_app_message (g_strdup_printf ("%s...", _("Loading data")), NULL, TD_MSG_MESSAGE);
      for (i=0; i < g_list_length (TD_DB_BASE (TD_APP (APP)->base)->datatable); i++)
	if (!td_database_table_copy_in (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->datatable, i)))
	  td_app_message (_("Loading file"), _("Loading file : datatable of local database not complete"), TD_MSG_STOP);
    }
  TD_APP (APP)->modified = FALSE;
  td_app_message (NULL, _("Creating local database"), TD_MSG_END);

  /*** Modules */
  td_app_message (NULL, _("Loading modules"), TD_MSG_BEGIN);
  td_app_message (g_strdup_printf ("%s...", _("Loading modules")), NULL, TD_MSG_MESSAGE);
  plugins_flower = td_dataplugins_list();
  for (i=0; i < g_list_length (TD_DB_BASE (TD_APP (APP)->base)->mod); i++)
    {
      for (j=0; j<g_list_length (TD_FLOWER (plugins_flower)->items_value); j++)
	if (!strcmp (TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name, 
				(gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (plugins_flower)->items_value, j), 0)))
	  {
	    if (!td_app_add_mod_data (TD_APP (APP), NULL, g_list_nth_data (g_list_nth_data (TD_FLOWER (plugins_flower)->items_value, j), 2)))
	      td_app_message (_("Loading file"), _("Loading file : Modules not complete"), TD_MSG_STOP);

	    /*** Palette */
	    if ((TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name_param) &&
		(strlen (g_strstrip (TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name_param))) &&
		(strcmp (TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name_param, "(null)")))
	      {
		gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_APP (APP)->mod_data, i)), "name_intl", TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name_param, NULL);
		td_mod_unmodified (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, i)));
	      }
	    if (TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->icon)
	      gtk_object_set (GTK_OBJECT (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, i))->about), "icon", TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->icon, NULL);

	    /*** Etablis - Benchs */
	    td_app_palette_add_mod (TD_APP_PALETTE (TD_APP (APP)->palette), g_list_nth_data (TD_APP (APP)->mod_data, i));
	    td_app_bench_add_mod (TD_APP_BENCH (TD_APP (APP)->bench), g_list_nth_data (TD_APP (APP)->mod_data, i));
	    td_app_etabliste_add_mod (TD_APP_ETABLISTE (TD_APP (APP)->etabliste), g_list_nth_data (TD_APP (APP)->mod_data, i));
	    break;
	  }
    }
  td_app_message (NULL, _("Loading modules"), TD_MSG_END);

  /*** Historique - History */
  if (TD_DB_CONNECT (TD_APP (APP)->connect)->type != TD_CONNECT_TYPE_TEMPLATE)
    {
      (gpointer*) symbol = td_dlsym (PLUGINS_CORE_BOOKMARKS, NULL, "libbookmarks.so", "plugins_add_history", TRUE);
      symbol (connect);
    }
  td_app_message (NULL, _("Loading file"), TD_MSG_END);
  return TRUE;
}

/**
 * td_db_connect_save:
 * @menuitem: menu command
 * @user_data: NULL
 * 
 * fr: Enregistre un fichier
 *
 * en: Save a file
 * 
 * Return value: FALSE on error
 **/

gboolean td_db_connect_save (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkObject *(*symbol1)();
  gboolean (*symbol3)();
  void (*symbol4)();
  GtkObject *base = NULL;
  GtkObject *connect = NULL;
  gchar *file = NULL;
  int i;
  gchar *txt_tmp;

  /*** Enregistrer sous - Save as */
  if (menuitem)
    if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s", PREFIX_WIDGET_PLUGINS, _("File"), _("Save as..."))))
      {
	file = g_strdup_printf ("%s", td_fileselector_create_window (_("Save file"), NULL, "td", TRUE));
	if ((!file) || (!strcmp (file, "(null)")))
	  {
	    txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
	    return TRUE;
	  }
	else
	  {
	    TD_APP (APP)->modified = TRUE;
	    connect = td_db_connect_new();
	    gtk_object_set (GTK_OBJECT (connect), 
			    "name", file, 
			    "file", file, NULL);
	    td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_FILE);
	    TD_APP (APP)->connect = connect;
	    txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
	  }
      }
  
  /*** Enregistrer sans nom - Save without name */
  if ((!(TD_APP (APP)->base) && (!file)) || 
      (!strcmp (TD_DB_CONNECT (TD_APP(APP)->connect)->name , _("New"))) ||
      (TD_DB_CONNECT (TD_APP (APP)->connect)->type == TD_CONNECT_TYPE_URL))
    {
      file = g_strdup_printf ("%s", td_fileselector_create_window (_("Save file"), NULL, "td", TRUE));
      if ((!file) || (!strcmp (file, "(null)")))
	{
	  txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
	  return TRUE;
	}
      else
	{
	  TD_APP (APP)->modified = TRUE;
	  connect = td_db_connect_new();
	  gtk_object_set (GTK_OBJECT (connect), 
			  "name", file,
			  "file", file, NULL);
	  td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_FILE);
	  TD_APP (APP)->connect = connect;
	  txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
	}
    }

  /*** Pas de modifications - No modifications */
  if (!TD_APP (APP)->modified)
    {
      td_app_message (_("No unsaved change"), NULL, TD_MSG_MESSAGE);
      return TRUE;
    }

  /*** Enregisrer - Save */
  td_app_message (NULL, _("Saving"), TD_MSG_BEGIN);
  td_app_message (g_strdup_printf ("%s...", _("Saving")), NULL, TD_MSG_MESSAGE);
  if (!file)
    file = TD_DB_CONNECT (TD_APP (APP)->connect)->file;

  /*** Structure */
  for (i=0; i<g_list_length (TD_APP (APP)->mod_data); i++)
    if (!strcmp (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, i))->name, "cogitation"))
      {
	(gpointer*) symbol1 = td_app_mod_data_symbol (i, "plugins_save", TRUE);
	base = symbol1();
	break;
      }
  if (!base)
    {
      base = td_db_base_new();
      for (i=0; i < g_list_length (TD_DB_BASE (TD_APP (APP)->base)->table); i++)
	td_db_base_add_table (TD_DB_BASE (base), g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->table, i));
      for (i=0; i < g_list_length (TD_DB_BASE (TD_APP (APP)->base)->mod); i++)
	td_db_base_add_mod (TD_DB_BASE (base), g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i));
    }

  /*** Donnes - Data */
  if (TD_APP (APP)->base)
    for (i=0; i < g_list_length (TD_DB_BASE (TD_APP (APP)->base)->table); i++)
      {
	txt_tmp = g_strdup_printf ("SELECT * FROM %s ORDER BY td_id;", TD_DB_TABLE (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->table, i))->name);
	td_db_base_add_datatable (TD_DB_BASE (base), td_database_select (g_strdup_printf ("SELECT * FROM %s ORDER BY td_id;", TD_DB_TABLE (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->table, i))->name)));
	td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, i), TD_DB_TABLE (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->table, i))->name);
      }

  /*** Fichier - File */
  if (!td_db_base_save (TD_DB_BASE (base), file))
    {
      td_app_message (_("Saving"), g_strdup_printf (_("Saving : file '%s' unreadable"), file), TD_MSG_FAILED);
      td_app_message (NULL, _("Saving"), TD_MSG_END);
      return FALSE;
    }
  td_app_message (_("Wrote file"), g_strdup_printf (_("Wrote file '%s'"), file), TD_MSG_MESSAGE);

  /*** Base de donnes distante - Remote database *//*** FIXME: refaire : +tards - recast : this night */
/*    if (!strcmp (TD_DB_CONNECT (TD_APP (APP)->connect)->type , "database")) */
/*      { */
/*        (gpointer*) symbol3 = td_app_mod_core_symbol (NULL, NULL, "libcommunication_db.so", "plugins_save_database"); */
/*        if (!symbol3 (TD_APP (APP)->connect)) */
/*  	{ */
/*  	  (gpointer*) symbol4 = td_app_mod_core_symbol (NULL, NULL, "libmessages.so", "plugins_load"); */
/*  	  symbol4 (g_strdup_printf ("%s/log.xml", TD_PACKAGE_TMP_DIR)); */
/*  	  td_palette_message (_("Saving"), _("Saving : database unreadable"), "failed"); */
/*  	  td_palette_message (NULL, _("Saving"), "end"); */
/*  	  return FALSE; */
/*  	} */
/*        td_palette_message (_("Wrote database"), g_strdup_printf (_("Wrote database '%s'"), TD_DB_CONNECT (TD_APP(APP)->connect)->base), "message"); */
/*        (gpointer*) symbol4 = td_app_mod_core_symbol (NULL, NULL, "libmessages.so", "plugins_load"); */
/*        symbol4 (g_strdup_printf ("%s/log.xml", TD_PACKAGE_TMP_DIR)); */

  /*** Relecture du fichier - Rereading file */
/*        if (!td_db_connect_load (NULL, TD_APP (APP)->connect)) */
/*  	{ */
/*  	  td_palette_message (_("Saving"), _("Saving : database unreadable"), "failed"); */
/*  	  td_palette_message (NULL, _("Saving"), "end"); */
/*  	  return FALSE; */
/*  	} */
/*      } */

  /*** Historique - History */
  (gpointer*) symbol4 = td_dlsym (PLUGINS_CORE_BOOKMARKS, NULL, "libbookmarks.so", "plugins_add_history", TRUE);
  symbol4 (TD_APP (APP)->connect);

  /*** Dcoration - Decoration */
  for (i=0; i<g_list_length (TD_APP (APP)->mod_data); i++)
    td_mod_unmodified (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, i)));
  TD_APP (APP)->modified = FALSE;
  td_app_message (NULL, _("Saving"), TD_MSG_DONE);
  td_app_message (NULL, _("Saving"), TD_MSG_END);
  return TRUE;
}

/**
 * td_db_connect_close:
 * @menuitem: menu command
 * @user_data: NULL
 * 
 * fr: Ferme le fichier courant
 *
 * en: Close the current file
 * 
 * Return value: FALSE on error
 **/

gboolean td_db_connect_close (GtkWidget *menuitem, gpointer user_data)
{
  void (*symbol)() = NULL;
  gchar *txt_tmp;
  GtkObject *connect = NULL;
  int i;
  int response = 0;
  gchar *menuitem_name;
  gchar *locks_file;
  GtkObject *locks_flower;
  if (menuitem)
    gtk_label_get (GTK_LABEL (g_list_nth_data (gtk_container_children (GTK_CONTAINER (GTK_BIN (menuitem)->child)), 1)), &menuitem_name);

  /*** Donnes - Data */
  if ((TD_APP(APP)->modified) && (strcmp (td_app_custom_value ("development", "close", "question"), "no")))
    {
      response = td_question_create_window (_("The file has unsaved changes, save them ?"), _("Warning"));
      if (response == 0)
	td_db_connect_save (NULL, NULL);
      if (response == 2)
	return FALSE;
    }

  /*** Modules */
  td_app_message (NULL, _("Closing file"), TD_MSG_BEGIN);
  td_app_message (NULL, _("Destroying modules"), TD_MSG_BEGIN);
  td_app_message (g_strdup_printf ("%s...", _("Destroying modules")), NULL, TD_MSG_MESSAGE);
  for (i=0; i<g_list_length (TD_APP (APP)->mod_data); i++)
    td_mod_destroy (g_list_nth_data (TD_APP (APP)->mod_data, i));
  TD_APP (APP)->mod_data = NULL;
  td_app_message (NULL, _("Destroying modules"), TD_MSG_END);
  if (PLUGINS_CORE_XTS)
    {
      symbol = dlsym (PLUGINS_CORE_XTS, "plugins_update_all");
      symbol (APP);
    }

  /*** Base de donnes - Database */
  td_app_message (NULL, _("Dropping local database"), TD_MSG_BEGIN);
  td_app_message (g_strdup_printf ("%s...", _("Dropping local database")), NULL, TD_MSG_MESSAGE);
  if (TD_APP (APP)->base)
    td_db_base_destroy (TD_DB_BASE (TD_APP (APP)->base));
  if (PLUGINS_CORE_DATABASE)
    td_database_base_raz();
  connect = td_db_connect_new();
  gtk_object_set (GTK_OBJECT (connect), "name", _("New"), NULL);
  td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_NONE);
  td_app_set_current (TD_APP (APP), connect, NULL);
  TD_APP(APP)->modified = FALSE;
  td_app_message (NULL, _("Dropping local database"), TD_MSG_END);
  td_app_message (NULL, _("Closing file"), TD_MSG_END);
  return TRUE;
}

/**
 * td_db_connect_open_oldfile:
 * @file: file location
 * 
 * fr: Ouvre un fichier ayant un format obsolte pour traduction
 *
 * en: Open a file with obsoleted format for translating
 * 
 * Return value: FALSE on error
 **/

gboolean td_db_connect_open_oldfile (gchar *file)
{
  gboolean (*symbol)() = NULL;
  gboolean bool_tmp;
  int i;
  gchar *txt_tmp;

  /*** Module dj charg ? - Module existing ? */
  txt_tmp = g_strdup_printf (("%s%s"), TD_PACKAGE_PLUGINS_DIR, "liboldfile.so");
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_APP (APP)->mod_core); i++)
    if (!strcmp ((gchar*) g_list_nth_data (TD_APP (APP)->mod_core, i), txt_tmp))
      {
	bool_tmp = TRUE;
	break;
      }

  /*** Oui - Yes */
  if (bool_tmp)
    {
      (gpointer*) symbol = td_app_mod_core_symbol (NULL, NULL, "liboldfile.so", "plugins_translate", TRUE);
      return (symbol (file));
    }

  /*** Non - No */
  td_app_add_mod_core (NULL, NULL, "liboldfile.so");
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE[g_list_length (TD_APP (APP)->mod_core)-1], "", txt_tmp, "plugins_translate", TRUE);
  return (symbol (file));
}

