/*****************************************************************************/
/* td_app_process.c : Objet Gtk+
 * td_app_process.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>

#include "commons.h"
#include "td_app.h"
#include "td_app_process.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_PID,
  ARG_STATUS,
  ARG_COMMAND,
  ARG_FILE,
};

static void td_app_process_set_pid (TdAppProcess *process, int pid)
{
  g_return_if_fail (process != NULL);
  g_return_if_fail (TD_IS_APP_PROCESS (process));
  if (process->pid != pid)
    process->pid = pid;
}

static void td_app_process_set_status (TdAppProcess *process, gboolean status)
{
  g_return_if_fail (process != NULL);
  g_return_if_fail (TD_IS_APP_PROCESS (process));
  if (process->status != status)
    process->status = status;
}

static void td_app_process_set_command (TdAppProcess *process, gchar *command)
{
  g_return_if_fail (process != NULL);
  g_return_if_fail (TD_IS_APP_PROCESS (process));
  if (process->command != command)
    process->command = command;
}

static void td_app_process_set_file (TdAppProcess *process, gchar *file)
{
  g_return_if_fail (process != NULL);
  g_return_if_fail (TD_IS_APP_PROCESS (process));
  if (process->file != file)
    process->file = file;
}

static void td_app_process_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdAppProcess *process;
  process = TD_APP_PROCESS (object);
  switch (arg_id)
    {
    case ARG_PID:
      td_app_process_set_pid (process, GTK_VALUE_INT (*arg));
      break;
    case ARG_STATUS:
      td_app_process_set_status (process, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_COMMAND:
      td_app_process_set_command (process, GTK_VALUE_STRING (*arg));
      break;
    case ARG_FILE:
      td_app_process_set_file (process, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_app_process_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdAppProcess *process;
  process = TD_APP_PROCESS (object);
   switch (arg_id)
    {
    case ARG_PID:
      GTK_VALUE_INT (*arg) = process->pid;
      break;
    case ARG_STATUS:
      GTK_VALUE_BOOL (*arg) = process->status;
      break;
    case ARG_COMMAND:
      GTK_VALUE_STRING (*arg) = process->command;
      break;
    case ARG_FILE:
      GTK_VALUE_STRING (*arg) = process->file;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_app_process_init (TdAppProcess *process)
{
  process->pid = 0;
  process->status = TRUE;
  process->command = NULL;
  process->file = NULL;
}

static void td_app_process_class_init (TdAppProcessClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdAppProcess::pid", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_PID);
  gtk_object_add_arg_type ("TdAppProcess::status", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_STATUS);
  gtk_object_add_arg_type ("TdAppProcess::command", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_COMMAND);
  gtk_object_add_arg_type ("TdAppProcess::file", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_FILE);
  object_class->set_arg = td_app_process_set_arg;
  object_class->get_arg = td_app_process_get_arg;
}

GtkType td_app_process_get_type (void)
{
  static GtkType app_process_type = 0;
  if (!app_process_type)
    {
      static const GtkTypeInfo app_process_info =
      {
  	"TdAppProcess", sizeof (TdAppProcess), sizeof (TdAppProcessClass),
  	(GtkClassInitFunc) td_app_process_class_init,
	(GtkObjectInitFunc) td_app_process_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      app_process_type = gtk_type_unique (GTK_TYPE_OBJECT, &app_process_info);
    }
  return app_process_type;
}

/**
 * td_app_process_new:
 * 
 * fr: Cr un nouveau processus
 *
 * en: Creates a new process
 * 
 * Return value: process
 **/

GtkObject *td_app_process_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_app_process_get_type()));
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_app_process_update:
 * @application: application
 * @file: file
 * @command: command
 * 
 * fr: Mise  jour du processus
 *
 * en: Updates the process
 * 
 * Return value: FALSE on error
 **/

gboolean td_app_process_update (TdApp *application, gchar *file, gchar *command)
{
  void (*symbol)() = NULL;
  int i, pid;
  gboolean bool_tmp;
  GtkObject *process;
  if (PLUGINS_CORE_MESSAGES)
    (gpointer*) symbol = dlsym (PLUGINS_CORE_MESSAGES, "plugins_update_process");

  /*** Recherche du processus - Search the process */
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (application->process); i++)
    if ((TD_APP_PROCESS (g_list_nth_data (application->process, i))->status) && (!strcmp (TD_APP_PROCESS (g_list_nth_data (application->process, i))->file, file)))
      {
	bool_tmp = TRUE;
	break;
      }
  if (bool_tmp)
    {
      if (td_file_exist (g_strdup_printf ("/proc/%d/stat", TD_APP_PROCESS (g_list_nth_data (application->process, i))->pid)))
	return TRUE;
      TD_APP_PROCESS (g_list_nth_data (application->process, i))->status = FALSE;
      if (PLUGINS_CORE_MESSAGES)
	symbol (GTK_OBJECT (g_list_nth_data (application->process, i)));
    }

  /*** Cration d'un nouveau processus - Create new process*/
  pid = td_exec (command);
  if (pid<1)
    return FALSE;
  process = td_app_process_new();
  gtk_object_set (GTK_OBJECT (process),
		  "pid", pid,
		  "command", command,
		  "file", file, NULL);
  td_app_add_process (application, process);
  if (PLUGINS_CORE_MESSAGES)
    symbol (process);
  return TRUE;
}
