/*****************************************************************************/
/*** td_app_palette.c : Objet Gtk+
 *** td_app_palette.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <dirent.h>

#include "commons.h"
#include "gtdk.h"
#include "td_about.h"
#include "td_flower.h"
#include "td_app.h"
#include "td_app_palette.h"
#include "td_db_base.h"
#include "td_db_mod.h"
#include "td_mod.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_app_palette_init (TdAppPalette *palette)
{
  palette->window = NULL;
  palette->toolbar = NULL;
  palette->status = NULL;
  palette->progressbar = NULL;
}

static void td_app_palette_class_init (TdAppPaletteClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  klass->create = td_app_palette_create;
}

GtkType td_app_palette_get_type (void)
{
  static GtkType app_palette_type = 0;
  if (!app_palette_type)
    {
      static const GtkTypeInfo app_palette_info =
      {
  	"TdAppPalette", sizeof (TdAppPalette), sizeof (TdAppPaletteClass),
  	(GtkClassInitFunc) td_app_palette_class_init,
	(GtkObjectInitFunc) td_app_palette_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      app_palette_type = gtk_type_unique (GTK_TYPE_OBJECT, &app_palette_info);
    }
  return app_palette_type;
}

/**
 * td_app_palette_new:
 * 
 * fr: Cr une nouvelle palette
 *
 * en: Creates a new palette
 * 
 * Return value: palette
 **/

GtkObject *td_app_palette_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_app_palette_get_type()));
}

/**
 * td_app_palette_destroy:
 * @palette: palette
 * 
 * fr: Dtruit la palette
 *
 * en: Destroys the palette
 **/

void td_app_palette_destroy (TdAppPalette *palette)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  gtdk_window_save_conf ("palette", palette->window, FALSE, TRUE, FALSE);
  gtk_widget_destroy (palette->window);
  gtk_object_destroy (GTK_OBJECT (palette));
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_app_palette_create:
 * @palette: palette
 * 
 * fr: Cr l'interface de la palette de l'application
 *
 * en: Creates the interface of palette of application
 **/

void td_app_palette_create (TdAppPalette *palette)
{
  GtkWidget *dock;
  GtkWidget *vbox1;
  GtkWidget *vbox2;
  GtkWidget *viewport1;
  gchar *txt_tampon;
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));

  /*** Fentre - Window */
  palette->window = gnome_app_new ("palette", NULL);
  gtk_window_set_policy (GTK_WINDOW (palette->window), FALSE, FALSE, FALSE);
  gtdk_window_set_title (GTK_WINDOW (palette->window), NULL, TD_WINDOW_TYPE_PALETTE);
  gtk_window_add_accel_group (GTK_WINDOW (palette->window), TD_APP (APP)->accel_group);
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gnome_app_set_contents (GNOME_APP (palette->window), vbox1);
  gtdk_window_save_defaultconf ("palette", -1, -1);
  gtdk_window_load_conf ("palette", palette->window);

  /*** Menu */
  dock = GNOME_APP (palette->window)->dock;
  gtk_widget_show (dock);
  gtk_widget_show (TD_APP(APP)->menu_palette);
  gtk_container_set_border_width (GTK_CONTAINER (TD_APP(APP)->menu_palette), 2);
  gnome_app_set_menus (GNOME_APP (palette->window), GTK_MENU_BAR (TD_APP(APP)->menu_palette));

  /*** Barre d'outils - Toolbar */
  palette->toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (palette->toolbar);
  gnome_app_add_toolbar (GNOME_APP (palette->window), GTK_TOOLBAR (palette->toolbar), "toolbar", GNOME_DOCK_ITEM_BEH_EXCLUSIVE, GNOME_DOCK_TOP, 1, 0, 0);
  gtk_widget_show (palette->toolbar);

  /*** Panneau - Panel  *//*** FIXME: +tards  - this night */

  /*** Barre d'tats - Status bar */
  palette->status = gtk_entry_new();
  gtk_entry_set_editable (GTK_ENTRY (palette->status), FALSE);
  gtk_box_pack_start (GTK_BOX (vbox1), palette->status, FALSE, FALSE, 0);
  gtk_widget_show (palette->status);
  palette->progressbar = gtk_progress_bar_new();
  gtk_progress_set_percentage (GTK_PROGRESS (palette->progressbar), 0);
  gtk_widget_hide (palette->progressbar);
  gtk_box_pack_start (GTK_BOX (vbox1), palette->progressbar, FALSE, FALSE, 0);

  /*** Appels - Calls */
  gtk_signal_connect_object (GTK_OBJECT (palette->window), "delete_event", GTK_SIGNAL_FUNC (td_app_quit), GTK_OBJECT (APP));
  gtk_widget_show (palette->window);
}

/**
 * td_app_palette_progressbar_init:
 * @palette: palette
 * @message: text
 * 
 * fr: Affiche de la barre de progression
 *
 * en: Displays the progress bar
 **/

void td_app_palette_progressbar_init (TdAppPalette *palette, gchar *message)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  gtk_entry_set_text (GTK_ENTRY (palette->status), message);
  gtk_progress_set_percentage (GTK_PROGRESS (palette->progressbar), 0);
  gtk_widget_show (palette->progressbar);
  while (gtk_events_pending())
    gtk_main_iteration();
}

/**
 * td_app_palette_progressbar_update:
 * @palette: palette
 * @pourcentage: value
 * 
 * fr: Mise  la valeur de la barre de progression
 *
 * en: Update the progress bar with the value
 **/

void td_app_palette_progressbar_update (TdAppPalette *palette, float pourcentage)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  if ((pourcentage < 0) || (pourcentage > 1))
    gtk_progress_set_percentage (GTK_PROGRESS (palette->progressbar), 0);
  else
    gtk_progress_set_percentage (GTK_PROGRESS (palette->progressbar), pourcentage);
  while (gtk_events_pending())
    gtk_main_iteration();
}

/**
 * td_app_palette_progressbar_hide:
 * @palette: palette
 * 
 * fr: Ferme la barre de progression
 *
 * en: Close the progress bar
 **/

void td_app_palette_progressbar_hide (TdAppPalette *palette)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  gtk_widget_hide (palette->progressbar);
  gtk_progress_set_percentage (GTK_PROGRESS (palette->progressbar), 0);
}

/**
 * td_app_palette_exec:
 * @palette: palette
 * @command: command
 * @message: message
 * 
 * fr: Execute une commande unix avec la barre d'activit de la palette
 *
 * en: Executes an unix command with the activity barre of the palette
 * 
 * Return value: FALSE on error
 **/

gboolean td_app_palette_exec (TdAppPalette *palette, gchar *command, gchar *message)
{
  gboolean bool_tmp = FALSE;
  float compteur;
  int pid, i;
  gchar *pid_file;
  DIR *proc;

  /* Sans /proc - Without /proc */
  proc = opendir ("/proc");
  if (!proc)
    {
      td_app_message (NULL, _("Executing command : process file system not find"), TD_MSG_FAILED);
      gtk_entry_set_text (GTK_ENTRY (palette->status), message);
      td_system (command);
      return TRUE;
    }
  closedir (proc);

  /* Commande - Command */
  td_app_palette_progressbar_init (palette, message);
  gtk_progress_set_value (GTK_PROGRESS (palette->progressbar), 0);
  gtk_progress_set_activity_mode (GTK_PROGRESS (palette->progressbar), TRUE);
  pid = td_exec (command);
  pid_file = g_strdup_printf ("/proc/%d/stat", pid);
  if (pid<0)
    {
      td_app_palette_progressbar_hide (palette);
      return FALSE;
    }
  i=0;
  while (td_file_exist (pid_file))
    {
      gtk_progress_set_value (GTK_PROGRESS (palette->progressbar), i++);
      while (gtk_events_pending())
	gtk_main_iteration();
      td_sleep (100);
    }
  td_app_palette_progressbar_hide (palette);
  return TRUE;
}

/**
 * td_app_palette_select:
 * @togglebutton: button
 * @mod_id: module identifier
 * 
 * fr: Evnement des buttons de la palette
 *
 * en: Event of button of palette
 **/

void td_app_palette_select (GtkToggleButton *togglebutton, gchar *mod_id)
{
  if ((gtk_toggle_button_get_active (togglebutton)))
    td_mod_show (g_list_nth_data (TD_APP (APP)->mod_data, atoi (mod_id)));
  else 
    td_mod_hide (g_list_nth_data (TD_APP (APP)->mod_data, atoi (mod_id)));
}

/**
 * td_app_palette_add_mod:
 * @palette: palette
 * @mod: mod object
 * 
 * fr: Ajoute un module  la palette
 *
 * en: Adds a module to the palette
 **/

void td_app_palette_add_mod (TdAppPalette *palette, GtkObject *mod)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  TD_MOD (mod)->palette_button = gtdk_toolbar_append_togglebutton (GTK_TOOLBAR (palette->toolbar), TD_MOD (mod)->name_intl, TD_ABOUT (TD_MOD (mod)->about)->icon);
  gtk_signal_connect (GTK_OBJECT (TD_MOD (mod)->palette_button), "toggled", GTK_SIGNAL_FUNC (td_app_palette_select), g_strdup_printf ("%d", TD_MOD (mod)->id));
}
