/*****************************************************************************/
/*** td_app_etabliste.c : Objet Gtk+
 *** td_app_etabliste.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "gtdk.h"
#include "icons.h"
#include "database.h"
#include "td_app.h"
#include "td_app_etabliste.h"
#include "td_mod.h"
#include "td_mod_etabliste.h"
#include "td_mod_box.h"
#include "td_field.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_app_etabliste_init (TdAppEtabliste *etabliste)
{
  etabliste->window = NULL;
  etabliste->notebook = NULL;
  etabliste->notebook_vbox = NULL;
}

static void td_app_etabliste_class_init (TdAppEtablisteClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  klass->create = td_app_etabliste_create;
}

GtkType td_app_etabliste_get_type (void)
{
  static GtkType app_etabliste_type = 0;
  if (!app_etabliste_type)
    {
      static const GtkTypeInfo app_etabliste_info =
      {
  	"TdAppEtabliste", sizeof (TdAppEtabliste), sizeof (TdAppEtablisteClass),
  	(GtkClassInitFunc) td_app_etabliste_class_init,
	(GtkObjectInitFunc) td_app_etabliste_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      app_etabliste_type = gtk_type_unique (GTK_TYPE_OBJECT, &app_etabliste_info);
    }
  return app_etabliste_type;
}

/**
 * td_app_etabliste_new:
 * 
 * fr: Cr un nouveau tabli
 *
 * en: Creates a new etabliste
 * 
 * Return value: etabliste
 **/

GtkObject *td_app_etabliste_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_app_etabliste_get_type()));
}

/**
 * td_app_etabliste_destroy:
 * @etabliste: etabliste
 * 
 * fr: Dtruit l'tabli
 *
 * en: Destroys the etabliste
 **/

void td_app_etabliste_destroy (TdAppEtabliste *etabliste)
{
  g_return_if_fail (etabliste != NULL);
  g_return_if_fail (TD_IS_APP_ETABLISTE (etabliste));
  gtdk_window_save_conf ("etabliste", etabliste->window, TRUE, TRUE, TRUE);
  gtk_widget_destroy (etabliste->window);
  gtk_object_destroy (GTK_OBJECT (etabliste));
}

/**
 * td_app_etabliste_hide:
 * @etabliste: etabliste
 * 
 * fr: Cache l'tabli
 *
 * en: Hides the etabliste
 **/

void td_app_etabliste_hide (TdAppEtabliste *etabliste)
{
  g_return_if_fail (etabliste != NULL);
  g_return_if_fail (TD_IS_APP_ETABLISTE (etabliste));
  gtdk_window_save_conf ("etabliste", etabliste->window, TRUE, TRUE, TRUE);
  gtk_widget_hide (GTK_WIDGET (etabliste->window));
}

/**
 * td_app_etabliste_show:
 * @etabliste: etabliste
 * 
 * fr: Affiche l'tabli
 *
 * en: Displays the etabliste
 **/

void td_app_etabliste_show (TdAppEtabliste *etabliste)
{
  g_return_if_fail (etabliste != NULL);
  g_return_if_fail (TD_IS_APP_ETABLISTE (etabliste));
  gtk_widget_show (GTK_WIDGET (etabliste->window));
  gtk_widget_hide_all (GNOME_APP (etabliste->window)->menubar->parent->parent);
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_app_etabliste_create:
 * @etabliste: etabliste
 * 
 * fr: Cr l'interface de l'tabli de l'application
 *
 * en: Creates the interface of etabliste of application
 **/

void td_app_etabliste_create (TdAppEtabliste *etabliste)
{
  GtkWidget *dock;
  GtkWidget *viewport;
  GtkWidget *vbox;
  gchar* txt_tmp;
  gchar *title;
  g_return_if_fail (etabliste != NULL);
  g_return_if_fail (TD_IS_APP_ETABLISTE (etabliste));

  /*** Fentre - Window */
  etabliste->window = gnome_app_new ("etabliste", NULL);
  gnome_app_enable_layout_config (GNOME_APP (etabliste->window), FALSE);
  gtk_window_set_policy (GTK_WINDOW (etabliste->window), TRUE, TRUE, FALSE);
  gtdk_window_set_title (GTK_WINDOW (etabliste->window), _("Etabliste"), TD_WINDOW_TYPE_TOOL);
  gnome_app_create_menus (GNOME_APP (etabliste->window), TD_APP (APP)->menu_gnomeui);
  gtdk_window_save_defaultconf ("etabliste", 300, 150);
  gtdk_window_load_conf ("etabliste", etabliste->window);
  dock = GNOME_APP (etabliste->window)->dock;
  gtk_signal_connect_object (GTK_OBJECT (etabliste->window), "delete_event", GTK_SIGNAL_FUNC (td_app_etabliste_hide), GTK_OBJECT (etabliste));

  /*** Signets - Notebooks */
  viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport);
  gnome_app_set_contents (GNOME_APP (etabliste->window), viewport);
  etabliste->notebook_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (etabliste->notebook_vbox);
  gtk_container_add (GTK_CONTAINER (viewport), etabliste->notebook_vbox);
  etabliste->notebook = gtk_notebook_new();
  gtk_widget_show (etabliste->notebook);
  gtk_box_pack_start (GTK_BOX (etabliste->notebook_vbox), etabliste->notebook, TRUE, TRUE, 0);
  if (!TD_FLAG_DEBUG_MODE)
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK (etabliste->notebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (etabliste->notebook), FALSE);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (etabliste->notebook), vbox);
  gtdk_vbox_title (_("No view selected"), vbox);

  /*** Affichage - Displaying */
  if (gtdk_geometry_get ("etabliste", "visible") == 1)
    {
      gtk_widget_show (GTK_WIDGET (etabliste->window));
      gtk_widget_hide_all (GNOME_APP (etabliste->window)->menubar->parent->parent);
    }
  else
    gtk_widget_hide (etabliste->window);
}

/**
 * td_app_etabliste_add_mod:
 * @etabliste: etabliste
 * @mod: module
 * 
 * fr: Ajoute un module  l'tabli
 *
 * en: Adds a module to the etabliste
 **/

void td_app_etabliste_add_mod (TdAppEtabliste *etabliste, GtkObject *mod)
{
  GList *field;
  GList *etabliste_item = NULL;
  GtkWidget *table;
  GtkWidget *ctree;
  GtkWidget *box_tmp;
  int i;
  gchar *list_query = NULL;
  gchar *txt_tmp = NULL;
  gchar *txt_tmp2 = NULL;
  GList *data = NULL;
  gboolean without_param = FALSE;
  g_return_if_fail (etabliste != NULL);
  g_return_if_fail (TD_IS_APP_ETABLISTE (etabliste));

  /*** Champs - Fields */
  field = td_mod_etabliste_field (TD_MOD (mod));
  if (g_list_length (field) == 0)
    without_param = TRUE;
  for (i=0; i< g_list_length (field); i++)
    {
      etabliste_item = g_list_append (etabliste_item, td_mod_etabliste_new());
      gtk_object_set (GTK_OBJECT (g_list_nth_data (etabliste_item, i)),
		      "name", TD_FIELD (g_list_nth_data (field, i))->name,
		      "selection_mode", gtdk_selection_mode_parse (td_field_property_value (g_list_nth_data (field, i), "etabliste selection mode")),
		      "query_refresh", td_field_property_value (g_list_nth_data (field, i), "etabliste refresh query"),
		      "query_set", td_field_property_value (g_list_nth_data (field, i), "etabliste set query"),
		      "query_unset", td_field_property_value (g_list_nth_data (field, i), "etabliste unset query"),
		      "query_visible", td_field_property_value (g_list_nth_data (field, i), "etabliste visible query"), NULL);
      txt_tmp = td_field_property_value (g_list_nth_data (field, i), "etabliste list item");
      if (txt_tmp)
	txt_tmp2 = "etabliste list item";
      else
	{
	  txt_tmp = td_field_property_value (g_list_nth_data (field, i), "etabliste list static query");
	  if (txt_tmp)
	    txt_tmp2 = "etabliste list static query";
	  else
	    {
	      txt_tmp = td_field_property_value (g_list_nth_data (field, i), "etabliste list query");
	      if (txt_tmp)
		txt_tmp2 = "etabliste list query";
	    }
	}
      gtk_object_set (GTK_OBJECT (g_list_nth_data (etabliste_item, i)),
		      "list_query", txt_tmp,
		      "list_type", txt_tmp2, NULL);
      td_mod_add_etabliste (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (etabliste_item, i)));
    }

  /*** Go ! */
  if (TD_MOD (mod)->id != -1)
    {
      TD_MOD (mod)->etabliste_vbox = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (TD_MOD (mod)->etabliste_vbox);
      gtk_container_add (GTK_CONTAINER (etabliste->notebook), TD_MOD (mod)->etabliste_vbox);
      gtdk_vbox_title (TD_MOD (mod)->name_intl, TD_MOD (mod)->etabliste_vbox);

      /*** Widgets */
      for (i=0; i< g_list_length (TD_MOD (mod)->etabliste); i++)
	{
	  ctree = gtk_ctree_new (2, 0);
	  gtdk_clist_adjustheight (GTK_CLIST (ctree));
	  gtk_widget_hide (ctree);
	  gtk_clist_column_titles_show (GTK_CLIST (ctree));
	  gtk_ctree_set_expander_style (GTK_CTREE (ctree), GTK_CTREE_EXPANDER_NONE);
	  gtk_ctree_set_line_style (GTK_CTREE (ctree), GTK_CTREE_LINES_NONE);
	  gtk_clist_set_selection_mode (GTK_CLIST (ctree), TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->selection_mode);
	  gtdk_clist_title (GTK_CLIST (ctree), 0, TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->name, -1, GTK_JUSTIFY_CENTER);
	  gtdk_clist_title (GTK_CLIST (ctree), 1, "td_id", -2, GTK_JUSTIFY_LEFT);
	  gtk_container_add (GTK_CONTAINER (TD_MOD (mod)->etabliste_vbox), ctree);
	  gtk_signal_connect (GTK_OBJECT (ctree), "select_row", GTK_SIGNAL_FUNC (td_mod_action_etabliste_set), mod);
	  gtk_signal_connect (GTK_OBJECT (ctree), "unselect_row", GTK_SIGNAL_FUNC (td_mod_action_etabliste_unset), mod);
	  td_mod_etabliste_set_widget (TD_MOD_ETABLISTE (g_list_nth_data (etabliste_item, i)), ctree, NULL);

	  /*** Liste - List */
	  if (!TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->list_query)
	    continue;
	  txt_tmp = g_strdup_printf ("%s", TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->list_query);
	  if (!strcmp (TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->list_type, "etabliste list item"))
	    { 
	      txt_tmp2 = strtok (txt_tmp, "',");
	      while (txt_tmp2)
		{
		  data = g_list_append (data, txt_tmp2);
		  txt_tmp2 = strtok (NULL, "',");
		}
	      gtdk_ctree_set_strings (GTK_CTREE (ctree), NULL, data);
	      data = NULL;
	      continue;
	    }
	  if ((!strcmp (TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->list_type, "etabliste list query")) ||
	      (!strcmp (TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->list_type, "etabliste list static query")))
	    gtdk_ctree_set_strings (GTK_CTREE (ctree), td_database_select (TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->list_query), NULL);
	}
    }
}




