/*****************************************************************************/
/* td_app_bench.h : Objet Gtk+
 * td_app_bench.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_APP_BENCH (td_app_bench_get_type())
#define TD_APP_BENCH(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_APP_BENCH, TdAppBench))
#define TD_APP_BENCH_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_APP_BENCH, TdAppBenchClass))
#define TD_IS_APP_BENCH(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_APP_BENCH))
#define TD_IS_APP_BENCH_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_APP_BENCH))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdAppBench TdAppBench;
typedef struct _TdAppBenchClass TdAppBenchClass;

struct _TdAppBench
{
  /*< public >*/
  GtkObject object;
  GtkWidget *window; /*** Fentre - Window */
  GtkWidget *notebook; /*** Onglets - Notebook */
  GtkWidget *notebook_vbox; /*** Container des onglets - Container of notebook */
};

struct _TdAppBenchClass
{
  GtkObjectClass parent_class;
  void (*create) (TdAppBench *bench);
};

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_app_bench_init (TdAppBench *bench);
static void td_app_bench_class_init (TdAppBenchClass *klass);
GtkType td_app_bench_get_type (void);
GtkObject *td_app_bench_new (void);
void td_app_bench_destroy (TdAppBench *bench);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
void td_app_bench_create (TdAppBench *bench);
void td_app_bench_hide (TdAppBench *bench);
void td_app_bench_show (TdAppBench *bench);
void td_app_bench_add_mod (TdAppBench *bench, GtkObject *mod);
