/*****************************************************************************/
/*** td_app_bench.c : Objet Gtk+
 *** td_app_bench.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "gtdk.h"
#include "icons.h"
#include "database.h"
#include "td_app.h"
#include "td_app_bench.h"
#include "td_mod.h"
#include "td_mod_bench.h"
#include "td_mod_box.h"
#include "td_field.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_app_bench_init (TdAppBench *bench)
{
  bench->window = NULL;
  bench->notebook = NULL;
  bench->notebook_vbox = NULL;
}

static void td_app_bench_class_init (TdAppBenchClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  klass->create = td_app_bench_create;
}

GtkType td_app_bench_get_type (void)
{
  static GtkType app_bench_type = 0;
  if (!app_bench_type)
    {
      static const GtkTypeInfo app_bench_info =
      {
  	"TdAppBench", sizeof (TdAppBench), sizeof (TdAppBenchClass),
  	(GtkClassInitFunc) td_app_bench_class_init,
	(GtkObjectInitFunc) td_app_bench_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      app_bench_type = gtk_type_unique (GTK_TYPE_OBJECT, &app_bench_info);
    }
  return app_bench_type;
}

/**
 * td_app_bench_new:
 * 
 * fr: Cr un nouveau tabli
 *
 * en: Creates a new bench
 * 
 * Return value: bench
 **/

GtkObject *td_app_bench_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_app_bench_get_type()));
}

/**
 * td_app_bench_destroy:
 * @bench: bench
 * 
 * fr: Dtruit l'tabli
 *
 * en: Destroys the bench
 **/

void td_app_bench_destroy (TdAppBench *bench)
{
  g_return_if_fail (bench != NULL);
  g_return_if_fail (TD_IS_APP_BENCH (bench));
  gtdk_window_save_conf ("bench", bench->window, TRUE, TRUE, TRUE);
  gtk_widget_destroy (bench->window);
  gtk_object_destroy (GTK_OBJECT (bench));
}

/**
 * td_app_bench_hide:
 * @bench: bench
 * 
 * fr: Cache l'tabli
 *
 * en: Hides the bench
 **/

void td_app_bench_hide (TdAppBench *bench)
{
  g_return_if_fail (bench != NULL);
  g_return_if_fail (TD_IS_APP_BENCH (bench));
  gtdk_window_save_conf ("bench", bench->window, TRUE, TRUE, TRUE);
  gtk_widget_hide (GTK_WIDGET (bench->window));
}

/**
 * td_app_bench_show:
 * @bench: bench
 * 
 * fr: Affiche l'tabli
 *
 * en: Displays the bench
 **/

void td_app_bench_show (TdAppBench *bench)
{
  g_return_if_fail (bench != NULL);
  g_return_if_fail (TD_IS_APP_BENCH (bench));
  gtk_widget_show (GTK_WIDGET (bench->window));
  gtk_widget_hide_all (GNOME_APP (bench->window)->menubar->parent->parent);
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_app_bench_create:
 * @bench: bench
 * 
 * fr: Cr l'interface de l'tabli de l'application
 *
 * en: Creates the interface of bench of application
 **/

void td_app_bench_create (TdAppBench *bench)
{
  GtkWidget *dock;
  GtkWidget *viewport;
  GtkWidget *vbox;
  gchar* txt_tmp;
  g_return_if_fail (bench != NULL);
  g_return_if_fail (TD_IS_APP_BENCH (bench));

  /*** Fentre - Window */
  bench->window = gnome_app_new ("bench", NULL);
  gnome_app_enable_layout_config (GNOME_APP (bench->window), FALSE);
  gtk_window_set_policy (GTK_WINDOW (bench->window), TRUE, TRUE, FALSE);
  gtdk_window_set_title (GTK_WINDOW (bench->window), _("Bench"), TD_WINDOW_TYPE_TOOL);
  gnome_app_create_menus (GNOME_APP (bench->window), TD_APP (APP)->menu_gnomeui);
  gtdk_window_save_defaultconf ("bench", 300, 150);
  gtdk_window_load_conf ("bench", bench->window);
  dock = GNOME_APP (bench->window)->dock;
  gtk_signal_connect_object (GTK_OBJECT (bench->window), "delete_event", GTK_SIGNAL_FUNC (td_app_bench_hide), GTK_OBJECT (bench));

  /*** Signets - Notebooks */
  viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport);
  gnome_app_set_contents (GNOME_APP (bench->window), viewport);
  bench->notebook_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (bench->notebook_vbox);
  gtk_container_add (GTK_CONTAINER (viewport), bench->notebook_vbox);
  bench->notebook = gtk_notebook_new();
  gtk_widget_show (bench->notebook);
  gtk_box_pack_start (GTK_BOX (bench->notebook_vbox), bench->notebook, TRUE, TRUE, 0);
  if (!TD_FLAG_DEBUG_MODE)
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK (bench->notebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (bench->notebook), FALSE);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (bench->notebook), vbox);
  gtdk_vbox_title (_("No view selected"), vbox);

  /*** Affichage - Displaying */
  if (gtdk_geometry_get ("bench", "visible") == 1)
    {
      gtk_widget_show (GTK_WIDGET (bench->window));
      gtk_widget_hide_all (GNOME_APP (bench->window)->menubar->parent->parent);
    }
  else
    gtk_widget_hide (bench->window);
}

/**
 * td_app_bench_add_mod:
 * @bench: bench
 * @mod: module
 * 
 * fr: Ajoute un module  l'tabli
 *
 * en: Adds a module to the bench
 **/

void td_app_bench_add_mod (TdAppBench *bench, GtkObject *mod)
{
  GList *field;
  GList *bench_item = NULL;
  GtkWidget *table;
  GtkWidget *box_tmp;
  int i;
  gchar *list_query = NULL;
  gchar *txt_tmp = NULL;
  gchar *txt_tmp2 = NULL;
  GList *list_tmp = NULL;
  gboolean without_param = FALSE;
  g_return_if_fail (bench != NULL);
  g_return_if_fail (TD_IS_APP_BENCH (bench));

  /*** Champs - Fields */
  field = td_mod_bench_field (TD_MOD (mod));
  if (g_list_length (field) == 0)
    without_param = TRUE;
  for (i=0; i< g_list_length (field); i++)
    {
      bench_item = g_list_append (bench_item, td_mod_bench_new());
      gtk_object_set (GTK_OBJECT (g_list_nth_data (bench_item, i)),
		      "name", TD_FIELD (g_list_nth_data (field, i))->name,
		      "table_field", TD_FIELD (g_list_nth_data (field, i))->table_field,
		      "query_refresh", td_field_property_value (g_list_nth_data (field, i), "bench refresh query"),
		      "query_visible", td_field_property_value (g_list_nth_data (field, i), "bench visible query"),
		      "query_unsensitive", td_field_property_value (g_list_nth_data (field, i), "bench unsensitive query"), NULL);
      txt_tmp = td_field_property_value (g_list_nth_data (field, i), "bench list item");
      if (txt_tmp)
	txt_tmp2 = "bench list item";
      else
	{
	  txt_tmp = td_field_property_value (g_list_nth_data (field, i), "bench list static query");
	  if (txt_tmp)
	    txt_tmp2 = "bench list static query";
	  else
	    {
	      txt_tmp = td_field_property_value (g_list_nth_data (field, i), "bench list query");
	      if (txt_tmp)
		txt_tmp2 = "bench list query";
	    }
	}
      gtk_object_set (GTK_OBJECT (g_list_nth_data (bench_item, i)),
		      "list_query", txt_tmp,
		      "list_type", txt_tmp2, NULL);
      td_mod_bench_set_widget (TD_MOD_BENCH (g_list_nth_data (bench_item, i)), gtk_entry_new(), NULL);
      td_mod_add_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (bench_item, i)));
    }

  /*** Go ! */
  if (TD_MOD (mod)->id != -1)
    {
      TD_MOD (mod)->bench_vbox = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (TD_MOD (mod)->bench_vbox);
      gtk_container_add (GTK_CONTAINER (bench->notebook), TD_MOD (mod)->bench_vbox);
      gtdk_vbox_title (TD_MOD (mod)->name_intl, TD_MOD (mod)->bench_vbox);
      table = gtk_table_new (g_list_length (TD_MOD (mod)->bench), 2, FALSE);
      gtk_widget_show (table);
      gtk_box_pack_start (GTK_BOX (TD_MOD (mod)->bench_vbox), table, FALSE, FALSE, 0);

      /*** Widgets */
      for (i=0; i< g_list_length (TD_MOD (mod)->bench); i++)
	{
	  TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->label = gtk_label_new (g_strdup_printf ("%s:", TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->name));
	  gtk_table_attach (GTK_TABLE (table), TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->label, 0, 1, i, i+1, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
	  gtk_misc_set_padding (GTK_MISC (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->label), 5, 0);
	  gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->label);

	  /*** Avec liste - With list */
	  if (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_widget)
	    {
	      box_tmp = gtk_hbox_new (FALSE, 0);
	      gtk_table_attach (GTK_TABLE (table), box_tmp, 1, 2, i, i+1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	      gtk_widget_show (box_tmp);
	      gtk_box_pack_start (GTK_BOX (box_tmp), TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->widget_parent, TRUE, TRUE, 0);
	      gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->widget_parent);
	      gtk_box_pack_start (GTK_BOX (box_tmp), TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_widget, FALSE, FALSE, 0);
	      gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_widget);
	      txt_tmp = g_strdup_printf ("%s", TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_query);
	      if (!TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_query)
		continue;
	      if (!strcmp (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_type, "bench list item"))
		{
  		  txt_tmp2 = strtok (txt_tmp, "',");
		  while (txt_tmp2)
		    {
		      list_tmp = g_list_append (list_tmp, txt_tmp2);
  		      txt_tmp2 = strtok (NULL, "',");
		    }
		  gtdk_option_menu_set_strings (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_widget, list_tmp, TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->widget);
		  list_tmp = NULL;
		  continue;
		}
	      if ((!strcmp (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_type, "bench list query")) ||
		  (!strcmp (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_type, "bench list static query")))
		gtdk_option_menu_set_strings (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_widget, td_database_column (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_query), TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->widget);
	      continue;
	    }

	  /*** Sans liste - Without list */
	  gtk_table_attach (GTK_TABLE (table), TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->widget_parent, 1, 2, i, i+1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	  gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->widget_parent);
	}
    }
}

