/*****************************************************************************/
/* database.h : Interface de base de donnes
 * database.h : Database interface
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manage
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

/*****************************************************************************/
/*** Connection - Connexion */
/*****************************************************************************/
gboolean td_database_base_login (gchar *name);
gboolean td_database_base_logout (void);

/*****************************************************************************/
/*** Crer - Create */
/*****************************************************************************/
gboolean td_database_base_create (gchar *name);
gboolean td_database_base_construct (GtkObject *base);
gboolean td_database_table_create (GtkObject *table);
gboolean td_database_rule_create (GtkObject *rule);
gboolean td_database_function_create (GtkObject *function);
gboolean td_database_table_exist (gchar *name);

/*****************************************************************************/
/*** Dtruit - Destroy */
/*****************************************************************************/
gboolean td_database_base_drop (gchar *name);
gboolean td_database_base_raz (void);
gboolean td_database_table_drop (GtkObject *table);
gboolean td_database_rule_drop (GtkObject *rule);
gboolean td_database_function_drop (GtkObject *function);

/*****************************************************************************/
/*** Remplissage de tables - Tables filling */
/*****************************************************************************/
gboolean td_database_table_copy_in (GtkObject *datatable);

/*****************************************************************************/
/*** Requte - Query */
/*****************************************************************************/
gboolean td_database_test_query (gchar *query);
gboolean td_database_command (gchar *query);
gboolean td_database_insert (gchar* query, gchar *table);
GtkObject *td_database_select (gchar *query);
GList *td_database_field (gchar *query);
GList *td_database_row (gchar *query);
GList *td_database_column (gchar *query);
gchar *td_database_value (gchar *query);
void td_database_set_current (gchar *query);
gchar *td_database_current (gchar *query);

/*****************************************************************************/
/*** Chane de caractre - String */
/*****************************************************************************/
gchar *td_database_strescape (gchar *source);
gchar *td_database_adaptvalue (gchar *value, gchar *type);

/*****************************************************************************/
/*** Arborescence - Tree structure */
/*****************************************************************************/
GtkObject *td_datatable_tree_sorted (gchar *table, gchar *table_tree, gchar *query, gchar *query_tree, int column_oid);
GList *td_datatable_tree_childs (gchar *fields, int start_id, gchar *table, gchar *table_tree);
