/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Filtre CSV
 * ToutDoux's plug-in : CSV filter
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "main.h"

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("CSV filter"),
		  "type", _("filter"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("filter"),
		  "category3", "csv",
		  "copyright", "Copyright (c) 2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

GtkObject *plugins_init (int mod_id)
{
  GtkObject *ret;
  ret = td_mod_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "text_csv",
		  "name_intl", _("CSV filter"),
		  "id", -1, NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def());
  return ret;
}

void plugins_destroy (gpointer user_data)
{
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
gboolean plugins_export (GtkObject *mod, gchar *file)
{
  GtkCTree *ctree = NULL;
  FILE *fp;
  GtkObject *mod_child;
  GtkCTreeNode *node;
  gchar *txt_tmp;
  guint8 spacing_tmp;
  GdkPixmap *pixmap_tmp;
  GdkBitmap *mask_tmp;
  int i;
  gchar *separator;
  td_app_message (NULL, _("Exporting CSV file"), TD_MSG_BEGIN);

  /*** Vrification des modules - Checking module */
  mod_child = g_list_nth_data (TD_MOD (mod)->child, 0); /* FIXME: limit  l'ain : +tards */
  if (TD_IS_MOD_TREE (mod_child)) /*** mod_tree */
    ctree = GTK_CTREE (TD_MOD_TREE (mod_child)->widget_data);
  if (TD_IS_MOD_BOX (mod_child)) /*** mod_box */
    ctree = GTK_CTREE (TD_MOD_BOX (mod_child)->widget_data);
  if (!ctree)
    {
      td_app_message (_("Reading module"), g_strdup_printf (_("Reading module : module '%s' unreadable for this export"), TD_MOD (mod)->name), TD_MSG_FAILED);
      td_app_message (NULL, _("Exporting CSV file"), TD_MSG_END);
      return FALSE;
    }

  /*** Ouverture - Open */
  if ((fp = fopen (file, "w")) == NULL)
    {
      td_app_message (_("Saving"), g_strdup_printf (_("Saving : file '%s' unreadable"), file), TD_MSG_FAILED);
      td_app_message (NULL, _("Saving CSV file"), TD_MSG_END);
      return FALSE;
    }

  /*** Titres - Titles */
  separator = td_app_custom_value ("filter", "table", "separator");
  if (!strcmp (td_app_custom_value ("filter", "table", "column title"), "yes"))
    {
      for (i=0; i<GTK_CLIST (ctree)->columns; i++)
	{
	  fprintf (fp, gtk_clist_get_column_title (GTK_CLIST (ctree), i));
	  fprintf (fp, separator);
	}
      fprintf (fp, _("level"));
      fprintf (fp, "\n");
    }

  /*** Valeurs - Values */
  td_app_message (g_strdup_printf ("%s...", _("Writting CSV data")), NULL, TD_MSG_MESSAGE);
  node = gtk_ctree_node_nth (ctree, 0);
  while (node)
    {
      gtk_ctree_node_get_pixtext (ctree, node, 0, &txt_tmp, &spacing_tmp, &pixmap_tmp, &mask_tmp);
      fprintf (fp, txt_tmp);
      for (i=1; i<GTK_CLIST (ctree)->columns; i++)
	{
	  gtk_ctree_node_get_text (ctree, node, i, &txt_tmp);
	  fprintf (fp, separator);
	  fprintf (fp, txt_tmp);
	}
      fprintf (fp, separator);
      fprintf (fp, g_strdup_printf ("%d", GTK_CTREE_ROW (node)->level));
      fprintf (fp, "\n");
      node = gtdk_ctree_next (node);
    }

  /*** Enregistrement - Writing */
  fclose (fp);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Exporting CSV file"), file), TD_MSG_DONE);
  td_app_message (NULL, _("Exporting CSV file"), TD_MSG_END);
  return TRUE;
}


