/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Filtre PSTriks
 * ToutDoux's plug-in : PSTriks filter
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <math.h>
#include <sys/wait.h>

#include "main.h"

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("PSTtricks filter"),
		  "type", _("filter"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("filter"),
		  "category3", "pstricks",
		  "copyright", "Copyright (c) 2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

GtkObject *plugins_init (int mod_id)
{
  GtkObject *ret;
  ret = td_mod_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "gfx_pstricks",
		  "name_intl", _("PSTtricks filter"),
		  "id", -1, NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def());
  return ret;
}

void plugins_destroy (gpointer user_data)
{
}

gchar *unit (gchar* value)
{
  if (!value)
    return NULL;
  if ((strstr (value, "pt")) ||
      (strstr (value, "mm")) ||
      (strstr (value, "cm")) ||
      (strstr (value, "in")) ||
      (strstr (value, "pc")) ||
      (strstr (value, "em")) ||
      (strstr (value, "ex")) ||
      (strstr (value, "bp")) ||
      (strstr (value, "dd")) ||
      (strstr (value, "cc")) ||
      (strstr (value, "sp")))
    return value;
  return g_strdup_printf ("%spt", value);
}

/*****************************************************************************/
/*** Document */
/*****************************************************************************/
void definition_document (FILE *fp, GtkObject *mod)
{
  gchar *title;

  /*** Commentaires - Comments */
  title = td_app_custom_value ("filter", "general", "title");
  title = td_string_replace (title, "$file", TD_DB_CONNECT (TD_APP(APP)->connect)->name);
  title = td_string_replace (title, "$module", TD_MOD (mod)->name_intl);
  fprintf (fp, "%% %s: %s\n", _("Title"), title);
  fprintf (fp, "%% %s: %s\n", _("Filter"), _("PSTtricks filter"));
  fprintf (fp, "%% %s: %s\n", _("Description"), td_app_custom_value ("filter", "general", "description"));

  /*** Classe du document - Document class */
  fprintf (fp, "\\documentclass[");
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "document", "class", "char size")))
    fprintf (fp, "%s", td_filter_custom_value ("gfx_pstricks", "document", "class", "char size"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "document", "class", "paper size")))
    fprintf (fp, ",%s", td_filter_custom_value ("gfx_pstricks", "document", "class", "paper size"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "document", "class", "others options")))
    fprintf (fp, ",%s]{%s}\n", 
	     td_filter_custom_value ("gfx_pstricks", "document", "class", "others options"),
	     td_filter_custom_value ("gfx_pstricks", "document", "class", "name"));
  else
    fprintf (fp, "]{%s}\n", td_filter_custom_value ("gfx_pstricks", "document", "class", "name"));

  /*** Localisation - Localization */
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "document", "localization", "babel")))
    fprintf (fp, "\\usepackage[%s]{babel}\n", td_filter_custom_value ("gfx_pstricks", "document", "localization", "babel"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "document", "localization", "fontenc")))
    fprintf (fp, "\\usepackage[%s]{fontenc}\n", td_filter_custom_value ("gfx_pstricks", "document", "localization", "fontenc"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "document", "localization", "inputenc")))
    fprintf (fp, "\\usepackage[%s]{inputenc}\n", td_filter_custom_value ("gfx_pstricks", "document", "localization", "inputenc"));

  /*** Paquet - Package */
  fprintf (fp, "\\usepackage{color}\n");
  fprintf (fp, "\\usepackage{graphics}\n");
  fprintf (fp, "\\usepackage{pstricks}\n\n");

  /*** Couleurs - Colors  */
  /*  % Definition of new colors */
  /*  \definecolor{Gold}        {rgb}{1.,0.84,0.} */
  /*  \definecolor{LemonChiffon}{rgb}{1.,0.98,0.8} */
  /*  \definecolor{LightBlue}   {rgb}{0.68,0.85,0.9} */
  /*  \definecolor{LightCyan}   {rgb}{0.88,1.,1.} */
  /*  \definecolor{PaleGreen}   {rgb}{0.88,1,0.88} */
  /*  \definecolor{Pink}        {rgb}{1.,0.75,0.8} */

  /*** Mise en page - Layout */
  fprintf (fp, "%% %s\n", _("Pagination"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "localization")))
    fprintf (fp, "\\usepackage[%s]{layout}\n", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "localization"));
  else
    fprintf (fp, "\\usepackage{layout}\n");
  fprintf (fp, "\\usepackage{fancyhdr}\n");
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "pagewidth")))
    fprintf (fp, "\\hsize=%s\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "pagewidth")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "pageheight")))
    fprintf (fp, "\\vsize=%s\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "pageheight")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "textwidth")))
    fprintf (fp, "\\setlength{\\textwidth}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "textwidth")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "textheight")))
    fprintf (fp, "\\setlength{\\textheight}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "textheight")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "oddsidemargin")))
    fprintf (fp, "\\setlength{\\oddsidemargin}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "oddsidemargin")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "marginparsep")))
    fprintf (fp, "\\setlength{\\marginparsep}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "marginparsep")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "marginparwidth")))
    fprintf (fp, "\\setlength{\\marginparwidth}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "marginparwidth")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "topmargin")))
    fprintf (fp, "\\setlength{\\topmargin}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "topmargin")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "headheight")))
    fprintf (fp, "\\setlength{\\headheight}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "headheight")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "headsep")))
    fprintf (fp, "\\setlength{\\headsep}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "headsep")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "footskip")))
    fprintf (fp, "\\setlength{\\footskip}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "footskip")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "hoffset")))
    fprintf (fp, "\\setlength{\\hoffset}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "hoffset")));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "voffset")))
    fprintf (fp, "\\setlength{\\voffset}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "voffset")));
  fprintf (fp, "\n");

  /*** Entte - Header */
  fprintf (fp, "%% %s\n", _("Header"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "head", "lhead")))
    fprintf (fp, "\\lhead{%s}\n", td_filter_custom_value ("gfx_pstricks", "pagination", "head", "lhead"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "head", "chead")))
    fprintf (fp, "\\chead{%s}\n", td_filter_custom_value ("gfx_pstricks", "pagination", "head", "chead"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "head", "rhead")))
    fprintf (fp, "\\rhead{%s}\n", td_filter_custom_value ("gfx_pstricks", "pagination", "head", "rhead"));
  fprintf (fp, "\\renewcommand{\\headrulewidth}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "head", "headrulewidth")));
  fprintf (fp, "\n");

  /*** Pied de page - Footer */
  fprintf (fp, "%% %s\n", _("Footer"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "foot", "lfoot")))
    fprintf (fp, "\\lfoot{%s}\n", td_filter_custom_value ("gfx_pstricks", "pagination", "foot", "lfoot"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "foot", "cfoot")))
    fprintf (fp, "\\cfoot{%s}\n", td_filter_custom_value ("gfx_pstricks", "pagination", "foot", "cfoot"));
  if (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "foot", "rfoot")))
    fprintf (fp, "\\rfoot{%s}\n", td_filter_custom_value ("gfx_pstricks", "pagination", "foot", "rfoot"));
  fprintf (fp, "\\renewcommand{\\footrulewidth}{%s}\n", unit (td_filter_custom_value ("gfx_pstricks", "pagination", "foot", "footrulewidth")));
  if ((strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "head", "lhead"))) ||
      (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "head", "chead"))) ||
      (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "head", "rhead"))) ||
      (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "foot", "lfoot"))) ||
      (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "foot", "cfoot"))) ||
      (strcmp ("none", td_filter_custom_value ("gfx_pstricks", "pagination", "foot", "rfoot"))))
    fprintf (fp, "\\pagestyle{fancy}\n");
  else
    fprintf (fp, "\\pagestyle{empty}\n");
  fprintf (fp, "\n");

  /*** Police de caractres - Font */
  fprintf (fp, "%% %s\n", _("Font"));
  fprintf (fp, "\\usefont{%s}{%s}{%s}{%s}\n\n", 
	   td_filter_custom_value ("gfx_pstricks", "document", "localization", "fontenc"),
	   td_filter_custom_value ("gfx_pstricks", "document", "font", "family"),
	   td_filter_custom_value ("gfx_pstricks", "document", "font", "weight"),
	   td_filter_custom_value ("gfx_pstricks", "document", "font", "slant"));
}

void draw_document (FILE *fp, GtkObject *mod_child)
{
  fprintf (fp, "%% %s\n", _("Document"));
  fprintf (fp, "\\begin{document}\n");

  /*** Maquette - Layout */
  if (!strcmp ("yes", td_filter_custom_value ("gfx_pstricks", "pagination", "layout", "pageup")))
    fprintf (fp, "\\layout\n\n");

  /*** Image - Picture */
  fprintf (fp, "\\begin{pspicture}\n");
  fprintf (fp, "\\rput[bl](%s,%s)",
	   unit (td_filter_custom_value ("gfx_pstricks", "picture", "placement", "x")),
	   unit (td_filter_custom_value ("gfx_pstricks", "picture", "placement", "y")));
  if (strcmp (td_filter_custom_value ("gfx_pstricks", "picture", "placement", "angle"), "none"))
    fprintf (fp, "{\\%s", td_filter_custom_value ("gfx_pstricks", "picture", "placement", "angle"));
  if (!strcmp (td_filter_custom_value ("gfx_pstricks", "picture", "placement", "angle"), "none"))
    fprintf (fp, "{\\tdpicture}\n");
  else
    fprintf (fp, "{\\tdpicture}}\n");
  fprintf (fp, "\\end{pspicture}\n");
  fprintf (fp, "\\end{document}\n");
}

/*****************************************************************************/
/*** Image - Picture */
/*****************************************************************************/
void draw_picture (FILE *fp, GtkObject *mod_child)
{
  /*** Dbut - Begin */
  fprintf (fp, "%% %s\n", _("Draw : picture"));
  fprintf (fp, "\\newcommand{\\tdpicture}{\n");
  fprintf (fp, "\\begin{pspicture}(%s,%s)\n",
	   unit (td_filter_custom_value ("gfx_pstricks", "picture", "size", "width")),
	   unit (td_filter_custom_value ("gfx_pstricks", "picture", "size", "height")));
  fprintf (fp, "\\psclip{\\tdframe(0pt,0pt)(%s,%s)}\n",
	   unit (td_filter_custom_value ("gfx_pstricks", "picture", "size", "width")),
	   unit (td_filter_custom_value ("gfx_pstricks", "picture", "size", "height")));

  /*** Canevas - Canvas */
  /*** BIDOUILLE: le -3 et le +2 - the -3 and the +2 */
  if (TD_IS_MOD_CANVAS (mod_child)) /*** mod_canvas */
    fprintf (fp, "\\rput[bl](-3pt,0pt){\\tdcanvas}\n");
  else
    if (TD_IS_MOD_GANTT (mod_child)) /*** mod_gantt */
      {
	fprintf (fp, "\\tdtimeruler\n");
	fprintf (fp, "\\rput[bl](-3pt,-%dpt){\\tdcanvas}\n", (int) GTK_WIDGET (TD_TIMERULER (TD_MOD_GANTT (mod_child)->timeruler)->widget)->allocation.height+2);
      }

  /*** Fin - End */
  fprintf (fp, "\\endpsclip\n");
  fprintf (fp, "\\end{pspicture}}\n\n");
}

/*****************************************************************************/
/*** Cadre - Frame */
/*****************************************************************************/
void definition_frame (FILE *fp)
{
  fprintf (fp, "\\newpsobject{tdframe}{psframe}{linecolor=%s,linewidth=%s",
	   td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linecolor"),
	   unit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linewidth")));
  if (!strstr (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linestyle"), ","))
    fprintf (fp, ",linestyle=%s", td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linestyle"));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linestyle"), "dashed,"))
    fprintf (fp, ",linestyle=%s,dash=%s %s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linestyle"), NULL, 0),
	     unit (td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linestyle"), NULL, 1)),
	     unit (td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linestyle"), NULL, 2)));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linestyle"), "dotted,"))
    fprintf (fp, ",linestyle=%s,dotsep=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linestyle"), NULL, 0),
	     unit (td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "linestyle"), NULL, 1)));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "border"), ","))
    fprintf (fp, ",border=%s,bordercolor=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "border"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "border"), NULL, 1));
  else
    if (strcmp (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "border"), "0"))
      fprintf (fp, ",border=%s", td_filter_custom_value ("gfx_pstricks", "picture", "frame", "border"));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "doubleline"), ","))
    fprintf (fp, ",doubleline=true,doublesep=%s,doublecolor=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "doubleline"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "doubleline"), NULL, 1));
  else
    if (strcmp (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "doubleline"), "false"))
      fprintf (fp, ",doubleline=%s", td_filter_custom_value ("gfx_pstricks", "picture", "frame", "doubleline"));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "shadow"), ","))
    fprintf (fp, ",shadow=true,shadowsize=%s,shadowangle=%s,shadowcolor=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "shadow"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "shadow"), NULL, 1),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "shadow"), NULL, 2));
  else
    if (strcmp (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "shadow"), "false"))
      fprintf (fp, ",shadow=%s", td_filter_custom_value ("gfx_pstricks", "picture", "frame", "shadow"));
  if (strcmp (td_filter_custom_value ("gfx_pstricks", "picture", "frame", "framearc"), "0"))
    fprintf (fp, ",framearc=%s", td_filter_custom_value ("gfx_pstricks", "picture", "frame", "framearc"));
  fprintf (fp, "}\n");
}

void definition_timeruler (FILE *fp)
{
  fprintf (fp, "\\newpsobject{tdtimerulerline}{psline}{linecolor=%s,linewidth=%s}\n",
	   td_filter_custom_value ("gfx_pstricks", "timeruler", "line", "linecolor"),
	   unit (td_filter_custom_value ("gfx_pstricks", "timeruler", "line", "linewidth")));
}

void draw_timeruler (FILE *fp, GtkObject *mod_child)
{
  int i;
  GnomeCanvasGroup *root = gnome_canvas_root (GNOME_CANVAS (TD_TIMERULER (TD_MOD_GANTT (mod_child)->timeruler)->widget));
  GnomeCanvasItem *item = NULL;
  fprintf (fp, "\\newcommand{\\tdtimeruler}{\n");
  fprintf (fp, "\\textcolor{%s}{\\%s{\\%s{\n",
	   td_filter_custom_value ("gfx_pstricks", "timeruler", "text", "textcolor"),
	   td_filter_custom_value ("gfx_pstricks", "timeruler", "text", "size"),
	   td_filter_custom_value ("gfx_pstricks", "timeruler", "text", "style"));

  /*** Items */
  for (i=0; i < g_list_length (GNOME_CANVAS_GROUP (root)->item_list); i=i+1)
    {
      item = g_list_nth_data (GNOME_CANVAS_GROUP (root)->item_list, i);
      if (GNOME_IS_CANVAS_LINE (item)) /* canvas_line */
	{
	  fprintf (fp, "\\tdtimerulerline");
	  fprintf (fp, "(%.0fpt,%.0fpt)(%.0fpt,%.0fpt)\n",
		   gtdk_canvas_i2ps_x (item, GNOME_CANVAS_LINE (item)->coords[0]),
		   gtdk_canvas_i2ps_y (item, GNOME_CANVAS_LINE (item)->coords[1]),
		   gtdk_canvas_i2ps_x (item, GNOME_CANVAS_LINE (item)->coords[2]),
		   gtdk_canvas_i2ps_y (item, GNOME_CANVAS_LINE (item)->coords[3]));
	  continue;
	}
      if (GNOME_IS_CANVAS_TEXT (item)) /* canvas_text */
	{
	  /*** BIDOUILLE: le 4 - the 4 */
	  fprintf (fp, "\\rput[tl](%.0fpt,%.0fpt){%s}\n",
		   gtdk_canvas_i2ps_x (item, GNOME_CANVAS_TEXT (item)->x),
		   gtdk_canvas_i2ps_y (item, GNOME_CANVAS_TEXT (item)->y)-4,
		   (gchar*) GNOME_CANVAS_TEXT (item)->text);
	  continue;
	}
    }
  fprintf (fp, "}}}}\n");
}

/*****************************************************************************/
/*** Cavenas - Canvas */
/*****************************************************************************/
void definition_canvas (FILE *fp)
{
  fprintf (fp, "%% %s\n", _("Objects : canvas"));

  /*** Nodes */
  fprintf (fp, "\\newpsobject{tdcanvasnodeframe}{psframe}{linecolor=%s,linewidth=%s",
	   td_filter_custom_value ("gfx_pstricks", "node", "line", "linecolor"),
	   unit (td_filter_custom_value ("gfx_pstricks", "node", "line", "linewidth")));
  if (!strstr (td_filter_custom_value ("gfx_pstricks", "node", "line", "linestyle"), ","))
    fprintf (fp, ",linestyle=%s", td_filter_custom_value ("gfx_pstricks", "node", "line", "linestyle"));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "node", "line", "linestyle"), "dashed,"))
    fprintf (fp, ",linestyle=%s,dash=%s %s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "linestyle"), NULL, 0),
	     unit (td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "linestyle"), NULL, 1)),
	     unit (td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "linestyle"), NULL, 2)));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "node", "line", "linestyle"), "dotted,"))
    fprintf (fp, ",linestyle=%s,dotsep=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "linestyle"), NULL, 0),
	     unit (td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "linestyle"), NULL, 1)));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "node", "line", "border"), ","))
    fprintf (fp, ",border=%s,bordercolor=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "border"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "border"), NULL, 1));
  else
    if (strcmp (td_filter_custom_value ("gfx_pstricks", "node", "line", "border"), "0"))
      fprintf (fp, ",border=%s", td_filter_custom_value ("gfx_pstricks", "node", "line", "border"));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "node", "line", "doubleline"), ","))
    fprintf (fp, ",doubleline=true,doublesep=%s,doublecolor=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "doubleline"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "doubleline"), NULL, 1));
  else
    if (strcmp (td_filter_custom_value ("gfx_pstricks", "node", "line", "doubleline"), "false"))
      fprintf (fp, ",doubleline=%s", td_filter_custom_value ("gfx_pstricks", "node", "line", "doubleline"));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "node", "line", "shadow"), ","))
    fprintf (fp, ",shadow=true,shadowsize=%s,shadowangle=%s, shadowcolor=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "shadow"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "shadow"), NULL, 1),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "line", "shadow"), NULL, 2));
  else
    if (strcmp (td_filter_custom_value ("gfx_pstricks", "node", "line", "shadow"), "false"))
      fprintf (fp, ",shadow=%s", td_filter_custom_value ("gfx_pstricks", "node", "line", "shadow"));
  if (strcmp (td_filter_custom_value ("gfx_pstricks", "node", "line", "framearc"), "0"))
    fprintf (fp, ",framearc=%s", td_filter_custom_value ("gfx_pstricks", "node", "line", "framearc"));
  fprintf (fp, ",fillstyle=%s", td_filter_custom_value ("gfx_pstricks", "node", "fill", "fillstyle"));
  if ((!strcmp (td_filter_custom_value ("gfx_pstricks", "node", "fill", "fillstyle"), "solid")) || 
      (strstr (td_filter_custom_value ("gfx_pstricks", "node", "fill", "fillstyle"), "*")))
    fprintf (fp, ",fillcolor=%s", td_filter_custom_value ("gfx_pstricks", "node", "fill", "fillcolor"));
  if ((strcmp (td_filter_custom_value ("gfx_pstricks", "node", "fill", "fillstyle"), "none")) &&
      (strcmp (td_filter_custom_value ("gfx_pstricks", "node", "fill", "fillstyle"), "node")) &&
      (strcmp (td_filter_custom_value ("gfx_pstricks", "node", "fill", "fillstyle"), "solid")))
    fprintf (fp, ",hatchwidth=%s,hatchsep=%s,hatchangle=%s,hatchcolor=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "fill", "hatchsize"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "fill", "hatchsize"), NULL, 1),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "node", "fill", "hatchsize"), NULL, 2),
	     td_filter_custom_value ("gfx_pstricks", "node", "fill", "hatchcolor"));
  fprintf (fp, "}\n");

  /*** Liens - Links */
  fprintf (fp, "\\newpsobject{tdcanvaslinkline}{psline}{linecolor=%s,linewidth=%s",
	   td_filter_custom_value ("gfx_pstricks", "link", "line", "linecolor"),
	   unit (td_filter_custom_value ("gfx_pstricks", "link", "line", "linewidth")));
  if (!strstr (td_filter_custom_value ("gfx_pstricks", "link", "line", "linestyle"), ","))
    fprintf (fp, ",linestyle=%s", td_filter_custom_value ("gfx_pstricks", "link", "line", "linestyle"));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "link", "line", "linestyle"), "dashed,"))
    fprintf (fp, ",dash=%s %s",
	     unit (td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "line", "linestyle"), NULL, 1)),
	     unit (td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "line", "linestyle"), NULL, 2)));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "link", "line", "linestyle"), "dotted,"))
    fprintf (fp, ",dotsep=%s", unit (td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "line", "linestyle"), NULL, 1)));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "link", "line", "border"), ","))
    fprintf (fp, ",border=%s,bordercolor=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "line", "border"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "line", "border"), NULL, 1));
  else
    if (strcmp (td_filter_custom_value ("gfx_pstricks", "node", "line", "border"), "0"))
      fprintf (fp, ",border=%s", td_filter_custom_value ("gfx_pstricks", "link", "line", "border"));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "link", "line", "doubleline"), ","))
    fprintf (fp, ",doubleline=true,doublesep=%s,doublecolor=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "line", "doubleline"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "line", "doubleline"), NULL, 1));
  else
    if (strcmp (td_filter_custom_value ("gfx_pstricks", "link", "line", "doubleline"), "false"))
      fprintf (fp, ",doubleline=%s", td_filter_custom_value ("gfx_pstricks", "link", "line", "doubleline"));
  if (strstr (td_filter_custom_value ("gfx_pstricks", "link", "line", "shadow"), ","))
    fprintf (fp, ",shadow=true,shadowsize=%s,shadowangle=%s,shadowcolor=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "line", "shadow"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "line", "shadow"), NULL, 1),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "line", "shadow"), NULL, 2));
  else
    if (strcmp (td_filter_custom_value ("gfx_pstricks", "link", "line", "shadow"), "false"))
      fprintf (fp, ",shadow=%s", td_filter_custom_value ("gfx_pstricks", "link", "line", "shadow"));
  if (strcmp (td_filter_custom_value ("gfx_pstricks", "link", "line", "linearc"), "0"))
    fprintf (fp, ",linearc=%s", td_filter_custom_value ("gfx_pstricks", "link", "line", "linearc"));
  fprintf (fp, ",arrows=%s", td_filter_custom_value ("gfx_pstricks", "link", "arrow", "style"));
  if (strcmp (td_filter_custom_value ("gfx_pstricks", "link", "arrow", "size"), "none"))
    fprintf (fp, ",arrowsize=%s,arrowlength=%s,arrowinset=%s",
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "arrow", "size"), NULL, 0),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "arrow", "size"), NULL, 1),
	     td_strsplit (td_filter_custom_value ("gfx_pstricks", "link", "arrow", "size"), NULL, 2));
  fprintf (fp, "}\n");

  /*** Poigne - Handle */
  fprintf (fp, "\\newpsobject{tdcanvashandleline}{psline}{linecolor=%s,linewidth=%s}\n",
	   td_filter_custom_value ("gfx_pstricks", "handle", "line", "linecolor"),
	   unit (td_filter_custom_value ("gfx_pstricks", "handle", "line", "linewidth")));
  fprintf (fp, "\\newpsobject{tdcanvashandleframe}{psframe}{linecolor=%s,linewidth=%s}\n\n",
	   td_filter_custom_value ("gfx_pstricks", "handle", "line", "linecolor"),
	   unit (td_filter_custom_value ("gfx_pstricks", "handle", "line", "linewidth")));
}

void draw_canvas (FILE *fp, GtkObject *mod_child, GnomeCanvasGroup *root)
{
  GnomeCanvasItem *item = NULL;
  GnomeCanvasItem *item_parent = NULL;
  int id_item;

  /*** Go ! */
  fprintf (fp, "%% %s\n", _("Draw : canvas"));
  fprintf (fp, "\\newcommand{\\tdcanvas}{\n");
  fprintf (fp, "\\textcolor{%s}{\\%s{\\%s{\n",
	   td_filter_custom_value ("gfx_pstricks", "node", "text", "textcolor"),
	   td_filter_custom_value ("gfx_pstricks", "node", "text", "size"),
	   td_filter_custom_value ("gfx_pstricks", "node", "text", "style"));
  id_item = 0;
  item_parent = GNOME_CANVAS_ITEM (root);
  item = g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, id_item);
  while (item)
    {

      /*** Groupe - Group */
      if (GNOME_IS_CANVAS_GROUP (item))
	{
	  id_item = 0;
	  item_parent = item;
	  item = g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, id_item);
	  continue;
	}

      /*** Item */
      draw_canvas_item (fp, mod_child, item);

      /*** Suivant - Next */
      id_item++;
      if (id_item < g_list_length (GNOME_CANVAS_GROUP (item_parent)->item_list))
	{
	  item = g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, id_item);
	  continue;
	}

      /*** Parent */
      if (TD_IS_MOD_CANVAS (mod_child)) /*** mod_canvas */
	if (GNOME_CANVAS_GROUP (item_parent) == gnome_canvas_root (GNOME_CANVAS (TD_MOD_CANVAS (mod_child)->widget_data)))
	  {
	    item = NULL;
	    continue;
	  }
      if (TD_IS_MOD_GANTT (mod_child)) /*** mod_gantt */
	if (GNOME_CANVAS_GROUP (item_parent) == gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_child)->widget_data)))
	  {
	    item = NULL;
	    continue;
	  }
      do
	{
	  if (!item_parent->parent)
	    {
	      item_parent = NULL;
	      continue;
	    }
	  id_item = g_list_index (GNOME_CANVAS_GROUP (item_parent->parent)->item_list, item_parent)+1;
	  item_parent = item_parent->parent;
	  item = g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, id_item);
	}
      while ((item_parent) && (!item));
    }
  fprintf (fp, "}}}}\n\n");
}

void draw_canvas_item (FILE *fp, GtkObject *mod_child, GnomeCanvasItem *item)
{
  /*** THANKS: fonction avec une grosse partie crite par - function with a big piece written by
       Fichier - File: libgnomeui/gnome-canvas-line.c
       Copyright : Copyright (C) 1998 The Free Software Foundation
       Auteur - Author: Federico Mena <federico@nuclecu.unam.mx> */

  double dx, dy, length;
  double sin_theta, cos_theta, tmp;
  int i;

  /*** Visibilit - Visiblity */
  if (!(item->object.flags & GNOME_CANVAS_ITEM_VISIBLE))
    return;
  if (!(item->parent->object.flags & GNOME_CANVAS_ITEM_VISIBLE))
    return;

  /*** Poigne - Handle */
  if ((gtk_object_get_user_data (GTK_OBJECT (item))) && (strstr (gtk_object_get_user_data (GTK_OBJECT (item)), "handle")))
    {
      if (GNOME_IS_CANVAS_LINE (item)) /* canvas_line */
	{
	  fprintf (fp, "\\tdcanvashandleline");
	  fprintf (fp, "(%.0fpt,%.0fpt)(%.0fpt,%.0fpt)\n",
		   gtdk_canvas_i2ps_x (item, GNOME_CANVAS_LINE (item)->coords[0]),
		   gtdk_canvas_i2ps_y (item, GNOME_CANVAS_LINE (item)->coords[1]),
		   gtdk_canvas_i2ps_x (item, GNOME_CANVAS_LINE (item)->coords[2]),
		   gtdk_canvas_i2ps_y (item, GNOME_CANVAS_LINE (item)->coords[3]));
	  return;
	}
      if (GNOME_IS_CANVAS_RECT (item)) /* canvas_rect */
	{
	  fprintf (fp, "\\tdcanvashandleframe");
	  fprintf (fp, "(%.0fpt,%.0fpt)(%.0fpt,%.0fpt)\n",
		   gtdk_canvas_i2ps_x (item, GNOME_CANVAS_RE (item)->x1),
		   gtdk_canvas_i2ps_y (item, GNOME_CANVAS_RE (item)->y1),
		   gtdk_canvas_i2ps_x (item, GNOME_CANVAS_RE (item)->x2),
		   gtdk_canvas_i2ps_y (item, GNOME_CANVAS_RE (item)->y2));
	  return;
	}
    }

  /*** Nodes */
  if (GNOME_IS_CANVAS_LINE (item)) /* canvas_line */
    {

      /*** Reste de manipulation - Manipulation tempory item */
      if (!strcmp ((gchar*) gtk_object_get_user_data (GTK_OBJECT (item)), "link"))
	return;

      /*** Ligne - Line */
      fprintf (fp, "\\tdcanvaslinkline");
      fprintf (fp, "(%.0fpt,%.0fpt)", 
	       gtdk_canvas_i2ps_x (item, GNOME_CANVAS_LINE (item)->coords[0]), 
	       gtdk_canvas_i2ps_y (item, GNOME_CANVAS_LINE (item)->coords[1]));
      for (i = 2; i < (GNOME_CANVAS_LINE (item)->num_points*2)-2; i=i+2)
	fprintf (fp, "(%.0fpt,%.0fpt)", 
		 gtdk_canvas_i2ps_x (item, GNOME_CANVAS_LINE (item)->coords[i]), 
		 gtdk_canvas_i2ps_y (item, GNOME_CANVAS_LINE (item)->coords[i+1]));
      dx = gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[i])-gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[i-2]); 
      dy = gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[i+1])-gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[i-1]);
      length = sqrt (dx*dx+dy*dy);
      if (length <= 0)
	sin_theta = cos_theta = 0.0;
      else 
	{
	  sin_theta = dy/length;
	  cos_theta = dx/length;
	}
      fprintf (fp, "(%.0fpt,%.0fpt)", 
	       gtdk_canvas_i2ps_x (item, GNOME_CANVAS_LINE (item)->coords[i])+((TD_FACE_LINK_ARROW[0]+TD_FACE_LINK_LINE_WIDTH[0])*cos_theta),
	       gtdk_canvas_i2ps_y (item, GNOME_CANVAS_LINE (item)->coords[i+1])-((TD_FACE_LINK_ARROW[0]+TD_FACE_LINK_LINE_WIDTH[0])*sin_theta)/2);
      fprintf (fp, "\n");
      return;
    }
  if (GNOME_IS_CANVAS_RECT (item)) /* canvas_rect */
    {
      fprintf (fp, "\\tdcanvasnodeframe");
      fprintf (fp, "(%.0fpt,%.0fpt)(%.0fpt,%.0fpt)\n",
	       gtdk_canvas_i2ps_x (item, GNOME_CANVAS_RE (item)->x1),
	       gtdk_canvas_i2ps_y (item, GNOME_CANVAS_RE (item)->y1),
	       gtdk_canvas_i2ps_x (item, GNOME_CANVAS_RE (item)->x2),
	       gtdk_canvas_i2ps_y (item, GNOME_CANVAS_RE (item)->y2));
      return;
    }
  if (GNOME_IS_CANVAS_TEXT (item)) /* canvas_text */
    {
      /*** BIDOUILLE: le 3 - the 3 */
      if (TD_IS_MOD_CANVAS (mod_child)) /*** mod_canvas */
	fprintf (fp, "\\rput[B](%.0fpt,%.0fpt){%s}\n",
		 gtdk_canvas_i2ps_x (item, GNOME_CANVAS_TEXT (item)->x),
		 gtdk_canvas_i2ps_y (item, GNOME_CANVAS_TEXT (item)->y)-3,
		 (gchar*) GNOME_CANVAS_TEXT (item)->text);
      else
	if (TD_IS_MOD_GANTT (mod_child)) /*** mod_gantt */
	  fprintf (fp, "\\rput[tl](%.0fpt,%.0fpt){%s}\n",
		   gtdk_canvas_i2ps_x (item, GNOME_CANVAS_TEXT (item)->x),
		   gtdk_canvas_i2ps_y (item, GNOME_CANVAS_TEXT (item)->y)-3,
		   (gchar*) GNOME_CANVAS_TEXT (item)->text);
      return;
    }
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
gboolean plugins_export (GtkObject *mod, gchar *file)
{
  GnomeCanvasGroup *root = NULL;
  FILE *fp;
  GtkObject *mod_child;
  td_app_message (NULL, _("Exporting PSTricks file"), TD_MSG_BEGIN);
  td_app_message (g_strdup_printf ("%s...", _("Writing PSTricks file")), NULL, TD_MSG_MESSAGE);

  /*** Vrification des modules - Checking module */
  /* FIXME: limit  l'ain : +tards */
  mod_child = g_list_nth_data (TD_MOD (mod)->child, 0);
  if (TD_IS_MOD_CANVAS (mod_child)) /*** mod_canvas */
    root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_CANVAS (mod_child)->widget_data));
  else
    if (TD_IS_MOD_GANTT (mod_child)) /*** mod_gantt */
      root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_child)->widget_data));
  if (!root)
    {
      td_app_message (_("Reading module"), g_strdup_printf (_("Reading module : module '%s' unreadable for this export"), TD_MOD (mod)->name), TD_MSG_FAILED);
      td_app_message (NULL, _("Exporting PSTricks file"), TD_MSG_END);
      return FALSE;
    }

  /*** Vrif de la prsence du fichier - Checking the presence of file */
  fp = fopen (file, "w");
  if (!fp)
    {
      td_app_message (_("Opening file"), NULL, TD_MSG_FAILED);
      td_app_message (NULL, _("Exporting PSTricks file"), TD_MSG_END);
      return FALSE;
    }

  /*** Dfiniton du document - Document defintion */
  TD_PS_HEIGHT_CANVAS = 0;
  TD_PS_HEIGHT = td_atoi (td_filter_custom_value ("gfx_pstricks", "picture", "size", "height"));
  if (TD_IS_MOD_CANVAS (mod_child)) /*** mod_canvas */
    TD_PS_WIDTH_CANVAS = GTK_WIDGET (TD_MOD_CANVAS (mod_child)->widget_data)->allocation.width;
  else
    if (TD_IS_MOD_GANTT (mod_child)) /*** mod_gantt */
      TD_PS_WIDTH_CANVAS = GTK_WIDGET (TD_TIMERULER (TD_MOD_GANTT (mod_child)->timeruler)->widget)->allocation.width;
  TD_PS_WIDTH = td_atoi (td_filter_custom_value ("gfx_pstricks", "picture", "size", "width"));
  definition_document (fp, mod);

  /*** Cadre - Frame */
  fprintf (fp, "%% %s\n", _("Objects : frame"));
  definition_frame (fp);

  /*** Rgle du temps - Timeruler */
  if (TD_IS_MOD_GANTT (mod_child)) /*** mod_gantt */
    {
      fprintf (fp, "%% %s\n", _("Objects : timeruler"));
      definition_timeruler (fp);
      fprintf (fp, "%% %s\n", _("Draw : timeruler"));
      draw_timeruler (fp, mod_child);
    }

  /*** Cavenas - Canvas */
  definition_canvas (fp);
  draw_canvas (fp, mod_child, root);

  /*** Image - Picture */
  draw_picture (fp, mod_child);

  /*** Document */
  draw_document (fp, mod_child);
  fclose (fp);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Exporting PSTricks file"), file), TD_MSG_DONE);
  td_app_message (NULL, _("Exporting PSTricks file"), TD_MSG_END);
  return TRUE;
}

/*****************************************************************************/
/*** Impression - Printing */
/*****************************************************************************/
gboolean plugins_print (GtkObject *mod, gchar *file)
{
  int pid, status, status2;
  gchar *pid_file;
  td_app_message (NULL, _("Printing"), TD_MSG_BEGIN);

  /*** Export */
  if (!plugins_export (mod, g_strdup_printf ("%s/export.tex", TD_PACKAGE_TMP_DIR)))
    {
      td_app_message (_("Exporting to TeX"), NULL, TD_MSG_FAILED);
      td_app_message (NULL, _("Printing"), TD_MSG_END);
      return FALSE;
    }

  /*** TeX vers PostScript - TeX to PostScript */
  if (!td_app_palette_exec (TD_APP_PALETTE (TD_APP (APP)->palette), g_strdup_printf ("latex %s/export.tex", TD_PACKAGE_TMP_DIR), _("Computing TeX...")))
    {
      td_app_message (_("Translating TeX to DVI"), NULL, TD_MSG_FAILED);
      td_app_message (NULL, _("Printing"), TD_MSG_END);
      return FALSE;
    }
  if (!td_system (g_strdup_printf ("mv export.dvi %s/export.dvi && mv export.aux %s/export.aux && mv export.log %s/export.log", TD_PACKAGE_TMP_DIR, TD_PACKAGE_TMP_DIR, TD_PACKAGE_TMP_DIR)))
    {
      td_app_message (_("Moving TeX generated files"), NULL, TD_MSG_FAILED);
      td_app_message (NULL, _("Printing"), TD_MSG_END);
      return FALSE;
    }
  if (!td_system (g_strdup_printf ("dvips %s/export -o %s/export.ps", TD_PACKAGE_TMP_DIR, TD_PACKAGE_TMP_DIR)))
    {
      td_app_message (_("Translating DVI to PostScript"), NULL, TD_MSG_FAILED);
      td_app_message (NULL, _("Printing"), TD_MSG_END);
      return FALSE;
    }

  /*** Visualisation - Visualization */
  if (!td_viewer_ps (g_strdup_printf ("%s/export.ps", TD_PACKAGE_TMP_DIR)))
    {
      td_app_message (_("Viewing PostScript"), NULL, TD_MSG_FAILED);
      td_app_message (NULL, _("Printing"), TD_MSG_END);
      return FALSE;
    }
  td_app_message (NULL, _("Printing"), TD_MSG_END);
  return TRUE;
}
