/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Planification
 * ToutDoux's plug-in : Scheduling system
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gprolog.h>

#include "main.h"

/*****************************************************************************/
/*** Module */
/*****************************************************************************/

/**
 * plugins_about_def:
 * 
 * fr: Retourne les dtails du greffon
 *
 * en: Returns plug-in's details
 *
 * Return value: plug-in details
 **/

GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Schedule"),
		  "type", _("compute"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("project manager"),
		  "category2", _("compute"),
		  "category3", _("schedule"),
		  "copyright", "Copyright (c) 2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

/**
 * plugins_about_def:
 * 
 * fr: Initialise le greffon
 *
 * en: Inits the plug-in
 *
 * Return value: FALSE on error
 **/

gboolean plugins_init (void)
{
  return TRUE;
}

/**
 * plugins_about_def:
 * 
 * fr: Dtruit le greffon
 *
 * en: Destroys the plug-in
 **/

void plugins_destroy (gpointer user_data)
{
}

/*****************************************************************************/
/*** Fonctions - Functions */
/*****************************************************************************/

/**
 * plugins_compute:
 * @input: input
 * 
 * fr: Retourne le rsultat d'une fonction
 *
 * en: Return the result of a function
 *
 * Return value: list
 **/

GList *plugins_compute (GList *input)
{
  GList *output = NULL;
  WamWord arg[10];
  gboolean bool_tmp;

  /*** Dorsal - Backend */
  Start_Prolog (0, NULL);

  /*** Entres - Inputs */
  arg[0] = Mk_Variable();
  arg[1] = Mk_String (g_list_nth_data (input, 0));

  /*** Go ! */
  bool_tmp = Pl_Query_Start (Find_Atom ("anc"), 2, arg, TRUE);
  if (bool_tmp)
    output = g_list_append (output, Rd_String (arg [0]));
  /*    while (bool_tmp) */
  /*      { */
  /*        output = g_list_append (output, Rd_String (arg [0])); */
  /*        bool_tmp = Pl_Query_Next_Solution(); */
  /*      } */
  Pl_Query_End (PL_RECOVER);

  /*** Dorsal - Backend */
  Stop_Prolog();
  return output;
}
