/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : gantt : Diagramme GANTT
 * ToutDoux's plug-in : gantt : GANTT diagram
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <math.h>

#include "main.h"

/* 
 * FIXME: Temps nous gagnerons, par usage abusive du greffon,
 * lments mieux finaliss, la lib retrouvera son autorite.
 */

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("GANTT diagram"),
		  "type", _("view"),
		  "version", "1.0.2",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("project manager"),
		  "category2", _("view"),
		  "category3", _("gantt"),
		  "copyright", "Copyright (c) 2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "icon", "icon_gantt.xpm", NULL);
  return ret;
}

GtkObject *plugins_init (int mod_id, gchar *mod_name)
{
  GtkObject *mod;
  GtkObject *child;
  GtkObject *timeruler;
  gchar *txt_tmp;
  if (!mod_name)
    mod_name = _("GANTT diagram");

  /*** Module */
  mod = td_mod_new();
  gtk_object_set (GTK_OBJECT (mod),
		  "name", "gantt",
		  "name_intl", mod_name,
		  "group", _("Project"),
		  "id", mod_id,
		  "fields", "name, begin, eend, duration, td_id, td_obso", NULL);
  td_mod_set_about (TD_MOD (mod), plugins_about_def());

  /*** Dfinitions - Definition */
  child = td_mod_gantt_new();
  gtk_object_set (GTK_OBJECT (child), 
		  "name", "gantt",
		  "name_intl", _("GANTT diagram"),
		  "reorderable", TRUE,
		  "customize", TRUE,
		  "table", "task",
		  "table_net", "task_net",
		  "table_tree", "task_tree", NULL);
  td_mod_add_child (TD_MOD (mod), child);
  menu_def (mod);

  /*** Echelle des temps - Timeruler */
  timeruler = td_timeruler_new();
  td_mod_gantt_set_timeruler (TD_MOD_GANTT (child), timeruler);
  txt_tmp = td_database_value (g_strdup_printf ("SELECT MIN (begin) FROM %s;", TD_MOD_GANTT (child)->table));
  if (strlen (g_strstrip (txt_tmp)))
    td_timeruler_set_lower (TD_TIMERULER (timeruler), td_date_add_days (td_date_parse (txt_tmp, "year-month-day"), -1));
  else
    td_timeruler_set_lower (TD_TIMERULER (timeruler), td_date_add_days (td_date_current(), -1));

  /*** Cration - Create */
  td_mod_create (TD_MOD (mod));
  return mod;
}

void plugins_refresh (GtkObject *mod, GtkObject *mod_gantt)
{
  GnomeCanvasGroup *root;
  GtkObject *datatable;
  GtkObject *datatable_tree;
  GnomeCanvasItem *item;
  GnomeCanvasItem *item_parent;
  GList *order = NULL;
  int i, j;
  gboolean bool_tmp;
  gchar *item_id, *item_parent_id, *current_id;
  gchar *txt_tmp;
  gchar *query;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data));

  /*** Echelle du temps - Timeruler */
  td_timeruler_set_scale (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler), 13);

  /*** Nodes */
  datatable = data_node_parent (mod_gantt, 0);
  datatable_tree = td_database_select (g_strdup_printf ("SELECT * FROM %s WHERE td_id_parent = 0;", TD_MOD_GANTT (mod_gantt)->table_tree));
  txt_tmp = "0";
  bool_tmp = TRUE;
  while (bool_tmp)
    {
      bool_tmp = FALSE;
      for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable_tree)->item); i++)
	if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tree)->item, i), 2), txt_tmp))
	  {
  	    order = g_list_append (order, g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tree)->item, i), 0));
	    txt_tmp =  g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tree)->item, i), 0);
	    bool_tmp = TRUE;
	    break;
	  }
    }
  for (i=g_list_length (order)-1; i!=-1; i--)
    for (j=0; j<g_list_length (TD_DB_DATATABLE (datatable)->item); j++)
      if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, j), 0), (gchar*) g_list_nth_data (order, i)))
	{
	  add_node (mod_gantt, NULL, NULL, g_list_nth_data (TD_DB_DATATABLE (datatable)->item, j));
	  break;
	}

  /*** Liens - Links */
  datatable = td_database_select (g_strdup_printf ("SELECT td_id, td_id_parent FROM %s WHERE td_id IN (SELECT td_id FROM %s WHERE td_id_parent = 0);",
						   TD_MOD_GANTT (mod_gantt)->table_net, TD_MOD_GANTT (mod_gantt)->table_tree));
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable)->item); i++)
    {
      item = NULL;
      item_parent = NULL;
      item_id = g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), 0);
      item_parent_id = g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), 1);
      for (j=0; j<g_list_length (root->item_list); j++)
	{
	  current_id = gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, j)));
	  if ((!current_id) || (strstr (current_id, ",")))
	    continue;
	  if (!strcmp (current_id, item_id))
	    {
	      item = g_list_nth_data (root->item_list, j);
	      continue;
	    }
	  if (!strcmp (current_id, item_parent_id))
	    {
	      item_parent = g_list_nth_data (root->item_list, j);
	      continue;
	    }
	  if ((item) && (item_parent))
	    break;
	}
      if ((!item) || (!item_parent))
	{
	  td_app_message (_("Refresh gantt"), g_strdup_printf (_("Refresh gantt : link '%s,%s' not find"), item_parent_id, item_id), TD_MSG_FAILED);
	  continue;
	}
      add_link (mod_gantt, item_parent, item, atoi (item_parent_id), atoi (item_id));
    }
  td_mod_unmodified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
}

void plugins_symbol_def (GtkObject *mod_gantt)
{
}

/*****************************************************************************/
/*** Node haut niveau - Node high level */
/*****************************************************************************/
void add_link (GtkObject *mod_gantt, GnomeCanvasItem *parent, GnomeCanvasItem *node, int parent_id, int node_id)
{
  GnomeCanvasItem *line;
  line = gnome_canvas_item_new (gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data)), gnome_canvas_line_get_type(),
				"fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL],
				"width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL],
				"line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL],
				"cap_style", TD_FACE_LINK_LINE_CAP,
				"join_style", TD_FACE_LINK_LINE_JOIN,
				"last_arrowhead", TRUE,
				"arrow_shape_a", TD_FACE_LINK_ARROW[0],
				"arrow_shape_b", TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1],
				"arrow_shape_c", TD_FACE_LINK_ARROW[2], NULL);
  gtk_object_set_user_data (GTK_OBJECT (line), g_strdup_printf ("%d,%d", parent_id, node_id));
  td_mod_gantt_draw_link (TD_MOD_GANTT (mod_gantt), line, parent, node);
  link_setup (mod_gantt, GNOME_CANVAS_ITEM (line));
  gnome_canvas_item_raise_to_top (line);
}

void remove_link (GtkObject *mod_gantt)
{
  int i;
  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_parent); i++)
    gtk_object_destroy (GTK_OBJECT (g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_parent, i)));
  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_child); i++)
    gtk_object_destroy (GTK_OBJECT (g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_child, i)));
  TD_MOD_GANTT (mod_gantt)->selected_link_parent = NULL;
  TD_MOD_GANTT (mod_gantt)->selected_link_child = NULL;
  CURRENT_ID = 0;
  CURRENT_ID_PARENT = 0;
}

GnomeCanvasGroup *add_node (GtkObject *mod_gantt, GnomeCanvasGroup *item_parent, GnomeCanvasGroup *item_sibling, GList *row)
{
  GnomeCanvasGroup *root;
  GnomeCanvasPoints *points;
  GnomeCanvasGroup *group;
  GnomeCanvasGroup *item_parent2;
  GnomeCanvasGroup *handle;
  GnomeCanvasItem *item;
  GList *row_parent;
  GtkObject *draw[2];
  gchar *txt_tmp;
  float x = 0;
  float y = 0;
  float y2 = 0;
  gchar *item_id = NULL;
  gchar *query;
  int i = 0;
  int j;
  int height = TD_MOD_GANTT (mod_gantt)->row_height;
  gchar *id_parent;
  gchar *id_child;
  gchar *id_link;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data));
  if (!item_parent)
    item_parent = root;

  /*** Liens - Links */
  if ((item_parent != root) || (item_sibling))
    {
      if (item_sibling)
	y2 = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item_sibling), 0)-1;
      else
	y2 = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item_parent), 0)+height-1;
      for (i=0; i<g_list_length (root->item_list); i++)
	if (GNOME_IS_CANVAS_LINE (g_list_nth_data (root->item_list, i)))
	  {
	    if (!strcmp ((gchar*) gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, i))), "link"))
	      continue;
	    points = gnome_canvas_points_new (GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->num_points);
	    for (j=0; j<GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->num_points; j++)
	      {
		points->coords[j*2] = GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2];
		if (y2 <= GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2+1])
		  points->coords[j*2+1] = GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2+1]+height;
		else
		  points->coords[j*2+1] = GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2+1];
		td_mod_gantt_link_correct (GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i)));
	      }
	    gnome_canvas_item_set (g_list_nth_data (root->item_list, i), "points", points, NULL);
	    gnome_canvas_points_free (points);
	  }
    }

  /*** Insertion  la racine - Insert to the root */
  if ((item_parent == root) && (item_sibling))
    {

      /*** Coordonne - Coordinate */
      x = (td_date_period_day (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, td_date_parse (g_list_nth_data (row, 1), "year-month-day"))*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)-gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (item_parent), 0);
      y = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item_sibling), 0);

      /*** Node */
      for (i=0; i<g_list_length (item_parent->item_list); i++)
	if (!GNOME_IS_CANVAS_LINE (g_list_nth_data (item_parent->item_list, i)))
	  if (y <= gtdk_canvas_i2w_y (g_list_nth_data (item_parent->item_list, i), 0))
	    gnome_canvas_item_move (g_list_nth_data (item_parent->item_list, i), 0, height);
    }

  /*** Insertion - Insert */
  if ((item_parent != root) && (item_sibling))
    {

      /*** Coordonne - Coordinate */
      x = (td_date_period_day (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, td_date_parse (g_list_nth_data (row, 1), "year-month-day"))*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)-gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (item_parent), 0);
      y = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item_sibling), 0)-gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item_parent), 0);

      /*** Parent */
      gtdk_canvas_handle_set_state (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, 2), TD_HANDLE_OPEN);

      /*** Dcalage - Gap */
      y2 = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item_sibling), 0);
      item_parent2 = item_parent;
      while (item_parent2)
	{

	  /*** Racine - Root */
	  if (item_parent2 == gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data)))
	    {
	      for (i=0; i<g_list_length (item_parent2->item_list); i++)
		if (y2 <= gtdk_canvas_i2w_y (g_list_nth_data (item_parent2->item_list, i), 0))
		  gnome_canvas_item_move (g_list_nth_data (item_parent2->item_list, i), 0, height);
	      item_parent2 = NULL;
	    }

	  /*** Parents */
	  else
	    {
	      for (i=3; i<g_list_length (item_parent2->item_list); i++)
		if (y2 <= gtdk_canvas_i2w_y (g_list_nth_data (item_parent2->item_list, i), 0))
		  gnome_canvas_item_move (g_list_nth_data (item_parent2->item_list, i), 0, height);
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent2)->item_list, 0), "y2", (double) GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent2)->item_list, 0))->y2+height, NULL);
	      item_parent2 = GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (item_parent2)->parent);
	    }
	}
   }

  /*** Ajout  la racine - Add to the root */
  if ((item_parent == root) && (!item_sibling))
    {
      x = td_date_period_day (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, td_date_parse (g_list_nth_data (row, 1), "year-month-day"))*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width;
      y = 0;
      for (i=0; i<g_list_length (item_parent->item_list); i++)
	{
	  if (GNOME_IS_CANVAS_LINE (g_list_nth_data (item_parent->item_list, i)))
	    continue;
	  y2 = GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (g_list_nth_data (item_parent->item_list, i))->item_list, 0))->y2+2+gtdk_canvas_i2w_y (g_list_nth_data (item_parent->item_list, i), 0);
	  if (y<y2)
	    y = y2;
	}
    }

  /*** Ajout - Add */
  if ((item_parent != root) && (!item_sibling))
    {

      /*** Coordonne - Coordinate */
      x = (td_date_period_day (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, td_date_parse (g_list_nth_data (row, 1), "year-month-day"))*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)-gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (item_parent), 0);
      y = GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, 0))->y2+2;

      /*** Parent */
      gtdk_canvas_handle_set_state (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, 2), TD_HANDLE_OPEN);
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, 0), "y2", (double) GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, 0))->y2+height, NULL);

      /*** Dcalage - Gap */
      y2 = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item_parent), 0);
      item_parent2 = GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (item_parent)->parent);
      while (item_parent2)
	{

	  /*** Racine - Root */
	  if (item_parent2 == gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data)))
	    {
	      for (i=0; i<g_list_length (item_parent2->item_list); i++)
		if (y2 < gtdk_canvas_i2w_y (g_list_nth_data (item_parent2->item_list, i), 0))
		  gnome_canvas_item_move (g_list_nth_data (item_parent2->item_list, i), 0, height);
	      item_parent2 = NULL;
	    }

	  /*** Parents */
	  else
	    {
	      for (i=3; i<g_list_length (item_parent2->item_list); i++)
		if (y2 < gtdk_canvas_i2w_y (g_list_nth_data (item_parent2->item_list, i), 0))
		  gnome_canvas_item_move (g_list_nth_data (item_parent2->item_list, i), 0, height);
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent2)->item_list, 0), "y2", (double) GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent2)->item_list, 0))->y2+height, NULL);
	      item_parent2 = GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (item_parent2)->parent);
	    }
	}
    }

  /*** Groupe - Group */
  group = GNOME_CANVAS_GROUP (gnome_canvas_item_new (item_parent, gnome_canvas_group_get_type(),
						     "x", (double) x,
						     "y", (double) y, NULL));
  node_setup (mod_gantt, GNOME_CANVAS_ITEM (group));
  gtk_object_set_user_data (GTK_OBJECT (group), g_list_nth_data (row, 0));

  /*** Cadre - Frame */
  node_setup (mod_gantt, GNOME_CANVAS_ITEM (group));
  x = td_date_period_day (td_date_parse (g_list_nth_data (row, 1), "year-month-day"), td_date_parse (g_list_nth_data (row, 2), "year-month-day"))*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width;
  gnome_canvas_item_new (group, gnome_canvas_rect_get_type(),
			 "x1", (double) 0,
			 "y1", (double) 0,
			 "x2", (double) x,
			 "y2", (double) height-2,
			 "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
			 "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
			 "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);

  /*** Etiquette - Label */
  if (TD_MOD_GANTT (mod_gantt)->label_form)
    {
      txt_tmp = TD_MOD_GANTT (mod_gantt)->label_form;
      for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->label_field); i++)
	txt_tmp = td_string_replace (txt_tmp, g_strdup_printf ("$%s", (gchar*) g_list_nth_data (TD_MOD_GANTT (mod_gantt)->label_field, i)), g_list_nth_data (row, i+3));
      gnome_canvas_item_new (group, gnome_canvas_text_get_type(),
			     "text", txt_tmp,
			     "x", (double) 2*TD_FACE_LINK_ARROW[2]+4+8+4,
			     "y", (double) 2,
			     "font_gdk", gtk_widget_get_default_style()->font,
			     "justification", GTK_JUSTIFY_LEFT,
			     "anchor", GTK_ANCHOR_NORTH_WEST,
			     "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_NORMAL], NULL);
    }

  /*** Poigne - Handle */
  handle = gtdk_canvas_handle (group, 2*TD_FACE_LINK_ARROW[2]+4, height/2);
  txt_tmp = td_database_value (g_strdup_printf ("SELECT td_id FROM %s WHERE td_id_parent = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, (gchar*) g_list_nth_data (row, 0)));
  handle_setup (mod_gantt, handle);
  if (!txt_tmp)
    gtdk_canvas_handle_set_state (handle, TD_HANDLE_HIDE);
  else
    gtdk_canvas_handle_set_state (handle, TD_HANDLE_CLOSE);
  gtk_object_set_user_data (GTK_OBJECT (handle), g_strdup_printf ("%s_handle", (gchar*) g_list_nth_data (row, 0)));
  return group;
}

void update_node (GtkObject *mod_gantt, GnomeCanvasGroup *item)
{
  GList *row;
  gchar *txt_tmp;
  int i, node_id;

  /*** Donnes - Data */
  if (!item)
    {
      item = TD_MOD_GANTT (mod_gantt)->selected;
      node_id = CURRENT_ID;
    }
  else
    node_id = atoi (gtk_object_get_user_data (GTK_OBJECT (item)));
  if ((!TD_MOD_GANTT (mod_gantt)->label_form) || (g_list_length (TD_MOD_GANTT (mod_gantt)->label_field) == 0))
    return;
  txt_tmp = "SELECT ";
  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->label_field); i++)
    {
      txt_tmp = g_strdup_printf ("%s%s", txt_tmp, (gchar*) g_list_nth_data (TD_MOD_GANTT (mod_gantt)->label_field, i));
      if (i != g_list_length (TD_MOD_GANTT (mod_gantt)->label_field)-1)
	txt_tmp = g_strdup_printf ("%s, ", txt_tmp);
    }
  txt_tmp = g_strdup_printf ("%s FROM %s WHERE td_id = %d;", txt_tmp, TD_MOD_GANTT (mod_gantt)->table, node_id);
  row = td_database_row (txt_tmp);

  /*** Etiquette - Label */
  txt_tmp = TD_MOD_GANTT (mod_gantt)->label_form;
  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->label_field); i++)
    txt_tmp = td_string_replace (txt_tmp, g_strdup_printf ("$%s", (gchar*) g_list_nth_data (TD_MOD_GANTT (mod_gantt)->label_field, i)), g_list_nth_data (row, i));
  gnome_canvas_item_set (g_list_nth_data (item->item_list, 1), "text", txt_tmp, NULL);
  return;
}

void remove_node (GtkObject *mod_gantt, GnomeCanvasGroup *item)
{
  GnomeCanvasGroup *root;
  int i, j, height_item;
  float y;
  float y2 = 0;
  GnomeCanvasGroup *item_parent;
  GnomeCanvasGroup *item_parent2;
  gchar *item_id = NULL;
  GnomeCanvasPoints *points;
  int height = TD_MOD_GANTT (mod_gantt)->row_height;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data));
  item_parent = GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (item)->parent);
  height_item = GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0))->y2+2;

  /*** Nodes */
  y = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item), 0);
  item_parent2 = item_parent;
  while (item_parent2)
    {

      /*** Racine - Root */
      if (item_parent2 == gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data)))
	{
	  for (i=0; i<g_list_length (item_parent2->item_list); i++)
	    if (!GNOME_IS_CANVAS_LINE (g_list_nth_data (item_parent2->item_list, i)))
	      if (y < gtdk_canvas_i2w_y (g_list_nth_data (item_parent2->item_list, i), 0))
		gnome_canvas_item_move (g_list_nth_data (item_parent2->item_list, i), 0, -height_item);
	  item_parent2 = NULL;
	}

      /*** Parents */
      else
	{
	  for (i=3; i<g_list_length (item_parent2->item_list); i++)
	    if (y < gtdk_canvas_i2w_y (g_list_nth_data (item_parent2->item_list, i), 0))
	      gnome_canvas_item_move (g_list_nth_data (item_parent2->item_list, i), 0, -height_item);
	  y = GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent2)->item_list, 0))->y2;
	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent2)->item_list, 0), "y2", (double) y-height_item, NULL);
	  y = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item_parent2), 0);
	  item_parent2 = GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (item_parent2)->parent);	
	}
    }

  /*** Liens - Links */
  y2 = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item), 0)-1;
  for (i=0; i<g_list_length (root->item_list); i++)
    if (GNOME_IS_CANVAS_LINE (g_list_nth_data (root->item_list, i)))
      {
	if (!strcmp ((gchar*) gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, i))), "link"))
	  continue;
	points = gnome_canvas_points_new (GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->num_points);
	for (j=0; j<GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->num_points; j++)
	  {
	    points->coords[j*2] = GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2];
	    if (y2 <= GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2+1])
	      points->coords[j*2+1] = GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2+1]-height_item;
	    else
	      points->coords[j*2+1] = GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2+1];
	    td_mod_gantt_link_correct (GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i)));
	  }
	gnome_canvas_item_set (g_list_nth_data (root->item_list, i), "points", points, NULL);
	gnome_canvas_points_free (points);
      }

  /*** Node */
  if (item == TD_MOD_GANTT (mod_gantt)->selected)
    {
      CURRENT_ID = 0;
      CURRENT_ID_PARENT = 0;
      CURRENT_ROW = NULL;
      TD_MOD_GANTT (mod_gantt)->selected = NULL;
    }
  gtk_object_destroy (GTK_OBJECT (item));

  /*** Poigne - Handle */
  if ((item_parent != gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data))) &&
      (g_list_length (item_parent->item_list)<4))
    gtdk_canvas_handle_set_state (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, 2), TD_HANDLE_HIDE);
}

/*****************************************************************************/
/*** Node bas niveau - Node low level */
/*****************************************************************************/
void expand_node (GnomeCanvasGroup *node, GtkObject *mod_gantt)
{
  int i, j;
  GtkObject *datatable;
  GtkObject *datatable_tree;
  GList *order = NULL;
  gboolean bool_tmp;
  gchar *txt_tmp;
  gchar *query;

  /*** Donnes - Data */
  txt_tmp = gtk_object_get_user_data (GTK_OBJECT (node));
  datatable = data_node_parent (mod_gantt, atoi (txt_tmp));
  datatable_tree = td_database_select (g_strdup_printf ("SELECT * FROM %s WHERE td_id_parent = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, txt_tmp));
  if (g_list_length (TD_DB_DATATABLE (datatable_tree)->item)==0)
    return;

  /*** Classement - Sorting */
  txt_tmp = "0";
  order = NULL;
  bool_tmp = TRUE;
  while (bool_tmp)
    {
      bool_tmp = FALSE;
      for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable_tree)->item); i++)
	if (!strcmp (g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tree)->item, i), 2), txt_tmp))
	  {
	    order = g_list_append (order, g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tree)->item, i), 0));
	    txt_tmp =  g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tree)->item, i), 0);
	    bool_tmp = TRUE;
	    break;
	  }
    }

  /*** Node */
  for (i=g_list_length (order)-1; i!=-1; i--)
    for (j=0; j<g_list_length (TD_DB_DATATABLE (datatable)->item); j++)
      if (!strcmp (g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, j), 0), g_list_nth_data (order, i)))
	{
	  add_node (mod_gantt, node, NULL, g_list_nth_data (TD_DB_DATATABLE (datatable)->item, j));
	  break;
	}
  return;
}

void collapse_node (GnomeCanvasGroup *node, GtkObject *mod_gantt)
{
  GnomeCanvasGroup *root;
  int i, j, height_item;
  float y, y2;
  GnomeCanvasGroup *item;
  GnomeCanvasGroup *item_parent;
  GnomeCanvasGroup *item_parent2;
  gchar *item_id = NULL;
  GnomeCanvasPoints *points;
  int height = TD_MOD_GANTT (mod_gantt)->row_height;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data));

  /*** Go ! */
  for (;3<g_list_length (node->item_list);)
    {
      item = GNOME_CANVAS_GROUP (g_list_nth_data (node->item_list, 3));
      item_parent = GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (item)->parent);
      height_item = GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0))->y2+2;

      /*** Nodes */
      y2 = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item), 0);
      item_parent2 = item_parent;
      while (item_parent2)
	{

	  /*** Racine - Root */
	  if (item_parent2 == gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data)))
	    {
	      for (i=0; i<g_list_length (item_parent2->item_list); i++)
		if (!GNOME_IS_CANVAS_LINE (g_list_nth_data (item_parent2->item_list, i)))
		  if (y2 < gtdk_canvas_i2w_y (g_list_nth_data (item_parent2->item_list, i), 0))
		    gnome_canvas_item_move (g_list_nth_data (item_parent2->item_list, i), 0, -height_item);
	      item_parent2 = NULL;
	    }

	  /*** Parents */
	  else
	    {
	      for (i=3; i<g_list_length (item_parent2->item_list); i++)
		if (y2 < gtdk_canvas_i2w_y (g_list_nth_data (item_parent2->item_list, i), 0))
		  gnome_canvas_item_move (g_list_nth_data (item_parent2->item_list, i), 0, -height_item);
	      y2 = GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent2)->item_list, 0))->y2;
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item_parent2)->item_list, 0), "y2", (double) y2-height_item, NULL);
	      y2 = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item_parent2), 0);
	      item_parent2 = GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (item_parent2)->parent);
	    }
	}

      /*** Liens - Links */
      y2 = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item), 0)-1;
      for (i=0; i<g_list_length (root->item_list); i++)
	if (GNOME_IS_CANVAS_LINE (g_list_nth_data (root->item_list, i)))
	  {
	    if (!strcmp ((gchar*) gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, i))), "link"))
	      continue;
	    points = gnome_canvas_points_new (GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->num_points);
	    for (j=0; j<GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->num_points; j++)
	      {
		points->coords[j*2] = GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2];
		if (y2 <= GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2+1])
		  points->coords[j*2+1] = GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2+1]-height_item;
		else
		  points->coords[j*2+1] = GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i))->coords[j*2+1];
		td_mod_gantt_link_correct (GNOME_CANVAS_LINE (g_list_nth_data (root->item_list, i)));
	      }
	    gnome_canvas_item_set (g_list_nth_data (root->item_list, i), "points", points, NULL);
	    gnome_canvas_points_free (points);
	  }

      /*** Node */
      if (item == TD_MOD_GANTT (mod_gantt)->selected)
	{
	  CURRENT_ID = 0;
	  CURRENT_ID_PARENT = 0;
	  CURRENT_ROW = NULL;
	  TD_MOD_GANTT (mod_gantt)->selected = NULL;
	}
      gtk_object_destroy (GTK_OBJECT (item));
    }
}

void link_setup (GtkObject *mod_gantt, GnomeCanvasItem *item)
{
  gtk_signal_connect (GTK_OBJECT (item), "event", GTK_SIGNAL_FUNC (link_event), mod_gantt);
}

void link_event (GnomeCanvasItem *item, GdkEvent *event, GtkObject *mod_gantt)
{
  gboolean bool_tmp;
  int i;

  /*** Eclairage - Prelight */
  switch (event->type) 
    {
    case GDK_ENTER_NOTIFY:
      gnome_canvas_item_set (item,
			     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_PRELIGHT],
			     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_PRELIGHT],
			     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_PRELIGHT], NULL);
      gnome_canvas_item_raise_to_top (item);
      break;
    case GDK_LEAVE_NOTIFY:
      bool_tmp = FALSE;
      for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_parent); i++)
	if (g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_parent, i) == item)
	  {

	    /*** Selectionn - Selected */
	    if (!TD_MOD_GANTT (mod_gantt)->selected)
	      gnome_canvas_item_set (item,
				     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_SELECTED],
				     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_SELECTED],
				     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_SELECTED], NULL);

	    /*** Parent */
	    else
	      gnome_canvas_item_set (item,
				     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_PARENT],
				     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_PARENT],
				     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_PARENT], NULL);
	    bool_tmp = TRUE;
	    break;
	  }

      /*** Enfant - Child */
      if (!bool_tmp)
	for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_child); i++)
	  if (g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_child, i) == item)
	    {
	      gnome_canvas_item_set (item,
				     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_CHILD],
				     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_CHILD],
				     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_CHILD], NULL);
	      bool_tmp = TRUE;
	      break;
	    }

      /*** Normal */
      if (!bool_tmp)
	gnome_canvas_item_set (item,
			       "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL],
			       "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL],
			       "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL], NULL);
      break;
    default:
      break;
    }
}

void handle_setup (GtkObject *mod_gantt, GnomeCanvasGroup *handle)
{
  gtk_signal_connect (GTK_OBJECT (handle), "event", GTK_SIGNAL_FUNC (handle_event), mod_gantt);
}

void handle_event (GnomeCanvasGroup *handle, GdkEvent *event, GtkObject *mod_gantt)
{
  if (event->type == GDK_BUTTON_PRESS)
    {
      if (gtdk_canvas_handle_get_state (handle) == TD_HANDLE_CLOSE)
	{
	  gtdk_canvas_handle_set_state (handle, TD_HANDLE_OPEN);
	  expand_node (GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (handle)->parent), mod_gantt);
	}
      else
	if (gtdk_canvas_handle_get_state (handle) == TD_HANDLE_OPEN)
	  {
	    gtdk_canvas_handle_set_state (handle, TD_HANDLE_CLOSE);
	    collapse_node (GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (handle)->parent), mod_gantt);
	  }
    }
}

void node_setup (GtkObject *mod_gantt, GnomeCanvasItem *item)
{
  gtk_signal_connect (GTK_OBJECT (item), "event", GTK_SIGNAL_FUNC (node_event), mod_gantt);
}

void node_event (GnomeCanvasItem *item, GdkEvent *event, GtkObject *mod_gantt)
{
  GdkEventButton *bevent;
  GnomeCanvasPoints *points;
  GnomeCanvasGroup *root;
  GnomeCanvasItem *node;
  GnomeCanvasItem *node2;
  GnomeCanvasItem *line;
  GdkColor color;
  GdkColor line_color;
  double new_x, new_y, item_x, item_y;
  GdkCursor *cursor = NULL;
  GDate *begin;
  GDate *end;
  GDate *day_tmp;
  int id_tmp = 0;
  int duration;
  double x, x1, x2, x3, y1;
  int delta_x, delta_day;
  int height = TD_MOD_GANTT (mod_gantt)->row_height;
  gchar *drop_id_sibling = NULL;
  gchar *drag_id, *drag_id_sibling, *drop_id, *drop_id_parent;
  int i;
  gboolean bool_tmp;
  GList *list_childs;
  item_x = event->button.x;
  item_y = event->button.y;
  bevent = (GdkEventButton*) event;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data));

  /*** Go ! */
  switch (event->type) 
    {

      /*** Eclairage - Prelight */
    case GDK_ENTER_NOTIFY:
      if (GNOME_IS_CANVAS_GROUP (item))
	{
  	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
				 "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_PRELIGHT],
				 "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_PRELIGHT],
				 "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_PRELIGHT], NULL);
  	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_PRELIGHT], NULL);
	}
      break;
    case GDK_LEAVE_NOTIFY:
      if (TD_MOD_GANTT (mod_gantt)->selected)
	{

	  /*** Selectionn - Selected */
	  bool_tmp = FALSE;
	  if (GNOME_CANVAS_ITEM (TD_MOD_GANTT (mod_gantt)->selected) == item)
	    {
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
				     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_SELECTED],
				     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_SELECTED],
				     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_SELECTED], NULL);
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_SELECTED], NULL);
	      bool_tmp = TRUE;
	      break;
	    }

	  /*** Parent */
	  if (bool_tmp)
	    break;
	  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_parent); i++)
	    if (g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_parent, i) == item)
	      {
		gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
				       "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_PARENT],
				       "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_PARENT],
				       "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_PARENT], NULL);
		gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_PARENT], NULL);
		bool_tmp = TRUE;
		break;
	      }

	  /*** Enfant - Child */
	  if (bool_tmp)
	    break;
	  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_child); i++)
	    if (g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_child, i) == item)
	      {
		gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
				       "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_CHILD],
				       "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_CHILD],
				       "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_CHILD], NULL);
		gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_CHILD], NULL);
		bool_tmp = TRUE;
		break;
	      }

	  /*** Normal */
	  if (bool_tmp)
	    break;
	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
				 "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
				 "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
				 "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);
	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_NORMAL], NULL);
	}

      /*** Normal */
      else
	gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
			       "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
			       "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
			       "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_NORMAL], NULL);
      break;

      /*** Selection */
    case GDK_BUTTON_PRESS:
      TD_MOD_GANTT (mod_gantt)->init_x = item_x;
      TD_MOD_GANTT (mod_gantt)->init_y = item_y;
      TD_MOD_GANTT (mod_gantt)->dragging_x = item_x;
      TD_MOD_GANTT (mod_gantt)->dragging_y = item_y;

      /*** Dplacement - Move */
      if ((gtdk_mouse_event (bevent, TD_EVENT_MOUSE_SELECT)) && (GNOME_IS_CANVAS_GROUP (item)))
	TD_MOD_GANTT (mod_gantt)->dragging = 1;

      /*** Taille - Size */
      else
	if ((gtdk_mouse_event (bevent, TD_EVENT_MOUSE_RESIZE)) && (GNOME_IS_CANVAS_GROUP (item)))
	  {
	    cursor = gtdk_cursor (TD_STOCK_CURSOR_RESIZE, TD_STOCK_CURSOR_RESIZE_MASK);
	    x1 = gtdk_canvas_w2i_x (item, item_x);
	    x2 = GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_GANTT (mod_gantt)->selected)->item_list, 0))->x2;
	    if (x1<x2/2)
	      TD_MOD_GANTT (mod_gantt)->dragging = 2;
	    else
	      TD_MOD_GANTT (mod_gantt)->dragging = 3;
	  }

      /*** Dnd dplacement - Dnd move */
	else
	  if ((gtdk_mouse_event (bevent, TD_EVENT_MOUSE_MOVE)) && (GNOME_IS_CANVAS_GROUP (item)))
	    {
	      cursor = gtdk_cursor (TD_STOCK_CURSOR_DND_MOVE, TD_STOCK_CURSOR_DND_MOVE_MASK);
	      draw_dnd_line (mod_gantt, item_x, item_y);
	      TD_MOD_GANTT (mod_gantt)->dragging = 4;
	    }

      /*** Dnd copie - Dnd copy */
	  else
	    if ((gtdk_mouse_event (bevent, TD_EVENT_MOUSE_COPY)) && (GNOME_IS_CANVAS_GROUP (item)))
	      {
		cursor = gtdk_cursor (TD_STOCK_CURSOR_DND_COPY, TD_STOCK_CURSOR_DND_COPY_MASK);
		draw_dnd_line (mod_gantt, item_x, item_y);
		TD_MOD_GANTT (mod_gantt)->dragging = 5;
	      }

      /*** Liaison - Link */
	    else
	      if ((gtdk_mouse_event (bevent, TD_EVENT_MOUSE_LINK)) && (GNOME_IS_CANVAS_GROUP (item)))
		{
		  cursor = gtdk_cursor (TD_STOCK_CURSOR_PENCIL, TD_STOCK_CURSOR_PENCIL_MASK);
		  TD_MOD_GANTT (mod_gantt)->dragging_x = item_x;
		  TD_MOD_GANTT (mod_gantt)->dragging_y = item_y;
		  TD_MOD_GANTT (mod_gantt)->dragging = 2;
		  points = gnome_canvas_points_new (2);
		  points->coords[0] = item_x;
		  points->coords[1] = item_y;
		  points->coords[2] = item_x;
		  points->coords[3] = item_y;
		  TD_MOD_GANTT (mod_gantt)->link = gnome_canvas_item_new (root, gnome_canvas_line_get_type(),
									  "points", points,
									  "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL],
									  "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL],
									  "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL], NULL);
		  gtk_object_set_user_data (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->link), "link");
		  gnome_canvas_points_free (points);
		  TD_MOD_GANTT (mod_gantt)->dragging = 6;
		}
      if (cursor)
	{
	  gnome_canvas_item_grab (item, GDK_POINTER_MOTION_MASK | GDK_BUTTON_RELEASE_MASK, cursor, bevent->time);
	  gdk_cursor_destroy (cursor);
	}
      break;

      /*** Dplacement - Move */
    case GDK_MOTION_NOTIFY:
      new_x = item_x;
      new_y = item_y;
      switch (TD_MOD_GANTT (mod_gantt)->dragging) 
	{

	  /*** Dure constante - Constant duration */
	case 1:
	  if (TD_MOD_GANTT (mod_gantt)->init_x == TD_MOD_GANTT (mod_gantt)->dragging_x)
	    {
	      cursor = gtdk_cursor (TD_STOCK_CURSOR_MOVE, TD_STOCK_CURSOR_MOVE_MASK);
	      gnome_canvas_item_grab (item, GDK_POINTER_MOTION_MASK | GDK_BUTTON_RELEASE_MASK, cursor, event->button.time);
	      gdk_cursor_destroy (cursor);
	    }
	  gnome_canvas_item_move (item, new_x - TD_MOD_GANTT (mod_gantt)->dragging_x, 0);
	  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_parent); i++)
	    td_mod_gantt_draw_link (TD_MOD_GANTT (mod_gantt), g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_parent, i), NULL, item);
  	  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_child); i++)
	    td_mod_gantt_draw_link (TD_MOD_GANTT (mod_gantt), g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_child, i), item, NULL);
	  /* FIXME: dplacement des liens des enfants : + tards */ 
/*    	  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_familly); i++) */
/*  	    td_mod_gantt_draw_link (TD_MOD_GANTT (mod_gantt), g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_familly, i), NULL, NULL); */
	  break;

	  /*** Taille dbut - Size begin */
	case 2:
	  gnome_canvas_item_move (item, new_x - TD_MOD_GANTT (mod_gantt)->dragging_x, 0);
	  x2 = GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_GANTT (mod_gantt)->selected)->item_list, 0))->x2;
	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_GANTT (mod_gantt)->selected)->item_list, 0), "x2", x2-(new_x-TD_MOD_GANTT (mod_gantt)->dragging_x), NULL);
	  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_parent); i++)
	    td_mod_gantt_draw_link (TD_MOD_GANTT (mod_gantt), g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_parent, i), NULL, item);
  	  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_child); i++)
	    td_mod_gantt_draw_link (TD_MOD_GANTT (mod_gantt), g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_child, i), item, NULL);
	  break;

	  /*** Taille fin - Size end */
	case 3:
	  x2 = GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_GANTT (mod_gantt)->selected)->item_list, 0))->x2;
	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_GANTT (mod_gantt)->selected)->item_list, 0), "x2", x2+(new_x-TD_MOD_GANTT (mod_gantt)->dragging_x), NULL);
	  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_parent); i++)
	    td_mod_gantt_draw_link (TD_MOD_GANTT (mod_gantt), g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_parent, i), NULL, item);
  	  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_child); i++)
	    td_mod_gantt_draw_link (TD_MOD_GANTT (mod_gantt), g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_child, i), item, NULL);
	  break;

	  /*** Dnd dplacement - Dnd move */
	case 4:
	  draw_dnd_line (mod_gantt, item_x, item_y);
	  break;

	  /*** Dnd copie - Dnd copy */
	case 5:
	  draw_dnd_line (mod_gantt, item_x, item_y);
	  break;

	  /*** Liaison - Link */
	case 6:
	  new_x = item_x;
	  new_y = item_y;
	  points = gnome_canvas_points_new (2);
	  points->coords[0] = GNOME_CANVAS_LINE (TD_MOD_GANTT (mod_gantt)->link)->coords[0];
	  points->coords[1] = GNOME_CANVAS_LINE (TD_MOD_GANTT (mod_gantt)->link)->coords[1];
	  points->coords[2] = new_x;
	  points->coords[3] = new_y;
	  gnome_canvas_item_set (TD_MOD_GANTT (mod_gantt)->link, "points", points, NULL);
	  gnome_canvas_points_free (points);
	  break;
	}
      TD_MOD_GANTT (mod_gantt)->dragging_x = new_x;
      TD_MOD_GANTT (mod_gantt)->dragging_y = new_y;
      break;

      /*** Application */
    case GDK_BUTTON_RELEASE:
      gnome_canvas_item_ungrab (item, bevent->time);
      switch (TD_MOD_GANTT (mod_gantt)->dragging) 
	{

	  /*** Dplacement - Move */
	case 1:

	  /*** Node */
       	  TD_FLAG_NO_REFRESH_NODE = TRUE;
	  delta_x = TD_MOD_GANTT (mod_gantt)->dragging_x - TD_MOD_GANTT (mod_gantt)->init_x;
	  duration = td_date_period_day (td_date_parse (td_database_current ("TD_CURRENT begin;"), "year-month-day"), td_date_parse (td_database_current ("TD_CURRENT eend;"), "year-month-day"));
	  if (delta_x>0)
	    delta_day = (delta_x/TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)+0.5;
	  else
	    delta_day = (delta_x/TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)-0.5;
	  begin = td_date_add_days (td_date_parse (td_database_current ("TD_CURRENT begin;"), "year-month-day"), delta_day);
	  end = td_date_add_days (begin, duration);
	  if (strcmp (td_date_print (begin, "year-month-day"), td_database_current ("TD_CURRENT begin;")))
	    td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
  	  x = td_date_period_day (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, td_date_parse (td_database_current ("TD_CURRENT begin;"), "year-month-day"))*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width;
  	  x2 = (td_date_period_day (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, begin)*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)-x-delta_x;
  	  td_database_command (g_strdup_printf ("UPDATE %s SET begin = %s, eend = %s WHERE td_id = %d;",
						TD_MOD_GANTT (mod_gantt)->table,
						td_database_adaptvalue (td_date_print (begin, "year-month-day"), "date"),
						td_database_adaptvalue (td_date_print (end, "year-month-day"), "date"),
						CURRENT_ID));
	  update_node (GTK_OBJECT (mod_gantt), NULL);
	  td_mod_refresh_bench (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id)), GTK_OBJECT (mod_gantt));
	  gnome_canvas_item_move (item, x2, 0);
	  TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
  	  TD_FLAG_NO_REFRESH_NODE = FALSE;
	  draw_links (mod_gantt, item, CURRENT_ID);

	  /*** Enfants - Childs */
	  list_childs = td_datatable_tree_childs ("begin, eend, td_id", CURRENT_ID, TD_MOD_GANTT (mod_gantt)->table, TD_MOD_GANTT (mod_gantt)->table_tree);
	  for (i=1; i<g_list_length (list_childs); i++)
	    {
	      begin = td_date_add_days (td_date_parse (g_list_nth_data (g_list_nth_data (list_childs, i), 0), "year-month-day"), delta_day);
	      end = td_date_add_days (td_date_parse (g_list_nth_data (g_list_nth_data (list_childs, i), 1), "year-month-day"), delta_day);
	      td_database_command (g_strdup_printf ("UPDATE %s SET begin = %s, eend = %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table,
						    td_database_adaptvalue (td_date_print (begin, "year-month-day"), "date"),
						    td_database_adaptvalue (td_date_print (end, "year-month-day"), "date"),
						    (gchar*) g_list_nth_data (g_list_nth_data (list_childs, i), 2)));
	    }
	  list_childs = gtdk_canvas_item_childs (item);
	  for (i=1; i<g_list_length (list_childs); i++)
	    if ((GNOME_IS_CANVAS_GROUP (g_list_nth_data (list_childs, i))) && 
		(!strstr ((gchar*) gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (list_childs, i))), "handle")))
	      update_node (mod_gantt, g_list_nth_data (list_childs, i));
	  break;

	  /*** Taille dbut - Size begin */
	case 2:
       	  TD_FLAG_NO_REFRESH_NODE = TRUE;
	  delta_x = TD_MOD_GANTT (mod_gantt)->dragging_x - TD_MOD_GANTT (mod_gantt)->init_x;
	  if (delta_x>0)
	    begin = td_date_add_days (td_date_parse (td_database_current ("TD_CURRENT begin;"), "year-month-day"), ((delta_x/TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)+0.5));
	  else
	    begin = td_date_add_days (td_date_parse (td_database_current ("TD_CURRENT begin;"), "year-month-day"), ((delta_x/TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)-0.5));
  	  duration = td_date_period_day (begin, td_date_parse (td_database_current ("TD_CURRENT eend;"), "year-month-day"));
	  if (strcmp (td_date_print (begin, "year-month-day"), td_database_current ("TD_CURRENT begin;")))
	    td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
  	  x = td_date_period_day (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, td_date_parse (td_database_current ("TD_CURRENT begin;"), "year-month-day"))*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width;
  	  x2 = (td_date_period_day (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, begin)*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)-x-delta_x;
	  x3 = GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0))->x2;
 	  td_database_command (g_strdup_printf ("UPDATE %s SET begin = %s, duration = %d WHERE td_id = %d;", 
						TD_MOD_GANTT (mod_gantt)->table, 
						td_database_adaptvalue (td_date_print (begin, "year-month-day"), "date"), 
						duration, 
						CURRENT_ID));
	  update_node (GTK_OBJECT (mod_gantt), NULL);
	  td_mod_refresh_bench (TD_MOD (g_list_nth_data (TD_APP(APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id)), GTK_OBJECT (mod_gantt));
	  gnome_canvas_item_move (item, x2, 0);
	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0), "x2", x3-x2, NULL);
	  TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
  	  TD_FLAG_NO_REFRESH_NODE = FALSE;
	  draw_links (mod_gantt, item, CURRENT_ID);
	  break;

	  /*** Taille fin - Size end */
	case 3:
       	  TD_FLAG_NO_REFRESH_NODE = TRUE;
	  delta_x = TD_MOD_GANTT (mod_gantt)->dragging_x - TD_MOD_GANTT (mod_gantt)->init_x;
	  if (delta_x>0)
	    end = td_date_add_days (td_date_parse (td_database_current ("TD_CURRENT eend;"), "year-month-day"), (delta_x/TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)+0.5);
	  else
	    end = td_date_add_days (td_date_parse (td_database_current ("TD_CURRENT eend;"), "year-month-day"), (delta_x/TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width)-0.5);
  	  duration = td_date_period_day (td_date_parse (td_database_current ("TD_CURRENT begin;"), "year-month-day"), end);
	  if (strcmp (td_date_print (end, "year-month-day"), td_database_current ("TD_CURRENT eend;")))
	    td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
  	  td_database_command (g_strdup_printf ("UPDATE %s SET eend = %s, duration = %d WHERE td_id = %d;", 
						TD_MOD_GANTT (mod_gantt)->table, 
						td_database_adaptvalue (td_date_print (end, "year-month-day"), "date"), 
						duration, 
						CURRENT_ID));
	  update_node (GTK_OBJECT (mod_gantt), NULL);
	  td_mod_refresh_bench (TD_MOD (g_list_nth_data (TD_APP(APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id)), GTK_OBJECT (mod_gantt));
	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0), "x2", duration*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width, NULL);
	  TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
  	  TD_FLAG_NO_REFRESH_NODE = FALSE;
	  draw_links (mod_gantt, item, CURRENT_ID);
	  break;

	  /*** Dnd dplacement - Dnd move */
	case 4:
	  node = gnome_canvas_get_item_at (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), item_x, item_y);
	  drag_id = g_strdup_printf ("%d", CURRENT_ID);
	  drag_id_sibling = td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id));

	  /*** Dans le nant - In the nil */
	  if (!node)
	    {
	      if (TD_MOD_GANTT (mod_gantt)->dragging_line1)
		{
		  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line1));
		  TD_MOD_GANTT (mod_gantt)->dragging_line1 = NULL;
		}
	      if (TD_MOD_GANTT (mod_gantt)->dragging_line2)
		{
		  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line2));
		  TD_MOD_GANTT (mod_gantt)->dragging_line2 = NULL;
		}
	      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %s WHERE td_id_sibling = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id_sibling, drag_id)); /*** Changement de l'ancien frre - Change of old sibling */
	      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %s WHERE (td_id_parent = 0) AND (td_id_sibling = 0);", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id)); /*** Changement du nouveau frre - Change of new sibling */
	      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_parent = 0, td_id_sibling = 0 WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id)); /*** Changement de la node prise - Change of node taken */
	      remove_node (mod_gantt, GNOME_CANVAS_GROUP (item));
	      add_node (mod_gantt, NULL, NULL, data_node (mod_gantt, atoi (drag_id)));
	      td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      draw_links (mod_gantt, item, CURRENT_ID);
	      break;
	    }

	  /*** Mme node - Same node */
	  if ((node->parent) && (!strcmp (drag_id, gtk_object_get_user_data (GTK_OBJECT (node->parent)))))
	    {
	      if (TD_MOD_GANTT (mod_gantt)->dragging_line1)
		{
		  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line1));
		  TD_MOD_GANTT (mod_gantt)->dragging_line1 = NULL;
		}
	      if (TD_MOD_GANTT (mod_gantt)->dragging_line2)
		{
		  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line2));
		  TD_MOD_GANTT (mod_gantt)->dragging_line2 = NULL;
		}
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      draw_links (mod_gantt, item, CURRENT_ID);
	      break;
	    }

	  /*** Dedans - Into */
	  if ((TD_MOD_GANTT (mod_gantt)->dragging_line1) && (TD_MOD_GANTT (mod_gantt)->dragging_line2))
	    {
	      gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line1));
	      TD_MOD_GANTT (mod_gantt)->dragging_line1 = NULL;
	      gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line2));
	      TD_MOD_GANTT (mod_gantt)->dragging_line2 = NULL;
	      drop_id = gtk_object_get_user_data (GTK_OBJECT (node->parent));
	      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %s WHERE td_id_sibling = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id_sibling, drag_id)); /*** Changement de l'ancien frre - Change of old sibling */
	      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %s WHERE (td_id_parent = %s) AND (td_id_sibling = 0);", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id, drop_id)); /*** Changement du nouveau frre - Change of new sibling */
	      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_parent = %s, td_id_sibling = 0 WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drop_id, drag_id)); /*** Changement de la node prise - Change of node taken */
	      remove_node (mod_gantt, GNOME_CANVAS_GROUP (item));
	      add_node (GTK_OBJECT (mod_gantt), GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (node)->parent), NULL, data_node (GTK_OBJECT (mod_gantt), atoi (drag_id)));
	      td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      draw_links (mod_gantt, item, CURRENT_ID);
	      draw_links (mod_gantt, item, CURRENT_ID);
	      break;
	    }

	  /*** Avant - Before */
	  if (TD_MOD_GANTT (mod_gantt)->dragging_line1)
	    {
	      gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line1));
	      TD_MOD_GANTT (mod_gantt)->dragging_line1 = NULL;
	      drop_id_sibling = gtk_object_get_user_data (GTK_OBJECT (node->parent));
	      drop_id_parent = td_database_value (g_strdup_printf ("SELECT td_id_parent FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drop_id_sibling));
	      drop_id = td_database_value (g_strdup_printf ("SELECT td_id FROM %s WHERE (td_id_parent = %s) AND (td_id_sibling = %s);", 
							    TD_MOD_GANTT (mod_gantt)->table_tree, drop_id_parent, drop_id_sibling));
	      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %s WHERE td_id_sibling = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id_sibling, drag_id)); /*** Changement de l'ancien frre - Change of old sibling */
	      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %s WHERE (td_id_parent = %s) AND (td_id = %s);", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id, drop_id_parent, drop_id)); /*** Changement du nouveau frre - Change of new sibling */
	      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_parent = %s, td_id_sibling = %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drop_id_parent, drop_id_sibling, drag_id)); /*** Changement de la node prise - Change of node taken */
	      remove_node (mod_gantt, GNOME_CANVAS_GROUP (item));
	      add_node (GTK_OBJECT (mod_gantt), GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (node->parent)->parent), GNOME_CANVAS_GROUP (node->parent), data_node (GTK_OBJECT (mod_gantt), atoi (drag_id)));
	      td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      draw_links (mod_gantt, item, CURRENT_ID);
	      break;
	    }

	  /*** Aprs - After */
	  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line2));
	  TD_MOD_GANTT (mod_gantt)->dragging_line2 = NULL;
	  drop_id = gtk_object_get_user_data (GTK_OBJECT (node->parent));
	  drop_id_parent = td_database_value (g_strdup_printf ("SELECT td_id_parent FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drop_id));
	  drop_id_sibling = td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drop_id));
	  if (strcmp (drop_id_sibling, "0"))
	    node2 = gnome_canvas_get_item_at (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), td_date_period_day (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, td_date_parse (td_database_value (g_strdup_printf ("SELECT begin FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table, drop_id_sibling)), "year-month-day"))*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width, item_y+GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (node->parent)->item_list, 0))->y2-((TD_MOD_GANTT (mod_gantt)->row_height)/2));
	  else
	    node2 = NULL;
	  td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %s WHERE td_id_sibling = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id_sibling, drag_id)); /*** Changement de l'ancien frre - Change of old sibling */
	  td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %s WHERE (td_id_parent = %s) AND (td_id = %s);", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id, drop_id_parent, drop_id)); /*** Changement du nouveau frre - Change of new sibling */
	  td_database_command (g_strdup_printf ("UPDATE %s SET td_id_parent = %s, td_id_sibling = %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drop_id_parent, drop_id_sibling, drag_id)); /*** Changement de la node prise - Change of node taken */
	  remove_node (mod_gantt, GNOME_CANVAS_GROUP (item));
	  if (!node2)
	    add_node (GTK_OBJECT (mod_gantt), GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (node->parent)->parent), NULL, data_node (GTK_OBJECT (mod_gantt), atoi (drag_id)));
	  else
	    add_node (GTK_OBJECT (mod_gantt), GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (node->parent)->parent), GNOME_CANVAS_GROUP (node2->parent), data_node (GTK_OBJECT (mod_gantt), atoi (drag_id)));
	  td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
	  TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	  draw_links (mod_gantt, item, CURRENT_ID);
	  break;

	  /*** Dnd copie - Dnd copy */
	case 5:
	  node = gnome_canvas_get_item_at (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), item_x, item_y);
	  drag_id = g_strdup_printf ("%d", CURRENT_ID);
	  drag_id_sibling = td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drag_id));

	  /*** Dans le nant - In the nil */
	  if (!node)
	    {
	      if (TD_MOD_GANTT (mod_gantt)->dragging_line1)
		{
		  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line1));
		  TD_MOD_GANTT (mod_gantt)->dragging_line1 = NULL;
		}
	      if (TD_MOD_GANTT (mod_gantt)->dragging_line2)
		{
		  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line2));
		  TD_MOD_GANTT (mod_gantt)->dragging_line2 = NULL;
		}
	      add_node (mod_gantt, NULL, NULL, data_node (mod_gantt, dnd_copy (mod_gantt, atoi (drag_id), 0, 0)));
	      td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      break;
	    }

	  /*** Mme node - Same node */
	  if ((node->parent) && (!strcmp (drag_id, gtk_object_get_user_data (GTK_OBJECT (node->parent)))))
	    {
	      if (TD_MOD_GANTT (mod_gantt)->dragging_line1)
		{
		  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line1));
		  TD_MOD_GANTT (mod_gantt)->dragging_line1 = NULL;
		}
	      if (TD_MOD_GANTT (mod_gantt)->dragging_line2)
		{
		  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line2));
		  TD_MOD_GANTT (mod_gantt)->dragging_line2 = NULL;
		}
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      break;
	    }

	  /*** Dedans - Into */
	  if ((TD_MOD_GANTT (mod_gantt)->dragging_line1) && (TD_MOD_GANTT (mod_gantt)->dragging_line2))
	    {
	      gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line1));
	      TD_MOD_GANTT (mod_gantt)->dragging_line1 = NULL;
	      gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line2));
	      TD_MOD_GANTT (mod_gantt)->dragging_line2 = NULL;
	      drop_id = gtk_object_get_user_data (GTK_OBJECT (node->parent));
	      add_node (mod_gantt, GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (node)->parent), NULL, data_node (mod_gantt, dnd_copy (mod_gantt, atoi (drag_id), atoi (drop_id), 0)));
	      td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      break;
	    }

	  /*** Avant - Before */
	  if (TD_MOD_GANTT (mod_gantt)->dragging_line1)
	    {
	      gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line1));
	      TD_MOD_GANTT (mod_gantt)->dragging_line1 = NULL;
	      drop_id_sibling = gtk_object_get_user_data (GTK_OBJECT (node->parent));
	      drop_id_parent = td_database_value (g_strdup_printf ("SELECT td_id_parent FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drop_id_sibling));
	      drop_id = td_database_value (g_strdup_printf ("SELECT td_id FROM %s WHERE (td_id_parent = %s) AND (td_id_sibling = %s);", TD_MOD_GANTT (mod_gantt)->table_tree, drop_id_parent, drop_id_sibling));
	      add_node (GTK_OBJECT (mod_gantt), GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (node->parent)->parent), GNOME_CANVAS_GROUP (node->parent), data_node (mod_gantt,dnd_copy (mod_gantt, atoi (drag_id), atoi (drop_id_parent), atoi (drop_id_sibling))));
	      td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      break;
	    }

	  /*** Aprs - After */
	  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line2));
	  TD_MOD_GANTT (mod_gantt)->dragging_line2 = NULL;
	  drop_id = gtk_object_get_user_data (GTK_OBJECT (node->parent));
	  drop_id_parent = td_database_value (g_strdup_printf ("SELECT td_id_parent FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drop_id));
	  drop_id_sibling = td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, drop_id));
	  if (strcmp (drop_id_sibling, "0"))
	    {
	      node2 = gnome_canvas_get_item_at (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), td_date_period_day (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, td_date_parse (td_database_value (g_strdup_printf ("SELECT begin FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table, drop_id_sibling)), "year-month-day"))*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width, item_y+GNOME_CANVAS_RE (g_list_nth_data (GNOME_CANVAS_GROUP (node->parent)->item_list, 0))->y2-((TD_MOD_GANTT (mod_gantt)->row_height)/2));
	      add_node (GTK_OBJECT (mod_gantt), GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (node->parent)->parent), GNOME_CANVAS_GROUP (node2->parent), data_node (mod_gantt, dnd_copy (mod_gantt, atoi (drag_id), atoi (drop_id_parent), atoi (drop_id_sibling))));
	    }
	  else
	    add_node (GTK_OBJECT (mod_gantt), GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (node->parent)->parent), NULL, data_node (mod_gantt, dnd_copy (mod_gantt, atoi (drag_id), atoi (drop_id_parent), atoi (drop_id_sibling))));
	  td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
	  TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	  break;

	  /*** Liaison - Link */
	case 6:

	  /*** Shunt */
	  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->link));
	  TD_MOD_GANTT (mod_gantt)->link = NULL;
	  node = item;
	  node2 = gnome_canvas_get_item_at (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data), item_x, item_y);
	  if ((!node2) || (GNOME_IS_CANVAS_LINE (node2)) || (GNOME_CANVAS_GROUP (node2->parent) == gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data))))
	    {
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      break;
	    }
	  node2 = node2->parent;
	  CURRENT_ID_PARENT = CURRENT_ID;
	  CURRENT_ID = atoi (gtk_object_get_user_data (GTK_OBJECT (node2)));
	  if (CURRENT_ID == CURRENT_ID_PARENT)
	    {
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      break;
	    }
	  if ((td_database_value (g_strdup_printf ("SELECT td_id FROM %s WHERE td_id = %d AND td_id_parent = %d;", TD_MOD_GANTT (mod_gantt)->table_net, CURRENT_ID, CURRENT_ID_PARENT))) ||
	      (td_database_value (g_strdup_printf ("SELECT td_id FROM %s WHERE td_id = %d AND td_id_parent = %d;", TD_MOD_GANTT (mod_gantt)->table_net, CURRENT_ID_PARENT, CURRENT_ID))))
	    {
	      TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	      break;
	    }

	  /*** Ligne - Line */
	  add_link (mod_gantt, node, node2, CURRENT_ID_PARENT, CURRENT_ID);
	  td_database_insert (g_strdup_printf ("INSERT INTO %s (td_id, td_id_parent) VALUES (%d, %d);", TD_MOD_GANTT (mod_gantt)->table_net, CURRENT_ID, CURRENT_ID_PARENT), "task_net");
	  td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_GANTT (mod_gantt)->id));
	  TD_MOD_GANTT (mod_gantt)->dragging = FALSE;
	  break;
	default:
	  break;
	}
      break;
    default:
      break;
    }
}

int dnd_copy (GtkObject *mod_gantt, int drag_id, int id_parent, int id_sibling)
{
  GList *list_tmp;
  GList *list_id_old = NULL;
  GList *list_id_new = NULL;
  gchar *txt_field;
  int cur_id;
  int i, j, k;
  gboolean bool_tmp;

  /*** Recherche des enfants - Searching childs */
  cur_id = 0;
  list_id_old = g_list_append (list_id_old, g_strdup_printf ("%d", drag_id));
  while (g_list_nth_data (list_id_old, cur_id))
    {
      list_tmp = td_database_column (g_strdup_printf ("SELECT td_id FROM %s WHERE td_id_parent = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, (gchar*) g_list_nth_data (list_id_old, cur_id)));
      for (i=0; i<g_list_length (list_tmp); i++)
	list_id_old = g_list_append (list_id_old, g_list_nth_data (list_tmp, i));
      cur_id++;
    }

  /*** Champs - Fields */
  list_tmp = td_database_field (g_strdup_printf ("SELECT * FROM %s;", TD_MOD_GANTT (mod_gantt)->table));
  txt_field = "";
  for (i=0; i<g_list_length (list_tmp)-g_list_length (TD_APP (APP)->admin_field); i++)
    {
      if (i != 0)
	txt_field = g_strdup_printf ("%s, ", txt_field);
      txt_field = g_strdup_printf ("%s%s", txt_field, (gchar*) g_list_nth_data (list_tmp, i));
    }

  /*** Node */
  for (i=0; i<g_list_length (list_id_old); i++)
    {
      td_database_insert (g_strdup_printf ("INSERT INTO %s SELECT %s FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table, txt_field, TD_MOD_GANTT (mod_gantt)->table, (gchar*) g_list_nth_data (list_id_old, i)), TD_MOD_GANTT (mod_gantt)->table); /*** Nouvelle node dans actions - New node in actions */
      list_id_new = g_list_append (list_id_new, g_strdup_printf ("%d", CURRENT_ID));
      if (i == 0)
	{
	  td_database_insert (g_strdup_printf ("INSERT INTO %s (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, %d);", TD_MOD_GANTT (mod_gantt)->table_tree, CURRENT_ID, id_parent, id_sibling), TD_MOD_GANTT (mod_gantt)->table_tree); /*** Nouvelle node dans actions_tree - New node in actions */
	  td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = %d) AND (td_id <> %d);", TD_MOD_GANTT (mod_gantt)->table_tree, CURRENT_ID, id_parent, id_sibling, CURRENT_ID)); /*** Changement du nouveau frre - Change of new child */
	}
      else
	{
	  id_parent = atoi (td_database_value (g_strdup_printf ("SELECT td_id_parent FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, (gchar*) g_list_nth_data (list_id_old, i))));
	  bool_tmp = FALSE;
	  for (j=0; j<g_list_length (list_id_old); j++)
	    if (id_parent == atoi (g_list_nth_data (list_id_old, j)))
	      {
		if (j >= g_list_length (list_id_new))
		  break;
		id_parent = atoi (g_list_nth_data (list_id_new, j));
		bool_tmp = TRUE;
		break;
	      }
	  if (!bool_tmp)
	    id_parent = 0;
	  id_sibling = atoi (td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM %s WHERE td_id = %s;", TD_MOD_GANTT (mod_gantt)->table_tree, (gchar*) g_list_nth_data (list_id_old, i))));
	  bool_tmp = FALSE;
	  for (k=0; k<g_list_length (list_id_old); k++)
	    if (id_sibling == atoi (g_list_nth_data (list_id_old, k)))
	      {
		if (k >= g_list_length (list_id_new))
		  break;
		id_sibling = atoi (g_list_nth_data (list_id_new, k));
		bool_tmp = TRUE;
		break;
	      }
	  if (!bool_tmp)
	    id_sibling = 0;
	  td_database_insert (g_strdup_printf ("INSERT INTO %s (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, %d);", TD_MOD_GANTT (mod_gantt)->table_tree, CURRENT_ID, id_parent, id_sibling), TD_MOD_GANTT (mod_gantt)->table_tree); /*** Nouvelle node dans actions_tree - New node in actions_tree */
	  td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = %d) AND (td_id <> %d);", TD_MOD_GANTT (mod_gantt)->table_tree, CURRENT_ID, id_parent, id_sibling, CURRENT_ID)); /*** Changement du nouveau frre - Change of new child */
	}
    }
  return atoi (g_list_nth_data (list_id_new, 0));
}

void draw_links (GtkObject *mod_gantt, GnomeCanvasItem *node, int id_node)
{
  int i;
  gchar *id_item;
  gchar *id_parent;
  gchar *id_child;
  GnomeCanvasGroup *root;
  GnomeCanvasItem *node2;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data));
  id_parent = g_strdup_printf (",%d", id_node);
  id_child = g_strdup_printf ("%d,", id_node);
  for (i=0; i<g_list_length (root->item_list); i++)
    {
      id_item = gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, i)));
      if ((!id_item) || (!strstr (id_item, ",")))
	continue;
      if (strstr (id_item, id_parent))
	td_mod_gantt_draw_link (TD_MOD_GANTT (mod_gantt), g_list_nth_data (root->item_list, i), NULL, node);
      else
	if (strstr (id_item, id_child))
	  td_mod_gantt_draw_link (TD_MOD_GANTT (mod_gantt), g_list_nth_data (root->item_list, i), node, NULL);
    }
}

void draw_dnd_line (GtkObject *mod_gantt, int item_x, int item_y)
{
  /* FIXME: Prendre en compte l'item sous le dnd : + tards */
  /* FIXME: Animer le dplacement comme MacOSX : + tards */
  GnomeCanvasGroup *root;
  GnomeCanvasPoints *points1 = NULL;
  GnomeCanvasPoints *points2 = NULL;
  int height = TD_MOD_GANTT (mod_gantt)->row_height;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_gantt)->widget_data));

  /*** Avant - Before */
  if (((int) item_y % height)<(height/3))
    {
      points1 = gnome_canvas_points_new (2);
      points1->coords[0] = 0;
      points1->coords[1] = (((item_y-((int) item_y % height))/height)*height)-1;
      points1->coords[2] = TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->widget->allocation.width;
      points1->coords[3] = points1->coords[1];
      if (!TD_MOD_GANTT (mod_gantt)->dragging_line1)
	TD_MOD_GANTT (mod_gantt)->dragging_line1 = gnome_canvas_item_new (root, gnome_canvas_line_get_type(), 
									  "points", points1, 
									  "fill_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_SELECTED],
									  "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_SELECTED], NULL);
      else
	gnome_canvas_item_move (TD_MOD_GANTT (mod_gantt)->dragging_line1, 0, ((((item_y-((int) item_y % height))/height)*height)-(((TD_MOD_GANTT (mod_gantt)->dragging_y-((int) TD_MOD_GANTT (mod_gantt)->dragging_y % height))/height)*height)));
      if (TD_MOD_GANTT (mod_gantt)->dragging_line2)
	{
	  gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line2));
	  TD_MOD_GANTT (mod_gantt)->dragging_line2 = NULL;
	}
      gnome_canvas_points_free (points1);
      return;
    }

  /*** Dedans - Into */
  if (((int) item_y % height)<(2*height/3))
    {
      points1 = gnome_canvas_points_new (2);
      points2 = gnome_canvas_points_new (2);
      points1->coords[0] = 0;
      points1->coords[1] = (((item_y-((int) item_y % height))/height)*height)-1;
      points1->coords[2] = TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->widget->allocation.width;
      points1->coords[3] = points1->coords[1];
      points2->coords[0] = points1->coords[0];
      points2->coords[1] = ((((item_y-((int) item_y % height))/height)+1)*height)-1;
      points2->coords[2] = points1->coords[2];
      points2->coords[3] = points2->coords[1];
      if (!TD_MOD_GANTT (mod_gantt)->dragging_line1)
	TD_MOD_GANTT (mod_gantt)->dragging_line1 = gnome_canvas_item_new (root, gnome_canvas_line_get_type(), 
									  "points", points1, 
									  "fill_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_SELECTED],
									  "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_SELECTED], NULL);
      else
	gnome_canvas_item_move (TD_MOD_GANTT (mod_gantt)->dragging_line1, 0, ((((item_y-((int) item_y % height))/height)*height)-(((TD_MOD_GANTT (mod_gantt)->dragging_y-((int) TD_MOD_GANTT (mod_gantt)->dragging_y % height))/height)*height)));
      if (!TD_MOD_GANTT (mod_gantt)->dragging_line2)
	TD_MOD_GANTT (mod_gantt)->dragging_line2 = gnome_canvas_item_new (root, gnome_canvas_line_get_type(), 
									  "points", points2, 
									  "fill_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_SELECTED],
									  "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_SELECTED], NULL);
     else
       gnome_canvas_item_move (TD_MOD_GANTT (mod_gantt)->dragging_line2, 0, (((((item_y-((int) item_y % height))/height)+1)*height)-((((TD_MOD_GANTT (mod_gantt)->dragging_y-((int) TD_MOD_GANTT (mod_gantt)->dragging_y % height))/height)+1)*height)));
      gnome_canvas_points_free (points1);
      gnome_canvas_points_free (points2);
      return;
    }

  /*** Aprs - After */
  points2 = gnome_canvas_points_new (2);
  points2->coords[0] = 0;
  points2->coords[1] = ((((item_y-((int) item_y % height))/height)+1)*height)-1;
  points2->coords[2] = TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->widget->allocation.width;
  points2->coords[3] = points2->coords[1];
  if (TD_MOD_GANTT (mod_gantt)->dragging_line1)
    {
      gtk_object_destroy (GTK_OBJECT (TD_MOD_GANTT (mod_gantt)->dragging_line1));
      TD_MOD_GANTT (mod_gantt)->dragging_line1 = NULL;
    }
  if (!TD_MOD_GANTT (mod_gantt)->dragging_line2)
    TD_MOD_GANTT (mod_gantt)->dragging_line2 = gnome_canvas_item_new (root, gnome_canvas_line_get_type(), 
								      "points", points2,
								      "fill_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_SELECTED],
								      "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_SELECTED], NULL);
  else
    gnome_canvas_item_move (TD_MOD_GANTT (mod_gantt)->dragging_line2, 0, (((((item_y-((int) item_y % height))/height)+1)*height)-((((TD_MOD_GANTT (mod_gantt)->dragging_y-((int) TD_MOD_GANTT (mod_gantt)->dragging_y % height))/height)+1)*height)));
  gnome_canvas_points_free (points2);
  return;
}

GList *data_node (GtkObject *mod_gantt, int node_id)
{
  GList *ret;
  gchar *query;
  int i;
  query = "SELECT td_id, begin, eend";
  if (g_list_length (TD_MOD_GANTT (mod_gantt)->label_field) != 0)
    query = g_strdup_printf ("%s, ", query);
  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->label_field); i++)
    {
      query = g_strdup_printf ("%s%s", query, (gchar*) g_list_nth_data (TD_MOD_GANTT (mod_gantt)->label_field, i));
      if (i != g_list_length (TD_MOD_GANTT (mod_gantt)->label_field)-1)
	query = g_strdup_printf ("%s, ", query);
    }
  query = g_strdup_printf ("%s FROM %s WHERE td_id = %d;", query, TD_MOD_GANTT (mod_gantt)->table, node_id);
  return td_database_row (query);
}

GtkObject *data_node_parent (GtkObject *mod_gantt, int node_id)
{
  gchar *query;
  int i;
  query = "SELECT td_id, begin, eend";
  if (g_list_length (TD_MOD_GANTT (mod_gantt)->label_field) != 0)
    query = g_strdup_printf ("%s, ", query);
  for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->label_field); i++)
    {
      query = g_strdup_printf ("%s%s", query, (gchar*) g_list_nth_data (TD_MOD_GANTT (mod_gantt)->label_field, i));
      if (i != g_list_length (TD_MOD_GANTT (mod_gantt)->label_field)-1)
	query = g_strdup_printf ("%s, ", query);
    }
  query = g_strdup_printf ("%s FROM %s WHERE td_id IN (SELECT td_id FROM %s WHERE td_id_parent = %d);", query, TD_MOD_GANTT (mod_gantt)->table, TD_MOD_GANTT (mod_gantt)->table_tree, node_id);
  return td_database_select (query);
}

/*****************************************************************************/
/*** Etablis - Bench */
/*****************************************************************************/
void plugins_bench_refresh (GtkObject *mod, GtkObject *mod_gantt)
{
  td_database_set_current (g_strdup_printf ("SELECT %s FROM %s WHERE td_id = %d;", TD_MOD (mod)->fields, TD_MOD_GANTT (g_list_nth_data (TD_MOD (mod)->child, 0))->table, CURRENT_ID));
}

void plugins_etabliste_refresh (GtkObject *mod, GtkObject *mod_gantt)
{
}

void plugins_bench_action (GtkObject *mod, gchar *value, gchar *table_field, int bench_id)
{
  TdModGantt *mod_gantt;
  double x;
  int duration;
  gchar *txt_tmp;
  int i;
  GDate *day_tmp;
  mod_gantt = TD_MOD_GANTT (g_list_nth_data (TD_MOD (mod)->child, 0));

  /*** Base de donnes - Database */
  TD_FLAG_NO_REFRESH_NODE = TRUE;
  if (!td_database_command (g_strdup_printf ("UPDATE %s SET %s = %s WHERE td_id = %d;", mod_gantt->table, table_field, td_database_adaptvalue (value, "text"), CURRENT_ID)))
    {
      TD_FLAG_NO_REFRESH_NODE = FALSE;
      return;
    }

  /*** Date */
  if (!strcmp (table_field, "begin"))
    {
      x = td_date_period_day (td_date_parse (td_database_current ("TD_CURRENT begin;"), "year-month-day"), td_date_parse (value, "year-month-day"))*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width;
      gnome_canvas_item_move (GNOME_CANVAS_ITEM (TD_MOD_GANTT (mod_gantt)->selected), x, 0);
      duration = td_date_period_day (td_date_parse (value, "year-month-day"), td_date_parse (td_database_current ("TD_CURRENT eend;"), "year-month-day"));
      td_database_command (g_strdup_printf ("UPDATE %s SET duration = %d WHERE td_id = %d;", mod_gantt->table, duration, CURRENT_ID));
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_GANTT (mod_gantt)->selected)->item_list, 0), "x2", duration*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width, NULL);
    }
  else
    if (!strcmp (table_field, "eend"))
      {
	duration = td_date_period_day (td_date_parse (td_database_current ("TD_CURRENT begin;"), "year-month-day"), td_date_parse (value, "year-month-day"));
	td_database_command (g_strdup_printf ("UPDATE %s SET duration = %d WHERE td_id = %d;", mod_gantt->table, duration, CURRENT_ID));
	gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_GANTT (mod_gantt)->selected)->item_list, 0), "x2", duration*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width, NULL);
      }
    else
      if (!strcmp (table_field, "duration"))
	{
	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_GANTT (mod_gantt)->selected)->item_list, 0), "x2", atoi (value)*TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width, NULL);
	  day_tmp = td_date_add_days (td_date_parse (td_database_current ("TD_CURRENT begin;"), "year-month-day"), atoi (value));
	  td_database_command (g_strdup_printf ("UPDATE %s SET eend = %s WHERE td_id = %d;", mod_gantt->table, td_database_adaptvalue (td_date_print (day_tmp, "year-month-day"), "date"), CURRENT_ID));
	}

  /*** Etiquette - Label */
  if (mod_gantt->label_form)
    {
      txt_tmp = mod_gantt->label_form;
      for (i=0; i<g_list_length (mod_gantt->label_field); i++)
	if (!strcmp (table_field, g_list_nth_data (mod_gantt->label_field, i)))
	  txt_tmp = td_string_replace (txt_tmp, g_strdup_printf ("$%s", (gchar*) g_list_nth_data (mod_gantt->label_field, i)), value);
	else
	  txt_tmp = td_string_replace (txt_tmp, g_strdup_printf ("$%s", (gchar*) g_list_nth_data (mod_gantt->label_field, i)), td_database_current (g_strdup_printf ("TD_CURRENT %s;", (gchar*) g_list_nth_data (mod_gantt->label_field, i))));
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_GANTT (mod_gantt)->selected)->item_list, 1), "text", txt_tmp, NULL);
    }
  td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
  TD_FLAG_NO_REFRESH_NODE = FALSE;
  return;
}

void plugins_etabliste_action (GtkObject *mod, gchar *value, gchar *table_field, int etabliste_id)
{
}

/*****************************************************************************/
/*** Menu */
/*****************************************************************************/
void menu_def (GtkObject *mod)
{
  GtkObject *menu[6];
  GtkObject *menu_link[1];

  /*** Crer - Create */
  menu[0] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[0]),
		  "label", _("Create"),
		  "icon", "list_new.xpm",
		  "query_visible", "TD_CURRENT (null);", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[0]);

  menu[1] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[1]), 
		  "label", _("Create"),
		  "icon", "list_new.xpm",
		  "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[1]);

  menu[2] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[2]), 
		  "label", _("Insert-Create"),
		  "icon", "list_empty.xpm",
		  "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[2]);
  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new());

  /*** Supprimer - Remove */
  menu[4] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[4]),
		  "label", _("Remove"),
		  "icon", "list_trash.xpm",
		  "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[4]);

  menu[5] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[5]), "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[5]);

  /*** Menu des liens : Supprimer - Links menu : remove */
  menu_link[0] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu_link[0]), 
		  "label", _("Remove"),
		  "icon", "list_trash.xpm", NULL);
  td_mod_add_menu_link (TD_MOD (mod), menu_link[0]);
  td_mod_add_menu_link (TD_MOD (mod), td_mod_menu_new());
}

void plugins_menu_refresh (GtkObject *mod, GtkObject *mod_gantt)
{
  td_database_set_current (g_strdup_printf ("SELECT %s FROM %s WHERE td_id = %d;", TD_MOD (mod)->fields, TD_MOD_GANTT (g_list_nth_data (TD_MOD (mod)->child, 0))->table, CURRENT_ID));
}

void plugins_menu_action (GtkObject *mod, int menu_id)
{
  TdModGantt *mod_gantt;
  int id_sibling;
  gchar *old_id_sibling;
  int id_parent, id_tmp;
  GDate *day_tmp;
  gchar *txt_tmp;
  mod_gantt = TD_MOD_GANTT (g_list_nth_data (TD_MOD (mod)->child, 0));

  /*** Action */
  switch (menu_id)
    {

      /*** Crer - Create */
    case 0:
      day_tmp = td_date_add_days (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, TD_MOD_GANTT (mod_gantt)->init_x/TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width);
      td_database_insert (g_strdup_printf ("INSERT INTO %s (begin, eend, duration) VALUES (%s, %s, 1);", mod_gantt->table, td_database_adaptvalue (td_date_print (day_tmp, "year-month-day"), "date"), td_database_adaptvalue (td_date_print (td_date_add_days (day_tmp, 1), "year-month-day"), "date")), mod_gantt->table);
      id_tmp = CURRENT_ID;
      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %d WHERE (td_id_parent = 0) AND (td_id_sibling = 0);", mod_gantt->table_tree, CURRENT_ID));
      td_database_insert (g_strdup_printf ("INSERT INTO %s (td_id, td_id_parent, td_id_sibling) VALUES (%d, 0, 0);", mod_gantt->table_tree, CURRENT_ID), "task_tree");
      add_node (GTK_OBJECT (mod_gantt), NULL, NULL, data_node (GTK_OBJECT (mod_gantt), id_tmp));
      break;

      /*** Crer dans - Create into */
    case 1:
      CURRENT_ID_PARENT = CURRENT_ID;
      day_tmp = td_date_add_days (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, TD_MOD_GANTT (mod_gantt)->init_x/TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width);
      td_database_insert (g_strdup_printf ("INSERT INTO %s (begin, eend, duration) VALUES (%s, %s, 1);", mod_gantt->table, td_database_adaptvalue (td_date_print (day_tmp, "year-month-day"), "date"), td_database_adaptvalue (td_date_print (td_date_add_days (day_tmp, 1), "year-month-day"), "date")), mod_gantt->table);
      id_tmp = CURRENT_ID;
      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", mod_gantt->table_tree, CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO %s (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", mod_gantt->table_tree, CURRENT_ID, CURRENT_ID_PARENT), mod_gantt->table_tree);
      add_node (GTK_OBJECT (mod_gantt), GNOME_CANVAS_GROUP (mod_gantt->selected), NULL, data_node (GTK_OBJECT (mod_gantt), id_tmp));
      break;

      /*** Crer-insrer - Create-insert */
    case 2:
      id_sibling = CURRENT_ID;
      old_id_sibling = td_database_value (g_strdup_printf ("SELECT td_id FROM %s WHERE td_id_sibling = %d;", mod_gantt->table_tree, CURRENT_ID));
      id_parent = atoi (td_database_value (g_strdup_printf ("SELECT td_id_parent FROM %s WHERE td_id = %d;", mod_gantt->table_tree, CURRENT_ID)));
      day_tmp = td_date_add_days (TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->lower, TD_MOD_GANTT (mod_gantt)->init_x/TD_TIMERULER (TD_MOD_GANTT (mod_gantt)->timeruler)->width);
      td_database_insert (g_strdup_printf ("INSERT INTO %s (begin, eend) VALUES (%s, %s);", mod_gantt->table, td_database_adaptvalue (td_date_print (day_tmp, "year-month-day"), "date"), td_database_adaptvalue (td_date_print (td_date_add_days (day_tmp, 1), "year-month-day"), "date")), mod_gantt->table);
      id_tmp = CURRENT_ID;
      if (old_id_sibling)
	td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %d WHERE td_id = %s;", mod_gantt->table_tree, CURRENT_ID, old_id_sibling));
      td_database_insert (g_strdup_printf ("INSERT INTO %s (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, %d);", mod_gantt->table_tree, CURRENT_ID, id_parent, id_sibling), mod_gantt->table_tree);
      add_node (GTK_OBJECT (mod_gantt), GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (mod_gantt->selected)->parent), GNOME_CANVAS_GROUP (mod_gantt->selected), data_node (GTK_OBJECT (mod_gantt), id_tmp));
      break;

      /*** Supprimmer - Remove */
    case 4:
      id_sibling = atoi (td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM %s WHERE td_id = %d;", mod_gantt->table_tree, CURRENT_ID)));
      old_id_sibling = td_database_value (g_strdup_printf ("SELECT td_id FROM %s WHERE td_id_sibling = %d;", mod_gantt->table_tree, CURRENT_ID));
      id_parent = atoi (td_database_value (g_strdup_printf ("SELECT td_id_parent FROM %s WHERE td_id = %d;", mod_gantt->table_tree, CURRENT_ID)));
      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = %d);", mod_gantt->table_tree, id_sibling, id_parent, CURRENT_ID));

      /*** Suppresion - Remove */
      td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id = %d;", mod_gantt->table_tree, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id_parent = %d;", mod_gantt->table_tree, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id IN (SELECT td_id FROM task_tree WHERE td_id_parent = %d);", mod_gantt->table, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id = %d;", mod_gantt->table, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id = %d;", mod_gantt->table_net, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id_parent = %d;", mod_gantt->table_net, CURRENT_ID));
      remove_node (GTK_OBJECT (mod_gantt), GNOME_CANVAS_GROUP (mod_gantt->selected));
      remove_link (GTK_OBJECT (mod_gantt));
      break;
    default:
      break;
    }
}

void plugins_menu_link_action (GtkObject *mod, int menu_id)
{
  TdModGantt *mod_gantt;
/*    int i; */
  mod_gantt = TD_MOD_GANTT (g_list_nth_data (TD_MOD (mod)->child, 0));
  td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id = %d AND td_id_parent = %d;", mod_gantt->table_net, CURRENT_ID, CURRENT_ID_PARENT));
  remove_link (GTK_OBJECT (TD_MOD_GANTT (g_list_nth_data (TD_MOD (mod)->child, 0))));
/*    td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id = %d AND td_id_parent = %d;", mod_gantt->table_net, CURRENT_ID, CURRENT_ID_PARENT)); */
/*    for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_parent); i++) */
/*      gtk_object_destroy (GTK_OBJECT (g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_parent, i))); */
/*    mod_gantt->selected_link_parent = NULL; */
/*    for (i=0; i<g_list_length (TD_MOD_GANTT (mod_gantt)->selected_link_child); i++) */
/*      gtk_object_destroy (GTK_OBJECT (g_list_nth_data (TD_MOD_GANTT (mod_gantt)->selected_link_child, i))); */
/*    mod_gantt->selected_link_child = NULL; */
/*    CURRENT_ID = 0; */
/*    CURRENT_ID_PARENT = 0; */
}
