/*****************************************************************************/
/* main.h : Interface et appels d'un arbre
 * main.h : Tree's interface and callbacks
 *
 *
 * Greffon ToutDoux : Cogitation : Construction de base de donnes et de gabarit
 * ToutDoux's plug-in : Cogitation : Data base builder and template builder
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#include <toutdoux.h>

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
GtkObject *mod_main;

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void);
GtkObject *plugins_init (int mod_id);

/*****************************************************************************/
/*** Enfant - Child */
/*****************************************************************************/
void child_def (GtkObject *mod);
void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer *user_data);
void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer *user_data);

/*****************************************************************************/
/*** Etablis - Benchs */
/*****************************************************************************/
void bench_def (GtkObject *mod);
void plugins_bench_refresh (GtkObject *mod, GtkObject *mod_tree);
void plugins_etabliste_refresh (GtkObject *mod, GtkObject *mod_tree);
void plugins_bench_action (GtkObject *mod, gchar *value, gchar *table_field, int bench_id);
void plugins_etabliste_action (GtkObject *mod, gchar *value, gchar *table_field, int etabliste_id);

/*****************************************************************************/
/*** Menu */
/*****************************************************************************/
void menu_def (GtkObject *mod);
void menu_predefined_tables (GtkWidget *menuitem, GtkObject *mod);
void menu_predefined_module (GtkWidget *menuitem, GtkObject *mod);
void plugins_menu_refresh (GtkObject *mod, GtkObject *mod_tree);
void plugins_menu_action (GtkObject *mod, int menu_id);

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
gboolean load (TdDbBase *base);
GtkObject *plugins_save (void);
