/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Cogitation : Construction de base de donnes et de gabarit
 * ToutDoux's plug-in : Cogitation : Data base builder and template builder
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/stat.h>

#include "main.h"

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
GtkObject *mod_main;

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "Cogitation",
		  "type", _("build"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "help", "Database editor, module editor",
		  "category1", _("build"),
		  "category2", "cogitation",
		  "category3", "(null)",
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

GtkObject *plugins_init (int mod_id)
{
  GtkObject *structure;
  GtkObject *modules_list;
  GtkObject *modules_tables;
  int i;
  gchar *txt_tmp;
  gboolean already_loaded;

  /*** Module */
  mod_main = td_mod_new();
  gtk_object_set (GTK_OBJECT (mod_main),
		  "name", "cogitation",
		  "name_intl", "Cogitation",
		  "group", _("Build"),
		  "id", mod_id,
		  "fields", "*", NULL);
  td_mod_set_about (TD_MOD (mod_main), plugins_about_def());

  /*** Base locale pour cogitation - Local base for cogitation */
  already_loaded = FALSE;
  structure = td_db_base_load (g_strdup_printf ("%s/share/%s/cogitation/tables.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR));
  if (!td_database_base_construct (structure))
    {
      if (TD_DB_CONNECT (TD_APP (APP)->connect)->type != TD_CONNECT_TYPE_RECOVERY)
	td_app_message (_("Loading file"), _("Loading file : Local database for cogitation not created"), TD_MSG_STOP);
      else	
	already_loaded = TRUE;
    }
  if (!already_loaded)
    for (i=0; i < g_list_length (TD_DB_BASE (structure)->datatable); i++)
      if (!td_database_table_copy_in (g_list_nth_data (TD_DB_BASE (structure)->datatable, i)))
	if (TD_DB_CONNECT (TD_APP (APP)->connect)->type != TD_CONNECT_TYPE_RECOVERY)
	  td_app_message (_("Loading file"), _("Loading file : Local database's datatables for cogitation not complete"), TD_MSG_STOP);

  /*** Tables des modules - Modules table */
  if (!already_loaded)
    {
      modules_list = td_flower_new();
      gtk_object_set (GTK_OBJECT (modules_list), "root", "dataplugins", "branch", "dataplugin", NULL);
      td_flower_add_branch_attribut (TD_FLOWER (modules_list), "name");
      td_flower_add_branch_attribut (TD_FLOWER (modules_list), "directory");
      td_flower_add_branch_attribut (TD_FLOWER (modules_list), "file");
      td_flower_load_file (TD_FLOWER (modules_list), g_strdup_printf ("%s/share/%s/data-plugins.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR));
      for (i=0; i < g_list_length (TD_FLOWER (modules_list)->items_value); i++)
	{
	  txt_tmp = g_strdup_printf ("%s/share/%s/%s/tables.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (modules_list)->items_value, i), 1));
	  if (td_file_exist (txt_tmp))
	    {
	      modules_tables = td_db_base_load (txt_tmp);
	      if (!td_database_table_copy_in (g_list_nth_data (TD_DB_BASE (modules_tables)->datatable, 0)))
		td_app_message (_("Loading file"), _("Loading file : Local database's datatable not complete"), TD_MSG_STOP);
	    }
	}
      td_flower_destroy (TD_FLOWER (modules_list));
    }

  /*** Dfinitions - Definition */
  child_def (mod_main);
  bench_def (mod_main);
  menu_def (mod_main);

  /*** Cration - Create */
  td_mod_create (TD_MOD (mod_main));
  if ((TD_APP (APP)->base) && (!already_loaded))
    load (TD_DB_BASE (TD_APP (APP)->base));
  return mod_main;
}

/*****************************************************************************/
/*** Enfant - Child */
/*****************************************************************************/

void child_def (GtkObject *mod)
{
  GtkWidget *toolbar;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *button1;
  GtkObject *child[2];
  GtkObject *icon0[5];
  GtkObject *icon1[8];

  /*** Barre d'outils - Tools barr */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  td_mod_set_window_toolbar (TD_MOD (mod), toolbar);
  radiobutton1 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), NULL, _("Database"), "button_database.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), NULL);
  radiobutton2 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton1, _("Module"), "button_module.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button1 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Close"), "button_close.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (td_mod_hide), GTK_OBJECT (mod_main));

  /*** Tables */
  child[0] = td_mod_tree_new();
  gtk_object_set (GTK_OBJECT (child[0]), 
		  "name", "database",
		  "name_intl", _("Database"),
		  "reorderable", TRUE,
		  "customize", TRUE,
		  "table", "td_tables",
		  "table_tree", "td_tables_tree", NULL);
  td_mod_add_child (TD_MOD (mod), child[0]);

  icon0[0] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon0[0]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_DATABASE,
		  "pixmap2", (gchar*) TD_STOCK_LIST_DATABASE,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'table');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[0]), icon0[0]);

  icon0[1] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon0[1]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_NEW,
		  "pixmap2", (gchar*) TD_STOCK_LIST_NEW,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'field');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[0]), icon0[1]);

  icon0[2] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon0[2]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_RULE,
		  "pixmap2", (gchar*) TD_STOCK_LIST_RULE,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'rule');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[0]), icon0[2]);

  icon0[3] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon0[3]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_FUNCTION,
		  "pixmap2", (gchar*) TD_STOCK_LIST_FUNCTION,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'function');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[0]), icon0[3]);

  icon0[4] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon0[4]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_PROPERTY,
		  "pixmap2", (gchar*) TD_STOCK_LIST_PROPERTY,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'property');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[0]), icon0[4]);

  /*** Modules */
  child[1] = td_mod_tree_new();
  gtk_object_set (GTK_OBJECT (child[1]), 
		  "name", "modules",
		  "name_intl", _("Modules"),
		  "reorderable", TRUE,
		  "customize", TRUE,
		  "table", "td_modules",
		  "table_tree", "td_modules_tree", NULL);
  td_mod_add_child (TD_MOD (mod), child[1]);

  icon1[0] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[0]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_PLUGINS,
		  "pixmap2", (gchar*) TD_STOCK_LIST_PLUGINS,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'module');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[0]);

  icon1[1] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[1]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_DATABASE,
		  "pixmap2", (gchar*) TD_STOCK_LIST_DATABASE,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'table');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[1]);

  icon1[2] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[2]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_NEW,
		  "pixmap2", (gchar*) TD_STOCK_LIST_NEW,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'field');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[2]);

  icon1[3] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[3]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_PROPERTY,
		  "pixmap2", (gchar*) TD_STOCK_LIST_PROPERTY,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'property');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[3]);

  icon1[4] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[4]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_BENCH,
		  "pixmap2", (gchar*) TD_STOCK_LIST_BENCH,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'interface');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[4]);

  icon1[5] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[5]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_BENCH,
		  "pixmap2", (gchar*) TD_STOCK_LIST_BENCH,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'bench');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[5]);

  icon1[6] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[6]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_BENCH,
		  "pixmap2", (gchar*) TD_STOCK_LIST_BENCH,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'etabliste');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[6]);

  icon1[7] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[7]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_PALETTE,
		  "pixmap2", (gchar*) TD_STOCK_LIST_PALETTE,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'palette');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[7]);

  icon1[8] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[8]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_COMMAND,
		  "pixmap2", (gchar*) TD_STOCK_LIST_COMMAND,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'menu');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[8]);
}

void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod_main)->window_notebook), 0);
}

void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod_main)->window_notebook), 1);
}

/*****************************************************************************/
/*** Etablis - Benchs */
/*****************************************************************************/
void bench_def (GtkObject *mod)
{
  GtkObject *bench0[4];
  GtkObject *bench1[2];

  /*** Tables */
  bench0[0] = td_mod_bench_new(); /* 0 */
  gtk_object_set (GTK_OBJECT (bench0[0]), "name", _("Name"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[0]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[0]);

  bench0[1] = td_mod_bench_new(); /* 1 */
  gtk_object_set (GTK_OBJECT (bench0[1]), 
		  "name", _("Name"),
		  "list_query", "(null)",
		  "list_type", "bench list query", NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[1]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[1]);

  bench0[2] = td_mod_bench_new(); /* 2 */
  gtk_object_set (GTK_OBJECT (bench0[2]),
		  "name", _("Value"),
		  "list_query", "(null)",
		  "list_type", "bench list query", NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[2]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[2]);

  bench0[3] = td_mod_bench_new(); /* 3 */
  gtk_object_set (GTK_OBJECT (bench0[3]), "name", _("Comment"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[3]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[3]);

  /*** Modules */
  bench1[0] = td_mod_bench_new(); /* 4 */
  gtk_object_set (GTK_OBJECT (bench1[0]), 
		  "name", _("Name"),
		  "list_query", "(null)",
		  "list_type", "bench list query", NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench1[0]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench1[0]);

  bench1[1] = td_mod_bench_new(); /* 5 */
  gtk_object_set (GTK_OBJECT (bench1[1]), 
		  "name", _("Value"),
		  "list_query", "(null)",
		  "list_type", "bench list query", NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench1[1]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench1[1]);
}

void plugins_bench_refresh (GtkObject *mod, GtkObject *mod_tree)
{
  int i;
  GtkCTreeNode *node;
  GtkCTreeNode *node_module;
  GtkCTreeNode *node_table;
  gchar *txt_tmp;
  gchar *txt_tmp2;

  /*** Recherche du module enfant - Searching child module */
  for (i=0; i<g_list_length (TD_MOD (mod_main)->child); i++)
    if (mod_tree == g_list_nth_data (TD_MOD (mod_main)->child, i))
      break;

  /*** Go ! */
  switch (i)
    {

      /*** Tables */
    case 0:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_tables WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));

      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 0)),
		      "query_refresh", g_strdup_printf ("SELECT name FROM td_tables WHERE (td_id = %d) AND ((type = 'table') OR (type = 'field'));", CURRENT_ID),
		      "query_visible", g_strdup_printf ("SELECT td_id FROM td_tables WHERE (td_id = %d) AND ((type = 'table') OR (type = 'field'));", CURRENT_ID), NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 1)),
  		      "query_refresh", "TD_CURRENT name;",
		      "query_visible", g_strdup_printf ("SELECT td_id FROM td_tables WHERE (td_id = %d) AND ((type = 'rule') OR (type = 'function') OR (type = 'property'));", CURRENT_ID), NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 2)),
  		      "query_refresh", "TD_CURRENT value;",
		      "query_visible", g_strdup_printf ("SELECT td_id FROM td_tables WHERE (td_id = %d) AND ((type = 'property'));", CURRENT_ID), NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 3)),
		      "query_refresh", g_strdup_printf ("SELECT comment FROM td_tables WHERE (td_id = %d) AND ((type = 'table') OR (type = 'rule') OR (type = 'function') OR (type = 'field'));", CURRENT_ID),
		      "query_visible", g_strdup_printf ("SELECT td_id FROM td_tables WHERE (td_id = %d) AND ((type = 'table') OR (type = 'rule') OR (type = 'function') OR (type = 'field'));", CURRENT_ID), NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 4)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 5)), "query_visible", "(null)", NULL);

      if (td_database_value ("TD_CURRENT type;"))
	{
	  if ((!strcmp (td_database_value ("TD_CURRENT type;"), "table")) || (!strcmp (td_database_value ("TD_CURRENT type;"), "field")))
	    {
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 1)), "list_query", g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=0) AND (type = '%s') AND (name = '(null)')", td_database_value ("TD_CURRENT type;")), NULL);
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 2)), "list_query", g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=0) AND (type = '%s') AND (name = '(null)')", td_database_value ("TD_CURRENT type;")), NULL);
	      break;
	    }

	  if (!strcmp (td_database_value ("TD_CURRENT type;"), "rule"))
	    {
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 1)), "list_query", "(null)", NULL);
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 2)), "list_query", "(null)", NULL);
	      break;
	    }

	  if (!strcmp (td_database_value ("TD_CURRENT type;"), "function"))
	    {
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 1)), "list_query", "(null)", NULL);
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 2)), "list_query", "(null)", NULL);
	      break;
	    }

	  if (!strcmp (td_database_value ("TD_CURRENT type;"), "property"))
	    {
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 1)), "list_query", g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=0) AND (type = 'property') AND (name = '(null)') AND (ttable IN (SELECT type FROM td_tables WHERE td_id IN (SELECT td_id_parent FROM td_tables_tree WHERE td_id = %d)));", CURRENT_ID), NULL);
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 2)), "list_query", g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=0) AND (type = 'property') AND (name = '%s') AND (ttable IN (SELECT type FROM td_tables WHERE td_id IN (SELECT td_id_parent FROM td_tables_tree WHERE td_id = %d)));", td_database_value ("TD_CURRENT name;"), CURRENT_ID), NULL);
	      break;
	    }
	}
      break;

      /*** Modules */
    case 1:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD(mod)->bench, 0)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 1)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 2)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 3)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 4)), 
		      "query_refresh", "TD_CURRENT name;",
		      "query_visible", g_strdup_printf ("SELECT td_id FROM td_modules WHERE (td_id = %d) AND ((type = 'module') OR (type = 'table') OR (type = 'field') OR (type = 'bench') OR (type = 'property'));", CURRENT_ID), NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 5)),
  		      "query_refresh", "TD_CURRENT value;",
		      "query_visible", g_strdup_printf ("SELECT td_id FROM td_modules WHERE (td_id = %d) AND ((type = 'table') OR (type = 'field') OR (type = 'property'));", CURRENT_ID), NULL);

      if (td_database_value ("TD_CURRENT type;"))
	{
	  if (!strcmp (td_database_value ("TD_CURRENT type;"), "module"))
	    {
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 4)), "list_query", "SELECT value FROM td_cogitation_predef WHERE (ggroup=1) AND (type = 'module') ORDER BY value", NULL);
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 5)), "list_query", "(null)", NULL);
	      break;
	    }
	  if (!strcmp (td_database_value ("TD_CURRENT type;"), "table"))
	    {
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 4)), "list_query", g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=1) AND (type = 'table') AND (module IN (SELECT name FROM td_modules WHERE td_id IN (SELECT td_id_parent FROM td_modules_tree WHERE td_id = %d))) ORDER BY value;", CURRENT_ID), NULL);
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 5)), "list_query", "SELECT name FROM td_tables WHERE (type = 'table') ORDER BY name;", NULL);
	      break;
	    }
	  if (!strcmp (td_database_value ("TD_CURRENT type;"), "field"))
	    {
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 4)), "list_query", g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=1) AND (type = 'field') AND (module IN (SELECT name FROM td_modules WHERE td_id IN (SELECT td_id_parent FROM td_modules_tree WHERE td_id IN (SELECT td_id_parent FROM td_modules_tree WHERE td_id = %d)))) AND (ttable IN (SELECT name FROM td_modules WHERE td_id IN (SELECT td_id_parent FROM td_modules_tree WHERE td_id = %d))) ORDER BY value;", CURRENT_ID, CURRENT_ID), NULL);
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 5)), "list_query", g_strdup_printf ("SELECT name FROM td_tables WHERE td_id IN (SELECT td_id FROM td_tables_tree WHERE td_id_parent IN (SELECT td_id FROM td_tables WHERE name IN (SELECT value FROM td_modules WHERE td_id IN (SELECT td_id_parent FROM td_modules_tree WHERE td_id = %d)))) ORDER BY name;", CURRENT_ID), NULL);
	      break;
	    }
	  if (!strcmp (td_database_value ("TD_CURRENT type;"), "property"))
	    {
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 4)), "list_query", g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=1) AND (type = 'property') AND (name = '(null)') AND (ttable IN (SELECT type FROM td_modules WHERE td_id IN (SELECT td_id_parent FROM td_modules_tree WHERE td_id IN (SELECT td_id_parent FROM td_modules_tree WHERE td_id = %d))));", CURRENT_ID), NULL);
	      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 5)), "list_query", g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=1) AND (type = 'property') AND (name = '%s');", td_database_value ("TD_CURRENT name;")), NULL);
	      break;
	    }
	}
      break;
    default:
      break;
    }
}

void plugins_etabliste_refresh (GtkObject *mod, GtkObject *mod_tree)
{
}

void plugins_bench_action (GtkObject *mod, gchar *value, gchar *table_field, int bench_id)
{
  TD_FLAG_NO_REFRESH_NODE = TRUE;
  switch (bench_id)
    {

      /*** Tables */
    case 0:
      td_database_command (g_strdup_printf ("UPDATE td_tables SET name = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 1:
      td_database_command (g_strdup_printf ("UPDATE td_tables SET name = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 2:
      td_database_command (g_strdup_printf ("UPDATE td_tables SET value = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 3:
      td_database_command (g_strdup_printf ("UPDATE td_tables SET comment = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;

      /*** Modules */
    case 4:
      td_database_command (g_strdup_printf ("UPDATE td_modules SET name = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 1)));
      break;
    case 5:
      td_database_command (g_strdup_printf ("UPDATE td_modules SET value = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 1)));
      break;
    default:
      break;
    }
  TD_FLAG_NO_REFRESH_NODE = FALSE;
}

void plugins_etabliste_action (GtkObject *mod, gchar *value, gchar *table_field, int etabliste_id)
{
}

/*****************************************************************************/
/*** Menu */
/*****************************************************************************/

void menu_def (GtkObject *mod)
{
  int i;
  GtkWidget *menu;
  GtkWidget *menuitem;
  GtkObject *menu0[6];
  GtkObject *menu1[13];
  GList *column;
  column = td_database_column ("SELECT value FROM td_cogitation_predef WHERE (ggroup=1) AND (type = 'module') ORDER BY value");

  /*** Tables */
  menu0[0] = td_mod_menu_new(); /* 0 */
  gtk_object_set (GTK_OBJECT (menu0[0]), 
		  "label", _("Create table"), 
		  "icon", "list_table.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[0]);

  menu0[1] = td_mod_menu_new(); /* 1 */
  gtk_object_set (GTK_OBJECT (menu0[1]), 
		  "label", _("Create predefined tables"), 
		  "icon", "list_package.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[1]);
  menu = gtk_menu_new();
  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (TD_MOD_MENU (menu0[1])->widget), menu);
  for (i=0; i<g_list_length (column); i++)
    {
      menuitem = gtk_menu_item_new_with_label ((gchar*) g_list_nth_data (column, i));
      gtk_widget_show (GTK_WIDGET (menuitem));
      gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (menu_predefined_tables), mod);
      gtk_menu_append (GTK_MENU (menu), menuitem);
    }

  menu0[2] = td_mod_menu_new(); /* 2 */
  gtk_object_set (GTK_OBJECT (menu0[2]), 
		  "label", _("Create field"), 
		  "icon", "list_new.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[2]);

  menu0[3] = td_mod_menu_new(); /* 3 */
  gtk_object_set (GTK_OBJECT (menu0[3]), 
		  "label", _("Create rule"), 
		  "icon", "list_rule.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[3]);

  menu0[4] = td_mod_menu_new(); /* 4 */
  gtk_object_set (GTK_OBJECT (menu0[4]), 
		  "label", _("Create function"), 
		  "icon", "list_function.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[4]);

  menu0[5] = td_mod_menu_new(); /* 5 */
  gtk_object_set (GTK_OBJECT (menu0[5]), 
		  "label", _("Create property"), 
		  "icon", "list_property.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[5]);

  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new()); /* 6 */

  menu0[5] = td_mod_menu_new(); /* 7 */
  gtk_object_set (GTK_OBJECT (menu0[5]), 
		  "label", _("Remove"), "icon", "list_trash.xpm", 
		  "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[5]);

  /*** Modules */
  menu1[0] = td_mod_menu_new(); /* 8 */
  gtk_object_set (GTK_OBJECT (menu1[0]), 
		  "label", _("Create module"), 
		  "icon", "list_module.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[0]);

  menu1[1] = td_mod_menu_new(); /* 9 */
  gtk_object_set (GTK_OBJECT (menu1[1]), 
		  "label", _("Create predefined module"), 
		  "icon", "list_package.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[1]);
  menu = gtk_menu_new();
  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (TD_MOD_MENU (menu1[1])->widget), menu);
  for (i=0; i<g_list_length (column); i++)
    {
      menuitem = gtk_menu_item_new_with_label ((gchar*) g_list_nth_data (column, i));
      gtk_widget_show (GTK_WIDGET (menuitem));
      gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (menu_predefined_module), mod);
      gtk_menu_append (GTK_MENU (menu), menuitem);
    }

  menu1[2] = td_mod_menu_new(); /* 10 */
  gtk_object_set (GTK_OBJECT (menu1[2]), 
		  "label", _("Create table"), 
		  "icon", "list_table.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[2]);

  menu1[3] = td_mod_menu_new(); /* 11 */
  gtk_object_set (GTK_OBJECT (menu1[3]), 
		  "label", _("Create interface"), 
		  "icon", "list_bench.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[3]);

  menu1[4] = td_mod_menu_new(); /* 12 */
  gtk_object_set (GTK_OBJECT (menu1[4]), 
		  "label", _("Create bench"), 
		  "icon", "list_bench.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[4]);

  menu1[5] = td_mod_menu_new(); /* 13 */
  gtk_object_set (GTK_OBJECT (menu1[5]), 
		  "label", _("Create etabliste"), 
		  "icon", "list_bench.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[5]);

  menu1[6] = td_mod_menu_new(); /* 14 */
  gtk_object_set (GTK_OBJECT (menu1[6]), 
		  "label", _("Create palette"), 
		  "icon", "list_palette.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[6]);

  menu1[7] = td_mod_menu_new(); /* 15 */
  gtk_object_set (GTK_OBJECT (menu1[7]), 
		  "label", _("Create menu"), 
		  "icon", "list_menu.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[7]);

  menu1[8] = td_mod_menu_new(); /* 16 */
  gtk_object_set (GTK_OBJECT (menu1[8]), 
		  "label", _("Create field"), 
		  "icon", "list_new.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[8]);

  menu1[9] = td_mod_menu_new(); /* 17 */
  gtk_object_set (GTK_OBJECT (menu1[9]), 
		  "label", _("Create property"), 
		  "icon", "list_property.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[9]);

  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new()); /* 18 */

  menu1[11] = td_mod_menu_new(); /* 19 */
  gtk_object_set (GTK_OBJECT (menu1[11]), 
		  "label", _("Remove"), 
		  "icon", "list_trash.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[11]);

  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new()); /* 20 */
}

void menu_predefined_tables (GtkWidget *menuitem, GtkObject *mod)
{
  gchar *module;
  GList *row;
  GList *tables;
  GList *fields;
  GtkObject *properties;
  int table_id;
  int field_id;
  GtkCTreeNode *table_node;
  GtkCTreeNode *field_node;
  int i, j, k;

  /*** Tables */
  td_app_message (NULL, _("Creating predefined tables"), TD_MSG_BEGIN);
  td_app_message (g_strdup_printf ("%s...", _("Creating predefined tables")), NULL, TD_MSG_MESSAGE);
  gtk_label_get (GTK_LABEL (GTK_BIN (menuitem)->child), &module);
  tables = td_database_column (g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=1) AND (module = '%s') AND (type = 'table');", module));
  for (i=0; i<g_list_length (tables); i++)
    {
      td_database_insert (g_strdup_printf ("INSERT INTO td_tables (name, type) VALUES ('%s', 'table');", (gchar*) g_list_nth_data (tables, i)), "td_tables");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_tables WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      table_node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), NULL, NULL, row);
      table_id = CURRENT_ID;
      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = 0) AND (td_id_sibling = 0);", CURRENT_ID));
      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, 0, 0);", CURRENT_ID), "td_tables_tree");

      /*** Champs - Fields */
      fields = td_database_column (g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=1) AND (module = '%s') AND (ttable = '%s') AND (type = 'field');", module, (gchar*) g_list_nth_data (tables, i)));
      for (j=0; j<g_list_length (fields); j++)
	{
	  td_database_insert (g_strdup_printf ("INSERT INTO td_tables (name, type) VALUES ('%s', 'field');", (gchar*) g_list_nth_data (fields, j)), "td_tables");
	  row = td_database_row (g_strdup_printf ("SELECT %s FROM td_tables WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
	  field_node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), table_node, NULL, row);
	  field_id = CURRENT_ID;
	  td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, table_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, table_id), "td_tables_tree");

	  /*** Proprits - Properties */
	  properties = td_database_select (g_strdup_printf ("SELECT name, value FROM td_cogitation_predef WHERE (ggroup=1) AND (module = '%s') AND (ttable = '%s') AND (field = '%s') AND (type = 'property');", module, (gchar*) g_list_nth_data (tables, i), (gchar*) g_list_nth_data (fields, j)));
	  for (k=0; k<g_list_length (TD_DB_DATATABLE (properties)->item); k++)
	    {
	      td_database_insert (g_strdup_printf ("INSERT INTO td_tables (name, value, type) VALUES ('%s', '%s', 'property');",
						   (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (properties)->item, k), 0),
						   (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (properties)->item, k), 1)), "td_tables");
	      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, field_id));
	      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, field_id), "td_tables_tree");
	    }
	}
    }
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Creating predefined tables"), module), TD_MSG_DONE);
  td_app_message (NULL, _("Creating predefined tables"), TD_MSG_END);
}

void menu_predefined_module (GtkWidget *menuitem, GtkObject *mod)
{
  gchar *module;
  GList *row;
  GList *tables;
  GList *fields;
  int module_id;
  int table_id;
  GtkCTreeNode *module_node;
  GtkCTreeNode *table_node;
  int i, j;

  /*** Module */
  td_app_message (NULL, _("Creating predefined tables"), TD_MSG_BEGIN);
  td_app_message (g_strdup_printf ("%s...", _("Creating predefined module")), NULL, TD_MSG_MESSAGE);
  gtk_label_get (GTK_LABEL (GTK_BIN (menuitem)->child), &module);
  td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'module');", module), "td_modules");
  row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
  module_node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), NULL, NULL, row);
  module_id = CURRENT_ID;
  td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = 0) AND (td_id_sibling = 0);", CURRENT_ID));
  td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, 0, 0);", CURRENT_ID), "td_modules_tree");

  /*** Tables */
  tables = td_database_column (g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=1) AND (module = '%s') AND (type = 'table');", module));
  for (i=0; i<g_list_length (tables); i++)
    {
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES ('%s', '%s', 'table');", (gchar*) g_list_nth_data (tables, i), (gchar*) g_list_nth_data (tables, i)), "td_modules");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      table_node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), module_node, NULL, row);
      table_id = CURRENT_ID;
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, module_id));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, module_id), "td_tables_tree");

      /*** Champs - Fields */
      fields = td_database_column (g_strdup_printf ("SELECT value FROM td_cogitation_predef WHERE (ggroup=1) AND (module = '%s') AND (ttable = '%s') AND (type = 'field');", module, (gchar*) g_list_nth_data (tables, i)));
      for (j=0; j<g_list_length (fields); j++)
	{
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES ('%s', '%s', 'field');", (gchar*) g_list_nth_data (fields, j), (gchar*) g_list_nth_data (fields, j)), "td_modules");
	  td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, table_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, table_id), "td_modules_tree");
	}
    }
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Creating predefined module"), module), TD_MSG_DONE);
  td_app_message (NULL, _("Creating predefined tables"), TD_MSG_END);
}

void plugins_menu_refresh (GtkObject *mod, GtkObject *mod_tree)
{
  int i;

  /*** Recherche du module enfant - Searching child module */
  for (i=0; i<g_list_length (TD_MOD (mod_main)->child); i++)
    if (mod_tree == g_list_nth_data (TD_MOD (mod_main)->child, i))
      break;

  /*** Go ! */
  switch (i)
    {

      /*** Tables */
    case 0:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_tables WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 0)), "query_visible", "TD_CURRENT (null);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 1)), "query_visible", "TD_CURRENT (null);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 2)), "query_visible", "TD_CURRENT td_id WHERE (type = 'table');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 3)), "query_visible", "TD_CURRENT td_id WHERE (type = 'table');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 4)), "query_visible", "TD_CURRENT td_id WHERE (type = 'table');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 5)), "query_visible", g_strdup_printf ("SELECT td_id FROM td_tables WHERE ((type = 'field') OR (type = 'rule') OR (type = 'function')) AND (td_id = %d);", CURRENT_ID), NULL);

      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 6)), "query_visible", "TD_CURRENT td_id;", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 7)), "query_visible", "TD_CURRENT td_id;", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 8)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 9)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 10)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 11)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 12)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 13)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 14)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 15)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 16)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 17)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 18)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 19)), "query_visible", "(null)", NULL);
      break;

      /*** Modules */
    case 1:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 0)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 1)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 2)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 3)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 4)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 5)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 6)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 7)), "query_visible", "(null)", NULL);

      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 8)), "query_visible", "TD_CURRENT (null);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 9)), "query_visible", "TD_CURRENT (null);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 10)), "query_visible", "TD_CURRENT td_id WHERE (type = 'module');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 11)), "query_visible", "TD_CURRENT td_id WHERE (type = 'module');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 12)), "query_visible", "TD_CURRENT td_id WHERE (type = 'module');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 13)), "query_visible", "TD_CURRENT td_id WHERE (type = 'module');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 14)), "query_visible", "TD_CURRENT td_id WHERE (type = 'module');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 15)), "query_visible", "TD_CURRENT td_id WHERE (type = 'module');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 16)), "query_visible", g_strdup_printf ("SELECT td_id FROM td_modules WHERE ((type = 'table') OR (type = 'interface') OR (type = 'bench') OR (type = 'etabliste')) AND (td_id = %d);", CURRENT_ID), NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 17)), "query_visible", g_strdup_printf ("SELECT td_id FROM td_modules WHERE ((type = 'field') OR (type = 'palette')) AND (td_id = %d);", CURRENT_ID), NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 18)), "query_visible", "TD_CURRENT td_id;", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 19)), "query_visible", "TD_CURRENT td_id;", NULL);
      break;
    default:
      break;
    }
}

void plugins_menu_action (GtkObject *mod, int menu_id)
{
  GtkCTreeNode *node;
  GList *row;
  int int_tmp;
  int id_sibling;
  int id_parent;
  switch (menu_id)
    {

      /*** Tables */
    case 0:
      td_database_insert ("INSERT INTO td_tables (type) VALUES ('table');", "td_tables");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_tables WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), NULL, NULL, row);
      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = 0) AND (td_id_sibling = 0);", CURRENT_ID));
      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, 0, 0);", CURRENT_ID), "td_tables_tree");
      break;

    case 1:
      break;

    case 2:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_tables (type) VALUES ('field');", "td_tables");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_tables WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_tables_tree");
      break;

    case 3:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_tables (type) VALUES ('rule');", "td_tables");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_tables WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_tables_tree");
      break;

    case 4:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_tables (type) VALUES ('function');", "td_tables");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_tables WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_tables_tree");
      break;

    case 5:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_tables (type) VALUES ('property');", "td_tables");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_tables WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_tables_tree");
      break;

    case 7:
      id_sibling = atoi (td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM td_tables_tree WHERE td_id = %d;", CURRENT_ID)));
      id_parent = atoi (td_database_value (g_strdup_printf ("SELECT td_id_parent FROM td_tables_tree WHERE td_id = %d;", CURRENT_ID)));
      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = %d);", id_sibling, id_parent, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_tables WHERE td_id IN (SELECT td_id FROM td_tables_tree WHERE td_id_parent = %d);", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_tables_tree WHERE td_id = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_tables_tree WHERE td_id_parent = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_tables WHERE td_id = %d;", CURRENT_ID));
      gtk_ctree_remove_node (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      CURRENT_ID = 0;
      CURRENT_ROW = NULL;
      TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected = NULL;
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;

      /*** Modules */
    case 8:
      td_database_insert ("INSERT INTO td_modules (type) VALUES ('module');", "td_modules");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), NULL, NULL, row);
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = 0) AND (td_id_sibling = 0);", CURRENT_ID));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, 0, 0);", CURRENT_ID), "td_modules_tree");
      break;

    case 9:
      break;

    case 10:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_modules (type) VALUES ('table');", "td_modules");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_modules_tree");
      break;

    case 11:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'interface');", _("Interface")), "td_modules");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_modules_tree");
      break;

    case 12:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'bench');", _("Bench")), "td_modules");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_modules_tree");
      break;

    case 13:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'etabliste');", _("Etabliste")), "td_modules");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_modules_tree");
      break;

    case 14:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'palette');", _("Palette")), "td_modules");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_modules_tree");
      break;

    case 15:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'menu');", _("Menu")), "td_modules");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_modules_tree");
      break;

    case 16:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_modules (type) VALUES ('field');", "td_modules");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_modules_tree");
      break;

    case 17:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_modules (type) VALUES ('property');", "td_modules");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_modules WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_modules_tree");
      break;

    case 19:
      id_sibling = atoi (td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM td_modules_tree WHERE td_id = %d;", CURRENT_ID)));
      id_parent = atoi (td_database_value (g_strdup_printf ("SELECT td_id_parent FROM td_modules_tree WHERE td_id = %d;", CURRENT_ID)));
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = %d);", id_sibling, id_parent, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_modules WHERE td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %d);", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_modules_tree WHERE td_id = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_modules_tree WHERE td_id_parent = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_modules WHERE td_id = %d;", CURRENT_ID));
      gtk_ctree_remove_node (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      CURRENT_ID = -1;
      CURRENT_ROW = NULL;
      TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected = NULL;
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 1)));
      break;
    default:
      break;
    }
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
gboolean load (TdDbBase *base)
{
  TdDbTable *table = NULL;
  TdField *table_field = NULL;
  TdRule *table_rule = NULL;
  TdFunction *table_function = NULL;
  TdDbMod *mod = NULL;
  TdDbModTable *mod_table = NULL;
  TdField *mod_table_field = NULL;
  TdField *mod_interface_field = NULL;
  TdField *mod_bench_field = NULL;
  TdField *mod_etabliste_field = NULL;
  TdDbDatatable *datatable = NULL;
  int module_id;
  int table_id;
  int field_id;
  int interface_id;
  int bench_id;
  int etabliste_id;
  int palette_id;
  int i, j, k, l;
  GList *row;

  /*** Tables */
  for (i=0; i<g_list_length (base->table); i++)
    {
      table = (TdDbTable*) g_list_nth_data (base->table, i);
      td_database_insert (g_strdup_printf ("INSERT INTO td_tables (name, comment, type) VALUES (%s, %s, 'table');", 
					   td_database_adaptvalue (table->name, "text"),
					   td_database_adaptvalue (table->comment, "text")), "td_tables");
      table_id = CURRENT_ID;
      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = 0) AND (td_id_sibling = 0);", CURRENT_ID));
      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, 0, 0);", CURRENT_ID), "td_tables_tree");

      /*** Champs - Fields */
      for (j=0; j<g_list_length (table->field); j++)
	{
	  table_field = (TdField*) g_list_nth_data (table->field, j);
	  td_database_insert (g_strdup_printf ("INSERT INTO td_tables (name, comment, type) VALUES (%s, %s, 'field');", 
					       td_database_adaptvalue (table_field->name, "text"),
					       td_database_adaptvalue (table_field->comment, "text")), "td_tables");
	  field_id = CURRENT_ID;
	  td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, table_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, table_id), "td_tables_tree");

	  /*** Proprits - Properties */
	  for (k=0; k< g_list_length (table_field->property_value); k++)
	    {
	      td_database_insert (g_strdup_printf ("INSERT INTO td_tables (name, value, type) VALUES (%s, %s, 'property');", 
						   td_database_adaptvalue (g_list_nth_data (table_field->property_name, k), "text"),
						   td_database_adaptvalue (g_list_nth_data (table_field->property_value, k), "text")), "td_tables");
	      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, field_id));
	      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, field_id), "td_tables_tree");
	    }
	}

      /*** Rgles - Rules */
      for (j=0; j<g_list_length (table->rule); j++)
	{
	  table_rule = (TdRule*) g_list_nth_data (table->rule, j);
	  td_database_insert (g_strdup_printf ("INSERT INTO td_tables (name, comment, type) VALUES (%s, %s, 'rule');",
					       td_database_adaptvalue (table_rule->name, "text"),
					       td_database_adaptvalue (table_rule->comment, "text")), "td_tables");
	  field_id = CURRENT_ID;
	  td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, table_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, table_id), "td_tables_tree");

	  /*** Proprits - Properties */
	  for (k=0; k< g_list_length (table_rule->property_value); k++)
	    {
	      td_database_insert (g_strdup_printf ("INSERT INTO td_tables (name, value, type) VALUES (%s, %s, 'property');", 
						   td_database_adaptvalue (g_list_nth_data (table_rule->property_name, k), "text"),
						   td_database_adaptvalue (g_list_nth_data (table_rule->property_value, k), "text")), "td_tables");
	      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, field_id));
	      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, field_id), "td_tables_tree");
	    }
	}

      /*** Fonctions - Functions */
      for (j=0; j<g_list_length (table->function); j++)
	{
	  table_function = (TdFunction*) g_list_nth_data (table->function, j);
	  td_database_insert (g_strdup_printf ("INSERT INTO td_tables (name, comment, type) VALUES (%s, %s, 'function');",
					       td_database_adaptvalue (table_function->name, "text"),
					       td_database_adaptvalue (table_function->comment, "text")), "td_tables");
	  field_id = CURRENT_ID;
	  td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, table_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, table_id), "td_tables_tree");

	  /*** Proprits - Properties */
	  for (k=0; k< g_list_length (table_function->property_value); k++)
	    {
	      td_database_insert (g_strdup_printf ("INSERT INTO td_tables (name, value, type) VALUES (%s, %s, 'property');", 
						   td_database_adaptvalue (g_list_nth_data (table_function->property_name, k), "text"),
						   td_database_adaptvalue (g_list_nth_data (table_function->property_value, k), "text")), "td_tables");
	      td_database_command (g_strdup_printf ("UPDATE td_tables_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, field_id));
	      td_database_insert (g_strdup_printf ("INSERT INTO td_tables_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, field_id), "td_tables_tree");
	    }
	}
    }

  /*** Modules */
  for (i=0; i<g_list_length (base->mod); i++)
    {
      mod = (TdDbMod*) g_list_nth_data (base->mod, i);
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, comment, type) VALUES (%s, %s, 'module');",
					   td_database_adaptvalue (mod->name, "text"),
					   td_database_adaptvalue (mod->comment, "text")), "td_modules");
      module_id = CURRENT_ID;
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = 0) AND (td_id_sibling = 0);", CURRENT_ID));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, 0, 0);", CURRENT_ID), "td_modules_tree");

      /*** Table */
      for (j=0; j<g_list_length (mod->table); j++)
	{
	  mod_table = (TdDbModTable*) g_list_nth_data (mod->table, j);
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES (%s, %s, 'table');",
					       td_database_adaptvalue (mod_table->name, "text"),
					       td_database_adaptvalue (mod_table->table, "text")), "td_modules");
	  table_id = CURRENT_ID;
	  td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, module_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, module_id), "td_modules_tree");

	  /*** Champs - Fields */
	  for (k=0; k<g_list_length (mod_table->field); k++)
	    {
	      mod_table_field = (TdField*) g_list_nth_data (mod_table->field, k);
	      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES (%s, %s, 'field');",
						   td_database_adaptvalue (mod_table_field->name, "text"),
						   td_database_adaptvalue (mod_table_field->table_field, "text")), "td_modules");
	      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, table_id));
	      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, table_id), "td_modules_tree");
	    }
	}

      /*** Interface */
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'interface');", _("Interface")), "td_modules");
      interface_id = CURRENT_ID;
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, module_id));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, module_id), "td_modules_tree");
      for (j=0; j<g_list_length (mod->interface_field); j++)
	{
	  mod_interface_field = (TdField*) g_list_nth_data (mod->interface_field, j);
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES (%s, %s, 'field');", 
					       td_database_adaptvalue (mod_interface_field->name, "text"),
					       td_database_adaptvalue (mod_interface_field->table_field, "text")), "td_modules");
	  field_id = CURRENT_ID;
	  td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, interface_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, interface_id), "td_modules_tree");

	  /*** Proprits - Properties */
	  for (k=0; k<g_list_length (mod_interface_field->property_name); k++)
	    {
	      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES (%s, %s, 'property');",
						   td_database_adaptvalue (g_list_nth_data (mod_interface_field->property_name, k), "text"),
						   td_database_adaptvalue (g_list_nth_data (mod_interface_field->property_value, k), "text")), "td_modules");
	      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, field_id));
	      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, field_id), "td_modules_tree");
	    }
	}

      /*** Etabli - Bench */
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'bench');", _("Bench")), "td_modules");
      bench_id = CURRENT_ID;
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, module_id));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, module_id), "td_modules_tree");
      for (j=0; j<g_list_length (mod->bench_field); j++)
	{
	  mod_bench_field = (TdField*) g_list_nth_data (mod->bench_field, j);
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES (%s, %s, 'field');", 
					       td_database_adaptvalue (mod_bench_field->name, "text"),
					       td_database_adaptvalue (mod_bench_field->table_field, "text")), "td_modules");
	  field_id = CURRENT_ID;
	  td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, bench_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, bench_id), "td_modules_tree");

	  /*** Proprits - Properties */
	  for (k=0; k<g_list_length (mod_bench_field->property_name); k++)
	    {
	      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES (%s, %s, 'property');",
						   td_database_adaptvalue (g_list_nth_data (mod_bench_field->property_name, k), "text"),
						   td_database_adaptvalue (g_list_nth_data (mod_bench_field->property_value, k), "text")), "td_modules");
	      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, field_id));
	      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, field_id), "td_modules_tree");
	    }
	}

      /*** Etabliste */
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'etabliste');", _("Etabliste")), "td_modules");
      etabliste_id = CURRENT_ID;
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, module_id));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, module_id), "td_modules_tree");
      for (j=0; j<g_list_length (mod->etabliste_field); j++)
	{
	  mod_etabliste_field = (TdField*) g_list_nth_data (mod->etabliste_field, j);
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES (%s, %s, 'field');", 
					       td_database_adaptvalue (mod_etabliste_field->name, "text"),
					       td_database_adaptvalue (mod_etabliste_field->table_field, "text")), "td_modules");
	  field_id = CURRENT_ID;
	  td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, etabliste_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, etabliste_id), "td_modules_tree");

	  /*** Proprits - Properties */
	  for (k=0; k<g_list_length (mod_etabliste_field->property_name); k++)
	    {
	      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES (%s, %s, 'property');",
						   td_database_adaptvalue (g_list_nth_data (mod_etabliste_field->property_name, k), "text"),
						   td_database_adaptvalue (g_list_nth_data (mod_etabliste_field->property_value, k), "text")), "td_modules");
	      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, field_id));
	      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, field_id), "td_modules_tree");
	    }
	}

      /*** Palette */
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'palette');", _("Palette")), "td_modules");
      palette_id = CURRENT_ID;
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, module_id));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, module_id), "td_modules_tree");
      if ((mod->name_param) && (strlen (g_strstrip (mod->name_param))) && strcmp (mod->name_param, "(null)"))
	{
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES ('palette name', %s, 'property');", td_database_adaptvalue (mod->name_param, "text")), "td_modules");
	  td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, palette_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, palette_id), "td_modules_tree");
	}
      if ((mod->icon) && (strlen (g_strstrip (mod->icon))) && strcmp (mod->icon, "(null)"))
	{
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, value, type) VALUES ('palette icon', %s, 'property');", td_database_adaptvalue (mod->icon, "text")), "td_modules");
	  td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, palette_id));
	  td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, palette_id), "td_modules_tree");
	}

      /*** Menu */
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules (name, type) VALUES ('%s', 'menu');", _("Menu")), "td_modules");
      td_database_command (g_strdup_printf ("UPDATE td_modules_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, module_id));
      td_database_insert (g_strdup_printf ("INSERT INTO td_modules_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, module_id), "td_modules_tree");
    }
  return TRUE;
}

GtkObject *plugins_save (void)
{
  int i, j, k, m;
  GtkObject *ret;
  GtkObject *mod;
  GtkObject *table;
  GtkObject *table_field;
  GtkObject *table_rule;
  GtkObject *table_function;
  GtkObject *bench;
  GtkObject *datatable_modules;
  GtkObject *datatable_tables;
  gchar *id_interface;
  gchar *id_bench;
  GtkObject *datatable_fields;
  GtkObject *datatable_properties;
  gchar *txt_tmp;

  /*** Base */
  ret = td_db_base_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "", 
		  "comment", "", NULL);

  /*** Tables */
  datatable_tables = td_datatable_tree_sorted ("td_tables", "td_tables_tree",
					       "SELECT name, comment, td_id FROM td_tables WHERE type = 'table';",
					       "SELECT * FROM td_tables_tree WHERE td_id_parent = 0;", 2);
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable_tables)->item); i++)
    {
      table = td_db_table_new();
      gtk_object_set (table, 
		      "name", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tables)->item, i), 0),
		      "comment", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tables)->item, i), 1), NULL);
      td_db_base_add_table (TD_DB_BASE (ret), table);

      /*** Champs, rgles et fonctions - Fields, rules and functions */
      datatable_fields = td_datatable_tree_sorted ("td_tables", "td_tables_tree",
						   g_strdup_printf ("SELECT name, comment, type, td_id FROM td_tables WHERE td_id IN (SELECT td_id FROM td_tables_tree WHERE td_id_parent = %s);", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tables)->item, i), 2)),
						   g_strdup_printf ("SELECT * FROM td_tables_tree WHERE td_id_parent = %s;", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tables)->item, i), 2)), 3);
      for (j=0; j<g_list_length (TD_DB_DATATABLE (datatable_fields)->item); j++)
	{
	  
	  /*** Champs - Fields */
	  if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 2), "field"))
	    {
	      table_field = td_field_new();
	      gtk_object_set (table_field,
			      "name", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 0),
			      "comment", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 1), NULL);
	      td_db_table_add_field (TD_DB_TABLE (table), table_field);
	      datatable_properties = td_datatable_tree_sorted ("td_tables", "td_tables_tree",
							       g_strdup_printf ("SELECT name, value, td_id FROM td_tables WHERE td_id IN (SELECT td_id FROM td_tables_tree WHERE td_id_parent = %s);", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 3)),
							       g_strdup_printf ("SELECT * FROM td_tables_tree WHERE td_id_parent = %s;", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 3)), 2);
	      for (k=0; k<g_list_length (TD_DB_DATATABLE (datatable_properties)->item); k++)
		td_field_add_property (TD_FIELD (table_field),
				       g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 0),
				       g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 1));
	      continue;
	    }

	  /*** Rgle - Rules */
	  if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 2), "rule"))
	    {
	      table_rule = td_rule_new();
	      gtk_object_set (table_rule,
			      "name", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 0),
			      "comment", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 1), NULL);
	      td_db_table_add_rule (TD_DB_TABLE (table), table_rule);
	      datatable_properties = td_datatable_tree_sorted ("td_tables", "td_tables_tree",
							       g_strdup_printf ("SELECT name, value, td_id FROM td_tables WHERE td_id IN (SELECT td_id FROM td_tables_tree WHERE td_id_parent = %s);", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 3)),
							       g_strdup_printf ("SELECT * FROM td_tables_tree WHERE td_id_parent = %s;", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 3)), 2);
	      for (k=0; k<g_list_length (TD_DB_DATATABLE (datatable_properties)->item); k++)
		td_rule_add_property (TD_RULE (table_rule),
				      g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 0),
				      g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 1));
	      continue;
	    }

	  /*** Fonction - Functions */
	  if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 2), "function"))
	    {
	      table_function = td_function_new();
	      gtk_object_set (table_function,
			      "name", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 0),
			      "comment", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 1), NULL);
	      td_db_table_add_function (TD_DB_TABLE (table), table_function);
	      datatable_properties = td_datatable_tree_sorted ("td_tables", "td_tables_tree",
							       g_strdup_printf ("SELECT name, value, td_id FROM td_tables WHERE td_id IN (SELECT td_id FROM td_tables_tree WHERE td_id_parent = %s);", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 3)),
							       g_strdup_printf ("SELECT * FROM td_tables_tree WHERE td_id_parent = %s;", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 3)), 2);
	      for (k=0; k<g_list_length (TD_DB_DATATABLE (datatable_properties)->item); k++)
		td_function_add_property (TD_FUNCTION (table_function),
					  g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 0),
					  g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 1));
	    }
	}
    }

  /*** Modules */
  datatable_modules = td_datatable_tree_sorted ("td_modules", "td_modules_tree",
						"SELECT name, value, td_id FROM td_modules WHERE type = 'module';",
						"SELECT * FROM td_modules_tree WHERE td_id_parent = 0;", 2);
  for (m=0; m<g_list_length (TD_DB_DATATABLE (datatable_modules)->item); m++)
    {
      mod = td_db_mod_new();
      gtk_object_set (mod, 
		      "name", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_modules)->item, m), 0),
		      "comment", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_modules)->item, m), 1), NULL);
      txt_tmp = td_database_value (g_strdup_printf ("SELECT value FROM td_modules WHERE (name = 'palette name') AND (td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent IN (SELECT td_id FROM td_modules WHERE name='%s'))));", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_modules)->item, m), 0)));
      if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	txt_tmp = "";
      gtk_object_set (mod, "name_param", txt_tmp, NULL);
      txt_tmp = td_database_value (g_strdup_printf ("SELECT value FROM td_modules WHERE (name = 'palette icon') AND (td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent IN (SELECT td_id FROM td_modules WHERE name='%s'))));", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_modules)->item, m), 0)));
      if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	txt_tmp = "";
      printf ("*** Debug : icon : %s \n", txt_tmp); 
      gtk_object_set (mod, "icon", txt_tmp, NULL);
      td_db_base_add_mod (TD_DB_BASE (ret), mod);

      /*** Table */
      datatable_tables = td_datatable_tree_sorted ("td_modules", "td_modules_tree",
						   g_strdup_printf ("SELECT name, comment, td_id FROM td_modules WHERE (type = 'table') AND (td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s));", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_modules)->item, m), 2)),
						   g_strdup_printf ("SELECT * FROM td_modules_tree WHERE td_id_parent = %s;", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_modules)->item, m), 2)), 2);
      for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable_tables)->item); i++)
	{
	  table = td_db_mod_table_new();
	  gtk_object_set (table, 
			  "name", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tables)->item, i), 0),
			  "table", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tables)->item, i), 1), NULL);
	  td_db_mod_add_table (TD_DB_MOD (mod), table);

	  /*** Champs - Fields */
	  datatable_fields = td_datatable_tree_sorted ("td_modules", "td_modules_tree",
						       g_strdup_printf ("SELECT name, comment, td_id FROM td_modules WHERE td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s);", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tables)->item, i), 2)),
						       g_strdup_printf ("SELECT * FROM td_modules_tree WHERE td_id_parent = %s;", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tables)->item, i), 2)), 2);
	  for (j=0; j<g_list_length (TD_DB_DATATABLE (datatable_fields)->item); j++)
	    {
	      table_field = td_field_new();
	      gtk_object_set (table_field,
			      "name", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 0),
			      "table_field", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 1), NULL);
	      td_db_mod_table_add_field (TD_DB_MOD_TABLE (table), table_field);
	    }
	}

      /*** Interface */
      id_interface = td_database_value (g_strdup_printf ("SELECT td_id FROM td_modules WHERE (type = 'interface') AND (td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s));", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_modules)->item, m), 2)));
      datatable_fields = td_datatable_tree_sorted ("td_modules", "td_modules_tree", 
						   g_strdup_printf ("SELECT name, value, td_id FROM td_modules WHERE td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s);", id_interface),
						   g_strdup_printf ("SELECT * FROM td_modules_tree WHERE td_id_parent = %s;", id_interface), 2);
      for (j=0; j<g_list_length (TD_DB_DATATABLE (datatable_fields)->item); j++)
	{
	  table_field = td_field_new();
	  gtk_object_set (table_field,
			  "name", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 0),
			  "table_field", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 1), NULL);
	  td_db_mod_add_interface_field (TD_DB_MOD (mod), table_field);

	  /*** Proprits - Properties */
	  datatable_properties = td_datatable_tree_sorted ("td_modules", "td_modules_tree",
							   g_strdup_printf ("SELECT name, value, td_id FROM td_modules WHERE td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s);", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 2)),
							   g_strdup_printf ("SELECT * FROM td_modules_tree WHERE td_id_parent = %s;", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 2)), 2);
	  for (k=0; k<g_list_length (TD_DB_DATATABLE (datatable_properties)->item); k++)
	    td_field_add_property (TD_FIELD (table_field), 
				   g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 0),
				   g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 1));
	}

      /*** Etabli - Bench */
      id_bench = td_database_value (g_strdup_printf ("SELECT td_id FROM td_modules WHERE (type = 'bench') AND (td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s));", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_modules)->item, m), 2)));
      datatable_fields = td_datatable_tree_sorted ("td_modules", "td_modules_tree", 
						   g_strdup_printf ("SELECT name, value, td_id FROM td_modules WHERE td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s);", id_bench),
						   g_strdup_printf ("SELECT * FROM td_modules_tree WHERE td_id_parent = %s;", id_bench), 2);
      for (j=0; j<g_list_length (TD_DB_DATATABLE (datatable_fields)->item); j++)
	{
	  table_field = td_field_new();
	  gtk_object_set (table_field,
			  "name", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 0),
			  "table_field", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 1), NULL);
	  td_db_mod_add_bench_field (TD_DB_MOD (mod), table_field);

	  /*** Proprits - Properties */
	  datatable_properties = td_datatable_tree_sorted ("td_modules", "td_modules_tree",
							   g_strdup_printf ("SELECT name, value, td_id FROM td_modules WHERE td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s);", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 2)),
							   g_strdup_printf ("SELECT * FROM td_modules_tree WHERE td_id_parent = %s;", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 2)), 2);
	  for (k=0; k<g_list_length (TD_DB_DATATABLE (datatable_properties)->item); k++)
	    td_field_add_property (TD_FIELD (table_field), 
				   g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 0),
				   g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 1));
	}

      /*** Etabliste */
      id_bench = td_database_value (g_strdup_printf ("SELECT td_id FROM td_modules WHERE (type = 'etabliste') AND (td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s));", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_modules)->item, m), 2)));
      datatable_fields = td_datatable_tree_sorted ("td_modules", "td_modules_tree",
						   g_strdup_printf ("SELECT name, value, td_id FROM td_modules WHERE td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s);", id_bench),
						   g_strdup_printf ("SELECT * FROM td_modules_tree WHERE td_id_parent = %s;", id_bench), 2);
      for (j=0; j<g_list_length (TD_DB_DATATABLE (datatable_fields)->item); j++)
	{
	  table_field = td_field_new();
	  gtk_object_set (table_field,
			  "name", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 0),
			  "table_field", g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 1), NULL);
	  td_db_mod_add_etabliste_field (TD_DB_MOD (mod), table_field);

	  /*** Proprits - Properties */
	  datatable_properties = td_datatable_tree_sorted ("td_modules", "td_modules_tree",
							   g_strdup_printf ("SELECT name, value, td_id FROM td_modules WHERE td_id IN (SELECT td_id FROM td_modules_tree WHERE td_id_parent = %s);", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 2)),
							   g_strdup_printf ("SELECT * FROM td_modules_tree WHERE td_id_parent = %s;", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_fields)->item, j), 2)), 2);
	  for (k=0; k<g_list_length (TD_DB_DATATABLE (datatable_properties)->item); k++)
	    td_field_add_property (TD_FIELD (table_field), 
				   g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 0),
				   g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_properties)->item, k), 1));
	}

    }
  return ret;
}
