/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Dtails des greffons
 * ToutDoux's plug-in : Plug-ins details
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
GtkObject *mod;
GList *plugins_filelist;
GList *plugins_list;

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Plug-ins details"),
		  "type", _("help"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("help"),
		  "category3", _("plug-ins details"),
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

GtkObject *mod_def (void)
{
  GtkObject *ret;
  GtkObject *box[2];
  GtkWidget *ctree[2];
  GtkWidget *scrolledwindow[2];
  GtkWidget *hbox1;
  GtkWidget *vbox1;
  GtkWidget *vseparator1;
  GtkWidget *viewport1;
  gchar *txt[2];
  gchar *txt2[3];
  gchar *txt_tmp;
  int i;

  GtkWidget *toolbar;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *button1;

  /*** Module */
  ret = td_mod_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "plug-ins_detail",
		  "name_intl", _("Plug-ins details"), 
		  "id", -1, NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def());

  /*** Barre d'outils - Tools barr */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  radiobutton1 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), NULL, _("Details"), "button_module.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), NULL);
  radiobutton2 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton1, _("Loaded"), "button_server.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button1 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Close"), "button_close.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (td_mod_hide), GTK_OBJECT (ret));
  td_mod_set_window_toolbar (TD_MOD (ret), toolbar);

  /*** Dtails - Details */
  box[0] = td_mod_box_new();
  gtk_object_set (GTK_OBJECT (box[0]), "name", _("Details"), NULL);
  td_mod_add_child (TD_MOD (ret), box[0]);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  td_mod_box_set_widget (TD_MOD_BOX (box[0]), hbox1);
  scrolledwindow[0] = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow[0]);
  gtk_box_pack_start (GTK_BOX (hbox1), scrolledwindow[0], FALSE, FALSE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow[0]), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  ctree[0] = gtk_ctree_new (2, 0);
  if (TD_FLAG_DEBUG_MODE)
    gtk_clist_column_titles_show (GTK_CLIST (ctree[0]));
  gtk_widget_show (ctree[0]);
  gtdk_clist_adjustheight (GTK_CLIST (ctree[0]));
  gtk_container_add (GTK_CONTAINER (scrolledwindow[0]), ctree[0]);
  gtdk_clist_title (GTK_CLIST (ctree[0]), 0, _("Category"), 1, GTK_JUSTIFY_CENTER);
  gtdk_clist_title (GTK_CLIST (ctree[0]), 1, _("File"), -2, GTK_JUSTIFY_CENTER);
  td_mod_box_set_widget_data (TD_MOD_BOX (box[0]), ctree[0]);
  td_app_message (NULL, _("Plug-ins details : Reading plug-ins"), TD_MSG_BEGIN);
  plugins_filelist = td_about_filelist (NULL, NULL);
  for (i=0; i<g_list_length (plugins_filelist); i++)
    plugins_list = g_list_append (plugins_list, td_about_get (g_list_nth_data (plugins_filelist, i)));
  td_about_categorytree (GTK_CTREE (ctree[0]), plugins_list, plugins_filelist);
  gtk_clist_set_column_width (GTK_CLIST (ctree[0]), 0, gtdk_ctree_optimal_column_width (GTK_CTREE (ctree[0]), 0));
  td_app_message (NULL, _("Plug-ins details : Reading plug-ins"), TD_MSG_END);
  vseparator1 = gtk_vseparator_new();
  gtk_widget_ref (vseparator1);
  gtk_widget_show (vseparator1);
  gtk_box_pack_start (GTK_BOX (hbox1), vseparator1, FALSE, TRUE, 0);
  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_box_pack_start (GTK_BOX (hbox1), viewport1, TRUE, TRUE, 0);
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (viewport1), vbox1);
  gtk_signal_connect (GTK_OBJECT (ctree[0]), "button_press_event", GTK_SIGNAL_FUNC (ctree_clicked), vbox1);
  gtk_signal_connect (GTK_OBJECT (ctree[0]), "tree_expand", GTK_SIGNAL_FUNC (gtdk_ctree_expand), scrolledwindow[0]);

  /*** Chargs - Loaded */
  box[1] = td_mod_box_new();
  gtk_object_set (GTK_OBJECT (box[1]), "name", _("Loaded"), NULL);
  td_mod_add_child (TD_MOD (ret), box[1]);
  scrolledwindow[1] = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow[1]);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow[1]), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  td_mod_box_set_widget (TD_MOD_BOX (box[1]), scrolledwindow[1]);
  ctree[1] = gtk_ctree_new (3, 0);
  gtdk_clist_adjustheight (GTK_CLIST (ctree[1]));
  gtk_widget_show (ctree[1]);
  gtk_ctree_set_expander_style (GTK_CTREE (ctree[1]), GTK_CTREE_EXPANDER_NONE);
  gtk_ctree_set_line_style (GTK_CTREE (ctree[1]), GTK_CTREE_LINES_NONE);
  gtk_container_add (GTK_CONTAINER (scrolledwindow[1]), ctree[1]);
  gtk_clist_column_titles_show (GTK_CLIST (ctree[1]));
  td_mod_box_set_widget_data (TD_MOD_BOX (box[1]), ctree[1]);
  gtdk_clist_title (GTK_CLIST (ctree[1]), 0, _("Name"), -1, GTK_JUSTIFY_LEFT);
  gtdk_clist_title (GTK_CLIST (ctree[1]), 1, _("File"), -1, GTK_JUSTIFY_LEFT);
  gtdk_clist_title (GTK_CLIST (ctree[1]), 2, _("Loaded"), -2, GTK_JUSTIFY_LEFT);
  gtk_signal_connect (GTK_OBJECT (ctree[1]), "button_press_event", GTK_SIGNAL_FUNC (td_mod_box_button_press), box[1]);
  return ret;
}

void plugins_init (void)
{
  if (!mod)
    {
      mod = mod_def();
      td_mod_create (TD_MOD (mod));
    }
  td_mod_show (TD_MOD (mod));
  plugins_update_all (APP);
}

void plugins_destroy (gpointer user_data)
{
  td_mod_destroy (TD_MOD (mod));
  g_list_free (plugins_filelist);
  g_list_free (plugins_list);
}

void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 0);
}
void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 1);
}

/*****************************************************************************/
/*** Navigateur - Browser */
/*****************************************************************************/
gboolean ctree_clicked (GtkWidget *widget, GdkEvent *event, GtkWidget *vbox1)
{
  GtkWidget *viewport1;
  GtkWidget *label1 = NULL;
  GtkWidget *label2;
  GtkWidget *label5;
  GtkWidget *hseparator1;
  GtkWidget *frame1;
  GtkWidget *scrolledwindow1;
  GtkWidget *text1;
  GtkWidget *frame2;
  GtkWidget *scrolledwindow2;
  GtkWidget *text2;
  GtkWidget *hseparator2;
  GtkWidget *label3;
  GtkWidget *label4;
  GtkWidget *href;
  GdkEventButton *bevent;
  gint row, column;
  gchar *txt_tmp;
  int i;
  GtkWidget *box_tmp = NULL;

  /*** Recherche du greffons - Searching plug-in */
  bevent = (GdkEventButton *) event;
  gtk_clist_get_selection_info (GTK_CLIST (widget), bevent->x, bevent->y, &row, &column);
  row = gtdk_clist_correction (GTK_CLIST (widget), row, bevent->y);
  if (row < 0)
    return TRUE;
  gtk_container_foreach (GTK_CONTAINER (vbox1), (GtkCallback)gtk_widget_destroy, NULL);
  gtk_clist_get_text (GTK_CLIST (widget), row, 1, &txt_tmp);
  if (!strcmp (txt_tmp, "(null)"))
    return TRUE;
  for (i=0; i<g_list_length (plugins_filelist); i++)
    if (!strcmp (txt_tmp, (gchar*) g_list_nth_data (plugins_filelist, i)))
      break;

  /*** Titre - Title */
  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_box_pack_start (GTK_BOX (vbox1), viewport1, FALSE, FALSE, 0);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport1), GTK_SHADOW_OUT);
  txt_tmp = g_strdup_printf("%s - %s", TD_ABOUT (g_list_nth_data (plugins_list, i))->name, TD_ABOUT (g_list_nth_data (plugins_list, i))->version);
  label1 = gtk_label_new (txt_tmp);
  gtk_widget_show (label1);
  gtk_container_add (GTK_CONTAINER (viewport1), label1);

  /*** Licence - License */
  box_tmp = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (box_tmp);
  gtk_container_set_border_width (GTK_CONTAINER (box_tmp), 5);
  gtk_box_pack_start (GTK_BOX (vbox1), box_tmp, FALSE, TRUE, 0);
  txt_tmp = g_strdup_printf ("%s", TD_ABOUT (g_list_nth_data (plugins_list, i))->copyright);
  label2 = gtk_label_new (txt_tmp);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (box_tmp), label2, FALSE, TRUE, 0);
  txt_tmp = g_strdup_printf ("%s", TD_ABOUT (g_list_nth_data (plugins_list, i))->license);
  label5 = gtk_label_new (txt_tmp);
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (box_tmp), label5, FALSE, TRUE, 0);

  /*** Description */
  frame2 = gtk_frame_new (_("Description"));
  gtk_widget_show (frame2);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);
  gtk_box_pack_start (GTK_BOX (vbox1), frame2, TRUE, TRUE, 0);
  box_tmp = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (box_tmp);
  gtk_container_set_border_width (GTK_CONTAINER (box_tmp), 5);
  gtk_container_add (GTK_CONTAINER (frame2), box_tmp);
  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_container_add (GTK_CONTAINER (box_tmp), scrolledwindow2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  text2 = gtk_text_new (NULL, NULL);
  gtk_widget_show (text2);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), text2);
  gtk_widget_realize (text2);
  if ((TD_ABOUT (g_list_nth_data (plugins_list, i))->help) && (strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->help, "(null)")))
    gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, TD_ABOUT (g_list_nth_data (plugins_list, i))->help, -2);

  /*** Auteurs - Authors */
  frame1 = gtk_frame_new (_("Authors"));
  gtk_widget_show (frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);
  box_tmp = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (box_tmp);
  gtk_container_set_border_width (GTK_CONTAINER (box_tmp), 5);
  gtk_container_add (GTK_CONTAINER (frame1), box_tmp);
  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (box_tmp), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  text1 = gtk_text_new (NULL, NULL);
  gtk_widget_show (text1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);
  gtk_widget_realize (text1);
  gtk_text_insert (GTK_TEXT (text1), NULL, NULL, NULL, TD_ABOUT (g_list_nth_data (plugins_list, i))->authors, -2);

  /*** Type */
  box_tmp = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (box_tmp);
  gtk_container_set_border_width (GTK_CONTAINER (box_tmp), 5);
  gtk_box_pack_start (GTK_BOX (vbox1), box_tmp, FALSE, TRUE, 0);
  txt_tmp = g_strdup_printf("%s: %s", _("Type"), TD_ABOUT (g_list_nth_data (plugins_list, i))->type);
  label3 = gtk_label_new (txt_tmp);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (box_tmp), label3, FALSE, TRUE, 0);
  txt_tmp = g_strdup_printf ("%s: %s", _("File"), (gchar*) g_list_nth_data (plugins_filelist, i));
  label4 = gtk_label_new (txt_tmp);
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (box_tmp), label4, FALSE, TRUE, 0);

  /*** Site web - Web site */
  if ((TD_ABOUT (g_list_nth_data (plugins_list, i))->web) && (strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->web, "(null)")))
    {
      href = gtdk_button_href (TD_ABOUT (g_list_nth_data (plugins_list, i))->web, NULL);
      gtk_widget_show (href);
      gtk_box_pack_start (GTK_BOX (vbox1), href, FALSE, FALSE, 0);
    }
  return TRUE;
}

/*****************************************************************************/
/*** Greffons - Plugins */
/*****************************************************************************/
void plugins_update_all (GtkObject *application)
{
  int i,j;
  gchar *txt[3];
  GtkCTreeNode *node = NULL;
  GdkPixmap *pixmap1 = NULL;
  GdkPixmap *pixmap2 = NULL;
  GdkBitmap *mask1 = NULL;
  GdkBitmap *mask2 = NULL;
  GdkColor transparent;
  if (!GTK_WIDGET_VISIBLE (TD_MOD (mod)->window))
    return;

  /*** Greffons noyaux - Core plug-ins */
  gtdk_ctree_clear (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data));
  pixmap1 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask1, &transparent, (gchar**) TD_STOCK_LIST_APPLICATION);
  pixmap2 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask2, &transparent, (gchar**) TD_STOCK_LIST_APPLICATION);
  if (PLUGINS_CORE_MESSAGES)
    {
      for (j=0; j<g_list_length (plugins_filelist); j++)
	if (!strcmp (g_strdup_printf ("%s%s", TD_PACKAGE_PLUGINS_DIR, "libdialog_messages.so"), (gchar*) g_list_nth_data (plugins_filelist, j)))
	  break;
      txt[0] = TD_ABOUT (g_list_nth_data (plugins_list, j))->name;
      txt[1] = g_strdup_printf ("%s%s", TD_PACKAGE_PLUGINS_DIR, "libdialog_messages.so");
      txt[2] = _("yes");
      node = gtk_ctree_insert_node (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), NULL, NULL, txt, 5, pixmap1, mask1, pixmap2, mask2, FALSE, FALSE);
    }
  if (PLUGINS_CORE_XTS)
    {
      for (j=0; j<g_list_length (plugins_filelist); j++)
	if (!strcmp (g_strdup_printf ("%s%s", TD_PACKAGE_PLUGINS_DIR, "libhelp_xts.so"), (gchar*) g_list_nth_data (plugins_filelist, j)))
	  break;
      txt[0] = TD_ABOUT (g_list_nth_data (plugins_list, j))->name;
      txt[1] = g_strdup_printf ("%s%s", TD_PACKAGE_PLUGINS_DIR, "libhelp_xts.so");
      txt[2] = _("yes");
      node = gtk_ctree_insert_node (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), NULL, NULL, txt, 5, pixmap1, mask1, pixmap2, mask2, FALSE, FALSE);
    }
  for (i=0; i<g_list_length (TD_APP (application)->mod_core); i++)
    {
      for (j=0; j<g_list_length (plugins_filelist); j++)
	if (!strcmp ((gchar*) g_list_nth_data (TD_APP (application)->mod_core, i), (gchar*) g_list_nth_data (plugins_filelist, j)))
	  break;
      txt[0] = TD_ABOUT (g_list_nth_data (plugins_list, j))->name;
      txt[1] = (gchar*) g_list_nth_data (TD_APP (application)->mod_core, i);
      txt[2] = _("yes");
      node = gtk_ctree_insert_node (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), NULL, NULL, txt, 5, pixmap1, mask1, pixmap2, mask2, FALSE, FALSE);
    }

  /*** Greffons de donnes - Data plug-ins */
  pixmap1 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask1, &transparent, (gchar**) TD_STOCK_LIST_DATABASE);
  pixmap2 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask2, &transparent, (gchar**) TD_STOCK_LIST_DATABASE);
  for (i=0; i<g_list_length (TD_APP (application)->mod_data); i++)
    {
      for (j=0; j<g_list_length (plugins_filelist); j++)
	if (!strcmp (TD_MOD (g_list_nth_data (TD_APP (application)->mod_data, i))->name_intl, TD_ABOUT (g_list_nth_data (plugins_list, j))->name))
	  break;
      txt[0] = TD_MOD (g_list_nth_data (TD_APP (application)->mod_data, i))->name_intl;
      txt[1] = (gchar*) g_list_nth_data (plugins_filelist, j);
      txt[2] = _("yes");
      node = gtk_ctree_insert_node (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), NULL, NULL, txt, 5, pixmap1, mask1, pixmap2, mask2, FALSE, FALSE);
    }

  /*** Greffons filtres - Filters plug-ins */
  pixmap1 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask1, &transparent, (gchar**) TD_STOCK_LIST_IMPORT_EXPORT);
  pixmap2 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask2, &transparent, (gchar**) TD_STOCK_LIST_IMPORT_EXPORT);
  for (i=0; i<g_list_length (TD_APP (application)->mod_filter); i++)
    {
      for (j=0; j<g_list_length (plugins_filelist); j++)
	if (!strcmp (TD_MOD (g_list_nth_data (TD_APP (application)->mod_filter, i))->name_intl, TD_ABOUT (g_list_nth_data (plugins_list, j))->name))
	  break;
      txt[0] = TD_ABOUT (g_list_nth_data (plugins_list, j))->name;
      txt[1] = (gchar*) g_list_nth_data (plugins_filelist, j);
      txt[2] = _("yes");
      node = gtk_ctree_insert_node (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), NULL, NULL, txt, 5, pixmap1, mask1, pixmap2, mask2, FALSE, FALSE);
    }
}
