/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : presto & faq
 * ToutDoux's plug-in : presto & faq
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "Presto",
		  "type", _("help"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("help"),
		  "category3", "presto",
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

GtkObject *mod_def (GtkObject *mod)
{
  GtkObject *ret;
  GtkObject *tree[2];

  GtkWidget *toolbar;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *button1;
  GtkWidget *menu1;
  gchar *txt_tmp;

  /*** Module */
  if (!strcmp (TD_MOD (mod)->name_intl, "(null)"))
    txt_tmp = "Presto";
  else
    txt_tmp = g_strdup_printf ("%s : Presto", TD_MOD (mod)->name_intl);
  ret = td_mod_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "presto",
		  "name_intl", txt_tmp,
		  "id", -1, NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def());

  /*** Barre d'outils - Tools barr */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  td_mod_set_window_toolbar (TD_MOD (ret), toolbar);
  radiobutton1 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), NULL, _("One-page informations"), "button_presto.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), ret);
  radiobutton2 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton1, _("Frequently asked questions"), "button_faq.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), ret);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button1 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Close"), "button_close.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (td_mod_hide), GTK_OBJECT (ret));

  /*** Presto */
  tree[0] = td_mod_stree_new();
  gtk_object_set (GTK_OBJECT (tree[0]), 
		  "name", _("One-page informations"),
		  "name_parent", "presto", NULL);
  td_mod_add_child (TD_MOD (ret), tree[0]);
  menu1 = gtk_menu_new();
  td_app_menu_std_new (menu1, ret);
  td_mod_stree_set_default_menu (TD_MOD_STREE (tree[0]), menu1);

  /*** Faq */
  tree[1] = td_mod_stree_new();
  gtk_object_set (GTK_OBJECT (tree[1]), 
		  "name", _("Frequently asked questions"),
		  "name_parent", "presto", NULL);
  td_mod_add_child (TD_MOD (ret), tree[1]);
  td_mod_stree_set_default_menu (TD_MOD_STREE (tree[1]), menu1);
  return ret;
}

void plugins_init (void)
{
}

void plugins_destroy (gpointer user_data)
{
}

void plugins_create (GtkObject *mod)
{
  td_app_message (NULL, _("Loading documentation"), TD_MSG_BEGIN);
  TD_MOD (mod)->presto_browser = mod_def (mod);
  td_mod_create (TD_MOD (TD_MOD (mod)->presto_browser));
  load (GTK_OBJECT (TD_MOD (mod)->presto_browser), mod);
  td_app_message (NULL, _("Loading documentation"), TD_MSG_END);
}

/*****************************************************************************/
/*** Barre d'outils - Tools barr */
/*****************************************************************************/
void radiobutton1_clicked (GtkRadioButton *radiobutton, GtkObject *mod)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 0);
}
void radiobutton2_clicked (GtkRadioButton *radiobutton, GtkObject *mod)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 1);
}


/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
void load (GtkObject *presto_browser, GtkObject *mod)
{
  GtkObject *flower[2];

  /*** Presto */
  flower[0] = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower[0]),
		  "root", "presto", 
		  "branch", "section",
		  "petal", "node",
		  "mode_one_column", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower[0]), "text");
  if (!td_flower_load_file (TD_FLOWER (flower[0]), g_strdup_printf("%s/share/%s/%s/presto-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, _("en"))))
    td_flower_load_file (TD_FLOWER (flower[0]), g_strdup_printf("%s/share/%s/%s/presto-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, "en"));
  td_mod_stree_load_flower (g_list_nth_data (TD_MOD (presto_browser)->child, 0), flower[0]);
  td_flower_destroy (TD_FLOWER (flower[0]));

  /*** Faq */
  flower[1] = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower[1]),
		  "root", "faq", 
		  "branch", "section",
		  "petal", "question",
		  "foliole", "reply",
		  "mode_one_column", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower[1]), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower[1]), "text");
  td_flower_add_foliole_attribut (TD_FLOWER (flower[1]), "text");
  if (!td_flower_load_file (TD_FLOWER (flower[1]), g_strdup_printf("%s/share/%s/%s/faq-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, _("en"))))
    td_flower_load_file (TD_FLOWER (flower[1]), g_strdup_printf("%s/share/%s/%s/faq-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, "en"));
  td_mod_stree_load_flower (g_list_nth_data (TD_MOD (presto_browser)->child, 1), flower[1]);
  td_flower_destroy (TD_FLOWER (flower[1]));
}
