/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux :  propos
 * ToutDoux's plug-in : about
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
GtkObject *mod;
GtkObject *flower[3];

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("About"),
		  "type", _("help"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("help"),
		  "category3", _("about"),
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

GtkObject *mod_def (void)
{
  GtkObject *ret;
  gchar *txt_tmp;

  GtkObject *box;
  GtkWidget *eventbox1;
  GtkWidget *viewport1;
  GtkWidget *vbox1;
  GtkWidget *pixmap;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *href;

  GtkObject *tree[3];
  GtkObject *field[3];

  GtkWidget *toolbar;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *radiobutton3;
  GtkWidget *radiobutton4;
  GtkWidget *button1;

  GtkWidget *menu1;
  td_app_message (NULL, _("Loading about"), TD_MSG_BEGIN);

  /*** Module */
  ret = td_mod_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "about",
		  "name_intl", _("About"),
		  "id", -1, NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def());

  /*** Barre d'outils - Tools barr */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  radiobutton1 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), NULL, _("About"), "button_about.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  radiobutton2 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton1, _("Authors"), "button_authors.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), NULL);
  radiobutton3 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton2, _("Thanks"), "button_thanks.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton3), "clicked", GTK_SIGNAL_FUNC (radiobutton3_clicked), NULL);
  radiobutton4 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton3, _("Supporters"), "button_supporters.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton4), "clicked", GTK_SIGNAL_FUNC (radiobutton4_clicked), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button1 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Close"), "button_close.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (td_mod_hide), GTK_OBJECT (ret));
  td_mod_set_window_toolbar (TD_MOD (ret), toolbar);

  /*** A propos - About */
  box = td_mod_box_new();
  gtk_object_set (GTK_OBJECT (box), "name", _("About"), NULL);
  td_mod_add_child (TD_MOD (ret), box);
  eventbox1 = gtk_event_box_new();
  gtk_widget_show (eventbox1);
  td_mod_box_set_widget (TD_MOD_BOX (box), eventbox1);
  vbox1 = gtk_vbox_new (FALSE, 2);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (eventbox1), vbox1);

  /*** Logo */
  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport1);
  gtk_widget_show (viewport1);
  gtk_box_pack_start (GTK_BOX (vbox1), viewport1, TRUE, TRUE, 0);
  pixmap = gtdk_pixmap_file (TD_ABOUT (TD_APP (APP)->about)->logo);
  gtk_widget_show (pixmap);
  gtk_container_add (GTK_CONTAINER (viewport1), pixmap);
  
  /*** Licence - License */
  txt_tmp = g_strdup_printf(_("Version %s ( %s ) - Copyright (c) 2000-2001 Philippe Roy"), TD_VERSION, TD_DATEVERSION);
  label1 = gtk_label_new (txt_tmp);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
  label2 = gtk_label_new (TD_ABOUT (TD_APP (APP)->about)->license);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);

  /*** Site web - Web site */
  href = gtdk_button_href (TD_ABOUT (TD_APP (APP)->about)->web, NULL);
  gtk_widget_show (href);
  gtk_box_pack_start (GTK_BOX (vbox1), href, FALSE, FALSE, 0);

  /*** Auteurs - Authors */
  tree[0] = td_mod_stree_new();
  gtk_object_set (GTK_OBJECT (tree[0]), 
		  "name", _("Authors"),
		  "name_parent", "about", NULL);
  td_mod_add_child (TD_MOD (ret), tree[0]);
  flower[0] = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower[0]),
		  "root", "authors", 
		  "branch", "section",
		  "petal", "author",
		  "foliole", "work",
		  "mode_one_column", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower[0]), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower[0]), "email");
  td_flower_add_foliole_attribut (TD_FLOWER (flower[0]), "name");
  if (!td_flower_load_file (TD_FLOWER (flower[0]), g_strdup_printf("%s/share/%s/app/authors-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"))))
    td_flower_load_file (TD_FLOWER (flower[0]), g_strdup_printf("%s/share/%s/app/authors-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, "en"));

  /*** Remerciements - Thanks */
  tree[1] = td_mod_stree_new();
  gtk_object_set (GTK_OBJECT (tree[1]), 
		  "name", _("Thanks"),
		  "name_parent", "about", NULL);
  td_mod_add_child (TD_MOD (ret), tree[1]);
  flower[1] = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower[1]), 
		  "root", "thanks", 
		  "branch", "user",
		  "mode_one_column", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower[1]), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower[1]), "email");
  if (!td_flower_load_file (TD_FLOWER (flower[1]), g_strdup_printf("%s/share/%s/app/thanks-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"))))
    td_flower_load_file (TD_FLOWER (flower[1]), g_strdup_printf("%s/share/%s/app/thanks-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, "en"));

  /*** Supporter */
  tree[2] = td_mod_stree_new();
  gtk_object_set (GTK_OBJECT (tree[2]), 
		  "name", _("Supporters"),
		  "name_parent", "about", NULL);
  td_mod_add_child (TD_MOD (ret), tree[2]);
  flower[2] = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower[2]), 
		  "root", "supporters", 
		  "branch", "supporter",
		  "mode_one_column", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "email");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "category");
  if (!td_flower_load_file (TD_FLOWER (flower[2]), g_strdup_printf("%s/share/%s/app/supporters-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"))))
    td_flower_load_file (TD_FLOWER (flower[2]), g_strdup_printf("%s/share/%s/app/supporters-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, "en"));
  return ret;
}

void plugins_init (void)
{
  if (!mod)
    {
      mod = mod_def();
      td_mod_create (TD_MOD (mod));
      td_mod_stree_load_flower (g_list_nth_data (TD_MOD (mod)->child, 1), flower[0]);
      td_mod_stree_load_flower (g_list_nth_data (TD_MOD (mod)->child, 2), flower[1]);
      td_mod_stree_load_flower (g_list_nth_data (TD_MOD (mod)->child, 3), flower[2]);
    }
  td_mod_show (TD_MOD (mod));
}

void plugins_destroy (gpointer user_data)
{
  td_mod_destroy (TD_MOD (mod));
  td_flower_destroy (TD_FLOWER (flower[0]));
  td_flower_destroy (TD_FLOWER (flower[1]));
  td_flower_destroy (TD_FLOWER (flower[2]));
}

void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 0);
}
void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 1);
}
void radiobutton3_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 2);
}
void radiobutton4_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 3);
}
