/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : messages
 * ToutDoux's plug-in : messages
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
GtkObject *mod;
GtkCTreeNode *node_current;

/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Messages"),
		  "type", _("dialog"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("dialog"),
		  "category3", _("messages"),
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

GtkObject *mod_def (void)
{
  GtkObject *ret;
  GtkObject *box[2];
  GtkWidget *scrolledwindow[2];
  GtkWidget *ctree[2];

  GtkWidget *toolbar;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *button1;

  /* Module */
  ret = td_mod_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "messages",
		  "name_intl", _("Messages"),
		  "id", -1, NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def());
  node_current = NULL;

  /* Barre d'outils */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  radiobutton1 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), NULL, _("Messages"), "button_messages.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), NULL);
  radiobutton2 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton1, _("Processes"), "button_server.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button1 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Close"), "button_close.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (td_mod_hide), GTK_OBJECT (ret));
  td_mod_set_window_toolbar (TD_MOD (ret), toolbar);

  /* Messages */
  box[0] = td_mod_box_new();
  gtk_object_set (GTK_OBJECT (box[0]), "name", _("Messages"), NULL);
  td_mod_add_child (TD_MOD (ret), box[0]);
  scrolledwindow[0] = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow[0]);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow[0]), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  td_mod_box_set_widget (TD_MOD_BOX (box[0]), scrolledwindow[0]);
  ctree[0] = gtk_ctree_new (2, 0);
  gtdk_clist_adjustheight (GTK_CLIST (ctree[0]));
  gtk_widget_show (ctree[0]);
  gtk_container_add (GTK_CONTAINER (scrolledwindow[0]), ctree[0]);
  gtk_clist_column_titles_show (GTK_CLIST (ctree[0]));
  td_mod_box_set_widget_data (TD_MOD_BOX (box[0]), ctree[0]);
  gtdk_clist_title (GTK_CLIST (ctree[0]), 0, _("Messages"), -1, GTK_JUSTIFY_CENTER);
  gtdk_clist_title (GTK_CLIST (ctree[0]), 1, _("Type"), -2, GTK_JUSTIFY_LEFT);
  gtk_signal_connect (GTK_OBJECT (ctree[0]), "button_press_event", GTK_SIGNAL_FUNC (td_mod_box_button_press), box[0]);

  /* Processus */
  box[1] = td_mod_box_new();
  gtk_object_set (GTK_OBJECT (box[1]), "name", _("Processes"), NULL);
  td_mod_add_child (TD_MOD (ret), box[1]);
  scrolledwindow[1] = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow[1]);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow[1]), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  td_mod_box_set_widget (TD_MOD_BOX (box[1]), scrolledwindow[1]);
  ctree[1] = gtk_ctree_new (4, 0);
  gtdk_clist_adjustheight (GTK_CLIST (ctree[1]));
  gtk_widget_show (ctree[1]);
  gtk_ctree_set_expander_style (GTK_CTREE (ctree[1]), GTK_CTREE_EXPANDER_NONE);
  gtk_ctree_set_line_style (GTK_CTREE (ctree[1]), GTK_CTREE_LINES_NONE);
  gtk_container_add (GTK_CONTAINER (scrolledwindow[1]), ctree[1]);
  gtk_clist_column_titles_show (GTK_CLIST (ctree[1]));
  td_mod_box_set_widget_data (TD_MOD_BOX (box[1]), ctree[1]);
  gtdk_clist_title (GTK_CLIST (ctree[1]), 0, _("PID"), -1, GTK_JUSTIFY_LEFT);
  gtdk_clist_title (GTK_CLIST (ctree[1]), 1, _("File"), -1, GTK_JUSTIFY_LEFT);
  gtdk_clist_title (GTK_CLIST (ctree[1]), 2, _("Command"), -1, GTK_JUSTIFY_LEFT);
  gtdk_clist_title (GTK_CLIST (ctree[1]), 3, _("Status"), -2, GTK_JUSTIFY_LEFT);
  gtk_signal_connect (GTK_OBJECT (ctree[1]), "button_press_event", GTK_SIGNAL_FUNC (td_mod_box_button_press), box[1]);
  return ret;
}

void plugins_init (void)
{
  int i;
  if (!mod)
    {
      mod = mod_def();
      td_mod_create (TD_MOD (mod));
      for (i=0; i<g_list_length (START_MSG); i++)
	{
	  plugins_new_message (g_list_nth_data (START_MSG, i), GPOINTER_TO_INT (g_list_nth_data (START_MSG, i+1)), g_list_nth_data (START_MSG, i+2));
	  i++;
	  i++;
	}
      START_MSG = NULL;
    }
  else
    td_mod_show (TD_MOD (mod));
}

void plugins_destroy (gpointer user_data)
{
  td_mod_destroy (TD_MOD (mod));
  mod = NULL;
}

void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 0);
}
void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 1);
}

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void plugins_new_message (gchar *message, TdMsg type, gchar *type_txt)
{
  GtkCTreeNode *node = NULL;
  gchar *txt[2];
  gchar *pixmap1_tmp = NULL;
  gchar *pixmap2_tmp = NULL;
  GdkPixmap *pixmap1 = NULL;
  GdkPixmap *pixmap2 = NULL;
  GdkBitmap *mask1 = NULL;
  GdkBitmap *mask2 = NULL;
  GdkColor transparent;
  if (!(TD_APP (APP)->palette))
    return;

  /* Valeurs */
  txt[0] = message;
  txt[1] = type_txt;

  /* Icones */
  switch (type)
    {
    case TD_MSG_DONE:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_OK;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_OK;
      break;
    case TD_MSG_TESTED:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_OK;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_OK;
      break;
    case TD_MSG_PLUGINS:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_PLUGINS;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_PLUGINS;
      break;
    case TD_MSG_COMMAND:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_COMMAND;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_COMMAND;
      break;
    case TD_MSG_SQL:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_DATABASE;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_DATABASE;
      break;
    case TD_MSG_SQL_CACHE:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_DATABASE_CACHE;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_DATABASE_CACHE;
      break;
    case TD_MSG_FUNCTION:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_FUNCTION;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_FUNCTION;
      break;
    case TD_MSG_FAILED:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_WARNING;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_WARNING;
      break;
    case TD_MSG_STOP:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_WARNING;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_WARNING;
      break;
    case TD_MSG_BEGIN:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_BOOKCLOSE;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_BOOKOPEN;
      break;
    case TD_MSG_MESSAGE:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_LIGHT;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_LIGHT;
      break;
    case TD_MSG_YES:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_YES;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_YES;
      break;
    case TD_MSG_NO:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_NO;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_NO;
      break;
    default:
      pixmap1_tmp = (gchar*) TD_STOCK_LIST_BOOKCLOSE;
      pixmap2_tmp = (gchar*) TD_STOCK_LIST_BOOKOPEN;
      break;
    }
  pixmap1 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask1, &transparent, (gchar**) pixmap1_tmp);
  pixmap2 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask2, &transparent, (gchar**) pixmap2_tmp);

  /* Node */
  if (mod)
    {
      if (type == TD_MSG_BEGIN)
	node_current = gtk_ctree_insert_node (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0))->widget_data), node_current, NULL, txt, 5, pixmap1, mask1, pixmap2, mask2, FALSE, FALSE);
      else
	{
	  if (type == TD_MSG_END)
	    {
	      if (node_current)
		{
		  if (GTK_CTREE_ROW (node_current)->parent)
		    node_current = GTK_CTREE_ROW (node_current)->parent;
		  else
		    node_current = NULL;
		}
	    }
	  else
	    node = gtk_ctree_insert_node (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0))->widget_data), node_current, NULL, txt, 5, pixmap1, mask1, pixmap2, mask2, FALSE, FALSE);
	  if (type == TD_MSG_FAILED)
	    gtdk_ctree_invert_expand_recursive (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0))->widget_data), node);
	}
    }
}

void plugins_update_process (GtkObject *process)
{
  int i,j;
  gchar *txt[4];
  gchar *txt_tmp;
  gchar *value_tmp;
  GtkCTreeNode *node = NULL;
  GdkPixmap *pixmap1 = NULL;
  GdkPixmap *pixmap2 = NULL;
  GdkBitmap *mask1 = NULL;
  GdkBitmap *mask2 = NULL;
  GdkColor transparent;
  gboolean leaf;
  gboolean expanded;
  guint8 spacing;

  /* Cration */
  if (TD_APP_PROCESS (process)->status)
    {
      txt[0] = g_strdup_printf ("%d", TD_APP_PROCESS (process)->pid);
      txt[1] = TD_APP_PROCESS (process)->file;
      txt[2] = TD_APP_PROCESS (process)->command;
      txt[3] = _("Active");
      pixmap1 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask1, &transparent, (gchar**) TD_STOCK_LIST_COMMAND);
      pixmap2 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask2, &transparent, (gchar**) TD_STOCK_LIST_COMMAND);
      node = gtk_ctree_insert_node (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), NULL, NULL, txt, 5, pixmap1, mask1, pixmap2, mask2, FALSE, FALSE);
      return;
    }

  /* Suppression */
  if (!TD_APP_PROCESS (process)->status)
    {
      node = gtk_ctree_node_nth (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), 0);
      while (node)
	{
	  gtk_ctree_node_get_text (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), node, 1, &txt_tmp);
	  if (!strcmp (txt_tmp, TD_APP_PROCESS (process)->file))
	    break;
	  node = gtdk_ctree_next (node);
	}
      if (node)
	{
	  gtk_ctree_get_node_info (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), node, &value_tmp, &spacing, &pixmap1, &pixmap2, &mask1, &mask2, &leaf, &expanded);
	  pixmap1 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask1, &transparent, (gchar**) TD_STOCK_LIST_EMPTY);
	  pixmap2 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask2, &transparent, (gchar**) TD_STOCK_LIST_EMPTY);
	  GTK_CTREE_ROW (node)->pixmap_closed = pixmap1;
	  GTK_CTREE_ROW (node)->mask_closed = mask1;
	  GTK_CTREE_ROW (node)->pixmap_opened = pixmap2;
	  GTK_CTREE_ROW (node)->mask_opened = mask2;
	  gtk_ctree_node_set_pixtext (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), node, 0, g_strdup_printf ("%d", TD_APP_PROCESS (process)->pid), spacing, pixmap1, mask1);
	  gtk_ctree_node_set_text (GTK_CTREE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), node, 3, _("Killed"));
	}
    }
}
