/*****************************************************************************/
/* main.c : Module principal et ligne de commande
 * main.c : Main module and command line
 *
 *
 * TouxDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <locale.h>
#include <dlfcn.h>
#include <toutdoux.h>

#include "main.h"
#include "configuration.h"

/*****************************************************************************/
/*** Menu Principal - Main menu */
/*** FIXME: gnration des menus par fichier XML : +tards - Generating menu by XML : this night */
/*****************************************************************************/
static GnomeUIInfo menu_main_help_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Customize"), NULL,
   customize_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_CUSTOMIZE, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Bookmarks"), NULL,
   bookmarks_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_FAVORITES, 'b', GDK_MOD1_MASK, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Presto"), NULL,
   presto_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_LIGHT, 0xFFBE, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("User's manual"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_MANUAL, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Plug-ins browser"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_PLUGINS, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("About"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_main_import_export_uiinfo[] =
{
  GNOMEUIINFO_END
};            	

static GnomeUIInfo menu_main_template_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create template"), NULL,
   td_db_connect_close, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_BUILD, 'n', GDK_CONTROL_MASK, NULL},
  {GNOME_APP_UI_ITEM, N_("Open template..."), NULL,
   td_db_connect_load, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_END
};            	

static GnomeUIInfo menu_main_file_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Save"), NULL,
   td_db_connect_save, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 's', GDK_CONTROL_MASK, NULL},
  {GNOME_APP_UI_ITEM, N_("Save as..."), NULL,
   td_db_connect_save, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Quit"), NULL,
   quit_toutdoux, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 'q', GDK_CONTROL_MASK, NULL},
  GNOMEUIINFO_END
};            	

static GnomeUIInfo menu_main_dialog_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Bench"), NULL,
   bench_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_BENCH, 'w', GDK_MOD1_MASK, NULL},
  {GNOME_APP_UI_ITEM, N_("Etabliste"), NULL,
   etabliste_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_BENCH, 'l', GDK_MOD1_MASK, NULL},
/*    {GNOME_APP_UI_ITEM, N_("Editor"), NULL, */
/*     td_app_menu_activate, NULL, NULL, */
/*     GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_EDITOR, 'e', GDK_MOD1_MASK, NULL}, */
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Messages"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_MESSAGES, 'm', GDK_MOD1_MASK, NULL},
  GNOMEUIINFO_END
};            	

static GnomeUIInfo menu_main_tools_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Edit template"), NULL,
   cogitation_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_BUILD, 't', GDK_MOD1_MASK, NULL},
  {GNOME_APP_UI_ITEM, N_("SQL console"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_CONSOLE, 'q', GDK_MOD1_MASK, NULL},
/*    {GNOME_APP_UI_ITEM, N_("Manage database"), NULL, */
/*     td_app_menu_activate, NULL, NULL, */
/*     GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_DATABASE, 0, 0, NULL}, */
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_main_debug_uiinfo[] =
{
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_main_uiinfo[] =
{
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_main_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Tools"), NULL,
   menu_main_tools_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_TOOLS, 0, 0, NULL},
  {GNOME_APP_UI_SUBTREE, N_("Dialogs"), NULL,
   menu_main_dialog_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_BENCH, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Debug"), NULL,
   menu_main_debug_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_DEBUG, 0, 0, NULL},
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_main_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_HELP, 0, 0, NULL},
  GNOMEUIINFO_END
};

/*****************************************************************************/
/*** Dfinition - Definition */
/*****************************************************************************/
GtkObject *app_def (void)
{
  GtkObject *ret;
  GtkObject *about;
  GtkObject *admin_field[2];
  GtkObject *palette;
  GtkObject *bench;
  GtkObject *etabliste;
  GtkObject *message;
  GtkObject *message_mod;
  GtkObject *message_mod_tree;
  GtkObject *field[2];
  GtkObject *menu[11];
  GtkObject *icon[10];
  GtkObject *icon_equal[10];
  void (*symbol)();

  GtkAccelGroup *accel_group;
  GtkWidget *menu1;
  GtkWidget *menu1_item[7];
  GtkWidget *menu2;
  GtkWidget *menu2_item[8];
  GtkWidget *menu3;
  GtkWidget *menu3_item[9];
  GtkWidget *menu4_item;
  int echo_mode;

  /*** Application */
  TD_FLAG_DEBUG_MODE = mode_debug_popt;
  ret = td_app_new();
  echo_mode = td_app_mode_echo_parse (td_app_custom_value ("development", "terminal", "echo"));
  if (mode_nocolor_popt)
    {
      if (echo_mode == TD_MODE_ECHO_ALL_COLORS)
	echo_mode = TD_MODE_ECHO_ALL_BW;
      else
	echo_mode = TD_MODE_ECHO_BW;
    }
  if (mode_debug_popt)
    {
      if ((echo_mode == TD_MODE_ECHO_COLORS) || (echo_mode == TD_MODE_ECHO_NO))
	echo_mode = TD_MODE_ECHO_ALL_COLORS;
      else
	echo_mode = TD_MODE_ECHO_ALL_BW;
    }
  gtk_object_set (GTK_OBJECT (ret), "mode_echo", echo_mode, NULL);

  /*** A propos - About */
  about = td_about_new();
  gtk_object_set (GTK_OBJECT (about), 
		  "name", TD_PACKAGE,
		  "version", g_strdup_printf("%s (%s)", TD_VERSION, TD_DATEVERSION),
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("ToutDoux is a free software, covered by the GNU General Public License."),
		  "logo", g_strdup_printf("%s/share/pixmaps/%s/logo.png", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR),
		  "web", "http://www.toutdoux.org", NULL);
  td_app_set_about (TD_APP (ret), about);

  /*** Menu gnral - Main menu */
  accel_group = gtk_accel_group_new();
  td_app_set_accel_group (TD_APP (ret), accel_group);
  td_app_set_menu_main (TD_APP (ret), menu_main_uiinfo);

  /*** Modules chargeables sur menu - Modules loaded by menu */
  menu[1] = td_app_menu_new();
  gtk_object_set (GTK_OBJECT (menu[1]),
		  "type", "module",
		  "path", g_strdup_printf ("%s/%s", _("Help"), _("About")),
		  "file", "libhelp_about.so",
		  "symbol", "plugins_init", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[1]);

  menu[2] = td_app_menu_new();
  gtk_object_set (GTK_OBJECT (menu[2]),
		  "type", "module",
		  "path", g_strdup_printf ("%s/%s", _("Help"), _("Plug-ins details")),
		  "file", "libhelp_xts.so",
		  "symbol", "plugins_init", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[2]);

  menu[3] = td_app_menu_new();
  gtk_object_set (GTK_OBJECT (menu[3]),
		  "type", "module",
		  "path", g_strdup_printf ("%s/%s", _("Tools"), _("Manage database")),
		  "file", "libcommunication_db.so",
		  "symbol", "plugins_init", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[3]);

  menu[4] = td_app_menu_new();
  gtk_object_set (GTK_OBJECT (menu[4]),
		  "type", "manual",
		  "path", g_strdup_printf ("%s/%s", _("Help"), _("User's manual")),
		  "file", g_strdup_printf ("index.html"), NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[4]);

  menu[5] = td_app_menu_new();
  gtk_object_set (GTK_OBJECT (menu[5]),
		  "type", "module",
		  "path", g_strdup_printf ("%s/%s", _("Tools"), _("Messages")),
		  "file", "libdialog_messages.so",
		  "symbol", "plugins_init", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[5]);
  menu[6] = td_app_menu_new();
  gtk_object_set (GTK_OBJECT (menu[6]),
		  "type", "module",
		  "path", g_strdup_printf ("%s/%s", _("Dialogs"), _("Messages")),
		  "file", "libdialog_messages.so",
		  "symbol", "plugins_init", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[6]);

  menu[7] = td_app_menu_new();
  gtk_object_set (GTK_OBJECT (menu[7]),
		  "type", "module",
		  "path", g_strdup_printf ("%s/%s", _("Tools"), _("Editor")),
		  "file", "libdialog_editor.so",
		  "symbol", "plugins_init", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[7]);
  menu[8] = td_app_menu_new();
  gtk_object_set (GTK_OBJECT (menu[8]),
		  "type", "module",
		  "path", g_strdup_printf ("%s/%s", _("Dialogs"), _("Editor")),
		  "file", "libdialog_editor.so",
		  "symbol", "plugins_init", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[8]);

  menu[9] = td_app_menu_new();
  gtk_object_set (GTK_OBJECT (menu[9]),
		  "type", "module",
		  "path", g_strdup_printf ("%s/%s", _("Tools"), _("SQL console")),
		  "file", "libtools_query.so",
		  "symbol", "plugins_init", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[9]);
  menu[10] = td_app_menu_new();
  gtk_object_set (GTK_OBJECT (menu[10]),
		  "type", "module",
		  "path", g_strdup_printf ("%s/%s", _("Tools"), _("SQL console")),
		  "file", "libtools_query.so",
		  "symbol", "plugins_init", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[10]);

  /*** Palette */
  /*** FIXME: gnration des menus par fichier XML : +tards - Generating menu by XML : this night */
  palette = td_app_palette_new();
  td_app_set_palette (TD_APP (ret), palette);
  td_app_set_menu_palette (TD_APP (ret), gtk_menu_bar_new());
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE_BOOKMARKS, NULL, "libhelp_bookmarks.so", "plugins_start", TRUE);
  symbol (TD_APP (ret));

  /*** Menu fichier - Menu file */
  menu1_item[0] = gtk_menu_item_new_with_label (_("File"));
  gtk_widget_show (menu1_item[0]);
  gtk_menu_bar_append (GTK_MENU_BAR (TD_APP (ret)->menu_palette), menu1_item[0]);
  menu1 = gtk_menu_new();
  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (menu1_item[0]), menu1);

  /*** Sous-menu nouveau - Submenu new */
  menu1_item[1] = gtdk_menu_item_new (_("New"), NULL, "list_new.xpm");
  gtk_menu_append (GTK_MENU (menu1), menu1_item[1]);
  td_app_set_menu_templates (TD_APP (ret), menu1_item[1]);
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE_BOOKMARKS, NULL, "libhelp_bookmarks.so", "plugins_menu_def_templates", TRUE);
  symbol (menu1_item[1], accel_group);
  menu1_item[6] = gtdk_menu_item_new (NULL, NULL, NULL);
  gtk_menu_append (GTK_MENU (menu1), menu1_item[6]);

  /*** Sous-menu ouvrir - Submenu open */
  menu1_item[2] = gtdk_menu_item_new (_("Open"), NULL, "list_open.xpm");
  gtk_menu_append (GTK_MENU (menu1), menu1_item[2]);
  td_app_set_menu_history (TD_APP (ret), menu1_item[2]);
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE_BOOKMARKS, NULL, "libhelp_bookmarks.so", "plugins_menu_def_history", TRUE);
  symbol (menu1_item[2], accel_group);

  /*** Sous-menu favoris  - Submenu favorites */
  menu1_item[3] = gtdk_menu_item_new (_("Favorites"), NULL, "list_favorites2.xpm");
  gtk_menu_append (GTK_MENU (menu1), menu1_item[3]);
  td_app_set_menu_favorites (TD_APP (ret), menu1_item[3]);
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE_BOOKMARKS, NULL, "libhelp_bookmarks.so", "plugins_menu_def_favorites", TRUE);
  symbol (menu1_item[3], accel_group);

  /*** Quitter - Quit */
  menu1_item[4] = gtdk_menu_item_new (NULL, NULL, NULL);
  gtk_menu_append (GTK_MENU (menu1), menu1_item[4]);
  menu1_item[5] = gtdk_menu_item_accel_new (_("Quit"), NULL, "list_quit.xpm", accel_group, GDK_Q, GDK_CONTROL_MASK);
  gtk_menu_append (GTK_MENU (menu1), menu1_item[5]);
  gtk_signal_connect (GTK_OBJECT (menu1_item[5]), "activate", GTK_SIGNAL_FUNC (quit_toutdoux), NULL);

  /*** Menu outils - Menu tools */
  menu2_item[0] = gtk_menu_item_new_with_label (_("Tools"));
  gtk_widget_show (menu2_item[0]);
  gtk_menu_bar_append (GTK_MENU_BAR (TD_APP (ret)->menu_palette), menu2_item[0]);
  menu2 = gtk_menu_new();
  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (menu2_item[0]), menu2);

  menu2_item[1] = gtdk_menu_item_accel_new (_("Edit template"), NULL, "list_build.xpm", accel_group, GDK_T, GDK_MOD1_MASK);
  gtk_signal_connect (GTK_OBJECT (menu2_item[1]), "activate", GTK_SIGNAL_FUNC (cogitation_show), NULL);
  gtk_menu_append (GTK_MENU (menu2), menu2_item[1]);
  menu2_item[2] = gtdk_menu_item_accel_new (_("SQL console"), NULL, "list_console.xpm", accel_group, GDK_Q, GDK_MOD1_MASK);
  gtk_signal_connect (GTK_OBJECT (menu2_item[2]), "activate", GTK_SIGNAL_FUNC (td_app_menu_gtk_activate), g_strdup_printf ("%s/%s", _("Tools"), _("SQL console")));
  gtk_menu_append (GTK_MENU (menu2), menu2_item[2]);
  /*  menu2_item[2] = gtdk_menu_item_new (_("Manage database"), NULL, "list_database.xpm"); */
/*    gtk_signal_connect (GTK_OBJECT (menu2_item[2]), "activate", GTK_SIGNAL_FUNC (td_app_menu_gtk_activate), g_strdup_printf ("%s/%s", _("Tools"), _("Manage database"))); */
/*    gtk_menu_append (GTK_MENU (menu2), menu2_item[2]); */
  menu2_item[3] = gtdk_menu_item_new (NULL, NULL, NULL);
  gtk_menu_append (GTK_MENU (menu2), menu2_item[3]);

  menu2_item[4] = gtdk_menu_item_accel_new (_("Bench"), NULL, "list_bench.xpm", accel_group, GDK_W, GDK_MOD1_MASK);
  gtk_signal_connect (GTK_OBJECT (menu2_item[4]), "activate", GTK_SIGNAL_FUNC (bench_show), NULL);
  gtk_menu_append (GTK_MENU (menu2), menu2_item[4]);
  menu2_item[6] = gtdk_menu_item_accel_new (_("Etabliste"), NULL, "list_bench.xpm", accel_group, GDK_L, GDK_MOD1_MASK);
  gtk_signal_connect (GTK_OBJECT (menu2_item[6]), "activate", GTK_SIGNAL_FUNC (etabliste_show), NULL);
  gtk_menu_append (GTK_MENU (menu2), menu2_item[6]);

/*    menu2_item[6] = gtdk_menu_item_accel_new (_("Editor"), NULL, "list_editor.xpm", accel_group, GDK_E, GDK_MOD1_MASK); */
/*    gtk_signal_connect (GTK_OBJECT (menu2_item[6]), "activate", GTK_SIGNAL_FUNC (td_app_menu_gtk_activate), g_strdup_printf ("%s/%s", _("Tools"), _("Editor"))); */
/*    gtk_menu_append (GTK_MENU (menu2), menu2_item[6]); */
  menu2_item[7] = gtdk_menu_item_new (NULL, NULL, NULL);
  gtk_menu_append (GTK_MENU (menu2), menu2_item[7]);

  menu2_item[5] = gtdk_menu_item_accel_new (_("Messages"), NULL, "list_messages.xpm", accel_group, GDK_M, GDK_MOD1_MASK);
  gtk_signal_connect (GTK_OBJECT (menu2_item[5]), "activate", GTK_SIGNAL_FUNC (td_app_menu_gtk_activate), g_strdup_printf ("%s/%s", _("Tools"), _("Messages")));
  gtk_menu_append (GTK_MENU (menu2), menu2_item[5]);

  /*** Menu aide - Menu help */
  menu3_item[0] = gtk_menu_item_new_with_label (_("Help"));
  gtk_widget_show (menu3_item[0]);
  gtk_menu_bar_append (GTK_MENU_BAR (TD_APP (ret)->menu_palette), menu3_item[0]);
  menu3 = gtk_menu_new();
  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (menu3_item[0]), menu3);

  menu3_item[1] = gtdk_menu_item_new (_("Customize"), NULL, "list_customize.xpm");
  gtk_signal_connect (GTK_OBJECT (menu3_item[1]), "activate", GTK_SIGNAL_FUNC (customize_show), NULL);
  gtk_menu_append (GTK_MENU (menu3), menu3_item[1]);
  menu3_item[2] = gtdk_menu_item_accel_new (_("Bookmarks"), NULL, "list_favorites2.xpm", accel_group, GDK_B, GDK_MOD1_MASK);
  gtk_signal_connect (GTK_OBJECT (menu3_item[2]), "activate", GTK_SIGNAL_FUNC (bookmarks_show), NULL);
  gtk_menu_append (GTK_MENU (menu3), menu3_item[2]);
  menu3_item[3] = gtdk_menu_item_new (NULL, NULL, NULL);
  gtk_menu_append (GTK_MENU (menu3), menu3_item[3]);

  menu3_item[6] = gtdk_menu_item_accel_new (_("Presto"), NULL, "list_presto.xpm", accel_group, 0xFFBE, 0);
  gtk_signal_connect (GTK_OBJECT (menu3_item[6]), "activate", GTK_SIGNAL_FUNC (presto_show), NULL);
  gtk_menu_append (GTK_MENU (menu3), menu3_item[6]);
  menu3_item[4] = gtdk_menu_item_new (_("User's manual"), NULL, "list_manual.xpm");
  gtk_signal_connect (GTK_OBJECT (menu3_item[4]), "activate", GTK_SIGNAL_FUNC (td_app_menu_gtk_activate), g_strdup_printf ("%s/%s", _("Help"), _("User's manual")));
  gtk_menu_append (GTK_MENU (menu3), menu3_item[4]);
  menu3_item[5] = gtdk_menu_item_new (NULL, NULL, NULL);
  gtk_menu_append (GTK_MENU (menu3), menu3_item[5]);

  menu3_item[7] = gtdk_menu_item_new (_("Plug-ins details"), NULL, "list_plugins.xpm");
  gtk_signal_connect (GTK_OBJECT (menu3_item[7]), "activate", GTK_SIGNAL_FUNC (td_app_menu_gtk_activate), g_strdup_printf ("%s/%s", _("Help"), _("Plug-ins details")));
  gtk_menu_append (GTK_MENU (menu3), menu3_item[7]);
  menu3_item[8] = gtdk_menu_item_new (_("About"), NULL, "list_about.xpm");
  gtk_signal_connect (GTK_OBJECT (menu3_item[8]), "activate", GTK_SIGNAL_FUNC (td_app_menu_gtk_activate), g_strdup_printf ("%s/%s", _("Help"), _("About")));
  gtk_menu_append (GTK_MENU (menu3), menu3_item[8]);

  /*** Etablis - Benchs */
  bench = td_app_bench_new();
  td_app_set_bench (TD_APP (ret), bench);
  etabliste = td_app_etabliste_new();
  td_app_set_etabliste (TD_APP (ret), etabliste);

  return ret;
}

/*****************************************************************************/
/*** Popt */
/*****************************************************************************/
gchar *file_popt;
gboolean mode_debug_popt;
gboolean mode_build_popt;
gboolean mode_nocolor_popt;
const char **arguments = NULL;
poptContext pctx;
const struct poptOption parametres[] ={
  {
    "file", 'f', POPT_ARG_STRING, &file_popt, 0, N_("Specify the file (optional)"), N_("FILE"),
  },
  {
    "build", 'b', POPT_ARG_NONE, &mode_build_popt, 0, N_("build mode"), NULL
  },
  {
    "debug", 'd', POPT_ARG_NONE, &mode_debug_popt, 0, N_("debug mode: verbose, show all widgets and disable recovery"), NULL
  },
  {
    "nocolor", 0, POPT_ARG_NONE, &mode_nocolor_popt, 0, N_("no colors mode"), NULL
  },
  {
    NULL, '\0', 0, NULL, 0, NULL, NULL
  }
};

/*****************************************************************************/
/*** Principal - Main */
/*****************************************************************************/
int main (int argc, char *argv[])
{
  GtkObject *connect;
  void (*symbol)();

  /*** Internationalisation - Internationalization */
  setlocale (LC_ALL, "");
  bindtextdomain (TD_PACKAGE, TD_PACKAGE_LOCALE_DIR);
  textdomain (TD_PACKAGE);

  /*** Initialisation - Initialization */
  gnome_init_with_popt_table (TD_PACKAGE, TD_VERSION, argc, argv, parametres, 0, &pctx);
  arguments = poptGetArgs (pctx);
  xmlKeepBlanksDefault(0);
  td_init();
  correction();

  /*** Interface de base de donnes locale - Locale database interface */
  if (!strcmp (td_app_custom_value ("database", "backend", "database management system"), "mysql"))
    PLUGINS_CORE_DATABASE = dlopen (g_strdup_printf ("%s%s", TD_PACKAGE_PLUGINS_DIR, "libdatabase_mysql.so"), RTLD_LAZY);
  else
    PLUGINS_CORE_DATABASE = dlopen (g_strdup_printf ("%s%s", TD_PACKAGE_PLUGINS_DIR, "libdatabase_postgresql.so"), RTLD_LAZY);
  (gpointer*) symbol = dlsym (PLUGINS_CORE_DATABASE, "plugins_init");
  symbol();

  /*** Dmarrage - Starting */
  td_app_message (NULL, _("Starting"), TD_MSG_BEGIN);
  configuration_general();
  APP = app_def();
  td_app_create (TD_APP (APP));
  td_app_message (g_strdup_printf ("%s...", _("Starting")), NULL, TD_MSG_MESSAGE);
  TD_FLAG_NO_REFRESH_PALLETTE_MESSAGE = TRUE;
  configuration_file();
  configuration_face();
  app_mod_core_def();
  TD_FLAG_NO_REFRESH_PALLETTE_MESSAGE = FALSE;
  td_app_message (NULL, _("Starting"), TD_MSG_END);

  /*** Fichier - File */
  /*** FIXME: ajouter URL et base de donnes : +tards - add URL and database : this night */
  if (TD_DB_CONNECT (TD_APP (APP)->connect)->type == TD_CONNECT_TYPE_NONE)
    {
      if ((!file_popt) && (argc>1) && (argv[1][0] != '-'))
	file_popt = g_strdup_printf ("%s", argv[1]);
      /*** FIXME: fichier de dmarrage : +tards - startup file this night */
      /* if ((!file_popt) && (!strcmp (td_app_custom_value ("file", "startup", "file"), "last file"))) */
      /* file_popt = TD_CUSTOM_FILE_STARTUP; */
      if (file_popt)
	{
	  gtk_object_set (GTK_OBJECT (TD_APP (APP)->connect),
			  "name", file_popt,
			  "file", file_popt, NULL);
	  td_db_connect_set_type (TD_DB_CONNECT (TD_APP (APP)->connect), TD_CONNECT_TYPE_FILE);
	}
    }
  if (TD_DB_CONNECT (TD_APP (APP)->connect)->type != TD_CONNECT_TYPE_NONE)
    td_db_connect_load (NULL, TD_APP (APP)->connect);

  /*** Boucle - Loop */
  gtk_main();
  return 0;
}

/*****************************************************************************/
/*** Menu */
/*** FIXME: Virer les menus GNOME pour ceux de GTK+ : +tards - Remove Gnome menu for GTK+ object : this night */
/*****************************************************************************/
void bench_show (void)
{
  td_app_bench_show (TD_APP_BENCH (TD_APP (APP)->bench));
}

void etabliste_show (void)
{
  td_app_etabliste_show (TD_APP_ETABLISTE (TD_APP (APP)->etabliste));
}

void quit_toutdoux (void)
{
  td_app_quit (TD_APP (APP));
}

void cogitation_show (void)
{
  int i;
  gboolean bool_tmp;

  /*** Recherche du module - Searching module */
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_APP (APP)->mod_data); i++)
    if (!strcmp (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, i))->name, "cogitation"))
      {
	bool_tmp = TRUE;
	break;
      }
  if (!bool_tmp)
    {
      td_app_message (NULL, _("Starting cogitation"), TD_MSG_BEGIN);
      td_app_message (g_strdup_printf ("%s...", _("Starting cogitation")), NULL, TD_MSG_MESSAGE);
      TD_FLAG_NO_REFRESH_PALLETTE_MESSAGE = TRUE;
      if (!td_app_add_mod_data (TD_APP (APP), NULL, "libcogitation.so"))
	td_app_message (_("Starting cogitation"), _("Starting cogitation : Module not complete"), TD_MSG_STOP);
      td_app_bench_add_mod (TD_APP_BENCH (TD_APP (APP)->bench), g_list_nth_data (TD_APP (APP)->mod_data, i));
      TD_FLAG_NO_REFRESH_PALLETTE_MESSAGE = FALSE;
      td_app_message (NULL, _("Starting cogitation"), TD_MSG_END);
    }

  /*** Go ! */
  td_mod_show (g_list_nth_data (TD_APP(APP)->mod_data, i));
}

void bookmarks_show (void)
{
  int i;
  gboolean bool_tmp;

  /*** Recherche du module - Searching module */
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_APP (APP)->mod_data); i++)
    if (!strcmp (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, i))->name, "help_bookmarks"))
      {
	bool_tmp = TRUE;
	break;
      }
  if (!bool_tmp)
    {
      td_app_message (NULL, _("Starting bookmarks"), TD_MSG_BEGIN);
      td_app_message (g_strdup_printf ("%s...", _("Starting bookmarks")), NULL, TD_MSG_MESSAGE);
      TD_FLAG_NO_REFRESH_PALLETTE_MESSAGE = TRUE;
      if (!td_app_add_mod_data (TD_APP (APP), NULL, "libhelp_bookmarks.so"))
	td_app_message (_("Starting bookmarks"), _("Starting bookmarks : Module not complete"), TD_MSG_STOP);
      td_app_bench_add_mod (TD_APP_BENCH (TD_APP (APP)->bench), g_list_nth_data (TD_APP (APP)->mod_data, i));
      TD_FLAG_NO_REFRESH_PALLETTE_MESSAGE = FALSE;
      td_app_message (NULL, _("Starting bookmarks"), TD_MSG_END);
    }

  /*** Go ! */
  td_mod_show (g_list_nth_data (TD_APP (APP)->mod_data, i));
}

void communication_db_show (void)
{
  td_app_mod_core_activate (TD_APP (APP), NULL, "libcommunication_db.so", "plugins_show", TRUE);
}

void customize_show (void)
{
  td_app_custom_show (TD_APP (APP));
}

void presto_show (void)
{
  td_app_presto_show (TD_APP (APP));
}

/*****************************************************************************/
/*** Modules noyaux - Core modules */
/*****************************************************************************/
void app_mod_core_def (void)
{
  void (*symbol)();

  /*** Interface de base de donnes locale - Locale database interface */
/*    if (!strcmp (td_app_custom_value ("database", "backend", "database management system"), "mysql")) */
/*      PLUGINS_CORE_DATABASE = dlopen (g_strdup_printf ("%s%s", TD_PACKAGE_PLUGINS_DIR, "libdatabase_mysql.so"), RTLD_LAZY); */
/*    else */
/*      PLUGINS_CORE_DATABASE = dlopen (g_strdup_printf ("%s%s", TD_PACKAGE_PLUGINS_DIR, "libdatabase_postgresql.so"), RTLD_LAZY); */
/*    (gpointer*) symbol = dlsym (PLUGINS_CORE_DATABASE, "plugins_init"); */
/*    symbol(); */

  /*** Greffon des messages - Messages plus-in */
  PLUGINS_CORE_MESSAGES = dlopen (g_strdup_printf ("%s%s", TD_PACKAGE_PLUGINS_DIR, "libdialog_messages.so"), RTLD_LAZY);
  (gpointer*) symbol = dlsym (PLUGINS_CORE_MESSAGES, "plugins_init");
  symbol();

  /*** Autres greffons - Others plus-ins */
  td_app_add_mod_core (NULL, NULL, "libcommunication_url.so"); /*** Commnunication URL : PLUGINS_CORE[0] */
  td_app_add_mod_core (NULL, NULL, "libhelp_customize.so"); /*** Personalisation -  Customize : PLUGINS_CORE[1] */
  td_app_add_mod_core (NULL, NULL, "libhelp_doc.so"); /*** Presto : PLUGINS_CORE[2] */
}
