/*****************************************************************************/
/* td_mod_tree_icon.c : Objet Gtk+
 * td_mod_tree_icon.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "td_mod_tree_icon.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_mod_tree_icon_init (TdModTreeIcon *mod_tree_icon)
{
  mod_tree_icon->pixmap1 = NULL;
  mod_tree_icon->pixmap2 = NULL;
  mod_tree_icon->equal = NULL;
}

static void td_mod_tree_icon_class_init (TdModTreeIconClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  klass->set = td_mod_tree_icon_set;
  klass->add_equal = td_mod_tree_icon_add_equal;
}

GtkType td_mod_tree_icon_get_type (void)
{
  static GtkType mod_tree_icon_type = 0;
  if (!mod_tree_icon_type)
    {
      static const GtkTypeInfo mod_tree_icon_info =
      {
  	"TdModTreeIcon", sizeof (TdModTreeIcon), sizeof (TdModTreeIconClass),
  	(GtkClassInitFunc) td_mod_tree_icon_class_init,
	(GtkObjectInitFunc) td_mod_tree_icon_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_tree_icon_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_tree_icon_info);
    }
  return mod_tree_icon_type;
}

GtkObject *td_mod_tree_icon_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_tree_icon_get_type ()));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_mod_tree_icon_set (TdModTreeIcon *mod_tree_icon, gchar *pixmap1, gchar *pixmap2)
{
  g_return_if_fail (mod_tree_icon != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_ICON (mod_tree_icon));
  if (mod_tree_icon->pixmap1 != pixmap1)
    mod_tree_icon->pixmap1 = pixmap1;
  if (mod_tree_icon->pixmap2 != pixmap2)
    mod_tree_icon->pixmap2 = pixmap2;
}

void td_mod_tree_icon_add_equal (TdModTreeIcon *mod_tree_icon, GtkObject *equal)
{
  g_return_if_fail (mod_tree_icon != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_ICON (mod_tree_icon));
  mod_tree_icon->equal = g_list_append (mod_tree_icon->equal, equal);
}

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
