/*****************************************************************************/
/* td_mod_tree.h : Objet Gtk+
 * td_mod_tree.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_TREE (td_mod_tree_get_type ())
#define TD_MOD_TREE(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_TREE, TdModTree))
#define TD_MOD_TREE_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_TREE, TdModTreeClass))
#define TD_IS_MOD_TREE(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_TREE))
#define TD_IS_MOD_TREE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_TREE))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdModTree TdModTree;
typedef struct _TdModTreeClass TdModTreeClass;

struct _TdModTree
{
  GtkObject object;
  gchar *name;
  int id;
  int idparent;
  GtkWidget *label;
  GtkWidget *widget;
  GtkCTreeNode *selected;
  GList *field;
  GList *icon;
  GtkWidget *default_menu;
  GList *menu;
  GList *property;
  gboolean reorderable;
  gboolean column_auto_resize;
  gboolean customize;
};

struct _TdModTreeClass
{
  GtkObjectClass parent_class;
  void (*add_field) (TdModTree *mod_tree, GtkObject *field);
  void (*add_icon) (TdModTree *mod_tree, GtkObject *icon);
  void (*set_default_menu) (TdModTree *mod_tree, GtkWidget *menu);
  void (*add_menu) (TdModTree *mod_tree, GtkObject *menu);
  void (*add_property) (TdModTree *mod_tree, GtkObject *property);
  void (*create) (TdModTree *mod_tree, int id, int idparent, GtkObject *config);
};

/* Kit de donnes d'un drag'n'drop - Data kit for drag'n'drop */
typedef struct _TdDnd
{
  gchar *value[6000]; /* valeur [index] - value [index] */
} _TdDnd, *TdDnd;


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static void td_mod_tree_set_name (TdModTree *mod_tree, gchar *name);
static void td_mod_tree_set_id (TdModTree *mod_tree, int id);
static void td_mod_tree_set_idparent (TdModTree *mod_tree, int idparent);
static void td_mod_tree_set_reorderable (TdModTree *mod_tree, gboolean reorderable);
static void td_mod_tree_set_column_auto_resize (TdModTree *mod_tree, gboolean column_auto_resize);
static void td_mod_tree_set_customize (TdModTree *mod_tree, gboolean customize);
static void td_mod_tree_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_tree_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_mod_tree_init (TdModTree *mod_tree);
static void td_mod_tree_class_init (TdModTreeClass *klass);
GtkType td_mod_tree_get_type (void);
GtkObject *td_mod_tree_new (void);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_mod_tree_add_field (TdModTree *mod_tree, GtkObject *field);
void td_mod_tree_add_icon (TdModTree *mod_tree, GtkObject *icon);
void td_mod_tree_set_default_menu (TdModTree *mod_tree, GtkWidget *default_menu);
void td_mod_tree_add_menu (TdModTree *mod_tree, GtkObject *menu);
void td_mod_tree_add_property (TdModTree *mod_tree, GtkObject *property);

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void td_mod_tree_create (TdModTree *mod_tree, int id, int idparent, GtkObject *config);
GtkObject *td_mod_tree_custom_def (TdModTree *mod_tree);
void td_mod_tree_button_press (GtkWidget *widget, GdkEventButton *event, TdModTree *mod_tree);
GList *td_mod_tree_read_node (TdModTree *mod_tree, GtkCTreeNode *node, gboolean admin);
GtkCTreeNode *td_mod_tree_add_node (TdModTree *mod_tree, GtkCTreeNode *parent, GtkCTreeNode *sibling, GList *data, gboolean new);
void td_mod_tree_remove_node (TdModTree *mod_tree);
void td_mod_tree_copy (TdModTree *mod_tree, GtkCTreeNode *node, GtkCTreeNode *node_parent, GtkCTreeNode *node_sibling);
void td_mod_tree_clear (TdModTree *mod_tree);
void td_mod_tree_expand (TdModTree *mod_tree, GtkCTreeNode *node);
gboolean td_mod_tree_refresh_node (GtkWidget *widget, GtkObject *mod_tree, int column, gboolean prop_refresh, gboolean icon_refresh);
void td_mod_tree_custom (TdModTree *mod_tree);

/*****************************************************************************/
/* Dnd */
/*****************************************************************************/
void td_mod_tree_dnd_get (GtkWidget *widget, GdkDragContext *context, GtkSelectionData *selection_data, guint info, guint time, int row);
gboolean td_mod_tree_dnd_received (GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *selection_data, guint info, guint time, TdModTree *mod_tree);
gint td_mod_tree_dnd_autoexpand (gpointer widget);
int td_mod_tree_dnd_drag_position (GtkWidget *widget, int x, int y, GtkWidget *scrolledwindow);
gboolean td_mod_tree_dnd_motion (GtkWidget *widget, GdkDragContext *context, gint x, gint y, guint time, GtkWidget *scrolledwindow);

/*****************************************************************************/
/* Base */
/*****************************************************************************/
gboolean td_mod_tree_load (TdModTree *mod_tree, GtkObject *datatable, gboolean translation);
GtkObject *td_mod_tree_save (TdModTree *mod_tree, gboolean translation);
void td_mod_tree_modified (TdModTree *mod_tree);
void td_mod_tree_unmodified (TdModTree *mod_tree);

/*****************************************************************************/
/* Fichier support (flower) */
/*****************************************************************************/
void td_mod_tree_load_flower (TdModTree *mod_tree, GtkObject *flower);
gboolean td_mod_tree_save_flower (TdModTree *mod_tree, GtkObject *flower, gchar *file);

/*****************************************************************************/
/* Old version */
/*****************************************************************************/
void td_mod_tree_dnd_get_old (GtkWidget *widget, GdkDragContext *context, GtkSelectionData *selection_data, guint info, guint time, int row);
gboolean td_mod_tree_dnd_received_old (GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *selection_data, guint info, guint time, TdModTree *mod_tree);
