/*****************************************************************************/
/* td_mod_tree.c : Objet Gtk+
 * td_mod_tree.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "gtdk.h"

#include "td_app.h"
#include "td_app_palette.h"
#include "td_app_editprop.h"

#include "td_mod_tree.h"
#include "td_mod_tree_menu.h"
#include "td_mod_tree_icon.h"
#include "td_mod_tree_prop.h"
#include "td_mod_tree_equal.h"

#include "td_db_base.h"
#include "td_db_mod.h"
#include "td_db_datatable.h"
#include "td_db_connect.h"

#include "td_field.h"
#include "td_field_dico.h"
#include "td_flower.h"
#include "td_custom.h"
#include "td_custom_option.h"

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_ID,
  ARG_IDPARENT,
  ARG_REORDERABLE,
  ARG_COLUMN_AUTO_RESIZE,
  ARG_CUSTOMIZE,
};

static void td_mod_tree_set_name (TdModTree *mod_tree, gchar *name)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  if (mod_tree->name != name)
    {
      mod_tree->name = name;
      mod_tree->label = gtk_label_new (name);
    }
}

static void td_mod_tree_set_id (TdModTree *mod_tree, int id)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  if (mod_tree->id != id)
    mod_tree->id = id;
}

static void td_mod_tree_set_idparent (TdModTree *mod_tree, int idparent)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  if (mod_tree->idparent != idparent)
    mod_tree->idparent = idparent;
}

static void td_mod_tree_set_reorderable (TdModTree *mod_tree, gboolean reorderable)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  if (mod_tree->reorderable != reorderable)
    mod_tree->reorderable = reorderable;
}

static void td_mod_tree_set_column_auto_resize (TdModTree *mod_tree, gboolean column_auto_resize)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  if (mod_tree->column_auto_resize != column_auto_resize)
    mod_tree->column_auto_resize = column_auto_resize;
}

static void td_mod_tree_set_customize (TdModTree *mod_tree, gboolean customize)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  if (mod_tree->customize != customize)
    mod_tree->customize = customize;
}

static void td_mod_tree_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModTree *mod_tree;
  mod_tree = TD_MOD_TREE (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_mod_tree_set_name (mod_tree, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ID:
      td_mod_tree_set_id (mod_tree, GTK_VALUE_INT (*arg));
      break;
    case ARG_IDPARENT:
      td_mod_tree_set_idparent (mod_tree, GTK_VALUE_INT (*arg));
      break;
    case ARG_REORDERABLE:
      td_mod_tree_set_reorderable (mod_tree, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_COLUMN_AUTO_RESIZE:
      td_mod_tree_set_column_auto_resize (mod_tree, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_CUSTOMIZE:
      td_mod_tree_set_customize (mod_tree, GTK_VALUE_BOOL (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_tree_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModTree *mod_tree;
  mod_tree = TD_MOD_TREE (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = mod_tree->name;
      break;
    case ARG_ID:
      GTK_VALUE_INT (*arg) = mod_tree->id;
      break;
    case ARG_IDPARENT:
      GTK_VALUE_INT (*arg) = mod_tree->idparent;
      break;
    case ARG_REORDERABLE:
      GTK_VALUE_BOOL (*arg) = mod_tree->reorderable;
      break;
    case ARG_COLUMN_AUTO_RESIZE:
      GTK_VALUE_BOOL (*arg) = mod_tree->column_auto_resize;
      break;
    case ARG_CUSTOMIZE:
      GTK_VALUE_BOOL (*arg) = mod_tree->customize;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_mod_tree_init (TdModTree *mod_tree)
{
  mod_tree->name = NULL;
  mod_tree->id = -1;
  mod_tree->idparent = -1;
  mod_tree->label = NULL;
  mod_tree->widget = NULL;
  mod_tree->field = NULL;
  mod_tree->icon = NULL;
  mod_tree->default_menu = NULL;
  mod_tree->menu = NULL;
  mod_tree->property = NULL;
  mod_tree->reorderable = FALSE;
  mod_tree->column_auto_resize = FALSE;
  mod_tree->customize = FALSE;
}

static void td_mod_tree_class_init (TdModTreeClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModTree::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdModTree::id", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_ID);
  gtk_object_add_arg_type ("TdModTree::idparent", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_IDPARENT);
  gtk_object_add_arg_type ("TdModTree::reorderable", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_REORDERABLE);
  gtk_object_add_arg_type ("TdModTree::column_auto_resize", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_COLUMN_AUTO_RESIZE);
  gtk_object_add_arg_type ("TdModTree::customize", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_CUSTOMIZE);
  object_class->set_arg = td_mod_tree_set_arg;
  object_class->get_arg = td_mod_tree_get_arg;
  klass->add_field = td_mod_tree_add_field;
  klass->add_icon = td_mod_tree_add_icon;
  klass->set_default_menu = td_mod_tree_set_default_menu;
  klass->add_menu = td_mod_tree_add_menu;
  klass->add_property = td_mod_tree_add_property;
  klass->create = td_mod_tree_create;
}

GtkType td_mod_tree_get_type (void)
{
  static GtkType mod_tree_type = 0;
  if (!mod_tree_type)
    {
      static const GtkTypeInfo mod_tree_info =
      {
  	"TdModTree", sizeof (TdModTree), sizeof (TdModTreeClass),
  	(GtkClassInitFunc) td_mod_tree_class_init,
	(GtkObjectInitFunc) td_mod_tree_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_tree_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_tree_info);
    }
  return mod_tree_type;
}

GtkObject *td_mod_tree_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_tree_get_type ()));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_mod_tree_add_field (TdModTree *mod_tree, GtkObject *field)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  mod_tree->field = g_list_append (mod_tree->field, field);
}

void td_mod_tree_add_icon (TdModTree *mod_tree, GtkObject *icon)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  mod_tree->icon = g_list_append (mod_tree->icon, icon);
}

void td_mod_tree_set_default_menu (TdModTree *mod_tree, GtkWidget *default_menu)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  if (mod_tree->default_menu != default_menu)
    mod_tree->default_menu = default_menu;
}

void td_mod_tree_add_menu (TdModTree *mod_tree, GtkObject *menu)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  mod_tree->menu = g_list_append (mod_tree->menu, menu);
}

void td_mod_tree_add_property (TdModTree *mod_tree, GtkObject *property)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  mod_tree->property = g_list_append (mod_tree->property, property);
}


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void td_mod_tree_create (TdModTree *mod_tree, int id, int idparent, GtkObject *config)
{
  GList *data = NULL;
  GtkWidget *ctree;
  GtkObject *property_tmp;
  GList *label = NULL;
  int i, j;
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));

  /* Box */
  mod_tree->id = id;
  mod_tree->idparent = idparent;
  mod_tree->widget = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (mod_tree->widget);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (mod_tree->widget), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  /* Arbre */
  ctree = gtk_ctree_new (g_list_length (mod_tree->field) + g_list_length (TD_APP (APP)->admin_field), 0);
  gtdk_clist_adjustheight (ctree);
  gtk_widget_show (ctree);
  gtk_container_add (GTK_CONTAINER (mod_tree->widget), ctree);
  gtk_widget_set_usize (ctree, 0, -2);
  gtk_clist_column_titles_show (GTK_CLIST (ctree));

  /* Donnes utilisateur avec configuration */
  if (mod_tree->customize)
    for (i=0; i<g_list_length (mod_tree->field); i++)
      {
	if ((!strcmp (td_custom_value (config, TD_MOD_TREE (mod_tree)->name, TD_FIELD (g_list_nth_data (mod_tree->field, i))->name, "autosize"), "t")) ||
	    (!strcmp (td_custom_value (config, TD_MOD_TREE (mod_tree)->name, TD_FIELD (g_list_nth_data (mod_tree->field, i))->name, "size"), "(null)")))
	  gtk_clist_set_column_auto_resize (GTK_CLIST (ctree), i, TRUE);
	else
	  gtk_clist_set_column_width (GTK_CLIST (ctree), i, atoi (td_custom_value (config, TD_MOD_TREE (mod_tree)->name, TD_FIELD (g_list_nth_data (mod_tree->field, i))->name, "size")));
	label = g_list_append (label, gtk_label_new (TD_FIELD (g_list_nth_data (mod_tree->field, i))->name_intl));
	gtk_widget_show (g_list_nth_data (label, i));
	gtk_clist_set_column_widget (GTK_CLIST (ctree), i, g_list_nth_data (label, i));
	if (!strcmp (td_custom_value (config, TD_MOD_TREE (mod_tree)->name, TD_FIELD (g_list_nth_data (mod_tree->field, i))->name, "visible"), "f"))
	  gtk_clist_set_column_visibility (GTK_CLIST (ctree), i, FALSE);
	if (TD_APP (APP)->mode_debug)
	  gtk_clist_set_column_visibility (GTK_CLIST (ctree), i, TRUE);
      }

  /* Donnes utilisateur sans configuration */
  else
    for (i=0; i<g_list_length (mod_tree->field); i++)
      {
	if (mod_tree->column_auto_resize)
	  gtk_clist_set_column_auto_resize (GTK_CLIST (ctree), i, TRUE);
	label = g_list_append (label, gtk_label_new (TD_FIELD (g_list_nth_data (mod_tree->field, i))->name_intl));
	gtk_widget_show (g_list_nth_data (label, i));
	gtk_clist_set_column_widget (GTK_CLIST (ctree), i, g_list_nth_data (label, i));
	if ((!TD_APP (APP)->mode_debug) && (!TD_FIELD (g_list_nth_data (mod_tree->field, i))->visible))
	  gtk_clist_set_column_visibility (GTK_CLIST (ctree), i, FALSE);
      }

  /* Donnes administrateur - Manager's data */
  for (i=0; i<g_list_length (TD_APP (APP)->admin_field); i++)
    {
      gtk_clist_set_column_auto_resize (GTK_CLIST (ctree), g_list_length (mod_tree->field)+i, TRUE);
      label = g_list_append (label, gtk_label_new (TD_FIELD (g_list_nth_data (TD_APP (APP)->admin_field, i))->name_intl));
      gtk_widget_show (g_list_nth_data (label, g_list_length (mod_tree->field)+i));
      gtk_clist_set_column_widget (GTK_CLIST (ctree), g_list_length (mod_tree->field)+i, g_list_nth_data (label, g_list_length (mod_tree->field)+i));
      if (!TD_APP (APP)->mode_debug)
	gtk_clist_set_column_visibility (GTK_CLIST (ctree), g_list_length (mod_tree->field)+i, FALSE);
    }

  /* Appels arbre */
  gtk_signal_connect (GTK_OBJECT (ctree), "button_press_event", GTK_SIGNAL_FUNC (td_mod_tree_button_press), mod_tree);
  gtk_signal_connect (GTK_OBJECT (ctree), "tree_expand", GTK_SIGNAL_FUNC (gtdk_ctree_expand), mod_tree->widget);
  if (mod_tree->reorderable)
    {
      gtk_drag_source_set (GTK_WIDGET (ctree), GDK_BUTTON1_MASK, TD_DRAG_TYPES, TD_N_DRAG_TYPES, GDK_ACTION_MOVE | GDK_ACTION_COPY);
      gtk_drag_dest_set (GTK_WIDGET (ctree), GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP, TD_DROP_TYPES, TD_N_DROP_TYPES, GDK_ACTION_MOVE | GDK_ACTION_COPY);
      gtk_signal_connect (GTK_OBJECT (ctree), "drag_data_received", GTK_SIGNAL_FUNC (td_mod_tree_dnd_received), mod_tree);
      gtk_signal_connect (GTK_OBJECT (ctree), "drag_motion", GTK_SIGNAL_FUNC (td_mod_tree_dnd_motion), mod_tree->widget);
    }
}

GtkObject *td_mod_tree_custom_def (TdModTree *mod_tree)
{
  int i, j, k;
  GtkObject *ret;
  GtkObject *option[500];
  GtkObject *spinbutton_adj[500];
  
  /* Gnral */
  ret = td_custom_new ();
  TD_CUSTOM (ret)->name = mod_tree->name;
  TD_CUSTOM (ret)->category1 = _("Tree");
  TD_CUSTOM (ret)->category2 = mod_tree->name;
  TD_CUSTOM (ret)->category3 = "(null)";

  /* Collonne */
  j = 0;
  k = 0;
  for (i=0; i<g_list_length (mod_tree->field); i++)
    {
      option[j] = td_custom_option_new ();
      gtk_object_set (GTK_OBJECT (option[j]),
		      "name", "visible",
		      "newline", TRUE,
		      "group", g_strdup_printf("%s", TD_FIELD (g_list_nth_data (mod_tree->field, i))->name), NULL);
      td_custom_option_set_widget (TD_CUSTOM_OPTION (option[j]), gtk_check_button_new_with_label (_("visible")));
      gtk_button_clicked (GTK_BUTTON (TD_CUSTOM_OPTION (option[j])->widget));
      td_custom_add_option (TD_CUSTOM (ret), option[j]);
      j++;

      option[j] = td_custom_option_new ();
      gtk_object_set (GTK_OBJECT (option[j]),
		      "name", "autosize",
		      "group", g_strdup_printf("%s", TD_FIELD (g_list_nth_data (mod_tree->field, i))->name), NULL);
      td_custom_option_set_widget (TD_CUSTOM_OPTION (option[j]), gtk_check_button_new_with_label (_("autosize")));
      gtk_button_clicked (GTK_BUTTON (TD_CUSTOM_OPTION (option[j])->widget));
      td_custom_add_option (TD_CUSTOM (ret), option[j]);
      j++;

      option[j] = td_custom_option_new ();
      gtk_object_set (GTK_OBJECT (option[j]),
		      "name", "size_label",
		      "group", g_strdup_printf("%s", TD_FIELD (g_list_nth_data (mod_tree->field, i))->name), NULL);
      td_custom_option_set_widget (TD_CUSTOM_OPTION (option[j]), gtk_label_new (_("size")));
      td_custom_add_option (TD_CUSTOM (ret), option[j]);
      j++;

      option[j] = td_custom_option_new ();
      gtk_object_set (GTK_OBJECT (option[j]),
		      "name", "size",
		      "group", g_strdup_printf("%s", TD_FIELD (g_list_nth_data (mod_tree->field, i))->name), NULL);

      spinbutton_adj[k] = gtk_adjustment_new (1, 0, 1000, 1, 10, 10);
      td_custom_option_set_widget (TD_CUSTOM_OPTION (option[j]), gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_adj[k]), 1, 0));
      td_custom_add_option (TD_CUSTOM (ret), option[j]);
      j++;
      k++;
    }
  return ret;
}

void td_mod_tree_button_press (GtkWidget *widget, GdkEventButton *event, TdModTree *mod_tree)
{
  TdModTreeMenu *menu_tmp = NULL;
  TdModTreeProp *property_tmp = NULL;
  GdkEventButton *bevent;
  int row, column, i, j;
  gboolean bool_tmp;
  gchar *value_tmp;
  GdkPixmap *pixmap_tmp;
  GdkBitmap *mask_tmp;
  guint8 spacing_tmp;
  GtkWidget *label_tmp;
  bevent = (GdkEventButton*) event;
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));

  /* Selection */
  gtk_clist_get_selection_info (GTK_CLIST (widget), bevent->x, bevent->y, &row, &column);
  row = gtdk_clist_correction (widget, row, bevent->y);
  if (row < 0)
    mod_tree->selected = NULL;
  else
    mod_tree->selected = gtk_ctree_node_nth (GTK_CTREE (widget), row);

  /* Proprits */
  FLAG_NO_REFRESH_NODE = TRUE;
  if (mod_tree->idparent==-1)
    gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_EDITPROP (TD_APP (APP)->editprop)->notebook), 0);
  else
    gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_EDITPROP (TD_APP (APP)->editprop)->notebook), mod_tree->idparent);
  for (i=0; i<g_list_length (mod_tree->property); i++)
    {
      property_tmp = g_list_nth_data (mod_tree->property, i);
      if (mod_tree->id == property_tmp->tab)
	{
	  bool_tmp = FALSE;
	  for (j=0; j<g_list_length (property_tmp->visible); j++)
	    if (td_mod_tree_equal_test_node (TD_MOD_TREE_EQUAL (g_list_nth_data (property_tmp->visible, j)), GTK_OBJECT (mod_tree)))
	      {
		bool_tmp = TRUE;
		break;
	      }
	  if (bool_tmp)
	    {

	      /* Sensitivit */
	      bool_tmp = FALSE;
	      for (j=0; j<g_list_length (property_tmp->unsensitive); j++)
		if (td_mod_tree_equal_test_node (TD_MOD_TREE_EQUAL (g_list_nth_data (property_tmp->unsensitive, j)), GTK_OBJECT (mod_tree)))
		  {
		    bool_tmp = TRUE;
		    break;
		  }
	      if (bool_tmp)
		gtk_widget_set_sensitive (property_tmp->widget_parent, FALSE);
	      else
		gtk_widget_set_sensitive (property_tmp->widget_parent, TRUE);

	      /* Valeur */
	      if (TD_MOD_TREE (mod_tree)->selected)
		{
		  if (property_tmp->column == 0)
		    gtk_ctree_node_get_pixtext (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, 0, &value_tmp, &spacing_tmp, &pixmap_tmp, &mask_tmp);
		  else
		    gtk_ctree_node_get_text (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, property_tmp->column, &value_tmp);

		  /* gtk_entry */
		  if (GTK_IS_ENTRY (property_tmp->widget))
		    gtk_entry_set_text (GTK_ENTRY (property_tmp->widget), value_tmp);

		  /* gtk_combo */
		  if (GTK_IS_COMBO (property_tmp->widget))
		    gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (property_tmp->widget)->entry), value_tmp);

		  /* gtk_toggle_button */
		  if (GTK_IS_TOGGLE_BUTTON (property_tmp->widget))
		    {
		      label_tmp = GTK_BUTTON (property_tmp->widget)->child;
		      gtk_label_set_text (GTK_LABEL (label_tmp), value_tmp);
		      if (((GTK_TOGGLE_BUTTON (property_tmp->widget)->active)) && (!strcmp (value_tmp, property_tmp->defaultv)))
			gtk_button_clicked (GTK_BUTTON (property_tmp->widget));
		      if ((!GTK_TOGGLE_BUTTON (property_tmp->widget)->active) && (strcmp (value_tmp, property_tmp->defaultv)))
			gtk_button_clicked (GTK_BUTTON (property_tmp->widget));
		    }

		  /* FIXME: la suite arrive : +tards */

		}

	      /* Visibilit */
	      gtk_widget_show (property_tmp->label);
	      gtk_widget_show (property_tmp->widget_parent);
	    }
	  else
	    {
	      gtk_widget_hide (property_tmp->label);
	      gtk_widget_hide (property_tmp->widget_parent);
	    }
	}
      else
	{
	  gtk_widget_hide (property_tmp->label);
	  gtk_widget_hide (property_tmp->widget_parent);
	}
    }
  FLAG_NO_REFRESH_NODE = FALSE;

  /* Dnd */
  if (mod_tree->reorderable)
    if (mod_tree->idparent!=-1)
      if (bevent->button == 1)
	if (mod_tree->selected)
	  gtk_signal_connect (GTK_OBJECT (widget), "drag_data_get", GTK_SIGNAL_FUNC (td_mod_tree_dnd_get), (int*) row);

  /* Menus item */
  if (bevent->button == 3)
    {
      gtk_clist_get_selection_info (GTK_CLIST (widget), bevent->x, bevent->y, &row, &column);
      row = gtdk_clist_correction (widget, row, bevent->y);
      if (row < 0)
	{
	  if (mod_tree->default_menu)
	    gnome_popup_menu_do_popup (TD_MOD_TREE (mod_tree)->default_menu, NULL, NULL, bevent, NULL);
	}
      else
	{
	  if (!g_list_length (mod_tree->menu))
	    gnome_popup_menu_do_popup (TD_MOD_TREE (mod_tree)->default_menu, NULL, NULL, bevent, NULL);
	  else
	    for (i=0; i<g_list_length (mod_tree->menu); i++)
	      {
		menu_tmp = (TdModTreeMenu*) g_list_nth_data (mod_tree->menu, i);
		for (j=0; j<g_list_length (menu_tmp->equal); j++)
		  if (td_mod_tree_equal_test_node (TD_MOD_TREE_EQUAL (g_list_nth_data (menu_tmp->equal, j)), GTK_OBJECT (mod_tree)))
		    {
		      j = g_list_length (menu_tmp->equal);
		      i = g_list_length (mod_tree->menu);
		      gnome_popup_menu_do_popup (menu_tmp->menu, NULL, NULL, bevent, NULL);
		    }
	      }
	  if (menu_tmp)
	    gtk_object_destroy (GTK_OBJECT (menu_tmp));
	}
    }

  /* Menu principal */
  if (bevent->button == 2)
    {
      mod_tree->selected = NULL;
      gnome_popup_menu_do_popup (TD_APP (APP)->menu_main, NULL, NULL, bevent, NULL);
    }
}

GList *td_mod_tree_read_node (TdModTree *mod_tree, GtkCTreeNode *node, gboolean admin)
{
  GList *ret = NULL;
  gchar *value_tmp;
  guint8 spacing_tmp;
  GdkPixmap *pixmap_tmp;
  GdkBitmap *mask_tmp;
  int i, j;

  /* Valeur */
  if (admin)
    j = 4;
  else
    j = 0;
  gtk_ctree_node_get_pixtext (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), node, 0, &value_tmp, &spacing_tmp, &pixmap_tmp, &mask_tmp);
  ret = g_list_append (ret, value_tmp);
  for (i=1; i<g_list_length (mod_tree->field)+j; i++)
    {
      gtk_ctree_node_get_text (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), node, i, &value_tmp);
      ret = g_list_append (ret, value_tmp);
    }
  return ret;
}

GtkCTreeNode *td_mod_tree_add_node (TdModTree *mod_tree, GtkCTreeNode *parent, GtkCTreeNode *sibling, GList *data, gboolean new)
{
  GtkCTreeNode *ret;
  gchar *txt[50];
  int i, j;
  gchar *value_tmp;
  GdkPixmap *pixmap_tmp;
  GdkBitmap *mask_tmp;
  guint8 spacing_tmp;
  gboolean this_icon = TRUE;
  TdModTreeIcon *icon_tmp = NULL;
  GdkPixmap *pixmap1 = NULL;
  GdkBitmap *mask1 = NULL;
  GdkPixmap *pixmap2 = NULL;
  GdkBitmap *mask2 = NULL;
  GdkColor transparent;

  /* Valeurs */
  if (new)
    {
      data = g_list_append (data, _("(bud)"));
      data = g_list_append (data, _("(bud)"));
      data = g_list_append (data, _("(bud)"));
      data = g_list_append (data, _("(bud)"));
    }
  for (i=0; i<g_list_length (data); i++)
    txt[i] = (gchar*) g_list_nth_data (data, i); 

  /* Icones */
  for (i=0; i<g_list_length (mod_tree->icon); i++)
    {
      icon_tmp = (TdModTreeIcon*) g_list_nth_data (mod_tree->icon, i);
      for (j=0; j<g_list_length (icon_tmp->equal); j++)
	if (td_mod_tree_equal_test_list (TD_MOD_TREE_EQUAL (g_list_nth_data (icon_tmp->equal, j)), data))
	  {
	    j = g_list_length (icon_tmp->equal);
	    i = g_list_length (mod_tree->icon);
	    pixmap1 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask1, &transparent, (gchar**) icon_tmp->pixmap1); /* bidouille sur la fentre */
	    pixmap2 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (TD_APP_PALETTE (TD_APP (APP)->palette)->window)->window, &mask2, &transparent, (gchar**) icon_tmp->pixmap2); /* bidouille sur la fentre */
	  }
      gtk_object_destroy (GTK_OBJECT (icon_tmp));
    }

  /* Node */
  ret = gtk_ctree_insert_node (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), parent, sibling, txt, 5, pixmap1, mask1, pixmap2, mask2, FALSE, FALSE);
  td_mod_tree_modified (mod_tree);
  return ret;
}

void td_mod_tree_remove_node (TdModTree *mod_tree)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  gtk_ctree_remove_node (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), mod_tree->selected);
  mod_tree->selected = NULL;
  td_mod_tree_modified (mod_tree);
}

void td_mod_tree_copy (TdModTree *mod_tree, GtkCTreeNode *node, GtkCTreeNode *node_parent, GtkCTreeNode *node_sibling)
{
  GList *data = NULL;
  GList *data_level = NULL;
  GList *node_list = NULL;
  int i, j, root_level;
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));

  /* Go ! */
  i = -1;
  root_level = GTK_CTREE_ROW (node)->level;
  while (node)
    {
      /* Valeur */
      i++;
      data = td_mod_tree_read_node (mod_tree, node, FALSE);
      data_level = g_list_append (data_level, g_strdup_printf("%d", GTK_CTREE_ROW (node)->level));
      if (i == 0)
	node_list = g_list_append (node_list, td_mod_tree_add_node (mod_tree, node_parent, node_sibling, data, TRUE));
      else
	{
	  j = 1;
	  while (atoi (g_list_nth_data (data_level, i-j)) != atoi (g_list_nth_data (data_level, i))-1)
	    j++;
	  node_list = g_list_append (node_list, td_mod_tree_add_node (mod_tree, g_list_nth_data (node_list, i-j), NULL, data, TRUE));
	}

      /* Suivant */
      data = NULL;
      node = gtdk_ctree_next (node);
      if (node)
	if (root_level >= GTK_CTREE_ROW (node)->level)
	  node = NULL;
    }
}

void td_mod_tree_clear (TdModTree *mod_tree)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  gtdk_ctree_clear (GTK_WIDGET (GTK_BIN (mod_tree->widget)->child));
  mod_tree->selected = NULL;
}

void td_mod_tree_expand (TdModTree *mod_tree, GtkCTreeNode *node)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  if (!node)
    gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected);
  else
    gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), node);
}

gboolean td_mod_tree_refresh_node (GtkWidget *widget, GtkObject *mod_tree, int column, gboolean prop_refresh, gboolean icon_refresh)
{
  TdModTreeIcon *icon_tmp = NULL;
  TdModTreeProp *property_tmp = NULL;
  GList *data = NULL;
  gboolean bool_tmp;
  gchar *value;
  gchar *value_tmp;
  gchar *value_merde;
  guint8 spacing_tmp;
  gboolean leaf_tmp;
  gboolean expanded_tmp;
  GdkPixmap *pixmap1_tmp;
  GdkPixmap *pixmap2_tmp;
  GdkBitmap *mask1_tmp;
  GdkBitmap *mask2_tmp;
  GdkPixmap *pixmap1 = NULL;
  GdkPixmap *pixmap2 = NULL;
  GdkBitmap *mask1;
  GdkBitmap *mask2;
  GdkColor transparent;
  GtkWidget *label_tmp;
  int i,j;

  /* Traitement du click en cours : ignore l'vnement */
  if (FLAG_NO_REFRESH_NODE)
    return TRUE;

  /* null */
  if (!TD_MOD_TREE (mod_tree)->selected)
    return TRUE;

  /* gtk_entry */
  if (GTK_IS_ENTRY (widget))
    value = gtk_entry_get_text (GTK_ENTRY (widget));

  /* gtk_combo */
  if (GTK_IS_COMBO (widget))
    value = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (widget)->entry));

  /* gtk_toggle_button */
  if (GTK_IS_TOGGLE_BUTTON (widget))
    {
      label_tmp = GTK_BUTTON (widget)->child;
      gtk_label_get (GTK_LABEL (label_tmp), &value);
    }

  /* FIXME: la suite arrive : +tards */

  /* Valeur */
  if (!column)
    {
      gtk_ctree_node_get_pixtext (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, 0, &value_tmp, &spacing_tmp, &pixmap1_tmp, &mask1_tmp);
      gtk_ctree_node_set_pixtext (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, 0, value, spacing_tmp, pixmap1_tmp, mask1_tmp);
    }
  else
    gtk_ctree_node_set_text (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, column, value);
  td_mod_tree_modified (TD_MOD_TREE (mod_tree));

  /* Proprits */
  if (prop_refresh)
    for (i=0; i<g_list_length (TD_MOD_TREE (mod_tree)->property); i++)
      {
	property_tmp = g_list_nth_data (TD_MOD_TREE (mod_tree)->property, i);
	if (TD_MOD_TREE (mod_tree)->id == property_tmp->tab)
	  {
	    bool_tmp = FALSE;
	    for (j=0; j<g_list_length (property_tmp->visible); j++)
	      if (td_mod_tree_equal_test_node (TD_MOD_TREE_EQUAL (g_list_nth_data (property_tmp->visible, j)), GTK_OBJECT (mod_tree)))
		{
		  bool_tmp = TRUE;
		  break;
		}
	    if (bool_tmp)
	      {

		/* Sensitivit */
		bool_tmp = FALSE;
		for (j=0; j<g_list_length (property_tmp->unsensitive); j++)
		  if (td_mod_tree_equal_test_node (TD_MOD_TREE_EQUAL (g_list_nth_data (property_tmp->unsensitive, j)), GTK_OBJECT (mod_tree)))
		    {
		      bool_tmp = TRUE;
		      break;
		  }
		if (bool_tmp)
		  gtk_widget_set_sensitive (property_tmp->widget_parent, FALSE);
		else
		  gtk_widget_set_sensitive (property_tmp->widget_parent, TRUE);
	      }
	  }
      }

  /* Traitement des icones */
  if (icon_refresh)
    {
      for (i=0; i<g_list_length (TD_MOD_TREE (mod_tree)->icon); i++)
	{
	  icon_tmp = (TdModTreeIcon*) g_list_nth_data (TD_MOD_TREE (mod_tree)->icon, i);
	  for (j=0; j<g_list_length (icon_tmp->equal); j++)
	    if (td_mod_tree_equal_test_node (TD_MOD_TREE_EQUAL (g_list_nth_data (icon_tmp->equal, j)), GTK_OBJECT (mod_tree)))
	      {
		j = g_list_length (icon_tmp->equal);
		i = g_list_length (TD_MOD_TREE (mod_tree)->icon);
		pixmap1 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child)->window, &mask1, &transparent, (gchar**) icon_tmp->pixmap1);
		pixmap2 = gdk_pixmap_create_from_xpm_d (GTK_WIDGET (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child)->window, &mask2, &transparent, (gchar**) icon_tmp->pixmap2);
	      }
	}
      GTK_CTREE_ROW (TD_MOD_TREE (mod_tree)->selected)->pixmap_closed = pixmap1;
      GTK_CTREE_ROW (TD_MOD_TREE (mod_tree)->selected)->mask_closed = mask1;
      GTK_CTREE_ROW (TD_MOD_TREE (mod_tree)->selected)->pixmap_opened = pixmap2;
      GTK_CTREE_ROW (TD_MOD_TREE (mod_tree)->selected)->mask_opened = mask2;
      gtk_ctree_get_node_info (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, &value_merde, &spacing_tmp, &pixmap1_tmp, &pixmap2_tmp, &mask1_tmp, &mask2_tmp, &leaf_tmp, &expanded_tmp);
      gtk_ctree_node_get_pixtext (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, 0, &value_tmp, &spacing_tmp, &pixmap1_tmp, &mask1_tmp);
      if (!expanded_tmp)
	gtk_ctree_node_set_pixtext (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, 0, g_strdup_printf ("%s", value_tmp), spacing_tmp, pixmap1, mask1);
      else
	gtk_ctree_node_set_pixtext (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, 0, g_strdup_printf ("%s", value_tmp), spacing_tmp, pixmap2, mask2);
      gtk_object_destroy (GTK_OBJECT (icon_tmp));
      g_list_free (data);
    }
  return TRUE;
}


/*****************************************************************************/
/* Dnd */
/*****************************************************************************/
void td_mod_tree_dnd_get (GtkWidget *widget, GdkDragContext *context, GtkSelectionData *selection_data, guint info, guint time, int row)
{
  int length;
  gchar *txt_tmp;

  /* Communication */
  DRAG_ROW = row;
  txt_tmp = "(null)";
  length = strlen (txt_tmp);
  gtk_selection_data_set (selection_data, GDK_SELECTION_TYPE_STRING, sizeof (txt_tmp), (guchar*) txt_tmp, length*2);
}

gboolean td_mod_tree_dnd_received (GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *selection_data, guint info, guint time, TdModTree *mod_tree)
{
  int drag_position = 0;
  GtkCTreeNode *node_drag;
  GtkCTreeNode *node;
  GtkCTreeNode *node_parent;
  GtkCTreeNode *node_sibling;
  int row, column, i, j, k;

  /* Correction sur le y (pomp de gtkctree.c) */
  y -= (GTK_CONTAINER (widget)->border_width + 
	widget->style->klass->ythickness + GTK_CLIST (widget)->column_title_area.height);

  /* Capture de la ligne */
  drag_position = td_mod_tree_dnd_drag_position (widget, x, y, mod_tree->widget);
  if (!drag_position)
    node = NULL;
  else
    {
      gtk_clist_get_selection_info (GTK_CLIST (widget), x, y, &row, &column);
      node = gtk_ctree_node_nth (GTK_CTREE (widget), row);
    }

  /* Dnd sur la mme node */
  if (mod_tree->selected == node)
    if (context->actions != GDK_ACTION_COPY)
      return TRUE;

  /* Position : avant */
  if (drag_position == 1)
    {
      if (GTK_CTREE_ROW (node)->parent)
	node_parent = GTK_CTREE_ROW (node)->parent;
      else
	node_parent = NULL;
      node_sibling = node;
    }
  else
    {

      /* Position : dedans */
      if (drag_position == 2)
	{
	  node_parent = node;
	  node_sibling = NULL;
	}
      else
	{

	  /* Position : aprs */
	  if (node)
	    {
	      if (GTK_CTREE_ROW (node)->parent)
		node_parent = GTK_CTREE_ROW (node)->parent;
	      else
		node_parent = NULL;
	      if (GTK_CTREE_ROW (node)->sibling)
		node_sibling = GTK_CTREE_ROW (node)->sibling;
	      else
		node_sibling = NULL;
	    }
	  else
	    {
	      node_parent = NULL;
	      node_sibling = NULL;
	    }
	}
    }

  /* Node prise */
  node_drag = gtk_ctree_node_nth (GTK_CTREE (widget), DRAG_ROW);

  /* Copie */
  if (context->actions != GDK_ACTION_COPY)
    gtk_ctree_move (GTK_CTREE (widget), node_drag, node_parent, node_sibling);
  else
    td_mod_tree_copy (mod_tree, node_drag, node_parent, node_sibling);
  return TRUE;
}

gint td_mod_tree_dnd_autoexpand (gpointer widget)
{
  /* FIXME: bugg : vers la bas = rien et vers le haut = le parent viens aussi ! */
  GtkCTreeNode *node_selection;

  /* Auto-expansion */
  node_selection = gtk_ctree_node_nth (GTK_CTREE (widget), FLAG_DRAG_AUTOEXPAND_ROW);
  if (node_selection)
    if (GTK_CTREE_ROW (node_selection)->children)
      gtk_ctree_expand (GTK_CTREE (widget), node_selection);

  /* Fin du timeout pour l'auto-expansion */
  gtk_timeout_remove (FLAG_DRAG_AUTOEXPAND_ID);
  return FLAG_DRAG_AUTOEXPAND_ID;
}

int td_mod_tree_dnd_drag_position (GtkWidget *widget, int x, int y, GtkWidget *scrolledwindow)
{
  GtkAdjustment *tampon_adjustement;
  int row, column;

  /* Capture de la ligne */
  tampon_adjustement = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (scrolledwindow));
  if (((y-tampon_adjustement->value)>tampon_adjustement->page_size)||(y<0)||
      (y>((GTK_CLIST(widget)->rows)*((GTK_CLIST(widget)->row_height)+1))))
    return 0;
  gtk_clist_get_selection_info (GTK_CLIST(widget), x, y, &row, &column);
  row = gtdk_clist_correction (widget, row, y);
  if (row < 0)
    return 0;

  /* Avant */
  if (y+tampon_adjustement->value<((row*((GTK_CLIST(widget)->row_height)+1))+((GTK_CLIST(widget)->row_height)/3)))
    return 1;
  else
    {

      /* Dedant */
      if (y+tampon_adjustement->value<((row*((GTK_CLIST(widget)->row_height)+1))+(2*((GTK_CLIST(widget)->row_height)/3))))
	return 2;

      /* Aprs */
      else
	return 3;
    }
}

gboolean td_mod_tree_dnd_motion (GtkWidget *widget, GdkDragContext *context, gint x, gint y, guint time, GtkWidget *scrolledwindow)
{
  int row, column, drag_position;
  float i;
  gchar *txt_tampon;
  GtkCTreeNode *node_selection = NULL; 
  GtkAdjustment *tampon_adjustement;

  /* Action du dnd par dfaut */
  if ((context->actions != GDK_ACTION_MOVE)&&(context->actions != GDK_ACTION_COPY))
    gdk_drag_status (context, GDK_ACTION_MOVE, 0);

  /* Correction sur le y (pomp de gtkctree.c) */
  y -= (GTK_CONTAINER (widget)->border_width + widget->style->klass->ythickness + GTK_CLIST(widget)->column_title_area.height);

  /* Fin du timeout d'auto-expansion */
  gtk_timeout_remove (FLAG_DRAG_AUTOEXPAND_ID);

  /* Capture de la ligne */
  drag_position = td_mod_tree_dnd_drag_position (widget, x, y, scrolledwindow);
  if (!drag_position)
    return TRUE;
  gtk_clist_get_selection_info(GTK_CLIST(widget), x, y, &row, &column);
  tampon_adjustement = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (scrolledwindow));

  /* Scroll */
  if ((y<10)&&(tampon_adjustement->value>tampon_adjustement->lower))
    {
      gtk_adjustment_set_value (tampon_adjustement, (tampon_adjustement->value)-((GTK_CLIST(widget)->row_height)+1));
      gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (scrolledwindow), tampon_adjustement);
      return TRUE;
    }
  if ((y>(GTK_CLIST(widget)->clist_window_height-10)) && (tampon_adjustement->value<(tampon_adjustement->upper-tampon_adjustement->page_size)))
    {
      gtk_adjustment_set_value (tampon_adjustement, (tampon_adjustement->value)+((GTK_CLIST(widget)->row_height)+1));
      gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (scrolledwindow), tampon_adjustement);
      return TRUE;
    }

  /* Effacer */
  gdk_draw_line (GTK_CLIST(widget)->clist_window, widget->style->base_gc[GTK_STATE_NORMAL],
		 0, 
		 (FLAG_DRAG_ROW_OLD * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value,
		 GTK_CLIST(widget)->clist_window_width - 1, 
		 (FLAG_DRAG_ROW_OLD * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value);
  gdk_draw_line (GTK_CLIST(widget)->clist_window, widget->style->base_gc[GTK_STATE_NORMAL],
		 0, 
		 ((FLAG_DRAG_ROW_OLD + 1) * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value,
		 GTK_CLIST(widget)->clist_window_width - 1, 
		 ((FLAG_DRAG_ROW_OLD + 1) * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value);
  node_selection = gtk_ctree_node_nth(GTK_CTREE(widget), row);
  if (!node_selection)
    return TRUE;

  /* Avant */
  if (drag_position == 1)
    gdk_draw_line (GTK_CLIST(widget)->clist_window, widget->style->fg_gc[GTK_STATE_NORMAL],
		   GTK_CTREE(widget)->tree_indent * GTK_CTREE_ROW(node_selection)->level,
		   (row * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value,
		   GTK_CLIST(widget)->clist_window_width - 1, 
		   (row * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value);
  else
    {

      /* Dedans */      
      if (drag_position == 2)
	{
	  gdk_draw_line (GTK_CLIST(widget)->clist_window, widget->style->fg_gc[GTK_STATE_NORMAL],
			 GTK_CTREE(widget)->tree_indent * GTK_CTREE_ROW(node_selection)->level,
			 (row * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value,
			 GTK_CLIST(widget)->clist_window_width - 1, 
			 (row * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value);
	  gdk_draw_line (GTK_CLIST(widget)->clist_window, widget->style->fg_gc[GTK_STATE_NORMAL],
			 GTK_CTREE(widget)->tree_indent * GTK_CTREE_ROW(node_selection)->level,
			 ((row + 1) * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value,
			 GTK_CLIST(widget)->clist_window_width - 1, 
			 ((row + 1) * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value);

	  /* Dpart du timeout d'auto-expansion */
	  FLAG_DRAG_AUTOEXPAND_ROW = row;
	  FLAG_DRAG_AUTOEXPAND_ID = gtk_timeout_add (1000, td_mod_tree_dnd_autoexpand, widget);
	}

      /* Aprs */
      else
	gdk_draw_line (GTK_CLIST(widget)->clist_window, widget->style->fg_gc[GTK_STATE_NORMAL],
		       GTK_CTREE(widget)->tree_indent * GTK_CTREE_ROW(node_selection)->level,
		       ((row + 1) * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value,
		       GTK_CLIST(widget)->clist_window_width - 1, 
		       ((row + 1) * ((GTK_CLIST(widget)->row_height)+1))-tampon_adjustement->value);
    }
  FLAG_DRAG_ROW_OLD = row;
  return TRUE;
}


/*****************************************************************************/
/* Base */
/*****************************************************************************/
gboolean td_mod_tree_load (TdModTree *mod_tree, GtkObject *datatable, gboolean translation)
{
  GList *data = NULL;
  GList *node_list = NULL;
  GList *node_id = NULL;
  int i, j;

  /* Go ! */
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable)->item); i++)
    {
      /* Valeur */
      if (translation)
	{
	  for (j=0; j<g_list_length (mod_tree->field); j++)
	    if (TD_FIELD (g_list_nth_data (mod_tree->field, j))->dico)
	      data = g_list_append (data, td_field_dico_2intl (TD_FIELD_DICO (TD_FIELD (g_list_nth_data (mod_tree->field, j))->dico), g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), j)));
	    else
	      data = g_list_append (data, g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), j));
	  data = g_list_append (data, g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), g_list_length (mod_tree->field)));
	  data = g_list_append (data, g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), g_list_length (mod_tree->field)+1));
	  data = g_list_append (data, g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), g_list_length (mod_tree->field)+2));
	  data = g_list_append (data, g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), g_list_length (mod_tree->field)+3));
	}
      else
	data = g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i);
      node_id = g_list_append (node_id, g_list_nth_data (data, g_list_length (mod_tree->field)));

      /* Node */
      if ((i == 0) || (atoi (g_list_nth_data (data, g_list_length (mod_tree->field)+1)) == 0))
	node_list = g_list_append (node_list, td_mod_tree_add_node (mod_tree, NULL, NULL, data, FALSE));
      else
	{
	  j = 1;
	  while (atoi (g_list_nth_data (node_id, i-j)) != atoi (g_list_nth_data (data, g_list_length (mod_tree->field)+1)))
	    /* while (atoi (g_list_nth_data (node_id, i-j)) != atoi (g_list_nth_data (node_id, i))+1) */
	    j++;
	  node_list = g_list_append (node_list, td_mod_tree_add_node (mod_tree, g_list_nth_data (node_list, i-j), NULL, data, FALSE));
	}
      data = NULL;
    }
  td_mod_tree_unmodified (mod_tree);
  g_list_free (node_list);
  g_list_free (data);
  return TRUE;
}


GtkObject *td_mod_tree_save (TdModTree *mod_tree, gboolean translation)
{
  GtkObject *ret;
  GList *data = NULL;
  GList *data2 = NULL;
  GtkCTreeNode *node;
  int i, j;
  gchar *txt_tmp;

  /* Table */
  ret = td_db_datatable_new ();
  TD_DB_DATATABLE (ret)->table = TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, mod_tree->idparent-3))->table;

  /* hopla_id */
  i=0;
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), 0);
  while (node)
    {
      i++;
      gtk_ctree_node_get_text (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), node, g_list_length (mod_tree->field), &txt_tmp);
      if ((!strcmp (txt_tmp, "(bud)")) || (atoi (txt_tmp) < 0))
	gtk_ctree_node_set_text (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), node, g_list_length (mod_tree->field), g_strdup_printf ("-%d", i));
      node = gtdk_ctree_next (node);
    }

  /* hopla_parent, hopla_sibling et hopla_obso */
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), 0);
  while (node)
    {
      if (GTK_CTREE_ROW (node)->parent)
	gtk_ctree_node_get_text (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), GTK_CTREE_ROW (node)->parent, g_list_length (mod_tree->field), &txt_tmp);
      else
	txt_tmp = "0";
      gtk_ctree_node_set_text (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), node, g_list_length (mod_tree->field)+1, txt_tmp);
      if (GTK_CTREE_ROW (node)->sibling)
	gtk_ctree_node_get_text (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), GTK_CTREE_ROW (node)->sibling, g_list_length (mod_tree->field), &txt_tmp);
      else
	txt_tmp = "0";
      gtk_ctree_node_set_text (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), node, g_list_length (mod_tree->field)+2, txt_tmp);
      gtk_ctree_node_set_text (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), node, g_list_length (mod_tree->field)+3, "f");
      node = gtdk_ctree_next (node);
    }

  /* Valeurs */
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), 0);
  while (node)
    {
      if (translation)
	{
	  data2 = td_mod_tree_read_node (mod_tree, node, TRUE);
	  for (i=0; i<g_list_length (mod_tree->field); i++)
	    {
	      if (TD_FIELD (g_list_nth_data (mod_tree->field, i))->dico)
		data = g_list_append (data, td_field_dico_intl2 (TD_FIELD_DICO (TD_FIELD (g_list_nth_data (mod_tree->field, i))->dico), g_list_nth_data (data2, i)));
	      else
		data = g_list_append (data, g_list_nth_data (data2, i));
	    }
	  data = g_list_append (data, g_list_nth_data (data2, g_list_length (mod_tree->field)));
	  data = g_list_append (data, g_list_nth_data (data2, g_list_length (mod_tree->field)+1));
	  data = g_list_append (data, g_list_nth_data (data2, g_list_length (mod_tree->field)+2));
	  data = g_list_append (data, g_list_nth_data (data2, g_list_length (mod_tree->field)+3));
	}
      else
	data = td_mod_tree_read_node (mod_tree, node, TRUE);
      td_db_datatable_add_item (TD_DB_DATATABLE (ret), data);
      data = NULL;
      node = gtdk_ctree_next (node);
    }
  td_mod_tree_unmodified (mod_tree);
  g_list_free (data2);
  g_list_free (data);
  return ret;
}

void td_mod_tree_modified (TdModTree *mod_tree)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));

  /* Module de donnes */
  if (mod_tree->idparent>2)
    {
      gtk_window_set_title (GTK_WINDOW (mod_tree->widget->parent->parent->parent->parent), g_strdup_printf ("ToutDoux : %s : *%s", TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP(APP)->base)->mod, mod_tree->idparent-3))->name, TD_DB_CONNECT (TD_APP(APP)->connect)->name));
      TD_APP(APP)->modified = TRUE;
    }

  /* Cogitation */
  if (mod_tree->idparent==1)
    {
      gtk_window_set_title (GTK_WINDOW (mod_tree->widget->parent->parent->parent->parent), g_strdup_printf ("ToutDoux : Cogitation : *%s", TD_DB_CONNECT (TD_APP(APP)->connect)->name));
      TD_APP(APP)->modified = TRUE;
    }
}

void td_mod_tree_unmodified (TdModTree *mod_tree)
{
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));

  /* Module de donnes */
  if (mod_tree->idparent>2)
    {
      gtk_window_set_title (GTK_WINDOW (mod_tree->widget->parent->parent->parent->parent), g_strdup_printf ("ToutDoux : %s : %s", TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP(APP)->base)->mod, mod_tree->idparent-3))->name, TD_DB_CONNECT (TD_APP(APP)->connect)->name));
      TD_APP(APP)->modified = TRUE;
    }

  /* Cogitation */
  if (mod_tree->idparent==1)
    {
      gtk_window_set_title (GTK_WINDOW (mod_tree->widget->parent->parent->parent->parent), g_strdup_printf ("ToutDoux : Cogitation : %s", TD_DB_CONNECT (TD_APP(APP)->connect)->name));
      TD_APP(APP)->modified = TRUE;
    }
}


/*****************************************************************************/
/* Fichier support */
/*****************************************************************************/
void td_mod_tree_load_flower (TdModTree *mod_tree, GtkObject *flower)
{
  GList *data = NULL;
  GList *node_list = NULL;
  GtkCTreeNode *node = NULL;
  GtkCTreeNode *node1 = NULL;
  GtkCTreeNode *node2;
  int i, j;
  g_return_if_fail (mod_tree != NULL);
  g_return_if_fail (TD_IS_MOD_TREE (mod_tree));
  
  /* Go ! */
  td_mod_tree_clear (mod_tree);
  if (!TD_FLOWER (flower)->mode_level)
    for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
      {
	if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 0)
	  node = td_mod_tree_add_node (mod_tree, NULL, NULL, g_list_nth_data (TD_FLOWER (flower)->items_value, i), TRUE);
	if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 1)
	  node1 = td_mod_tree_add_node (mod_tree, node, NULL, g_list_nth_data (TD_FLOWER (flower)->items_value, i), TRUE);
	if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 2)
	  node2 = td_mod_tree_add_node (mod_tree, node1, NULL, g_list_nth_data (TD_FLOWER (flower)->items_value, i), TRUE);
      }
  else
    {
      for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
	{
	  if (!i)
	    {
	      node_list = g_list_append (node_list, td_mod_tree_add_node (mod_tree, NULL, NULL, g_list_nth_data (TD_FLOWER (flower)->items_value, 0), TRUE));
	      continue;
	    }
	  j = 1;
	  while (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i-j)) != GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i))-1)
	    j++;
	  node_list = g_list_append (node_list, td_mod_tree_add_node (mod_tree, g_list_nth_data (node_list, i-j), NULL, g_list_nth_data (TD_FLOWER (flower)->items_value, i), TRUE));
	}
    }
  g_list_free (data);
  g_list_free (node_list);
}

gboolean td_mod_tree_save_flower (TdModTree *mod_tree, GtkObject *flower, gchar *file)
{
  GList *data = NULL;
  FILE *fp;
  xmlDocPtr doc;
  xmlNsPtr ns;
  xmlNodePtr tree;
  xmlNodePtr item1 = NULL;
  xmlNodePtr item2 = NULL;
  xmlNodePtr item;
  GtkCTreeNode *node;
  int i, j;

  /* Prliminaire */
  fp = fopen (file, "w");
  if (!fp)
    {
      td_palette_message (NULL, _("Opening file"), "failed");
      return FALSE;
    }
  fclose (fp);
  doc = xmlNewDoc ("1.0");
  ns = xmlNewGlobalNs (doc, TD_FLOWER (flower)->space, g_strdup_printf("ToutDoux-%s", TD_FLOWER (flower)->root));
  doc->root = xmlNewDocNode (doc, ns, TD_FLOWER (flower)->root, NULL);
  tree = doc->root;
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), 0);

  /* Sauvegarde en mode level (arbre sans dtd fixe) */
  if (TD_FLOWER (flower)->mode_level)
    {
      node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), 0);
      while (node)
	{
	  data = td_mod_tree_read_node (mod_tree, node, FALSE);
	  item = xmlNewChild (tree, ns, TD_FLOWER (flower)->branch, NULL);
	  for (i=0; i<g_list_length (mod_tree->field); i++)
	    xmlSetProp (item, g_strdup_printf("%s", (gchar*) TD_FIELD (g_list_nth_data (mod_tree->field, i))->name), g_strdup_printf("%s", (gchar*) g_list_nth_data (data, i)));
	  xmlSetProp (item, "level", g_strdup_printf("%d", GTK_CTREE_ROW (node)->level));
	  data = NULL;
	  node = gtdk_ctree_next (node);
	}
    }

  /* Sauvegarde avec dtd fixe de 3 niveaux */
  else
    {
      node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), 0);
      while (node)
	{
	  data = td_mod_tree_read_node (mod_tree, node, FALSE);
	  if (GTK_CTREE_ROW (node)->level == 1)
	    {
	      item1 = xmlNewChild (tree, ns, TD_FLOWER (flower)->branch, NULL);
	      for (i=0; i<g_list_length (data); i++)
		for (j=0; j<g_list_length (TD_FLOWER (flower)->branch_attribut); j++)
		  if (!strcmp (g_list_nth_data (TD_FLOWER (flower)->branch_attribut, j), 
			       TD_FIELD (g_list_nth_data (mod_tree->field, i))->name))
		    xmlSetProp (item1, g_strdup_printf("%s", (gchar*) TD_FIELD (g_list_nth_data (mod_tree->field, i))->name), g_strdup_printf("%s", (gchar*) g_list_nth_data (data, i)));
	    }
	  if (GTK_CTREE_ROW (node)->level == 2)
	    {
	      item2 = xmlNewChild (item1, ns, TD_FLOWER (flower)->petal, NULL);
	      for (i=0; i<g_list_length (data); i++)
		for (j=0; j<g_list_length (TD_FLOWER (flower)->petal_attribut); j++)
		  if (!strcmp (g_list_nth_data (TD_FLOWER (flower)->petal_attribut, j), 
			       TD_FIELD (g_list_nth_data (mod_tree->field, i))->name))
		    xmlSetProp (item2, g_strdup_printf("%s", (gchar*) TD_FIELD (g_list_nth_data (mod_tree->field, i))->name), g_strdup_printf("%s", (gchar*) g_list_nth_data (data, i)));
	    }
	  if (GTK_CTREE_ROW (node)->level == 3)
	    {
	      item = xmlNewChild (item2, ns, TD_FLOWER (flower)->foliole, NULL);
	      for (i=0; i<g_list_length (data); i++)
		for (j=0; j<g_list_length (TD_FLOWER (flower)->foliole_attribut); j++)
		  if (!strcmp (g_list_nth_data (TD_FLOWER (flower)->foliole_attribut, j), 
			       TD_FIELD (g_list_nth_data (mod_tree->field, i))->name))
		    xmlSetProp (item, g_strdup_printf("%s", (gchar*) TD_FIELD (g_list_nth_data (mod_tree->field, i))->name), g_strdup_printf("%s", (gchar*) g_list_nth_data (data, i)));
	    }
	  data = NULL;
	  node = gtdk_ctree_next (node);
	}
    }

  /* Fin */
  if (xmlSaveFile (file, doc) < 0)
    {
      td_palette_message (NULL, _("Writting file"), "failed");
      xmlFreeDoc (doc);
      return FALSE;
    }
  xmlFreeDoc (doc);
  g_list_free (data);
  return TRUE;
}


/*****************************************************************************/
/* Old version */
/*****************************************************************************/
void td_mod_tree_dnd_get_old (GtkWidget *widget, GdkDragContext *context, GtkSelectionData *selection_data, guint info, guint time, int row)
{
  GList *data = NULL;
  gchar *value_tmp;
  guint8 spacing_tmp;
  GdkPixmap *pixmap_tmp;
  GdkBitmap *mask_tmp;
  GtkCTreeNode *node;
  GtkCTreeNode *node_start;
  GtkCTreeNode *node_parent;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  guint8 spacing;
  int i, j, length;
  gchar *txt_tmp;
  gchar *txt[6000];

  /* Prise des infos */
  node_start = gtk_ctree_node_nth (GTK_CTREE (widget), row);
  node = node_start;
  while (node)
    {

      /* Valeurs */
      gtk_ctree_node_get_pixtext (GTK_CTREE (widget), node, 0, &value_tmp, &spacing_tmp, &pixmap_tmp, &mask_tmp);
      data = g_list_append (data, value_tmp);
      for (i=1; i<(GTK_CLIST (widget)->columns); i++)
	{
	  gtk_ctree_node_get_text (GTK_CTREE (widget), node, i, &value_tmp);
	  data = g_list_append (data, value_tmp);
	}
      data = g_list_append (data, g_strdup_printf ("%d", GTK_CTREE_ROW (node)->level));
      data = g_list_append (data, "\\"); 

      /* Selection du suivant : enfant, fratrie, fratrie du parent, ... */
      if (GTK_CTREE_ROW (node)->children)
	{
	  node = GTK_CTREE_ROW (node)->children;
	  continue;
	}
      if (node == node_start)
	{
	  node = NULL;
	  continue;
	}
      if (GTK_CTREE_ROW (node)->sibling)
	{
	  node = GTK_CTREE_ROW (node)->sibling;
	  continue;
	}
      do
	{
	  node_parent = GTK_CTREE_ROW (node)->parent;
	  if (node_parent == node_start)
	    node = NULL;
	  else
	    {
	      if (!GTK_CTREE_ROW (node_parent)->sibling)
		node = node_parent;
	      else
		node = GTK_CTREE_ROW (node_parent)->sibling;
	    }
	}
      while ((node == node_parent) && (node));
    }

  /* Vrif de la longueur des donnes */
  if (g_list_length (data)>60000)
    td_palette_message (NULL, g_strdup_printf (_("Dnd operation : number of data >60000 : %d"), g_list_length (data)), "failed");

  /* Communication */
  length = 0;
  for (i=0; i<g_list_length (data); i++)
    {
      txt[i] = g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, i));
      if (!strlen (txt[i]))
	txt[i] = "(null)";
      length = length + strlen (txt[i]);
    }
  txt[i] = NULL;
  gtk_selection_data_set (selection_data, GDK_SELECTION_TYPE_STRING, sizeof (txt), (guchar*) txt, length*2);
  g_list_free (data);
}

gboolean td_mod_tree_dnd_received_old (GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *selection_data, guint info, guint time, TdModTree *mod_tree)
{
  GList *data_tmp = NULL;
  GList *data = NULL;
  GList *data_level = NULL;
  GList *node_list = NULL;
  gchar **vals = (gchar **)selection_data->data;
  gchar **vals2;
  int drag_position = 0;
  GtkCTreeNode *node;
  GtkCTreeNode *node_parent = NULL;
  GtkCTreeNode *node_next = NULL;
  int row, column, i, j, k;
  int m = 0;
  gboolean flag_node_empty;

  /* Correction sur le y (pomp de gtkctree.c) */
  y -= (GTK_CONTAINER (widget)->border_width + 
	widget->style->klass->ythickness + GTK_CLIST (widget)->column_title_area.height);

  /* Capture de la ligne */
  drag_position = td_mod_tree_dnd_drag_position (widget, x, y, mod_tree->widget);
  if (!drag_position)
    node = NULL;
  else
    {
      gtk_clist_get_selection_info (GTK_CLIST (widget), x, y, &row, &column);
      node = gtk_ctree_node_nth (GTK_CTREE (widget), row);
    }

  /* Dnd sur la mme node */
  if (mod_tree->selected == node)
    if (context->actions != GDK_ACTION_COPY)
      return TRUE;

  /* Valeurs */
  k = -1;
  i = -1;
  j = -1;
  flag_node_empty = FALSE;
  for (vals2 = vals; *vals2; vals2++)
    if (**vals2)
      {
	i++;
	if (strcmp (*vals2, "\\"))
	  {
	    j++;
	    if (!strcmp (*vals2, "(null)"))
	      {
		data_tmp = g_list_append (data_tmp, "");
		flag_node_empty = TRUE;
	      }
	    else
	      data_tmp = g_list_append (data_tmp, g_strdup_printf ("%s", *vals2));
	    continue;
	  }
	else
	  {

	    /* Donnes administrateur */
	    data = NULL;
	    if (context->actions == GDK_ACTION_COPY)
	      {
		for (j=0; j<(g_list_length (data_tmp))-5; j++)
		  data = g_list_append (data, g_strdup_printf ("%s", (gchar*) g_list_nth_data (data_tmp, j)));
		data = g_list_append (data, "(bud)");
		data = g_list_append (data, "(bud)");
		data = g_list_append (data, "(bud)");
		data = g_list_append (data, "(bud)");
	      }
	    else
	      for (j=0; j<(g_list_length (data_tmp))-1; j++)
		data = g_list_append (data, g_strdup_printf ("%s", (gchar*) g_list_nth_data (data_tmp, j)));
	    data_level = g_list_append (data_level, g_strdup_printf ("%s", (gchar*) g_list_nth_data (data_tmp, (g_list_length (data_tmp)-1))));
	    k++;
	    j = -1;
	    data_tmp = NULL;

 	    /* Avant */
	    if (drag_position == 1)
	      {
		if (GTK_CTREE_ROW (node)->parent)
		  node_parent = GTK_CTREE_ROW (node)->parent;
		else
		  node_parent = NULL;
		node_next = node;
	      }
	    else
	      {

		/* Dedans */
		if (drag_position == 2)
		  {
		    node_parent = node;
		    node_next = NULL;
		  }
		else
		  {

		    /* Aprs */
		    if (node)
		      {
			if (GTK_CTREE_ROW (node)->parent)
			  node_parent = GTK_CTREE_ROW (node)->parent;
			else
			  node_parent = NULL;
			if (GTK_CTREE_ROW (node)->sibling)
			  node_next = GTK_CTREE_ROW (node)->sibling;
			else
			  node_next = NULL;
		      }
		    else
		      {
			node_parent = NULL;
			node_next = NULL;
		      }
		  }
	      }

	    /* Premire node */
	    if (!k)
	      {
		node_list = g_list_append (node_list, td_mod_tree_add_node (mod_tree, node_parent, node_next, data, FALSE));
		/* if (drag_position == 2) */
		/* gtk_ctree_expand (GTK_CTREE (widget), mod_tree->selected); */
	      }

	    /* Nodes suivantes */
	    else
	      {
		m = 1;
		while (atoi (g_list_nth_data (data_level, k-m)) != atoi (g_list_nth_data (data_level, k))-1)
		  m++;
		node_list = g_list_append (node_list, td_mod_tree_add_node (mod_tree, g_list_nth_data (node_list, k-m), NULL, data, FALSE));
	      }
	  }
      }

  /* Suppression des nodes pour le context de dplacement */
  if (context->actions != GDK_ACTION_COPY)
    gtk_ctree_remove_node (GTK_CTREE(widget), mod_tree->selected);
  g_free (*vals2);
  if (!flag_node_empty) /* FIXME: strange */
    g_free (*vals);
  g_list_free (data_tmp);
  g_list_free (data);
  g_list_free (data_level);
  g_list_free (node_list);
  return TRUE;
}
